#ifndef __UtilVirtualTable_h
#define __UtilVirtualTable_h

#include "HString.h"	// For HString.

///////////////////////////////////////////////////////////////////////////////////////////

#define FD_TABLE_IDS_MAX	5

class FCTableIds
{
public:
	FCTableIds ();
	FCTableIds (const DWORD* pBegin, const DWORD* pEnd);
	FCTableIds (DWORD dwSize, DWORD dwId);
	FCTableIds (DWORD dwTableId0,
				DWORD dwTableId1 = DWORD(-1),
				DWORD dwTableId2 = DWORD(-1),
				DWORD dwTableId3 = DWORD(-1),
				DWORD dwTableId4 = DWORD(-1));
	void	Set (const DWORD* pBegin, const DWORD* pEnd);
	void	Set (const DWORD id[], DWORD dwSize);
	void	Set (	DWORD dwTableId0 = DWORD(-1),
					DWORD dwTableId1 = DWORD(-1),
					DWORD dwTableId2 = DWORD(-1),
					DWORD dwTableId3 = DWORD(-1),
					DWORD dwTableId4 = DWORD(-1));
//----- 05.12.20 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
	DWORD	GetSize () const;
	const DWORD*	Get () const;
//	void	push_back (DWORD dwId);
//	DWORD&	back ();
	void	Clear ();
//	DWORD&	operator [] (DWORD dwIndex);
//	void	resize (DWORD dwSize);
	const DWORD&	operator [] (DWORD dwIndex) const;
	const DWORD*	End () const;
//----- 05.12.20 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//----- 05.12.18 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	FCTableIds&	PushBack (DWORD dwId);
	FCTableIds&	PopBack ();
	FCTableIds&	SetLast (DWORD dwId);
	DWORD		GetLast () const;
	void		InStream (const BYTE*& pTransaction);
	void		OutStream (BYTEVector& vTransaction) const;
//----- 05.12.18 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

friend bool operator < (const FCTableIds& tableIds1, const FCTableIds& tableIds2);
friend bool operator != (const FCTableIds& tableIds1, const FCTableIds& tableIds2);
protected:
	DWORD	m_dwIdsSize;
	DWORD	m_dwIds[FD_TABLE_IDS_MAX];
}; // class FCTableIds.

extern bool operator < (const FCTableIds& tableIds1, const FCTableIds& tableIds2);
extern bool operator != (const FCTableIds& tableIds1, const FCTableIds& tableIds2);
extern bool operator == (const FCTableIds& tableIds1, const FCTableIds& tableIds2);
extern BYTEVector& operator << (BYTEVector& vStream, const FCTableIds& data);
extern BYTEVector& operator << (BYTEVector& vStream, FCTableIds& data);
extern void FFReadData (FCTableIds& data, const BYTE*& pStream);

///////////////////////////////////////////////////////////////////////////////////////////

struct FCTableName
{
	FCTableName ();
	FCTableName (const HString& hstrTopDirPath, const DWORD aTableIds[], DWORD dwTableIds);
	FCTableName (const HString& hstrTopDirPath, const FCTableIds& vTableIds);
	FCTableName (	const HString& hstrTopDirPath,
					DWORD dwTableId0 = DWORD(-1),
					DWORD dwTableId1 = DWORD(-1),
					DWORD dwTableId2 = DWORD(-1),
					DWORD dwTableId3 = DWORD(-1),
					DWORD dwTableId4 = DWORD(-1));
	FCTableName (const FCTableName& tableName);
	FCTableName (const DsTableName& dsTableName);
	~FCTableName ();
	void	operator = (const FCTableName& tableName);
	void	operator = (const DsTableName& dsTableName);
	operator DsTableName () const;
	void	Clear ();
	DWORD			GetSize () const;
	FCTableName&	PushBack (DWORD dwId);
	FCTableName&	PopBack ();
	FCTableName&	SetLast (DWORD dwId);
	DWORD			GetLast () const;
	const HString&		GetTopDirPath () const;
	const FCTableIds&	GetTableIds () const;
	WString			GetTitle () const;

	HString	m_hstrTopDirPath;
	FCTableIds	m_vTableIds;
}; // struct FCTableName.

extern bool operator < (const FCTableName& tableName1, const FCTableName& tableName2);
extern bool operator != (const FCTableName& tableName1, const FCTableName& tableName2);
extern bool operator == (const FCTableName& tableName1, const FCTableName& tableName2);
extern BYTEVector& operator << (BYTEVector& vStream, const FCTableName& tableName);
extern BYTEVector& operator << (BYTEVector& vStream, FCTableName& tableName);
extern void FFReadData (FCTableName& tableName, const BYTE*& pStream);

///////////////////////////////////////////////////////////////////////////////////////////

#define FD_INDEX_RECORD_SIZE	(sizeof(flint) + sizeof(DWORD) + sizeof(flint))

class FCTableIndex
{
public:
//----- 05.12.16 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	FCTableIndex (BYTE* pIndex, size_t szIndex);
//	void	Initialize (BYTE* pIndex, size_t szIndex);
//----- 05.12.16 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	FCTableIndex (BYTE* pIndexData, DWORD dwDataSize, DWORD dwBeginIndex);
//----- 05.12.16 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
// 05.12.16 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	DWORD	GetCount () const;
	DWORD	GetBeginIndex () const;
	DWORD	GetEndIndex () const;
	flint	GetIndexFilePosition (DWORD dwIndex) const;
	flint	GetPrimaryId (DWORD dwIndex) const;
	DWORD	GetAppendIdentifier (DWORD dwIndex) const;
	flint	GetDataFilePosition (DWORD dwIndex) const;
	DWORD	FindIndex (flint fliPrimaryId) const;
// 05.12.16 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	void	OffsetTableFilePosition (flint fliPositionOffset);
	DWORD	GetRecordSize (DWORD dwIndex) const;

protected:
//----- 05.12.16 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	size_t	m_szIndex;
//	BYTE*	m_pIndex;
//----- 05.12.16 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	BYTE*	m_pIndex;
	DWORD	m_dwBeginIndex;
	DWORD	m_dwEndIndex;
//----- 05.12.16 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
}; // class FCTableIndex.

///////////////////////////////////////////////////////////////////////////////////////////

//----- 05.12.20 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//extern void FFReadTableIds (const BYTE*& pTransaction, FCTableIds& vTableIds);
//extern void FFWriteTableIds (BYTEVector& vTransaction, const FCTableIds& vTableIds);
//----- 05.12.20 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//extern void FFGetControlIds (FCTableIds& vControlIds, const FCTableIds& vTableIds);
//extern void FFGetSubControlIds (FCTableIds& vSubControlIds, const FCTableIds& vGroupIds);
//extern void FFGetSubControlIds (FCTableName& subControlIds, const FCTableName& groupIds);

extern WString FFGetFilePath (const FCTableIds& vTableIds);
extern WString FFGetFilePath (const FCTableName& tableName);

#endif//__UtilVirtualTable_h
