// WndHistFindPanel.cpp : _xZkqqHx_iDeDiDjDiDhGiDiKiDiBiDjDiDgFiBfLiDfGiDiHiDjD_xHqqkZx_ _xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_
//

#include "stdafx.h"
#include "DynamicDraw.h"
#include "RegData.h"			// For SaveRegBinary.etc.
#include "PrhHistFindObject.h"	// For CFCPrhHistFindObject.
#include "PrhHistFindLink.h"	// For CFCPrhHistFindLink.
#include "PrhHistFindText.h"	// For CFCPrhHistFindText.
#include "PrhHistFindChar.h"	// For CFCPrhHistFindChar.
#include "PrhHistFindLabel.h"	// For CFCPrhHistFindLabel.
#include "PrhHistFindDocument.h"// For CFCPrhHistFindDocument.
#include "PrhHistFindDate.h"	// For CFCPrhHistFindDate.
#include "WndHistFindPanel.h"	// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

//----- _xZkqqHx_iDiMiDfHiDfIiDgHiDiKjFnLjBlGjGlM_xHqqkZx_ -----
static const wchar_t* REG_WND_HIST_FIND_PANEL = L"CFCWndHistFindPanel";

// _xZkqqHx_jDgPjIfOjGlMiCpAiPiJiKpKiJlLiBeC_xHqqkZx_
LPCTSTR CFCWndHistFindPanel::s_lpszClassName = NULL;

/////////////////////////////////////////////////////////////////////////////
// CFCWndHistFindPanel

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistFindPanel::CFCWndHistFindPanel
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CFCWndHistFindPanel::CFCWndHistFindPanel (DWORD dwId)
					:BASE_CLASS(dwId)
{
	m_lIndex = FIND_PAGE_NONE;
} // CFCWndHistFindPanel::CFCWndHistFindPanel.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistFindPanel::~CFCWndHistFindPanel
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CFCWndHistFindPanel::~CFCWndHistFindPanel ()
{
} // CFCWndHistFindPanel::~CFCWndHistFindPanel.

BEGIN_MESSAGE_MAP(CFCWndHistFindPanel, BASE_CLASS)
	//{{AFX_MSG_MAP(CFCWndHistFindPanel)
	ON_WM_CREATE()
	ON_WM_DESTROY()
	ON_WM_CLOSE()
	ON_WM_SETFOCUS()
	ON_CBN_SELCHANGE(IDC_HFD_CMB_SELECT_SEARCH_TYPE, OnSelchangeHfdCmbSelectSearchType)
	ON_WM_SHOWWINDOW()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()
// 05.11.13 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	ON_MESSAGE(WM_USER_PRE_DWSTROY_WINDOW, OnUserPreDestroyWindow)
// 05.11.13 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	ON_WM_PAINT()
//----- 05.10.31 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	ON_BN_CLICKED(IDC_HFD_CHK_SEARCH_OBJECT, OnHfdChkSearchObject)
//	ON_BN_CLICKED(IDC_HFD_CHK_SEARCH_LINK, OnHfdChkSearchLink)
//	ON_BN_CLICKED(IDC_HFD_CHK_SEARCH_LABEL, OnHfdChkSearchLabel)
//	ON_BN_CLICKED(IDC_HFD_CHK_SEARCH_HIDOCUMENT, OnHfdChkSearchHidocument)
//	ON_BN_CLICKED(IDC_HFD_CHK_SEARCH_DATE, OnHfdChkSearchDate)
//----- 05.10.31 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/////////////////////////////////////////////////////////////////////////////
// CFCWndHistFindPanel _xZkqqHx_iDiGiBfLiDfFiKnGjAjEiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistFindPanel::Create
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeFiDeCiDjDiDgIiDeFiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pParent	:_xZkqqHx_jAgFiDeFiDeCiDjDiDgIiDeFiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iNoMjAkMiCmJiOlIjEhDiClFiClNiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCWndHistFindPanel::Create (CWnd* pParent)
{
	// _xZkqqHx_iDeOiDiJiDfIiCpAjDgPjIfOiBeC_xHqqkZx_
	if (s_lpszClassName == NULL)
    	s_lpszClassName = ::AfxRegisterWndClass(CS_HREDRAW | CS_VREDRAW,
										FFGetApp()->LoadStandardCursor(IDC_ARROW));
	// _xZkqqHx_iDeFiDeCiDjDiDgIiDeFiCpAiNoMjAkMiBeC_xHqqkZx_
	CString strTitle;
	strTitle.LoadString(IDS_MSG_HIST_FIND_PANEL);
	if (!CreateEx(	0,
					s_lpszClassName,
					strTitle,
// 05.11.02 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//					WS_OVERLAPPED|WS_CAPTION|WS_SYSMENU|WS_VISIBLE,
					WS_OVERLAPPED|WS_CAPTION|WS_SYSMENU,
					0, 0, 1, 1,
					pParent->GetSafeHwnd(), NULL, NULL)) return FALSE;
	// _xZkqqHx_iDeBiDeDiDfCiDjDiCmMjAnNjCoIiBeC_xHqqkZx_
	SetIcon(FFGetApp()->LoadIcon(IDR_HIST_VIEW), FALSE);
	return TRUE;
} // CFCWndHistFindPanel::Create.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistFindPanel::GetActivePage
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeBiDeOiDgFiDeCiDhFiCmIiDhJiBfLiDfHiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeBiDeOiDgFiDeCiDhFiCmIiDhJiBfLiDfHiCmMiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.11.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long CFCWndHistFindPanel::GetActivePage ()
{
	return m_lIndex;
} // CFCWndHistFindPanel::GetActivePage.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistFindPanel::SetActivePage
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNjFfMiOkGjCiGiCmMiDhJiBfLiDfHiCpAjEpBiDeBiDeOiDgFiDeCiDhFiCmJiClFiBeBiOhHjCoIiClDiCoKiClNiDhJiBfLiDfHiCpA_xHqqkZx_
 *			_xZkqqHx_iDeBiDeOiDgFiDeCiDhFiCmJjFmPiNfIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lIndex	:_xZkqqHx_jAfGiClFiCkCiDhJiBfLiDfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.11.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCWndHistFindPanel::SetActivePage (long lIndex)
{
	if (m_lIndex == lIndex) return;
	if (GetActivePage() != FIND_PAGE_NONE)
	{
		GetPage(GetActivePage())->ShowWindow(SW_HIDE);

		// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCkJiCoHiDiBiDjDiDgPjFmPjAjEiCnGiDgGiBfLiDfOiCpAjDfNjBjHiBeC_xHqqkZx_
		GetPage(GetActivePage())->UpdateVariables();
		GetPage(GetActivePage())->OnKillActive();
	}
	m_lIndex = lIndex;
	if (GetActivePage() != FIND_PAGE_NONE)
	{
		GetPage(GetActivePage())->ShowWindow(SW_SHOW);
		GetPage(GetActivePage())->SetFocus();

		GetPage(GetActivePage())->OnSetActive();
		// _xZkqqHx_iDiBiDjDiDgPjFmPjAjEiCkJiCoHiDfCiDjDiDgHiDiNiBfLiDiLiCnGiDgGiBfLiDfOiCpAjDfNjBjHiBeC_xHqqkZx_
		GetPage(GetActivePage())->UpdateControls();
		// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjFfMiOkGiBeFjEpBjFfMiOkGiBeFjHeMiMpIjAkLiCpAjAnNjCoIiBeC_xHqqkZx_
		GetPage(GetActivePage())->UpdateActivate();

		//----- _xZkqqHx_iDeBiDeOiDgFiDeCiDhFiCmJiCmIiCmBiClNiDhJiBfLiDfHiCmMiBeBjBeJjBpAiDfCiDjDiDhLiDhLiDgCiDeOiDfIiCpAjAnNjCoI_xHqqkZx_ -----
		// _xZkqqHx_iMjPiNpFjBeJjBpAiCmMiDfCiDjDiDhLiDhLiDgCiDeOiDfIiBeC_xHqqkZx_
		CComboBox* pBox = (CComboBox*)GetPage(GetActivePage())->GetDlgItem(IDC_HFD_CMB_SELECT_SEARCH_TYPE);
		// _xZkqqHx_iMlLiNnNiCmMjAnNjCoIiBeC_xHqqkZx_
		pBox->SetCurSel(GetActivePage());
		// _xZkqqHx_iMjPiNpFjBeJjBpAiCmMiDfCiDjDiDhLiDhLiDgCiDeOiDfIiCmJiDhEiDeIiBfLiDeKiDfIiBeC_xHqqkZx_
		GetPage(GetActivePage())->GotoDlgCtrl(pBox);
	}
} // CFCWndHistFindPanel::SetActivePage.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistFindPanel::GetPage
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCmMiDhJiBfLiDfHiDeJiDhFiDfHiDeGiDeOiDgHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lIndex	:_xZkqqHx_iDhJiBfLiDfHiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhJiBfLiDfHiDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.11.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CFCPrhHistFindBase* CFCWndHistFindPanel::GetPage (long lIndex)
{
	return m_pPrhHistFindBase[lIndex];
} // CFCWndHistFindPanel::GetPage.

/////////////////////////////////////////////////////////////////////////////
// CFCWndHistFindPanel _xZkqqHx_iDiBiDgCiDfKiBfLiDfH_xHqqkZx_ _xZkqqHx_iDgOiDjDiDgIiDiJ_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistFindPanel::OnCreate
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeFiDeCiDjDiDgIiDeFiNoMjAkMiOjOiCmJiOmAiNhDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
int CFCWndHistFindPanel::OnCreate (LPCREATESTRUCT lpCreateStruct)
{
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	if (BASE_CLASS::OnCreate(lpCreateStruct) == -1)
		return -1;

	// _xZkqqHx_iKgFiDfGiBfLiDgHiCpAiNoMjAkMiBeC_xHqqkZx_
	m_pPrhHistFindBase[FIND_OBJECT_PAGE] = new CFCPrhHistFindObject();
	m_pPrhHistFindBase[FIND_OBJECT_PAGE]->Create(CFCPrhHistFindObject::IDD, this);
	m_pPrhHistFindBase[FIND_LINK_PAGE] = new CFCPrhHistFindLink();
	m_pPrhHistFindBase[FIND_LINK_PAGE]->Create(CFCPrhHistFindLink::IDD, this);
	m_pPrhHistFindBase[FIND_TEXT_PAGE] = new CFCPrhHistFindText();
	m_pPrhHistFindBase[FIND_TEXT_PAGE]->Create(CFCPrhHistFindText::IDD, this);
	m_pPrhHistFindBase[FIND_CHAR_PAGE] = new CFCPrhHistFindChar();
	m_pPrhHistFindBase[FIND_CHAR_PAGE]->Create(CFCPrhHistFindChar::IDD, this);
	m_pPrhHistFindBase[FIND_LABEL_PAGE] = new CFCPrhHistFindLabel();
	m_pPrhHistFindBase[FIND_LABEL_PAGE]->Create(CFCPrhHistFindLabel::IDD, this);
	m_pPrhHistFindBase[FIND_DOCUMENT_PAGE] = new CFCPrhHistFindDocument();
	m_pPrhHistFindBase[FIND_DOCUMENT_PAGE]->Create(CFCPrhHistFindDocument::IDD, this);
	m_pPrhHistFindBase[FIND_DATE_PAGE] = new CFCPrhHistFindDate();
	m_pPrhHistFindBase[FIND_DATE_PAGE]->Create(CFCPrhHistFindDate::IDD, this);

	long lWidth = 0;
	long lHeight = 0;
	for (long lC = 0; lC != FIND_PAGE_SIZE; lC++)
	{
		CRect rect;
		m_pPrhHistFindBase[lC]->GetClientRect(rect);
		if (lWidth < rect.Width())
			lWidth = rect.Width();
		if (lHeight < rect.Height())
			lHeight = rect.Height();
	}
	CRect rectClient;
	GetClientRect(rectClient);
	CRect rectWindow;
	GetWindowRect(rectWindow);
	rectWindow.right += (lWidth - rectClient.Width());
	rectWindow.bottom += (lHeight - rectClient.Height());
	// _xZkqqHx_iDeFiDeCiDjDiDgIiDeFiDfEiDeDiDfJiCpAjFmPiNfIiBeC_xHqqkZx_
	MoveWindow(rectWindow.left, rectWindow.top, rectWindow.Width(), rectWindow.Height(), TRUE);

	return 0;
} // CFCWndHistFindPanel::OnCreate.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistFindPanel::OnDestroy
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeFiDeCiDjDiDgIiDeFiNoNiPjMiOjOiCmJiOmAiNhDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.11.13 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCWndHistFindPanel::OnDestroy ()
{
	// CFrameWnd::DestroyWindow _xZkqqHx_iCkJiCoHjClMjAnKiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
	// CFCWndHistFindPanel::DestroyWindow_xZkqqHx_iBeB_xHqqkZx_CFrameWnd::OnDestroy _xZkqqHx_iCmN_xHqqkZx_
	// _xZkqqHx_iKnEiCmJjDpMiCoHiCmIiCkCiBeC_xHqqkZx_

	// Baseclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::OnDestroy();

	for (long lC = 0; lC != FIND_PAGE_SIZE; lC++)
	{
		m_pPrhHistFindBase[lC]->DestroyWindow();
		delete m_pPrhHistFindBase[lC];
		m_pPrhHistFindBase[lC] = NULL;
	}
} // CFCWndHistFindPanel::OnDestroy.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistFindPanel::OnClose
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeFiDeCiDjDiDgIiDeFiCpAjFmCiClGiCoJiCmGiCkLiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCWndHistFindPanel::OnClose ()
{
	// _xZkqqHx_iDeFiDeCiDjDiDgIiDeFiCpAiPeJjHlJiClHiCoJiCmGiNkCiCoJiBeC_xHqqkZx_
	// _xZkqqHx_iDeFiDeCiDjDiDgIiDeFiCpA_xHqqkZx_HIDE_xZkqqHx_iClHiCoJiBeC_xHqqkZx_
	//	BASE_CLASS::OnClose();
	SetWindowVisible(FALSE);
} // CFCWndHistFindPanel::OnClose.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistFindPanel::OnSetFocus
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDeFiDeCiDjDiDgIiDeFiCmJiDhEiDeIiBfLiDeKiDfIiCkKiInKiCmBiClNiCmGiCkLiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCWndHistFindPanel::OnSetFocus (CWnd* pOldWnd)
{
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::OnSetFocus(pOldWnd);

	if (GetActivePage() != FIND_PAGE_NONE)
		GetPage(GetActivePage())->SetFocus();
} // CFCWndHistFindPanel::OnSetFocus.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistFindPanel::OnSelchangeHfdCmbSelectSearchType
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMjPiNpFiDfOiDeDiDhGiDfCiDjDiDhLiDhLiDgCiDeOiDfIiCmMjBeJjBpAiCkKjFmPiNfIiClDiCoKiClNiCmGiCkLiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.10.31 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCWndHistFindPanel::OnSelchangeHfdCmbSelectSearchType ()
{
	CComboBox* pBox = (CComboBox*)GetPage(GetActivePage())->GetDlgItem(IDC_HFD_CMB_SELECT_SEARCH_TYPE);
	if (pBox != NULL)
	{
		SetActivePage(pBox->GetCurSel());
	}
} // CFCWndHistFindPanel::OnSelchangeHfdCmbSelectSearchType.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistFindPanel::OnShowWindow
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeFiDeCiDjDiDgIiDeFjFfMiOkGiOjOiBeFjEpBjFfMiOkGiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.11.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCWndHistFindPanel::OnShowWindow (BOOL bShow, UINT nStatus)
{
	// Baseclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::OnShowWindow(bShow, nStatus);

	if (!bShow)
	//----- _xZkqqHx_iDeFiDeCiDjDiDgIiDeFiCkKjEpBjFfMiOkGiCmJiCmIiCoJiPoKiNiH_xHqqkZx_ -----
	{
		//----- _xZkqqHx_iDiMiDfHiDfIiDgHiDiKiCmJiPpDiLlFiCpAjFnLjBlGiClHiCoJ_xHqqkZx_ -----
		long lActivePage = GetActivePage();
		// _xZkqqHx_iDeBiDhGiDiKiPeJjHlJiOjOiCmJiBeBiClBiClBiCmNiCfBiJpBiImIiPoDiOmAiNhDiClDiCoKiCoJiClNiCnPiBeB_xHqqkZx_
		// lActivePage != FIND_PAGE_NONE _xZkqqHx_iCpAiDgAiDeGiDgCiDeOiClHiCoJ_xHqqkZx_
		// _xZkqqHx_jFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
		if (lActivePage != FIND_PAGE_NONE)
		//----- _xZkqqHx_iDeBiDeOiDgFiDeCiDhFiCmIiDhJiBfLiDfHiCkKjHeMiMpIiCmIiPoKiNiH_xHqqkZx_ -----
		{
			g_pReg->SaveRegBinary(	REG_WND_HIST_FIND_PANEL,
									L"lActivePage",
									(BYTE*)&lActivePage,
									sizeof(lActivePage));
			// _xZkqqHx_iDeBiDeOiDgFiDeCiDhFiCmIiDhJiBfLiDfHiCmJjEpBjFfMiOkGiCpAjCmKjCgNiBeC_xHqqkZx_
			SetActivePage(FIND_PAGE_NONE);
		}
	} else
	//----- _xZkqqHx_iDeFiDeCiDjDiDgIiDeFiCkKjFfMiOkGiCmJiCmIiCoJiPoKiNiH_xHqqkZx_ -----
	{
		//----- _xZkqqHx_iDiMiDfHiDfIiDgHiDiKiCkJiCoHiPpDiLlFiCpAiOoGjDlOiClHiCoJ_xHqqkZx_ -----
		long lActivePage = FIND_OBJECT_PAGE;
		g_pReg->LoadRegBinary(	REG_WND_HIST_FIND_PANEL,
								L"lActivePage",
								(BYTE*)&lActivePage,
								sizeof(lActivePage));
		// _xZkqqHx_iDeBiDeOiDgFiDeCiDhFiCmIiDhJiBfLiDfHiCmJjFfMiOkGiCpAjCmKjCgNiBeC_xHqqkZx_
		SetActivePage(lActivePage);
	}
} // CFCWndHistFindPanel::OnShowWindow.

