// WndRichEdit.h : _xZkqqHx_iDhHiDgCiDfPiBfL_xHqqkZx_ _xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_
//
#ifndef __WndRichEdit_h
#define __WndRichEdit_h

#include <time.h>		// For clock_t.
#include "Env.h"		// For SFontID.
#include "UtilFont.h"	// For FCFontCharInfo.
#include "WndBase.h"	// For Baseclass.

//;----- <EXPORT TO SDK> -----;

#ifdef SUPER_CLASS
#undef SUPER_CLASS
#endif
#define SUPER_CLASS CFCWndBase

/////////////////////////////////////////////////////////////////////////////
// CFCWndRichEdit _xZkqqHx_iDeFiDeCiDjDiDgIiDeF_xHqqkZx_

//----- FCEditChar::m_wChar, FCStatChar::m_wChar_xZkqqHx_iLkEjCmK_xHqqkZx_ -----
#define FDRCH_RETURN				0x00
#define FDRCH_CONTINUE				0x01
//----- FCStatChar::m_wChar_xZkqqHx_jAoKjHhA_xHqqkZx_ -----
#define FDRCH_FONT_AND_OFFSET		0x02
#define FDRCH_PRESPACE				0x03
#define FDRCH_COLORREF				0x04
#define FDRCH_AFTERSPACE			0x05
#define FDRCH_LINES_AND_CROSSSTAT	0x06

// m_byCrossStat _xZkqqHx_iCmMjCgMiBeC_xHqqkZx_
#define FDWR_CROSS_INSIDE	0	// m_nAfterSpace_xZkqqHx_iCpAiKnMiCnPiCmEiBeBjFlGiOjKiCkKiDhEiDiMiBfLiDiAiCmMjDoAjBkEiCmJiCkAiCoJiBeC_xHqqkZx_
#define FDWR_CROSS_ONLINE	1	// _xZkqqHx_jFlGiOjKiCmNiDhEiDiMiBfLiDiAiCmMjDoAjBkEiClOiCkKiBeB_xHqqkZx_m_nAfterSpace_xZkqqHx_iCkKiDhEiDiMiBfLiDiAiCmJiPgEiCmIiCmBiCmEiCkCiCoJiBeC_xHqqkZx_
#define FDWR_CROSS_OUTSIDE	2	// _xZkqqHx_jFlGiOjKiCkKiDhEiDiMiBfLiDiAiCmMiKePiCmJiPgPiCmEiCkCiCoJiBeC_xHqqkZx_

//----- CFCWndRichEdit::m_byVertAlign_xZkqqHx_iBeB_xHqqkZx_FCRichText::m_dwVertAlign_xZkqqHx_iLkEjCmK_xHqqkZx_ -----
#define FDRC_AL_TOP			0x01
#define FDRC_AL_V_CENTER	0x02
#define FDRC_AL_BOTTOM		0x03

//----- FCEditLine::m_byLineType_xZkqqHx_iBeB_xHqqkZx_FCStatLine::m_byLineType_xZkqqHx_iLkEjCmK_xHqqkZx_ -----
#define FDRC_LT_HEAD		0x00
#define FDRC_LT_CONTINUE	0x01

class FCUndoArchive;
class FCAutoDC;
class FCSearchParser;
class FCRichEditBuffer;
struct FCTextLineInfo;
class FCStatLine;
class FCObjFigure;
class CFCWndRichEdit;

//;------ </EXPORT TO SDK> -----;

//----- 02.08.18 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ (Times New Roman _xZkqqHx_iCmM_xHqqkZx_ "ABC"_xZkqqHx_iCmM_xHqqkZx_B_xZkqqHx_iCpAjBeJjBpAiClFiCmEiBeBiDgFiDeMiDfIiDgH_xHqqkZx_"_xZkqqHx_iCkAiCkCiCkE_xHqqkZx_"_xZkqqHx_iCpAiBhFiDgFiDeMiDfIiDgHiCmGiClFiCmEjDfMiCoIjFhEiCkPiBhGiClHiCoJiCmGiCkEiCnMiCkNiCkCiCkJiCmIiCkCiBeC_xHqqkZx_)-----
inline wchar_t Fdrch2Wchar (wchar_t wChar)
	{
		switch (wChar)
		{
		case FDRCH_RETURN:
			return WCH_CR;
		case FDRCH_CONTINUE:
		case FDRCH_FONT_AND_OFFSET:
		case FDRCH_PRESPACE:
		case FDRCH_COLORREF:
		case FDRCH_AFTERSPACE:
		case FDRCH_LINES_AND_CROSSSTAT:
			return L'\0';
		default:
			return wChar;
		}
	}
//----- 02.08.18 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ (Times New Roman _xZkqqHx_iCmM_xHqqkZx_ "ABC"_xZkqqHx_iCmM_xHqqkZx_B_xZkqqHx_iCpAjBeJjBpAiClFiCmEiBeBiDgFiDeMiDfIiDgH_xHqqkZx_"_xZkqqHx_iCkAiCkCiCkE_xHqqkZx_"_xZkqqHx_iCpAiBhFiDgFiDeMiDfIiDgHiCmGiClFiCmEjDfMiCoIjFhEiCkPiBhGiClHiCoJiCmGiCkEiCnMiCkNiCkCiCkJiCmIiCkCiBeC_xHqqkZx_)-----

////////////////////////// _xZkqqHx_iDeHiDgGiDeCiDfOjHhAiCmMiDeOiDiJiDfI_xHqqkZx_ ////////////////////////////////

//----------<NOT EXPORT TO VIEWER>-----------

//;----- <EXPORT TO SDK> -----;
class FCShortRect
{
//;------ </EXPORT TO SDK> -----;
public:
	FCShortRect ();
	FCShortRect (short nL, short nT, short nR, short nB);
	BOOL IsRectEmpty () const;
	void SetRect (short nL, short nT, short nR, short nB);
	BOOL operator != (const FCShortRect& rect) const;
	BOOL operator == (const FCShortRect& rect) const;
	void operator = (const FCShortRect& rect);
	void operator |= (const FCShortRect& rect);
	void Empty ();
	void ExtendX (short n);
//;----- <EXPORT TO SDK> -----;
public:
	short	left;
	short	top;
	short	right;
	short	bottom;
}; // class FCShortRect.
//;------ </EXPORT TO SDK> -----;

inline FCShortRect operator & (const FCShortRect& rt1, const FCShortRect& rt2)
{
	FCShortRect rtR;
	if (!LinearOverlap(rtR.left, rtR.right, rt1.left, rt1.right, rt2.left, rt2.right))
		return FCShortRect(0,0,0,0);
	if (!LinearOverlap(rtR.top, rtR.bottom, rt1.top, rt1.bottom, rt2.top, rt2.bottom))
		return FCShortRect(0,0,0,0);
	return rtR;
} // FCShortRect operator &.

typedef vector<FCShortRect> FCShortRectVector;

//;----- <EXPORT TO SDK> -----;
class FCEditChar
{
//;------ </EXPORT TO SDK> -----;
public:
	FCEditChar ();
	FCEditChar (WORD wChar, SFontID foidFont, WORD wOffset, short nAfterSpace,
				COLORREF crColor, BYTE byUnderline, BYTE byStrikeOut,
				fmmetol mmfWidth, fmmetol mmfAbcA, fmmetol mmfAbcC, fmmetol mmfPreSpace,
				BYTE byCrossStat);
	void	Clear ();
	void	OutStream (BYTEVector& vStream) const;
	void	InStream (const BYTE*& pData);
	void	Overread (const FCFontCharInfo& fci);
	void	ReqOverwrite (FCFontCharInfo& fci) const;
	BOOL	operator == (const FCEditChar& ec) const;
	BOOL	operator != (const FCEditChar& ec) const;
	static size_t SizeOfStream ();
//;----- <EXPORT TO SDK> -----;
public:
	WORD		m_wChar;		// _xZkqqHx_jFlGiOjKiDfCiBfLiDgIiBeC_xHqqkZx_
	SFontID		m_foidFont;		// _xZkqqHx_jFlGiOjKiCmMiDhEiDeIiDjDiDgH_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
	WORD		m_wOffset;		// Baseline_xZkqqHx_iCkJiCoHiCmM_xHqqkZx_Offset_xZkqqHx_iBeC_xHqqkZx_0,MAXSHORT,MINSHORT_xZkqqHx_iCmM_xHqqkZx_3_xZkqqHx_jCgMiBeC_xHqqkZx_
	short		m_nAfterSpace;	// _xZkqqHx_jFlGiOjKiCmMiMoDiCoLiCmMiLpDjEjCiBeC_xHqqkZx_TWIPS_xZkqqHx_iBeCjFlGiOjKiKnEiKhFiCmMjFmPiNfIiCmJiCoGiCmBiCmEjAnNjCoIiClDiCoKiCoJiBeC_xHqqkZx_
	COLORREF	m_crColor;		// _xZkqqHx_jFlGiOjKiCmMjAeGiBeC_xHqqkZx_
	BYTE		m_byUnderline;	// _xZkqqHx_iJlKjApMiMgAiOkOiBeC_xHqqkZx_
	BYTE		m_byStrikeOut;	// _xZkqqHx_iOoGiPmBiClFjApMiMgAiOkOiBeC_xHqqkZx_
	fmmetol		m_mmfWidth;		// _xZkqqHx_jFlGiOjKiCmMjFjNiBeC_xHqqkZx_
	fmmetol		m_mmfAbcA;		// ABC_xZkqqHx_iNfMjBkCjBmMiCmM_xHqqkZx_abcA_xZkqqHx_iCmMjCgMiBeC_xHqqkZx_
	fmmetol		m_mmfAbcC;		// ABC_xZkqqHx_iNfMjBkCjBmMiCmM_xHqqkZx_abcC_xZkqqHx_iCmMjCgMiBeC_xHqqkZx_
	fmmetol		m_mmfPreSpace;	// _xZkqqHx_jFlGiOjKiCmMjBePiCmMjHfNjEjCiBeCiImKjChFjClCjAkOjHhAiBeC_xHqqkZx_
	BYTE		m_byCrossStat;	// _xZkqqHx_jFlGiOjKiCkKiDhEiDiMiBfLiDiAjDoAiCkJiBeI_xHqqkZx_

	FCShortRect	m_nrRect;		// _xZkqqHx_jFlGiOjKjFgAiJoGiLoJiMgAjHmMiIoGiBeC_xHqqkZx_
}; // class FCEditChar.

typedef vector<FCEditChar> FCEditCharVector;
//;------ </EXPORT TO SDK> -----;

//;----- <EXPORT TO SDK> -----;
class FCEditLine
{
//;------ </EXPORT TO SDK> -----;
public:
	FCEditLine ();
	void	Clear ();
	void	GetFormat (FCTextLineInfo& tli) const;
	void	SetFormat (const FCTextLineInfo& tli);
	void	operator = (const FCStatLine& slStat);
	void	CopyProperty (const FCEditLine& elEdit);
	mmetol	CalcTabPos (mmetol mmX) const;
	mmetol	CalcTabRPos (mmetol mmX) const;
	void	OutLinStream (BYTEVector& vQueue) const;
	void	InLinStream (const BYTE*& bypQueue);
	void	OutLinChrStream (BYTEVector& vQueue) const;
	void	InLinChrStream (const BYTE*& bypQueue);
//----- 05.07.01 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	BOOL	operator == (const FCEditLine& el) const;
	BOOL	operator != (const FCEditLine& el) const;
//----- 05.07.01 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

//;----- <EXPORT TO SDK> -----;
public:
	//----- _xZkqqHx_jAoGjDkKiNhDiBeBiMhAjBlBiNhDiCmFjDkPiClGjCgMiCpAiOjNiCmCiDiBiDjDiDgPjFmPjAjE_xHqqkZx_ -----
	mmetol			m_mmStartIndent;	// _xZkqqHx_jAoGjDkKiNhDiCmMiNlGiDeDiDjDiDgGiDjDiDgHiBeC_xHqqkZx_
	mmetol			m_mmRightIndent;	// _xZkqqHx_jAoGjDkKiBeFiMhAjBlBiNhDiCmMiJeFiDeDiDjDiDgGiDjDiDgHiBeC_xHqqkZx_
	mmetol			m_mmOffset;			// _xZkqqHx_iMhAjBlBiNhDiCmMiDeDiDjDiDgGiDjDiDgHiBgJjAoGjDkKiNhDiCmJjBmOiClHiCoJiDeJiDhEiDfKiDgCiDgHjCgMiBgKiBeC_xHqqkZx_
	mmetolVector	m_mmvTabs;			// _xZkqqHx_iNhDiCmMiDfOiDhFiPoOjFpBiBeC_xHqqkZx_
	BYTE			m_byAlignment;		// _xZkqqHx_iDeBiDiJiDeDiDjDiDiBiDjDiDgHiBgJiNlGjCiGiJjLiJeFiKpBiClJiBgKiBeC_xHqqkZx_

	//----- _xZkqqHx_jAoGjDkKiNhDiBeFiMhAjBlBiNhDiCpAiMiIjCoIiClHiCoJiDiBiDjDiDgPjFmPjAjE_xHqqkZx_ -----
	BYTE			m_byLineType;		// _xZkqqHx_iNhDiCmMiDfOiDeDiDhG_xHqqkZx_(_xZkqqHx_jAoGjDkK_xHqqkZx_/_xZkqqHx_iMhAjBlB_xHqqkZx_)_xZkqqHx_iBeC_xHqqkZx_

	//----- _xZkqqHx_iNhDiKnEiKhFiCpAiOhHjCoIiClHiCoJiDiBiDjDiDgPjFmPjAjE_xHqqkZx_ -----
	short			m_nTwipLineAfter;	// _xZkqqHx_iNhDiKnEiBgJiNhDiCmMiJlKiBgKiCmM_xHqqkZx_TWIPS_xZkqqHx_jAjEiBeC_xHqqkZx_

	//----- _xZkqqHx_iNhDiCmMjFlGiOjKiPoOjFpBiCpAiOpLiCnPiCoJiDiBiDjDiDgPjFmPjAjE_xHqqkZx_ -----
	FCEditCharVector m_vEditChar;

	//----- _xZkqqHx_iNhDiCmMiNmEiMhGiOfKiCmFjCgMiCkKiOfKiPgPiJmCjEfMiCmIiDiBiDjDiDgPjFmPjAjE_xHqqkZx_ -----
	mmetol			m_mmY;
	fmmetol			m_mmfTMHeight;
	fmmetol			m_mmfTMAscent;
	fmmetol			m_mmfTMExternalLeading;
}; // class FCEditLine.

typedef vector<FCEditLine> FCEditLineVector;
//;------ </EXPORT TO SDK> -----;

// Undo_xZkqqHx_jHhAiCmMiDfCiDhNiDjDiDgIiDfCiBfLiDgIiBeC_xHqqkZx_
enum FTRichEditCmd
{
//----- 06.02.19 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	FDECMD_NONE = 0,			// _xZkqqHx_iDfCiDhNiDjDiDgIiCmIiClFiBeC_xHqqkZx_
//	FDECMD_DELETE_LINES,		// _xZkqqHx_jFkBjAjEiNhDiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
//	FDECMD_REPLACE_CHARS,		// _xZkqqHx_iCfAiNhDjCiGiCmMjFkBjAjEjFlGiOjKiCpAjDpMiCoKjBnGiCkGiCoJiBeC_xHqqkZx_
//	FDECMD_INSERT_LINE,			// _xZkqqHx_iCfAiNhDiCpAjBhNjDpMiClHiCoJiBeC_xHqqkZx_
//	FDECMD_FORMAT_LINE,			// _xZkqqHx_iCfAiNhDiCmMiDhEiDeIiBfLiDhNiDgCiDgHiCpAjFmPiNfIiClHiCoJiBeC_xHqqkZx_
//	FDECMD_FORMAT_CHARS,		// _xZkqqHx_jFkBjAjEiNhDiCmJjDgOiCoJjFkBjAjEjFlGiOjKiCmMiDhEiDeIiBfLiDhNiDgCiDgHiCpAjFmPiNfIiClHiCoJiBeC_xHqqkZx_
//	FDECMD_MODIFY_MARGIN,		// _xZkqqHx_jHfNjEjCiCpAjFmPiNfIiClHiCoJiBeC_xHqqkZx_
//	FDECMD_MODIFY_VERT_ALIGN,	// _xZkqqHx_jAiCjClMjFpLiMpMiDeBiDiJiDeDiDjDiDiBiDjDiDgHiCpAjFmPiNfIiClHiCoJiBeC_xHqqkZx_
//
//	FDECMD_DELETE_THIN_LINE,	// _xZkqqHx_iLpDiNhDiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
//	FDECMD_INSERT_THIN_LINE,	// _xZkqqHx_iLpDiNhDiCpAjBhNjDpMiClHiCoJiBeC_xHqqkZx_
//----- 06.02.19 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	FDECMD_NONE = 0,			// _xZkqqHx_iDfCiDhNiDjDiDgIiCmIiClFiBeC_xHqqkZx_
	FDECMD_DELETE_THIN_LINE,	// _xZkqqHx_iLpDiNhDiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
	FDECMD_INSERT_THIN_LINE,	// _xZkqqHx_iLpDiNhDiCpAjBhNjDpMiClHiCoJiBeC_xHqqkZx_
	FDECMD_REPLACE_CHARS,		// _xZkqqHx_iCfAiNhDjCiGiCmMjFkBjAjEjFlGiOjKiCpAjDpMiCoKjBnGiCkGiCoJiBeC_xHqqkZx_
	FDECMD_FORMAT_LINE,			// _xZkqqHx_iCfAiNhDiCmMiDhEiDeIiBfLiDhNiDgCiDgHiCpAjFmPiNfIiClHiCoJiBeC_xHqqkZx_
	FDECMD_FORMAT_CHARS,		// _xZkqqHx_jFkBjAjEiNhDiCmJjDgOiCoJjFkBjAjEjFlGiOjKiCmMiDhEiDeIiBfLiDhNiDgCiDgHiCpAjFmPiNfIiClHiCoJiBeC_xHqqkZx_
	FDECMD_MODIFY_MARGIN,		// _xZkqqHx_jHfNjEjCiCpAjFmPiNfIiClHiCoJiBeC_xHqqkZx_
	FDECMD_MODIFY_VERT_ALIGN,	// _xZkqqHx_jAiCjClMjFpLiMpMiDeBiDiJiDeDiDjDiDiBiDjDiDgHiCpAjFmPiNfIiClHiCoJiBeC_xHqqkZx_
//----- 06.02.19 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
}; // enum FTRichEditCmd.

//----------</NOT EXPORT TO VIEWER>-----------

////////////////////////// _xZkqqHx_jFjEjFgJjHhAiCmMiDeOiDiJiDfI_xHqqkZx_ ////////////////////////////////

//;----- <EXPORT TO SDK> -----;

/*************************************************************************
 * _xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	FCStatChar
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	FCRichText_xZkqqHx_jCiGiCmMiCfAjFlGiOjKiCpAjFfMiClHiDeOiDiJiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.17 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
class FCStatChar
{
//;------ </EXPORT TO SDK> -----;
public:
	FCStatChar ();
	FCStatChar (WORD wChar, fmmetol mmfPreSpace);
	FCStatChar (WORD wChar, fmmetol mmfWidth, fmmetol mmfAbcA, fmmetol mmfAbcC);
	FCStatChar (WORD wChar, SFontID foid, WORD wOffset);
	FCStatChar (WORD wChar, COLORREF cref);
	FCStatChar (WORD wChar, short nAfterSpace);
	FCStatChar (WORD wChar, BYTE byUnderline, BYTE byStrikeOut, BYTE byCrossStat);

	BOOL operator == (const FCStatChar& sc) const;
	BOOL operator != (const FCStatChar& sc) const;
	void OutStream (FCUndoArchive& ar) const;
	void InStream (FCUndoArchive& ar);

//;----- <EXPORT TO SDK> -----;
public:
	WORD	m_wChar;	// _xZkqqHx_jFlGiOjKiDfCiBfLiDgI_xHqqkZx_.
	union
	{
		DWORD			m_dwForStream;	// _xZkqqHx_jDpMiPgPjHmNjHhAiBeC_xHqqkZx_
		fmmetol			m_mmfWidth;		// _xZkqqHx_jFlGiOjKiCmMjFjN_xHqqkZx_.
		struct {
			SFontID		m_foidFont;		// _xZkqqHx_jFlGiOjKiCmMiDhEiDeIiDjDiDgH_xHqqkZx_ID.
			WORD		m_wOffset;		// Baseline_xZkqqHx_iCkJiCoHiCmM_xHqqkZx_Offset_xZkqqHx_iBeC_xHqqkZx_0,MAXSHORT,MINSHORT_xZkqqHx_iCmM_xHqqkZx_3_xZkqqHx_jCgMiBeC_xHqqkZx_
		};
		fmmetol			m_mmfPreSpace;	// _xZkqqHx_jFlGiOjKiCmMjBePiCmMjHfNjEjC_xHqqkZx_.
		COLORREF		m_crColor;		// _xZkqqHx_jFlGiOjKiCmMjAeG_xHqqkZx_.
		short			m_nAfterSpace;	// _xZkqqHx_jFlGiOjKiCmMiMoDiCoLiCmMiLpDjEjCiBeC_xHqqkZx_TWIPS_xZkqqHx_iBeC_xHqqkZx_
		struct {
			BYTE		m_byUnderline;	// _xZkqqHx_iJlKjApMiBeC_xHqqkZx_
			BYTE		m_byStrikeOut;	// _xZkqqHx_iOoGiPmBiClFjApMiBeC_xHqqkZx_
			BYTE		m_byCrossStat;	// _xZkqqHx_jFlGiOjKiIoMiCoKiPpDjBnEiBeC_xHqqkZx_
			BYTE		m_byDummy;
		};
	};
	fmmetol	m_mmfAbcA;	// ABC_xZkqqHx_iNfMjBkCjBmMiCmM_xHqqkZx_abcA_xZkqqHx_iCmMjCgMiBeC_xHqqkZx_
	fmmetol	m_mmfAbcC;	// ABC_xZkqqHx_iNfMjBkCjBmMiCmM_xHqqkZx_abcC_xZkqqHx_iCmMjCgMiBeC_xHqqkZx_
}; // class FCStatChar.

typedef vector<FCStatChar> FCStatCharVector;

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	FCStatLine
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	FCRichText_xZkqqHx_jCiGiCmMiCfAiNhDiCpAjFfMiClHiDeOiDiJiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.17 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
class FCStatLine
{
//;------ </EXPORT TO SDK> -----;
public:
	FCStatLine ();
//----- 05.07.01 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	void	GetFormat (FCTextLineInfo& tli) const;
	void	SetFormat (const FCTextLineInfo& tli);
//----- 05.07.01 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	void	operator = (const FCEditLine& elEdit);
	void	operator = (const FCStatLine& sl);
	void	OutStream (FCUndoArchive& ar) const;
	void	InStream (FCUndoArchive& ar);
	BOOL	operator == (const FCStatLine& sl) const;
	BOOL	operator != (const FCStatLine& sl) const;

//;----- <EXPORT TO SDK> -----;
public:
	//----- _xZkqqHx_jAoGjDkKiNhDiBeBiMhAjBlBiNhDiCmFjDkPiClGjCgMiCpAiOjNiCmCiDiBiDjDiDgPjFmPjAjE_xHqqkZx_ -----
	mmetol			m_mmStartIndent;	// _xZkqqHx_jAoGjDkKiNhDiCmMiNlGiDeDiDjDiDgGiDjDiDgH_xHqqkZx_.
	mmetol			m_mmRightIndent;	// _xZkqqHx_jAoGjDkKiBeFiMhAjBlBiNhDiCmMiJeFiDeDiDjDiDgGiDjDiDgH_xHqqkZx_.
	mmetol			m_mmOffset;			// _xZkqqHx_iMhAjBlBiNhDiCmMiDeDiDjDiDgGiDjDiDgHiBgJjAoGjDkKiNhDiCmJ_xHqqkZx_
										// _xZkqqHx_jBmOiClHiCoJiDeJiDhEiDfKiDgCiDgHjCgMiBgK_xHqqkZx_.
	mmetolVector	m_mmvTabs;			// _xZkqqHx_iDfOiDhFiCmMiImKjChFiCmMjHpB_xHqqkZx_.
	BYTE			m_byAlignment;		// _xZkqqHx_iDeBiDiJiDeDiDjDiDiBiDjDiDgH_xHqqkZx_.
	//----- _xZkqqHx_jAoGjDkKiNhDiBeBiMhAjBlBiNhDiCmFiInJiCmIiCoJjCgMiCpAiOjNiCmCiDiBiDjDiDgPjFmPjAjE_xHqqkZx_ -----
	BYTE			m_byLineType;		// _xZkqqHx_iNhDiCmMiDfOiDeDiDhG_xHqqkZx_(_xZkqqHx_jAoGjDkK_xHqqkZx_/_xZkqqHx_iMhAjBlB_xHqqkZx_)
	//----- _xZkqqHx_iNhDiKnEiKhFiCpAiOhHjCoIiClHiCoJiDiBiDjDiDgPjFmPjAjE_xHqqkZx_ -----
	short			m_nTwipLineAfter;	// _xZkqqHx_iNhDiKnEiBgJiNhDiCmMiJlKiBgKiCmM_xHqqkZx_TWIPS_xZkqqHx_jAjEiBeC_xHqqkZx_
	//----- _xZkqqHx_iNhDiCmMjFlGiOjKiPoOjFpBiCpAiOpLiCnPiCoJiDiBiDjDiDgPjFmPjAjE_xHqqkZx_ -----
	FCStatCharVector	m_vStatChar;	// _xZkqqHx_jFlGiOjKjHpBiBeC_xHqqkZx_
	//----- _xZkqqHx_iNhDiCmMiNmEiMhGiOfKiCmFjCgMiCkKiOfKiPgPiJmCjEfMiCmIiDiBiDjDiDgPjFmPjAjE_xHqqkZx_ -----
	mmetol			m_mmY;				// _xZkqqHx_iNhDiCmMiPoDiCmMiNmAjFfH_xHqqkZx_.
	fmmetol			m_mmfTMHeight;		// _xZkqqHx_jFlGiOjKiCmMiNiCiClD_xHqqkZx_.
	fmmetol			m_mmfTMAscent;		// _xZkqqHx_iDhIiBfLiDfIiDiJiDeDiDjDiCkJiCoHiNhDiCmMiPoDiCnMiCmFiCmMiNiCiClD_xHqqkZx_.
	fmmetol			m_mmfTMExternalLeading;	// _xZkqqHx_jFlGiOjKiCmMiJlKiCmMiMiEiKnE_xHqqkZx_.
}; // class FCStatLine.

//;------ </EXPORT TO SDK> -----;

//----- 01.08.17 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//////////////////////////////////////////////////////////////////////////
// _xZkqqHx_iImIiJlKiCmN_xHqqkZx_ MolipSDK_xZkqqHx_iCnG_xHqqkZx_Export_xZkqqHx_jHhAiBeC_xHqqkZx_
#if 0
//;----- <EXPORT TO SDK> -----;
/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	class FCStatLineVector
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	FCRichText_xZkqqHx_iCmMiNhDiCpAjFfMiClHiDeOiDiJiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.17 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
class FCStatLineVector : public vector<FCStatLine>
{
}; // class FCStatLineVector.
//;------ </EXPORT TO SDK> -----;
#endif //0
//////////////////////////////////////////////////////////////////////////
//----- 01.08.17 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	class FCStatLineVector
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	FCRichText_xZkqqHx_iCmMiNhDiCpAjFfMiClHiDeOiDiJiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.17 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
class FCStatLineVector : public vector<FCStatLine>
{
protected:
typedef vector<FCStatLine> BASE_CLASS;

public:
	void	OutStream (FCUndoArchive& ar) const;
	void	InStream (FCUndoArchive& ar);
}; // class FCStatLineVector.

/********************************************
CHARFORMAT
{
    UINT     cbSize; 
    _WPAD    _wPad1; 
    DWORD    dwMask; 
    DWORD    dwEffects; 
    long     yHeight;	// TWIPS_xZkqqHx_jCfAiImKiCmFiCkAiCoJiClBiCmGiCmJjCiNiInD_xHqqkZx_.
    long     yOffset;	// TWIPS_xZkqqHx_jCfAiImKiCmFiCkAiCoJiClBiCmGiCmJjCiNiInD_xHqqkZx_.
    COLORREF crTextColor; 
    BYTE     bCharSet; 
    BYTE     bPitchAndFamily; 
    CHAR    szFaceName[LF_FACESIZE]; 
    _WPAD    _wPad2; 
} // CHARFORMAT.

LOGFONT
{
   long lfHeight;
   long lfWidth;
   long lfEscapement;
   long lfOrientation;
   long lfWeight;
   BYTE lfItalic;
   BYTE lfUnderline;
   BYTE lfStrikeOut;
   BYTE lfCharSet;
   BYTE lfOutPrecision;
   BYTE lfClipPrecision;
   BYTE lfQuality;
   BYTE lfPitchAndFamily;
   CHAR lfFaceName[LF_FACESIZE];
} LOGFONT;

typedef struct tagTEXTMETRIC { // tm  
    LONG tmHeight;			InternalLeading + Ascent + Descent.
    LONG tmAscent;			FONT_xZkqqHx_iCmMiPoDjFjE_xHqqkZx_
    LONG tmDescent;			FONT_xZkqqHx_iCmMiJlKjFjE_xHqqkZx_
    LONG tmInternalLeading;	FONT_xZkqqHx_iCmMiPoDjHfNjEjC_xHqqkZx_
    LONG tmExternalLeading;	FONT_xZkqqHx_iCmMiJlKjHfNjEjC_xHqqkZx_
    LONG tmAveCharWidth; 
    LONG tmMaxCharWidth; 
    LONG tmWeight; 
    LONG tmOverhang; 
    LONG tmDigitizedAspectX; 
    LONG tmDigitizedAspectY; 
    BCHAR tmFirstChar; 
    BCHAR tmLastChar; 
    BCHAR tmDefaultChar; 
    BCHAR tmBreakChar; 
    BYTE tmItalic; 
    BYTE tmUnderlined; 
    BYTE tmStruckOut; 
    BYTE tmPitchAndFamily; 
    BYTE tmCharSet; 
} TEXTMETRIC; 

typedef struct _paraformat {  
    UINT cbSize; 
    _WPAD _wPad1; 
    DWORD dwMask; 
    WORD  wNumbering; 
    WORD  wReserved; 
    LONG  dxStartIndent; 
    LONG  dxRightIndent; 
    LONG  dxOffset; 
    WORD  wAlignment; 
    SHORT cTabCount; 
    LONG  rgxTabs[MAX_TAB_STOPS]; 
} PARAFORMAT; 
********************************************/

//;----- <EXPORT TO SDK> -----;
typedef void (*FDRichSpecKeyCallback)(WORD wKey);
typedef void (*FDCharInfoCallback)(FCFontCharInfo* fciExtCode, FCFontCharInfo* fciStdCode, CFCWndRichEdit* pEditor, void* pData);
typedef void (*FDLineInfoCallback)(FCTextLineInfo* tli, CFCWndRichEdit* pEditor, void* pData);
//;------ </EXPORT TO SDK> -----;

class CFCWndRichEdit : public SUPER_CLASS
{
protected:
typedef SUPER_CLASS BASE_CLASS;

// _xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfGiDiHiDjD_xHqqkZx_
public:
	CFCWndRichEdit();

// _xZkqqHx_iDiGiBfLiDfFiKnGjAjEiBgJiDiBiDjDiDgPiBgK_xHqqkZx_
public:
	//----- _xZkqqHx_iPiJiKpKiJlLiKnGjIeB_xHqqkZx_ ------
	virtual BOOL	Create (DWORD dwExStyle, DWORD dwStyle, const RECT& rect,
							CWnd* pParentWnd, UINT nID,
							CCreateContext* pContext = NULL);
	virtual void	SetSpecKeyCallback (FDRichSpecKeyCallback fncCallback);
	virtual void	PenBrushInit (	PenStyleID psidPenStyle,
									fmmetol mmfPenWeight,
									SColorID scidPenBackSColor,
									SColorID scidBrushBackSColor);
	virtual void	SetMaskPolygon (DBLPoint* mmptpPoly, long lPoly, const DBLPoint& mmptLeftTop);
	virtual void	ClearMaskPolygon ();

// 06.03.25 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	virtual void	RotateBackgroundColor ();

	//----- _xZkqqHx_jBfDiJoGjGmKiDiCiBfLiDgIiKnGjIeB_xHqqkZx_ -----
	virtual BOOL	IsFullScreenEditMode () const;
	virtual void	SetFullScreenEditMode (BOOL bIsFullMode);
	virtual BOOL	IsTextOver () const;
	virtual BOOL	CalcEnoughSizeRatio (	double& dRatioHorz,
											double& dRatioVert,
											const FCObjFigure* pObj);

	virtual WORD	GetFixResize () const;
	virtual BOOL	GetIsShortenByText () const;
	virtual void	SetFixResize (WORD wFixResize);
	virtual void	SetIsShortenByText (BOOL bIsShortenByText);

	virtual void	SetMargin (mmetol mmMarginL, mmetol mmMarginT,
								mmetol mmMarginR, mmetol mmMarginB);
	virtual void	GetMargin (mmetol& mmMarginL, mmetol& mmMarginT,
								mmetol& mmMarginR, mmetol& mmMarginB) const;
	virtual void	SetVertAlignment (BYTE byAlign);
	virtual BYTE	GetVertAlignment () const;

	virtual void	ShowWindow (int nCmdShow);
	virtual void	MoveWindowMM (const DBLRect& mmrct);
	virtual void	GetWindowRectMM (DBLRect& mmrt) const;

	virtual void	SetText (const FCStatLineVector& vStatLine);
	virtual void	GetText (FCStatLineVector& vStatLine) const;
	virtual void	GetText (WString& str, BOOL bIs2CR = FALSE) const;

	virtual void	ClearText ();
	virtual void	ClearAll ();

	//----- _xZkqqHx_iDfCiDhNiDjDiDgIiKnGjAjE_xHqqkZx_ -----
	virtual void	ClearAllSession ();

	//----- _xZkqqHx_iDfCiDhNiDjDiDgIiDeMiDiFiBfLiKnGjIeB_xHqqkZx_ ------
	virtual void	GetCmdQueue (BYTEVector& byvQueue) const;
	virtual void	SetCmdQueue (long lQueueSz, const BYTE* bypQueue, long lQueuePos);
	virtual long	GetCmdQueueSize () const;

	//----- _xZkqqHx_jBkOjAkLiKnGjIeB_xHqqkZx_ ------
	virtual long	GetCurIndex () const;
	virtual void	SetCurIndex (long lIndex);

	virtual void	GetCurCharPos (long& lCurLine, long& lCurChar) const;
	virtual void	SetCurCharPos (long lCurLine, long lCurChar);

	virtual long	GetIndexSize () const;
	virtual const FCEditChar&	GetChar (long lIndex) const;
	virtual long	GetLineSize () const;
	virtual const FCEditLine&	GetLine (long lLine) const;

	virtual void	GetSelectNormal (long& lFrom, long& lTo) const;
	virtual void	GetSelect (long& lFrom, long& lTo) const;
	virtual void	SetSelect (long lFrom, long lTo);
	virtual void	DrawSelect (CDC* pDC = NULL);
	virtual void	DrawSelect (long lFrom0, long lTo0, long lFrom1, long lTo1, CDC* pDC = NULL);

	virtual void	CalcLineAll ();
	virtual void	CalcLineBelow (long lLineFrom);
	virtual void	CalcLineBelowSub (long lLineFrom);
	virtual void	CalcLineBelowTop (mmetol& mmTopOffset, mmetol& mmBtmOffset, long lLineFrom);
	virtual void	CalcLineBelowCenter ();
	virtual void	CalcLineBelowBottom ();

	//----- Redo/Undo_xZkqqHx_iKnGjAjE_xHqqkZx_ -----
	virtual BOOL	CanRedo () const;
	virtual BOOL	CanUndo () const;
	virtual void	Redo ();
	virtual void	Undo ();
	virtual void	RedoUntilBottom ();
	virtual void	UndoUntilTop ();

	virtual BOOL	CanSelectAll () const;
	virtual void	SelectAll ();
	virtual void	SelectExAll ();

	virtual BOOL	CanPaste () const;
	virtual void	OnPaste ();
	virtual BOOL	CanPasteSpec (DWORD dwFormat) const;
	virtual void	OnPasteSpec (DWORD dwFormat);

	virtual BOOL	CanCopy () const;
	virtual void	OnCopy ();

// 06.02.24 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	virtual void	OnChar (WORD wChar);
	virtual void	OnDelete ();
	virtual void	OnBackspace ();

	virtual void	GetCurCharInfo (FCFontCharInfo& fciExtCode,
									FCFontCharInfo& fciStdCode,
									BOOL bInit = TRUE) const;
	virtual void	SetCurCharInfo (const FCFontCharInfo& fciExtCode,
									const FCFontCharInfo& fciStdCode);

//----- 05.07.01 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	virtual void	GetCurLineInfo (FCTextLineInfo& tli,
									BOOL bInit = TRUE) const;
	virtual void	SetCurLineInfo (const FCTextLineInfo& tli);
//----- 05.07.01 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
//----- 05.07.01 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	virtual int		GetAlignment () const;
//	virtual void	SetAlignment (int iAlign);
//	virtual BOOL	GetLineAfter (short& nLineAfter) const;
//	virtual void	SetLineAfter (short nLineAfter);
//----- 05.07.01 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//----- 05.07.01 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	virtual void	InflateFontSize ();
	virtual void	DeflateFontSize ();
//----- 05.07.01 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	virtual BOOL	FindNext (FCSearchParser& sp);
	virtual BOOL	FindPrev (FCSearchParser& sp);
	virtual void	ReplaceAll (FCSearchParser& sp);
	virtual BOOL	ReplaceOne (long& lFrom, long& lTo, FCSearchParser& sp);

// 02.06.24 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ (_xZkqqHx_iKnIiNjBiMoKiBeBjCiGiNjBiMoKjDjJiCmM_xHqqkZx_UNICODE_xZkqqHx_iCmJjBmOiJjO_xHqqkZx_)
	virtual void	OnChars (const wchar_t* wcpText);
//----- 02.08.14 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ (Times New Roman _xZkqqHx_iCmM_xHqqkZx_ "ABC"_xZkqqHx_iCmM_xHqqkZx_B_xZkqqHx_iCpAjBeJjBpAiClFiCmEiBeBiDgFiDeMiDfIiDgH_xHqqkZx_"_xZkqqHx_iCkAiCkCiCkE_xHqqkZx_"_xZkqqHx_iCpAiBhFiDgFiDeMiDfIiDgHiCmGiClFiCmEjDfMiCoIjFhEiCkPiBhGiClHiCoJiCmGiCkEiCnMiCkNiCkCiCkJiCmIiCkCiBeC_xHqqkZx_)-----
	virtual void	OverwriteFormat (FCFontCharInfo& fciExtCodeFormat,
									 FCFontCharInfo& fciStdCodeFormat,
									 const FCEditChar& eChar) const;
//----- 02.08.14 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ (Times New Roman _xZkqqHx_iCmM_xHqqkZx_ "ABC"_xZkqqHx_iCmM_xHqqkZx_B_xZkqqHx_iCpAjBeJjBpAiClFiCmEiBeBiDgFiDeMiDfIiDgH_xHqqkZx_"_xZkqqHx_iCkAiCkCiCkE_xHqqkZx_"_xZkqqHx_iCpAiBhFiDgFiDeMiDfIiDgHiCmGiClFiCmEjDfMiCoIjFhEiCkPiBhGiClHiCoJiCmGiCkEiCnMiCkNiCkCiCkJiCmIiCkCiBeC_xHqqkZx_)-----
// 02.08.26 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ (NextChar_xZkqqHx_iCpAjHjIjHhAiClFiClNjFpLiCkKiCoGiCkC_xHqqkZx_)
	virtual const FCEditChar&	GetChar (long lLine, long lChar) const;

// _xZkqqHx_iDiGiBfLiDfFiKnGjAjEiBgJ_xHqqkZx_static_xZkqqHx_iBgK_xHqqkZx_
	//----- _xZkqqHx_iDfCiDhNiDjDiDgIiDeMiDiFiBfLiKnGjIeB_xHqqkZx_ ------
	static void	OptimizeCmdQueue (BYTEVector& byvQueue, BOOL bIsFlatText = FALSE, BOOL bIsFlatChar = FALSE);
//----- 06.02.20 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	static void	RedoCmdQueue (WString& wstrText, const BYTE* pQueue, size_t szQueueSize);
	static void	UndoCmdQueue (WString& wstrText, const BYTE* pQueue, size_t szQueueSize);
//----- 06.02.20 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

//----- 06.03.02 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	static BOOL	RedoCmdQueue (longRangeVector& vSelectRange, const BYTE* pQueue, size_t szQueueSize);
	static BOOL	UndoCmdQueue (longRangeVector& vSelectRange, const BYTE* pQueue, size_t szQueueSize);
//----- 06.03.02 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

// _xZkqqHx_iDiGiBfLiDfFiKnGjAjEiBgJiDiBiDjDiDgPiBgK_xHqqkZx_
protected:
//----- 05.07.01 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	virtual void	SetCurCharInfo (FDCharInfoCallback fncCallback, void* pData);
	virtual void	SetCurLineInfo (FDLineInfoCallback fncCallback, void* pData);
//----- 05.07.01 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

// 05.07.10 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	virtual BOOL	CanPasteAsRtf () const;
	virtual void	OnPasteAsRtf (DWORD dwFormat);
// 05.07.10 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	virtual BOOL	CanPasteAsText () const;
	virtual void	OnPasteAsText (DWORD dwFormat);

	//----- _xZkqqHx_jBfDiJoGjGmKiDiCiBfLiDgIiKnGjIeB_xHqqkZx_ -----
	virtual void	UpdateFullScreenMode (BOOL bFullScreen);

	virtual BOOL	NextChar (long& lLine, long& lChar) const;
	virtual void	IndexToCharPos (long& lLine, long& lChar, long lIndex) const;
	virtual const FCEditChar&	GetCaretChar () const;
	virtual void	CalcCaret (mmetol& mmX, mmetol& mmY, mmetol& mmH) const;
	virtual mmetol	RepositionCaret ();

	virtual long	CharPosToIndex (long lLine, long lChar) const;
	virtual long	CoordToLine (mmetol mmy) const;
	virtual long	CoordToGapX (long lLine, mmetol mmx) const;
	virtual long	JoinLineBelow (long lLine);
	virtual void	JoinContLine (long lTopLine);
	virtual void	CalcLine (long lLine);
	virtual long	CalcLineAlignLeft (FCEditLine& edLine, mmetol& mmLeftGap,
										mmetol& mmRightGap, mmetol mmAlignGap,
										long lCharMax);

	enum {
		FTWR_END_NORMAL = 0,
		FTWR_END_OVER_ASCENT  = int(1L << 0),
		FTWR_END_OVER_DESCENT = int(1L << 1),
	};
	virtual int		CalcAlignLeftSimple (FCEditLine& edLine,
										long& lCharCount,
										mmetol& mmLeftGap, mmetol& mmRightGap,
										mmetol mmTMAscent, mmetol mmTMDescent,
										mmetol mmTMExternalLeading,
										mmetol mmAlignGap, long lCharMax,
										long lSpcIncFirst = 0,
										long lSpcIncEnd = 0,
										mmetol mmSpcInc = 0.0);

	virtual BOOL	IsWrapedWordE (long& lNewCount, const FCEditCharVector& vEditChar,
									long lCharCount) const;
	virtual BOOL	IsWrapedWordJ (long& lNewCount, const FCEditCharVector& vEditChar,
									long lCharCount) const;

	virtual long	CalcLineAlignRight (FCEditLine& edLine, long lCharSz);
	virtual BOOL	CalcLineAlignLeftright (FCEditLine& edLine, long lCharSz, mmetol mmRightGap);
	virtual void	ResetCurFormat ();
	virtual long	GetNextBoundary (long lCurLine, long lCurChar) const;
	virtual long	GetPrevBoundary (long lCurLine, long lCurChar) const;

	virtual BOOL	SendRgnRedraw ();
	virtual void	FillBackAndMarkUpdate (CDC* pDC);
	virtual void	RedrawUpdate (CDC* pDC);
	virtual void	RegisterClearRgn (const FCEditChar* pCharFirst,
										const FCEditChar* pCharLast = NULL); 
	virtual void	RegisterClearRgn (const FCEditLine* pLineFirst,
										const FCEditLine* pLineLast = NULL); 

	//----- Redo/Undo_xZkqqHx_iKnGjAjE_xHqqkZx_ -----
//----- 06.02.28 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	virtual BOOL	Redo1Session (long& lMinLine, long& lMinIdx, long& lCurIdx);
//	virtual BOOL	Undo1Session (long& lMinLine, long& lMinIdx, long& lCurIdx);
//----- 06.02.28 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	virtual BOOL	Redo1Session (long& lMinLine, long& lCurIdx);
	virtual BOOL	Undo1Session (long& lMinLine, long& lCurIdx);
//----- 06.02.28 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

	//----- _xZkqqHx_iDfCiDhNiDjDiDgIiKnGjAjE_xHqqkZx_ -----
	virtual void	SessionBegin ();
	virtual void	SessionEnd ();

	virtual DWORD	ReadVSizeUCmdQueue ();
	virtual DWORD	RReadVSizeUCmdQueue ();
	virtual void	WriteVSizeUCmdQueue (DWORD dwB);
	virtual void	InsertVSizeUCmdQueue (long lPos, DWORD dwB);
	virtual long	SeekCmdQueuePos (long lSize);
	virtual long	GetCmdQueuePos () const;
	virtual void	SetCmdQueuePos (long lPos);
	virtual const BYTE* GetCmdQueuePtr () const;
	virtual void	SetCmdQueuePtr (const BYTE* pPtr);

//----- 06.02.24 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	virtual void	CmdDeleteThinLine (long lIdxFrom);
//	virtual void	CmdInsertThinLine (long lIdxTo, const FCEditLine& eLine);
//	virtual void	CmdReplaceChars (long lIdxFrom, long lDelSz, const FCEditChar* pInsChar, long lInsSz);
//	virtual void	CmdFormatLine (long lIdxTo, const FCEditLine& eLine);
//----- 06.02.24 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	virtual long	CmdDeleteThinLine (long lIdxFrom);
	virtual long	CmdInsertThinLine (long lIdxTo, const FCEditLine& eLine);
	virtual long	CmdReplaceChars (long lIdxFrom, long lDelSz, const FCEditChar* pInsChar, long lInsSz);
	virtual long	CmdFormatLine (long lIdxTo, const FCEditLine& eLine);
//----- 06.02.24 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	virtual void	CmdFormatChars (long lIdxFrom, long lSize, const FCEditChar* pChar);
	virtual void	CmdModifyMargin (mmetol mmMarginL, mmetol mmMarginT, mmetol mmMarginR, mmetol mmMarginB);
	virtual void	CmdModifyVertAlign (BYTE byAlign);

	virtual void	RedoCmdDeleteThinLine (long lLine, long lChar);
	virtual void	UndoCmdDeleteThinLine (long lLine, long lChar);
	virtual void	RedoCmdInsertThinLine (long lLine, long lChar);
	virtual void	UndoCmdInsertThinLine (long lLine, long lChar);
	virtual void	RedoCmdReplaceChars (long lLine, long lChar);
	virtual void	UndoCmdReplaceChars (long lLine, long lChar);
	virtual void	RedoCmdFormatLine (long lLine, long lChar);
	virtual void	UndoCmdFormatLine (long lLine, long lChar);
	virtual void	RedoCmdFormatChars (long lLine, long lChar);
	virtual void	UndoCmdFormatChars (long lLine, long lChar);
	virtual void	RedoCmdModifyMargin (long lLine, long lChar);
	virtual void	UndoCmdModifyMargin (long lLine, long lChar);
	virtual void	RedoCmdModifyVertAlign (long lLine, long lChar);
	virtual void	UndoCmdModifyVertAlign (long lLine, long lChar);

	virtual long	MCmdDeleteSelection ();
	virtual long	MCmdInsertText (const FCEditCharVector& vChar,
									const FCTextLineInfo* tli = NULL);
//----- 06.02.24 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	virtual void	MCmdReplaceText (long lFrom, long lTo, const wchar_t* wcpStr);
//	virtual void	MCmdDeleteLines (long lIdxFrom, long lSize);
//	virtual void	MCmdInsertLine (long lIdxTo, const FCEditLine& eLine);
//----- 06.02.24 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	virtual long	MCmdReplaceText (long lFrom, long lTo, const wchar_t* wcpStr);
	virtual long	MCmdDeleteLines (long lIdxFrom, long lSize);
	virtual long	MCmdInsertLine (long lIdxTo, const FCEditLine& eLine);
//----- 06.02.24 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

// _xZkqqHx_iDiGiBfLiDfFiKnGjAjEiBgJ_xHqqkZx_template_xZkqqHx_iBgK_xHqqkZx_
protected:

//----------<NOT EXPORT TO VIEWER>-----------
	template<class T> void ReadCmdQueue (T& data)
		{
			// _xZkqqHx_iDeMiDiFiBfLiCkJiCoHjCgMiCpAiDfCiDhDiBfLiBeC_xHqqkZx_
			memcpy(&data, m_byvCmdQueue.begin() + m_lCmdPos, sizeof(data));
			// _xZkqqHx_iDfCiDhNiDjDiDgIiDeMiDiFiBfLjCiGiCmFiCmMiMlLiNnNiCmMiImKjChFiCpAjAgJiCnPiCoJiBeC_xHqqkZx_
			m_lCmdPos += sizeof(data);
		}
// 06.02.18 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	template<class T> void WriteCmdQueue (T data)
	template<class T> void WriteCmdQueue (const T& data)
		{
			m_byvCmdQueue.insert(m_byvCmdQueue.end(),
								(const BYTE*)(&data),
								(const BYTE*)(&data) + sizeof(data));
		}

	template<> void ReadCmdQueue <FCEditChar> (FCEditChar& eChar)
		{
			BYTE* pData = m_byvCmdQueue.begin() + m_lCmdPos;
			eChar.InStream(pData);
			m_lCmdPos = pData - m_byvCmdQueue.begin();
		}

// 06.02.18 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	template<> void WriteCmdQueue <FCEditChar> (FCEditChar eChar)
	template<> void WriteCmdQueue <FCEditChar> (const FCEditChar& eChar)
		{
			eChar.OutStream(m_byvCmdQueue);
		}
//----------</NOT EXPORT TO VIEWER>-----------

protected:
	static LPCTSTR	m_lpszClassName;	// AfxRegisterWndClass_xZkqqHx_iCmFjDgPjIfOiClDiCoKiClN_xHqqkZx_
										// _xZkqqHx_iDeOiDiJiDfIjGlMiCpAjFnLjBlGiBeC_xHqqkZx_
// 05.07.11 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	static DWORD	m_dwRTF;
	static short	m_nEditCtrlCount;	// _xZkqqHx_iClBiCmMiDeOiDiJiDfIiCmMiDeJiDhFiDfHiDeGiDeOiDgHjAjE_xHqqkZx_.
	static FCRichEditBuffer*	m_richpEditCtrl;
										// Copy&Paste_xZkqqHx_jHhAiDeHiDgGiDeCiDgCiDgHiDfCiDjDiDgHiDiNiBfLiDiL_xHqqkZx_.

	//----- _xZkqqHx_jEhHiMgJiBeFiKePiMgAjApMjFgAiJoGjHhAiDhJiDjDiBeFiDhFiDiJiDfG_xHqqkZx_ -----
	PenStyleID		m_psidPenStyle;
	fmmetol			m_mmfPenWeight;
	SColorID		m_scidPenBackSColor;
	SColorID		m_scidBrushBackSColor;
//----- 06.03.25 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iDeHiDgGiDeCiDfOjEhHiMgJjAeGiBeC_xHqqkZx_
	COLORREF		m_crBackground;
//----- 06.03.25 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	FCEditLineVector	m_vEditLine;	// _xZkqqHx_iNhD_xHqqkZx_.
	long				m_lCurIndex;	// _xZkqqHx_iMlLiNnNiCmMiDeKiDiMiDgCiDgHiCmMiImKjChFiBgJjFlGiOjKjAjEiBgK_xHqqkZx_
	mmetol				m_mmCaretX;		// _xZkqqHx_iDeKiDiMiDgCiDgHiCmMiImKjChFiBgJ_xHqqkZx_mm_xZkqqHx_iNmAjFfHiBgK_xHqqkZx_
	long				m_lSelFrom;		// _xZkqqHx_jBeJjBpAjEmNiImNiCmMiKeKiOgOiImKjChF_xHqqkZx_
	long				m_lSelTo;		// _xZkqqHx_jBeJjBpAjEmNiImNiCmMiPeJjHlJiImKjChFiBeCjBeJjBpAiNmFiMoDiCmMjFlGiOjKiCmM_xHqqkZx_Idx+1

	FCFontCharInfo		m_fciCurExtCodeFormat;	// _xZkqqHx_iMlLiNnNiCmMjFlGiOjKiDhEiDeIiBfLiDhNiDgCiDgH_xHqqkZx_.
	FCFontCharInfo		m_fciCurStdCodeFormat;	// _xZkqqHx_iMlLiNnNiCmM_xHqqkZx_SJIS_xZkqqHx_jFlGiOjKiDhEiDeIiBfLiDhNiDgCiDgHiBeC_xHqqkZx_

	BOOL		m_bIsBtnDown;		// _xZkqqHx_iNlGiDhLiDfOiDjDiCmMiPpDjBnEiBeCiJjPiClFiCmEiCkCiCoJiCmGiCkL_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
	long		m_lDblClkInterval;	// _xZkqqHx_iDfPiDhFiDiLiDeOiDiKiDgCiDeOiCmMiKnEiKhFiBeCiDhOiDiKjFgCiBeC_xHqqkZx_
	clock_t		m_clkLBtnDown;		// _xZkqqHx_iNlGiDhLiDfOiDjDiDeOiDiKiDgCiDeOiCmMiOjOiKnEiBeC_xHqqkZx_
	int			m_iClickCount;		// _xZkqqHx_jIeBjBlBiDeOiDiKiDgCiDeOiCmMiDeKiDeFiDjDiDfOiBeC_xHqqkZx_

	long			m_lgIndentLine;		// _xZkqqHx_iDhNiBfLiDeKiBfLiInKjDkOiOjOiCmMiDiPiBfLiDeOiBeC_xHqqkZx_
	FCShortRect		m_nrtClearRgn;		// _xZkqqHx_iNmEjFgAiJoGiOjOiCmJiPmBiLiOiClHiCoJjHmMiIoGiBeC_xHqqkZx_

	FDRichSpecKeyCallback	m_fncCallback;	// _xZkqqHx_iDfCiBfLiDiLiDgPiDgCiDeOiKnGjAjE_xHqqkZx_.
	BOOL					m_bIsFullScreen;	// _xZkqqHx_jBfDiJoGjGmKiDeHiDgGiDeCiDfOiDiCiBfLiDgIiBeI_xHqqkZx_
//----- 05.02.19 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	WORD	m_wFixResize;		// _xZkqqHx_iDgFiDeMiDfIiDgHiDiKiDfEiDeDiDfJiOjOiCmMjAiFjFlNjFpLiMpMiCmMjFjEjFgJiDiKiDfEiDeDiDfJjFpLjGeAiBeC_xHqqkZx_
// 05.05.03 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	WORD	m_wResizeVert;		// _xZkqqHx_iDgFiDeMiDfIiDgHiDiKiDfEiDeDiDfJiOjOiCmMjAiCjClMjFpLiMpMiCmMjFjEjFgJiDiKiDfEiDeDiDfJjFpLjGeAiBeC_xHqqkZx_
	BOOL	m_bIsShortenByText;	// _xZkqqHx_iDgFiDeMiDfIiDgHiPgLiPkMiOjOiCmJjFjEjFgJiPgLiPkMiBeI_xHqqkZx_
//----- 05.02.19 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	DBLRect			m_mmrtWindow;		// _xZkqqHx_iClBiCmMiDeFiDeCiDjDiDgIiDeFiCmMiDfEiDeDiDfJiBeC_xHqqkZx_
	DBLPointVector	m_vmmptPoly;		// _xZkqqHx_iDhNiDfIiDeOiDhMiDiKiDfDiDjDjEhKjHpBiBeCiDeHiDgGiDeCiDfOiDeFiDeCiDjDiDgIiDeFiNlGiPoD_xHqqkZx_=(0,0)_xZkqqHx_iCmJjAlDiLeLiJlLiBeC_xHqqkZx_

	DBLRect			m_mmrtWindowOrig;	// _xZkqqHx_iNmFiPiJiCmJjAnNjCoIiClDiCoKiClNiClBiCmMiDeFiDeCiDjDiDgIiDeFiCmMiDfEiDeDiDfJiBeC_xHqqkZx_
	DBLPointVector	m_vmmptPolyOrig;	// _xZkqqHx_iNmFiPiJiCmJjAnNjCoIiClDiCoKiClNiDhNiDfIiDeOiDhMiDiKiDfDiDjDjEhKjHpBiBeCiDeHiDgGiDeCiDfOiDeFiDeCiDjDiDgIiDeFiNlGiPoD_xHqqkZx_=(0,0)_xZkqqHx_iCmJjAlDiLeLiJlLiBeC_xHqqkZx_

	//------------------------------------------------------------------------
	// _xZkqqHx_iImIiJlKiCmNjCmKiPoNiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiCpAiDhEiDiLiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiCmJjAnIiCoIjBnGiCkGiCoJiNnLiCmJiBeB_xHqqkZx_
	// _xZkqqHx_iMoDiCmFjCmKiPoNiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiCmJjGnPiClHiOjOiCmMiClNiCnPiCmJiDgPiDgCiDeOiDeBiDgCiDhGiClFiCmEiCkIiCkNjFmPjAjEiBeC_xHqqkZx_
//----- 05.02.20 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	DBLRect			m_mmrtWindowOrig;		// _xZkqqHx_iClBiCmMiDeFiDeCiDjDiDgIiDeFiCmMiDfEiDeDiDfJiBeCiDeJiDiKiDfHiDgJiDiLiBeC_xHqqkZx_
//	DBLPointVector	m_vmmptPolyOrig;		// _xZkqqHx_iDhNiDfIiDeOiDhMiDiKiDfDiDjDjEhKjHpBiBeCiDeJiDiKiDfHiDgJiDiLiBeC_xHqqkZx_
//----- 05.02.20 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	SColorID		m_scidPenBackSColorOrig;// _xZkqqHx_iDhJiDjDjAeGiBeC_xHqqkZx_
	DBLPoint		m_mmptViewCenterOrig;	// _xZkqqHx_iDhCiDiFiBfLiCmMjCiGjAfDiNmAjFfHiCpAiLeMjIfOiBeC_xHqqkZx_
	long			m_lZoom256Orig;			// _xZkqqHx_iDfJiBfLiDiAjCgMiCpAiLeMjIfOiBeC_xHqqkZx_
	//------------------------------------------------------------------------

	mmetol			m_mmMarginL;		// _xZkqqHx_iDgFiDeMiDfIiDgHjHmMiIoGiCmMiNlGiDhNiBfLiDfHiDjD_xHqqkZx_.
	mmetol			m_mmMarginT;		// _xZkqqHx_iDgFiDeMiDfIiDgHjHmMiIoGiCmMiPoDiDhNiBfLiDfHiDjD_xHqqkZx_.
	mmetol			m_mmMarginR;		// _xZkqqHx_iDgFiDeMiDfIiDgHjHmMiIoGiCmMiJeFiDhNiBfLiDfHiDjD_xHqqkZx_.
	mmetol			m_mmMarginB;		// _xZkqqHx_iDgFiDeMiDfIiDgHjHmMiIoGiCmMiJlKiDhNiBfLiDfHiDjD_xHqqkZx_.
	BYTE			m_byVertAlign;		// _xZkqqHx_jAiCjClMjFpLiMpMiCmMiDeBiDiJiDeDiDjDiDiBiDjDiDgHiBeC_xHqqkZx_

	BYTEVector	m_byvCmdQueue;		// Redo,Undo_xZkqqHx_jHhAiDfCiDhNiDjDiDgIjHpBiBeC_xHqqkZx_
	long		m_lCmdPos;			// _xZkqqHx_iDfCiDhNiDjDiDgIiDeMiDiFiBfLjCiGiCmFiCmMiMlLiNnNiCmMiImKjChFiBeC_xHqqkZx_

//----- 02.08.31 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ (_xZkqqHx_iKnIiNjBiMoK_xHqqkZx_IME_xZkqqHx_iCmFjDkOiNoMiCkKiCkIiCkJiClFiCkC_xHqqkZx_)-----
	BOOL			m_bStartImeComposition;	// IME_xZkqqHx_iCnGiCmMjDpMjHmNiKeKiOgOiCkJiBeI_xHqqkZx_
//----- 02.08.31 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ (_xZkqqHx_iKnIiNjBiMoK_xHqqkZx_IME_xZkqqHx_iCmFjDkOiNoMiCkKiCkIiCkJiClFiCkC_xHqqkZx_)-----

//----- 06.02.19 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// Undo_xZkqqHx_jHhAiCmMiDfCiDhNiDjDiDgIiDfCiBfLiDgIiBeC_xHqqkZx_
//	enum FTRichEditCmd
//	{
//// 06.02.19 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
////		FDECMD_SEPARATER = 0,		// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiDfKiDhAiDiMiBfLiDfOiBeCjAoCjBmOiCmJiCePiBeC_xHqqkZx_
//		FDECMD_NONE = 0,			// _xZkqqHx_iDfCiDhNiDjDiDgIiCmIiClFiBeC_xHqqkZx_
//		FDECMD_DELETE_LINES,		// _xZkqqHx_jFkBjAjEiNhDiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
//		FDECMD_REPLACE_CHARS,		// _xZkqqHx_iCfAiNhDjCiGiCmMjFkBjAjEjFlGiOjKiCpAjDpMiCoKjBnGiCkGiCoJiBeC_xHqqkZx_
//		FDECMD_INSERT_LINE,			// _xZkqqHx_iCfAiNhDiCpAjBhNjDpMiClHiCoJiBeC_xHqqkZx_
//		FDECMD_FORMAT_LINE,			// _xZkqqHx_iCfAiNhDiCmMiDhEiDeIiBfLiDhNiDgCiDgHiCpAjFmPiNfIiClHiCoJiBeC_xHqqkZx_
//		FDECMD_FORMAT_CHARS,		// _xZkqqHx_jFkBjAjEiNhDiCmJjDgOiCoJjFkBjAjEjFlGiOjKiCmMiDhEiDeIiBfLiDhNiDgCiDgHiCpAjFmPiNfIiClHiCoJiBeC_xHqqkZx_
//		FDECMD_MODIFY_MARGIN,		// _xZkqqHx_jHfNjEjCiCpAjFmPiNfIiClHiCoJiBeC_xHqqkZx_
//		FDECMD_MODIFY_VERT_ALIGN,	// _xZkqqHx_jAiCjClMjFpLiMpMiDeBiDiJiDeDiDjDiDiBiDjDiDgHiCpAjFmPiNfIiClHiCoJiBeC_xHqqkZx_
//	}; // enum FTRichEditCmd.
//----- 06.02.19 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

// _xZkqqHx_iDeBiDgHiDiKiDhCiDiFiBfLiDgH_xHqqkZx_
public:

// _xZkqqHx_iDeJiDhJiDiMiBfLiDfGiDiHiDjD_xHqqkZx_
public:

// _xZkqqHx_iDeJiBfLiDgPiBfLiDiJiDeDiDgI_xHqqkZx_
	// ClassWizard _xZkqqHx_iCmNiJlMjBhKiKnGjAjEiCpAjAlGjAkMiClFiDeJiBfLiDgPiBfLiDiJiDeDiDgIiClFiCnMiClHiBeC_xHqqkZx_
	//{{AFX_VIRTUAL(CFCWndRichEdit)
	public:
	//}}AFX_VIRTUAL
//	virtual BOOL PreTranslateMessage(MSG* pMsg);

// _xZkqqHx_iDeDiDjDiDhGiDiKiDiBiDjDiDgFiBfLiDfGiDiHiDjD_xHqqkZx_
public:
	virtual ~CFCWndRichEdit ();

	// _xZkqqHx_jAlGjAkMiClDiCoKiClNiDiBiDgCiDfKiBfLiDfH_xHqqkZx_ _xZkqqHx_iDhNiDgCiDhGiKnGjAjE_xHqqkZx_
protected:
	//{{AFX_MSG(CFCWndRichEdit)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnDestroy();
	afx_msg void OnPaint();
	afx_msg void OnSetFocus(CWnd* pOldWnd);
	afx_msg void OnKillFocus(CWnd* pNewWnd);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg UINT OnGetDlgCode();
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnChar(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnContextMenu(CWnd* pWnd, CPoint point);
	afx_msg void OnMButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnMButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnMButtonDblClk(UINT nFlags, CPoint point);
	//}}AFX_MSG
//	afx_msg LRESULT OnImeChar(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT OnImeStartcomposition(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT OnImeEndcomposition(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT OnRulerMarker(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT OnCurrentLineUpdated(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT OnImeComposition(WPARAM wParam, LPARAM lParam);
	DECLARE_MESSAGE_MAP()

//----- 06.06.22 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
// _xZkqqHx_iKnGjAjEiPiHiPjIiCpAjFmPiCkGiCmIiCkCiClNiCnPiCmJiClBiClBiCmJjCmHiJmBiBeC_xHqqkZx_
public:
	virtual void	CalcCharWidthAll ();
//----- 06.06.22 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
}; // class CFCWndRichEdit.

/////////////////////////////////////////////////////////////////////////////

#endif//__WndRichEdit_h
