// DbServer.cpp : _xZkqqHx_iDeDiDjDiDhGiDiKiDiBiDjDiDgFiBfLiDfGiDiHiDjD_xHqqkZx_ _xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_
//

#include "stdafx.h"
#include <Windows.h>				// For FCDbFileDialog::OPENFILENAME.
#include <Commdlg.h>				// For FCDbFileDialog::OPENFILENAME.
#include <shlobj.h>					// For SHBrowseForFolder.
#include "UtilErr.h"				// For FFThrowMiscUnknown.
#include "UtilStdLib.h"				// For m1_for.
#include "UtilWin.h"				// For FFSetWindowText.
#include "UtilVirtualTable.h"		// For FCTableName.
#include "ServerTableManager.h"		// For FCServerTableManager.
#include "FdbProjectDialog.h"		// For FCFdbProjectDialog.
#include "DbServer.h"				// This header.

// _xZkqqHx_iDhEiDeAiDeDiDiLiDiNiDgCiDeOiCkKiOlIjEhDiClFiClNiPoKiNiHiBeBiDgHiDiJiDeDiCnMiCmFiCmMiDeDiDjDiDfOiBfLiDgPiDiLiBeC_xHqqkZx_
#define FD_INTERVAL_FILE_LOCK_MILLISEC	500

// _xZkqqHx_iJpAjFpKjHhGiLiBiCmMjHeMiMpIiKpKiMmAiBeC_xHqqkZx_
static const FDMILLISECTIME FD_UNLOCK_REQUEST_VALID_TIME = 1000;

// _xZkqqHx_iDhEiDeAiDeDiDiLjClHiCmMiNmFjBoFjCgMiBeCiNmFiCoAjAfLiCkNiCmIiCoJiDhAiDfI_xHqqkZx_(own_xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiCmMiDiGiBfLiDfFiBfLiPoOjFpB_xHqqkZx_)_xZkqqHx_iCpAiIpIiCkNiBeC_xHqqkZx_
static const long FD_MAX_PROJECT_PATH = (_MAX_PATH - strlen("/.own/086404DC-9F65-43F7-B4FB-F487D5DCEF4D.$1000000000000$5$"));

struct S_DBSERVER
{
	S_DBSERVER () : s_hWnd(NULL) {}
	HWND	s_hWnd;						// _xZkqqHx_iDiBiDgCiDfKiBfLiDfHjBjHjFhEjAoGiBeBjAgFiDeFiDeCiDjDiDgIiDeFiBeC_xHqqkZx_
	DWORD	s_dwUnlockRequestMessage;	// _xZkqqHx_iJpAjFpKjHhGiLiBiDiBiDgCiDfKiBfLiDfHiBeC_xHqqkZx_
}; // struct S_DBSERVER.

typedef FCCsAreaRead<S_DBSERVER>		s0_read;
typedef FCCsAreaWrite<S_DBSERVER>		s0_write;
typedef FCCsAreaReadWrite<S_DBSERVER>	s0_readwrite;

static FCCsAreaDef<S_DBSERVER> s_0;

/////////////////////////////////////////////////////////////////////////////
//
// _xZkqqHx_iDgFiBfLiDhFiDiLiCmGiDeDiDjDiDgGiDgCiDeOiDfIiCmMiNfMjBkCiBeC_xHqqkZx_
//
//           _xZkqqHx_iEkFiEjPiEjPiEjP_xHqqkZx_ Record 0 _xZkqqHx_iEjPiEjPiEjPiEjPiEkJiEjPiEjP_xHqqkZx_ Record 1 _xZkqqHx_iEjPiEjPiEkJiEjPiEjPiEjP_xHqqkZx_ Record 2 _xZkqqHx_iEjPiEjPiEjPiEjPiEjPiEjPiEkH_xHqqkZx_    _xZkqqHx_iEkFiEjPiEjPiEjP_xHqqkZx_ Record N _xZkqqHx_iEjPiEjPiEjPiEjPiEkH_xHqqkZx_
//           _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkGiBgDiBgDiEkGiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkC_xHqqkZx_
//      Data _xZkqqHx_iEkA_xHqqkZx_                        _xZkqqHx_iEkA_xHqqkZx_                  _xZkqqHx_iEkA_xHqqkZx_                            _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_                        _xZkqqHx_iEkA_xHqqkZx_
//           _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkIiBgDiBgDiEkIiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_
//           _xZkqqHx_iBkK_xHqqkZx_                        _xZkqqHx_iBkK_xHqqkZx_                  _xZkqqHx_iBkK_xHqqkZx_                            _xZkqqHx_iBkK_xHqqkZx_                              _xZkqqHx_iBkK_xHqqkZx_
//           _xZkqqHx_iEkA_xHqqkZx_                        _xZkqqHx_iEkA_xHqqkZx_                  _xZkqqHx_iEkA_xHqqkZx_                            _xZkqqHx_iEkA_xHqqkZx_                              _xZkqqHx_iEkA_xHqqkZx_
//           _xZkqqHx_iEkEiEjPiEkC_xHqqkZx_                    _xZkqqHx_iEkEiEkC_xHqqkZx_                _xZkqqHx_iEkEiEjPiEjPiEkC_xHqqkZx_                      _xZkqqHx_iEkA_xHqqkZx_                            _xZkqqHx_iEkBiEkD_xHqqkZx_
//               _xZkqqHx_iEkA_xHqqkZx_                      _xZkqqHx_iEkA_xHqqkZx_                      _xZkqqHx_iEkA_xHqqkZx_                      _xZkqqHx_iEkA_xHqqkZx_                            _xZkqqHx_iEkA_xHqqkZx_
//           _xZkqqHx_iEkBiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkGiBgDiBgDiEkGiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkC_xHqqkZx_
//     Index _xZkqqHx_iEkA_xHqqkZx_Addres_xZkqqHx_iEkA_xHqqkZx_PrimId_xZkqqHx_iEkA_xHqqkZx_Identi_xZkqqHx_iEkA_xHqqkZx_Addres_xZkqqHx_iEkA_xHqqkZx_PrimId_xZkqqHx_iEkA_xHqqkZx_Identi_xZkqqHx_iEkA_xHqqkZx_Addres_xZkqqHx_iEkA_xHqqkZx_PrimId_xZkqqHx_iEkA_xHqqkZx_Identi_xZkqqHx_iEkA_xHqqkZx_Addres_xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_PrimId_xZkqqHx_iEkA_xHqqkZx_Identi_xZkqqHx_iEkA_xHqqkZx_Addres_xZkqqHx_iEkA_xHqqkZx_
//           _xZkqqHx_iEkEiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkIiBgDiBgDiEkIiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkD_xHqqkZx_
//           _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
//           _xZkqqHx_iEkF_xHqqkZx_flint-_xZkqqHx_iEkJ_xHqqkZx_flint-_xZkqqHx_iEkJ_xHqqkZx_DWORD-_xZkqqHx_iEkJ_xHqqkZx_flint-_xZkqqHx_iEkJ_xHqqkZx_flint-_xZkqqHx_iEkJ_xHqqkZx_DWORD-_xZkqqHx_iEkJ_xHqqkZx_flint-_xZkqqHx_iEkJ_xHqqkZx_flint-_xZkqqHx_iEkJ_xHqqkZx_DWORD-_xZkqqHx_iEkJ_xHqqkZx_flint-_xZkqqHx_iEkJiBgDiBgDiEkJ_xHqqkZx_flint-_xZkqqHx_iEkJ_xHqqkZx_DWORD-_xZkqqHx_iEkJ_xHqqkZx_flint-_xZkqqHx_iEkH_xHqqkZx_
//                   _xZkqqHx_iEkA_xHqqkZx_                      _xZkqqHx_iEkA_xHqqkZx_                      _xZkqqHx_iEkA_xHqqkZx_                      _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_                      _xZkqqHx_iEkA_xHqqkZx_
//                   _xZkqqHx_iEkFiEjPiEjPiEjP_xHqqkZx_ Record 0 _xZkqqHx_iEjPiEjPiEjPiEkJiEjPiEjPiEjP_xHqqkZx_ Record 1 _xZkqqHx_iEjPiEjPiEjPiEkJiEjPiEjPiEjP_xHqqkZx_ Record 2 _xZkqqHx_iEjPiEjPiEjPiEkH_xHqqkZx_    _xZkqqHx_iEkFiEjPiEjPiEjP_xHqqkZx_ Record N _xZkqqHx_iEjPiEjPiEjPiEkH_xHqqkZx_
//
// Index_xZkqqHx_iNmFiPiJiCmM_xHqqkZx_Addres_xZkqqHx_iCmNiBeB_xHqqkZx_Index_xZkqqHx_iCpAjDhCjCiGiCkJiCoHjAnIiCoIiPgPiClHiPoKiNiHiCmJjFeLjHhGiCmGiCmIiCoJiBeC_xHqqkZx_
// _xZkqqHx_iClBiCoKiCkKjGlDiCkCiCmGiBeBiCmHiCmMiImKjChFiCkJiCoHjAnIiCoIiPgPiClFiClNiCmMiCkJiCkKiCoNiCkJiCoHiCmIiCkNiCmIiCoJiClNiCnPiBeC_xHqqkZx_
//

/////////////////////////////////////////////////////////////////////////////
// FCIndexFile.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCIndexFile::FCIndexFile
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCIndexFile::FCIndexFile (const FCTableName& tableName)
		:	m_file(	FFGetFilePath(tableName) + FDTBL_INDEX_FILE_EXT,
					GENERIC_READ, FILE_SHARE_READ, OPEN_EXISTING)
{
} // FCIndexFile::FCIndexFile (const wchar_t* wcpFilePath);

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCIndexFile::~FCIndexFile
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCIndexFile::~FCIndexFile ()
{
	m_file.Close();
} // FCIndexFile::~FCIndexFile ();

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCIndexFile::GetRecordCount
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiBfLiDhFiDiLiCmMiDiMiDfCiBfLiDgIjAjEiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiMiDfCiBfLiDgIjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DWORD FCIndexFile::GetRecordCount () const
{
	return DWORD((m_file.GetLength64() - sizeof(flint)) / FD_INDEX_RECORD_SIZE);
} // DWORD FCIndexFile::GetRecordCount () const;

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCIndexFile::GetDataFilePosition
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDiMiDfCiBfLiDgIiImKjChFiCmMiBeBiDgGiBfLiDfOiDhEiDeAiDeDiDiLiCmJiCkIiCkPiCoJiDhEiDeAiDeDiDiLiImKjChF_xHqqkZx_
 *			_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwIndex	:_xZkqqHx_iDiMiDfCiBfLiDgIiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDgGiBfLiDfOiDhEiDeAiDeDiDiLiCmMiImKjChFiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDgFiBfLiDhFiDiLiCmMiDiMiDfCiBfLiDgIjAjEiCkKiCgNiCmMiPoKiNiHiBeB_xHqqkZx_dwIndex _xZkqqHx_iCmNiBeBiCePiCkJiCoHiCgNiCnMiCmF_xHqqkZx_
 *			_xZkqqHx_iOhHjCoIiCmFiCkLiCoJiBeCiCgNiCpAiOhHjCoIiClFiClNiPoKiNiHiCmNiDgGiBfLiDfOiDhEiDeAiDeDiDiLiPeJjCfLiCkKjFnEiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
flint FCIndexFile::GetDataFilePosition (DWORD dwIndex)
{
	// _xZkqqHx_iIoKiCmCjBePiCmMiImKjChFiCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
	flint fliRecordPosition;
	m_file.Seek64(GetIndexFilePosition(dwIndex) - sizeof(flint), FILE_BEGIN);
	m_file.Read64(&fliRecordPosition, sizeof(fliRecordPosition));
	return fliRecordPosition;
} // flint FCIndexFile::GetDataFilePosition (DWORD dwIndex);

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCIndexFile::SeekToIndex
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDeDiDjDiDgGiDgCiDeOiDfIiImKjChFiCmJiDhEiDeAiDeDiDiLiDhMiDeDiDjDiDfOiCpAiInKjDkOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwIndex	:_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCIndexFile::SeekToIndex (DWORD dwIndex)
{
	m_file.Seek64(GetIndexFilePosition(dwIndex), FILE_BEGIN);
} // void FCIndexFile::SeekToIndex (DWORD dwIndex);

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCIndexFile::GetCurrentIndex
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiDeDiDjDiDgGiDgCiDeOiDfIiImKjChFiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiDeDiDjDiDgGiDgCiDeOiDfIiImKjChFiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DWORD FCIndexFile::GetCurrentIndex () const
{
	return DWORD((m_file.GetPosition64() - sizeof(flint)) / FD_INDEX_RECORD_SIZE);
} // DWORD FCIndexFile::GetCurrentIndex () const;

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCIndexFile::Read
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiImKjChFiCkJiCoHiBeBiDiMiDfCiBfLiDgIiPoOjFpBiCpAjDmHiCnNiPgPiClHiBeCiMlLiNnNiImKjChFiCmNiOjPiCmM_xHqqkZx_
 *			_xZkqqHx_iDiMiDfCiBfLiDgIiImKjChFiCmJiInKjDkOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fliPrimaryId	:_xZkqqHx_iDhGiDiJiDeDiDhNiDiKiBfL_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *			dwAppendIdentifier
 *							:_xZkqqHx_jCmHiJmB_xHqqkZx_Identifier_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *			fliDataFilePositionTail
 *							:_xZkqqHx_iDgGiBfLiDfOiDhEiDeAiDeDiDiLiImKjChFiCpAjFnEiClHiBeCiDiMiDfCiBfLiDgIiCmMiPeJjCfLiCpA_xHqqkZx_
 *							 _xZkqqHx_jFnEiClHiClBiCmGiCmJjCiNiInDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCIndexFile::Read (flint& fliPrimaryId,
						DWORD& dwAppendIdentifier,
						flint& fliDataFilePositionTail)
{
	m_file.Read64(&fliPrimaryId, sizeof(fliPrimaryId));
	m_file.Read64(&dwAppendIdentifier, sizeof(dwAppendIdentifier));
	m_file.Read64(&fliDataFilePositionTail, sizeof(fliDataFilePositionTail));
} // void FCIndexFile::Read.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCIndexFile::GetIndexFilePosition
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDiMiDfCiBfLiDgIiImKjChFiCmMiBeBiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCmJiCkIiCkPiCoJ_xHqqkZx_
 *			_xZkqqHx_iDhEiDeAiDeDiDiLiImKjChFiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwIndex	:_xZkqqHx_iDiMiDfCiBfLiDgIiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCmMiImKjChFiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDgFiBfLiDhFiDiLiCmMiDiMiDfCiBfLiDgIjAjEiCkKiCgNiCmMiPoKiNiHiBeB_xHqqkZx_dwIndex _xZkqqHx_iCmNiBeBiCePiCkJiCoHiCgNiCnMiCmF_xHqqkZx_
 *			_xZkqqHx_iOhHjCoIiCmFiCkLiCoJiBeCiCgNiCpAiOhHjCoIiClFiClNiPoKiNiHiCmNiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiPeJjCfLiCkKjFnEiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
flint FCIndexFile::GetIndexFilePosition (DWORD dwIndex)
{
	return sizeof(flint) + (flint(FD_INDEX_RECORD_SIZE) * flint(dwIndex));
} // flint FCIndexFile::GetIndexFilePosition (DWORD dwIndex);

/////////////////////////////////////////////////////////////////////////////
// FCDbServer

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDbServer::FCDbServer
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCDbServer::FCDbServer ()
{
} // FCDbServer::FCDbServer.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDbServer::~FCDbServer
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCDbServer::~FCDbServer ()
{
//----- 06.03.15 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	td_readwrite td_rw(m_csaThreadData);
	if (td_rw->m_hFlushThreadHandle != INVALID_HANDLE_VALUE)
	//----- _xZkqqHx_iDhEiDiJiDgCiDfGiDiFiDfIiDiMiDgCiDgIiOmAiNhDjCiGiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDhEiDiJiDgCiDfGiDiFiDfIiDiMiDgCiDgIiCpAiLkNjAkHiPeJjHlJiClDiClJiCoJiBeC_xHqqkZx_
		TerminateThread(td_rw->m_hFlushThreadHandle, 0);
		// _xZkqqHx_iDhEiDiJiDgCiDfGiDiFiOmAiNhDiDfIiDiMiDgCiDgIiCmMiDgOiDjDiDgIiDiLiBeC_xHqqkZx_
		td_rw->m_hFlushThreadHandle = INVALID_HANDLE_VALUE;
		// _xZkqqHx_iDfIiDiMiDgCiDgIiLoMjDkOiDeDiDhIiDjDiDgHiBeC_xHqqkZx_
		CloseHandle(td_rw->m_hThreadEvent);
		td_rw->m_hThreadEvent = INVALID_HANDLE_VALUE;
		// _xZkqqHx_iDhEiDiJiDgCiDfGiDiFjElLjCoIiDhEiDiJiDePiBeC_xHqqkZx_
		td_rw->m_bIsFlushing = FALSE;

		//----- _xZkqqHx_iDgHiDiJiDjDiDfFiDeOiDfGiDiHiDjDiDgPiDgCiDhEiDeAiCpAiNoNiPjMiClHiCoJ_xHqqkZx_ -----
		while (!td_rw->m_vTopDirPath.empty())
		{
			// _xZkqqHx_iDgHiDiJiDjDiDfFiDeOiDfGiDiHiDjDiDgPiDgCiDhEiDeAiCpAiNoNiPjMiBeC_xHqqkZx_
			delete[] td_rw->m_vTransaction.back();
			td_rw->m_vTopDirPath.pop_back();
			td_rw->m_vTransaction.pop_back();
			td_rw->m_vTransactionSize.pop_back();
		}
	}
//----- 06.03.15 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
} // FCDbServer::~FCDbServer.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDbServer::Initialize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfEiBfLiDgPiBfLiCmMiPiJiKpKiJlLiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDbServer::Initialize ()
{
} // FCDbServer::Initialize.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDbServer::Terminate
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfEiBfLiDgPiBfLiCmMiPeJjHlJiPiIjHjNiBeCiNoNiPjMjBePiCmJjFeLiClIiOmAiNhDiClHiCoJjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDbServer::Terminate ()
{
//----- 06.03.15 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iDhEiDiJiDgCiDfGiDiFiCmMiDfIiDiMiDgCiDgIiCpAiPeJjHlJiClDiClJiCoJiBeC_xHqqkZx_
	TerminateFlushThread();
//----- 06.03.15 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	//----- _xZkqqHx_iJpAjFpKjHhGiLiBiCpAiNoNiPjM_xHqqkZx_ -----
	lr_readwrite lr_rw(m_csaLockRec);
	map<FCTableName, int>::const_iterator iTh;
	for (iTh = lr_rw->m_mpGroupNameToUnlockReq.begin();
		 iTh != lr_rw->m_mpGroupNameToUnlockReq.end(); iTh++)
		FCAutoLock::RemoveUnlockRequest(iTh->first, iTh->second);
	// _xZkqqHx_jEhKjHpBiCpAiDeOiDiKiDeBiBeC_xHqqkZx_
	lr_rw->m_mpGroupNameToUnlockReq.clear();

	// _xZkqqHx_iJpAjFpKjHhGiLiBiKmEiOiLiDfIiDiMiDgCiDgIiCpAjCoCiOhOiBeC_xHqqkZx_
	FCAutoLock::TerminateAllWatchUnlockRequestThread();
	map<FCTableName, FCServerLockRecAuto>::iterator iT2i;
	for (iT2i = lr_rw->m_mpTableNameToLockRec.begin();
		 iT2i != lr_rw->m_mpTableNameToLockRec.end();
		 iT2i++)
	{
		FCServerLockRec* pLockRec = iT2i->second.get();
		if (pLockRec->m_autoReadLock.IsFileLocked())
			pLockRec->m_autoReadLock.UnlockFile();
		if (pLockRec->m_autoWriteLock.IsFileLocked())
			pLockRec->m_autoWriteLock.UnlockFile();
	}
} // FCDbServer::Terminate.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDbServer::SetLoginUserName
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfEiBfLiDgPiBfLiCpAiOgHiCkEiDeOiDiJiDeDiDeBiDjDiDgHiCmMiDiGiBfLiDfFiBfLjGlMiCpAjDgPjIfOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpUserName	:_xZkqqHx_iDiGiBfLiDfFiBfLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jAnNjCoIiClDiCoKiClNiDiGiBfLiDfFiBfLjGlMiCmNiBeBiDgFiBfLiDhFiDiLiCpAiDiNiDgCiDeOiClFiCmEiCkCiCoJjBiKiOoIiCpAjDmBjCoIiClHiCoJ_xHqqkZx_
 *			_xZkqqHx_iClNiCnPiCmJiOgHiCoNiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDgFiBfLiDhFiDiLiCkKiDiNiDgCiDeOiCmFiCkLiCmIiCkCiCmGiCkLiBhFiChHiChHiChHiChHiCmJiCoGiCmBiCmEiDiNiDgCiDeOiClDiCoKiCmEiCkCiCnMiClHiBhG_xHqqkZx_
 *			_xZkqqHx_iCmGiCkCiCkEiDiBiDgCiDfKiBfLiDfHiCpAjFfMiOkGiClHiCoJiClNiCnPiCmJiOgHiCoNiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDbServer::SetLoginUserName (const wchar_t* wcpUserName)
{
	FCAutoLock::SetLoginUserName(wcpUserName);
} // FCDbServer::SetLoginUserName.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDbServer::CheckTopGroupPath
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgHiDgCiDhGiDePiDiLiBfLiDhGiCmMiDhAiDfIiCkKjAlDiPoNiCkJiCmHiCkEiCkJjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpTopDirPath	:_xZkqqHx_iDgHiDgCiDhGiDePiDiLiBfLiDhGiCmMiDhAiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAlDiPoNiCmMiPoKiNiHiCmN_xHqqkZx_ 0_xZkqqHx_iBeCiDeHiDiJiBfLiCmMiPoKiNiHiCmNiDiBiDgCiDfKiBfLiDfH_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DsErr FCDbServer::CheckTopGroupPath (const wchar_t* wcpTopDirPath)
{
	if (FD_MAX_PROJECT_PATH <= wcslen(wcpTopDirPath))
		return IDS_DYSR_ERR_FILE_PATH_TOO_LONG;
	if (!FFIsFilePathRegal(wcpTopDirPath))
		return IDS_DYSR_ERR_FILE_PATH_WRONG;
	return 0;
} // FCDbServer::CheckTopGroupPath.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDbServer::TryReadLock
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgFiBfLiDhFiDiLiCmM_xHqqkZx_SHARED READ_xZkqqHx_iDiNiDgCiDeOiCpAiOiOiCnNiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	guidTable			:_xZkqqHx_jDmHiCnNiNjOiCnMiCoKiClNiDgGiBfLiDfOiCmMiBeBiDgFiBfLiDhFiDiL_xHqqkZx_GUID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *			dwDeleteIdentifier	:_xZkqqHx_jDmHiCnNiNjOiCnMiCoKiClNiDgGiBfLiDfOiCmMiBeBiNoNiPjM_xHqqkZx_Identifier_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *			dwAppendIdentifier	:_xZkqqHx_jDmHiCnNiNjOiCnMiCoKiClNiDgGiBfLiDfOiCmMiBeBjCmHiJmB_xHqqkZx_Identifier_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *			dsTableName			:_xZkqqHx_iDgFiBfLiDhFiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_ 0_xZkqqHx_iBeCiDeHiDiJiBfLiCmMiPoKiNiHiCmNiDiBiDgCiDfKiBfLiDfH_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DsErr FCDbServer::TryReadLock (	GUID& guidTable,
								DWORD& dwDeleteIdentifier,
								DWORD& dwAppendIdentifier,
								const DsTableName& dsTableName)
{
	return TryReadLock(	guidTable,
						dwDeleteIdentifier,
						dwAppendIdentifier,
						FCTableName(dsTableName));
} // FCDbServer::TryReadLock.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDbServer::TryWriteLock
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgFiBfLiDhFiDiLiCmM_xHqqkZx_EXCLUSIVE WRITE_xZkqqHx_iDiNiDgCiDeOiCpAiOiOiCnNiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dsTableName	:_xZkqqHx_iDgFiBfLiDhFiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_ 0_xZkqqHx_iBeCiDeHiDiJiBfLiCmMiPoKiNiHiCmNiDiBiDgCiDfKiBfLiDfH_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DsErr FCDbServer::TryWriteLock (const DsTableName& dsTableName)
{
	return TryWriteLock(FCTableName(dsTableName));
} // FCDbServer::TryWriteLock.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDbServer::CreateWriteLock
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiNiDgCiDeOiDhEiDeAiDeDiDiLiBgJiPiKjHeMiMkAiDhEiDeAiDeDiDiLiBgKiCpAiNoMjAkMiClFiBeB_xHqqkZx_EXCLUSIVE WRITE_xZkqqHx_iDiNiDgCiDeOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dsTableName		:_xZkqqHx_iDgFiBfLiDhFiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_ 0_xZkqqHx_iBeCiDeHiDiJiBfLiCmMiPoKiNiHiCmNiDiBiDgCiDfKiBfLiDfH_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DsErr FCDbServer::CreateWriteLock (const DsTableName& dsTableName)
{
	return CreateWriteLock(FCTableName(dsTableName));
} // FCDbServer::CreateWriteLock.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDbServer::ReadUnlock
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgFiBfLiDhFiDiLiCmM_xHqqkZx_READ_xZkqqHx_iDiNiDgCiDeOiCpAiJpAiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dsTableName		:_xZkqqHx_iDgFiBfLiDhFiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iKkOjBfDiCmJiJpAiPjMiClDiCoKiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeCiDiNiDgCiDeOiCkKiOgDiCmBiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_ FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDiNiDgCiDeOiCmNjFkBjAjEiJpBiPgEiCmLiCmEiCmFiCkLiCoJiCmMiCmFiBeBiCfAiJpBiKnGjAjEiCpAiOmAiNhDiClFiCmEiCoA_xHqqkZx_
 *			_xZkqqHx_iDiNiDgCiDeOiCkKiJpAiPjMiCmFiCkLiCoJiCmGiCmNiMmAiCoHiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCDbServer::ReadUnlock (const DsTableName& dsTableName)
{
	return ReadUnlock(FCTableName(dsTableName));
} // FCDbServer::ReadUnlock.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDbServer::WriteUnlock
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgFiBfLiDhFiDiLiCmM_xHqqkZx_WRITE_xZkqqHx_iDiNiDgCiDeOiCpAiJpAiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dsTableName		:_xZkqqHx_iDgFiBfLiDhFiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iKkOjBfDiCmJiJpAiPjMiClDiCoKiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeCiDiNiDgCiDeOiCkKiOgDiCmBiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_ FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDiNiDgCiDeOiCmNjFkBjAjEiJpBiPgEiCmLiCmEiCmFiCkLiCoJiCmMiCmFiBeBiCfAiJpBiKnGjAjEiCpAiOmAiNhDiClFiCmEiCoA_xHqqkZx_
 *			_xZkqqHx_iDiNiDgCiDeOiCkKiJpAiPjMiCmFiCkLiCoJiCmGiCmNiMmAiCoHiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCDbServer::WriteUnlock (const DsTableName& dsTableName)
{
	return WriteUnlock(FCTableName(dsTableName));
} // FCDbServer::WriteUnlock.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDbServer::IsReadLocked
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgFiBfLiDhFiDiLiCkK_xHqqkZx_READ_xZkqqHx_iDiNiDgCiDeOiClDiCoKiCmEiCkCiCoJiCkJjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dsTableName		:_xZkqqHx_iDgFiBfLiDhFiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiNiDgCiDeOiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCDbServer::IsReadLocked (const DsTableName& dsTableName) const
{
	return IsReadLocked(FCTableName(dsTableName));
} // FCDbServer::IsReadLocked.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDbServer::IsWriteLocked
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgFiBfLiDhFiDiLiCkK_xHqqkZx_WRITE_xZkqqHx_iDiNiDgCiDeOiClDiCoKiCmEiCkCiCoJiCkJjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dsTableName		:_xZkqqHx_iDgFiBfLiDhFiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiNiDgCiDeOiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCDbServer::IsWriteLocked (const DsTableName& dsTableName) const
{
	return IsWriteLocked(FCTableName(dsTableName));
} // FCDbServer::IsWriteLocked.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDbServer::WhoLockingFile
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgFiBfLiDhFiDiLiCpAiDiNiDgCiDeOiClFiCmEiCkCiCoJiDiGiBfLiDfFiBfLiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dsUserName		:_xZkqqHx_iDiGiBfLiDfFiBfLjGlMiCmMiDiKiDfIiDgHiCpAjFnEiClHiBeC_xHqqkZx_
 *							 _xZkqqHx_iDiGiBfLiDfFiBfLjGlMiCpA_xHqqkZx_ '/' _xZkqqHx_iCmFiCmCiCmIiCkCiClOjFlGiOjKjHpBiBeC_xHqqkZx_
 *			dsTableName		:_xZkqqHx_iDgFiBfLiDhFiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiNiDgCiDeOiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDbServer::WhoLockingFile (DsString& dsUserName, const DsTableName& dsTableName) const
{
	WString wstrUserName = FCAutoLock::WhoLockingFile(FCTableName(dsTableName));
	dsUserName = wstrUserName.c_str();
} // FCDbServer::WhoLockingFile.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDbServer::SendTransaction
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeOiDiJiDeDiDeBiDjDiDgHiCkJiCoHiDgHiDiJiDjDiDfFiDeOiDfGiDiHiDjDiCpAiOpDiCkPiOoGiCoIiBeBiPiIjHjNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	bMultiUserAccessable:_xZkqqHx_jFkBjAjEiDiGiBfLiDfFiBfLiCkKiDhEiDeAiDeDiDiLiCmJjDkPiOjOiCmJiDeBiDeOiDfKiDfI_xHqqkZx_
 *								 _xZkqqHx_iClHiCoJiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bReturnImmediate	:_xZkqqHx_jBkGiOjOiCmJjFjMiLeBiClHiCoJiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpTopDirPath		:_xZkqqHx_iDgHiDiJiDjDiDfFiDeOiDfGiDiHiDjDjBmOiPnLiCmMiDgHiDgCiDhGiDePiDiLiBfLiDhGiCpA_xHqqkZx_
 *								 _xZkqqHx_iOhHjCoIiBeC_xHqqkZx_
 *			pTransaction		:_xZkqqHx_iDgHiDiJiDjDiDfFiDeOiDfGiDiHiDjDiDgGiBfLiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *			szTransaction		:_xZkqqHx_iDgHiDiJiDjDiDfFiDeOiDfGiDiHiDjDiDgGiBfLiDfOiCmMiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lTopDirCount		:_xZkqqHx_iDgHiDiJiDjDiDfFiDeOiDfGiDiHiDjDiCmMjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	bMultiUserAccessable = TRUE _xZkqqHx_iCkKiOhHjCoIiClDiCoKiClNiPoKiNiHiCmNiBeBiDiNiDgCiDeOiCmM_xHqqkZx_
 *			_xZkqqHx_iPiKjHeMiMkAiDhEiDeAiDeDiDiLiCpA_xHqqkZx_EXCLUSIVE_xZkqqHx_iCmFiDiNiDgCiDeOiClFiCmEjBlMiDiGiBfLiDfFiBfLiCmMiDeBiDeOiDfKiDfIiCpA_xHqqkZx_
 *			_xZkqqHx_jAkHiMmAiClFiCmEiCkJiCoHiBeBiDgFiBfLiDhFiDiLiCmMiPjBiCkLiNjOiCnNiCpAiNhDiCkEiBeCiDiNiDgCiDeOiCmFiCkLiCmIiCkCiPoKiNiHiCmN_xHqqkZx_
 *			_xZkqqHx_iJpAjFpKjHhGiLiBiCpAjEkNiNhDiClHiCoJiBeCiCnMiClNiBeBiDgFiBfLiDhFiDiLiCmMiPjBiCkLiNjOiCnNjBePiCmJiJpBjFjMiDhEiDeAiDeDiDiL_xHqqkZx_
 *			_xZkqqHx_iCpAiNoMjAkMiClFiBeBiPjBiCkLiNjOiCnNjCiGiCmJjCiGjCgGiClFiCmEiCoAiMlDiCmMiPpDjBnEiCmJiJpBjFjMiCmFiCkLiCoJiCoGiCkEiCmJ_xHqqkZx_
 *			_xZkqqHx_iClHiCoJiBeC_xHqqkZx_
 *			bReturnImmediate = TRUE _xZkqqHx_iCkKiOhHjCoIiClDiCoKiClNiPoKiNiHiCmNiBeBiPiIjHjNiCpAjFmKiDfIiDiMiDgCiDgIiCmF_xHqqkZx_
 *			_xZkqqHx_jAgJiCnPiCmEiBeBiKnGjAjEiCmNiClHiCkOiCmJjFjMiLeBiClHiCoJiBeC_xHqqkZx_bReturnImmediate = FALSE _xZkqqHx_iCmMiPoKiNiHiCmN_xHqqkZx_
 *			_xZkqqHx_iPiIjHjNiCpAiClBiCmMiDfIiDiMiDgCiDgIiCmFjAgJiCnPiCmEiBeBiPiIjHjNiCkKiPeJjHlJiClHiCoJiCnMiCmFjFjMiLeBiClFiCmIiCkCiBeC_xHqqkZx_
 *			_xZkqqHx_iDgHiDiJiDjDiDfFiDeOiDfGiDiHiDjDiCmNiBeBiDgHiDgCiDhGiDePiDiLiBfLiDhGiClCiCmGiCmJjFkKiCkPiCmEiOhHjCoIiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jHoBiCkGiCmOiDgHiDgCiDhGiDePiDiLiBfLiDhGiCkKiCgAiBeBiCgBiBeBiCgCiCmGiCfCiCmCiCkAiCoJiPoKiNiHiBeBiImIiJlKiCmMiIpIjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpTopDirPath[0] = _xZkqqHx_iCgA_xHqqkZx_
 *			wcpTopDirPath[1] = _xZkqqHx_iCgB_xHqqkZx_
 *			wcpTopDirPath[2] = _xZkqqHx_iCgC_xHqqkZx_
 *			pTransaction[0] = _xZkqqHx_iChD_xHqqkZx_a
 *			pTransaction[1] = _xZkqqHx_iChD_xHqqkZx_b
 *			pTransaction[2] = _xZkqqHx_iChD_xHqqkZx_c
 *			szTransaction[0] = sizeof _xZkqqHx_iChD_xHqqkZx_a
 *			szTransaction[1] = sizeof _xZkqqHx_iChD_xHqqkZx_b
 *			szTransaction[2] = sizeof _xZkqqHx_iChD_xHqqkZx_c
 *			lTopDirCount = _xZkqqHx_iCfC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDbServer::SendTransaction (	BOOL bMultiUserAccessable,
									BOOL bReturnImmediate,
									const wchar_t* wcpTopDirPath[],
									const BYTE* pTransaction[],
									size_t szTransaction[],
									long lTopDirCount)
{
	// _xZkqqHx_iDhEiDiJiDgCiDfGiDiFjCiGiCmNiPiIjHjNiCmFiCkLiCmIiCkCiBeC_xHqqkZx_
	if (IsFlushing()) FFThrowMiscUnknown();

	//----- WRITE_xZkqqHx_iDiNiDgCiDeOiCpAjBjNiClFiDiNiDgCiDeO_xHqqkZx_ -----

	// _xZkqqHx_jBkGiOjOjFjMiLeBiCmMiPoKiNiHiBeBiDeOiDiJiDeDiDeBiDjDiDgHiCmF_xHqqkZx_WRITE_xZkqqHx_iDiNiDgCiDeOiCpAiJpAiPjMiClDiCoKiCoJiJmCjEfMjAkLiCkKiCkAiCoJiBeC_xHqqkZx_
	// _xZkqqHx_iClLiCmMiClNiCnPiBeBjFmKiDfIiDiMiDgCiDgIiCmFiCmNiCmIiCkNiClBiCmMiKnGjAjEjCiGiCmFjBjNiClFiDiNiDgCiDeOiCpAiClFiCmEiCkIiCkNiBeC_xHqqkZx_

	// _xZkqqHx_iMlLiOjOjDfPiCmF_xHqqkZx_Write_xZkqqHx_iDiNiDgCiDeOiClDiCoKiCmEiCkCiCoJiDgFiBfLiDhFiDiLiCpAjBfDiCmEiOoGjDlOiBeC_xHqqkZx_
	vector<FCTableName> vWriteLockedTableName;
	GetWriteLockedTable(vWriteLockedTableName);
	// Write_xZkqqHx_iDiNiDgCiDeOiClDiCoKiCmEiCkCiCoJiDgFiBfLiDhFiDiLiCpAjBfDiCmEiCfAiCmCjBjNiClFiDiNiDgCiDeOiClFiCmEiCkIiCkNiBeC_xHqqkZx_
	mdef_const_iterator(vector<FCTableName>, iTn);
	m1_for (iTn, vWriteLockedTableName)
	{
		// _xZkqqHx_iDgFiBfLiDhFiDiLiCpA_xHqqkZx_WRITE_xZkqqHx_iCmFjBjNiClFiDiNiDgCiDeOiBeCiKpJiCmJiDiNiDgCiDeOiNmPiCnNiCmIiCmMiCmFjFeLiClIjAkMiMpHiClHiCoJiBeC_xHqqkZx_
		TryWriteLock(*iTn);
	}

	{
		// _xZkqqHx_iDhEiDiJiDgCiDfGiDiFiCkKiOmAiNhDiClDiCoKiCoJjDhIiCmJiDfIiDiMiDgCiDgIiCpAiNoMjAkMiClFiCmEiBeBiDhEiDiJiDgCiDfGiDiFiCkK_xHqqkZx_
		// _xZkqqHx_iKkOjHlJiClHiCoJjDhIiCmJiDfIiDiMiDgCiDgIiCpAiPeJjHlJiClFiCmEiCkCiClNiCkKiBeBiDfIiDiMiDgCiDgIiNoMjAkMiCmJiCmNiOjOiKnEiCkK_xHqqkZx_
		// _xZkqqHx_iCkJiCkJiCmBiCmEiClFiCnMiCkCiBeBjDkOiNoMiCkKjChIiCkNiCmIiCmBiCmEiCkCiClNiBeC_xHqqkZx_
		// _xZkqqHx_iClBiCmMiClNiCnPiBeBiDfIiDiMiDgCiDgIiCmNiOmAiNhDiClFiCmBiCmPiCmIiClFiCmFiBeBiDeDiDhIiDjDiDgHiCmJiCoGiCmBiCmE_xHqqkZx_
		// _xZkqqHx_iOmAiNhDiCpAjAkHiMoEiClHiCoJiCoGiCkEiCmJiClFiClNiBeC_xHqqkZx_

		td_readwrite td_rw(m_csaThreadData);
		// _xZkqqHx_iDhEiDiJiDgCiDfGiDiFiOmAiNhDiDfIiDiMiDgCiDgIiCmMiDgOiDjDiDgIiDiLiBeC_xHqqkZx_
		if (td_rw->m_hFlushThreadHandle == INVALID_HANDLE_VALUE)
		//----- _xZkqqHx_iCnMiClOiDfIiDiMiDgCiDgIiCpAiOmAiNhDiClFiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDfIiDiMiDgCiDgIiLoMjDkOiDeDiDhIiDjDiDgHiBeC_xHqqkZx_
			td_rw->m_hThreadEvent = CreateEvent(NULL, FALSE, FALSE, NULL);
			// _xZkqqHx_iDhEiDiJiDgCiDfGiDiFjElLjCoIiDhEiDiJiDePiBeC_xHqqkZx_
			td_rw->m_bIsFlushing = FALSE;
			// _xZkqqHx_iDfIiDiMiDgCiDgIiCpAiLeOjDkOiBeC_xHqqkZx_
			DWORD dwFlushThreadId;
			td_rw->m_hFlushThreadHandle =
				CreateThread(NULL, 0, (PTHREAD_START_ROUTINE)FCDbServer::myFlushAllThread,
							(LPVOID)this, 0, &dwFlushThreadId);
		}
	}
	// _xZkqqHx_iDhEiDiJiDgCiDfGiDiFiCmMiDeHiDiJiBfLiDfCiBfLiDgIiCpAiDiKiDfKiDgCiDgHiBeC_xHqqkZx_
	ResetFlushError();

	// _xZkqqHx_iDhEiDiJiDgCiDfGiDiFiDfIiDiMiDgCiDgIiLoMjDkOiDeDiDhIiDjDiDgHiBeC_xHqqkZx_
	HANDLE hThreadEvent;
	{
		// _xZkqqHx_iDhEiDiJiDgCiDfGiDiFjElLjCoIiDhEiDiJiDePiCpAjAnNjCoIiBeC_xHqqkZx_
		// _xZkqqHx_iDfIiDiMiDgCiDgIjCiGiCmFiCoAjAnNjCoIiClHiCoJiCkKiBeBiDfIiDiMiDgCiDgIiCkKjDkOiCkNiDfOiDeDiDhOiDjDiDePiCkK_xHqqkZx_
		// _xZkqqHx_jFhDiKgNiOmAiCmIiCmMiCmFiBeBiClBiClBiCmFjAnNjCoIiClFiCmEiClFiCnMiCkEiBeC_xHqqkZx_
		td_readwrite td_rw(m_csaThreadData);
		td_rw->m_bIsFlushing = TRUE;

		td_rw->m_vTopDirPath.clear();
		td_rw->m_vTransaction.clear();
		td_rw->m_vTransactionSize.clear();

		for (long lC = 0; lC != lTopDirCount; lC++)
		{
			BYTE* pBuff = new BYTE[szTransaction[lC]];
			memcpy(pBuff, pTransaction[lC], szTransaction[lC]);
			td_rw->m_vTopDirPath.push_back(HString(wcpTopDirPath[lC]));
			td_rw->m_vTransaction.push_back(pBuff);
			td_rw->m_vTransactionSize.push_back(szTransaction[lC]);
		}
		td_rw->m_vWriteLockedTableName = vWriteLockedTableName;
		// _xZkqqHx_jFkBjAjEiDiGiBfLiDfFiBfLiCkJiCoHjDkPiOjOiDeBiDeOiDfKiDfIiJmCjEfMiCmJiClHiCoJiCkJiBeI_xHqqkZx_
		td_rw->m_bMultiUserAccessable = bMultiUserAccessable;

		hThreadEvent = td_rw->m_hThreadEvent;
	}
	if (bReturnImmediate)
	//----- _xZkqqHx_jBkGiOjOjFjMiLeBiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDfIiDiMiDgCiDgIiLoMjDkOiDeDiDhIiDjDiDgHiCpAiDfGiDePiDgJiDiLiPpDjBnEiCmJiBeC_xHqqkZx_PulseEvent _xZkqqHx_iClOiCmGiBeB_xHqqkZx_
		// WaitForSingleObject _xZkqqHx_iCmJjDpMiCmBiCmEiPkNiClFiOjOiKnEiCkKiMgPiClNiCmIiCkCiCmG_xHqqkZx_
		// _xZkqqHx_iCkEiCnMiCkNjDkOiNoMiClFiCmIiCkJiCmBiClNiBeC_xHqqkZx_
		SetEvent(hThreadEvent);
	} else
	//----- _xZkqqHx_iDhEiDiJiDgCiDfGiDiFiPeJjHlJiCpAjBnCiCmCiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDhEiDiJiDgCiDfGiDiFiPiIjHjNiBeC_xHqqkZx_
		FlushThreadProc();
	}
} // FCDbServer::SendTransaction.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDbServer::GetFlushErrorCode
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBePiJpBiCmM_xHqqkZx_SendTransaction_xZkqqHx_iKnGjAjEiCmJiCoGiCmBiCmEiOmAiNhDiClDiCoKiClNiDhEiDiJiDgCiDfGiDiFiCmF_xHqqkZx_
 *			_xZkqqHx_jAlGiClGiClNiDeHiDiJiBfLiCmMiDfCiBfLiDgIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeHiDiJiBfLiDfCiBfLiDgIiBeCiDeHiDiJiBfLiCkKjGlDiCkJiCmBiClNiPoKiNiHiCmN_xHqqkZx_0_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDeHiDiJiBfLiCmNiBeB_xHqqkZx_DynamicServerErrorCode.h _xZkqqHx_iCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DsErr FCDbServer::GetFlushErrorCode () const
{
	// _xZkqqHx_iDhEiDiJiDgCiDfGiDiFjCiGiCmMiDeHiDiJiBfLiDfCiBfLiDgIiBeC_xHqqkZx_
	return td_read(m_csaThreadData)->m_dsFlushErrorCode;
} // FCDbServer::GetFlushErrorCode.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDbServer::GetFlushErrorMessage
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBePiJpBiCmM_xHqqkZx_SendTransaction_xZkqqHx_iKnGjAjEiCmJiCoGiCmBiCmEiOmAiNhDiClDiCoKiClNiDhEiDiJiDgCiDfGiDiFiCmF_xHqqkZx_
 *			_xZkqqHx_jAlGiClGiClNiDeHiDiJiBfLiCmMiDiBiDgCiDfKiBfLiDfHjFlGiOjKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dstrErrorMessage	:_xZkqqHx_iDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHjFlGiOjKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDeHiDiJiBfLiCmNiBeB_xHqqkZx_DynamicServerErrorCode.h _xZkqqHx_iCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDbServer::GetFlushErrorMessage (DsString& dstrErrorMessage) const
{
	// _xZkqqHx_iDhEiDiJiDgCiDfGiDiFjCiGiCmMiDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiBeC_xHqqkZx_
	dstrErrorMessage = (const wchar_t*)GetFlushErrorMessage();
} // FCDbServer::GetFlushErrorMessage.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDbServer::GetRecordCount
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgFiBfLiDhFiDiLiCmMiDiMiDfCiBfLiDgIjAjEiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dsTableName		:_xZkqqHx_iDgFiBfLiDhFiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiMiDfCiBfLiDgIjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DWORD FCDbServer::GetRecordCount (const DsTableName& dsTableName)
{
	return GetRecordCount(FCTableName(dsTableName));
} // FCDbServer::GetRecordCount.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDbServer::LoadTableIndex
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiBfLiDhFiDiLiCmMiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCkJiCoHiDeDiDjDiDgGiDgCiDeOiDfIiPoOjFpBiCpAjDmHiCnNiPgPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vTableIndex		:_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiPoOjFpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			dsTableName		:_xZkqqHx_iDgFiBfLiDhFiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwBeginIndex	:_xZkqqHx_jDmHiCnNiPgPiClHiDiMiDfCiBfLiDgIjEmNiImNiCmMiNmFiPiJiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwEndIndex		:_xZkqqHx_jDmHiCnNiPgPiClHiDiMiDfCiBfLiDgIjEmNiImNiCmMiNmFiMoDiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *							 vTableIndex_xZkqqHx_iCmJiBeBiClBiCmMjCgMiCmNiKnMiCnMiCoKiCmIiCkCiBeC_xHqqkZx_
 *							 _xZkqqHx_iPeJiCoNiCoIiCnMiCmFjDmHiCnNiPgPiClHiPoKiNiHiCmN_xHqqkZx_ DWORD(-1)_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDgGiBfLiDfOiDhEiDeAiDeDiDiLiCmGiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCmNiImIiJlKiCmMjAhNiCmMiNfMjBkCiCpAiClFiCmEiCkCiCoJiBeC_xHqqkZx_
 *
 *               _xZkqqHx_iEkFiEjPiEjPiEjP_xHqqkZx_ Record 0 _xZkqqHx_iEjPiEjPiEjPiEjPiEkJiEjPiEjP_xHqqkZx_ Record 1 _xZkqqHx_iEjPiEjPiEkJiEjPiEjPiEjP_xHqqkZx_ Record 2 _xZkqqHx_iEjPiEjPiEjPiEjPiEjPiEjPiEkH_xHqqkZx_    _xZkqqHx_iEkFiEjPiEjPiEjP_xHqqkZx_ Record N _xZkqqHx_iEjPiEjPiEjPiEjPiEkH_xHqqkZx_
 *               _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkGiBgDiBgDiEkGiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkC_xHqqkZx_
 *          Data _xZkqqHx_iEkA_xHqqkZx_                        _xZkqqHx_iEkA_xHqqkZx_                  _xZkqqHx_iEkA_xHqqkZx_                            _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_                        _xZkqqHx_iEkA_xHqqkZx_
 *               _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkIiBgDiBgDiEkIiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_
 *               _xZkqqHx_iBkK_xHqqkZx_                        _xZkqqHx_iBkK_xHqqkZx_                  _xZkqqHx_iBkK_xHqqkZx_                            _xZkqqHx_iBkK_xHqqkZx_                              _xZkqqHx_iBkK_xHqqkZx_
 *               _xZkqqHx_iEkA_xHqqkZx_                        _xZkqqHx_iEkA_xHqqkZx_                  _xZkqqHx_iEkA_xHqqkZx_                            _xZkqqHx_iEkA_xHqqkZx_                              _xZkqqHx_iEkA_xHqqkZx_
 *               _xZkqqHx_iEkEiEjPiEkC_xHqqkZx_                    _xZkqqHx_iEkEiEkC_xHqqkZx_                _xZkqqHx_iEkEiEjPiEjPiEkC_xHqqkZx_                      _xZkqqHx_iEkA_xHqqkZx_                            _xZkqqHx_iEkBiEkD_xHqqkZx_
 *                   _xZkqqHx_iEkA_xHqqkZx_                      _xZkqqHx_iEkA_xHqqkZx_                      _xZkqqHx_iEkA_xHqqkZx_                      _xZkqqHx_iEkA_xHqqkZx_                            _xZkqqHx_iEkA_xHqqkZx_
 *               _xZkqqHx_iEkBiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkGiBgDiBgDiEkGiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkC_xHqqkZx_
 *         Index _xZkqqHx_iEkA_xHqqkZx_Addres_xZkqqHx_iEkA_xHqqkZx_PrimId_xZkqqHx_iEkA_xHqqkZx_Identi_xZkqqHx_iEkA_xHqqkZx_Addres_xZkqqHx_iEkA_xHqqkZx_PrimId_xZkqqHx_iEkA_xHqqkZx_Identi_xZkqqHx_iEkA_xHqqkZx_Addres_xZkqqHx_iEkA_xHqqkZx_PrimId_xZkqqHx_iEkA_xHqqkZx_Identi_xZkqqHx_iEkA_xHqqkZx_Addres_xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_PrimId_xZkqqHx_iEkA_xHqqkZx_Identi_xZkqqHx_iEkA_xHqqkZx_Addres_xZkqqHx_iEkA_xHqqkZx_
 *               _xZkqqHx_iEkEiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkIiBgDiBgDiEkIiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkD_xHqqkZx_
 *               _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
 *               _xZkqqHx_iEkF_xHqqkZx_flint-_xZkqqHx_iEkJ_xHqqkZx_flint-_xZkqqHx_iEkJ_xHqqkZx_DWORD-_xZkqqHx_iEkJ_xHqqkZx_flint-_xZkqqHx_iEkJ_xHqqkZx_flint-_xZkqqHx_iEkJ_xHqqkZx_DWORD-_xZkqqHx_iEkJ_xHqqkZx_flint-_xZkqqHx_iEkJ_xHqqkZx_flint-_xZkqqHx_iEkJ_xHqqkZx_DWORD-_xZkqqHx_iEkJ_xHqqkZx_flint-_xZkqqHx_iEkJiBgDiBgDiEkJ_xHqqkZx_flint-_xZkqqHx_iEkJ_xHqqkZx_DWORD-_xZkqqHx_iEkJ_xHqqkZx_flint-_xZkqqHx_iEkH_xHqqkZx_
 *                       _xZkqqHx_iEkA_xHqqkZx_                      _xZkqqHx_iEkA_xHqqkZx_                      _xZkqqHx_iEkA_xHqqkZx_                      _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_                      _xZkqqHx_iEkA_xHqqkZx_
 *                       _xZkqqHx_iEkFiEjPiEjPiEjP_xHqqkZx_ Record 0 _xZkqqHx_iEjPiEjPiEjPiEkJiEjPiEjPiEjP_xHqqkZx_ Record 1 _xZkqqHx_iEjPiEjPiEjPiEkJiEjPiEjPiEjP_xHqqkZx_ Record 2 _xZkqqHx_iEjPiEjPiEjPiEkH_xHqqkZx_    _xZkqqHx_iEkFiEjPiEjPiEjP_xHqqkZx_ Record N _xZkqqHx_iEjPiEjPiEjPiEkH_xHqqkZx_
 *
 *                                       _xZkqqHx_iEkAiBkJiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiCgAiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiBkIiEkA_xHqqkZx_
 *
 *			_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiCmMiCfAiDiMiDfCiBfLiDgIiCmNiBeB_xHqqkZx_
 *			_xZkqqHx_iDhGiDiJiDeDiDhNiDiKiBfL_xHqqkZx_ID_xZkqqHx_iBhLjCmHiJmB_xHqqkZx_Identifier_xZkqqHx_iBhLiDgGiBfLiDfOiPeJjCfLiDeBiDgIiDiMiDfI_xHqqkZx_
 *			_xZkqqHx_iCmMiDfKiDgCiDgHiCkJiCoHiNfMjAkMiClDiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iPoDjAhNiCmJiCkAiCoJiCoGiCkEiCmJiBeBiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCmMjAoGjDkKiCmJiCmNiBeB_xHqqkZx_
 *			_xZkqqHx_iDgGiBfLiDfOjAoGjDkKiDeBiDgIiDiMiDfIiCmMiPoOjFpBiCkKjHfNjFkKiCmJjDpMiCmBiCmEiCkCiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDgGiBfLiDfOiDhEiDeAiDeDiDiLiCmMjAoGjDkKiCmNiCePiCmIiCmMiCmFiClBiCmMiPoOjFpBiCmNjFhDjHhGiCmJiOhGiCkGiCoJiCkKiBeB_xHqqkZx_
 *			LoadTableIndex_xZkqqHx_jDjJiCmFiDeDiDjDiDgGiDgCiDeOiDfIiCpAjDhCjCiGiCkJiCoHjAnIiCoIiPgPiClHiPoKiNiHiCmJ_xHqqkZx_
 *			_xZkqqHx_iDgGiBfLiDfOiDhEiDeAiDeDiDiLiCmMiCmHiCmMiImKjChFiCkJiCoHiDiMiDfCiBfLiDgIiCkKiOgOiCnMiCoJiCkJiCpAjClCiCnHiCoJiInHiCmJ_xHqqkZx_
 *			_xZkqqHx_jFeLjHhGiCmGiCmIiCoJiBeC_xHqqkZx_
 *
 *			dwBeginIndex = 1_xZkqqHx_iBeB_xHqqkZx_dwEndIndex = 3 _xZkqqHx_iCpAiOhHjCoIiClFiClNiPoKiNiHiBeB_xHqqkZx_
 *			vTableIndex _xZkqqHx_iCmJiCmNiCgAiCmMjEmNiImNiCkKjAnNjCoIiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDbServer::LoadTableIndex (	DsArray<BYTE>& vTableIndex,
									const DsTableName& dsTableName,
									DWORD dwBeginIndex,
									DWORD dwEndIndex)
{
	LoadTableIndex(	vTableIndex,
					FCTableName(dsTableName),
					dwBeginIndex,
					dwEndIndex);
} // FCDbServer::LoadTableIndex.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDbServer::LoadTableRecords
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiBfLiDhFiDiLiCmMiDgGiBfLiDfOiDhEiDeAiDeDiDiLiCkJiCoHiDiMiDfCiBfLiDgIiDgGiBfLiDfOiCpAjDmHiCnNiPgPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vTableRecord	:_xZkqqHx_iDiMiDfCiBfLiDgIiDgGiBfLiDfOiPoOjFpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			dsTableName		:_xZkqqHx_iDgFiBfLiDhFiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwBeginIndex	:_xZkqqHx_jDmHiCnNiPgPiClHiDiMiDfCiBfLiDgIjEmNiImNiCmMiNmFiPiJiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwEndIndex		:_xZkqqHx_jDmHiCnNiPgPiClHiDiMiDfCiBfLiDgIjEmNiImNiCmMiNmFiMoDiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *							 vTableRecord_xZkqqHx_iCmJiBeBiClBiCmMjCgMiCmNiKnMiCnMiCoKiCmIiCkCiBeC_xHqqkZx_
 *							 _xZkqqHx_iPeJiCoNiCoIiCnMiCmFjDmHiCnNiPgPiClHiPoKiNiHiCmN_xHqqkZx_ DWORD(-1)_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDgGiBfLiDfOiDhEiDeAiDeDiDiLiCmGiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCmNiImIiJlKiCmMjAhNiCmMiNfMjBkCiCpAiClFiCmEiCkCiCoJiBeC_xHqqkZx_
 *
 *                                         _xZkqqHx_iEkAiBkJiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiCgAiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiBkIiEkA_xHqqkZx_
 *
 *               _xZkqqHx_iEkFiEjPiEjPiEjP_xHqqkZx_ Record 0 _xZkqqHx_iEjPiEjPiEjPiEjPiEkJiEjPiEjP_xHqqkZx_ Record 1 _xZkqqHx_iEjPiEjPiEkJiEjPiEjPiEjP_xHqqkZx_ Record 2 _xZkqqHx_iEjPiEjPiEjPiEjPiEjPiEjPiEkH_xHqqkZx_    _xZkqqHx_iEkFiEjPiEjPiEjP_xHqqkZx_ Record N _xZkqqHx_iEjPiEjPiEjPiEjPiEkH_xHqqkZx_
 *               _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkGiBgDiBgDiEkGiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkC_xHqqkZx_
 *          Data _xZkqqHx_iEkA_xHqqkZx_                        _xZkqqHx_iEkA_xHqqkZx_                  _xZkqqHx_iEkA_xHqqkZx_                            _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_                        _xZkqqHx_iEkA_xHqqkZx_
 *               _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkIiBgDiBgDiEkIiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_
 *               _xZkqqHx_iBkK_xHqqkZx_                        _xZkqqHx_iBkK_xHqqkZx_                  _xZkqqHx_iBkK_xHqqkZx_                            _xZkqqHx_iBkK_xHqqkZx_                              _xZkqqHx_iBkK_xHqqkZx_
 *               _xZkqqHx_iEkA_xHqqkZx_                        _xZkqqHx_iEkA_xHqqkZx_                  _xZkqqHx_iEkA_xHqqkZx_                            _xZkqqHx_iEkA_xHqqkZx_                              _xZkqqHx_iEkA_xHqqkZx_
 *               _xZkqqHx_iEkEiEjPiEkC_xHqqkZx_                    _xZkqqHx_iEkEiEkC_xHqqkZx_                _xZkqqHx_iEkEiEjPiEjPiEkC_xHqqkZx_                      _xZkqqHx_iEkA_xHqqkZx_                            _xZkqqHx_iEkBiEkD_xHqqkZx_
 *                   _xZkqqHx_iEkA_xHqqkZx_                      _xZkqqHx_iEkA_xHqqkZx_                      _xZkqqHx_iEkA_xHqqkZx_                      _xZkqqHx_iEkA_xHqqkZx_                            _xZkqqHx_iEkA_xHqqkZx_
 *               _xZkqqHx_iEkBiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkGiBgDiBgDiEkGiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkC_xHqqkZx_
 *         Index _xZkqqHx_iEkA_xHqqkZx_Addres_xZkqqHx_iEkA_xHqqkZx_PrimId_xZkqqHx_iEkA_xHqqkZx_Identi_xZkqqHx_iEkA_xHqqkZx_Addres_xZkqqHx_iEkA_xHqqkZx_PrimId_xZkqqHx_iEkA_xHqqkZx_Identi_xZkqqHx_iEkA_xHqqkZx_Addres_xZkqqHx_iEkA_xHqqkZx_PrimId_xZkqqHx_iEkA_xHqqkZx_Identi_xZkqqHx_iEkA_xHqqkZx_Addres_xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_PrimId_xZkqqHx_iEkA_xHqqkZx_Identi_xZkqqHx_iEkA_xHqqkZx_Addres_xZkqqHx_iEkA_xHqqkZx_
 *               _xZkqqHx_iEkEiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkIiBgDiBgDiEkIiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkD_xHqqkZx_
 *               _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
 *               _xZkqqHx_iEkF_xHqqkZx_flint-_xZkqqHx_iEkJ_xHqqkZx_flint-_xZkqqHx_iEkJ_xHqqkZx_DWORD-_xZkqqHx_iEkJ_xHqqkZx_flint-_xZkqqHx_iEkJ_xHqqkZx_flint-_xZkqqHx_iEkJ_xHqqkZx_DWORD-_xZkqqHx_iEkJ_xHqqkZx_flint-_xZkqqHx_iEkJ_xHqqkZx_flint-_xZkqqHx_iEkJ_xHqqkZx_DWORD-_xZkqqHx_iEkJ_xHqqkZx_flint-_xZkqqHx_iEkJiBgDiBgDiEkJ_xHqqkZx_flint-_xZkqqHx_iEkJ_xHqqkZx_DWORD-_xZkqqHx_iEkJ_xHqqkZx_flint-_xZkqqHx_iEkH_xHqqkZx_
 *                       _xZkqqHx_iEkA_xHqqkZx_                      _xZkqqHx_iEkA_xHqqkZx_                      _xZkqqHx_iEkA_xHqqkZx_                      _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_                      _xZkqqHx_iEkA_xHqqkZx_
 *                       _xZkqqHx_iEkFiEjPiEjPiEjP_xHqqkZx_ Record 0 _xZkqqHx_iEjPiEjPiEjPiEkJiEjPiEjPiEjP_xHqqkZx_ Record 1 _xZkqqHx_iEjPiEjPiEjPiEkJiEjPiEjPiEjP_xHqqkZx_ Record 2 _xZkqqHx_iEjPiEjPiEjPiEkH_xHqqkZx_    _xZkqqHx_iEkFiEjPiEjPiEjP_xHqqkZx_ Record N _xZkqqHx_iEjPiEjPiEjPiEkH_xHqqkZx_
 *
 *			dwBeginIndex = 1_xZkqqHx_iBeB_xHqqkZx_dwEndIndex = 3 _xZkqqHx_iCpAiOhHjCoIiClFiClNiPoKiNiHiBeB_xHqqkZx_
 *			vTableRecord _xZkqqHx_iCmJiCmNiCgAiCmMjEmNiImNiCkKjAnNjCoIiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDbServer::LoadTableRecords (	DsArray<BYTE>& vTableRecord,
									const DsTableName& dsTableName,
									DWORD dwBeginIndex,
									DWORD dwEndIndex)
{
	LoadTableRecords(	vTableRecord,
						FCTableName(dsTableName),
						dwBeginIndex,
						dwEndIndex);
} // FCDbServer::LoadTableRecords.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDbServer::GetUnlockRequestGroup
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iCkCiCnMiJpAjFpKjHhGiLiBiCpAiOpDiCkPiCmEiCkCiCoJiDePiDiLiBfLiDhGiCmMjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dsGroupNameArray	:_xZkqqHx_iDePiDiLiBfLiDhGjGlMiCmMjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jBlMiCmMiDeBiDhGiDiKiCkJiCoHiDiNiDgCiDeOiJpAjFpKiCmMjHhGiLiBiCpAiOpDiCkPiCmEiCkCiCoJiDePiDiLiBfLiDhGiCpAjClCiCnHiBeB_xHqqkZx_
 *			_xZkqqHx_iClLiCmMiIoKjHjHiCpAjFnEiClHiBeC_xHqqkZx_
 *			_xZkqqHx_iJpAjFpKjHhGiLiBiCmNiDgFiBfLiDhFiDiLjCfAiImKiCmFiCmNiCmIiCkNiBeBiDePiDiLiBfLiDhGjCfAiImKiCmFiCkAiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iJpAjFpKjHhGiLiBiCmNjFmKiDfIiDiMiDgCiDgIiCmJiCoGiCmBiCmEiPoNiCmJiKmEiOiLiClDiCoKiCmEiCkIiCoIiBeBiJpAjFpKjHhGiLiBiCpA_xHqqkZx_
 *			_xZkqqHx_iOpDiCkPjFhEiCkPiCoJiCmGiDiBiDjDiDgPiBfLjFmPjAjEiCmJiLeMjIfOiClDiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iLeMjIfOiClDiCoKiClNiDePiDiLiBfLiDhGiCmJiCmNjHeMiMpIiKpKiMmAiCkKjAnNjCoIiClDiCoKiCmEiCkIiCoIiBeBjHeMiMpIiKpKiMmAiCpA_xHqqkZx_
 *			_xZkqqHx_iJnPiCkMiClNiJpAjFpKjHhGiLiBiCmNiNoNiPjMiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDbServer::GetUnlockRequestGroup (DsArray<DsTableName>& dsGroupNameArray)
{
	vector<FCTableName> vGroupName;
	GetUnlockRequestGroup(vGroupName);
	dsGroupNameArray.Allocate(vGroupName.size());
	long lC;
	for (lC = 0; lC != vGroupName.size(); lC++)
		dsGroupNameArray.GetAt(lC) = DsTableName(vGroupName[lC]);
} // FCDbServer::GetUnlockRequestGroup.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDbServer::IsFlushing
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFmKiDfIiDiMiDgCiDgIiCmFiDhEiDiJiDgCiDfGiDiFiPiIjHjNjCiGiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhEiDiJiDgCiDfGiDiFiPiIjHjNjCiGiCmMiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCDbServer::IsFlushing () const
{
	// _xZkqqHx_iDhEiDiJiDgCiDfGiDiFjElLjCoIiDhEiDiJiDePiBeC_xHqqkZx_
	return td_read(m_csaThreadData)->m_bIsFlushing;
} // FCDbServer::IsFlushing.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDbServer::IsGroupExist
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDePiDiLiBfLiDhGiCkKjBlGiNnNiClHiCoJiCkJjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dsGroupName		:_xZkqqHx_iDePiDiLiBfLiDhGjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jBlGiNnNiClHiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDePiDiLiBfLiDhGiCmMiDgGiDeCiDiMiDeOiDgHiDiKiCkKjBlGiNnNiClHiCoJiCkJjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCDbServer::IsGroupExist (const DsTableName& dsGroupName) const
{
	return IsGroupExist(FCTableName(dsGroupName));
} // FCDbServer::IsGroupExist.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDbServer::IsTableExist
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgFiBfLiDhFiDiLiCkKjBlGiNnNiClHiCoJiCkJjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dsTableName	:_xZkqqHx_iDgFiBfLiDhFiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jBlGiNnNiClHiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDgFiBfLiDhFiDiLiCmMiDgGiBfLiDfOiDhEiDeAiDeDiDiLiCkKjBlGiNnNiClHiCoJiCkJjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCDbServer::IsTableExist (const DsTableName& dsTableName) const
{
	return IsTableExist(FCTableName(dsTableName));
} // FCDbServer::IsTableExist.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDbServer::DeleteTopGroup
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgHiDgCiDhGiDePiDiLiBfLiDhGiCmMiDgGiDeCiDiMiDeOiDgHiDiKiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpTopDirPath	:_xZkqqHx_iDgHiDgCiDhGiDePiDiLiBfLiDhGiCmMiDhAiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeHiDiJiBfLiDfCiBfLiDgIiBeCiDeHiDiJiBfLiCkKjGlDiCkCiPoKiNiHiCmN_xHqqkZx_ 0_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDfEiDhFiDePiDiLiBfLiDhGiBeBiDfEiDhFiDgFiBfLiDhFiDiLiCmNiKpJiCmJiNoNiPjMiClDiCoKiBeBiLpDiCmFiCkAiCoJiCmNiClIiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCmMiClNiCnPiBeBiDfEiDhFiDgFiBfLiDhFiDiLiCmMiDiNiDgCiDeOjDjJiCmNjFeLjHhGiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DsErr FCDbServer::DeleteTopGroup (const wchar_t* wcpTopDirPath)
{
//----- 06.03.12 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iDhAiDfIiCpAiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
	const DsErr errCode = CheckTopGroupPath(wcpTopDirPath);
	// _xZkqqHx_iDhAiDfIiCmJiInJiPoNiCkKiCkAiCoKiCmOiBeBiDeHiDiJiBfLiCpAjFnEiClHiBeC_xHqqkZx_
	if (errCode != 0) return errCode;
//----- 06.03.12 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiCpAiNoNiPjMiBeC_xHqqkZx_
	if (!FFRecursiveRemoveDirectory(wcpTopDirPath))
		return IDS_DYSR_ERR_FILE_ACCESS_DENIED;
	else
		return 0;
} // FCDbServer::DeleteTopGroup.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDbServer::IsRecoveryRequired
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiDgHiDgCiDhGiDePiDiLiBfLiDhGiCkKiDiKiDeKiDgPiDiKiBfLiCpAjFeLjHhGiCmGiClFiCmEiCkCiCoJiCkJjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpTopDirPath	:_xZkqqHx_iDgHiDgCiDhGiDePiDiLiBfLiDhGiCmMiDhAiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiKiDeKiDgPiDiKiBfLiCkKjFeLjHhGiCmIiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	.rcv _xZkqqHx_iDhEiDeAiDeDiDiLiCkKiOgDiCmBiCmEiCkCiCmEiBeBiKiOiCmC_xHqqkZx_OPEN_xZkqqHx_iJmCjEfMiCmIiPoKiNiHiBeBjBePiJpBiCmMiDhEiDiJiDgCiDfGiDiFiCkK_xHqqkZx_
 *			_xZkqqHx_iOlIjEhDiCmJiPeJiCoNiCmBiClNiCmGiNgMiCkGiCoHiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCmMiCoGiCkEiCmIiPoKiNiHiCmNiDiKiDeKiDgPiDiKiBfLiCkKjFeLjHhGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCDbServer::IsRecoveryRequired (const wchar_t* wcpTopDirPath) const
{
//----- 06.03.11 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_iJpBjFjMiDhEiDeAiDeDiDiLiCkKjBlGiNnNiClHiCoJiCkJiBeI_xHqqkZx_
//	BOOL bRecoverExist = FALSE;
//	// _xZkqqHx_iJpBjFjMiDhEiDeAiDeDiDiLjHhAiDgGiDeCiDiMiDeOiDgHiDiKiCpAiNoMjAkMiBeC_xHqqkZx_
//	const WString wstrRecoverDir = WString(wcpTopDirPath) + L'\\' + FDTBL_RECOVER_DIR_NAME;
//	// _xZkqqHx_iJpBjFjMiDhEiDeAiDeDiDiLjHhAiDgGiDeCiDiMiDeOiDgHiDiKiCpAiMjPiNpFiClFiBeBiJpBjFjMiDhEiDeAiDeDiDiLiCkKiOgDiCmBiCmEiCkCiCmIiCkCiCkJjClCiCnHiCoJiBeC_xHqqkZx_
//	WIN32_FIND_DATA findData;
//	HANDLE hDir = FindFirstFile(WStrToTStr(wstrRecoverDir + L"\\*" + FDTBL_RECOVER_FILE_EXT), &findData);
//	if (hDir != INVALID_HANDLE_VALUE)
//	//----- _xZkqqHx_iIoKiCmCiCmFiCoAiJpBjFjMiDhEiDeAiDeDiDiLiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
//	{
//		do
//		{
//			// _xZkqqHx_iMjPiNpFiClDiCoKiClNiJpBjFjMiDhEiDeAiDeDiDiLjGlMiBeC_xHqqkZx_
//			const WString wstrFileName = wstrRecoverDir + L'\\' + (const wchar_t*)TStrToWStr(findData.cFileName);
//			FCFile32 file;
//			if (file.Open(wstrFileName, GENERIC_READ, FILE_SHARE_READ, OPEN_EXISTING))
//			//----- _xZkqqHx_iJpBjFjMiDhEiDeAiDeDiDiLiCkKiDeJiBfLiDhGiDjDiJmCjEfMiCmIiPoKiNiH_xHqqkZx_ -----
//			{
//				// _xZkqqHx_iMlLiNnNiDhEiDiJiDgCiDfGiDiFiNoMiLmGjCiGiCmMiPoKiNiHiCmNiBeBiJpBjFjMiDhEiDeAiDeDiDiLiCmNiDfGiDeGiDeBiCmFiCkLiCmIiCkCiCmNiClIiBeC_xHqqkZx_
//				// _xZkqqHx_iPfNiCmBiCmEiBeBiDhEiDiJiDgCiDfGiDiFiCmJiOlIjEhDiClFiClNiDfAiBfLiDfIiCmMiJpBjFjMiDhEiDeAiDeDiDiLiCmGjElLjCgGiBeC_xHqqkZx_
//				bRecoverExist = TRUE;
//				// _xZkqqHx_iDhEiDeAiDeDiDiLiCpAjFmCiClGiCoJiBeC_xHqqkZx_
//				file.Close();
//			}
//		} while (!bRecoverExist && FindNextFile(hDir, &findData));
//		FindClose(hDir);
//	}
//	// _xZkqqHx_iJpBjFjMiDhEiDeAiDeDiDiLiCkKjBlGiNnNiClHiCoJiCkJiBeI_xHqqkZx_
//	return bRecoverExist;
//----- 06.03.11 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_iJpBjFjMiDhEiDeAiDeDiDiLiCkKjBlGiNnNiClHiCoJiCkJiBeI_xHqqkZx_
	BOOL bRecoverExist = FALSE;
	// _xZkqqHx_iJpBjFjMiDhEiDeAiDeDiDiLjHhAiDgGiDeCiDiMiDeOiDgHiDiKiCpAiNoMjAkMiBeC_xHqqkZx_
	const WString wstrRecoverDir = WString(wcpTopDirPath) + L'\\' + FDTBL_RECOVER_DIR_NAME;
	WStringVector vFileName;	// _xZkqqHx_jClMiJlKiCmMiDhEiDeAiDeDiDiLjGlMiIoKjHjHiBeC_xHqqkZx_
	// _xZkqqHx_iJpBjFjMiDhEiDeAiDeDiDiLjHhAiDgGiDeCiDiMiDeOiDgHiDiKiCpAiMjPiNpFiClFiBeBiJpBjFjMiDhEiDeAiDeDiDiLiCkKiOgDiCmBiCmEiCkCiCmIiCkCiCkJjClCiCnHiCoJiBeC_xHqqkZx_
	FFEnumDirectoryFile(WStringVector(), vFileName, wstrRecoverDir + L"\\*" + FDTBL_RECOVER_FILE_EXT);
	WStringVector::const_iterator iStr;
	for (iStr = vFileName.begin();
		 !bRecoverExist && iStr != vFileName.end(); iStr++)
	{
		// _xZkqqHx_iMjPiNpFiClDiCoKiClNiJpBjFjMiDhEiDeAiDeDiDiLjGlMiBeC_xHqqkZx_
		const WString wstrFileName = wstrRecoverDir + L'\\' + *iStr;
		FCFile32 file;
		if (file.Open(wstrFileName, GENERIC_READ, FILE_SHARE_READ, OPEN_EXISTING))
		//----- _xZkqqHx_iJpBjFjMiDhEiDeAiDeDiDiLiCkKiDeJiBfLiDhGiDjDiJmCjEfMiCmIiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iMlLiNnNiDhEiDiJiDgCiDfGiDiFiNoMiLmGjCiGiCmMiPoKiNiHiCmNiBeBiJpBjFjMiDhEiDeAiDeDiDiLiCmNiDfGiDeGiDeBiCmFiCkLiCmIiCkCiCmNiClIiBeC_xHqqkZx_
			// _xZkqqHx_iPfNiCmBiCmEiBeBiDhEiDiJiDgCiDfGiDiFiCmJiOlIjEhDiClFiClNiDfAiBfLiDfIiCmMiJpBjFjMiDhEiDeAiDeDiDiLiCmGjElLjCgGiBeC_xHqqkZx_
			bRecoverExist = TRUE;
			// _xZkqqHx_iDhEiDeAiDeDiDiLiCpAjFmCiClGiCoJiBeC_xHqqkZx_
			file.Close();
		}
	}
	// _xZkqqHx_iJpBjFjMiDhEiDeAiDeDiDiLiCkKjBlGiNnNiClHiCoJiCkJiBeI_xHqqkZx_
	return bRecoverExist;
//----- 06.03.11 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCDbServer::IsRecoveryRequired.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDbServer::IsTopGroupExist
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgHiDgCiDhGiDePiDiLiBfLiDhGiCmMiDgGiDeCiDiMiDeOiDgHiDiKiCkKjBlGiNnNiClHiCoJiCkJiCmHiCkEiCkJjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpTopDirPath	:_xZkqqHx_iDgHiDgCiDhGiDePiDiLiBfLiDhGiCmMiDhAiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jBlGiNnNiClHiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCDbServer::IsTopGroupExist (const wchar_t* wcpTopDirPath) const
{
	return (FFIsThereFile(wcpTopDirPath) != FD_FILE_NOT_EXIST);
} // FCDbServer::IsTopGroupExist.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDbServer::GetLastModifiedFdtime
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgFiBfLiDhFiDiLiCkKiNmFiMoDiCmJiPeDjAlDiClDiCoKiClNiOjOiKnEiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dsTableName	:_xZkqqHx_iDgFiBfLiDhFiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iNmFiMoDiCmJiPeDjAlDiClDiCoKiClNiOjOiKnEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FDTIME FCDbServer::GetLastModifiedFdtime (const DsTableName& dsTableName) const
{
	FDTIME fdtmWriteTime;
	if (FCFile32(	FFGetFilePath(FCTableName(dsTableName)) + FDTBL_DATA_FILE_EXT,
					GENERIC_READ, FILE_SHARE_READ,
					OPEN_EXISTING).GetFileTime(NULL, NULL, &fdtmWriteTime))
		return fdtmWriteTime;
	else
		return 0;
} // FCDbServer::GetLastModifiedFdtime.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDbServer::OnDlgOpenDirectory
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgHiDgCiDhGiDePiDiLiBfLiDhGiCpAiNoMjAkMiClHiCoJiClNiCnPiCmMiBeBiDgGiDeCiDiMiDeOiDgHiDiKiCpAjBeJjBpAiClHiCoJ_xHqqkZx_
 *			_xZkqqHx_iDhEiDeIiDiLiDfPiDfPiDeDiDeBiDiNiDePiCpAjFfMiOkGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dsDirPath		:_xZkqqHx_jBeJjBpAiClDiCoKiClNiDgGiDeCiDiMiDeOiDgHiDiKiCmMiDhAiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *			hwndParent		:_xZkqqHx_jAgFiDeFiDeCiDjDiDgIiDeFiCpAiOhHjCoIiBeC_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiClHiCoJiCmG_xHqqkZx_
 *							 _xZkqqHx_iDhEiDeIiDeBiDePiDiJiDeFiDjDiDgIiCmMiDeFiDeCiDjDiDgIiDeFiCkKjBeJiCmOiCoKiCoJiBeC_xHqqkZx_
 *			wcpInitPath		:_xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiDhAiDfIiCmMiPiJiKpKjCgMiCpAjAnNjCoIiBeC_xHqqkZx_
 *			pCtrlIdArray	:_xZkqqHx_iDfPiDeDiDeBiDiNiDePiPoDiCmMiDfCiDjDiDgHiDiNiBfLiDiLiCmMiCkEiClPiBeB_xHqqkZx_
 *							 _xZkqqHx_jFfMiOkGiDgFiDeMiDfIiDgHiCpAjChFiCkLiKlHiCkGiClNiCkCiDfCiDjDiDgHiDiNiBfLiDiLiCmM_xHqqkZx_
 *							 ID_xZkqqHx_jEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pCtrlTextArray	:pCtrlIdArray_xZkqqHx_iCmFiOhHjCoIiClDiCoKiClNiDfCiDjDiDgHiDiNiBfLiDiLiCmJ_xHqqkZx_
 *							 _xZkqqHx_jAnNjCoIiClHiCoJiDgFiDeMiDfIiDgHiCmMjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			szCtrlTextCount	:pCtrlIdArray_xZkqqHx_jEhKjHpBiCmMiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfPiDeDiDeBiDiNiDePiCmMiMiLiJmKiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DWORD FCDbServer::OnDlgOpenDirectory (	DsString& dsDirPath,
										HWND hwndParent,
										const wchar_t* wcpInitPath,
										const DWORD* pCtrlIdArray,
										const wchar_t** pCtrlTextArray,
										size_t szCtrlTextCount) const
{
	if (IsFlushing()) FFThrowMiscUnknown();

	// _xZkqqHx_iClBiClBiCmFiDhEiDeIiDeBiDePiDiJiDeFiDjDiDgIiDeFiDeCiDjDiDgIiDeFiCpAjAnNjCoIiClFiCmIiCkCiCmGiBeB_xHqqkZx_
	// _xZkqqHx_iDhNiDeFiDfIiBeFiDeMiBfLiDeDiDhIiDjDiDgHiCpAiDhKiBfLiDiLiDgIiCmFiCkLiCmIiCkCiBeC_xHqqkZx_
	if (hwndParent == NULL)
		hwndParent = GetForegroundWindow();

	// _xZkqqHx_iDfPiDeDiDeBiDiNiDePiCmJjDgOiClHiDgGiBfLiDfOiBeC_xHqqkZx_
	struct _UserParam {
		tcstring			m_strInitPath;
		map<DWORD, WString> m_mpIdToText;
	} userParam;
	// _xZkqqHx_iDfPiDeDiDeBiDiNiDePjFfMiOkGiOjOiCmMiDhAiDfIiCpAjAnNjCoIiBeC_xHqqkZx_
	userParam.m_strInitPath = (wcpInitPath != NULL) ?
							(const _TCHAR*)WStrToTStr(wcpInitPath) : _T("");
	// _xZkqqHx_iDfPiDeDiDeBiDiNiDePiCmMiDfCiDjDiDgHiDiNiBfLiDiLiCmMiDgFiDeMiDfIiDgHiCpAjAnNjCoIiBeC_xHqqkZx_
	for (size_t n = 0; n != szCtrlTextCount; n++)
		userParam.m_mpIdToText[pCtrlIdArray[n]] = pCtrlTextArray[n];

// SDK_xZkqqHx_iCmM_xHqqkZx_ShlObj.h_xZkqqHx_iCoGiCoIiBeC_xHqqkZx_
#ifndef BIF_NEWDIALOGSTYLE
#define BIF_NEWDIALOGSTYLE 0x0040	// _xZkqqHx_iKgHjCkDiDhEiDeIiDiLiDfPiBfLiDhLiDgCiDeOiDfIiBeC_xHqqkZx_
#define BIF_EDITBOX        0x0010   // Add an editbox to the dialog
#endif// BIF_NEWDIALOGSTYLE

	// SHBrowseForFolder _xZkqqHx_iCmFiBeB_xHqqkZx_BIF_NEWDIALOGSTYLE_xZkqqHx_iCpAiOgHiCkEiClNiCnPiCmJjFeLjHhGiCmIiPiJiKpKiJlLiBeC_xHqqkZx_
	OleInitialize(NULL);
	//----- _xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKjBeJjBpAiDfPiDeDiDeBiDiNiDePjFfMiOkGjHhAiCmJiNfMjBkCjBmMiCpAjAnNjCoI_xHqqkZx_ -----
	BROWSEINFO bi;
	_TCHAR ach[_MAX_PATH * 4];
	bi.hwndOwner	= hwndParent;
	bi.pidlRoot		= NULL;
	bi.pszDisplayName = NULL;
	bi.lpszTitle	= NULL;
	// _xZkqqHx_jCiNiBgK_xHqqkZx_BIF_STATUSTEXT_xZkqqHx_iCmNiBeB_xHqqkZx_BIF_NEWDIALOGSTYLE_xZkqqHx_iOhHjCoIiOjOiCmNiDfEiDhMiBfLiDgHiClFiCmIiCkCiBeC_xHqqkZx_
	bi.ulFlags		= BIF_RETURNONLYFSDIRS | BIF_NEWDIALOGSTYLE | BIF_EDITBOX;
	bi.lpfn			= myBrowseCallbackProc;
	bi.lParam		= LPARAM(&userParam);
	bi.iImage		= 0;
	// _xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKjBeJjBpAiDfPiDeDiDeBiDiNiDePiCpAjFfMiOkGiBeC_xHqqkZx_
	LPITEMIDLIST pidl = SHBrowseForFolder(&bi);
	if (pidl)
	{
		// _xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKjGlMiCpAiOoGjDlOiBeC_xHqqkZx_
		SHGetPathFromIDList(pidl, ach);
		// Get the shell's allocator to free PIDLs
		LPMALLOC lpMalloc;
		if (!SHGetMalloc(&lpMalloc) && (lpMalloc != NULL))
		{
			lpMalloc->Free(pidl);
			lpMalloc->Release();
		}
		dsDirPath = (const wchar_t*)TStrToWStr(ach);
	}
	// OleInitialize_xZkqqHx_iCmMiPeJjHlJiPiIjHjNiBeC_xHqqkZx_
	OleUninitialize();
	return pidl ? IDOK : IDCANCEL;
} // FCDbServer::OnDlgOpenDirectory.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDbServer::OnDlgSaveTopGroup
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgHiDgCiDhGiDePiDiLiBfLiDhGiCpAjFnLjBlGiClHiCoJiClNiCnPiCmMiDhEiDeAiDeDiDiLiDfPiDeDiDeBiDiNiDePiCpAjFfMiOkGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dstrTopGroupPath:_xZkqqHx_jBeJjBpAiClDiCoKiClNiDgHiDgCiDhGiDePiDiLiBfLiDhGiCmMiDgGiDeCiDiMiDeOiDgHiDiKiCmM_xHqqkZx_
 *							 _xZkqqHx_iDhAiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *			hwndParent		:_xZkqqHx_jAgFiDeFiDeCiDjDiDgIiDeFiCpAiOhHjCoIiBeC_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiClHiCoJiCmG_xHqqkZx_
 *							 _xZkqqHx_iDhEiDeIiDeBiDePiDiJiDeFiDjDiDgIiCmMiDeFiDeCiDjDiDgIiDeFiCkKjBeJiCmOiCoKiCoJiBeC_xHqqkZx_
 *			wcpDlgTitle		:_xZkqqHx_iDfPiDeDiDeBiDiNiDePiCmMiDfOiDeDiDgHiDiLjFlGiOjKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpInitPath		:_xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiDhAiDfIiCmMiPiJiKpKjCgMiCpAjAnNjCoIiBeC_xHqqkZx_
 *			wcpDocumentType	:_xZkqqHx_iDhEiDeAiDeDiDiLiDfPiDeDiDeBiDiNiDePiCmJjFfMiOkGiClDiCoKiCoJiDhEiDeCiDiLiDfOiPoOjFpBiCmM_xHqqkZx_
 *							 _xZkqqHx_iDfOiDeDiDhGjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpExt			:_xZkqqHx_iDhEiDeAiDeDiDiLiDfPiDeDiDeBiDiNiDePiCmJjFfMiOkGiClDiCoKiCoJiDhEiDeCiDiLiDfOiPoOjFpBiCmM_xHqqkZx_
 *							 _xZkqqHx_iDhEiDeAiDeDiDiLiKgHjCkDiOhBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pCtrlIdArray	:_xZkqqHx_iDfPiDeDiDeBiDiNiDePiPoDiCmMiDfCiDjDiDgHiDiNiBfLiDiLiCmMiCkEiClPiBeB_xHqqkZx_
 *							 _xZkqqHx_jFfMiOkGiDgFiDeMiDfIiDgHiCpAjChFiCkLiKlHiCkGiClNiCkCiDfCiDjDiDgHiDiNiBfLiDiLiCmM_xHqqkZx_
 *							 ID_xZkqqHx_jEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pCtrlTextArray	:pCtrlIdArray_xZkqqHx_iCmFiOhHjCoIiClDiCoKiClNiDfCiDjDiDgHiDiNiBfLiDiLiCmJ_xHqqkZx_
 *							 _xZkqqHx_jAnNjCoIiClHiCoJiDgFiDeMiDfIiDgHiCmMjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			szCtrlTextCount	:pCtrlIdArray_xZkqqHx_jEhKjHpBiCmMiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bIsJustifyWindow:_xZkqqHx_iDeFiDeCiDjDiDgIiDeFiImKjChFiCpAjFoCjAlDiClHiCoJiCkJiCmHiCkEiCkJiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfPiDeDiDeBiDiNiDePiCmMiMiLiJmKiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DWORD FCDbServer::OnDlgSaveTopGroup (	DsString& dstrTopGroupPath,
										HWND hwndParent,
										const wchar_t* wcpDlgTitle,
										const wchar_t* wcpInitPath,
										const wchar_t* wcpDocumentType,
										const wchar_t* wcpExt,
										const DWORD* pCtrlIdArray,
										const wchar_t** pCtrlTextArray,
										size_t szCtrlTextCount,
										BOOL bIsJustifyWindow) const
{
	if (IsFlushing()) FFThrowMiscUnknown();
	DWORD dwFlags = OFN_HIDEREADONLY | OFN_EXPLORER;
	// _xZkqqHx_iDhEiDeCiDiLiDfOiBfLjFlGiOjKjHpBiCpAiNoMjAkMiBeC_xHqqkZx_
	WString wstrFilter;
	wstrFilter.Format(L"%s (*%s)|*%s||", wcpDocumentType, wcpExt, wcpExt);
	// _xZkqqHx_iDhEiDeAiDeDiDiLiDhAiDfIiPiJiKpKjCgMiBeC_xHqqkZx_
	WString wstrInitFilePath = wcpInitPath;
	// _xZkqqHx_iDfPiDeDiDeBiDiNiDePjFjMiLeBjCgMiBeC_xHqqkZx_
	DWORD dwRet;
	for (;;)
	{
//----- 06.04.20 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//		if (FFVersionInfo().dwPlatformId == VER_PLATFORM_WIN32_NT)
//		//----- WindowsNT_xZkqqHx_iMgOiCmMiPoKiNiH_xHqqkZx_ ------
//		{
//----- 06.04.20 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
			// _xZkqqHx_iDhEiDeAiDeDiDiLiDfPiDeDiDeBiDiNiDePiCpAjFfMiOkGiBeC_xHqqkZx_
			FCFdbProjectDialog dlg(	FALSE,
									NULL,
									wstrInitFilePath,
									dwFlags,
									wstrFilter,
									L"0.ddtb",
									hwndParent,
									wcpDlgTitle,
									pCtrlIdArray,
									pCtrlTextArray,
									szCtrlTextCount,
									bIsJustifyWindow);
			// _xZkqqHx_iDhEiDeAiDeDiDiLiDfPiDeDiDeBiDiNiDePiCpAjFfMiOkGiBeC_xHqqkZx_
			dwRet = dlg.DoModal();
			// OK_xZkqqHx_iImIiKePiCmIiCoHiCmOiPeJjHlJiBeC_xHqqkZx_
			if (dwRet != IDOK) break;
			// _xZkqqHx_iDhEiDeAiDeDiDiLiDhAiDfIiCpAjAnNjCoIiBeC_xHqqkZx_
			wstrInitFilePath = dlg.GetPathName();
//----- 06.04.20 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//		} else
//		//----- Windows95_xZkqqHx_iMgOiCmMiPoKiNiH_xHqqkZx_ -----
//		{
//			// _xZkqqHx_iDhEiDeAiDeDiDiLiDfPiDeDiDeBiDiNiDePiCpAjFfMiOkGiBeC_xHqqkZx_
//			FCDbFileDialog dlg(	FALSE,
//								NULL,
//								wstrInitFilePath,
//								dwFlags,
//								wstrFilter,
//								hwndParent,
//								wcpDlgTitle,
//								pCtrlIdArray,
//								pCtrlTextArray,
//								szCtrlTextCount,
//								bIsJustifyWindow);
//			// _xZkqqHx_iDhEiDeAiDeDiDiLiDfPiDeDiDeBiDiNiDePiCpAjFfMiOkGiBeC_xHqqkZx_
//			dwRet = dlg.DoModal();
//			// OK_xZkqqHx_iImIiKePiCmIiCoHiCmOiPeJjHlJiBeC_xHqqkZx_
//			if (dwRet != IDOK) break;
//			// _xZkqqHx_iDhEiDeAiDeDiDiLiDhAiDfIiCpAjAnNjCoIiBeC_xHqqkZx_
//			wstrInitFilePath = dlg.GetPathName();
//		}
//----- 06.04.20 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

		// OK_xZkqqHx_iCmMiPoKiNiHiCmNiBeBiDhEiDeAiDeDiDiLjClHiCpAiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
		// _xZkqqHx_iDhEiDeAiDeDiDiLjClHiCkK_xHqqkZx_ _xZkqqHx_iNmFjBoFjCgM_xHqqkZx_ FD_MAX_PROJECT_PATH _xZkqqHx_jGkCjGjOiCmIiCoHiCmOiPeJjHlJiBeC_xHqqkZx_
		if (wstrInitFilePath.GetLength() < FD_MAX_PROJECT_PATH)
		{
			dstrTopGroupPath = (const wchar_t*)wstrInitFilePath;
			break;
		}
		// _xZkqqHx_iDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiCpAjFfMiOkGiBeC_xHqqkZx_
		// IDS_DYSR_ERR_FILE_PATH_TOO_LONG "_xZkqqHx_iDhEiDeAiDeDiDiLiCmMiDhAiDfIiCkKjClHiClHiCkMiCnMiClHiBeC_xHqqkZx_"
		FFMessageBox(FFLoadWString(IDS_DYSR_ERR_FILE_PATH_TOO_LONG));
//----- 06.04.16 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//		// _xZkqqHx_iDhEiDeAiDeDiDiLiDhAiDfIiPiJiKpKjCgMiCpAjAnNjCoIiClFiCmEiBeBiNmEiCnBiDfPiDeDiDeBiDiNiDePiCpAiKeKiCkNiBeC_xHqqkZx_
//		wstrInitFilePath = dlg.GetPathName();
//----- 06.04.16 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	}
	// _xZkqqHx_iDfPiDeDiDeBiDiNiDePjFjMiLeBjCgMiBeC_xHqqkZx_
	return dwRet;
} // FCDbServer::OnDlgSaveTopGroup.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDbServer::OnDlgOpenTopGroup
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgHiDgCiDhGiDePiDiLiBfLiDhGiCpAiKeKiCkNiClNiCnPiCmMiDhEiDeAiDeDiDiLiDfPiDeDiDeBiDiNiDePiCpAjFfMiOkGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dstrTopGroupPath:_xZkqqHx_jBeJjBpAiClDiCoKiClNiDgHiDgCiDhGiDePiDiLiBfLiDhGiCmMiDgGiDeCiDiMiDeOiDgHiDiKiCmM_xHqqkZx_
 *							 _xZkqqHx_iDhAiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *			hwndParent		:_xZkqqHx_jAgFiDeFiDeCiDjDiDgIiDeFiCpAiOhHjCoIiBeC_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiClHiCoJiCmG_xHqqkZx_
 *							 _xZkqqHx_iDhEiDeIiDeBiDePiDiJiDeFiDjDiDgIiCmMiDeFiDeCiDjDiDgIiDeFiCkKjBeJiCmOiCoKiCoJiBeC_xHqqkZx_
 *			wcpDlgTitle		:_xZkqqHx_iDfPiDeDiDeBiDiNiDePiCmMiDfOiDeDiDgHiDiLjFlGiOjKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpFilePath		:_xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiDhAiDfIiCmMiPiJiKpKjCgMiCpAjAnNjCoIiBeC_xHqqkZx_
 *			wcpDocumentType	:_xZkqqHx_iDhEiDeAiDeDiDiLiDfPiDeDiDeBiDiNiDePiCmJjFfMiOkGiClDiCoKiCoJiDhEiDeCiDiLiDfOiPoOjFpBiCmM_xHqqkZx_
 *							 _xZkqqHx_iDfOiDeDiDhGjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpExt			:_xZkqqHx_iDhEiDeAiDeDiDiLiDfPiDeDiDeBiDiNiDePiCmJjFfMiOkGiClDiCoKiCoJiDhEiDeCiDiLiDfOiPoOjFpBiCmM_xHqqkZx_
 *							 _xZkqqHx_iDhEiDeAiDeDiDiLiKgHjCkDiOhBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pCtrlIdArray	:_xZkqqHx_iDfPiDeDiDeBiDiNiDePiPoDiCmMiDfCiDjDiDgHiDiNiBfLiDiLiCmMiCkEiClPiBeB_xHqqkZx_
 *							 _xZkqqHx_jFfMiOkGiDgFiDeMiDfIiDgHiCpAjChFiCkLiKlHiCkGiClNiCkCiDfCiDjDiDgHiDiNiBfLiDiLiCmM_xHqqkZx_
 *							 ID_xZkqqHx_jEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pCtrlTextArray	:pCtrlIdArray_xZkqqHx_iCmFiOhHjCoIiClDiCoKiClNiDfCiDjDiDgHiDiNiBfLiDiLiCmJ_xHqqkZx_
 *							 _xZkqqHx_jAnNjCoIiClHiCoJiDgFiDeMiDfIiDgHiCmMjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			szCtrlTextCount	:pCtrlIdArray_xZkqqHx_jEhKjHpBiCmMiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bIsJustifyWindow:_xZkqqHx_iDeFiDeCiDjDiDgIiDeFiImKjChFiCpAjFoCjAlDiClHiCoJiCkJiCmHiCkEiCkJiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfPiDeDiDeBiDiNiDePiCmMiMiLiJmKiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DWORD FCDbServer::OnDlgOpenTopGroup (	DsString& dstrTopGroupPath,
										HWND hwndParent,
										const wchar_t* wcpDlgTitle,
										const wchar_t* wcpFilePath,
										const wchar_t* wcpDocumentType,
										const wchar_t* wcpExt,
										const DWORD* pCtrlIdArray,
										const wchar_t** pCtrlTextArray,
										size_t szCtrlTextCount,
										BOOL bIsJustifyWindow) const
{
	if (IsFlushing()) FFThrowMiscUnknown();
	const DWORD dwFlags = OFN_HIDEREADONLY | OFN_EXPLORER;
	// _xZkqqHx_iDfPiDeDiDeBiDiNiDePjFjMiLeBjCgMiBeC_xHqqkZx_
	DWORD dwRet;

//----- 06.04.20 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	if (FFVersionInfo().dwPlatformId == VER_PLATFORM_WIN32_NT)
//	//----- WindowsNT_xZkqqHx_iMgOiCmMiPoKiNiH_xHqqkZx_ ------
//	{
//----- 06.04.20 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
		// _xZkqqHx_iDhEiDeCiDiLiDfOiBfLjFlGiOjKjHpBiCpAiNoMjAkMiBeC_xHqqkZx_
		WString wstrFilter;
		wstrFilter.Format(L"%s (*%s)|*%s||", wcpDocumentType, wcpExt, wcpExt);
		// _xZkqqHx_iDhEiDeAiDeDiDiLiDhAiDfIiPiJiKpKjCgMiBeC_xHqqkZx_
		WString wstrInitFilePath = wcpFilePath;
		for (;;)
		{
			// _xZkqqHx_iDhEiDeAiDeDiDiLiDfPiDeDiDeBiDiNiDePiCpAjFfMiOkGiBeC_xHqqkZx_
			FCFdbProjectDialog dlg(	TRUE,
									NULL,
									wstrInitFilePath,
									dwFlags,
									wstrFilter,
									L"0.ddtb",
									hwndParent,
									wcpDlgTitle,
									pCtrlIdArray,
									pCtrlTextArray,
									szCtrlTextCount,
									bIsJustifyWindow);
			// _xZkqqHx_iDhEiDeAiDeDiDiLiDfPiDeDiDeBiDiNiDePiCpAjFfMiOkGiBeC_xHqqkZx_
			dwRet = dlg.DoModal();
			// OK_xZkqqHx_iImIiKePiCmIiCoHiCmOiPeJjHlJiBeC_xHqqkZx_
			if (dwRet != IDOK) break;
			// _xZkqqHx_iDhEiDeAiDeDiDiLiDhAiDfIiCpAjAnNjCoIiBeC_xHqqkZx_
			wstrInitFilePath = dlg.GetPathName();
			// OK_xZkqqHx_iCmMiPoKiNiHiCmNiBeBiDhEiDeAiDeDiDiLjClHiCpAiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
			// _xZkqqHx_iDhEiDeAiDeDiDiLjClHiCkK_xHqqkZx_ _xZkqqHx_iNmFjBoFjCgM_xHqqkZx_ FD_MAX_PROJECT_PATH _xZkqqHx_jGkCjGjOiCmIiCoHiCmOiPeJjHlJiBeC_xHqqkZx_
			if (wstrInitFilePath.GetLength() < FD_MAX_PROJECT_PATH)
			{
				dstrTopGroupPath = (const wchar_t*)wstrInitFilePath;
				break;
			}
			// _xZkqqHx_iDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiCpAjFfMiOkGiBeC_xHqqkZx_
			// IDS_DYSR_ERR_FILE_PATH_TOO_LONG "_xZkqqHx_iDhEiDeAiDeDiDiLiCmMiDhAiDfIiCkKjClHiClHiCkMiCnMiClHiBeC_xHqqkZx_"
			FFMessageBox(FFLoadWString(IDS_DYSR_ERR_FILE_PATH_TOO_LONG));
//----- 06.04.17 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//			// _xZkqqHx_iDhEiDeAiDeDiDiLiDhAiDfIiPiJiKpKjCgMiCpAjAnNjCoIiClFiCmEiBeBiNmEiCnBiDfPiDeDiDeBiDiNiDePiCpAiKeKiCkNiBeC_xHqqkZx_
//			wstrInitFilePath = dlg.GetPathName();
//----- 06.04.17 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
		}
//----- 06.04.20 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	} else
//	//----- Windows95_xZkqqHx_iMgOiCmMiPoKiNiH_xHqqkZx_ -----
//	{
//		// _xZkqqHx_iDhEiDeCiDiLiDfOiBfLjFlGiOjKjHpBiCpAiNoMjAkMiBeC_xHqqkZx_
//		WString wstrFilter;
//		wstrFilter.Format(L"%s (.ddtb)|.ddtb||", wcpDocumentType);
//		// _xZkqqHx_iDhEiDeAiDeDiDiLiDhAiDfIiPiJiKpKjCgMiBeC_xHqqkZx_
//		WString wstrInitFilePath = wcpFilePath;
//		if (wstrInitFilePath.CompareTailNoCase(wcpExt) == 0)
//			wstrInitFilePath = FFGetFileDirectory(wcpFilePath, FALSE) + L"*.ddtb";
//		for (;;)
//		{
//			// _xZkqqHx_iDhEiDeAiDeDiDiLiDfPiDeDiDeBiDiNiDePiCpAjFfMiOkGiBeC_xHqqkZx_
//			FCDbFileDialog dlg(	TRUE,
//								NULL,
//								wstrInitFilePath,
//								dwFlags,
//								wstrFilter,
//								hwndParent,
//								wcpDlgTitle,
//								pCtrlIdArray,
//								pCtrlTextArray,
//								szCtrlTextCount,
//								bIsJustifyWindow);
//			// _xZkqqHx_iDhEiDeAiDeDiDiLiDfPiDeDiDeBiDiNiDePiCpAjFfMiOkGiBeC_xHqqkZx_
//			dwRet = dlg.DoModal();
//			// OK_xZkqqHx_iImIiKePiCmIiCoHiCmOiPeJjHlJiBeC_xHqqkZx_
//			if (dwRet != IDOK) break;
//			// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDgGiDeCiDiMiDeOiDgHiDiKiCpAiOoGjDlOiBeC_xHqqkZx_
//			wstrInitFilePath = FFTableToTopDirPath(dlg.GetPathName());
//			// OK_xZkqqHx_iCmMiPoKiNiHiCmNiBeBiDhEiDeAiDeDiDiLjClHiCpAiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
//			// _xZkqqHx_iDhEiDeAiDeDiDiLjClHiCkK_xHqqkZx_ _xZkqqHx_iNmFjBoFjCgM_xHqqkZx_ FD_MAX_PROJECT_PATH _xZkqqHx_jGkCjGjOiCmIiCoHiCmOiPeJjHlJiBeC_xHqqkZx_
//			if (wstrInitFilePath.GetLength() < FD_MAX_PROJECT_PATH)
//			{
//				dstrTopGroupPath = (const wchar_t*)wstrInitFilePath;
//				break;
//			}
//			// _xZkqqHx_iDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiCpAjFfMiOkGiBeC_xHqqkZx_
//			// IDS_DYSR_ERR_FILE_PATH_TOO_LONG "_xZkqqHx_iDhEiDeAiDeDiDiLiCmMiDhAiDfIiCkKjClHiClHiCkMiCnMiClHiBeC_xHqqkZx_"
//			FFMessageBox(FFLoadWString(IDS_DYSR_ERR_FILE_PATH_TOO_LONG));
////----- 06.04.17 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////			// _xZkqqHx_iDhEiDeAiDeDiDiLiDhAiDfIiPiJiKpKjCgMiCpAjAnNjCoIiClFiCmEiBeBiNmEiCnBiDfPiDeDiDeBiDiNiDePiCpAiKeKiCkNiBeC_xHqqkZx_
////			wstrInitFilePath = dlg.GetPathName();
////----- 06.04.17 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//		}
//	}
//----- 06.04.20 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_iDfPiDeDiDeBiDiNiDePjFjMiLeBjCgMiBeC_xHqqkZx_
	return dwRet;
} // FCDbServer::OnDlgOpenTopGroup.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDbServer::TerminateFlushThread
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDiJiDgCiDfGiDiFiDfIiDiMiDgCiDgIiCpAiLkNjAkHiPeJjHlJiClDiClJiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iLkNjAkHiPeJjHlJiClFiClNiPoKiNiHiCmNiDiBiDiCiDiKiBfLiDiKiBfLiDeOjDjJiDeHiDiJiBfLiCkKjEkNjAlGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDbServer::TerminateFlushThread ()
{
	td_readwrite td_rw(m_csaThreadData);
	if (td_rw->m_hFlushThreadHandle != INVALID_HANDLE_VALUE)
	//----- _xZkqqHx_iDhEiDiJiDgCiDfGiDiFiDfIiDiMiDgCiDgIiOmAiNhDjCiGiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDfIiDiMiDgCiDgIiPeJjHlJjHhGiLiBiCkKiCkAiCoJiCkJiBeI_xHqqkZx_
		td_rw->m_bIsTerminate = TRUE;
		// _xZkqqHx_iDfIiDiMiDgCiDgIiLoMjDkOiDeDiDhIiDjDiDgHiCpAiDfGiDePiDgJiDiLiPpDjBnEiCmJiBeC_xHqqkZx_PulseEvent _xZkqqHx_iClOiCmGiBeB_xHqqkZx_
		// WaitForSingleObject _xZkqqHx_iCmJjDpMiCmBiCmEiPkNiClFiOjOiKnEiCkKiMgPiClNiCmIiCkCiCmG_xHqqkZx_
		// _xZkqqHx_iCkEiCnMiCkNjDkOiNoMiClFiCmIiCkJiCmBiClNiBeC_xHqqkZx_
		SetEvent(td_rw->m_hThreadEvent);
	}
} // FCDbServer::TerminateFlushThread.

//----- 06.02.14 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDbServer::MakeUniqTmpTopGroupPath
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iIoKiOjOiDgGiDeCiDiMiDeOiDgHiDiKiBgJ_xHqqkZx_TMP_xZkqqHx_jDjJiBgKiCmMiJlKiCmFiBeBiDiGiDgKiBfLiDeOiCmIiDgHiDgCiDhGiDePiDiLiBfLiDhGiDhAiDfI_xHqqkZx_
// *			_xZkqqHx_iBgJiDgGiDeCiDiMiDeOiDgHiDiKjGlMiBgKiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dsTopGroupPath	:_xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiDhAiDfIiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iIoKiOjOiDgGiDeCiDiMiDeOiDgHiDiKiCmNiBeBiKmCiLkLjFmPjAjE_xHqqkZx_'MOLIPTMP' -> 'TMP' -> 'TEMP'
// *			_xZkqqHx_iCkJiCoHiDgGiDeCiDiMiDeOiDgHiDiKiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
// *			_xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKjGlMiNoMjAkMiCkJiCoHjHjIjHhAiClHiCoJiCnMiCmFiCmJiBeBjBlMiCmMiDeBiDhGiDiKiCkJiCoHjDkPiClG_xHqqkZx_
// *			_xZkqqHx_jGlMjBePiCmMiDhEiDeAiDeDiDiLiCkKiNoMjAkMiClDiCoKiCoJiClBiCmGiCoAjHeMiCoIjDlOiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCDbServer::MakeUniqTmpTopGroupPath (DsString& dsTopGroupPath) const
//{
//	WString wstrTopGroupPath;
//	FFMakeUniqTmpFileName(wstrTopGroupPath, L"_Dyn", L".tbl");
//	dsTopGroupPath = wstrTopGroupPath.c_str();
//} // FCDbServer::MakeUniqTmpTopGroupPath.
//----- 06.02.14 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDbServer::MakeUniqTopGroupPath
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDhAiDfIiCpAiMlDiCmJiBeBiDiGiDgKiBfLiDeOiCmIiDgHiDgCiDhGiDePiDiLiBfLiDhGiDhAiDfIjGlMiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dsTopGroupPath	:_xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiDhAiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *			wcpPath			:_xZkqqHx_iNoMjAkMiClHiCoJiMlDiCmGiCmIiCoJiDhAiDfIjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpExt			:_xZkqqHx_iKgHjCkDiOhBiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jHoBiBeG_xHqqkZx_wcpPath = "C:\TMP\HELLO", wcpExt = ".TXT"_xZkqqHx_iCmMiPoKiNiHiBeC_xHqqkZx_
 *				dsTopGroupPath = "C:\TMP\HELLO_1f.TXT"
 *
 *			_xZkqqHx_iClBiClBiCmFiCmNiBeBiDhEiDeAiDeDiDiLjClHiCpAiMjPiNlIiClFiCmIiCkCiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCmMjCgMiCpAiOgHiCkEiDeOiDiJiDeDiDeBiDjDiDgHjBkEiCmFjClCiNlIiClHiCoJjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDbServer::MakeUniqTopGroupPath (	DsString& dsTopGroupPath,
										const wchar_t* wcpPath,
										const wchar_t* wcpExt) const
{
	WString wstrTopGroupPath;
	FFMakeUniqFileName(wstrTopGroupPath, wcpPath, wcpExt);
	dsTopGroupPath = wstrTopGroupPath.c_str();
} // FCDbServer::MakeUniqTopGroupPath.

//----- 06.02.22 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDbServer::GetTmpDirectory
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	MakeUniqTmpTopGroupPath_xZkqqHx_iKnGjAjEiCmFiOgHiCoNiCoKiCoJiBeBiIoKiOjOiDgGiDeCiDiMiDeOiDgHiDiKiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dsDirPath	:_xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiDhAiDfIiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iIoKiOjOiDgGiDeCiDiMiDeOiDgHiDiKiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iIoKiOjOiDgGiDeCiDiMiDeOiDgHiDiKiCmNiBeBiKmCiLkLjFmPjAjE_xHqqkZx_'MOLIPTMP' -> 'TMP' -> 'TEMP'
// *			_xZkqqHx_iCkJiCoHiDgGiDeCiDiMiDeOiDgHiDiKiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCDbServer::GetTmpDirectory (DsString& dsDirPath) const
//{
//	dsDirPath = FFGetTmpDirectory().c_str();
//} // FCDbServer::GetTmpDirectory.
//----- 06.02.22 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDbServer::SetCurrentDirectory
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiDgGiDeCiDiMiDeOiDgHiDiKiCpAjAnNjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpDirPath	:_xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiDhAiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDbServer::SetCurrentDirectory (const wchar_t* wcpDirPath)
{
	FFSetCurrentDirectory(wcpDirPath);
} // FCDbServer::SetCurrentDirectory.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDbServer::GetCurrentDirectory
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiDgGiDeCiDiMiDeOiDgHiDiKiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dsDirPath	:_xZkqqHx_iMlLiNnNiCmMiDgGiDeCiDiMiDeOiDgHiDiKiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDbServer::GetCurrentDirectory (DsString& dsDirPath) const
{
	dsDirPath = FFGetCurrentDirectory(FALSE).c_str();
} // FCDbServer::GetCurrentDirectory.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDbServer::TryReadLock
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgFiBfLiDhFiDiLiCmM_xHqqkZx_SHARED READ_xZkqqHx_iDiNiDgCiDeOiCpAiOiOiCnNiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	guidTable			:_xZkqqHx_jDmHiCnNiNjOiCnMiCoKiClNiDgGiBfLiDfOiCmMiBeBiDgFiBfLiDhFiDiL_xHqqkZx_GUID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *			dwDeleteIdentifier	:_xZkqqHx_jDmHiCnNiNjOiCnMiCoKiClNiDgGiBfLiDfOiCmMiBeBiNoNiPjM_xHqqkZx_Identifier_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *			dwAppendIdentifier	:_xZkqqHx_jDmHiCnNiNjOiCnMiCoKiClNiDgGiBfLiDfOiCmMiBeBjCmHiJmB_xHqqkZx_Identifier_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *			tableName			:_xZkqqHx_iDgFiBfLiDhFiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_ 0_xZkqqHx_iBeCiDeHiDiJiBfLiCmMiPoKiNiHiCmNiDiBiDgCiDfKiBfLiDfH_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DsErr FCDbServer::TryReadLock (	GUID& guidTable,
								DWORD& dwDeleteIdentifier,
								DWORD& dwAppendIdentifier,
								const FCTableName& tableName)
{
//----- 06.03.12 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iDhAiDfIiCpAiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
	DsErr errCode = CheckTopGroupPath(WString(tableName.GetTopDirPath()));
	// _xZkqqHx_iDhAiDfIiCmJiInJiPoNiCkKiCkAiCoKiCmOiBeBiDeHiDiJiBfLiCpAjFnEiClHiBeC_xHqqkZx_
	if (errCode != 0) return errCode;
//----- 06.03.12 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	// _xZkqqHx_jGlDiMpIiCmIiJpAjFpKjHhGiLiBiCpAiNoNiPjMiBeC_xHqqkZx_
	ClearInvalidUnlockRequest();

	// _xZkqqHx_iJpAjFpKjHhGiLiBiCkKjHiIiCmEiCkCiCmEiCoAiBeBiKpJiCmJjGlDiMpIiCmJiCmIiCmBiCmEiCkCiCoJiJmCjEfMjAkLiCkKiCkAiCoJiBeC_xHqqkZx_
	// _xZkqqHx_iClBiCmMiClNiCnPiBeBiJpAjFpKjHhGiLiBiCkJiCoHiCmMiOjOiKnEiCkKjCfKiCkCiPoKiNiHiCmNiJpAjFpKjHhGiLiBiDhEiDeAiDeDiDiLiCmM_xHqqkZx_
	// _xZkqqHx_jHeMiMpIjAkLiCpAjClCiCnHiCoJiBeC_xHqqkZx_

	FCServerLockRec* pLockRec = GetLockRec(tableName);

	// _xZkqqHx_iNmFiMoDiCmJiJpAjFpKiDiBiDgCiDfKiBfLiDfHiCpAjBjHjFhEiClFiClNiOjOiKnEiCkJiCoH_xHqqkZx_
	// _xZkqqHx_iCkAiCnMiCoIiMgPiJnPiClFiCmEiCkCiCmIiCkCiPoKiNiHiCmNiBeBiJpAjFpKjHhGiLiBiDhEiDeAiDeDiDiLiCkK_xHqqkZx_
	// _xZkqqHx_jGkCiClOjBlGiNnNiClFiCmEiCkCiCoJiCkJiDgAiDeGiDgCiDeOiClHiCoJiBeC_xHqqkZx_
	if (pLockRec == NULL ||
		(pLockRec != NULL && !pLockRec->m_autoReadLock.IsFileLocked()))
	//----- _xZkqqHx_jGkCiClOiDiNiDgCiDeOiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		if (FFGetCurrentMillisecTime() - ur_read(m_csaUnlockReq)->m_fdmtLastUnlockRequest < FD_UNLOCK_REQUEST_VALID_TIME)
		//----- _xZkqqHx_iNmFiMoDiCmJiJpAjFpKiDiBiDgCiDfKiBfLiDfHiCpAjBjHjFhEiClFiClNiOjOiKnEiCkJiCoHiCkAiCnMiCoIiMgPiJnPiClFiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			if (FCAutoLock::IsThereValidReqFile(FCTableName(tableName).PopBack()))
			//----- _xZkqqHx_iJpAjFpKjHhGiLiBiDhEiDeAiDeDiDiLiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
			{
				// "_xZkqqHx_jBlMiCmMiDeBiDhGiDiKiDfAiBfLiDfGiDiHiDjDiCkJiCoHiDhEiDeAiDeDiDiLiCmMiJpAjFpKjHhGiLiBiCkKjHiIiCmEiCkCiCnMiClH_xHqqkZx_"
				return IDS_DYSR_ERR_FILE_UNLOCK_REQUESTED;
			}
		}
	}

// 06.03.12 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	DsErr errCode;
	if (pLockRec != NULL)
	{
		// _xZkqqHx_iLkEjHeM_xHqqkZx_READ_xZkqqHx_iDiNiDgCiDeOiCpAiOiOiCnNiCoJiBeC_xHqqkZx_
		// _xZkqqHx_jBnCiClPiOjOiKnEiBiBiCePiCmFiOiOiCnNiCoJiBeC_xHqqkZx_
		errCode = pLockRec->m_autoReadLock.TryLockFile(	tableName,
														FCAutoLock::LOCK_SHARED,
														0);
	} else
	{
		pLockRec = new FCServerLockRec();
		// _xZkqqHx_iLkEjHeM_xHqqkZx_READ_xZkqqHx_iDiNiDgCiDeOiCpAiOiOiCnNiCoJiBeC_xHqqkZx_
		// _xZkqqHx_jBnCiClPiOjOiKnEiBiBiCePiCmFiOiOiCnNiCoJiBeC_xHqqkZx_
		errCode = pLockRec->m_autoReadLock.TryLockFile(	tableName,
														FCAutoLock::LOCK_SHARED,
														0);
		if (errCode != 0)
			delete pLockRec;
		else
			SetLockRec(tableName, pLockRec);
	}
	if (errCode == 0)
	//----- _xZkqqHx_iDiNiDgCiDeOiCmJjAkMiMpHiClFiClNiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jFnEjCgMiCpAjAnNjCoIiBeC_xHqqkZx_
		guidTable = pLockRec->m_autoReadLock.GetTableGuid();
		dwDeleteIdentifier = pLockRec->m_autoReadLock.GetDeleteIdentifier();
		dwAppendIdentifier = pLockRec->m_autoReadLock.GetAppendIdentifier();

		// _xZkqqHx_iKmEiOiLiDfIiDiMiDgCiDgIiCpAiNoMjDkOiClDiClJiCoJiBeCiKpJiCmJiNoMjDkOiNmPiCnNiCmMiPoKiNiHiCmNiJlNiCoAiClFiCmIiCkCiBeC_xHqqkZx_
		FCAutoLock::StartWatchUnlockRequestThread(	FCTableName(tableName).PopBack(),
													WatchUnlockRequestCallback,
													(void*)this);
	}
	return errCode;
} // FCDbServer::TryReadLock.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDbServer::TryWriteLock
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgFiBfLiDhFiDiLiCmM_xHqqkZx_EXCLUSIVE WRITE_xZkqqHx_iDiNiDgCiDeOiCpAiOiOiCnNiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tableName	:_xZkqqHx_iDgFiBfLiDhFiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_ 0_xZkqqHx_iBeCiDeHiDiJiBfLiCmMiPoKiNiHiCmNiDiBiDgCiDfKiBfLiDfH_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DsErr FCDbServer::TryWriteLock (const FCTableName& tableName)
{
//----- 06.03.12 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iDhAiDfIiCpAiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
	DsErr errCode = CheckTopGroupPath(WString(tableName.GetTopDirPath()));
	// _xZkqqHx_iDhAiDfIiCmJiInJiPoNiCkKiCkAiCoKiCmOiBeBiDeHiDiJiBfLiCpAjFnEiClHiBeC_xHqqkZx_
	if (errCode != 0) return errCode;
//----- 06.03.12 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

// 06.03.12 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	DsErr errCode;
	FCServerLockRec* pLockRec = GetLockRec(tableName);
	if (pLockRec != NULL)
	{
		// _xZkqqHx_jEhCjBlM_xHqqkZx_WRITE_xZkqqHx_iDiNiDgCiDeOiCpAiOiOiCnNiCoJiBeC_xHqqkZx_
		// _xZkqqHx_jBnCiClPiOjOiKnEiBiBiCePiCmFiOiOiCnNiCoJiBeC_xHqqkZx_
		errCode = pLockRec->m_autoWriteLock.TryLockFile(tableName,
														FCAutoLock::LOCK_EXCLUSIVE,
														0);
	} else
	{
		pLockRec = new FCServerLockRec();
		// _xZkqqHx_jEhCjBlM_xHqqkZx_WRITE_xZkqqHx_iDiNiDgCiDeOiCpAiOiOiCnNiCoJiBeC_xHqqkZx_
		// _xZkqqHx_jBnCiClPiOjOiKnEiBiBiCePiCmFiOiOiCnNiCoJiBeC_xHqqkZx_
		errCode = pLockRec->m_autoWriteLock.TryLockFile(tableName,
														FCAutoLock::LOCK_EXCLUSIVE,
														0);
		if (errCode != 0)
			delete pLockRec;
		else
			SetLockRec(tableName, pLockRec);
	}
	return errCode;
} // FCDbServer::TryWriteLock.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDbServer::TryExclusiveReadLock
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgFiBfLiDhFiDiLiCmM_xHqqkZx_EXCLUSIVE READ_xZkqqHx_iDiNiDgCiDeOiCpAiOiOiCnNiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tableName	:_xZkqqHx_iDgFiBfLiDhFiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_ 0_xZkqqHx_iBeCiDeHiDiJiBfLiCmMiPoKiNiHiCmNiDiBiDgCiDfKiBfLiDfH_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDiNiDgCiDeOiCmFiCkLiCmIiCkCiPoKiNiHiBeBiMlEiIpGiCkK_xHqqkZx_IDS_DYSR_ERR_FILE_LOCKED_BY_OTHERS
 *			_xZkqqHx_iBgJjBlMiCmMiDiGiBfLiDfFiBfLiCkKiDiNiDgCiDeOiNmPiCnNiBgKiCmMiPoKiNiHiCmMiCnNiBeBiJpAjFpKjHhGiLiBiCpAjEkNiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DsErr FCDbServer::TryExclusiveReadLock (const FCTableName& tableName)
{
//----- 06.03.12 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iDhAiDfIiCpAiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
	DsErr errCode = CheckTopGroupPath(WString(tableName.GetTopDirPath()));
	// _xZkqqHx_iDhAiDfIiCmJiInJiPoNiCkKiCkAiCoKiCmOiBeBiDeHiDiJiBfLiCpAjFnEiClHiBeC_xHqqkZx_
	if (errCode != 0) return errCode;
//----- 06.03.12 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

// 06.03.12 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	DsErr errCode;
	FCServerLockRec* pLockRec = GetLockRec(tableName);
	if (pLockRec != NULL)
	{
		if (pLockRec->m_autoReadLock.IsFileLocked())
		//----- _xZkqqHx_iKpJiCmJiDiNiDgCiDeOiNmPiCnNiCmMiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iLkEjHeMjAnNjCoIiCkKiInJiCmIiCoJiPoKiNiHiCmNiDeHiDiJiBfLiCpAiDfIiDiNiBfLiBeC_xHqqkZx_
			if (pLockRec->m_autoReadLock.GetShareKind() != FCAutoLock::LOCK_EXCLUSIVE)
				FFThrowMiscUnknown();
		}
		// _xZkqqHx_jEhCjBlM_xHqqkZx_READ_xZkqqHx_iDiNiDgCiDeOiCpAiOiOiCnNiCoJiBeCjBnCiClPiOjOiKnEiBiBiCePiCmFiOiOiCnNiCoJiBeC_xHqqkZx_
		errCode = pLockRec->m_autoReadLock.TryLockFile(	tableName,
														FCAutoLock::LOCK_EXCLUSIVE,
														0);
	} else
	{
		pLockRec = new FCServerLockRec();
		// _xZkqqHx_jEhCjBlM_xHqqkZx_READ_xZkqqHx_iDiNiDgCiDeOiCpAiOiOiCnNiCoJiBeCjBnCiClPiOjOiKnEiBiBiCePiCmFiOiOiCnNiCoJiBeC_xHqqkZx_
		errCode = pLockRec->m_autoReadLock.TryLockFile(	tableName,
														FCAutoLock::LOCK_EXCLUSIVE,
														0);
		if (errCode != 0)
			delete pLockRec;	// _xZkqqHx_iDeHiDiJiBfLiCmMiPoKiNiHiCmNiDiNiDgCiDeOjFmPjAjEiCpAiNoNiPjMiBeC_xHqqkZx_
		else
			SetLockRec(tableName, pLockRec);	// _xZkqqHx_iDgFiBfLiDhFiDiLjGlM_xHqqkZx_->_xZkqqHx_iDiNiDgCiDeOjFmPjAjE_xHqqkZx_ _xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
	}
	if (errCode == IDS_DYSR_ERR_FILE_LOCKED_BY_OTHERS)
	//----- _xZkqqHx_jBlMiDiGiBfLiDfFiBfLiCmMiDiNiDgCiDeOiCkKiMlEiIpGiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iJpAjFpKjHhGiLiBiCpAjEkNiNhDiClHiCoJiBeC_xHqqkZx_
		FCTableName groupName = FCTableName(tableName).PopBack();
		lr_readwrite lr_rw(m_csaLockRec);
		if (lr_rw->m_mpGroupNameToUnlockReq.find(groupName) == lr_rw->m_mpGroupNameToUnlockReq.end())
		//----- _xZkqqHx_iDePiDiLiBfLiDhGjGlM_xHqqkZx_->_xZkqqHx_iJpAjFpKjHhGiLiBiDhEiDeAiDeDiDiL_xHqqkZx_ _xZkqqHx_iCmJjGkCjDgPjIfOiCmMiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iJpAjFpKjHhGiLiBiDhEiDeAiDeDiDiLiCpAiNoMjAkMiBeC_xHqqkZx_
			int fh = FCAutoLock::IssueUnlockRequest(groupName);
			if (fh != -1)
				lr_rw->m_mpGroupNameToUnlockReq[groupName] = fh;
		}
	}
	return errCode;
} // FCDbServer::TryExclusiveReadLock.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDbServer::CreateWriteLock
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiNiDgCiDeOiDhEiDeAiDeDiDiLiBgJiPiKjHeMiMkAiDhEiDeAiDeDiDiLiBgKiCpAiNoMjAkMiClFiBeB_xHqqkZx_EXCLUSIVE WRITE_xZkqqHx_iDiNiDgCiDeOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tableName		:_xZkqqHx_iDgFiBfLiDhFiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_ 0_xZkqqHx_iBeCiDeHiDiJiBfLiCmMiPoKiNiHiCmNiDiBiDgCiDfKiBfLiDfH_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DsErr FCDbServer::CreateWriteLock (const FCTableName& tableName)
{
//----- 06.03.12 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iDhAiDfIiCpAiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
	DsErr errCode = CheckTopGroupPath(WString(tableName.GetTopDirPath()));
	// _xZkqqHx_iDhAiDfIiCmJiInJiPoNiCkKiCkAiCoKiCmOiBeBiDeHiDiJiBfLiCpAjFnEiClHiBeC_xHqqkZx_
	if (errCode != 0) return errCode;
//----- 06.03.12 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	if (GetLockRec(tableName) != NULL)
		FFThrowMiscUnknown();

	FCServerLockRec* pLockRec = new FCServerLockRec();
	// _xZkqqHx_iDgFiBfLiDhFiDiL_xHqqkZx_GUID=GUID_NULL,Identifier=0_xZkqqHx_iCmFiDiNiDgCiDeOiCpAiNoMjAkMiBeC_xHqqkZx_
// 06.03.12 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	DsErr errCode = pLockRec->m_autoWriteLock.CreateLockFile(tableName, GUID_NULL, 0, 0);
	errCode = pLockRec->m_autoWriteLock.CreateLockFile(tableName, GUID_NULL, 0, 0);
	if (errCode != 0)
	{
		// _xZkqqHx_iDeHiDiJiBfLjAnNjCoIiBeC_xHqqkZx_
		delete pLockRec;
		return errCode;
	}
	SetLockRec(tableName, pLockRec);
	return 0;
} // FCDbServer::CreateWriteLock.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDbServer::ReadUnlock
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgFiBfLiDhFiDiLiCmM_xHqqkZx_READ_xZkqqHx_iDiNiDgCiDeOiCpAiJpAiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tableName	:_xZkqqHx_iDgFiBfLiDhFiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iKkOjBfDiCmJiJpAiPjMiClDiCoKiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeCiDiNiDgCiDeOiCkKiOgDiCmBiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_ FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDiNiDgCiDeOiCmNjFkBjAjEiJpBiPgEiCmLiCmEiCmFiCkLiCoJiCmMiCmFiBeBiCfAiJpBiKnGjAjEiCpAiOmAiNhDiClFiCmEiCoA_xHqqkZx_
 *			_xZkqqHx_iDiNiDgCiDeOiCkKiJpAiPjMiCmFiCkLiCoJiCmGiCmNiMmAiCoHiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCDbServer::ReadUnlock (const FCTableName& tableName)
{
	FCServerLockRec* pLockRec = GetLockRec(tableName);
	if (pLockRec == NULL)
		FFThrowMiscUnknown();
	// _xZkqqHx_iLkEjHeMiDiNiDgCiDeOiCkJiBeI_xHqqkZx_
	BOOL bIsSharedLock = (pLockRec->m_autoReadLock.GetShareKind() == FCAutoLock::LOCK_SHARED);

	// _xZkqqHx_iDiNiDgCiDeOiCpAiJpAiPjMiBeC_xHqqkZx_
	pLockRec->m_autoReadLock.UnlockFile();
	BOOL bIsReadLocked = pLockRec->m_autoReadLock.IsFileLocked();
	if (!bIsReadLocked)
	//----- _xZkqqHx_iDiNiDgCiDeOiCkKiKkOjBfDiCmJiJpAiPjMiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iLkEjHeMiDiNiDgCiDeOiCmMiPoKiNiHiCmNiBeBiKmEiOiLiDfIiDiMiDgCiDgIiCpAiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
		// _xZkqqHx_jFhDjHhGiCmIiKmEiOiLiCpAjCoCiOhOiClDiClJiCoJiBeC_xHqqkZx_
		if (bIsSharedLock)
			ReduceWatchUnlockRequestThread();
	}
	if (!pLockRec->m_autoWriteLock.IsFileLocked() &&
		!pLockRec->m_autoReadLock.IsFileLocked())
	{
		//----- _xZkqqHx_iDiNiDgCiDeOiCkKiKkOjBfDiCmJiJpAiPjMiClDiCoKiCmEiCkCiCoKiCmOjDgPjIfOiCpAjGjFiPmB_xHqqkZx_ -----
		lr_readwrite(m_csaLockRec)->m_mpTableNameToLockRec.erase(tableName);
	}
	// _xZkqqHx_iDiNiDgCiDeOiCkKiKkOjBfDiCmJiJpAiPjMiClDiCoKiCmEiCkCiCoKiCmO_xHqqkZx_TRUE_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
	return !bIsReadLocked;
} // FCDbServer::ReadUnlock.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDbServer::WriteUnlock
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgFiBfLiDhFiDiLiCmM_xHqqkZx_WRITE_xZkqqHx_iDiNiDgCiDeOiCpAiJpAiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tableName	:_xZkqqHx_iDgFiBfLiDhFiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iKkOjBfDiCmJiJpAiPjMiClDiCoKiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeCiDiNiDgCiDeOiCkKiOgDiCmBiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_ FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDiNiDgCiDeOiCmNjFkBjAjEiJpBiPgEiCmLiCmEiCmFiCkLiCoJiCmMiCmFiBeBiCfAiJpBiKnGjAjEiCpAiOmAiNhDiClFiCmEiCoA_xHqqkZx_
 *			_xZkqqHx_iDiNiDgCiDeOiCkKiJpAiPjMiCmFiCkLiCoJiCmGiCmNiMmAiCoHiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCDbServer::WriteUnlock (const FCTableName& tableName)
{
	FCServerLockRec* pLockRec = GetLockRec(tableName);
	if (pLockRec == NULL)
		FFThrowMiscUnknown();
	pLockRec->m_autoWriteLock.UnlockFile();
	const BOOL bIsWriteLocked = pLockRec->m_autoWriteLock.IsFileLocked();
	if (!pLockRec->m_autoWriteLock.IsFileLocked() &&
		!pLockRec->m_autoReadLock.IsFileLocked())
	{
		//----- _xZkqqHx_iDiNiDgCiDeOiCkKiKkOjBfDiCmJiJpAiPjMiClDiCoKiCmEiCkCiCoKiCmOjDgPjIfOiCpAjGjFiPmB_xHqqkZx_ -----
		lr_readwrite(m_csaLockRec)->m_mpTableNameToLockRec.erase(tableName);
	}
	// _xZkqqHx_iDiNiDgCiDeOiCkKiKkOjBfDiCmJiJpAiPjMiClDiCoKiCmEiCkCiCoKiCmO_xHqqkZx_TRUE_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
	return !bIsWriteLocked;
} // FCDbServer::WriteUnlock.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDbServer::RemoveUnlockRequest
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgFiBfLiDhFiDiLiCmMjBkOiClHiCoJiDePiDiLiBfLiDhGiCmJjEkNiNhDjCiGiCmMiJpAjFpKjHhGiLiBiCpAiJpAiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tableName	:_xZkqqHx_iDgFiBfLiDhFiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iJpAjFpKjHhGiLiBiCkKiDePiDiLiBfLiDhGjCfAiImKiCmIiCmMiCmFiBeBiClBiCmMiKnGjAjEiCpAiOmAiNhDiClHiCoJiCmGiOhHjCoIiClDiCoKiClN_xHqqkZx_
 *			_xZkqqHx_iDgFiBfLiDhFiDiLiImIiKePiCmJiCoAiClBiCmMiDePiDiLiBfLiDhGiCmJjBkOiClHiCoJiDgFiBfLiDhFiDiLiCmMjEkNiNhDiClFiClN_xHqqkZx_
 *			_xZkqqHx_iJpAjFpKjHhGiLiBiCmNiJpAiPjMiClDiCoKiCoJiClBiCmGiCmJiCmIiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iJpAjFpKjHhGiLiBiCkKjEkNiNhDiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiHiCmNiJlNiCoAiClFiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDbServer::RemoveUnlockRequest (const FCTableName& tableName)
{
	// _xZkqqHx_iJpAjFpKjHhGiLiBiCkKjEkNiNhDjCiGiCkJjClCiCnHiCoJiBeC_xHqqkZx_
	FCTableName groupName = FCTableName(tableName).PopBack();
	lr_readwrite lr_rw(m_csaLockRec);
	map<FCTableName, int>::iterator i = lr_rw->m_mpGroupNameToUnlockReq.find(groupName);
	if (i != lr_rw->m_mpGroupNameToUnlockReq.end())
	//----- _xZkqqHx_iDePiDiLiBfLiDhGjGlM_xHqqkZx_->_xZkqqHx_iJpAjFpKjHhGiLiBiDhEiDeAiDeDiDiL_xHqqkZx_ _xZkqqHx_iCmJjDgPjIfOiNmPiCnNiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iJpAjFpKjHhGiLiBiDhEiDeAiDeDiDiLiCpAiNoMjAkMiBeC_xHqqkZx_
		FCAutoLock::RemoveUnlockRequest(i->first, i->second);
		lr_rw->m_mpGroupNameToUnlockReq.erase(i);
	}
} // FCDbServer::RemoveUnlockRequest.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDbServer::IsReadLocked
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgFiBfLiDhFiDiLiCkK_xHqqkZx_READ_xZkqqHx_iDiNiDgCiDeOiClDiCoKiCmEiCkCiCoJiCkJjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tableName		:_xZkqqHx_iDgFiBfLiDhFiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiNiDgCiDeOiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCDbServer::IsReadLocked (const FCTableName& tableName) const
{
	const FCServerLockRec* pLockRec = GetLockRec(tableName);
	if (pLockRec == NULL) return FALSE;
	return pLockRec->m_autoReadLock.IsFileLocked();
} // FCDbServer::IsReadLocked.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDbServer::IsWriteLocked
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgFiBfLiDhFiDiLiCkK_xHqqkZx_WRITE_xZkqqHx_iDiNiDgCiDeOiClDiCoKiCmEiCkCiCoJiCkJjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tableName		:_xZkqqHx_iDgFiBfLiDhFiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiNiDgCiDeOiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCDbServer::IsWriteLocked (const FCTableName& tableName) const
{
	const FCServerLockRec* pLockRec = GetLockRec(tableName);
	if (pLockRec == NULL) return FALSE;
	return pLockRec->m_autoWriteLock.IsFileLocked();
} // FCDbServer::IsWriteLocked.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDbServer::GetReadLockInfo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iPiKjHeMiMkAiDhEiDeAiDeDiDiLiCmJiLeMjIfOiClDiCoKiClNiPoOjFpBiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	guidTable			:_xZkqqHx_jDmHiCnNiNjOiCnMiCoKiClNiDgGiBfLiDfOiCmMiBeBiDgFiBfLiDhFiDiL_xHqqkZx_GUID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *			dwDeleteIdentifier	:_xZkqqHx_jDmHiCnNiNjOiCnMiCoKiClNiDgGiBfLiDfOiCmMiBeBiNoNiPjM_xHqqkZx_Identifier_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *			dwAppendIdentifier	:_xZkqqHx_jDmHiCnNiNjOiCnMiCoKiClNiDgGiBfLiDfOiCmMiBeBjCmHiJmB_xHqqkZx_Identifier_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *			tableName			:_xZkqqHx_iDgFiBfLiDhFiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDbServer::GetReadLockInfo (	GUID& guidTable,
									DWORD& dwDeleteIdentifier,
									DWORD& dwAppendIdentifier,
									const FCTableName& tableName) const
{
	const FCServerLockRec* pLockRec = GetLockRec(tableName);
	guidTable = pLockRec->m_autoReadLock.GetTableGuid();
	dwDeleteIdentifier = pLockRec->m_autoReadLock.GetDeleteIdentifier();
	dwAppendIdentifier = pLockRec->m_autoReadLock.GetAppendIdentifier();
} // FCDbServer::GetReadLockInfo.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDbServer::ResetFlushError
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAnNjCoIiClDiCoKiCmEiCkCiCoJiDhEiDiJiDgCiDfGiDiFiDeHiDiJiBfLiCpAiDeOiDiKiDeBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDbServer::ResetFlushError ()
{
	td_readwrite td_rw(m_csaThreadData);
	td_rw->m_dsFlushErrorCode = 0;
	td_rw->m_wstrFlushErrorMessage.Empty();
} // FCDbServer::ResetFlushError.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDbServer::SetFlushError
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDiJiDgCiDfGiDiFiDfIiDiMiDgCiDgIiCkKiDeHiDiJiBfLiCpAiLeOiClBiClFiClNiPoKiNiHiCmJiBeBiDeHiDiJiBfLiPoOjFpBiCpA_xHqqkZx_
 *			_xZkqqHx_jAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dsFormatId	:_xZkqqHx_iDeHiDiJiBfLiDfCiBfLiDgIiCpAiOhHjCoIiBeCiDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiCmM_xHqqkZx_
 *						 _xZkqqHx_jFlGiOjKjHpBiDiKiDfMiBfLiDfI_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDbServer::SetFlushError (DsErr dsFormatId, ...)
{
	td_readwrite td_rw(m_csaThreadData);
	td_rw->m_dsFlushErrorCode = dsFormatId;
	//----- _xZkqqHx_iDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiCmMjFlGiOjKjHpBiCpAjBgHiCnNjHkHiCmEiCoJ_xHqqkZx_ -----
	WString wstrFormat;
	(void)wstrFormat.LoadString(dsFormatId);
	va_list argList;
	va_start(argList, dsFormatId);
	td_rw->m_wstrFlushErrorMessage.FormatV(wstrFormat.c_str(), argList);
	va_end(argList);
} // FCDbServer::SetFlushError.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDbServer::GetFlushErrorMessage
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBePiJpBiCmM_xHqqkZx_SendTransaction_xZkqqHx_iKnGjAjEiCmJiCoGiCmBiCmEiOmAiNhDiClDiCoKiClNiDhEiDiJiDgCiDfGiDiFiCmF_xHqqkZx_
 *			_xZkqqHx_jAlGiClGiClNiDeHiDiJiBfLiCmMiDiBiDgCiDfKiBfLiDfHjFlGiOjKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHjFlGiOjKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDeHiDiJiBfLiCmNiBeB_xHqqkZx_DynamicServerErrorCode.h _xZkqqHx_iCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WString FCDbServer::GetFlushErrorMessage () const
{
	// _xZkqqHx_iDhEiDiJiDgCiDfGiDiFjCiGiCmMiDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiBeC_xHqqkZx_
	return td_read(m_csaThreadData)->m_wstrFlushErrorMessage;
} // FCDbServer::GetFlushErrorMessage.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCIndexFile::GetRecordCount
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiBfLiDhFiDiLiCmMiDiMiDfCiBfLiDgIjAjEiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiMiDfCiBfLiDgIjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DWORD FCDbServer::GetRecordCount (const FCTableName& tableName)
{
	return FCIndexFile(tableName).GetRecordCount();
} // FCDbServer::GetRecordCount.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDbServer::LoadTableIndex
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiBfLiDhFiDiLiCmMiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCkJiCoHiDeDiDjDiDgGiDgCiDeOiDfIiPoOjFpBiCpAjDmHiCnNiPgPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vTableIndex		:_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiPoOjFpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			tableName		:_xZkqqHx_iDgFiBfLiDhFiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwBeginIndex	:_xZkqqHx_jDmHiCnNiPgPiClHiDiMiDfCiBfLiDgIjEmNiImNiCmMiNmFiPiJiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwEndIndex		:_xZkqqHx_jDmHiCnNiPgPiClHiDiMiDfCiBfLiDgIjEmNiImNiCmMiNmFiMoDiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *							 vTableIndex_xZkqqHx_iCmJiBeBiClBiCmMjCgMiCmNiKnMiCnMiCoKiCmIiCkCiBeC_xHqqkZx_
 *							 _xZkqqHx_iPeJiCoNiCoIiCnMiCmFjDmHiCnNiPgPiClHiPoKiNiHiCmN_xHqqkZx_ DWORD(-1)_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iNmFiPiJiCmM_xHqqkZx_LoadTableIndex_xZkqqHx_iKnGjAjEiCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDbServer::LoadTableIndex (	DsArray<BYTE>& vTableIndex,
									const FCTableName& tableName,
									DWORD dwBeginIndex,
									DWORD dwEndIndex)
{
	FCFile32 fileIndex(	FFGetFilePath(tableName) + FDTBL_INDEX_FILE_EXT,
						GENERIC_READ, FILE_SHARE_READ, OPEN_EXISTING);
	const flint fliBegin = FCIndexFile::GetIndexFilePosition(dwBeginIndex) - sizeof(flint);
	const flint fliEnd = (dwEndIndex != DWORD(-1)) ?
						FCIndexFile::GetIndexFilePosition(dwEndIndex) : fileIndex.GetLength64();
	vTableIndex.Allocate(fliEnd - fliBegin);
	fileIndex.Seek64(fliBegin, FILE_BEGIN);
	if (fileIndex.Read64(vTableIndex.Get(), vTableIndex.GetSize()) != vTableIndex.GetSize())
		FFThrowMiscUnknown();
	fileIndex.Close();
} // FCDbServer::LoadTableIndex.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDbServer::LoadTableRecords
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiBfLiDhFiDiLiCmMiDgGiBfLiDfOiDhEiDeAiDeDiDiLiCkJiCoHiDiMiDfCiBfLiDgIiDgGiBfLiDfOiCpAjDmHiCnNiPgPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vTableRecord	:_xZkqqHx_iDiMiDfCiBfLiDgIiDgGiBfLiDfOiPoOjFpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			tableName		:_xZkqqHx_iDgFiBfLiDhFiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwBeginIndex	:_xZkqqHx_jDmHiCnNiPgPiClHiDiMiDfCiBfLiDgIjEmNiImNiCmMiNmFiPiJiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwEndIndex		:_xZkqqHx_jDmHiCnNiPgPiClHiDiMiDfCiBfLiDgIjEmNiImNiCmMiNmFiMoDiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *							 vTableRecord_xZkqqHx_iCmJiBeBiClBiCmMjCgMiCmNiKnMiCnMiCoKiCmIiCkCiBeC_xHqqkZx_
 *							 _xZkqqHx_iPeJiCoNiCoIiCnMiCmFjDmHiCnNiPgPiClHiPoKiNiHiCmN_xHqqkZx_ DWORD(-1)_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iNmFiPiJiCmM_xHqqkZx_LoadTableRecords_xZkqqHx_iKnGjAjEiCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDbServer::LoadTableRecords (	DsArray<BYTE>& vTableRecord,
									const FCTableName& tableName,
									DWORD dwBeginIndex,
									DWORD dwEndIndex)
{
	FCIndexFile indexFile(tableName);
	const FCServerLockRec* pLockRec = GetLockRec(tableName);
	if (dwEndIndex == DWORD(-1) || indexFile.GetRecordCount() < dwEndIndex)
		dwEndIndex = indexFile.GetRecordCount();

	const WString wstrTablePath = FFGetFilePath(tableName) + FDTBL_DATA_FILE_EXT;
	FCFile32 fileTable;
	if (!fileTable.Open(wstrTablePath, GENERIC_READ, 0, OPEN_EXISTING))
		FFThrowMiscUnknown();
	const flint fliBeginPosition = indexFile.GetDataFilePosition(dwBeginIndex);
	const flint fliEndPosition = indexFile.GetDataFilePosition(dwEndIndex);
	vTableRecord.Allocate(fliEndPosition - fliBeginPosition);
	fileTable.Seek64(fliBeginPosition, FILE_BEGIN);
	if (fileTable.Read64(vTableRecord.Get(), vTableRecord.GetSize()) != vTableRecord.GetSize())
		FFThrowMiscUnknown();
} // FCDbServer::LoadTableRecords.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDbServer::GetUnlockRequestGroup
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iCkCiCnMiJpAjFpKjHhGiLiBiCpAiOpDiCkPiCmEiCkCiCoJiDePiDiLiBfLiDhGiCmMjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vGroupName	:_xZkqqHx_iDePiDiLiBfLiDhGjGlMiCmMjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jBlMiCmMiDeBiDhGiDiKiCkJiCoHiDiNiDgCiDeOiJpAjFpKiCmMjHhGiLiBiCpAiOpDiCkPiCmEiCkCiCoJiDePiDiLiBfLiDhGiCpAjClCiCnHiBeB_xHqqkZx_
 *			_xZkqqHx_iClLiCmMiIoKjHjHiCpAjFnEiClHiBeC_xHqqkZx_
 *			_xZkqqHx_iJpAjFpKjHhGiLiBiCmNiDgFiBfLiDhFiDiLjCfAiImKiCmFiCmNiCmIiCkNiBeBiDePiDiLiBfLiDhGjCfAiImKiCmFiCkAiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iJpAjFpKjHhGiLiBiCmNjFmKiDfIiDiMiDgCiDgIiCmJiCoGiCmBiCmEiPoNiCmJiKmEiOiLiClDiCoKiCmEiCkIiCoIiBeBiJpAjFpKjHhGiLiBiCpA_xHqqkZx_
 *			_xZkqqHx_iOpDiCkPjFhEiCkPiCoJiCmGiDiBiDjDiDgPiBfLjFmPjAjEiCmJiLeMjIfOiClDiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iLeMjIfOiClDiCoKiClNiDePiDiLiBfLiDhGiCmJiCmNjHeMiMpIiKpKiMmAiCkKjAnNjCoIiClDiCoKiCmEiCkIiCoIiBeBjHeMiMpIiKpKiMmAiCpA_xHqqkZx_
 *			_xZkqqHx_iJnPiCkMiClNiJpAjFpKjHhGiLiBiCmNiNoNiPjMiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDbServer::GetUnlockRequestGroup (vector<FCTableName>& vGroupName)
{
	// _xZkqqHx_jGlDiMpIiCmIiJpAjFpKjHhGiLiBiCpAiNoNiPjMiBeC_xHqqkZx_
	ClearInvalidUnlockRequest();
	// m_mpUnlockReqDirToValidTime _xZkqqHx_iCmMiDeOiDiKiDgFiDeCiDeKiDiLiDfKiDeOiDfGiDiHiDjDiBeC_xHqqkZx_
	ur_readwrite ur_rw(m_csaUnlockReq);

	vGroupName.clear();
	map<FCTableName, FDMILLISECTIME>::const_iterator iUrt;
	for (iUrt = ur_rw->m_mpUnlockReqDirToValidTime.begin();
		 iUrt != ur_rw->m_mpUnlockReqDirToValidTime.end(); iUrt++)
	{
		vGroupName.push_back((*iUrt).first);
	}
} // FCDbServer::GetUnlockRequestGroup.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDbServer::IsGroupExist
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDePiDiLiBfLiDhGiCkKjBlGiNnNiClHiCoJiCkJjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	groupName	:_xZkqqHx_iDePiDiLiBfLiDhGjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jBlGiNnNiClHiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDePiDiLiBfLiDhGiCmMiDgGiDeCiDiMiDeOiDgHiDiKiCkKjBlGiNnNiClHiCoJiCkJjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCDbServer::IsGroupExist (const FCTableName& groupName) const
{
	const WString wstrGroupPath = FFGetFilePath(groupName);
	return (FFIsThereFile(wstrGroupPath) != FD_FILE_NOT_EXIST);
} // FCDbServer::IsGroupExist.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDbServer::IsTableExist
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgFiBfLiDhFiDiLiCkKjBlGiNnNiClHiCoJiCkJjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tableName	:_xZkqqHx_iDgFiBfLiDhFiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jBlGiNnNiClHiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDgFiBfLiDhFiDiLiCmMiDgGiBfLiDfOiDhEiDeAiDeDiDiLiCkKjBlGiNnNiClHiCoJiCkJjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCDbServer::IsTableExist (const FCTableName& tableName) const
{
	const WString wstrTablePath = FFGetFilePath(tableName) + FDTBL_DATA_FILE_EXT;
//	const WString wstrIndexPath = FFGetFilePath(tableName) + FDTBL_INDEX_FILE_EXT;
	return (FFIsThereFile(wstrTablePath) != FD_FILE_NOT_EXIST);
} // FCDbServer::IsTableExist.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDbServer::GetLockRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgFiBfLiDhFiDiLiCmJjBmOiJjOiClHiCoJiBeBiDiNiDgCiDeOiDiMiDfCiBfLiDgIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tableName	:_xZkqqHx_iDgFiBfLiDhFiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiNiDgCiDeOiDiMiDfCiBfLiDgIiBeCiMkJiCmCiCkJiCoHiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDiNiDgCiDeOiDiMiDfCiBfLiDgIiCmJiCmNiBeB_xHqqkZx_READ_xZkqqHx_iDiNiDgCiDeO_xHqqkZx_/WRITE_xZkqqHx_iDiNiDgCiDeOiCmMiDeJiDhFiDfHiDeGiDeOiDgHiCkK_xHqqkZx_
 *			_xZkqqHx_iLeMjIfOiClDiCoKiCmEiCkCiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCServerLockRec* FCDbServer::GetLockRec (const FCTableName& tableName)
{
	lr_readwrite lr_rw(m_csaLockRec);
	FCServerLockRec* pLockRec = NULL;
	map<FCTableName, FCServerLockRecAuto>::iterator iT2i;
	iT2i = lr_rw->m_mpTableNameToLockRec.find(tableName);
	if (iT2i != lr_rw->m_mpTableNameToLockRec.end())
	{
		pLockRec = iT2i->second.get();
	}
	return pLockRec;
} // FCDbServer::GetLockRec.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDbServer::GetLockRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgFiBfLiDhFiDiLiCmJjBmOiJjOiClHiCoJiBeBiDiNiDgCiDeOiDiMiDfCiBfLiDgIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tableName	:_xZkqqHx_iDgFiBfLiDhFiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiNiDgCiDeOiDiMiDfCiBfLiDgIiBeCiMkJiCmCiCkJiCoHiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDiNiDgCiDeOiDiMiDfCiBfLiDgIiCmJiCmNiBeB_xHqqkZx_READ_xZkqqHx_iDiNiDgCiDeO_xHqqkZx_/WRITE_xZkqqHx_iDiNiDgCiDeOiCmMiDeJiDhFiDfHiDeGiDeOiDgHiCkK_xHqqkZx_
 *			_xZkqqHx_iLeMjIfOiClDiCoKiCmEiCkCiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const FCServerLockRec* FCDbServer::GetLockRec (const FCTableName& tableName) const
{
	lr_read lr_r(m_csaLockRec);
	const FCServerLockRec* pLockRec = NULL;
	map<FCTableName, FCServerLockRecAuto>::const_iterator iT2i;
	iT2i = lr_r->m_mpTableNameToLockRec.find(tableName);
	if (iT2i != lr_r->m_mpTableNameToLockRec.end())
	{
		pLockRec = iT2i->second.get();
	}
	return pLockRec;
} // FCDbServer::GetLockRec.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDbServer::SetLockRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgFiBfLiDhFiDiLiCmJjBmOiJjOiClHiCoJiBeBiDiNiDgCiDeOiDiMiDfCiBfLiDgIiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tableName	:_xZkqqHx_iDgFiBfLiDhFiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pLockRec	:_xZkqqHx_iDiNiDgCiDeOiDiMiDfCiBfLiDgIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDbServer::SetLockRec (	const FCTableName& tableName,
								FCServerLockRec* pLockRec)
{
	lr_readwrite lr_rw(m_csaLockRec);
	lr_rw->m_mpTableNameToLockRec[tableName] = FCServerLockRecAuto(pLockRec);
} // FCDbServer::SetLockRec.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDbServer::ReduceWatchUnlockRequestThread
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iJpAjFpKjHhGiLiBiCpAiKmEiOiLjCiGiCmMiDePiDiLiBfLiDhGiCmMiCkEiClPiBeBiKpJiCmJiDiNiDgCiDeOiCkKiJpAjFpKiClDiCoKiCmE_xHqqkZx_
			_xZkqqHx_iKmEiOiLiClHiCoJjFeLjHhGiCmMiCmIiCkCiDePiDiLiBfLiDhGiCmMiKmEiOiLiCpAjCoCiOhOiClDiClJiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDbServer::ReduceWatchUnlockRequestThread ()
{
	lr_read lr_r(m_csaLockRec);
	// _xZkqqHx_iMlLiNnNiKmEiOiLiClDiCoKiCmEiCkCiCoJjBfDiCmEiCmMiDePiDiLiBfLiDhGiCmMiDgFiBfLiDhFiDiLjGlMiCpAiOoGjDlOiBeC_xHqqkZx_
	set<FCTableName> stWatchGroupName;
	FCAutoLock::GetWatchUnlockRequestThreadName(stWatchGroupName);

	// READ&SHARED_xZkqqHx_iDiNiDgCiDeOiClDiCoKiCmEiCkCiCoJiDgFiBfLiDhFiDiLiCkKjBkOiClHiCoJiDePiDiLiBfLiDhGiCpAiPjMiCkNiBeC_xHqqkZx_
	// _xZkqqHx_iOgDiCoIiCkKiKmEiOiLjFhDjHhGiCmIiDePiDiLiBfLiDhGiCmGiCmIiCoJiBeC_xHqqkZx_
	map<FCTableName, FCServerLockRecAuto>::const_iterator iT2i;
	for (iT2i = lr_r->m_mpTableNameToLockRec.begin();
		 iT2i != lr_r->m_mpTableNameToLockRec.end(); iT2i++)
	{
		const FCServerLockRec* pLockRec = iT2i->second.get();
		if (pLockRec->m_autoReadLock.IsFileLocked() &&
			pLockRec->m_autoReadLock.GetShareKind() == FCAutoLock::LOCK_SHARED)
		//----- _xZkqqHx_iLkEjHeM_xHqqkZx_READ_xZkqqHx_iDiNiDgCiDeOiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iKmEiOiLiDePiDiLiBfLiDhGiCkJiCoHiBeBiDePiDiLiBfLiDhGiCpAiPjMiCkNiBeC_xHqqkZx_
			stWatchGroupName.erase(FCTableName(iT2i->first).PopBack());
		}
	}

	// _xZkqqHx_jFhDjHhGiCmIiKmEiOiLiDfIiDiMiDgCiDgIiCpAjCoCiOhOiClDiClJiCoJiBeC_xHqqkZx_
	set<FCTableName>::const_iterator iTn;
	for (iTn = stWatchGroupName.begin(); iTn != stWatchGroupName.end(); iTn++)
	{
		// _xZkqqHx_iKmEiOiLiDfIiDiMiDgCiDgIiCpAjCoCiOhOiClDiClJiCoJiBeC_xHqqkZx_
		FCAutoLock::StopWatchUnlockRequestThread(*iTn);
	}
} // FCDbServer::ReduceWatchUnlockRequestThread.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDbServer::SetUnlockRequestGroup
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBlMiCmMiDeBiDhGiDiKiCkJiCoHiJpAjFpKjHhGiLiBiCkKjDmNiCkCiCmEiCkCiCoJiDePiDiLiBfLiDhGiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	aGroupName		:_xZkqqHx_iJpAjFpKjHhGiLiBiCmMiCkAiCmBiClNiDePiDiLiBfLiDhGiCmMiDiKiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			szGroupNameCount:aGroupName_xZkqqHx_iCmMjEhKjHpBjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	m_stUnlockRequest _xZkqqHx_iCmJiJpAjFpKjHhGiLiBjCiGiCmMiDePiDiLiBfLiDhGiCmGiClFiCmEjDgPjIfOiClFiBeB_xHqqkZx_
 *			_xZkqqHx_iDiBiDeDiDjDiDeFiDeCiDjDiDgIiDeFiCmJiJpAjFpKjHhGiLiBiDiBiDgCiDfKiBfLiDfHiCpAjBjHjFhEiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDiBiDeDiDjDiDeFiDeCiDjDiDgIiDeFiCmNiBeBiJpAjFpKjHhGiLiBiDiBiDgCiDfKiBfLiDfHiCpAiOpDiCkPiOoGiCoJiCmGiBeB_xHqqkZx_
 *			_xZkqqHx_iJlMjBhKiDhEiDeAiDeDiDiLiDfEiBfLiDgPiCmJ_xHqqkZx_READ_xZkqqHx_iDiNiDgCiDeOiDeMiBfLiDhGiCmMiJpAiPjMiCpAjHhGiLiBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDbServer::SetUnlockRequestGroup (const FCTableName aGroupName[],
										size_t szGroupNameCount)
{
	// _xZkqqHx_jGlDiMpIiCmIiJpAjFpKjHhGiLiBiCpAiNoNiPjMiBeC_xHqqkZx_
	ClearInvalidUnlockRequest();
	// m_mpUnlockReqDirToValidTime _xZkqqHx_iCmMiDeOiDiKiDgFiDeCiDeKiDiLiDfKiDeOiDfGiDiHiDjDiBeC_xHqqkZx_
	ur_readwrite ur_rw(m_csaUnlockReq);
	// _xZkqqHx_jDgPjIfOiClDiCoKiClNiCkJiBeI_xHqqkZx_
	BOOL bRegistered = FALSE;
	// _xZkqqHx_iMlLiNnNiOjOiKnEiCpAiOoGjDlOiBeC_xHqqkZx_
	const FDMILLISECTIME fdmtCurrent = FFGetCurrentMillisecTime();
	long lC;
	for (lC = 0; lC != szGroupNameCount; lC++)
	{
		// _xZkqqHx_iKpJiCmJjDgPjIfOiNmPiCnNiCkJjClCiCnHiCoJiBeCjClCiCnHiClIiCmJjDgPjIfOiClHiCoJiCmGjHeMiMpIiKpKiMmAiCpAiDiKiDfKiDgCiDgHiClFiCmEiClFiCnMiCkEiClNiCnPiBeB_xHqqkZx_
		// _xZkqqHx_jFeLiClIjClCiCnHiCmEiCkJiCoHjDgPjIfOiClHiCoJiClBiCmGiBeC_xHqqkZx_
		map<FCTableName, FDMILLISECTIME>::const_iterator iUrt = ur_rw->m_mpUnlockReqDirToValidTime.find(aGroupName[lC]);
		if (iUrt == ur_rw->m_mpUnlockReqDirToValidTime.end())
		//----- _xZkqqHx_jGkCjDgPjIfOiCmMiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_jDgPjIfOiClDiCoKiClNiCkJiBeI_xHqqkZx_
			bRegistered = TRUE;
			// _xZkqqHx_jGkCjDgPjIfOiCmMiPoKiNiHiCmNiBeBjHeMiMpIiKpKiMmA_xHqqkZx_ FD_UNLOCK_REQUEST_VALID_TIME _xZkqqHx_iCmFjDgPjIfOiBeC_xHqqkZx_
			ur_rw->m_mpUnlockReqDirToValidTime[aGroupName[lC]] = fdmtCurrent + FD_UNLOCK_REQUEST_VALID_TIME;
		}
	}
	// _xZkqqHx_jDgPjIfOiClDiCoKiClNiPoKiNiHiCmNiBeBiJpAjFpKiDiBiDgCiDfKiBfLiDfHiCpAjBjHjFhEiBeC_xHqqkZx_
	s0_read s0_r(s_0);
	if (bRegistered && s0_r->s_hWnd != NULL)
	{
		// _xZkqqHx_iNmFiMoDiCmJiJpAjFpKiDiBiDgCiDfKiBfLiDfHiCpAjBjHjFhEiClFiClNiOjOiKnEiCpAiLeMjIfOiBeC_xHqqkZx_
		ur_rw->m_fdmtLastUnlockRequest = fdmtCurrent;
		::PostMessage(s0_r->s_hWnd, s0_r->s_dwUnlockRequestMessage, 0, 0);
	}
} // FCDbServer::SetUnlockRequestGroup.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDbServer::ClearInvalidUnlockRequest
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOjOiKnEjAnIiCoKiCmFjGlDiMpIiCmJiCmIiCmBiClNiJpAjFpKjHhGiLiBiCpAiDiKiDfIiDgHiCkJiCoHiNoNiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.11.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDbServer::ClearInvalidUnlockRequest ()
{
	// m_mpUnlockReqDirToValidTime _xZkqqHx_iCmMiDeOiDiKiDgFiDeCiDeKiDiLiDfKiDeOiDfGiDiHiDjDiBeC_xHqqkZx_
	ur_readwrite ur_rw(m_csaUnlockReq);
	// _xZkqqHx_iMlLiNnNiOjOiKnEiCpAiOoGjDlOiBeC_xHqqkZx_
	const FDMILLISECTIME fdmtCurrent = FFGetCurrentMillisecTime();
	//----- _xZkqqHx_jHeMiMpIiKpKiMmAiCpAiJnPiCkMiClNiJpAjFpKjHhGiLiBiCmNiDiKiDfIiDgHiCkJiCoHiNoNiPjMiClHiCoJ_xHqqkZx_ -----
	map<FCTableName, FDMILLISECTIME>::iterator iUrt;
	for (iUrt = ur_rw->m_mpUnlockReqDirToValidTime.begin();
		 iUrt != ur_rw->m_mpUnlockReqDirToValidTime.end();)
	{
		// _xZkqqHx_jHeMiMpIiKpKiMmAiCpAiJnPiCkMiClNiJpAjFpKjHhGiLiBiCmNiNoNiPjMiBeC_xHqqkZx_
		if (iUrt->second != FDMILLISECTIME(-1) &&
			iUrt->second < fdmtCurrent)
			iUrt = ur_rw->m_mpUnlockReqDirToValidTime.erase(iUrt);
		else
			iUrt++;
	}
} // FCDbServer::ClearInvalidUnlockRequest.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDbServer::GetWriteLockedTable
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiOjOjDfPiCmF_xHqqkZx_WRITE_xZkqqHx_iDiNiDgCiDeOiClDiCoKiCmEiCkCiCoJiDgFiBfLiDhFiDiLiCpAjBfDiCmEjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vTableName	:_xZkqqHx_iDgFiBfLiDhFiDiLjGlMiCmMiDiKiDfIiDgHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDbServer::GetWriteLockedTable (vector<FCTableName>& vTableName) const
{
	lr_read lr_r(m_csaLockRec);
	map<FCTableName, FCServerLockRecAuto>::const_iterator iT2i;
	for (iT2i = lr_r->m_mpTableNameToLockRec.begin();
		 iT2i != lr_r->m_mpTableNameToLockRec.end(); iT2i++)
	{
		const FCServerLockRec* pLockRec = iT2i->second.get();
		if (pLockRec->m_autoWriteLock.IsFileLocked())
			vTableName.push_back(iT2i->first);
	}
} // FCDbServer::GetWriteLockedTable.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDbServer::DeleteLock
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiNiDgCiDeOiJpAiPjMiNmPiCnNiCmMiDiNiDgCiDeOiDhEiDeAiDeDiDiLiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tableName	:_xZkqqHx_iDgFiBfLiDhFiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	tableName_xZkqqHx_iCmJiKnGiClHiCoJiPiKjHeMiMkAiDhEiDeAiDeDiDiLiCmGiPiKjHeMiOnCiDhEiDeAiDeDiDiLiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDbServer::DeleteLock (const FCTableName& tableName)
{
	lr_readwrite lr_rw(m_csaLockRec);
	// _xZkqqHx_jBfDiCmEiCmMiDiNiDgCiDeOiCmNiJpAiPjMiClDiCoKiCmEiCkCiCoJiCmNiClIiBeCiDiNiDgCiDeOiCkKiJpAiPjMiClDiCoKiCmE_xHqqkZx_
	// _xZkqqHx_iCkCiCoKiCmOiBeB_xHqqkZx_LockRec = NULL_xZkqqHx_iBeC_xHqqkZx_
	if (GetLockRec(tableName) != NULL)
		FFThrowMiscUnknown();
	// _xZkqqHx_iDiNiDgCiDeOiDiMiDfCiBfLiDgIiCpAiNoNiPjMiBeC_xHqqkZx_
	lr_rw->m_mpTableNameToLockRec.erase(tableName);
	// _xZkqqHx_iPiKjHeMiMkAiDhEiDeAiDeDiDiLiCmGiPiKjHeMiOnCiDhEiDeAiDeDiDiLiCpAiNoNiPjMiBeC_xHqqkZx_
	// _xZkqqHx_iBgJiJpAjFpKjHhGiLiBiDgGiDeCiDiMiDeOiDgHiDiKiCmNiNoNiPjMiCkKjGmKjDhMiCmIiCmMiCmFiOgDiClFiCmEiCkIiCkNiBgK_xHqqkZx_
	FCAutoLock::DeleteLockFile(tableName);
} // FCDbServer::DeleteLock.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDbServer::FlushThreadProc
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDiJiDgCiDfGiDiFiDfIiDiMiDgCiDgIiCmMiPiIjHjNiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iDfIiDiMiDgCiDgIjCiGiCkJiCoHiMmEiCnBiPgPiClDiCoKiCoJiClBiCmGiCmJjCiNiInDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDbServer::FlushThreadProc ()
{
	// _xZkqqHx_iImIiMoDiCmNiDiNiDgCiDeOjFmPjAjEiCpAjFnLiMoMiBeC_xHqqkZx_
	// _xZkqqHx_jFnLiMoMjCiGiCmNiBeBiDhEiDiJiDgCiDfGiDiFiDfIiDiMiDgCiDgIiImIiKePiCkJiCoHiDiNiDgCiDeOiCkKjFmPiNfIiCmFiCkLiCmIiCkNiCmIiCoJiBeC_xHqqkZx_
	lr_readwrite lr_rw(m_csaLockRec);

	// _xZkqqHx_iDgHiDiJiDjDiDfFiDeOiDfGiDiHiDjDjEhKjHpBiBeC_xHqqkZx_
	vector<HString>	m_vTopDirPath;
	vector<BYTE*>	m_vTransaction;
	vector<size_t>	m_vTransactionSize;
	// _xZkqqHx_iDhEiDiJiDgCiDfGiDiFiDfIiDiMiDgCiDgIiCmJjDgOiClDiCoKiCoJjBePiCmJiBeBjBjNiClF_xHqqkZx_WRITE_xZkqqHx_iDiNiDgCiDeOiClDiCoKiClNiDgFiBfLiDhFiDiLiCmMiIoKjHjHiBeC_xHqqkZx_
	// _xZkqqHx_iDhEiDiJiDgCiDfGiDiFiPeJjHlJiMoDiCmJiDfIiDiMiDgCiDgIjCiGiCmFiMlIiDiNiDgCiDeOiClHiCoJjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
	vector<FCTableName> vWriteLockedTableName;
	// _xZkqqHx_jFkBjAjEiDiGiBfLiDfFiBfLiCkJiCoHjDkPiOjOiDeBiDeOiDfKiDfIiJmCjEfMiCmJiClHiCoJiCkJiBeI_xHqqkZx_
	BOOL bMultiUserAccessable;
	{
		// _xZkqqHx_iDfIiDiMiDgCiDgIiDgGiBfLiDfOiCmMjFnLiMoMjHmMiIoGiBeC_xHqqkZx_
		td_readwrite td_rw(m_csaThreadData);
		m_vTopDirPath = td_rw->m_vTopDirPath;
		m_vTransaction = td_rw->m_vTransaction;
		m_vTransactionSize = td_rw->m_vTransactionSize;
		vWriteLockedTableName = td_rw->m_vWriteLockedTableName;
		// _xZkqqHx_jFkBjAjEiDiGiBfLiDfFiBfLiCkJiCoHjDkPiOjOiDeBiDeOiDfKiDfIiJmCjEfMiCmJiClHiCoJiCkJiBeI_xHqqkZx_
		bMultiUserAccessable = td_rw->m_bMultiUserAccessable;

		// _xZkqqHx_jCgMiCpAjDkPiOjOiCmJiDeBiDeOiDfKiDfIiClFiCmIiCkCiCoGiCkEiBeBiClBiClPiCoHiCmNiDeOiDiKiDeBiBeC_xHqqkZx_
		td_rw->m_vTopDirPath.clear();
		td_rw->m_vTransaction.clear();
		td_rw->m_vTransactionSize.clear();
		// _xZkqqHx_iDhEiDiJiDgCiDfGiDiFjElLjCoIiDhEiDiJiDePiBeC_xHqqkZx_
		td_rw->m_bIsFlushing = TRUE;
	}

	// WRITE_xZkqqHx_iDiNiDgCiDeOiClDiCoKiClNiDgFiBfLiDhFiDiLiCpA_xHqqkZx_ READ&SHARED_xZkqqHx_iCmFiCoAiDiNiDgCiDeOiClHiCoJiBeC_xHqqkZx_
	// AddTransaction _xZkqqHx_iCmM_xHqqkZx_ CMD_COPY_RECORD _xZkqqHx_iDfCiDhNiDjDiDgIiPiIjHjNiCmJiCkIiCkCiCmEiBeB_xHqqkZx_
	// _xZkqqHx_jDfNjBjHiMlDiCmMiDgFiBfLiDhFiDiLiCpAjDmHiCnNiPgPiClHjFeLjHhGiCkKiCkAiCoJiClNiCnPiBeBiCmGiCoIiCkAiCkGiClI_xHqqkZx_
	// _xZkqqHx_jBfDiCmEiCmMiDgFiBfLiDhFiDiLiCpA_xHqqkZx_ READ_xZkqqHx_iDiNiDgCiDeOiClFiCmEiCkIiCkNiBeC_xHqqkZx_
	mdef_const_iterator(vector<FCTableName>, iTn);
	m1_for (iTn, vWriteLockedTableName)
	{
		GUID guidTmp;
		DWORD dwTmpIdentifier;
		while (TryReadLock(	guidTmp,
							dwTmpIdentifier,
							dwTmpIdentifier,
							*iTn) != 0)
		{
			// _xZkqqHx_iDgFiBfLiDhFiDiLiCmN_xHqqkZx_Write_xZkqqHx_iDiNiDgCiDeOiClDiCoKiCmEiCoJiCmMiCmF_xHqqkZx_ Shared_xZkqqHx_iCmF_xHqqkZx_Read_xZkqqHx_iDiNiDgCiDeO_xHqqkZx_
			// _xZkqqHx_iClHiCoJiCmMiCmJiOlIjEhDiClHiCoJiClBiCmGiCmNjHeMiCoIjDlOiCmIiCkCiCmMiClOiCkKiBeBjEePiCmMiClNiCnPiCmJ_xHqqkZx_
			// _xZkqqHx_jBnCiClPiOjOiKnEiCpAjDpMiCoKiCmEiNmEjDhIiDgHiDiJiDeDiClDiClJiCoJiBeC_xHqqkZx_
			Sleep(FD_INTERVAL_FILE_LOCK_MILLISEC);
		}
	}

	// _xZkqqHx_iDgHiDiJiDjDiDfFiDeOiDfGiDiHiDjDiCmFiNoNiPjMiClDiCoKiClNiDgFiBfLiDhFiDiLiCmMiIoKjHjHiBeC_xHqqkZx_
	vector<FCTableName> vAllDeletedTableName;
	while (!m_vTopDirPath.empty())
	//----- _xZkqqHx_jFkBjAjEiCmMiDgHiDiJiDjDiDfFiDeOiDfGiDiHiDjDiCpAiDiLiBfLiDhG_xHqqkZx_ -----
	{
		// _xZkqqHx_iDgHiDiJiDjDiDfFiDeOiDfGiDiHiDjDiCpAiPiIjHjNiClHiCoJiClNiCnPiCmMiDeJiDhFiDfHiDeGiDeOiDgHiCpAiNoMjAkMiBeC_xHqqkZx_
		FCServerTableManager serverTableManager(this, m_vTopDirPath.back());
		// _xZkqqHx_iDgHiDiJiDjDiDfFiDeOiDfGiDiHiDjDiCmMiDgGiBfLiDfOiCpAiPiIjHjNiClFiCmEiBeBiJlMjBhKiDhEiDeAiDeDiDiLiCpAiNoMjAkMiBeC_xHqqkZx_
		serverTableManager.AddTransaction(	m_vTransaction.back(),
											m_vTransactionSize.back());
		// _xZkqqHx_iDgHiDiJiDjDiDfFiDeOiDfGiDiHiDjDiDgPiDgCiDhEiDeAiCpAiNoNiPjMiBeC_xHqqkZx_
		delete[] m_vTransaction.back();
		// _xZkqqHx_iPiIjHjNiNmPiCnNiCmMjHhGjBgGiCpAiDgHiDiJiDjDiDfFiDeOiDfGiDiHiDjDjEhKjHpBiCkJiCoHiNoNiPjMiBeC_xHqqkZx_
		m_vTopDirPath.pop_back();
		m_vTransaction.pop_back();
		m_vTransactionSize.pop_back();
		// _xZkqqHx_iJlMjBhKiDgFiBfLiDhFiDiLiCpAjFkIjHjNiDhEiDeAiDeDiDiLiCnGiDhEiDiJiDgCiDfGiDiFiBeC_xHqqkZx_
		vector<FCTableName> vDeletedTableName;
		// _xZkqqHx_jFkBjAjEiDiGiBfLiDfFiBfLiCkJiCoHjDkPiOjOiDeBiDeOiDfKiDfIiJmCjEfMiCmJiClHiCoJiCkJiBeI_xHqqkZx_
		if (bMultiUserAccessable)
			serverTableManager.FlushAll(vDeletedTableName);
		else
			serverTableManager.FlushAll2(vDeletedTableName);
		// _xZkqqHx_iDhEiDiJiDgCiDfGiDiFjCiGiCmJiDeHiDiJiBfLiCkKjEkNjAlGiClFiClNiPoKiNiHiCmNiPeJjHlJiBeC_xHqqkZx_
		if (GetFlushErrorCode() != 0) break;
		// _xZkqqHx_iNoNiPjMiClDiCoKiClNiDgFiBfLiDhFiDiLiCpAiOpLiPfHiBeC_xHqqkZx_
		vAllDeletedTableName.insert(vAllDeletedTableName.end(),
									vDeletedTableName.begin(),
									vDeletedTableName.end());
	}
	// _xZkqqHx_jDhCjCiGiCmFiPeJjHlJiClFiClNiPoKiNiHiCmNiBeBiOgDiCoIiCmMiDgHiDiJiDjDiDfFiDeOiDfGiDiHiDjDiDgPiDgCiDhEiDeAiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
	while (!m_vTopDirPath.empty())
	{
		// _xZkqqHx_iDgHiDiJiDjDiDfFiDeOiDfGiDiHiDjDiDgPiDgCiDhEiDeAiCpAiNoNiPjMiBeC_xHqqkZx_
		delete[] m_vTransaction.back();
		m_vTopDirPath.pop_back();
		m_vTransaction.pop_back();
		m_vTransactionSize.pop_back();
	}
	// WRITE_xZkqqHx_iDiNiDgCiDeOiCmMjBjNiClFiDiNiDgCiDeOiCpAiJpAiPjMiClHiCoJiBeC_xHqqkZx_
	m1_for (iTn, vWriteLockedTableName)
	{
		WriteUnlock(*iTn);
		ReadUnlock(*iTn);
	}
	// _xZkqqHx_iNoNiPjMiClDiCoKiClNiDgFiBfLiDhFiDiLiCmMiDiNiDgCiDeOiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
	m1_for (iTn, vAllDeletedTableName)
	{
		// _xZkqqHx_iDiNiDgCiDeOiCpAiJpAiPjMiClHiCoJiBeC_xHqqkZx_
		if (IsReadLocked(*iTn))
			while (!ReadUnlock(*iTn));
		if (IsWriteLocked(*iTn))
			while (!WriteUnlock(*iTn));
		// _xZkqqHx_iDiNiDgCiDeOiDhEiDeAiDeDiDiLiCpAiNoNiPjMiBeC_xHqqkZx_
		DeleteLock(*iTn);
	}

//	TRACE(_T("FCDbServer::myFlushAllThread B\n"));

	{
		// _xZkqqHx_iDfIiDiMiDgCiDgIiDgGiBfLiDfOiCmMjFnLiMoMjHmMiIoGiBeC_xHqqkZx_
		td_readwrite td_rw(m_csaThreadData);
		// _xZkqqHx_iDhEiDiJiDgCiDfGiDiFjElLjCoIiDhEiDiJiDePiBeC_xHqqkZx_
		td_rw->m_bIsFlushing = FALSE;
	}
//	TRACE(_T("FCDbServer::myFlushAllThread C\n"));
} // FCDbServer::FlushThreadProc.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDbServer::WatchUnlockRequestCallback
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiNiDgCiDeOiJpAjFpKjHhGiLiBiKmEiOiLiDfIiDiMiDgCiDgIiCmJjDgOiClHiDfCiBfLiDiLiDgPiDgCiDeOiKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	data			:_xZkqqHx_iDfCiBfLiDiLiDgPiDgCiDeOjAnNjCoIiOjOiCmJjDkPiOjOiCmJjAnNjCoIiClHiCoJiDiGiBfLiDfFiDgGiBfLiDfO_xHqqkZx_
 *							 _xZkqqHx_iCkKiOhHjCoIiClDiCoKiCoJiBeC_xHqqkZx_
 *			aGroupName		:_xZkqqHx_iJpAjFpKjHhGiLiBiCmMiCkAiCmBiClNiDePiDiLiBfLiDhGiCmMiDiKiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			szGroupNameCount:aGroupName_xZkqqHx_iCmMjEhKjHpBjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	static_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDbServer::WatchUnlockRequestCallback (void* data, const FCTableName aGroupName[], size_t szGroupNameCount)
{
	FCDbServer* pDbServer = (FCDbServer*)data;
	pDbServer->SetUnlockRequestGroup(aGroupName, szGroupNameCount);
} // FCDbServer::WatchUnlockRequestCallback.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDbServer::myFlushAllThread
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeDiDiLiCpAiDhEiDiJiDgCiDfGiDiFiClHiCoJiDfIiDiMiDgCiDgIiDhGiDiNiDePiDiJiDiAiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pvoid	:FCHiFileServer_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfIiDiMiDgCiDgIiCmMiDeHiDiJiBfLiDfCiBfLiDgIiCpAjFnEiClHiBeCjAkMiMpHiCmMiPoKiNiHiCmNiCePiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	static_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.07.29 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void WINAPI FCDbServer::myFlushAllThread (LPVOID pvoid)
{
	FCDbServer* pDbServer = (FCDbServer*)pvoid;
	// _xZkqqHx_iDhEiDiJiDgCiDfGiDiFiDfIiDiMiDgCiDgIiLoMjDkOiDeDiDhIiDjDiDgH_xHqqkZx_(_xZkqqHx_iDfCiDhDiBfL_xHqqkZx_)_xZkqqHx_iBeC_xHqqkZx_
	HANDLE hThreadEvent;
	// _xZkqqHx_iDfIiDiMiDgCiDgI_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
	{
		// _xZkqqHx_iDhEiDiJiDgCiDfGiDiFiDfIiDiMiDgCiDgIiCmMiDeOiDiKiDgFiDeCiDeKiDiLiDfKiDgCiDfGiDiHiDjDiBeC_xHqqkZx_
		td_readwrite td_rw(pDbServer->m_csaThreadData);
		hThreadEvent = td_rw->m_hThreadEvent;
	}
	for (;;)
	{
//		TRACE(_T("FCDbServer::myFlushAllThread A\n"));
		// _xZkqqHx_iDeDiDhIiDjDiDgHiCkKiDfGiDePiDgJiDiLiCmJiCmIiCoJiCmMiCpAjBnCiCmCiBeC_xHqqkZx_
		WaitForSingleObject(hThreadEvent, INFINITE);
		{
			// _xZkqqHx_iDhEiDiJiDgCiDfGiDiFiDfIiDiMiDgCiDgIiCmMiDeOiDiKiDgFiDeCiDeKiDiLiDfKiDgCiDfGiDiHiDjDiBeC_xHqqkZx_
			td_readwrite td_rw(pDbServer->m_csaThreadData);
			// _xZkqqHx_iDfIiDiMiDgCiDgIiPeJjHlJjHhGiLiBiCkKiCkAiCoJiPoKiNiHiCmNiPeJjHlJiBeC_xHqqkZx_
			if (td_rw->m_bIsTerminate)
			{
				// _xZkqqHx_iDhEiDiJiDgCiDfGiDiFiOmAiNhDiDfIiDiMiDgCiDgIiCmMiDgOiDjDiDgIiDiLiBeC_xHqqkZx_
				td_rw->m_hFlushThreadHandle = INVALID_HANDLE_VALUE;
				// _xZkqqHx_iDfIiDiMiDgCiDgIiLoMjDkOiDeDiDhIiDjDiDgHiBeC_xHqqkZx_
				CloseHandle(td_rw->m_hThreadEvent);
				td_rw->m_hThreadEvent = INVALID_HANDLE_VALUE;
				break;
			}
		}
		// _xZkqqHx_iDeDiDhIiDjDiDgHiCpAjEpBiDfGiDePiDgJiDiLiPpDjBnEiCmJiBeC_xHqqkZx_
		ResetEvent(hThreadEvent);
		// _xZkqqHx_iDhEiDiJiDgCiDfGiDiFiPiIjHjNiBeC_xHqqkZx_
		pDbServer->FlushThreadProc();
	}
} // FCDbServer::myFlushAllThread.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDbServer::myBrowseCallbackProc
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	OnPjnBtnDirDialog_xZkqqHx_jCiGiCmMiBeBiDhEiDeIiDiLiDfPiDhFiDiJiDeFiDfFiCkJiCoHiMmEiCnBiPgPiClDiCoKiCoJ_xHqqkZx_
 *			_xZkqqHx_iDfCiBfLiDiLiDgPiDgCiDeOiKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	hwnd	:_xZkqqHx_iDhEiDeIiDiLiDfPiDhFiDiJiDeFiDfFiDfPiDeDiDeBiDiNiDePiBeC_xHqqkZx_
 *			uMsg	:_xZkqqHx_iDfCiBfLiDiLiDgPiDgCiDeOiCmMiMlEiIpGiDeDiDhIiDjDiDgHiBeC_xHqqkZx_
 *			lp		:_xZkqqHx_iDeDiDhIiDjDiDgHiClCiCmGiCmJiInJiCmIiCoJiBeC_xHqqkZx_
 *			pData	:OnPjnBtnDirDialog_xZkqqHx_iCmM_xHqqkZx_BROWSEINFO.lParam_xZkqqHx_iCmMjCgMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iPoNiCmJiCePiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDhFiDiJiDeFiDfFiDfPiDeDiDeBiDiNiDePiCmJiDgGiDeCiDiMiDeOiDgHiDiKiCmMiPiJiKpKjCgMiCpAiOhHiOkGiClFiClNiCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.02.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
int CALLBACK FCDbServer::myBrowseCallbackProc (HWND hwnd, UINT uMsg, LPARAM lp, LPARAM pData)
{
	_TCHAR tcsDir[_MAX_PATH * 2];
	struct _UserParam
	{
		// _xZkqqHx_iDeFiDeCiDjDiDgIiDeFiImIiJlKiCmMiDfCiDjDiDgHiDiNiBfLiDiLiCmMiDgFiDeMiDfIiDgHiCpAjChFiKlHiClHiCoJiBeC_xHqqkZx_
		void SetStdBtnString (HWND hWndDlg)
		{
			for (HWND hWnd = ::GetWindow(hWndDlg, GW_CHILD);
				hWnd != NULL; hWnd = ::GetNextWindow(hWnd, GW_HWNDNEXT))
			{
				DWORD dwID = GetDlgCtrlID(hWnd);
				map<DWORD, WString>::const_iterator i = m_mpIdToText.find(dwID);
				if (i != m_mpIdToText.end())
				//----- _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMiDgFiDeMiDfIiDgHiCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
				{
					FFSetWindowText(hWnd, i->second);
				} else
				//----- _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMiDgFiDeMiDfIiDgHiCkKiOhHjCoIiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
				{
					// _xZkqqHx_iDgGiDhEiDeIiDiLiDgHjCgMiCpAjAnNjCoIiBeC_xHqqkZx_
					switch (dwID)
					{
					case IDOK:
						FFSetWindowText(hWnd, FFLoadWString(IDS_CTRL_OK));
						break;
					case IDCANCEL:
						FFSetWindowText(hWnd, FFLoadWString(IDS_CTRL_CANCEL));
						break;
					case IDHELP:
						FFSetWindowText(hWnd, FFLoadWString(IDS_CTRL_HELP));
						break;
					}
				}
			}
		} // SetStdBtnString.
		tcstring			m_strInitPath;
		map<DWORD, WString> m_mpIdToText;
	} *userParam = (_UserParam*)pData;

	switch (uMsg)
	{
	case BFFM_INITIALIZED:	// _xZkqqHx_iPiJiKpKiJlLiOjOiBeC_xHqqkZx_
	{
		// WParam is TRUE since you are passing a path.
		// It would be FALSE if you were passing a pidl.
		// pData_xZkqqHx_iCmJiCmNiBeB_xHqqkZx_OnPjnBtnDirDialog_xZkqqHx_iCmFiDgGiDeCiDiMiDeOiDgHiDiKjGlMiCpAjAnNjCoIiBeC_xHqqkZx_
		SendMessage(hwnd, BFFM_SETSELECTION, TRUE, LPARAM(userParam->m_strInitPath.c_str()));
		// _xZkqqHx_jFfHiPiAiDhLiDfOiDjDiCmMjFfMiOkGjFlGiOjKjHpBiCpAjChFiCkLiKlHiCkGiCoJiBeC_xHqqkZx_
		userParam->SetStdBtnString(hwnd);
		break;
	}
	case BFFM_SELCHANGED:	// _xZkqqHx_iDiGiBfLiDfFiCkKiDhEiDeIiDiLiDfPiCpAjBeJjBpAiClFiClNiPoKiNiHiBeC_xHqqkZx_
	{
		// BFFM_SELCHANGED_xZkqqHx_iCmMiPoKiNiHiCmNiBeB_xHqqkZx_lp_xZkqqHx_iCmJiCmN_xHqqkZx_ITEMDLIST_xZkqqHx_iCkKjAnNjCoIiClDiCoKiCmEiCkCiCoJiBeC_xHqqkZx_
		if (SHGetPathFromIDList((LPCITEMIDLIST)lp ,tcsDir))
		{
			// BFFM_SETSTATUSTEXT _xZkqqHx_iCmNiBeB_xHqqkZx_BIF_NEWDIALOGSTYLE _xZkqqHx_iCmFiCmNiOgHiCkGiCmIiCkC_xHqqkZx_
			// _xZkqqHx_iClNiCnPiBeBiDeFiDeCiDjDiDgIiDeFiDfOiDeDiDgHiDiLiCmJiDhAiDfIiCpAiLeMjDpMiBeC_xHqqkZx_
			SetWindowText(hwnd, tcsDir);
		}
		break;
	}
	default:
		break;
	}
	return 0;
} // FCDbServer::myBrowseCallbackProc.

//////////////////////////////////////////////////////////////////////////
// _xZkqqHx_iMpGiKeKiKnGjAjEiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	DynamicServerCreate
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	DLL_xZkqqHx_iCmMiMpGiKeKiKnGjAjEiBeC_xHqqkZx_DynamicServer_xZkqqHx_iCpAiNoMjAkMiBeFiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	callback	:_xZkqqHx_iDeHiDiJiBfLjEkNjAlGiOjOiCmMiDfCiBfLiDiLiDgPiDgCiDeOiKnGjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	DynamicServer_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DYNAMICSERVER_API DynamicServer* DynamicServerCreate (DsErrorThrowCallback callback)
{
	FFSetErrorThrowFunc(callback);
	FCDbServer* pServer = new FCDbServer();
	pServer->Initialize();
	return pServer;
} // DynamicServerCreate.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	DynamicServerDelete
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	DLL_xZkqqHx_iCmMiMpGiKeKiKnGjAjEiBeC_xHqqkZx_DynamicServer_xZkqqHx_iCpAiPeJjHlJiBeFiNoNiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pServer	:_xZkqqHx_iDfEiBfLiDgPiBfLiDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DYNAMICSERVER_API void DynamicServerDelete (DynamicServer* pServer)
{
	// _xZkqqHx_iDfEiBfLiDgPiBfLiCmMiPeJjHlJiPiIjHjNiBeC_xHqqkZx_
	((FCDbServer*)pServer)->Terminate();
	delete ((FCDbServer*)pServer);
} // DynamicServerDelete.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	DynamicServerSetWnd
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	DLL_xZkqqHx_iCmMiMpGiKeKiKnGjAjEiBeC_xHqqkZx_DynamicServer_xZkqqHx_iCmJiDiBiDgCiDfKiBfLiDfHjBjHjFhEjAoGiCmMiDeFiDeCiDjDiDgIiDeFiCpA_xHqqkZx_
 *			_xZkqqHx_jAnNjCoIiClHiCoJiBeCiJpAjFpKjHhGiLiBiDiBiDgCiDfKiBfLiDfHjDjJiCkKjBjHjFhEiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	hWnd	:_xZkqqHx_iDeFiDeCiDjDiDgIiDeFiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwUnlockRequestMessage
					:_xZkqqHx_iJpAjFpKjHhGiLiBiDiBiDgCiDfKiBfLiDfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DYNAMICSERVER_API void DynamicServerSetWnd (HWND hWnd, DWORD dwUnlockRequestMessage)
{
	s0_readwrite s0rw(s_0);
	s0rw->s_hWnd = hWnd;
	s0rw->s_dwUnlockRequestMessage = dwUnlockRequestMessage;
	// _xZkqqHx_iDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiDhLiDgCiDeOiDfIiCmMjAgFiDeFiDeCiDjDiDgIiDeFiCpAjAnNjCoIiBeC_xHqqkZx_
	FFSetErrorHwnd(hWnd);
} // DynamicServerSetWnd.
