#include "General.h"
#include "RegExpNode.h"
#include "RegNodePareCode.h"	// For RegNodePareCode.
#include "RegNodeEnumChar.h"	// For RegNodeEnumChar.
#include "RegExpNFASub.h"		// This header.

//----- 05.05.10 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FmfCreate
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAlDiLeLjFfMiMlLiDeJiDhFiDfHiDeGiDeOiDgHiNoMjAkMiKnGjAjEiBeC_xHqqkZx_DLL_xZkqqHx_iCmM_xHqqkZx_Export_xZkqqHx_jHhAiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAlDiLeLjFfMiMlLiDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	LoadLibrary_xZkqqHx_iCmFjClMjAnK_xHqqkZx_DLL_xZkqqHx_iCpAiDiNiBfLiDgIiClFiCmE_xHqqkZx_GetProcAddress_xZkqqHx_iCmFiOoGiCoIiPgPiClHiPoKiNiHiCmJ_xHqqkZx_
 *			_xZkqqHx_jHjIjHhAiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.05.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DllExport FmRegExpNFA* FmfCreate ()
{
	return new RegExpNFASub();
} // FmfCreate ().

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FmfDelete
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAlDiLeLjFfMiMlLiDeJiDhFiDfHiDeGiDeOiDgHiNoNiPjMiKnGjAjEiBeC_xHqqkZx_DLL_xZkqqHx_iCmM_xHqqkZx_Export_xZkqqHx_jHhAiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFmPjAjE_xHqqkZx_>	pNFA	:_xZkqqHx_jAlDiLeLjFfMiMlLiDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	LoadLibrary_xZkqqHx_iCmFjClMjAnK_xHqqkZx_DLL_xZkqqHx_iCpAiDiNiBfLiDgIiClFiCmE_xHqqkZx_GetProcAddress_xZkqqHx_iCmFiOoGiCoIiPgPiClHiPoKiNiHiCmJ_xHqqkZx_
 *			_xZkqqHx_jHjIjHhAiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.05.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DllExport void FmfDelete (FmRegExpNFA* pNFA)
{
	delete pNFA;
} // FmfDelete (FmRegExpNFA* pNFA).
//----- 05.05.10 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

//----- 05.05.10 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FmRegExpNFA::Create
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAlDiLeLjFfMiMlLiDeJiDhFiDfHiDeGiDeOiDgHiNoMjAkMiKnGjAjEiBeC_xHqqkZx_DLL_xZkqqHx_iCmM_xHqqkZx_Export_xZkqqHx_jHhAiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAlDiLeLjFfMiMlLiDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.16 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
// *************************************************************************/
//FmRegExpNFA* FmRegExpNFA::Create ()
//{
//	return new RegExpNFASub();
//} // FmRegExpNFA::Create.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FmRegExpNFA::Delete
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAlDiLeLjFfMiMlLiDeJiDhFiDfHiDeGiDeOiDgHiNoNiPjMiKnGjAjEiBeC_xHqqkZx_DLL_xZkqqHx_iCmM_xHqqkZx_Export_xZkqqHx_jHhAiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFmPjAjE_xHqqkZx_>	pNFA	:_xZkqqHx_jAlDiLeLjFfMiMlLiDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.16 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FmRegExpNFA::Delete (FmRegExpNFA* pNFA)
//{
//	delete pNFA;
//} // FmRegExpNFA::Delete.
//----- 05.05.10 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	RegExpNFASub::RegExpNFASub
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAlDiLeLjFfMiMlLiDeJiDhFiDfHiDeGiDeOiDgHiCmMiDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.16 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
RegExpNFASub::RegExpNFASub ()
{
	// _xZkqqHx_iDgNiBfLiDgIjHpBiCmMjAoGjDkKjFmPjAjEiBeC_xHqqkZx_
	m_pNode = NULL;
	// _xZkqqHx_jFmPiKlHiDeJiDhGiDfGiDiHiDjDiDhEiDiJiDePiBeC_xHqqkZx_
	m_wFlags = 0;
	// _xZkqqHx_jHmKiOhHjCoIiOhBiCmMiMeKiCoIjFnEiClFiJpBjAjEiBeC_xHqqkZx_
	m_dwQTimes = 0;
	// _xZkqqHx_jFjEjFkKjFlGiOjKjHpBiKiHiMmKiDeJiBfLiDhGiDjDjCiGiCpAiPiJiKpKiJlLiBeC_xHqqkZx_
	m_bPareOpening = FALSE;
	// _xZkqqHx_jFjEjFkKjFlGiOjKjHpBiDiKiDfIiDgHiCpAiDgNiBfLiDgIjCiGiCkJiCoHiOoGjDlOiClFiClNiCkJiBeI_xHqqkZx_
	m_bGetMatchStr = FALSE;
} // RegExpNFASub::RegExpNFASub.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	RegExpNFASub::~RegExpNFASub
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAlDiLeLjFfMiMlLiDeJiDhFiDfHiDeGiDeOiDgHiCmMiDgGiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.16 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
RegExpNFASub::~RegExpNFASub ()
{
	// _xZkqqHx_iDgNiBfLiDgIjHpBiCpAiNoNiPjMiBeC_xHqqkZx_
	if (m_pNode != NULL) delete m_pNode;
	m_pNode = NULL;
} // RegExpNFASub::~RegExpNFASub.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	RegExpNFASub::IsMatch
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFlGiOjKjHpBiCkKjAlDiLeLjFfMiMlLiCmJiIoKjChGiClFiCmEiCkCiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wPreChar:tcpStr_xZkqqHx_iCmMiCfAiCmCjBePiCmMjFlGiOjKiCpAiOhHjCoIiBeC_xHqqkZx_tcpStr_xZkqqHx_iCkKjFlGiOjKjHpBjAoGjDkKiCmMiPoKiNiHiCmN_xHqqkZx_
 *					 '\0'_xZkqqHx_iCpAjAnNjCoIiClHiCoJiBeCiDhNiDgCiDgAiClFiClNjEmNiImNiCmMiNmFiMoDiCmMjFlGiOjKiCpAjFnEiClHiBeC_xHqqkZx_
 *			tcpStr	:_xZkqqHx_jFlGiOjKjHpBiCmMiMjPiNpFjAoGjDkKjAoGjDkKiImKjChFiCpAiOhHjCoIiBeCjFlGiOjKjHpBiCkKiIoKjChGiClFiClNiPoKiNiHiCmNiBeB_xHqqkZx_
 *					 _xZkqqHx_iIoKjChGiClFiClNjEmNiImNiCmMiOjPiCmMjFlGiOjKjHpBiCmJjAgJiCnPiCoHiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iIoKjChGiClHiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBiIoKjChGiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jHoBiCkGiCmOiBeB_xHqqkZx_"ABCDEFGHIJ"_xZkqqHx_iCmGiCkCiCkEjFlGiOjKjHpBiCkKiCkAiCoJiPoKiNiHiCmNiBeB_xHqqkZx_"A"_xZkqqHx_iCmMiImKjChFiCkJiCoH_xHqqkZx_
 *			_xZkqqHx_iCfAjFlGiOjKiClIiCmCiDhMiDeDiDjDiDfOiCpAiInKjDkOiClFiCmIiCkKiCoHiBeB_xHqqkZx_"J"_xZkqqHx_iCmMiImKjChFiCnMiCmF_xHqqkZx_IsMatch_xZkqqHx_iKnGjAjE_xHqqkZx_
 *			_xZkqqHx_iCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iNmFiPiJiCmNiBeB_xHqqkZx_wPreChar = 0, tcpStr = &A_xZkqqHx_iBeC_xHqqkZx_
 *			_xZkqqHx_iOjPiCmNiBeB_xHqqkZx_wPreChar = 'A', tcpStr = &B_xZkqqHx_iBeC_xHqqkZx_
 *			_xZkqqHx_iOjPiCmNiBeB_xHqqkZx_wPreChar = 'B', tcpStr = &C_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	tcpStr_xZkqqHx_iCmMiImKjChFiCkJiCoHiClFiCkJiMjPiNpFiClFiCmIiCkCiClBiCmGiCmJjCiNiInDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.12.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL RegExpNFASub::IsMatch (WORD& wPreChar, CTCP& tcpStr, CTCP tcpStrEnd)
{
	if (m_pNode == NULL) return FALSE;
	// _xZkqqHx_jFjEjFkKjFlGiOjKjHpBiDiKiDfIiDgHiCpAiDgNiBfLiDgIjCiGiCkJiCoHiOoGjDlOiClFiClNiCkJiBeI_xHqqkZx_
	m_bGetMatchStr = FALSE;
	// _xZkqqHx_jFjEjFkKjFlGiOjKjHpBiDiKiDfIiDgHiCpAiDeOiDiKiDeBiBeC_xHqqkZx_
	m_vMatchStr.clear();
	if (m_pNode->IsMatch(wPreChar, tcpStr, tcpStrEnd)) return TRUE;
	return FALSE;
} // RegExpNFASub::IsMatch.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	RegExpNFASub::SetExpression
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAlDiLeLjFfMiMlLiCmMiMjPiNpFiOkOjFlGiOjKjHpBiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tcsExp	:_xZkqqHx_iMjPiNpFiOkOjFlGiOjKjHpBiCpAjAnNjCoIiClHiCoJiBeCiDeHiDiJiBfLjEkNjAlGiImKjChFiCpAjFnEiClHiBeC_xHqqkZx_
 *			wFlags	:_xZkqqHx_iMjPiNpFiOkOiJpAjAmNiOjOiCmMiDeJiDhGiDfGiDiHiDjDiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *			dwQTimes:Quantifier(*,+)_xZkqqHx_iCmMiNmFjBoFiCmMiMeKiCoIjFnEiClFiJpBjAjEiCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAlDiPoNiCmIiCoHiCmO_xHqqkZx_ TRUE_xZkqqHx_iBeBiDeHiDiJiBfLiCmIiCoHiCmO_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.12.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL RegExpNFASub::SetExpression (CTCP& tcsExp, WORD wFlags, DWORD dwQTimes)
{
	// _xZkqqHx_iMmDiCkCiDgNiBfLiDgIiCkKiOgDiCmBiCmEiCkCiCoJiCmIiCoHiCmOiBeBiNoNiPjMiBeC_xHqqkZx_
	if (m_pNode != NULL) delete m_pNode;
	// _xZkqqHx_iDhEiDiJiDePiCpAiDiBiDjDiDgPiCmJjAnNjCoIiBeC_xHqqkZx_
	m_wFlags = wFlags;
	// _xZkqqHx_jHmKiOhHjCoIiOhBiCmMiMeKiCoIjFnEiClFiJpBjAjEiCpAjAnNjCoIiBeC_xHqqkZx_
	m_dwQTimes = dwQTimes;
	// _xZkqqHx_jFjEjFkKjFlGiOjKjHpBiKiHiMmKiDeJiBfLiDhGiDjDjCiGiCpAiPiJiKpKiJlLiBeC_xHqqkZx_
	m_bPareOpening = FALSE;
	// _xZkqqHx_jAfGiClFiCkCiDgNiBfLiDgIiDgDiDiKiBfLiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
	RegExpNode node;
	BOOL bRegal = MkNodeGeneral(NULL, &node, tcsExp);
	// _xZkqqHx_iDgNiBfLiDgIiDgDiDiKiBfLiCmMiDgHiDgCiDhGiCpAjAnNjCoIiBeC_xHqqkZx_
	m_pNode = node.m_pNodeNext;
	node.m_pNodeNext = NULL;
	// _xZkqqHx_jFjEjFkKjFlGiOjKjHpBiKiHiMmKiDeJiBfLiDhGiDjDjCiGiCmIiCoHiCmOiBeBiDeHiDiJiBfLiBeC_xHqqkZx_
	if (m_bPareOpening) bRegal = FALSE;
	return bRegal;
} // RegExpNFASub::SetExpression.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	RegExpNFASub::GetMatchStrSize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAlDiLeLjFfMiMlLjCiGiCmM_xHqqkZx_"()"_xZkqqHx_iCmFiKgNjFnLiClDiCoKiClNjFjEjFkKjFlGiOjKjHpBiDiKiDfIiDgHiCmMiDfEiDeDiDfJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFjEjFkKjFlGiOjKjHpBiDiKiDfIiDgHiCmMiDfEiDeDiDfJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long RegExpNFASub::GetMatchStrSize ()
{
	if (!m_bGetMatchStr)
	//----- _xZkqqHx_jFjEjFkKjFlGiOjKjHpBiDiKiDfIiDgHiCpAiDgNiBfLiDgIjCiGiCkJiCoHiOoGjDlOiClFiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jFjEjFkKjFlGiOjKjHpBiDiKiDfIiDgHiCpAiDeOiDiKiDeBiBeC_xHqqkZx_
		m_vMatchStr.clear();
		MatchStrRec rec;
		BOOL bFirst = TRUE;	// _xZkqqHx_iDeJiBfLiDhGiDjDiKiHiMmKiBeI_xHqqkZx_
		for (RegExpNode* pNode = m_pNode; pNode != NULL; pNode = pNode->m_pNodeNext)
		{
			if (pNode->IsKindOf(NODE_PARE_CODE))
			{
				if (bFirst)
				{
					rec.tcpFrom = ((RegNodePareCode*)pNode)->m_tcpStr;
				} else
				{
					rec.tcpTo = ((RegNodePareCode*)pNode)->m_tcpStr;
					m_vMatchStr.push_back(rec);
				}
				bFirst = !bFirst;
			}
		}
		// _xZkqqHx_jFjEjFkKjFlGiOjKjHpBiDiKiDfIiDgHiCpAiDgNiBfLiDgIjCiGiCkJiCoHiOoGjDlOiClFiClNiCkJiBeI_xHqqkZx_
		m_bGetMatchStr = TRUE;
	}
	return m_vMatchStr.size();
} // RegExpNFASub::GetMatchStrSize.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	RegExpNFASub::GetMatchStr
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMjFjEjFkKjFlGiOjKjHpBiCmMjEmNiImNiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFmPjAjE_xHqqkZx_>	tcpFrom	:_xZkqqHx_jEmNiImNiCmMiNmFiPiJiCmMjFlGiOjKiImKjChFiCpAjFnEiClHiBeC_xHqqkZx_
 *			tcpTo	:_xZkqqHx_jEmNiImNiCmMiNmFiMoDiCmMjFlGiOjKiImKjChFiCpAjFnEiClHiBeC_xHqqkZx_
 *			lIdx	:_xZkqqHx_iOoGjDlOiClHiCoJjFjEjFkKjFlGiOjKjHpBiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void RegExpNFASub::GetMatchStr (CTCP& tcpFrom, CTCP& tcpTo, long lIdx)
{
	// _xZkqqHx_jFjEjFkKjFlGiOjKjHpBiDiKiDfIiDgHiCpAiDgNiBfLiDgIjCiGiCkJiCoHiOoGjDlOiClFiCmEiCkCiCmIiCkCiPoKiNiHiCmNiBeBiOoGjDlOiBeC_xHqqkZx_
	if (!m_bGetMatchStr) GetMatchStrSize();

	if (lIdx < m_vMatchStr.size())
	{
		tcpFrom = m_vMatchStr[lIdx].tcpFrom;
		tcpTo = m_vMatchStr[lIdx].tcpTo;
	} else
	{
		tcpFrom = NULL;
		tcpTo = NULL;
	}
} // RegExpNFASub::GetMatchStr.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	RegExpNFASub::MkNodeGeneral
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAlDiLeLjFfMiMlLiOkOjCiGiCmMiBeBiCfAjFlGiOjKiCpAjFmPiKlHiClHiCoJiBeCiNmEiLeBjDeJiCmJiOmAiNhDiClDiCoKiBeBiMiLiJmK_xHqqkZx_
 *			_xZkqqHx_jAlDiLeLjFfMiMlLiOkOjBfDjBmMiCpAjFmPiKlHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pPre2Node	:_xZkqqHx_iClBiCoKiCkJiCoHiPiIjHjNiClHiCoJjFlGiOjKiImKjChFiCmMjDpBiCmCjBePiCmMjFlGiOjKiCmMiDgNiBfLiDgI_xHqqkZx_
 *						 _xZkqqHx_iCpAiOhHjCoIiBeCjHmKiOhHjCoIiOhB_xHqqkZx_(*,+,?)_xZkqqHx_iCmMiOjOiCmJjHjIjHhAiClDiCoKiCoJiBeC_xHqqkZx_
 *			pPreNode	:_xZkqqHx_iClBiCoKiCkJiCoHiPiIjHjNiClHiCoJjFlGiOjKiImKjChFiCmMiIoKiCmCjBePiCmMjFlGiOjKiCmMiDgNiBfLiDgI_xHqqkZx_
 *						 _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			tcpHead		:_xZkqqHx_iClBiCoKiCkJiCoHiPiIjHjNiClHiCoJjFlGiOjKjHpBiCmMjAoGjDkKiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeHiDiJiBfLiCmMiPoKiNiHiCmN_xHqqkZx_ FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.16 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL RegExpNFASub::MkNodeGeneral (RegExpNode* pPre2Node, RegExpNode* pPreNode,
									CTCP& tcpHead)
{
	WORD wChar;
	// _xZkqqHx_iNmFiPiJiCmMiCfAjFlGiOjK_xHqqkZx_(\_xZkqqHx_iCmMiPoKiNiHiCmNiCfBjFlGiOjK_xHqqkZx_)_xZkqqHx_iCpAiOoGiCoIiPgPiClHiBeCjFlGiOjKiOoNiCoAjElLjCoIiBeC_xHqqkZx_
	CHAR_KIND kind = GetExpChar(tcpHead, wChar);
	switch (kind)
	{
	case KND_INVALID_CHR:	// Error. _xZkqqHx_iDeHiDiJiBfLiBeC_xHqqkZx_
		return FALSE;
	case KND_NULL_CHR:		// '\0'
		return TRUE;
	case KND_QUANT_COD:		// +,*,?
		return MkNodeQuantCode(pPre2Node, pPreNode, wChar, tcpHead);
	case KND_ASSERT_COD:	// ^,$,\b
		return MkNodeAssertCode(pPre2Node, pPreNode, wChar, tcpHead);
	case KND_RPARE_OPEN_COD:	// ( _xZkqqHx_iDeJiBfLiDhGiDjDiKnLiKiHiMmKiBeC_xHqqkZx_
		return MkNodeOpenPareCode(pPre2Node, pPreNode, wChar, tcpHead);
	case KND_RPARE_CLOSE_COD:	// ) _xZkqqHx_iDeOiDiNiBfLiDfJiKnLiKiHiMmKiBeC_xHqqkZx_
		return MkNodeClosePareCode(pPre2Node, pPreNode, wChar, tcpHead);
	case KND_ENUM_OPEN_COD:	// [
		return MkNodeEnumChar(pPre2Node, pPreNode, wChar, tcpHead);
	case KND_AMBIG_CHR:		// .,\d,\w,\s,
		return MkNodeAmbigChar(pPre2Node, pPreNode, wChar, tcpHead);
	default:	// KND_GENERAL_CHR a,A,1,,KND_RANGE_COD -, etc
		return MkNodeLetterChar(pPre2Node, pPreNode, wChar, tcpHead);
		return FALSE;
	}
} // RegExpNFASub::MkNodeGeneral.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	RegExpNFASub::MkNodeQuantCode
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHmKiOhHjCoIiOhB_xHqqkZx_(*,+,?)_xZkqqHx_iCmMjFlGiOjKiCpAiDgNiBfLiDgIiCmJjFmPiKlHiClFiBeBiOjPiCmMjFlGiOjKiCmMjFmPiKlHiPiIjHjNiCpA_xHqqkZx_
 *			_xZkqqHx_iNhDiCkEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pPre2Node	:_xZkqqHx_iClBiCoKiCkJiCoHiPiIjHjNiClHiCoJjFlGiOjKiImKjChFiBgJjBkGiClPjHmKiOhHjCoIiOhBiCmM_xHqqkZx_
 *						 _xZkqqHx_iOjPiCmMjFlGiOjKiImKjChFiBgKiCmMjDpBiCmCjBePiCmMjFlGiOjKiCmMiDgNiBfLiDgI_xHqqkZx_
 *						 _xZkqqHx_iCpAiOhHjCoIiBeCjHmKiOhHjCoIiOhB_xHqqkZx_(*,+,?)_xZkqqHx_iCmMiOjOiCmJjHjIjHhAiClDiCoKiCoJiBeC_xHqqkZx_
 *			pPreNode	:_xZkqqHx_iClBiCoKiCkJiCoHiPiIjHjNiClHiCoJjFlGiOjKiImKjChFiBgJjBkGiClPjHmKiOhHjCoIiOhBiCmM_xHqqkZx_
 *						 _xZkqqHx_iOjPiCmMjFlGiOjKiImKjChFiBgKiCmMiIoKiCmCjBePiCmMjFlGiOjKiCmMiDgNiBfLiDgI_xHqqkZx_
 *						 _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			wPreChar	:_xZkqqHx_iClBiCoKiCkJiCoHiPiIjHjNiClHiCoJjFlGiOjKiImKjChFiBgJjBkGiClPjHmKiOhHjCoIiOhBiCmM_xHqqkZx_
 *						 _xZkqqHx_iOjPiCmMjFlGiOjKiImKjChFiBgKiCmMiIoKiCmCjBePiCmMjFlGiOjKiCpAiOhHjCoIiBeC_xHqqkZx_
 *			tcpHead		:_xZkqqHx_iClBiCoKiCkJiCoHiPiIjHjNiClHiCoJjFlGiOjKjHpBiCmMjAoGjDkKiCpAiOhHjCoIiBgJjBkGiClP_xHqqkZx_
 *						 _xZkqqHx_jHmKiOhHjCoIiOhBiCmMiOjPiCmMjFlGiOjKiImKjChFiBgK_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeHiDiJiBfLiCmMiPoKiNiHiCmN_xHqqkZx_ FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.16 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL RegExpNFASub::MkNodeQuantCode (RegExpNode* pPre2Node, RegExpNode* pPreNode,
									WORD wPreChar, CTCP& tcpHead)
{
	// _xZkqqHx_jHmKiOhHjCoIiOhBiCmMjBePiCmMjFlGiOjKiCkKjGlDiCkCiPoKiNiHiCmNiBeBiDeHiDiJiBfLiBeC_xHqqkZx_
	if (pPre2Node == NULL) return FALSE;
	// _xZkqqHx_jBePiCmMjFlGiOjKiCkKiDeMiDiDiDiJiDeOiDfOiMgOiCmFiCmIiCkCiCmIiCoHiCmOiBeBiDeHiDiJiBfLiBeC_xHqqkZx_
	if (!pPreNode->IsKindOf(NODE_CHAR)) return FALSE;
	// _xZkqqHx_iCfAiCmCjBePiCmMiDgNiBfLiDgIiCpAiDfEiDhFiDgNiBfLiDgIiCmGiClHiCoJjHmKiOhHjCoIiOhBiDgNiBfLiDgIiCpAjBhNjDpMiBeC_xHqqkZx_
	pPre2Node->m_pNodeNext = new RegNodeQuantCode(wPreChar, pPreNode, m_dwQTimes);
	// _xZkqqHx_iOjPiCmMjFlGiOjKiCmMiPiIjHjNiCpAiNhDiCkEiBeC_xHqqkZx_
	return MkNodeGeneral(pPre2Node, pPre2Node->m_pNodeNext, tcpHead);
} // RegExpNFASub::MkNodeQuantCode.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	RegExpNFASub::MkNodeAssertCode
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlOjGlOiOhB_xHqqkZx_(^,$,\b)_xZkqqHx_iCmMjFlGiOjKiCpAiDgNiBfLiDgIiCmJjFmPiKlHiClFiBeBiOjPiCmMjFlGiOjKiCmMjFmPiKlHiPiIjHjNiCpA_xHqqkZx_
 *			_xZkqqHx_iNhDiCkEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pPre2Node	:_xZkqqHx_iClBiCoKiCkJiCoHiPiIjHjNiClHiCoJjFlGiOjKiImKjChFiBgJjBkGiClPiMlOjGlOiOhBiCmM_xHqqkZx_
 *						 _xZkqqHx_iOjPiCmMjFlGiOjKiImKjChFiBgKiCmMjDpBiCmCjBePiCmMjFlGiOjKiCmMiDgNiBfLiDgI_xHqqkZx_
 *						 _xZkqqHx_iCpAiOhHjCoIiBeCjHmKiOhHjCoIiOhB_xHqqkZx_(*,+,?)_xZkqqHx_iCmMiOjOiCmJjHjIjHhAiClDiCoKiCoJiBeC_xHqqkZx_
 *			pPreNode	:_xZkqqHx_iClBiCoKiCkJiCoHiPiIjHjNiClHiCoJjFlGiOjKiImKjChFiBgJjBkGiClPiMlOjGlOiOhBiCmM_xHqqkZx_
 *						 _xZkqqHx_iOjPiCmMjFlGiOjKiImKjChFiBgKiCmMiIoKiCmCjBePiCmMjFlGiOjKiCmMiDgNiBfLiDgI_xHqqkZx_
 *						 _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			wPreChar	:_xZkqqHx_iClBiCoKiCkJiCoHiPiIjHjNiClHiCoJjFlGiOjKiImKjChFiBgJjBkGiClPiMlOjGlOiOhBiCmM_xHqqkZx_
 *						 _xZkqqHx_iOjPiCmMjFlGiOjKiImKjChFiBgKiCmMiIoKiCmCjBePiCmMjFlGiOjKiCpAiOhHjCoIiBeC_xHqqkZx_
 *			tcpHead		:_xZkqqHx_iClBiCoKiCkJiCoHiPiIjHjNiClHiCoJjFlGiOjKjHpBiCmMjAoGjDkKiCpAiOhHjCoIiBgJjBkGiClP_xHqqkZx_
 *						 _xZkqqHx_iMlOjGlOiOhBiCmMiOjPiCmMjFlGiOjKiImKjChFiBgK_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeHiDiJiBfLiCmMiPoKiNiHiCmN_xHqqkZx_ FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.16 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL RegExpNFASub::MkNodeAssertCode (RegExpNode* pPre2Node, RegExpNode* pPreNode,
									WORD wPreChar, CTCP& tcpHead)
{
	CTCP tcpNext;
	switch (wPreChar)
	{
	case _T('^'):	// _xZkqqHx_iNhDjDkKiDfCiBfLiDgIiBeC_xHqqkZx_
		// _xZkqqHx_iNhDjDkKiDfCiBfLiDgIiCmMjBePiCmMjFlGiOjKiCkKjHeMiCoJiPoKiNiHiCmNiBeBiDeHiDiJiBfLiBeC_xHqqkZx_
		if (pPre2Node != NULL) return FALSE;
//----- 01.11.05 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
//----- 06.09.07 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//		// _xZkqqHx_iNhDjDkKiDfCiBfLiDgIiCmMiOjPiCmJjFlGiOjKiCkKjBlBiCkJiCmIiCkCiPoKiNiHiCmNiBeBiDeHiDiJiBfLiBeC_xHqqkZx_
//		if (GetWChar(tcpNext, tcpHead, NULL) == _T('\0')) return FALSE;
//----- 06.09.07 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
		// _xZkqqHx_iMlOjGlOiOhBjCfAjDmGiOgHjHhAiCpAiLjGiJmCiClFiCmIiCkCiPoKiNiHiBjFiNhDjDkKiDfCiBfLiDgIiCmMiOjPiCmJjFlGiOjKiCkKjBlBiCkJiCmIiCkCiPoKiNiHiCmNiBeBiDeHiDiJiBfLiBeC_xHqqkZx_
		if (!(m_wFlags & DREX_EXP_ALLOW_SINGLE_ASSERTION) &&
			GetWChar(tcpNext, tcpHead, NULL) == _T('\0')) return FALSE;
//----- 06.09.07 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//----- 01.11.05 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
		break;
	case _T('$'):	// _xZkqqHx_iNhDjGjGiDfCiBfLiDgIiBeC_xHqqkZx_
//----- 01.11.05 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
//----- 06.09.07 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//		// _xZkqqHx_iNhDjGjGiDfCiBfLiDgIiCmMjBePiCmMjFlGiOjKiCkKjGlDiCkCiPoKiNiHiCmNiBeBiDeHiDiJiBfLiBeC_xHqqkZx_
//		if (pPre2Node == NULL) return FALSE;
//----- 06.09.07 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
		// _xZkqqHx_iMlOjGlOiOhBjCfAjDmGiOgHjHhAiCpAiLjGiJmCiClFiCmIiCkCiPoKiNiHiBjFiNhDjGjGiDfCiBfLiDgIiCmMjBePiCmMjFlGiOjKiCkKjGlDiCkCiPoKiNiHiCmNiBeBiDeHiDiJiBfLiBeC_xHqqkZx_
		if (!(m_wFlags & DREX_EXP_ALLOW_SINGLE_ASSERTION) &&
			pPre2Node == NULL)
			return FALSE;
//----- 06.09.07 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//----- 01.11.05 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
		// _xZkqqHx_iNhDjGjGiDfCiBfLiDgIiCmMiOjPiCmJjFlGiOjKiCkKjBlBiCkNiPoKiNiHiCmNiBeBiDeHiDiJiBfLiBeC_xHqqkZx_
		if (GetWChar(tcpNext, tcpHead, NULL) != _T('\0')) return FALSE;
		break;
	case _T('b'):	// _xZkqqHx_jCfAiMoKiLkLiKeFiDfCiBfLiDgIiBeC_xHqqkZx_
//----- 01.11.05 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
//----- 06.09.07 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//		// _xZkqqHx_jCfAiMoKiLkLiKeFiDfCiBfLiDgIiCmMjBePiCmMjFlGiOjKiCkKjGlDiCkNiBeB_xHqqkZx_
//		// _xZkqqHx_jCfAiMoKiLkLiKeFiDfCiBfLiDgIiCmMiOjPiCmJjFlGiOjKiCkKjBlBiCkJiCmIiCkCiPoKiNiHiCmNiBeBiDeHiDiJiBfLiBeC_xHqqkZx_
//		if (pPre2Node == NULL && GetWChar(tcpNext, tcpHead, NULL) == _T('\0')) return FALSE;
//----- 06.09.07 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
		// _xZkqqHx_iMlOjGlOiOhBjCfAjDmGiOgHjHhAiCpAiLjGiJmCiClFiCmIiCkCiPoKiNiHiBjF_xHqqkZx_
		// _xZkqqHx_jCfAiMoKiLkLiKeFiDfCiBfLiDgIiCmMjBePiCmMjFlGiOjKiCkKjGlDiCkN_xHqqkZx_ _xZkqqHx_iKiOiCmC_xHqqkZx_
		// _xZkqqHx_jCfAiMoKiLkLiKeFiDfCiBfLiDgIiCmMiOjPiCmJjFlGiOjKiCkKjBlBiCkJiCmIiCkCiPoKiNiHiCmNiBeBiDeHiDiJiBfLiBeC_xHqqkZx_
		if (!(m_wFlags & DREX_EXP_ALLOW_SINGLE_ASSERTION) &&
			pPre2Node == NULL &&
			GetWChar(tcpNext, tcpHead, NULL) == _T('\0')) return FALSE;
//----- 06.09.07 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//----- 01.11.05 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
		break;
	default:
		return FALSE;
	}
	// _xZkqqHx_iCfAiCmCjBePiCmMiDgNiBfLiDgIiCmMiMoDiCoLiCmJiMlOjGlOiOhBiDgNiBfLiDgIiCpAjCmHiJmBiBeC_xHqqkZx_
	pPreNode->m_pNodeNext = new RegNodeAssertCode(wPreChar);
	// _xZkqqHx_iOjPiCmMjFlGiOjKiCmMiPiIjHjNiCpAiNhDiCkEiBeC_xHqqkZx_
	return MkNodeGeneral(pPreNode, pPreNode->m_pNodeNext, tcpHead);
} // RegExpNFASub::MkNodeAssertCode.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	RegExpNFASub::MkNodeOpenPareCode
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFkKjFlGiOjKjHpBiCmMiDeJiBfLiDhGiDjD_xHqqkZx_"("_xZkqqHx_iCmMjFlGiOjKiCpAiDgNiBfLiDgIiCmJjFmPiKlHiClFiBeBiOjPiCmMjFlGiOjKiCmM_xHqqkZx_
 *			_xZkqqHx_jFmPiKlHiPiIjHjNiCpAiNhDiCkEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pPre2Node	:_xZkqqHx_iClBiCoKiCkJiCoHiPiIjHjNiClHiCoJjFlGiOjKiImKjChFiBgJjBkGiClP_xHqqkZx_"("_xZkqqHx_iCmM_xHqqkZx_
 *						 _xZkqqHx_iOjPiCmMjFlGiOjKiImKjChFiBgKiCmMjDpBiCmCjBePiCmMjFlGiOjKiCmMiDgNiBfLiDgI_xHqqkZx_
 *						 _xZkqqHx_iCpAiOhHjCoIiBeCjHmKiOhHjCoIiOhB_xHqqkZx_(*,+,?)_xZkqqHx_iCmMiOjOiCmJjHjIjHhAiClDiCoKiCoJiBeC_xHqqkZx_
 *			pPreNode	:_xZkqqHx_iClBiCoKiCkJiCoHiPiIjHjNiClHiCoJjFlGiOjKiImKjChFiBgJjBkGiClP_xHqqkZx_"("_xZkqqHx_iCmM_xHqqkZx_
 *						 _xZkqqHx_iOjPiCmMjFlGiOjKiImKjChFiBgKiCmMiIoKiCmCjBePiCmMjFlGiOjKiCmMiDgNiBfLiDgI_xHqqkZx_
 *						 _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			wPreChar	:_xZkqqHx_iClBiCoKiCkJiCoHiPiIjHjNiClHiCoJjFlGiOjKiImKjChFiBgJjBkGiClP_xHqqkZx_"("_xZkqqHx_iCmM_xHqqkZx_
 *						 _xZkqqHx_iOjPiCmMjFlGiOjKiImKjChFiBgKiCmMiIoKiCmCjBePiCmMjFlGiOjKiCpAiOhHjCoIiBeC_xHqqkZx_
 *			tcpHead		:_xZkqqHx_iClBiCoKiCkJiCoHiPiIjHjNiClHiCoJjFlGiOjKjHpBiCmMjAoGjDkKiCpAiOhHjCoIiBgJjBkGiClP_xHqqkZx_
 *						 "("_xZkqqHx_iCmMiOjPiCmMjFlGiOjKiImKjChFiBgK_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeHiDiJiBfLiCmMiPoKiNiHiCmN_xHqqkZx_ FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL RegExpNFASub::MkNodeOpenPareCode (RegExpNode* pPre2Node, RegExpNode* pPreNode,
									WORD wPreChar, CTCP& tcpHead)
{
	// _xZkqqHx_iKpJiCmJjFjEjFkKjFlGiOjKjHpBiKiHiMmKiDeJiBfLiDhGiDjDjCiGiCmIiCoHiCmOiBeBiDeHiDiJiBfLiBeC_xHqqkZx_
	if (m_bPareOpening) return FALSE;
	// _xZkqqHx_jFjEjFkKjFlGiOjKjHpBiKiHiMmKiDeJiBfLiDhGiDjDjCiGiCpAjAnNjCoIiBeC_xHqqkZx_
	m_bPareOpening = TRUE;
	// _xZkqqHx_iCfAiCmCjBePiCmMiDgNiBfLiDgIiCmMiMoDiCoLiCmJiKnLiKiHiMmKiDgNiBfLiDgIiCpAjCmHiJmBiBeC_xHqqkZx_
	pPreNode->m_pNodeNext = new RegNodePareCode();
	// _xZkqqHx_iOjPiCmMjFlGiOjKiCmMiPiIjHjNiCpAiNhDiCkEiBeC_xHqqkZx_
	return MkNodeGeneral(pPreNode, pPreNode->m_pNodeNext, tcpHead);
} // RegExpNFASub::MkNodeOpenPareCode.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	RegExpNFASub::MkNodeClosePareCode
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFkKjFlGiOjKjHpBiCmMiDeOiDiNiBfLiDfJ_xHqqkZx_")"_xZkqqHx_iCmMjFlGiOjKiCpAiDgNiBfLiDgIiCmJjFmPiKlHiClFiBeBiOjPiCmMjFlGiOjKiCmM_xHqqkZx_
 *			_xZkqqHx_jFmPiKlHiPiIjHjNiCpAiNhDiCkEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pPre2Node	:_xZkqqHx_iClBiCoKiCkJiCoHiPiIjHjNiClHiCoJjFlGiOjKiImKjChFiBgJjBkGiClP_xHqqkZx_")"_xZkqqHx_iCmM_xHqqkZx_
 *						 _xZkqqHx_iOjPiCmMjFlGiOjKiImKjChFiBgKiCmMjDpBiCmCjBePiCmMjFlGiOjKiCmMiDgNiBfLiDgI_xHqqkZx_
 *						 _xZkqqHx_iCpAiOhHjCoIiBeCjHmKiOhHjCoIiOhB_xHqqkZx_(*,+,?)_xZkqqHx_iCmMiOjOiCmJjHjIjHhAiClDiCoKiCoJiBeC_xHqqkZx_
 *			pPreNode	:_xZkqqHx_iClBiCoKiCkJiCoHiPiIjHjNiClHiCoJjFlGiOjKiImKjChFiBgJjBkGiClP_xHqqkZx_")"_xZkqqHx_iCmM_xHqqkZx_
 *						 _xZkqqHx_iOjPiCmMjFlGiOjKiImKjChFiBgKiCmMiIoKiCmCjBePiCmMjFlGiOjKiCmMiDgNiBfLiDgI_xHqqkZx_
 *						 _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			wPreChar	:_xZkqqHx_iClBiCoKiCkJiCoHiPiIjHjNiClHiCoJjFlGiOjKiImKjChFiBgJjBkGiClP_xHqqkZx_")"_xZkqqHx_iCmM_xHqqkZx_
 *						 _xZkqqHx_iOjPiCmMjFlGiOjKiImKjChFiBgKiCmMiIoKiCmCjBePiCmMjFlGiOjKiCpAiOhHjCoIiBeC_xHqqkZx_
 *			tcpHead		:_xZkqqHx_iClBiCoKiCkJiCoHiPiIjHjNiClHiCoJjFlGiOjKjHpBiCmMjAoGjDkKiCpAiOhHjCoIiBgJjBkGiClP_xHqqkZx_
 *						 ")"_xZkqqHx_iCmMiOjPiCmMjFlGiOjKiImKjChFiBgK_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeHiDiJiBfLiCmMiPoKiNiHiCmN_xHqqkZx_ FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL RegExpNFASub::MkNodeClosePareCode (RegExpNode* pPre2Node, RegExpNode* pPreNode,
									WORD wPreChar, CTCP& tcpHead)
{
	// _xZkqqHx_iKpJiCmJjFjEjFkKjFlGiOjKjHpBiKiHiMmKiDeOiDiNiBfLiDfJjCiGiCmIiCoHiCmOiBeBiDeHiDiJiBfLiBeC_xHqqkZx_
	if (!m_bPareOpening) return FALSE;
	// _xZkqqHx_jFjEjFkKjFlGiOjKjHpBiKiHiMmKiDeOiDiNiBfLiDfJjCiGiCpAjAnNjCoIiBeC_xHqqkZx_
	m_bPareOpening = FALSE;
	// _xZkqqHx_iCfAiCmCjBePiCmMiDgNiBfLiDgIiCmMiMoDiCoLiCmJiKnLiKiHiMmKiDgNiBfLiDgIiCpAjCmHiJmBiBeC_xHqqkZx_
	pPreNode->m_pNodeNext = new RegNodePareCode();
	// _xZkqqHx_iOjPiCmMjFlGiOjKiCmMiPiIjHjNiCpAiNhDiCkEiBeC_xHqqkZx_
	return MkNodeGeneral(pPreNode, pPreNode->m_pNodeNext, tcpHead);
} // RegExpNFASub::MkNodeClosePareCode.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	RegExpNFASub::MkNodeEnumChar
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_> 	_xZkqqHx_jHpBiLjDjFlGiOjKiCmM_xHqqkZx_([])_xZkqqHx_iCmMjFlGiOjKiCpAiDgNiBfLiDgIiCmJjFmPiKlHiClFiBeBiOjPiCmMjFlGiOjKiCmMjFmPiKlHiPiIjHjNiCpA_xHqqkZx_
 *			_xZkqqHx_iNhDiCkEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pPre2Node	:_xZkqqHx_iClBiCoKiCkJiCoHiPiIjHjNiClHiCoJjFlGiOjKiImKjChFiBgJjBkGiClPjHpBiLjDjFlGiOjKiCmM_xHqqkZx_
 *						 _xZkqqHx_iOjPiCmMjFlGiOjKiImKjChFiBgKiCmMjDpBiCmCjBePiCmMjFlGiOjKiCmMiDgNiBfLiDgI_xHqqkZx_
 *						 _xZkqqHx_iCpAiOhHjCoIiBeCjHmKiOhHjCoIiOhB_xHqqkZx_(*,+,?)_xZkqqHx_iCmMiOjOiCmJjHjIjHhAiClDiCoKiCoJiBeC_xHqqkZx_
 *			pPreNode	:_xZkqqHx_iClBiCoKiCkJiCoHiPiIjHjNiClHiCoJjFlGiOjKiImKjChFiBgJjBkGiClPjHpBiLjDjFlGiOjKiCmM_xHqqkZx_
 *						 _xZkqqHx_iOjPiCmMjFlGiOjKiImKjChFiBgKiCmMiIoKiCmCjBePiCmMjFlGiOjKiCmMiDgNiBfLiDgI_xHqqkZx_
 *						 _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			wPreChar	:_xZkqqHx_iClBiCoKiCkJiCoHiPiIjHjNiClHiCoJjFlGiOjKiImKjChFiBgJjBkGiClPjHpBiLjDjFlGiOjKiCmM_xHqqkZx_
 *						 _xZkqqHx_iOjPiCmMjFlGiOjKiImKjChFiBgKiCmMiIoKiCmCjBePiCmMjFlGiOjKiCpAiOhHjCoIiBeC_xHqqkZx_
 *			tcpHead		:_xZkqqHx_iClBiCoKiCkJiCoHiPiIjHjNiClHiCoJjFlGiOjKjHpBiCmMjAoGjDkKiCpAiOhHjCoIiBgJjBkGiClP_xHqqkZx_
 *						 _xZkqqHx_jHpBiLjDjFlGiOjKiCmMiOjPiCmMjFlGiOjKiImKjChFiBgK_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeHiDiJiBfLiCmMiPoKiNiHiCmN_xHqqkZx_ FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.16 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL RegExpNFASub::MkNodeEnumChar (RegExpNode* pPre2Node, RegExpNode* pPreNode,
									WORD wPreChar, CTCP& tcpHead)
{
	// _xZkqqHx_iCfAiCmCjBePiCmMiDgNiBfLiDgIiCmMiMoDiCoLiCmJjHpBiLjDjFlGiOjKiDgNiBfLiDgIiCpAjCmHiJmBiBeC_xHqqkZx_
	pPreNode->m_pNodeNext = new RegNodeEnumChar(m_wFlags);
	// _xZkqqHx_iDeJiBfLiDhGiDjDjHpBiLjDiOhB_xHqqkZx_([)_xZkqqHx_iImIiNhOiBeBiDeOiDiNiBfLiDfJjHpBiLjDiOhB_xHqqkZx_(])_xZkqqHx_iCnMiCmFiCpAiJpAjAmNiBeC_xHqqkZx_
	if (!((RegNodeEnumChar*)pPreNode->m_pNodeNext)->SetExpression(tcpHead)) return FALSE;
	// _xZkqqHx_iOjPiCmMjFlGiOjKiCmMiPiIjHjNiCpAiNhDiCkEiBeC_xHqqkZx_
	return MkNodeGeneral(pPreNode, pPreNode->m_pNodeNext, tcpHead);
} // RegExpNFASub::MkNodeEnumChar.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	RegExpNFASub::MkNodeAmbigChar
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_> 	_xZkqqHx_jOeCjGiGjFlGiOjK_xHqqkZx_(.,\d,\w,\s)_xZkqqHx_iCmMjFlGiOjKiCpAiDgNiBfLiDgIiCmJjFmPiKlHiClFiBeBiOjPiCmMjFlGiOjKiCmMjFmPiKlHiPiIjHjNiCpA_xHqqkZx_
 *			_xZkqqHx_iNhDiCkEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pPre2Node	:_xZkqqHx_iClBiCoKiCkJiCoHiPiIjHjNiClHiCoJjFlGiOjKiImKjChFiBgJjBkGiClPjOeCjGiGjFlGiOjKiCmM_xHqqkZx_
 *						 _xZkqqHx_iOjPiCmMjFlGiOjKiImKjChFiBgKiCmMjDpBiCmCjBePiCmMjFlGiOjKiCmMiDgNiBfLiDgI_xHqqkZx_
 *						 _xZkqqHx_iCpAiOhHjCoIiBeCjHmKiOhHjCoIiOhB_xHqqkZx_(*,+,?)_xZkqqHx_iCmMiOjOiCmJjHjIjHhAiClDiCoKiCoJiBeC_xHqqkZx_
 *			pPreNode	:_xZkqqHx_iClBiCoKiCkJiCoHiPiIjHjNiClHiCoJjFlGiOjKiImKjChFiBgJjBkGiClPjOeCjGiGjFlGiOjKiCmM_xHqqkZx_
 *						 _xZkqqHx_iOjPiCmMjFlGiOjKiImKjChFiBgKiCmMiIoKiCmCjBePiCmMjFlGiOjKiCmMiDgNiBfLiDgI_xHqqkZx_
 *						 _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			wPreChar	:_xZkqqHx_iClBiCoKiCkJiCoHiPiIjHjNiClHiCoJjFlGiOjKiImKjChFiBgJjBkGiClPjOeCjGiGjFlGiOjKiCmM_xHqqkZx_
 *						 _xZkqqHx_iOjPiCmMjFlGiOjKiImKjChFiBgKiCmMiIoKiCmCjBePiCmMjFlGiOjKiCpAiOhHjCoIiBeC_xHqqkZx_
 *			tcpHead		:_xZkqqHx_iClBiCoKiCkJiCoHiPiIjHjNiClHiCoJjFlGiOjKjHpBiCmMjAoGjDkKiCpAiOhHjCoIiBgJjBkGiClP_xHqqkZx_
 *						 _xZkqqHx_jOeCjGiGjFlGiOjKiCmMiOjPiCmMjFlGiOjKiImKjChFiBgK_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeHiDiJiBfLiCmMiPoKiNiHiCmN_xHqqkZx_ FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.16 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL RegExpNFASub::MkNodeAmbigChar (RegExpNode* pPre2Node, RegExpNode* pPreNode,
									WORD wPreChar, CTCP& tcpHead)
{
	// _xZkqqHx_iCfAiCmCjBePiCmMiDgNiBfLiDgIiCmMiMoDiCoLiCmJjOeCjGiGjFlGiOjKiDgNiBfLiDgIiCpAjCmHiJmBiBeC_xHqqkZx_
	pPreNode->m_pNodeNext = new RegNodeAmbigChar(wPreChar);
	// _xZkqqHx_iOjPiCmMjFlGiOjKiCmMiPiIjHjNiCpAiNhDiCkEiBeC_xHqqkZx_
	return MkNodeGeneral(pPreNode, pPreNode->m_pNodeNext, tcpHead);
} // RegExpNFASub::MkNodeAmbigChar.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	RegExpNFASub::MkNodeLetterChar
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_> 	_xZkqqHx_jCmKiPoNiCmMiCfAjFlGiOjKiCpAiDgNiBfLiDgIiCmJjFmPiKlHiClFiBeBiOjPiCmMjFlGiOjKiCmMjFmPiKlHiPiIjHjNiCpAiNhDiCkEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pPre2Node	:_xZkqqHx_iClBiCoKiCkJiCoHiPiIjHjNiClHiCoJjFlGiOjKiImKjChFiBgJjBkGiClPjCmKiPoNjFlGiOjKiCmM_xHqqkZx_
 *						 _xZkqqHx_iOjPiCmMjFlGiOjKiImKjChFiBgKiCmMjDpBiCmCjBePiCmMjFlGiOjKiCmMiDgNiBfLiDgI_xHqqkZx_
 *						 _xZkqqHx_iCpAiOhHjCoIiBeCjHmKiOhHjCoIiOhB_xHqqkZx_(*,+,?)_xZkqqHx_iCmMiOjOiCmJjHjIjHhAiClDiCoKiCoJiBeC_xHqqkZx_
 *			pPreNode	:_xZkqqHx_iClBiCoKiCkJiCoHiPiIjHjNiClHiCoJjFlGiOjKiImKjChFiBgJjBkGiClPjCmKiPoNjFlGiOjKiCmM_xHqqkZx_
 *						 _xZkqqHx_iOjPiCmMjFlGiOjKiImKjChFiBgKiCmMiIoKiCmCjBePiCmMjFlGiOjKiCmMiDgNiBfLiDgI_xHqqkZx_
 *						 _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			wPreChar	:_xZkqqHx_iClBiCoKiCkJiCoHiPiIjHjNiClHiCoJjFlGiOjKiImKjChFiBgJjBkGiClPjCmKiPoNjFlGiOjKiCmM_xHqqkZx_
 *						 _xZkqqHx_iOjPiCmMjFlGiOjKiImKjChFiBgKiCmMiIoKiCmCjBePiCmMjFlGiOjKiCpAiOhHjCoIiBeC_xHqqkZx_
 *			tcpHead		:_xZkqqHx_iClBiCoKiCkJiCoHiPiIjHjNiClHiCoJjFlGiOjKjHpBiCmMjAoGjDkKiCpAiOhHjCoIiBgJjBkGiClP_xHqqkZx_
 *						 _xZkqqHx_jCmKiPoNjFlGiOjKiCmMiOjPiCmMjFlGiOjKiImKjChFiBgK_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeHiDiJiBfLiCmMiPoKiNiHiCmN_xHqqkZx_ FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.16 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL RegExpNFASub::MkNodeLetterChar (RegExpNode* pPre2Node, RegExpNode* pPreNode,
									WORD wPreChar, CTCP& tcpHead)
{
	if (m_wFlags & DREX_EXP_TO_UPCASE)
	//----- _xZkqqHx_jBoFjFlGiOjKiCnGjFmPiKlHiPiIjHjN_xHqqkZx_ -----
	{
		// _xZkqqHx_jBoFjFlGiOjKiCnGjFmPiKlHiBeC_xHqqkZx_
		if (_T('a') <= wPreChar && wPreChar <= _T('z'))
			wPreChar -= int(_T('a')) - int(_T('A'));
	}
	// _xZkqqHx_iCfAiCmCjBePiCmMiDgNiBfLiDgIiCmMiMoDiCoLiCmJjCmKiPoNjFlGiOjKiDgNiBfLiDgIiCpAjCmHiJmBiBeC_xHqqkZx_
	pPreNode->m_pNodeNext = new RegNodeLetterChar(wPreChar, m_wFlags);
	// _xZkqqHx_iOjPiCmMjFlGiOjKiCmMiPiIjHjNiCpAiNhDiCkEiBeC_xHqqkZx_
	return MkNodeGeneral(pPreNode, pPreNode->m_pNodeNext, tcpHead);
} // RegExpNFASub::MkNodeLetterChar.

