#include "General.h"
#include "RegExpNode.h"		// This header.

/////////////////////////////////////////////////////////////////////////
// RegExpNode_xZkqqHx_iDeDiDjDiDhGiDiKiDiBiDjDiDgHiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	RegExpNode::RegExpNode
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.16 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
RegExpNode::RegExpNode () : m_pNodeNext(NULL) {}

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	RegExpNode::~RegExpNode
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.16 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
RegExpNode::~RegExpNode ()
{
	// _xZkqqHx_iOjPiCmMiDgNiBfLiDgIiCpAiNoNiPjMiClHiCoJiBeCiMiLiJmKiBeBiNmEiLeBjDeJiCmJiNoNiPjMiClDiCoKiCmEiCkCiCkNiBeC_xHqqkZx_
	if (m_pNodeNext != NULL) delete m_pNodeNext;
	m_pNodeNext = NULL;
} // RegExpNode::~RegExpNode.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	RegExpNode::IsKindOf
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDeOiDiJiDfIiCkKiBeBiOhHjCoIiCmMiDeOiDiJiDfIiCmMiDfEiDhFiDeOiDiJiDfIiCmFiCkAiCoJiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	type	:_xZkqqHx_jClCiCnHiCoJiDeOiDiJiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfEiDhFiDeOiDiJiDfIiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.16 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL RegExpNode::IsKindOf (NODE_TYPE type)
{
	return type == NODE_NONE;
} // RegExpNode::IsKindOf.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	RegExpNode::IsMatch
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMjFlGiOjKjHpBiCmMjAoGjDkKjFlGiOjKiCmJiBeBiClBiCmMiDeJiDhFiDfHiDeGiDeOiDgHiCkKiDhNiDgCiDgAiClFiCmEiCkCiCoJiCkJ_xHqqkZx_
 *			_xZkqqHx_iCmHiCkEiCkJiCpAjClCiCnHiCoJiBeCiDhNiDgCiDgAiClFiCmEiCkCiCoJiPoKiNiHiCmNiBeBiOjPiCmMiDgNiBfLiDgIiCmJiPiIjHjNiCpA_xHqqkZx_
 *			_xZkqqHx_jBjHiCoJiCmMiCmFiBeBjIeBiNlNjDeJiCmJjFlGiOjKjHpBjBfDjBmMiCmMiDhNiDgCiDgAiDjDiDePiCpAjClCiCnHiCoJiClBiCmGiCkKiPgPjHiIiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wPreChar	:tcpStr_xZkqqHx_iCmMjFlGiOjKiImKjChFiCmMiIoKiCmCjBePiCmMjFlGiOjKiCpAiOhHjCoIiBeC_xHqqkZx_
 *						 _xZkqqHx_iDhNiDgCiDgAiClFiClNiPoKiNiHiCmNiBeBiIoKjChGiClFiClNjEmNiImNiCmMiNmFiMoDiCmMjFlGiOjKiCpA_xHqqkZx_
 *						 _xZkqqHx_jFnEiClHiBeC_xHqqkZx_
 *			tcpStr		:_xZkqqHx_iClBiCoKiCkJiCoHjClCiCnHiCoJjFlGiOjKjHpBiCmMjAoGjDkKiCpAiOhHjCoIiBeC_xHqqkZx_
 *						 _xZkqqHx_iDhNiDgCiDgAiClFiClNiPoKiNiHiCmNiBeBiIoKjChGiClFiClNjEmNiImNiCmMiOjPiCmMjFlGiOjKiImKjChFiCpA_xHqqkZx_
 *						 _xZkqqHx_jFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhNiDgCiDgAiClFiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.16 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL RegExpNode::IsMatch (WORD& wPreChar, CTCP& tcpStr, CTCP tcpStrEnd)
{
	return FALSE;
} // RegExpNode::IsMatch.

/////////////////////////////////////////////////////////////////////////
// RegNodeAnyCode_xZkqqHx_iDeDiDjDiDhGiDiKiDiBiDjDiDgHiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	RegNodeAnyCode::IsKindOf
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDeOiDiJiDfIiCkKiBeBiOhHjCoIiCmMiDeOiDiJiDfIiCmMiDfEiDhFiDeOiDiJiDfIiCmFiCkAiCoJiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	type	:_xZkqqHx_jClCiCnHiCoJiDeOiDiJiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfEiDhFiDeOiDiJiDfIiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.16 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL RegNodeAnyCode::IsKindOf (NODE_TYPE type)
{
	if (type == NODE_CODE) return TRUE;
	return RegExpNode::IsKindOf(type);
} // RegNodeAnyCode::IsKindOf.

/////////////////////////////////////////////////////////////////////////
// RegNodeAnyChar_xZkqqHx_iDeDiDjDiDhGiDiKiDiBiDjDiDgHiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	RegNodeAnyChar::IsKindOf
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDeOiDiJiDfIiCkKiBeBiOhHjCoIiCmMiDeOiDiJiDfIiCmMiDfEiDhFiDeOiDiJiDfIiCmFiCkAiCoJiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	type	:_xZkqqHx_jClCiCnHiCoJiDeOiDiJiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfEiDhFiDeOiDiJiDfIiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.16 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL RegNodeAnyChar::IsKindOf (NODE_TYPE type)
{
	if (type == NODE_CHAR) return TRUE;
	return RegExpNode::IsKindOf(type);
} // RegNodeAnyChar::IsKindOf.

/////////////////////////////////////////////////////////////////////////
// RegNodeQuantCode_xZkqqHx_iDeDiDjDiDhGiDiKiDiBiDjDiDgHiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	RegNodeQuantCode::RegNodeQuantCode
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wChar		:_xZkqqHx_jHmKiOhHjCoIiOhBiCmMiOoNjHnOiCpAiOhHjCoIiBeC_xHqqkZx_'+','*','?'
 *			pSubNode	:_xZkqqHx_jHmKiOhHjCoIiOhBiCmFiPeDiPpMiClDiCoKiCoJiDfEiDhFiDgNiBfLiDgIiCpAiOhHjCoIiBeC_xHqqkZx_".*"_xZkqqHx_iCmMiPoKiNiHiCmM_xHqqkZx_"."
 *			dwQTimes	:+,*_xZkqqHx_iCmMiMeKiCoIjFnEiClFiJpBjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.16 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
RegNodeQuantCode::RegNodeQuantCode (WORD wChar, RegExpNode* pSubNode, DWORD dwQTimes)
{
	m_wCode = wChar;
	m_pSubNode = pSubNode;
	m_dwQTimes = dwQTimes;
} // RegNodeQuantCode::RegNodeQuantCode.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	RegNodeQuantCode::~RegNodeQuantCode
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.16 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
RegNodeQuantCode::~RegNodeQuantCode ()
{
	if (m_pSubNode != NULL) delete m_pSubNode;
	m_pSubNode = NULL;
} // RegNodeQuantCode::~RegNodeQuantCode.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	RegNodeQuantCode::IsKindOf
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDeOiDiJiDfIiCkKiBeBiOhHjCoIiCmMiDeOiDiJiDfIiCmMiDfEiDhFiDeOiDiJiDfIiCmFiCkAiCoJiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	type	:_xZkqqHx_jClCiCnHiCoJiDeOiDiJiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfEiDhFiDeOiDiJiDfIiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.16 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL RegNodeQuantCode::IsKindOf (NODE_TYPE type)
{
	if (type == NODE_QUANT_CODE) return TRUE;
	return RegNodeAnyCode::IsKindOf(type);
} // RegNodeQuantCode::IsKindOf.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	RegNodeQuantCode::IsMatch
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMjFlGiOjKjHpBiCmMjAoGjDkKjFlGiOjKiCmJiBeBiClBiCmMiDeJiDhFiDfHiDeGiDeOiDgHiCkKiDhNiDgCiDgAiClFiCmEiCkCiCoJiCkJ_xHqqkZx_
 *			_xZkqqHx_iCmHiCkEiCkJiCpAjClCiCnHiCoJiBeCiDhNiDgCiDgAiClFiCmEiCkCiCoJiPoKiNiHiCmNiBeBiOjPiCmMiDgNiBfLiDgIiCmJiPiIjHjNiCpA_xHqqkZx_
 *			_xZkqqHx_jBjHiCoJiCmMiCmFiBeBjIeBiNlNjDeJiCmJjFlGiOjKjHpBjBfDjBmMiCmMiDhNiDgCiDgAiDjDiDePiCpAjClCiCnHiCoJiClBiCmGiCkKiPgPjHiIiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wPreChar	:tcpStr_xZkqqHx_iCmMjFlGiOjKiImKjChFiCmMiIoKiCmCjBePiCmMjFlGiOjKiCpAiOhHjCoIiBeC_xHqqkZx_
 *						 _xZkqqHx_iDhNiDgCiDgAiClFiClNiPoKiNiHiCmNiBeBiIoKjChGiClFiClNjEmNiImNiCmMiNmFiMoDiCmMjFlGiOjKiCpA_xHqqkZx_
 *						 _xZkqqHx_jFnEiClHiBeC_xHqqkZx_
 *			tcpStr		:_xZkqqHx_iClBiCoKiCkJiCoHjClCiCnHiCoJjFlGiOjKjHpBiCmMjAoGjDkKiCpAiOhHjCoIiBeC_xHqqkZx_
 *						 _xZkqqHx_iDhNiDgCiDgAiClFiClNiPoKiNiHiCmNiBeBiIoKjChGiClFiClNjEmNiImNiCmMiOjPiCmMjFlGiOjKiImKjChFiCpA_xHqqkZx_
 *						 _xZkqqHx_jFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhNiDgCiDgAiClFiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.16 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL RegNodeQuantCode::IsMatch (WORD& wPreChar, CTCP& tcpStr, CTCP tcpStrEnd)
{
	switch (m_wCode)
	{
	case _T('*'):	// _xZkqqHx_iCePiJpBiImIiPoDiBeC_xHqqkZx_
		return IsMatchSub(wPreChar, tcpStr, tcpStrEnd, m_dwQTimes);
	case _T('+'):	// _xZkqqHx_iCfAiJpBiImIiPoDiBeC_xHqqkZx_
		// _xZkqqHx_iNmFjCoBiCmFiCoAiCfAiJpBiDfEiDhFiDgNiBfLiDgIiCkKiDhNiDgCiDgAiClFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
		if (!m_pSubNode->IsMatch(wPreChar, tcpStr, tcpStrEnd)) return FALSE;
		return IsMatchSub(wPreChar, tcpStr, tcpStrEnd, m_dwQTimes);
	case _T('?'):	// _xZkqqHx_iCePiJpBiIlNiCkCiCmNiCfAiJpBiBeC_xHqqkZx_
	  {
		WORD wCharBak = wPreChar;
		CTCP tcpStrBak = tcpStr;
		// _xZkqqHx_iDfEiDhFiDgNiBfLiDgIiCkKiIoKiJpBiIoKjChGiClHiCoJiPoKiNiHiCmNiBeBiOjPiCmMiDgNiBfLiDgIiCmJiPiIjHjNiCpAjAgJiCnPiCoJiBeC_xHqqkZx_
		if (m_pSubNode->IsMatch(wPreChar, tcpStr, tcpStrEnd))
		{
			// _xZkqqHx_iOjPiCmMiDgNiBfLiDgIiCkKjGlDiCkCiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
			if (m_pNodeNext == NULL) return TRUE;
			if (m_pNodeNext->IsMatch(wPreChar, tcpStr, tcpStrEnd)) return TRUE;
		}
		// _xZkqqHx_iOlIjEhDiClFiClNiCmMiCmFjCgMiCpAjGnPiClHiBeC_xHqqkZx_
		wPreChar = wCharBak;
		tcpStr = tcpStrBak;
		// _xZkqqHx_iOjPiCmMiDgNiBfLiDgIiCkKjGlDiCkCiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
		if (m_pNodeNext == NULL) return TRUE;
		// _xZkqqHx_iOjPiCmMiDgNiBfLiDgIiCmMiDhNiDgCiDgAiDjDiDePiMiLiJmKiCpAjFnEiClHiBeC_xHqqkZx_
		return m_pNodeNext->IsMatch(wPreChar, tcpStr, tcpStrEnd);
	  }
	default:	// _xZkqqHx_jGkCiDfEiDhMiBfLiDgHjHmKiOhHjCoIiOhBiBeCiCkAiCoIjDlOiCmIiCkCiBeC_xHqqkZx_
		return FALSE;
	}
} // RegNodeQuantCode::IsMatch.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	RegNodeQuantCode::IsMatchSub
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	IsMatch_xZkqqHx_iCmMjFoCiPjFiKnGjAjEiBeCjHmKiOhHjCoIiOhBiCmNiBeBiJlNiJpBjBlBiCkNiCkJiCoNiCkJiCoHiCmIiCkCiCmMiCmFiBeB_xHqqkZx_
 *			_xZkqqHx_iClLiCoKiCpAiNmEiLeBjDeJiCmJiPiIjHjNiClFiBeBiDhNiDgCiDgAiDjDiDePiImKjChFiCpAiLiBiCnPiCoJiBeC_xHqqkZx_"+","*"_xZkqqHx_iCmF_xHqqkZx_
 *			_xZkqqHx_iCmMiCnNiOgHjHhAiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wPreChar	:tcpStr_xZkqqHx_iCmMjFlGiOjKiImKjChFiCmMiIoKiCmCjBePiCmMjFlGiOjKiCpAiOhHjCoIiBeC_xHqqkZx_
 *						 _xZkqqHx_iDhNiDgCiDgAiClFiClNiPoKiNiHiCmNiBeBiIoKjChGiClFiClNjEmNiImNiCmMiNmFiMoDiCmMjFlGiOjKiCpA_xHqqkZx_
 *						 _xZkqqHx_jFnEiClHiBeC_xHqqkZx_
 *			tcpStr		:_xZkqqHx_iClBiCoKiCkJiCoHjClCiCnHiCoJjFlGiOjKjHpBiCmMjAoGjDkKiCpAiOhHjCoIiBeC_xHqqkZx_
 *						 _xZkqqHx_iDhNiDgCiDgAiClFiClNiPoKiNiHiCmNiBeBiIoKjChGiClFiClNjEmNiImNiCmMiOjPiCmMjFlGiOjKiImKjChFiCpA_xHqqkZx_
 *						 _xZkqqHx_jFnEiClHiBeC_xHqqkZx_
 *			dwCount		:IsMatchSub_xZkqqHx_iCmMiOgDiCoIiCmMiDgMiDfIiDgHiJmCjEfMiCmIiJpBjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhNiDgCiDgAiClFiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	1._xZkqqHx_jIeBjBlBiClHiCoJjFlGiOjKiCkKjBlBiCkNiKnEiCmNiBeBiNmFiMoDiCnMiCmFiMjPiNpFiClHiCoJiBeC_xHqqkZx_
 *			2._xZkqqHx_iOjPiCmMiDgNiBfLiDgIiCmJiDhNiDgCiDgAiDjDiDePiPiIjHjNiCpAjAgJiCnPiCoJiBeC_xHqqkZx_
 *			3.2._xZkqqHx_iCmMiDhNiDgCiDgAiDjDiDePiCkKiIoKjChGiClFiCmIiCkCiPoKiNiHiCmNiBeBiIoKiCmCjGnPiCoJiBeC_xHqqkZx_
 *			4._xZkqqHx_iIoKiCmCjGnPiCmBiClNiImKjChFiCkJiCoHiBeBiOjPiCmMiDgNiBfLiDgIiCmJiDhNiDgCiDgAiDjDiDePiPiIjHjNiCpAjAgJiCnPiCoJiBeC_xHqqkZx_
 *			5.4._xZkqqHx_iCmMiDhNiDgCiDgAiDjDiDePiCkKiIoKjChGiClFiCmIiCkCiPoKiNiHiCmNiBeBiIoKiCmCjGnPiCoJiBeC_xHqqkZx_
 *			6._xZkqqHx_iIoKiCmCjGnPiCmBiClNiImKjChFiCkJiCoHiBeBiOjPiCmMiDgNiBfLiDgIiCmJiDhNiDgCiDgAiDjDiDePiPiIjHjNiCpAjAgJiCnPiCoJiBeC_xHqqkZx_
 *			7.5._xZkqqHx_iBgA_xHqqkZx_6._xZkqqHx_iCmMiPiIjHjNiCpAiBeBiIoKjChGiClHiCoJiCnMiCmFiMeKiCoIjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.16 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL RegNodeQuantCode::IsMatchSub (WORD& wPreChar, CTCP& tcpStr, CTCP tcpStrEnd, DWORD dwCount)
{
	if (dwCount != 0)
	{
		WORD wCharBak = wPreChar;
		CTCP tcpStrBak = tcpStr;
		// _xZkqqHx_iDfEiDhFiDgNiBfLiDgIiCmMiIoKjChGiCkKjBlBiCkNiMmAiCoIiBeBiNmEiLeBjDeJiCmJ_xHqqkZx_*_xZkqqHx_iPiIjHjNiCpAjBlBiCkPiCoJiBeC_xHqqkZx_
		if (m_pSubNode->IsMatch(wPreChar, tcpStr, tcpStrEnd))
			if (IsMatchSub(wPreChar, tcpStr, tcpStrEnd, dwCount - 1)) return TRUE;
		// _xZkqqHx_iOlIjEhDiClFiClNiCmMiCmFjCgMiCpAjGnPiClHiBeC_xHqqkZx_
		wPreChar = wCharBak;
		tcpStr = tcpStrBak;
	}
	// _xZkqqHx_iDfEiDhFiDgNiBfLiDgIiIoKjChGiCkKiPeJiCoNiCoIiBeBiOjPiCmMiDgNiBfLiDgIiCkKjGlDiCkCiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
	if (m_pNodeNext == NULL) return TRUE;
	// _xZkqqHx_iOjPiCmMiDgNiBfLiDgIiCmMiDhNiDgCiDgAiDjDiDePiMiLiJmKiCpAjFnEiClHiBeC_xHqqkZx_
	return m_pNodeNext->IsMatch(wPreChar, tcpStr, tcpStrEnd);
} // RegNodeQuantCode::IsMatchSub.

/////////////////////////////////////////////////////////////////////////
// RegNodeAssertCode_xZkqqHx_iDeDiDjDiDhGiDiKiDiBiDjDiDgHiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	RegNodeAssertCode::RegNodeAssertCode
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.16 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
RegNodeAssertCode::RegNodeAssertCode (WORD wChar)
{
	m_wCode = wChar;
} // RegNodeAssertCode::RegNodeAssertCode.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	RegNodeAssertCode::IsKindOf
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDeOiDiJiDfIiCkKiBeBiOhHjCoIiCmMiDeOiDiJiDfIiCmMiDfEiDhFiDeOiDiJiDfIiCmFiCkAiCoJiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	type	:_xZkqqHx_jClCiCnHiCoJiDeOiDiJiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfEiDhFiDeOiDiJiDfIiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.16 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL RegNodeAssertCode::IsKindOf (NODE_TYPE type)
{
	if (type == NODE_ASSERT_CODE) return TRUE;
	return RegNodeAnyCode::IsKindOf(type);
} // RegNodeAssertCode::IsKindOf.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	RegNodeAssertCode::IsMatch
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMjFlGiOjKjHpBiCmMjAoGjDkKjFlGiOjKiCmJiBeBiClBiCmMiDeJiDhFiDfHiDeGiDeOiDgHiCkKiDhNiDgCiDgAiClFiCmEiCkCiCoJiCkJ_xHqqkZx_
 *			_xZkqqHx_iCmHiCkEiCkJiCpAjClCiCnHiCoJiBeCiDhNiDgCiDgAiClFiCmEiCkCiCoJiPoKiNiHiCmNiBeBiOjPiCmMiDgNiBfLiDgIiCmJiPiIjHjNiCpA_xHqqkZx_
 *			_xZkqqHx_jBjHiCoJiCmMiCmFiBeBjIeBiNlNjDeJiCmJjFlGiOjKjHpBjBfDjBmMiCmMiDhNiDgCiDgAiDjDiDePiCpAjClCiCnHiCoJiClBiCmGiCkKiPgPjHiIiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wPreChar	:tcpStr_xZkqqHx_iCmMjFlGiOjKiImKjChFiCmMiIoKiCmCjBePiCmMjFlGiOjKiCpAiOhHjCoIiBeC_xHqqkZx_
 *						 _xZkqqHx_iDhNiDgCiDgAiClFiClNiPoKiNiHiCmNiBeBiIoKjChGiClFiClNjEmNiImNiCmMiNmFiMoDiCmMjFlGiOjKiCpA_xHqqkZx_
 *						 _xZkqqHx_jFnEiClHiBeC_xHqqkZx_
 *			tcpStr		:_xZkqqHx_iClBiCoKiCkJiCoHjClCiCnHiCoJjFlGiOjKjHpBiCmMjAoGjDkKiCpAiOhHjCoIiBeC_xHqqkZx_
 *						 _xZkqqHx_iDhNiDgCiDgAiClFiClNiPoKiNiHiCmNiBeBiIoKjChGiClFiClNjEmNiImNiCmMiOjPiCmMjFlGiOjKiImKjChFiCpA_xHqqkZx_
 *						 _xZkqqHx_jFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhNiDgCiDgAiClFiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.16 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL RegNodeAssertCode::IsMatch (WORD& wPreChar, CTCP& tcpStr, CTCP tcpStrEnd)
{
	CTCP tcpNext;
	switch (m_wCode)
	{
	case _T('^'):	// _xZkqqHx_jFlGjDkKiBeC_xHqqkZx_
		// _xZkqqHx_jClMjBePiCmMjFlGiOjKiCkKiNhDjGjGjFlGiOjKiCkJiBeI_xHqqkZx_
		if (!IsLineEnd(wPreChar)) return FALSE;
		break;
	case _T('$'):	// _xZkqqHx_jFlGjGjGiBeC_xHqqkZx_
		if (!IsLineEnd(GetWChar(tcpNext, tcpStr, tcpStrEnd))) return FALSE;
		break;
	case _T('b'):	// _xZkqqHx_jCfAiMoKiLkLiKeFiBeC_xHqqkZx_
		if (WCharKind(wPreChar) == WCharKind(GetWChar(tcpNext, tcpStr, tcpStrEnd))) return FALSE;
		break;
	default:
		return FALSE;
	}
	if (m_pNodeNext == NULL) return TRUE;
	return m_pNodeNext->IsMatch(wPreChar, tcpStr, tcpStrEnd);
} // RegNodeAssertCode::IsMatch.

/////////////////////////////////////////////////////////////////////////
// RegNodeAmbigChar_xZkqqHx_iDeDiDjDiDhGiDiKiDiBiDjDiDgHiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	RegNodeAmbigChar::RegNodeAmbigChar
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.16 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
RegNodeAmbigChar::RegNodeAmbigChar (WORD wChar)
{
	m_wCode = wChar;
} // RegNodeAmbigChar::RegNodeAmbigChar.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	RegNodeAmbigChar::IsKindOf
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDeOiDiJiDfIiCkKiBeBiOhHjCoIiCmMiDeOiDiJiDfIiCmMiDfEiDhFiDeOiDiJiDfIiCmFiCkAiCoJiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	type	:_xZkqqHx_jClCiCnHiCoJiDeOiDiJiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfEiDhFiDeOiDiJiDfIiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.16 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL RegNodeAmbigChar::IsKindOf (NODE_TYPE type)
{
	if (type == NODE_AMBIG_CHAR) return TRUE;
	return RegNodeAnyChar::IsKindOf(type);
} // RegNodeAmbigChar::IsKindOf.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	RegNodeAmbigChar::IsMatch
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMjFlGiOjKjHpBiCmMjAoGjDkKjFlGiOjKiCmJiBeBiClBiCmMiDeJiDhFiDfHiDeGiDeOiDgHiCkKiDhNiDgCiDgAiClFiCmEiCkCiCoJiCkJ_xHqqkZx_
 *			_xZkqqHx_iCmHiCkEiCkJiCpAjClCiCnHiCoJiBeCiDhNiDgCiDgAiClFiCmEiCkCiCoJiPoKiNiHiCmNiBeBiOjPiCmMiDgNiBfLiDgIiCmJiPiIjHjNiCpA_xHqqkZx_
 *			_xZkqqHx_jBjHiCoJiCmMiCmFiBeBjIeBiNlNjDeJiCmJjFlGiOjKjHpBjBfDjBmMiCmMiDhNiDgCiDgAiDjDiDePiCpAjClCiCnHiCoJiClBiCmGiCkKiPgPjHiIiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wPreChar	:tcpStr_xZkqqHx_iCmMjFlGiOjKiImKjChFiCmMiIoKiCmCjBePiCmMjFlGiOjKiCpAiOhHjCoIiBeC_xHqqkZx_
 *						 _xZkqqHx_iDhNiDgCiDgAiClFiClNiPoKiNiHiCmNiBeBiIoKjChGiClFiClNjEmNiImNiCmMiNmFiMoDiCmMjFlGiOjKiCpA_xHqqkZx_
 *						 _xZkqqHx_jFnEiClHiBeC_xHqqkZx_
 *			tcpStr		:_xZkqqHx_iClBiCoKiCkJiCoHjClCiCnHiCoJjFlGiOjKjHpBiCmMjAoGjDkKiCpAiOhHjCoIiBeC_xHqqkZx_
 *						 _xZkqqHx_iDhNiDgCiDgAiClFiClNiPoKiNiHiCmNiBeBiIoKjChGiClFiClNjEmNiImNiCmMiOjPiCmMjFlGiOjKiImKjChFiCpA_xHqqkZx_
 *						 _xZkqqHx_jFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhNiDgCiDgAiClFiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.16 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL RegNodeAmbigChar::IsMatch (WORD& wPreChar, CTCP& tcpStr, CTCP tcpStrEnd)
{
	CTCP tcpNext;
	WORD wChar = GetWChar(tcpNext, tcpStr, tcpStrEnd);
	// _xZkqqHx_jFlGjGjGiCmIiCoHiCmOiBeB_xHqqkZx_FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
	if (wChar == _T('\0')) return FALSE;
	switch (m_wCode)
	{
	case _T('.'):	// _xZkqqHx_iJpMiNhDiCpAiPjMiCkNjBfDiCmEiCmMiCfAjFlGiOjKiBeC_xHqqkZx_
		if (wChar == _T('\r') || wChar == _T('\n')) return FALSE;
		break;
	case _T('d'):	// _xZkqqHx_jAjEiOjKiBeC_xHqqkZx_
		if (!IsDigit(wChar)) return FALSE;
		break;
	case _T('w'):	// _xZkqqHx_jCfAiMoKiBeC_xHqqkZx_
		if (!IsWordAtom(wChar)) return FALSE;
		break;
	case _T('s'):	// _xZkqqHx_iLpDjEjCiBeC_xHqqkZx_
		if (!IsSpace(wChar)) return FALSE;
		break;
	default:
		return FALSE;
	}
	// _xZkqqHx_iMhAjBlBiCmMiOkOiCkKiIoKjChGiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
	if (m_pNodeNext != NULL)
		if (!m_pNodeNext->IsMatch(wChar, tcpNext, tcpStrEnd)) return FALSE;
	// _xZkqqHx_iIoKjChGiClFiClNiImKjChFiCnMiCmFjFlGiOjKiCpAjAgJiCnPiCoJiBeC_xHqqkZx_
	wPreChar = wChar;
	tcpStr = tcpNext;
	return TRUE;
} // RegNodeAmbigChar::IsMatch.

/////////////////////////////////////////////////////////////////////////
// RegNodeLetterChar_xZkqqHx_iDeDiDjDiDhGiDiKiDiBiDjDiDgHiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	RegNodeLetterChar::RegNodeLetterChar
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.16 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
RegNodeLetterChar::RegNodeLetterChar (WORD wChar, WORD wFlags)
{
	m_wFlags = wFlags;
	m_wChar = wChar;
} // RegNodeLetterChar::RegNodeLetterChar.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	RegNodeLetterChar::IsKindOf
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDeOiDiJiDfIiCkKiBeBiOhHjCoIiCmMiDeOiDiJiDfIiCmMiDfEiDhFiDeOiDiJiDfIiCmFiCkAiCoJiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	type	:_xZkqqHx_jClCiCnHiCoJiDeOiDiJiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfEiDhFiDeOiDiJiDfIiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.16 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL RegNodeLetterChar::IsKindOf (NODE_TYPE type)
{
	if (type == NODE_LETTER_CHAR) return TRUE;
	return RegNodeAnyChar::IsKindOf(type);
} // RegNodeLetterChar::IsKindOf.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	RegNodeLetterChar::IsMatch
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMjFlGiOjKjHpBiCmMjAoGjDkKjFlGiOjKiCmJiBeBiClBiCmMiDeJiDhFiDfHiDeGiDeOiDgHiCkKiDhNiDgCiDgAiClFiCmEiCkCiCoJiCkJ_xHqqkZx_
 *			_xZkqqHx_iCmHiCkEiCkJiCpAjClCiCnHiCoJiBeCiDhNiDgCiDgAiClFiCmEiCkCiCoJiPoKiNiHiCmNiBeBiOjPiCmMiDgNiBfLiDgIiCmJiPiIjHjNiCpA_xHqqkZx_
 *			_xZkqqHx_jBjHiCoJiCmMiCmFiBeBjIeBiNlNjDeJiCmJjFlGiOjKjHpBjBfDjBmMiCmMiDhNiDgCiDgAiDjDiDePiCpAjClCiCnHiCoJiClBiCmGiCkKiPgPjHiIiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wPreChar	:tcpStr_xZkqqHx_iCmMjFlGiOjKiImKjChFiCmMiIoKiCmCjBePiCmMjFlGiOjKiCpAiOhHjCoIiBeC_xHqqkZx_
 *						 _xZkqqHx_iDhNiDgCiDgAiClFiClNiPoKiNiHiCmNiBeBiIoKjChGiClFiClNjEmNiImNiCmMiNmFiMoDiCmMjFlGiOjKiCpA_xHqqkZx_
 *						 _xZkqqHx_jFnEiClHiBeC_xHqqkZx_
 *			tcpStr		:_xZkqqHx_iClBiCoKiCkJiCoHjClCiCnHiCoJjFlGiOjKjHpBiCmMjAoGjDkKiCpAiOhHjCoIiBeC_xHqqkZx_
 *						 _xZkqqHx_iDhNiDgCiDgAiClFiClNiPoKiNiHiCmNiBeBiIoKjChGiClFiClNjEmNiImNiCmMiOjPiCmMjFlGiOjKiImKjChFiCpA_xHqqkZx_
 *						 _xZkqqHx_jFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhNiDgCiDgAiClFiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.16 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL RegNodeLetterChar::IsMatch (WORD& wPreChar, CTCP& tcpStr, CTCP tcpStrEnd)
{
	CTCP tcpNext;
	WORD wChar = GetWChar(tcpNext, tcpStr, tcpStrEnd);
	// _xZkqqHx_jFlGjGjGiCmIiCoHiCmOiBeB_xHqqkZx_FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
	if (wChar == _T('\0')) return FALSE;
	if (m_wFlags & DREX_EXP_TO_UPCASE)
	//----- _xZkqqHx_jBoFjFlGiOjKiCnGjFmPiKlHiPiIjHjN_xHqqkZx_ -----
	{
		// _xZkqqHx_jBoFjFlGiOjKiCnGjFmPiKlHiBeC_xHqqkZx_
		if (_T('a') <= wChar && wChar <= _T('z'))
			wChar -= int(_T('a')) - int(_T('A'));
	}
	// _xZkqqHx_jFlGiOjKiCkKiIoKjChGiClFiCmIiCkCiCmIiCoHiCmO_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
	if (wChar != m_wChar) return FALSE;
	// _xZkqqHx_iMhAjBlBiCmMiOkOiCkKiIoKjChGiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
	if (m_pNodeNext != NULL)
		if (!m_pNodeNext->IsMatch(wChar, tcpNext, tcpStrEnd)) return FALSE;
	// _xZkqqHx_iIoKjChGiClFiClNiImKjChFiCnMiCmFjFlGiOjKiCpAjAgJiCnPiCoJiBeC_xHqqkZx_
	wPreChar = wChar;
	tcpStr = tcpNext;
	return TRUE;
} // RegNodeLetterChar::IsMatch.

