#ifndef __RegExpNode_h
#define __RegExpNode_h

/*************************************************************************
 * <_xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_>	RegExpNode.h
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAlDiLeLjFfMiMlLiOkOjCiGiCmMiBeBiKgFiDgNiBfLiDgI_xHqqkZx_(_xZkqqHx_jFlGiOjK_xHqqkZx_,*,+,\w,\s,etc)_xZkqqHx_iCmMiDeJiDhFiDfHiDeGiDeOiDgHiCpA_xHqqkZx_
 *			_xZkqqHx_jCoIiLgAiClHiCoJiDhHiDgCiDfPiBfLiDhEiDeAiDeDiDiLiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.16 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/

//----- _xZkqqHx_iDgNiBfLiDgIiCmMiDeOiDiJiDfIiDfOiDeDiDhGiCpAjCoIiLgA_xHqqkZx_ -----
enum NODE_TYPE
{
	NODE_NONE = 0,
	NODE_CODE,			// _xZkqqHx_iLeMiNiGiDeOiDiJiDfIiBeCiKoOjGhLiDeOiDiJiDfIiBeC_xHqqkZx_
	NODE_CHAR,			// _xZkqqHx_jFlGiOjKiDeOiDiJiDfIiBeCiKoOjGhLiDeOiDiJiDfIiBeC_xHqqkZx_
	NODE_QUANT_CODE,	// _xZkqqHx_jHmKiOhHjCoIiOhBiDeOiDiJiDfIiBeC_xHqqkZx_(+,*,?)
	NODE_ASSERT_CODE,	// _xZkqqHx_iMlOjGlOiOhBiDeOiDiJiDfIiBeC_xHqqkZx_(^,$,\b)
	NODE_PARE_CODE,		// _xZkqqHx_iDeJiBfLiDhGiDjDiKnLiKiHiMmKiDeOiDiJiDfIiBeC_xHqqkZx_"(",")"
	NODE_AMBIG_CHAR,	// _xZkqqHx_jOeCjGiGjFlGiOjKiDeOiDiJiDfIiBeC_xHqqkZx_(.,\d,\s,\w)
	NODE_ENUM_CHAR,		// _xZkqqHx_jHpBiLjDjFlGiOjKiDeOiDiJiDfIiBeC_xHqqkZx_([])
	NODE_LETTER_CHAR,	// _xZkqqHx_jCmKiPoNjFlGiOjKiDeOiDiJiDfIiBeC_xHqqkZx_(a,b,c,etc)
}; // enum NODE_TYPE.

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	RegExpNode
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBfDiCmEiCmMiDgNiBfLiDgIiCmMiKoOjGhLiDeOiDiJiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.16 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
class RegExpNode
{
public:
	RegExpNode ();
	virtual ~RegExpNode ();
	virtual BOOL	IsKindOf (NODE_TYPE type);
	virtual BOOL	IsMatch (WORD& wPreChar, CTCP& tcpStr, CTCP tcpStrEnd);
public:
	RegExpNode*	m_pNodeNext;
}; // class RegExpNode.

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	RegNodeAnyCode
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iLeMiNiGiDeOiDiJiDfIiBeCjHmKiOhHjCoIiOhBiDeOiDiJiDfIiBeBiMlOjGlOiOhBiDeOiDiJiDfIiCmMiKoOjGhLiDeOiDiJiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.16 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
class RegNodeAnyCode : public RegExpNode
{
public:
	virtual BOOL	IsKindOf (NODE_TYPE type);
}; // class RegNodeAnyCode.

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	RegNodeAnyChar
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFlGiOjKiDeOiDiJiDfIiBeCjOeCjGiGjFlGiOjKiDeOiDiJiDfIiBeBjCmKiPoNjFlGiOjKiDeOiDiJiDfIiCmMiKoOjGhLiDeOiDiJiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.16 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
class RegNodeAnyChar : public RegExpNode
{
public:
	virtual BOOL	IsKindOf (NODE_TYPE type);
}; // class RegNodeAnyChar.

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	RegNodeQuantCode
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHmKiOhHjCoIiOhBiDeOiDiJiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.16 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
class RegNodeQuantCode : public RegNodeAnyCode
{
public:
	RegNodeQuantCode (WORD wChar, RegExpNode* pSubNode, DWORD dwQTimes);
	virtual ~RegNodeQuantCode ();
	virtual BOOL	IsKindOf (NODE_TYPE type);
	virtual BOOL	IsMatch (WORD& wPreChar, CTCP& tcpStr, CTCP tcpStrEnd);
protected:
	BOOL	IsMatchSub (WORD& wPreChar, CTCP& tcpStr, CTCP tcpStrEnd, DWORD dwCount);

public:
	WORD			m_wCode;	// _xZkqqHx_jHmKiOhHjCoIiOhBiCmMiOoNjHnOiBeC_xHqqkZx_
	RegExpNode*		m_pSubNode;	// _xZkqqHx_jHmKiOhHjCoIiOhBiCmFiPeDiPpMiClDiCoKiCoJiDfEiDhFiDgNiBfLiDgIiBeC_xHqqkZx_".*"_xZkqqHx_iCmMiPoKiNiHiCmM_xHqqkZx_"."
	DWORD			m_dwQTimes;	// +,*_xZkqqHx_iCmMiMeKiCoIjFnEiClFiJpBjAjEiBeC_xHqqkZx_
}; // class RegNodeQuantCode.

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	RegNodeAssertCode
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlOjGlOiOhBiDeOiDiJiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.16 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
class RegNodeAssertCode : public RegNodeAnyCode
{
public:
	RegNodeAssertCode (WORD wChar);
	virtual BOOL	IsKindOf (NODE_TYPE type);
	virtual BOOL	IsMatch (WORD& wPreChar, CTCP& tcpStr, CTCP tcpStrEnd);
public:
	WORD	m_wCode;
}; // class RegNodeAssertCode.

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	RegNodeAmbigChar
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jOeCjGiGjFlGiOjKiDeOiDiJiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.16 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
class RegNodeAmbigChar : public RegNodeAnyChar
{
public:
	RegNodeAmbigChar (WORD wChar);
	virtual BOOL	IsKindOf (NODE_TYPE type);
	virtual BOOL	IsMatch (WORD& wPreChar, CTCP& tcpStr, CTCP tcpStrEnd);
public:
	WORD	m_wCode;
}; // class RegNodeAmbigChar.

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	RegNodeLetterChar
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jCmKiPoNjFlGiOjKiDeOiDiJiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.16 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
class RegNodeLetterChar : public RegNodeAnyChar
{
public:
	RegNodeLetterChar (WORD wChar, WORD wFlags);
	virtual BOOL	IsKindOf (NODE_TYPE type);
	virtual BOOL	IsMatch (WORD& wPreChar, CTCP& tcpStr, CTCP tcpStrEnd);
public:
	WORD	m_wFlags;
	WORD	m_wChar;
}; // class RegNodeLetterChar.

#endif//!__RegExpNode_h
