// HiDocToolDlg.cpp : _xZkqqHx_iDeDiDjDiDhGiDiKiDiBiDjDiDgFiBfLiDfGiDiHiDjD_xHqqkZx_ _xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_
//

#include "StdAfx.h"
#include <io.h>					// For _access.
#include "HiDocTool.h"
#include "UtilFile.h"			// For FFEnumDirectoryFile.
#include "UtilDlg.h"			// For FFSetDlgItemText.
#include "File32.h"				// For FCFile32.
#include "CRCFileTmpl.h"		// For FCCRCFileTmpl32.
#include "FdbProjectDialog.h"	// For FCFdbProjectDialog.
#include "HiDocToolDlg.h"		// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define WM_USER_PROCEED_DIRECT			(WM_USER + 0x1000)

// _xZkqqHx_iDiKiDeKiDgPiDiKiBfLiDhEiDeAiDeDiDiLiCmMiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
static const BYTE UNDO_CMD_NONE				= 0;	// _xZkqqHx_jGlDiMpIiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
static const BYTE UNDO_CMD_DELETE_DIRECTORY	= 1;	// _xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiNoNiPjMiBeC_xHqqkZx_
static const BYTE UNDO_CMD_CREATE_DIRECTORY	= 2;	// _xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiNoMjAkMiBeC_xHqqkZx_
static const BYTE UNDO_CMD_DELETE_FILE		= 3;	// _xZkqqHx_iDhEiDeAiDeDiDiLiNoNiPjMiBeC_xHqqkZx_
static const BYTE UNDO_CMD_CREATE_FILE		= 4;	// _xZkqqHx_iDhEiDeAiDeDiDiLiNoMjAkMiBeC_xHqqkZx_
static const BYTE UNDO_CMD_MODIFY_FILE		= 5;	// _xZkqqHx_iDhEiDeAiDeDiDiLiPeDjAlDiBeC_xHqqkZx_

// _xZkqqHx_iDiKiDeKiDgPiDiKiBfLiDhEiDeAiDeDiDiLiCmMiPeJjCfLiBeC_xHqqkZx_
#define FD_RECOVER_END_CODE ("?End*Of*File?")
#define FD_RECOVER_END_CODE_LEN (sizeof(FD_RECOVER_END_CODE) - 1)

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	myIsRecoverFileRegal
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iPeDjFjMiDhEiDeAiDeDiDiLiCkKjEgKjBlJiClFiCmEiCkCiCmIiCkCiCkJiDgAiDeGiDgCiDeOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fileRecover	:_xZkqqHx_iDhEiDeAiDeDiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	0	:_xZkqqHx_jAlDiPoNiBeC_xHqqkZx_
 *			1	:_xZkqqHx_iPeDjFjMiDhEiDeAiDeDiDiLiCkKjDhCjCiGiCmFiPeJjHlJiBeC_xHqqkZx_
 *			2	:_xZkqqHx_iPeDjFjMiDhEiDeAiDeDiDiLiCkKjEgKjBlJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.08.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
static int myIsRecoverFileRegal (FCCRCFileTmpl32<FCFile32>& fileRecover)
{
	// _xZkqqHx_iDhEiDeAiDeDiDiLiDfEiDeDiDfJiCkK_xHqqkZx_(CRC+_xZkqqHx_iPeJjCfLiDfCiBfLiDgI_xHqqkZx_)_xZkqqHx_jGkCjGjOiCmIiCoHiCmOjDhCjCiGiPeJjHlJiBeC_xHqqkZx_
	if (fileRecover.GetLength64() < sizeof(WORD) + FD_RECOVER_END_CODE_LEN)
		return 1;
	// _xZkqqHx_iPeJjCfLiDfCiBfLiDgIiCpAjDmHiCnNiPgPiClHiBeC_xHqqkZx_
	fileRecover.Seek64(-long(FD_RECOVER_END_CODE_LEN), FILE_END);
	BYTE buff[FD_RECOVER_END_CODE_LEN];
	fileRecover.Read64(buff, FD_RECOVER_END_CODE_LEN);
	// _xZkqqHx_iPeJjCfLiDfCiBfLiDgIiCkKiKnEiIoBiCmBiCmEiCkCiCoJiPoKiNiHiCmNjDhCjCiGiPeJjHlJiBeC_xHqqkZx_
	if (memcmp(buff, FD_RECOVER_END_CODE, FD_RECOVER_END_CODE_LEN) != 0)
		return 1;
	// _xZkqqHx_iDgGiBfLiDfOjFjEjFkKiCmMiDfEiDeDiDfJiBeC_xHqqkZx_CRC_xZkqqHx_iBeBiPeJjCfLiDfCiBfLiDgIiCmMiDfEiDeDiDfJiCpAiPjMiCkNiBeC_xHqqkZx_
	flint fliDataSize = fileRecover.GetLength64() - sizeof(WORD) - FD_RECOVER_END_CODE_LEN;
	// _xZkqqHx_iDhEiDeAiDeDiDiLjAoGjDkKiCnGiInKjDkOiBeC_xHqqkZx_
	fileRecover.Seek64(0, FILE_BEGIN);
	// CRC_xZkqqHx_iMhGiOfKiCpAiKeKiOgOiBeC_xHqqkZx_
	fileRecover.StartCRC();
	// _xZkqqHx_iDiPiBfLiDeOiDgPiDgCiDhEiDeAiBeC_xHqqkZx_
	BYTE work[0x1000];
	while (fliDataSize != 0)
	{
		// _xZkqqHx_jDmHiCnNiPgPiClHiDgPiDeDiDgHjAjEiCpAiOfKiPgPiBeC_xHqqkZx_
		const flint fliReadSize = (sizeof(work) < fliDataSize) ? sizeof(work) : fliDataSize;
		// _xZkqqHx_iDgGiBfLiDfOiCpAjDmHiCnNiPgPiClHiBeC_xHqqkZx_CRC_xZkqqHx_iCkKiMhGiOfKiClDiCoKiCoJiBeC_xHqqkZx_
		fileRecover.Read64(work, fliReadSize);
		// _xZkqqHx_iOgDiCoIiDgGiBfLiDfOiDfEiDeDiDfJiCpAiMhGiOfKiBeC_xHqqkZx_
		fliDataSize -= fliReadSize;
	}
	// CRC_xZkqqHx_iCpAiOfKiPgPiBeC_xHqqkZx_
	const WORD wCRC = fileRecover.StopCRC();
	WORD wRecCRC;
	// _xZkqqHx_iLeMjIfOiClDiCoKiCmEiCkCiCoJ_xHqqkZx_CRC_xZkqqHx_iCpAjDmHiCnNiPgPiClHiBeC_xHqqkZx_
	fileRecover.Read64(&wRecCRC, sizeof(wRecCRC));
	// _xZkqqHx_iOfKiPgPiClDiCoKiClN_xHqqkZx_CRC_xZkqqHx_iCmGiLeMjIfOiClDiCoKiCmEiCkCiCoJ_xHqqkZx_CRC_xZkqqHx_iCkKiIoKjChGiClFiCmIiCkCiPoKiNiHiCmNjEgKjBlJiBeC_xHqqkZx_
	if (wCRC != wRecCRC)
		return 2;
	return 0;
} // myIsRecoverFileRegal.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	myCheckAccess
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgGiDeCiDiMiDeOiDgHiDiKiJlKiCmJiCkAiCoJiBeBjBfDiCmEiCmMiDhEiDeAiDeDiDiLiBeFiDgGiDeCiDiMiDeOiDgHiDiKiCmM_xHqqkZx_
 *			_xZkqqHx_iDeBiDeOiDfKiDfIiLjGiJmCiCpAiDgAiDeGiDgCiDeOiClHiCoJiBeCiOhHjCoIiClDiCoKiClNiDgGiDeCiDiMiDeOiDgHiDiKiCpAiKnMiCnOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wstrInvalidFile	:_xZkqqHx_iDeBiDeOiDfKiDfIiCkKjFhDiLjGiJmCiCmMiDhEiDeAiDeDiDiLiCpAjFnEiClHiBeC_xHqqkZx_
 *			wcpDirPath		:_xZkqqHx_jClCiCnHiCoJjBmOiPnLiCmMiDgGiDeCiDiMiDeOiDgHiDiKiCpAiOhHjCoIiBeC_xHqqkZx_
 *							 _xZkqqHx_iNmFiMoDiCmJ_xHqqkZx_'\'_xZkqqHx_iCpAjFhEiCkPiCmEiCmNiCkCiCkPiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iCnAiCmGiCmCiCmFiCoAiDeBiDeOiDfKiDfIjFhDiLjGiJmCiCmMiDhEiDeAiDeDiDiLiBeFiDgGiDeCiDiMiDeOiDgHiDiKiCkKjBlGiNnNiClHiCoJ_xHqqkZx_
 *			_xZkqqHx_iPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.08.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
static BOOL myCheckAccess (WString& wstrInvalidFile, const wchar_t* wcpDirPath)
{
	if (!FFCanAllAccessDirectory(wcpDirPath))
	//----- _xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiCmJjDmHiCnNiOoGiCoIiBjFiPjBiCkLiNjOiCnNiCmFiDeBiDeOiDfKiDfIiCmFiCkLiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDeBiDeOiDfKiDfIiCmJiOlIjEhDiClFiClNiDhEiDeAiDeDiDiLiCpAjAnNjCoIiBeC_xHqqkZx_
		wstrInvalidFile = wcpDirPath;
		// _xZkqqHx_iDeHiDiJiBfLjFjMiLeBiBeC_xHqqkZx_
		return FALSE;
	}

	// wcpDirPath_xZkqqHx_iCmMjClMiJlKiCmJiCkAiCoJiDgGiDeCiDiMiDeOiDgHiDiKiBeFiDhEiDeAiDeDiDiLiCmMjHpBiLjDiBeC_xHqqkZx_
	WStringVector vDirName;
	WStringVector vFileName;
	FFEnumDirectoryFile(vDirName,
						vFileName,
						WString(wcpDirPath) + L"\\*");

	WStringVector::const_iterator iStr;
	for (iStr = vFileName.begin(); iStr != vFileName.end(); iStr++)
	//----- _xZkqqHx_iDhEiDeAiDeDiDiLjGlMiCpAiDiLiBfLiDhG_xHqqkZx_ -----
	{
		WString wstrSubFilePath = wcpDirPath;
		wstrSubFilePath += L'\\';
		wstrSubFilePath += *iStr;
		if (_access(WStrToTStr(wstrSubFilePath), 06) == -1)
		//----- _xZkqqHx_jDmHiCnNiOoGiCoIiBjFiPjBiCkLiNjOiCnNiCmFiDeBiDeOiDfKiDfIiCmFiCkLiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDeBiDeOiDfKiDfIiCmJiOlIjEhDiClFiClNiDhEiDeAiDeDiDiLiCpAjAnNjCoIiBeC_xHqqkZx_
			wstrInvalidFile = wstrSubFilePath;
			// _xZkqqHx_iDeHiDiJiBfLjFjMiLeBiBeC_xHqqkZx_
			return FALSE;
		}
	}

	for (iStr = vDirName.begin(); iStr != vDirName.end(); iStr++)
	//----- _xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKjGlMiCpAiDiLiBfLiDhG_xHqqkZx_ -----
	{
		WString wstrSubDirPath = wcpDirPath;
		wstrSubDirPath += L'\\';
		wstrSubDirPath += *iStr;
		// _xZkqqHx_iDfEiDhFiDgGiDeCiDiMiDeOiDgHiDiKiCpAiNmEiLeBjDeJiCmJjClCiNlIiBeC_xHqqkZx_
		if (!myCheckAccess(wstrInvalidFile, wstrSubDirPath))
			return FALSE;	// _xZkqqHx_iDeHiDiJiBfLjFjMiLeBiBeC_xHqqkZx_
	}
	return TRUE;
} // myCheckAccess.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	mySearchRecoverFile
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgGiDeCiDiMiDeOiDgHiDiKiJlKiCmJiCkAiCoJiBeBiPeDjFjMiDhEiDeAiDeDiDiL_xHqqkZx_(*.m)_xZkqqHx_iCmM_xHqqkZx_
 *			_xZkqqHx_iDhEiDeAiDeDiDiLiDhAiDfIjGlMiCpAjBfDiCmEiOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vRecoverFile:_xZkqqHx_iPeDjFjMiDhEiDeAiDeDiDiLiCmMiDhAiDfIjGlMiDiKiDfIiDgHiCpAjFnEiClHiBeCiDhAiDfIjGlMiCmN_xHqqkZx_
 *						 _xZkqqHx_iDhEiDiLiDhAiDfIiCmFjAnNjCoIiClDiCoKiCoJiBeC_xHqqkZx_
 *			wcpDirPath	:_xZkqqHx_jClCiCnHiCoJjBmOiPnLiCmMiDgGiDeCiDiMiDeOiDgHiDiKiCpAiOhHjCoIiBeC_xHqqkZx_
 *						 _xZkqqHx_iNmFiMoDiCmJ_xHqqkZx_'\'_xZkqqHx_iCpAjFhEiCkPiCmEiCmNiCkCiCkPiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
static void mySearchRecoverFile (vector<WString>& vRecoverFile,
								const wchar_t* wcpDirPath)
{
	// _xZkqqHx_iJpBjFjMiDhEiDeAiDeDiDiLjHhAiDgGiDeCiDiMiDeOiDgHiDiKiCpAiNoMjAkMiBeC_xHqqkZx_
	const WString wstrRecoverDir = WString(wcpDirPath) + L'\\' + FDTBL_RECOVER_DIR_NAME;
	// _xZkqqHx_iPeDjFjMiDhEiDeAiDeDiDiLiKgHjCkDiOhBiCpAiOjNiCmCiDhEiDeAiDeDiDiLiCmMjHpBiLjDiBeC_xHqqkZx_
	WStringVector vRecoverFileName;
	FFEnumDirectoryFile(WStringVector(),
						vRecoverFileName,
						wstrRecoverDir + L"\\*" + FDTBL_RECOVER_FILE_EXT);
	// _xZkqqHx_iPeDjFjMiDhEiDeAiDeDiDiLjGlMiCpAiBeBiDhEiDiLiDhAiDfIiCmJiClFiCmE_xHqqkZx_ vRecoverFile _xZkqqHx_iCmJjCmHiJmBiBeC_xHqqkZx_
	WStringVector::const_iterator iStr;
	for (iStr = vRecoverFileName.begin(); iStr != vRecoverFileName.end(); iStr++)
		vRecoverFile.push_back(wstrRecoverDir + L'\\' + *iStr);
} // mySearchRecoverFile.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	myDeleteOldFile
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgGiDeCiDiMiDeOiDgHiDiKiJlKiCmJiCkAiCoJiBeBjBfDiCmEiCmM_xHqqkZx_.OLD_xZkqqHx_iDhEiDeAiDeDiDiLiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wstrInvalidFile	:_xZkqqHx_iDeBiDeOiDfKiDfIiCkKjFhDiLjGiJmCiCmMiDhEiDeAiDeDiDiLiCpAjFnEiClHiBeC_xHqqkZx_
 *			wcpDirPath		:_xZkqqHx_jBmOiPnLiCmMiDgGiDeCiDiMiDeOiDgHiDiKiCpAiOhHjCoIiBeC_xHqqkZx_
 *							 _xZkqqHx_iNmFiMoDiCmJ_xHqqkZx_'\'_xZkqqHx_iCpAjFhEiCkPiCmEiCmNiCkCiCkPiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iCnAiCmGiCmCiCmFiCoAiDeBiDeOiDfKiDfIjFhDiLjGiJmCiCmMiDhEiDeAiDeDiDiLiBeFiDgGiDeCiDiMiDeOiDgHiDiKiCkKjBlGiNnNiClHiCoJ_xHqqkZx_
 *			_xZkqqHx_iPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.08.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
static BOOL myDeleteOldFile (WString& wstrInvalidFile, const wchar_t* wcpDirPath)
{
	// wcpDirPath_xZkqqHx_iCmMjClMiJlKiCmJiCkAiCoJiDgGiDeCiDiMiDeOiDgHiDiKiBeFiDhEiDeAiDeDiDiLiCmMjHpBiLjDiBeC_xHqqkZx_
	WStringVector vDirName;
	WStringVector vFileName;
	FFEnumDirectoryFile(vDirName,
						vFileName,
						WString(wcpDirPath) + L"\\*");
	WStringVector::const_iterator iStr;
	for (iStr = vFileName.begin(); iStr != vFileName.end(); iStr++)
	//----- _xZkqqHx_iDhEiDeAiDeDiDiLjGlMiCpAiDiLiBfLiDhG_xHqqkZx_ -----
	{
		if (iStr->CompareTailNoCase(L".old") == 0)
		//----- _xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_ *iStr _xZkqqHx_iCmMiKgHjCkDiOhBiCkK_xHqqkZx_ .old _xZkqqHx_iCmMiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDhEiDiLiDhAiDfIiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
			WString wstrSubFilePath = wcpDirPath;
			wstrSubFilePath += L'\\';
			wstrSubFilePath += *iStr;
			// _xZkqqHx_iDhEiDeAiDeDiDiLiCpAiNoNiPjMiBeC_xHqqkZx_
			if (!FFDeleteFile(wstrSubFilePath))
			//----- _xZkqqHx_iNoNiPjMiCmJiOlIjEhDiClFiClNiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_iDeBiDeOiDfKiDfIiOlIjEhDiClFiClNiDhEiDeAiDeDiDiLiCpAjAnNjCoIiBeC_xHqqkZx_
				wstrInvalidFile = wstrSubFilePath;
				return FALSE;
			}
		}
	}

	for (iStr = vDirName.begin(); iStr != vDirName.end(); iStr++)
	//----- _xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKjGlMiCpAiDiLiBfLiDhG_xHqqkZx_ -----
	{
		// _xZkqqHx_iDhEiDiLiDhAiDfIiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
		WString wstrSubDirPath = wcpDirPath;
		wstrSubDirPath += L'\\';
		wstrSubDirPath += *iStr;
		if (iStr->CompareTailNoCase(L".old") == 0)
		//----- _xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiK_xHqqkZx_ *iStr _xZkqqHx_iCmMiKgHjCkDiOhBiCkK_xHqqkZx_ .old _xZkqqHx_iCmMiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiImIiJlKiCpAjBfDiCmEiNoNiPjMiBeC_xHqqkZx_
			if (!FFRecursiveRemoveDirectory(wstrSubDirPath))
			//----- _xZkqqHx_iNoNiPjMiCmJiOlIjEhDiClFiClNiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_iDeBiDeOiDfKiDfIiOlIjEhDiClFiClNiDhEiDeAiDeDiDiLiCpAjAnNjCoIiBeC_xHqqkZx_
				wstrInvalidFile = wstrSubDirPath;
				return FALSE;
			}
		} else
		//----- _xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiK_xHqqkZx_ *iStr _xZkqqHx_iCmMiKgHjCkDiOhBiCkK_xHqqkZx_ .old _xZkqqHx_iImIiKePiCmMiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDfEiDhFiDgGiDeCiDiMiDeOiDgHiDiKiCpAiNmEiLeBjDeJiCmJjClCiCnHiCoJiBeC_xHqqkZx_
			if (!myDeleteOldFile(wstrInvalidFile, wstrSubDirPath))
				return FALSE;
		}
	}
	return TRUE;
} // myDeleteOldFile.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	myGetTablePath
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	wcpProjectPath _xZkqqHx_iImIiJlKiCmJiCkAiCoJjBfDiCmEiCmMiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLjGlMiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	stTablePath		:_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLjGlMiCpAjFnEiClHiBeC_xHqqkZx_
 *			wcpDirPath		:_xZkqqHx_iMjPiNpFiClHiCoJiDgGiDeCiDiMiDeOiDgHiDiKiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpProjectPath	:_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDhAiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iJlKjBhHiCnMiCmFjClCiCnHiCoJiClNiCnPiCmJiBeBiPiIjHjNiCmNiNmEiLeBjDeJiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iKgFiIpIjAjEiCmJiCmNiImIiJlKiCmMiCoGiCkEiCmIjCgMiCkKjAnNjCoIiClDiCoKiBeBiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 *			_xZkqqHx_iNmFiPiJiCmMiOmAiNhDiBeC_xHqqkZx_
 *			wcpDirPath		:"";
 *			wcpProjectPath	:"C:\Document\Sample.mdpj";
 *
 *			_xZkqqHx_iCfAiJpBjGnKiCmMiNmEiLeBiOmAiNhDiBeC_xHqqkZx_
 *			wcpDirPath		:"\0";
 *			wcpProjectPath	:"C:\Document\Sample.mdpj";
 *
 *			_xZkqqHx_iCfBiJpBjGnKiCmMiNmEiLeBiOmAiNhDiBeC_xHqqkZx_
 *			wcpDirPath		:"\0\1";
 *			wcpProjectPath	:"C:\Document\Sample.mdpj";
 *
 *			_xZkqqHx_jFnEjCgMiBeC_xHqqkZx_\_xZkqqHx_iCmFiCmNiCmIiCkN_xHqqkZx_$_xZkqqHx_iCpAiOgHiCkEiBeC_xHqqkZx_
 *			stTablePath		:{ "$0$2$0$", "$0$2$1$", "$0$2$2$" }
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
static void myGetTablePath (set<WString>& stTablePath, const wchar_t* wcpDirPath, const wchar_t* wcpProjectPath)
{
	// wcpDirPath_xZkqqHx_iCmMjClMiJlKiCmJiCkAiCoJiDgGiDeCiDiMiDeOiDgHiDiKiBeFiDhEiDeAiDeDiDiLiCmMjHpBiLjDiBeC_xHqqkZx_
	WStringVector vDirName;
	WStringVector vFileName;
	FFEnumDirectoryFile(vDirName,
						vFileName,
						WString(wcpProjectPath) + wcpDirPath + L"\\*");

	WStringVector::const_iterator iStr;
	for (iStr = vFileName.begin(); iStr != vFileName.end(); iStr++)
	//----- _xZkqqHx_iDhEiDeAiDeDiDiLjGlMiCpAiDiLiBfLiDhG_xHqqkZx_ -----
	{
		if (iStr->CompareTailNoCase(L".ddix") == 0)
		//----- _xZkqqHx_iDgFiBfLiDhFiDiLiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCmMiPoKiNiH_xHqqkZx_ -----
		{
			WString wstr = wcpDirPath;
			wstr.Replace(L'\\', L'$');
			wstr += L'$';
			wstr += iStr->Left(iStr->GetLength() - wcslen(L".ddix"));
			wstr += L'$';
			stTablePath.insert(wstr);
		}
	}
	vFileName.clear();

	for (iStr = vDirName.begin(); iStr != vDirName.end(); iStr++)
	//----- _xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKjGlMiCpAiDiLiBfLiDhG_xHqqkZx_ -----
	{
		if (iStr->GetAt(0) != L'.')
		//----- . _xZkqqHx_iCmFiOgOiCnMiCoJiDgGiDeCiDiMiDeOiDgHiDiKjGlMiImIiKePiCmMiPoKiNiH_xHqqkZx_ -----
		{
			// . _xZkqqHx_iCmFiOgOiCnMiCoJiDgGiDeCiDiMiDeOiDgHiDiKiCmN_xHqqkZx_ _xZkqqHx_iDiPiBfLiDeOjHhAiBeC_xHqqkZx_
			// _xZkqqHx_iMjPiNpFiClFiCmEiCoAiCkCiCkCiCmMiClOiCkKiBeBiOjOiKnEiCmMjGlDjBmKiBeC_xHqqkZx_
			WString wstrSubDirPath = wcpDirPath;
			wstrSubDirPath += L'\\';
			wstrSubDirPath += *iStr;
			// _xZkqqHx_iDfEiDhFiDgGiDeCiDiMiDeOiDgHiDiKiCpAiNmEiLeBjDeJiCmJjClCiNlIiBeC_xHqqkZx_
			myGetTablePath(stTablePath, wstrSubDirPath, wcpProjectPath);
		}
	}
} // myGetTablePath.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	myGetAppendIdentifier
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCkJiCoHiBeBjCmHiJmB_xHqqkZx_Identifier_xZkqqHx_iCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwAppendIdentifier	:_xZkqqHx_jCmHiJmB_xHqqkZx_Identifier_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *			wcpIndexPath		:_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCmMiDhAiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeHiDiJiBfLiDfCiBfLiDgIiBeCiDeHiDiJiBfLiCkKjGlDiCkCiPoKiNiHiCmN_xHqqkZx_0_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDiMiDfCiBfLiDgIiCkKjHeMiCoJiPoKiNiHiCmNiBeBiNmFiMoDiCmMiDiMiDfCiBfLiDgIiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCmM_xHqqkZx_
 *			_xZkqqHx_jCmHiJmB_xHqqkZx_Identifier + 1 _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *			_xZkqqHx_iDiMiDfCiBfLiDgIiCkKjGlDiCkCiPoKiNiHiCmN_xHqqkZx_ 0 _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
static DWORD myGetAppendIdentifier (DWORD& dwAppendIdentifier, const wchar_t* wcpIndexPath)
{
	FCFile32 indexFile;
	// _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCpAiKeKiCkNiBeC_xHqqkZx_
	if (!indexFile.Open(wcpIndexPath,
						GENERIC_READ,
						0, OPEN_EXISTING))
	{
		// IDS_ERR_FILE_ACCESS_DENIED "_xZkqqHx_iDeHiDiJiBfLiBeGiDhEiDeAiDeDiDiLiCmMiDeBiDeOiDfKiDfIiCkKiLjGiJmCiClDiCoKiCmEiCkCiCnMiClJiCpBiBeC_xHqqkZx_"
		return IDS_ERR_FILE_ACCESS_DENIED;
	}

	// _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiNmFiMoDiCmMiDiMiDfCiBfLiDgIiCkJiCoHjCmHiJmB_xHqqkZx_Identifier_xZkqqHx_iCpAiOoGjDlOiBeC_xHqqkZx_

	if (indexFile.GetLength64() == sizeof(flint))
	//----- _xZkqqHx_iDgFiBfLiDhFiDiLiCmMiDiMiDfCiBfLiDgIjAjEiBiBiCePiCmMiPoKiNiH_xHqqkZx_ -----
	{
		dwAppendIdentifier = 0;
	} else
	if (indexFile.GetLength64() < sizeof(flint) + sizeof(flint) + sizeof(DWORD) + sizeof(flint))
	//----- _xZkqqHx_iDgFiBfLiDhFiDiLiCmMiDiMiDfCiBfLiDgIjAjEiBiBiCfAiCoGiCoIiPkMiClDiCkCiPoKiNiH_xHqqkZx_ -----
	{
		// IDS_ERR_FILE_DESTROY "_xZkqqHx_iDeHiDiJiBfLiBeGiDhEiDeAiDeDiDiLiCmNjEgKjBlJiClFiCmEiCkCiCnMiClHiBeC_xHqqkZx_"
		return IDS_ERR_FILE_DESTROY;
	} else
	//----- _xZkqqHx_iDgFiBfLiDhFiDiLiCmMiDiMiDfCiBfLiDgIjAjEiBiBiCfAiImIiPoDiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiDgFiBfLiDhFiDiLiNmFiMoDiCmMjCmHiJmB_xHqqkZx_Identifier_xZkqqHx_iCpAiOoGjDlOiBeC_xHqqkZx_
		indexFile.Seek64(-long(sizeof(DWORD) + sizeof(flint)), FILE_END);
		indexFile.Read64(&dwAppendIdentifier, sizeof(dwAppendIdentifier));
		// _xZkqqHx_jCmHiJmB_xHqqkZx_Identifier_xZkqqHx_iCmJiCfAiJmBiOfKiBeC_xHqqkZx_
		dwAppendIdentifier++;
		// _xZkqqHx_jCmHiJmB_xHqqkZx_Identifier_xZkqqHx_iCkKjGlDiMpIjCgM_xHqqkZx_(-1)_xZkqqHx_iCmMiPoKiNiHiCmNiBeB_xHqqkZx_0_xZkqqHx_iCmJjFoCjAlDiBeC_xHqqkZx_
		if (dwAppendIdentifier == DWORD(-1))
			dwAppendIdentifier = 0;
	}
	// _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCpAjFmCiClGiCoJiBeC_xHqqkZx_
	indexFile.Close();

	return 0;
} // myGetAppendIdentifier.

/////////////////////////////////////////////////////////////////////////////
// _xZkqqHx_iDeBiDhGiDiKiDfAiBfLiDfGiDiHiDjDiCmMiDgPiBfLiDfHiDiHiDjDiPoOjFpBiCmFiOgHiCoNiCoKiCmEiCkCiCoJ_xHqqkZx_ CAboutDlg _xZkqqHx_iDfPiDeDiDeBiDiNiDeP_xHqqkZx_

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// _xZkqqHx_iDfPiDeDiDeBiDiNiDeP_xHqqkZx_ _xZkqqHx_iDgGiBfLiDfO_xHqqkZx_
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard _xZkqqHx_iCmNiJlMjBhKiKnGjAjEiCmMiDeJiBfLiDgPiBfLiDiJiDeDiDgIiCpAjAlGjAkMiClFiCnMiClH_xHqqkZx_
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV _xZkqqHx_iCmMiDfEiDhMiBfLiDgH_xHqqkZx_
	//}}AFX_VIRTUAL

// _xZkqqHx_iDeDiDjDiDhGiDiKiDiBiDjDiDgFiBfLiDfGiDiHiDjD_xHqqkZx_
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// _xZkqqHx_iDiBiDgCiDfKiBfLiDfH_xHqqkZx_ _xZkqqHx_iDgOiDjDiDgIiDiJiCkKiCkAiCoIiCnMiClJiCpBiBeC_xHqqkZx_
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CHiDocToolDlg _xZkqqHx_iDfPiDeDiDeBiDiNiDeP_xHqqkZx_

CHiDocToolDlg::CHiDocToolDlg (	BOOL bIsDirect,
								const wchar_t* wcpFilePath,
								BOOL bIsMoveToDesktop,
								CWnd* pParent /*=NULL*/)
			:	CDialog(bIsDirect ? IDD_HIDOCTOOL_DIALOG_DIRECT : IDD_HIDOCTOOL_DIALOG, pParent),
				m_bIsDirect(bIsDirect),					// _xZkqqHx_jClMjAnKjDpMjHmNiCkJiBeC_xHqqkZx_
				m_wstrFilePath(wcpFilePath),			// _xZkqqHx_iPeDjFjMjBmOiPnLiDhEiDeAiDeDiDiLiBeC_xHqqkZx_
				m_bIsMoveToDesktop(bIsMoveToDesktop)	// _xZkqqHx_iDgGiDfIiDeOiDgHiDgCiDhGiInKjDkOiCkJiBeI_xHqqkZx_
{
	//{{AFX_DATA_INIT(CHiDocToolDlg)
		// _xZkqqHx_iDiBiDiC_xHqqkZx_: _xZkqqHx_iClBiCmMiImKjChFiCmJ_xHqqkZx_ ClassWizard _xZkqqHx_iCmJiCoGiCmBiCmEiDiBiDjDiDgPiCmMiPiJiKpKiJlLiCkKjCmHiJmBiClDiCoKiCnMiClHiBeC_xHqqkZx_
	//}}AFX_DATA_INIT
	// _xZkqqHx_iDiBiDiC_xHqqkZx_: LoadIcon _xZkqqHx_iCmN_xHqqkZx_ Win32 _xZkqqHx_iCmM_xHqqkZx_ DestroyIcon _xZkqqHx_iCmMiDfEiDhFiDfGiBfLiDfAiDjDiDfIiCpAjHhGiLiBiClFiCnMiClJiCpBiBeC_xHqqkZx_
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
} // CHiDocToolDlg::CHiDocToolDlg.

void CHiDocToolDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CHiDocToolDlg)
		// _xZkqqHx_iDiBiDiC_xHqqkZx_: _xZkqqHx_iClBiCmMiPoKiPiKiCmJiCmN_xHqqkZx_ ClassWizard _xZkqqHx_iCmJiCoGiCmBiCmE_xHqqkZx_ DDX _xZkqqHx_iCmG_xHqqkZx_ DDV _xZkqqHx_iCmMiMmEiCnBiPgPiClFiCkKjCmHiJmBiClDiCoKiCnMiClHiBeC_xHqqkZx_
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CHiDocToolDlg, CDialog)
	//{{AFX_MSG_MAP(CHiDocToolDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_MAIN_BTN_PROJECT_FILE, OnMainBtnProjectFile)
	ON_BN_CLICKED(IDC_MAIN_BTN_START_RECOVER, OnMainBtnStartRecover)
	//}}AFX_MSG_MAP
	ON_MESSAGE(WM_USER_PROCEED_DIRECT, OnUserProceedDirect)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CHiDocToolDlg _xZkqqHx_iDiBiDgCiDfKiBfLiDfH_xHqqkZx_ _xZkqqHx_iDgOiDjDiDgIiDiJ_xHqqkZx_

BOOL CHiDocToolDlg::OnInitDialog ()
{
	CDialog::OnInitDialog();

	// "_xZkqqHx_iDgPiBfLiDfHiDiHiDjDiPoOjFpB_xHqqkZx_..." _xZkqqHx_iDiBiDgKiDiFiBfLiNiAjGnKiCpAiDfGiDfIiDgFiDiA_xHqqkZx_ _xZkqqHx_iDiBiDgKiDiFiBfLiCnGjCmHiJmBiClFiCnMiClHiBeC_xHqqkZx_

	// IDM_ABOUTBOX _xZkqqHx_iCmNiDfCiDhNiDjDiDgI_xHqqkZx_ _xZkqqHx_iDiBiDgKiDiFiBfLiCmMjEmNiImNiCmFiCmIiCkPiCoKiCmOiCmIiCoIiCnMiClJiCpBiBeC_xHqqkZx_
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// _xZkqqHx_iClBiCmMiDfPiDeDiDeBiDiNiDePjHhAiCmMiDeBiDeDiDfCiDjDiCpAjAnNjCoIiClFiCnMiClHiBeCiDhEiDiMiBfLiDiAiDiPiBfLiDeOiCmNiDeBiDhGiDiKiDfAiBfLiDfGiDiHiDjDiCmMiDiBiDeDiDjD_xHqqkZx_
	// _xZkqqHx_iDeFiDeCiDjDiDgIiDeFiCkKiDfPiDeDiDeBiDiNiDePiCmFiCmIiCkCiOjOiCmNiOkJjDkOjDeJiCmJjAnNjCoIiClFiCnMiClJiCpBiBeC_xHqqkZx_
	SetIcon(m_hIcon, TRUE);			// _xZkqqHx_jBoFiCkLiCkCiDeBiDeDiDfCiDjDiCpAjAnNjCoI_xHqqkZx_
	SetIcon(m_hIcon, FALSE);		// _xZkqqHx_iPkMiClDiCkCiDeBiDeDiDfCiDjDiCpAjAnNjCoI_xHqqkZx_

	if (m_bIsDirect)
	//----- _xZkqqHx_jClMjAnKjDpMjHmNiCmMiPoKiNiH_xHqqkZx_ -----
	{
		PostMessage(WM_USER_PROCEED_DIRECT);
	}

	return TRUE;  // TRUE _xZkqqHx_iCpAjFnEiClHiCmGiDfCiDjDiDgHiDiNiBfLiDiLiCmJjAnNjCoIiClFiClNiDhEiDeIiBfLiDeKiDfIiCmNiOlIiCoNiCoKiCnMiClJiCpBiBeC_xHqqkZx_
}

void CHiDocToolDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// _xZkqqHx_iCoAiClFiDfPiDeDiDeBiDiNiDePiDhLiDgCiDeOiDfIiCmJiNmFiPkMiJlLiDhLiDfOiDjDiCpAjCmHiJmBiClHiCoJiCmIiCoHiCmOiBeBiDeBiDeDiDfCiDjDiCpAjFgAiJoGiClHiCoJ_xHqqkZx_
// _xZkqqHx_iDfCiBfLiDgIiCpAiImIiJlKiCmJiLeMiPhBiClHiCoJjFeLjHhGiCkKiCkAiCoIiCnMiClHiBeC_xHqqkZx_MFC _xZkqqHx_iDeBiDhGiDiKiDfAiBfLiDfGiDiHiDjDiCmN_xHqqkZx_ document/view
// _xZkqqHx_iDiCiDgGiDiLiCpAiOgHiCmBiCmEiCkCiCoJiCmMiCmFiBeBiClBiCmMiPiIjHjNiCmNiDhEiDiMiBfLiDiAiDiPiBfLiDeOiCmJiCoGiCoIiOkJjDkOjDeJiCmJiPiIjHjNiClDiCoKiCnMiClHiBeC_xHqqkZx_

void CHiDocToolDlg::OnPaint ()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // _xZkqqHx_jFgAiJoGjHhAiCmMiDgGiDgPiDeDiDfI_xHqqkZx_ _xZkqqHx_iDfCiDjDiDgFiDeMiDfIiDgH_xHqqkZx_

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// _xZkqqHx_iDeOiDiJiDeDiDeBiDjDiDgHiCmMiLoJiMgAjHmMiIoGjDoAiCmMjCiGiJjL_xHqqkZx_
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// _xZkqqHx_iDeBiDeDiDfCiDjDiCpAjFgAiJoGiClFiCnMiClHiBeC_xHqqkZx_
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// _xZkqqHx_iDfGiDfIiDgFiDiAiCmNiBeBiDiGiBfLiDfFiBfLiCkKiNmFiPkMiJlLiDeFiDeCiDjDiDgIiDeFiCpAiDgIiDiJiDgCiDePiClFiCmEiCkCiCoJiKnEiBeB_xHqqkZx_
// _xZkqqHx_iDeKiBfLiDfMiDiLiCpAjFfMiOkGiClHiCoJiClNiCnPiCmJiClBiClBiCpAiMmEiCnBiPgPiClFiCnMiClHiBeC_xHqqkZx_
HCURSOR CHiDocToolDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CHiDocToolDlg::OnMainBtnProjectFile ()
{
	// _xZkqqHx_iMlLiNnNiCmMiDgGiDeCiDiMiDeOiDgHiDiKiCpAiOoGjDlOiBeC_xHqqkZx_
	WString wstrCurDir = FFGetCurrentDirectory(FALSE);
	// _xZkqqHx_iKgHjCkDiOhBiCkK_xHqqkZx_ ".mdpj" _xZkqqHx_iCmFiCmIiCkNiCmIiCoJiCnMiCmFiPoDiCoJiBeC_xHqqkZx_
	while (wstrCurDir.CompareTailNoCase(L".mdpj") == 0)
		wstrCurDir = FFGetFileDirectory(wstrCurDir, TRUE);

	// _xZkqqHx_iDfOiDeDiDgHiDiLjGlMiCmMjAnNjCoIiBeC_xHqqkZx_
	// IDS_MSG_OPEN_PROJECT = "_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCpAiKeKiCkN_xHqqkZx_"
	WString wstrDlgTitle;
	wstrDlgTitle.LoadString(IDS_MSG_OPEN_PROJECT);
//----- 06.04.25 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	if (FFVersionInfo().dwPlatformId == VER_PLATFORM_WIN32_NT)
//	//----- WindowsNT_xZkqqHx_iMgOiCmMiPoKiNiH_xHqqkZx_ ------
//	{
//----- 06.04.25 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	FCFdbProjectDialog dlg(	TRUE,
							NULL,
							wstrCurDir + L"\\*.mdpj",
							OFN_HIDEREADONLY | OFN_EXPLORER,
							L"Historic Draw Projects (*.mdpj)|*.mdpj||",
							L"0.ddtb",
							m_hWnd,
							wstrDlgTitle,
							NULL,
							NULL,
							0,
							FALSE);
	// _xZkqqHx_iDhEiDeAiDeDiDiLiDfPiDeDiDeBiDiNiDePiCpAjFfMiOkGiBeC_xHqqkZx_
	DWORD dwRet = dlg.DoModal();
	if (dwRet != IDOK) return;
	// _xZkqqHx_iDhEiDeAiDeDiDiLjGlMiCpAjAnNjCoIiBeC_xHqqkZx_
	FFSetDlgItemText(m_hWnd, IDC_MAIN_EDT_PROJECT_FILE, dlg.GetPathName());
//----- 06.04.25 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	} else
//	//----- Windows95_xZkqqHx_iMgOiCmMiPoKiNiH_xHqqkZx_ -----
//	{
//		FCDbFileDialog dlg(	TRUE,
//							NULL,
//							L"*.ddtb",
//							OFN_HIDEREADONLY | OFN_EXPLORER,
//							L"Historic Draw Projects (*.ddtb)|*.ddtb||",
//							m_hWnd,
//							wstrDlgTitle,
//							NULL,
//							NULL,
//							0,
//							FALSE);
//		// _xZkqqHx_iDhEiDeAiDeDiDiLiDfPiDeDiDeBiDiNiDePiCpAjFfMiOkGiBeC_xHqqkZx_
//		DWORD dwRet = dlg.DoModal();
//		if (dwRet != IDOK) return;
//		// _xZkqqHx_iDhEiDeAiDeDiDiLjGlMiCpAjAnNjCoIiBeC_xHqqkZx_
//		FFSetDlgItemText(m_hWnd, IDC_MAIN_EDT_PROJECT_FILE, FFTableToTopDirPath(dlg.GetPathName()));
//	}
//----- 06.04.25 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
} // CHiDocToolDlg::OnMainBtnProjectFile.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CHiDocToolDlg::OnMainBtnStartRecover
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iPeDjFjMiKeKiOgOiDhLiDfOiDjDiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.08.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CHiDocToolDlg::OnMainBtnStartRecover ()
{
	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDhEiDeAiDeDiDiLjGlMiCpAiOoGjDlOiBeC_xHqqkZx_
	CString strProjectPath;
	GetDlgItemText(IDC_MAIN_EDT_PROJECT_FILE, strProjectPath);
	try
	{
		// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDhEiDeAiDeDiDiLiCpAiPeDjFjMiClHiCoJiBeC_xHqqkZx_
		DoRecover(TStrToWStr(strProjectPath));
	} catch (CException* e)
	//----- _xZkqqHx_iDeHiDiJiBfLiPiIjHjN_xHqqkZx_ -----
	{
		// IDS_MSG_RECOVER_FAILED   "_xZkqqHx_iPeDjFjMiCmNiOlIjEhDiClFiCnMiClFiClNiBeC_xHqqkZx_"
		PrintMessage(IDS_MSG_RECOVER_FAILED);
		throw e;
	}
} // CHiDocToolDlg::OnMainBtnStartRecover.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CHiDocToolDlg::OnUserProceedDirect
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iPiIjHjNiCpAiDfPiDeDiDiMiDeOiDgHiCmJjAgJiCnPiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iPoNiCmJ_xHqqkZx_1_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.08.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
LRESULT CHiDocToolDlg::OnUserProceedDirect (WPARAM, LPARAM)
{
	FTFileKind fileKindNew = FFIsThereFile(m_wstrFilePath);
	if (fileKindNew != FD_FILE_DIRECTORY)
	//----- _xZkqqHx_iPeDjFjMjBmOiPnLiDhEiDeAiDeDiDiLiCkKiDgGiDeCiDiMiDeOiDgHiDiKiCmFiCmNiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiCpAjFfMiOkGiClFiCmEiPiIjHjNiCpAiPeJjHlJiBeC_xHqqkZx_
		PrintMessage(IDS_ERR_FILE_NOT_EXIST);
		PrintMessage(m_wstrFilePath);
		return 1;
	}
	// _xZkqqHx_iPeDjFjMjBmOiPnLiDhEiDeAiDeDiDiLiBeC_xHqqkZx_
	WString wstrDocFile = m_wstrFilePath;
	if (m_bIsMoveToDesktop)
	//----- _xZkqqHx_iDgGiDfIiDeOiDgHiDgCiDhGiCnGiInKjDkOiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		//----- _xZkqqHx_iDgGiDfIiDeOiDgHiDgCiDhGiDhEiDeIiDiLiDfPiCpAiOoGjDlO_xHqqkZx_ -----
		LPITEMIDLIST pidl;
		if(!SUCCEEDED(SHGetSpecialFolderLocation(NULL, CSIDL_DESKTOPDIRECTORY, &pidl)))
		{
			// IDS_ERR_MSG_NOT_FOUND_DESKTOP = "_xZkqqHx_iDgGiDfIiDeOiDgHiDgCiDhGiDhEiDeIiDiLiDfPiCkKiMkJiCmCiCkJiCoIiCnMiClJiCpBiBeC_xHqqkZx_"
			PrintMessage(IDS_ERR_MSG_NOT_FOUND_DESKTOP);
			return 1;
		}
		_TCHAR szDesktop[_MAX_PATH + 1];
		// _xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKjGlMiCpAiOoGjDlOiBeC_xHqqkZx_
		SHGetPathFromIDList(pidl, szDesktop);
		WString wstrDesktop = TStrToWStr(szDesktop);
		// Get the shell's allocator to free PIDLs
		//----- _xZkqqHx_iDiPiBfLiDeOjHmMiIoGiCpAiKeKjFpK_xHqqkZx_ -----
		LPMALLOC lpMalloc;
		if (!SHGetMalloc(&lpMalloc) && (lpMalloc != NULL))
		{
			lpMalloc->Free(pidl);
			lpMalloc->Release();
		}
		// _xZkqqHx_iDhEiDeAiDeDiDiLjGlMiBgJiKgHjCkDiOhBjGlDiClFiBgKiCpAjCmHiJmBiBeC_xHqqkZx_
		wstrDesktop += L"\\Untitled";
		try
		{
			// _xZkqqHx_iPeDjFjMjBmOiPnLiDhEiDeAiDeDiDiLiCmJiBeBiDgGiDfIiDeOiDgHiDgCiDhGiPoDiCmMiDiGiDgKiBfLiDeOiCmIiDhEiDeAiDeDiDiLjGlMiCpAjAnNjCoIiBeC_xHqqkZx_
			::FFMakeUniqFileName(wstrDocFile, wstrDesktop, L".mdpj");
		} catch (CException* e)
		//----- _xZkqqHx_iDeHiDiJiBfLiPiIjHjN_xHqqkZx_ -----
		{
			e->Delete();
			// IDS_ERR_MSG_CANNOT_MAKE_DESKTOP_FILE = "_xZkqqHx_iDgGiDfIiDeOiDgHiDgCiDhGiCmJiDhEiDeAiDeDiDiLiCkKiNoMjAkMiCmFiCkLiCnMiClJiCpBiBeC_xHqqkZx_"
			PrintMessage(IDS_ERR_MSG_CANNOT_MAKE_DESKTOP_FILE);
			return 1;
		}
		// _xZkqqHx_iDgGiDfIiDeOiDgHiDgCiDhGiCnGiDhEiDeAiDeDiDiLiCpAjFkBiOmKiBeC_xHqqkZx_
		if (!FFCopyDirectory(m_wstrFilePath, wstrDocFile))
		//----- _xZkqqHx_iDhEiDeIiDiLiDfPiCpAiDgGiDfIiDeOiDgHiDgCiDhGiCmJjFkBiOmKiCmFiCkLiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			// IDS_ERR_MSG_CANNOT_MAKE_DESKTOP_FILE = "_xZkqqHx_iDgGiDfIiDeOiDgHiDgCiDhGiCmJiDhEiDeAiDeDiDiLiCkKiNoMjAkMiCmFiCkLiCnMiClJiCpBiBeC_xHqqkZx_"
			PrintMessage(IDS_ERR_MSG_CANNOT_MAKE_DESKTOP_FILE);
			return 1;
		}

		// _xZkqqHx_iDhEiDeAiDeDiDiLiBgJjAoCjBmOiBeFjBiKjBmOiBgKiDhAiDfIjGlMiCmMiDhEiDeAiDeDiDiLjGlMiCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
		WString wstrFileName = FFGetFileName(wstrDocFile);
		// IDS_MSG_COPY_TO_DESKTOP "_xZkqqHx_iDgGiDfIiDeOiDgHiDgCiDhGiCmMiBhF_xHqqkZx_%s_xZkqqHx_iBhGiCmJjFkBiOmKiClFiCnMiClFiClNiBeC_xHqqkZx_"
		WString wstrFormat;
		wstrFormat.LoadString(IDS_MSG_COPY_TO_DESKTOP);
		WString wstrMessage;
		wstrMessage.Format(wstrFormat.c_str(), wstrFileName.c_str());
		PrintMessage(wstrMessage);
	} else
	//----- _xZkqqHx_iDgGiDfIiDeOiDgHiDgCiDhGiCnGiInKjDkOiClFiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iPeDjFjMjBmOiPnLiDhEiDeAiDeDiDiLiCpAjAnNjCoIiBeC_xHqqkZx_
		wstrDocFile = m_wstrFilePath;
	}
	// _xZkqqHx_jAfGiClFiCkCiDhEiDeAiDeDiDiLjGlMiCpAiDfCiDjDiDgHiDiNiBfLiDiLiCmJjAnNjCoIiBeC_xHqqkZx_
	SetDlgItemText(IDC_MAIN_EDT_PROJECT_FILE, WStrToTStr(wstrDocFile));
	try
	{
		//----- _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDhEiDeAiDeDiDiLiCpAiPeDjFjMiClHiCoJ_xHqqkZx_ -----
		// _xZkqqHx_iPeDjFjMiPiIjHjNiBeCiPeDjFjMiCmJiOlIjEhDiClFiClNiPoKiNiHiCmNiDeHiDiJiBfLiCpAiDfIiDiNiBfLiBeC_xHqqkZx_
		if (!DoRecover(wstrDocFile))
			AfxThrowUserException();
		// _xZkqqHx_iDgGiDfIiDeOiDgHiDgCiDhGiCnGiInKjDkOiClFiClNiPoKiNiHiCmNiBeBiMlDiCmMiDhEiDeAiDeDiDiLiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
		if (m_bIsMoveToDesktop)
			FFRemoveDirectory(m_wstrFilePath);
	} catch (CException* e)
	//----- _xZkqqHx_iDeHiDiJiBfLiPiIjHjN_xHqqkZx_ -----
	{
		// IDS_MSG_RECOVER_FAILED   "_xZkqqHx_iPeDjFjMiCmNiOlIjEhDiClFiCnMiClFiClNiBeC_xHqqkZx_"
		PrintMessage(IDS_MSG_RECOVER_FAILED);
		throw e;
	}
	return 1;
} // CHiDocToolDlg::OnUserProceedDirect.

//----- 06.03.11 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CHiDocToolDlg::SetFilePath
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeDiDiLiDhAiDfIiCpAjAnNjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpFilePath	:_xZkqqHx_iDhEiDeAiDeDiDiLiDhAiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.08.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void CHiDocToolDlg::SetFilePath (const wchar_t* wcpFilePath)
//{
//	m_wstrFilePath = wcpFilePath;
//} // CHiDocToolDlg::SetFilePath.
//----- 06.03.11 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

void CHiDocToolDlg::PrintMessage (DWORD dwId)
{
	CEdit* pEdit = (CEdit*)GetDlgItem(IDC_MAIN_EDT_MESSAGE);
	CString str;
	str.LoadString(dwId);
	pEdit->ReplaceSel(str);
	pEdit->ReplaceSel(_T("\r\n"));
} // CHiDocToolDlg::PrintMessage.

void CHiDocToolDlg::PrintMessage (const wchar_t* wcpText)
{
	CEdit* pEdit = (CEdit*)GetDlgItem(IDC_MAIN_EDT_MESSAGE);
	pEdit->ReplaceSel(WStrToTStr(wcpText));
	pEdit->ReplaceSel(_T("\r\n"));
} // CHiDocToolDlg::PrintMessage.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CHiDocToolDlg::PatchRecoverFile
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iPeDjFjMiDhEiDeAiDeDiDiLiCmMiPiIjHjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fileRecover	:_xZkqqHx_iPeDjFjMiDhEiDeAiDeDiDiLiCmMiDhEiDeAiDeDiDiLiDgOiDjDiDgIiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpDiffFilePath	:_xZkqqHx_iPeDjFjMiDhEiDeAiDeDiDiLiDhAiDfIjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.01.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CHiDocToolDlg::PatchRecoverFile (	FCFile32& fileRecover,
										const wchar_t* wcpProjectPath)
{
	// _xZkqqHx_iPeDjFjMiDhEiDeAiDeDiDiLiCmMiDhEiDeAiDeDiDiLiDhMiDeDiDjDiDfOiCpAiDfCiDhNiDjDiDgIiPeJjCfLiCmJiInKjDkOiBeC_xHqqkZx_
	fileRecover.Seek64(-long(sizeof(WORD) + FD_RECOVER_END_CODE_LEN), FILE_END);
	// _xZkqqHx_iNlHjFkKiDhFiDiNiDgCiDeOiCmMjDmHiCnNiNjOiCnNiBeC_xHqqkZx_
	for (;;)
	{
		// _xZkqqHx_iPeDjFjMiDhEiDeAiDeDiDiLjAoGjDkKiCmJjCeCiClFiClNiCoHiPeJjHlJiBeC_xHqqkZx_
		if (fileRecover.GetPosition64() == 0) break;
		// _xZkqqHx_iDfCiDhNiDjDiDgIiDfEiDeDiDfJjFkKiCpAjGnPiClHiBeC_xHqqkZx_
		const long lCommandTail = fileRecover.Seek64(-long(sizeof(flint)), FILE_CURRENT);
		// _xZkqqHx_iDfCiDhNiDjDiDgIiDfEiDeDiDfJiCpAjDmHiCnNiPgPiClHiBeC_xHqqkZx_
		flint fliCommandSize;
		fileRecover.Read64(&fliCommandSize, sizeof(fliCommandSize));
		// _xZkqqHx_iDfCiDhNiDjDiDgIjAoGjDkKiCnGjGnPiClHiBeC_xHqqkZx_
		const long lCommandTop = fileRecover.Seek64(-(fliCommandSize + sizeof(flint)), FILE_CURRENT);
		// _xZkqqHx_iDfCiDhNiDjDiDgIiCpAjDmHiCnNiPgPiClHiBeC_xHqqkZx_
		BYTE byCommand;
		fileRecover.Read64(&byCommand, sizeof(byCommand));
		// _xZkqqHx_iDhEiDeAiDeDiDiLjGlMjClHiCpAjDmHiCnNiPgPiClHiBeC_xHqqkZx_
		short nNameSize;
		fileRecover.Read64(&nNameSize, sizeof(nNameSize));
		// _xZkqqHx_iDhEiDeAiDeDiDiLjGlMiBgJjBiKjBmOiDhAiDfIiBgKiCpAjDmHiCnNiPgPiClHiBeC_xHqqkZx_
		vector<wchar_t> vBuff(nNameSize + 1, L'\0');
		fileRecover.Read64(&vBuff.at(0), sizeof(wchar_t) * nNameSize);
		// _xZkqqHx_jAoCjBmOiDhAiDfIjGlMiCpAiNoMjAkMiBeCiDhEiDeAiDeDiDiLjGlMiCmMjAoGjDkKiCmJiCmN_xHqqkZx_'\'_xZkqqHx_iCkKjFhEiCkCiCmEiCkCiCoJiCmMiCmFiBeB_xHqqkZx_
		// _xZkqqHx_iClLiCmMiCnMiCnMiDhGiDiNiDfHiDeGiDeOiDgHiDhAiDfIiCmJjCmHiJmBiClHiCoKiCmOiCoGiCkCiBeC_xHqqkZx_
		WString wstrFilePath = WString(wcpProjectPath) + &vBuff.at(0);

		switch (byCommand)
		{
		case UNDO_CMD_DELETE_DIRECTORY:	// _xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiNoNiPjMiBeC_xHqqkZx_
			OnDeleteDirectoryProc(fileRecover, wstrFilePath);
			break;
		case UNDO_CMD_CREATE_DIRECTORY:	// _xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiNoMjAkMiBeC_xHqqkZx_
			OnCreateDirectoryProc(fileRecover, wstrFilePath);
			break;
		case UNDO_CMD_DELETE_FILE:		// _xZkqqHx_iDhEiDeAiDeDiDiLiNoNiPjMiBeC_xHqqkZx_
			OnDeleteFileProc(fileRecover, wstrFilePath);
			break;
		case UNDO_CMD_CREATE_FILE:		// _xZkqqHx_iDhEiDeAiDeDiDiLiNoMjAkMiBeC_xHqqkZx_
			OnCreateFileProc(fileRecover, wstrFilePath);
			break;
		case UNDO_CMD_MODIFY_FILE:		// _xZkqqHx_iDhEiDeAiDeDiDiLiPeDjAlDiBeC_xHqqkZx_
			OnModifyFileProc(fileRecover, lCommandTail, wstrFilePath);
			break;
		default:
			PrintMessage(IDS_ERR_FILE_DESTROY);
			PrintMessage(wcpProjectPath);
			AfxThrowFileException(CFileException::endOfFile, -1, WStrToTStr(wcpProjectPath));
		}

		// _xZkqqHx_iDfCiDhNiDjDiDgIjAoGjDkKiCnGiInKjDkOiBeC_xHqqkZx_
		fileRecover.Seek64(lCommandTop, FILE_BEGIN);
	}
} // CHiDocToolDlg::PatchRecoverFile.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CHiDocToolDlg::OnDeleteDirectoryProc
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiBfLiDfOiDgGiDeCiDiMiDeOiDgHiDiKiNoNiPjMiCmMiDiKiDeKiDgPiDiKiBfLiPiIjHjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fileRecover		:_xZkqqHx_iPeDjFjMiDhEiDeAiDeDiDiLiCmMiDhEiDeAiDeDiDiLiDgOiDjDiDgIiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpDataFilePath	:_xZkqqHx_iDgGiBfLiDfOiDhEiDeAiDeDiDiLiDhAiDfIjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CHiDocToolDlg::OnDeleteDirectoryProc (FCFile32& fileRecover, const wchar_t* wcpDataFilePath)
{
	// _xZkqqHx_iDgPiDgCiDeOiDeBiDgCiDhGiDgGiDeCiDiMiDeOiDgHiDiKiCpAjClCiCnHiCoJiBeC_xHqqkZx_
	FTFileKind fileKindOld = FFIsThereFile(WString(wcpDataFilePath) + L".old");
	if (fileKindOld != FD_FILE_DIRECTORY)
	//----- _xZkqqHx_iDgPiDgCiDeOiDeBiDgCiDhGiDgGiDeCiDiMiDeOiDgHiDiKiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		// IDS_ERR_FILE_NOT_EXIST  "_xZkqqHx_iDeHiDiJiBfLiBeGiDhEiDeAiDeDiDiLiCkKjBlGiNnNiClFiCmEiCkCiCnMiClJiCpBiBeC_xHqqkZx_"
		PrintMessage(IDS_ERR_FILE_NOT_EXIST);
		PrintMessage(WString(wcpDataFilePath) + L".old");
		AfxThrowFileException(CFileException::endOfFile, -1, WStrToTStr(wcpDataFilePath));
	}
	// _xZkqqHx_jAfGiDgGiDeCiDiMiDeOiDgHiDiKiCpAjClCiCnHiCoJiBeC_xHqqkZx_
	FTFileKind fileKindNew = FFIsThereFile(wcpDataFilePath);
	if (fileKindNew == FD_FILE_DIRECTORY)
	//----- _xZkqqHx_jAfGiDgGiDeCiDiMiDeOiDgHiDiKiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ ------
	{
		// _xZkqqHx_jAfGiDgGiDeCiDiMiDeOiDgHiDiKiCpAjBfDiCmEiNoNiPjMiBeC_xHqqkZx_
		if (!FFRecursiveRemoveDirectory(wcpDataFilePath))
		{
			// IDS_ERR_FILE_ACCESS_DENIED "_xZkqqHx_iDeHiDiJiBfLiBeGiDhEiDeAiDeDiDiLiCmMiDeBiDeOiDfKiDfIiCkKiLjGiJmCiClDiCoKiCmEiCkCiCnMiClJiCpBiBeC_xHqqkZx_"
			PrintMessage(IDS_ERR_FILE_ACCESS_DENIED);
			PrintMessage(wcpDataFilePath);
			AfxThrowFileException(CFileException::endOfFile, -1, WStrToTStr(wcpDataFilePath));
		}
	}
	// _xZkqqHx_iDgPiDgCiDeOiDeBiDgCiDhGiDgGiDeCiDiMiDeOiDgHiDiKiCpAjAfGiDgGiDeCiDiMiDeOiDgHiDiKiCnGiInKjDkOiClHiCoJiBeC_xHqqkZx_
	if (!MoveFile(	WStrToTStr(WString(wcpDataFilePath) + L".old"),
					WStrToTStr(wcpDataFilePath)))
	//----- _xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiInKjDkOiCmJiOlIjEhDiClFiClNiPoKiNiH_xHqqkZx_ -----
	{
		// IDS_ERR_FILE_ACCESS_DENIED "_xZkqqHx_iDeHiDiJiBfLiBeGiDhEiDeAiDeDiDiLiCmMiDeBiDeOiDfKiDfIiCkKiLjGiJmCiClDiCoKiCmEiCkCiCnMiClJiCpBiBeC_xHqqkZx_"
		PrintMessage(IDS_ERR_FILE_ACCESS_DENIED);
		PrintMessage(wcpDataFilePath);
		AfxThrowFileException(CFileException::endOfFile, -1, WStrToTStr(wcpDataFilePath));
	}
} // CHiDocToolDlg::OnDeleteDirectoryProc.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CHiDocToolDlg::OnCreateDirectoryProc
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiBfLiDfOiDgGiDeCiDiMiDeOiDgHiDiKiNoMjAkMiCmMiDiKiDeKiDgPiDiKiBfLiPiIjHjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fileRecover		:_xZkqqHx_iPeDjFjMiDhEiDeAiDeDiDiLiCmMiDhEiDeAiDeDiDiLiDgOiDjDiDgIiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpDataFilePath	:_xZkqqHx_iDgGiBfLiDfOiDhEiDeAiDeDiDiLiDhAiDfIjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CHiDocToolDlg::OnCreateDirectoryProc (FCFile32& fileRecover, const wchar_t* wcpDataFilePath)
{
	// _xZkqqHx_jAfGiDgGiDeCiDiMiDeOiDgHiDiKiCpAjClCiCnHiCoJiBeC_xHqqkZx_
	FTFileKind fileKindNew = FFIsThereFile(wcpDataFilePath);
	if (fileKindNew == FD_FILE_DIRECTORY)
	//----- _xZkqqHx_jAfGiDgGiDeCiDiMiDeOiDgHiDiKiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ ------
	{
		// _xZkqqHx_jAfGiDgGiDeCiDiMiDeOiDgHiDiKiCpAjBfDiCmEiNoNiPjMiBeC_xHqqkZx_
		if (!FFRecursiveRemoveDirectory(wcpDataFilePath))
		{
			// IDS_ERR_FILE_ACCESS_DENIED "_xZkqqHx_iDeHiDiJiBfLiBeGiDhEiDeAiDeDiDiLiCmMiDeBiDeOiDfKiDfIiCkKiLjGiJmCiClDiCoKiCmEiCkCiCnMiClJiCpBiBeC_xHqqkZx_"
			PrintMessage(IDS_ERR_FILE_ACCESS_DENIED);
			PrintMessage(wcpDataFilePath);
			AfxThrowFileException(CFileException::endOfFile, -1, WStrToTStr(wcpDataFilePath));
		}
	}
} // CHiDocToolDlg::OnCreateDirectoryProc.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CHiDocToolDlg::OnDeleteFileProc
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiBfLiDfOiDhEiDeAiDeDiDiLiNoNiPjMiCmMiDiKiDeKiDgPiDiKiBfLiPiIjHjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fileRecover		:_xZkqqHx_iPeDjFjMiDhEiDeAiDeDiDiLiCmMiDhEiDeAiDeDiDiLiDgOiDjDiDgIiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpDataFilePath	:_xZkqqHx_iDgGiBfLiDfOiDhEiDeAiDeDiDiLiDhAiDfIjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.01.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CHiDocToolDlg::OnDeleteFileProc (FCFile32& fileRecover, const wchar_t* wcpDataFilePath)
{
	// _xZkqqHx_iDgPiDgCiDeOiDeBiDgCiDhGiDhEiDeAiDeDiDiLiCpAjClCiCnHiCoJiBeC_xHqqkZx_
	FTFileKind fileKindOld = FFIsThereFile(WString(wcpDataFilePath) + L".old");
	if (fileKindOld != FD_FILE_32)
	//----- _xZkqqHx_iDgPiDgCiDeOiDeBiDgCiDhGiDhEiDeAiDeDiDiLiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiH_xHqqkZx_ ------
	{
		// IDS_ERR_FILE_NOT_EXIST  "_xZkqqHx_iDeHiDiJiBfLiBeGiDhEiDeAiDeDiDiLiCkKjBlGiNnNiClFiCmEiCkCiCnMiClJiCpBiBeC_xHqqkZx_"
		PrintMessage(IDS_ERR_FILE_NOT_EXIST);
		PrintMessage(WString(wcpDataFilePath) + L".old");
		AfxThrowFileException(CFileException::endOfFile, -1, WStrToTStr(wcpDataFilePath));
	}
	// _xZkqqHx_jAfGiDhEiDeAiDeDiDiLiCpAjClCiCnHiCoJiBeC_xHqqkZx_
	FTFileKind fileKindNew = FFIsThereFile(wcpDataFilePath);
	if (fileKindNew == FD_FILE_32)
	//----- _xZkqqHx_jAfGiDhEiDeAiDeDiDiLiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ ------
	{
		// _xZkqqHx_jAfGiDhEiDeAiDeDiDiLiCpAiNoNiPjMiBeC_xHqqkZx_
		if (!FFDeleteFile(wcpDataFilePath))
		{
			// IDS_ERR_FILE_ACCESS_DENIED "_xZkqqHx_iDeHiDiJiBfLiBeGiDhEiDeAiDeDiDiLiCmMiDeBiDeOiDfKiDfIiCkKiLjGiJmCiClDiCoKiCmEiCkCiCnMiClJiCpBiBeC_xHqqkZx_"
			PrintMessage(IDS_ERR_FILE_ACCESS_DENIED);
			PrintMessage(wcpDataFilePath);
			AfxThrowFileException(CFileException::endOfFile, -1, WStrToTStr(wcpDataFilePath));
		}
	}
	// _xZkqqHx_iDgPiDgCiDeOiDeBiDgCiDhGiDhEiDeAiDeDiDiLiCpAjAfGiDhEiDeAiDeDiDiLiCnGiInKjDkOiClHiCoJiBeC_xHqqkZx_
	if (!MoveFile(	WStrToTStr(WString(wcpDataFilePath) + L".old"),
					WStrToTStr(wcpDataFilePath)))
	//----- _xZkqqHx_iDhEiDeAiDeDiDiLiInKjDkOiCmJiOlIjEhDiClFiClNiPoKiNiH_xHqqkZx_ -----
	{
		// IDS_ERR_FILE_ACCESS_DENIED "_xZkqqHx_iDeHiDiJiBfLiBeGiDhEiDeAiDeDiDiLiCmMiDeBiDeOiDfKiDfIiCkKiLjGiJmCiClDiCoKiCmEiCkCiCnMiClJiCpBiBeC_xHqqkZx_"
		PrintMessage(IDS_ERR_FILE_ACCESS_DENIED);
		PrintMessage(wcpDataFilePath);
		AfxThrowFileException(CFileException::endOfFile, -1, WStrToTStr(wcpDataFilePath));
	}
} // CHiDocToolDlg::OnDeleteFileProc.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CHiDocToolDlg::OnCreateFileProc
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiBfLiDfOiDhEiDeAiDeDiDiLiNoMjAkMiCmMiDiKiDeKiDgPiDiKiBfLiPiIjHjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fileRecover		:_xZkqqHx_iPeDjFjMiDhEiDeAiDeDiDiLiCmMiDhEiDeAiDeDiDiLiDgOiDjDiDgIiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpDataFilePath	:_xZkqqHx_iDgGiBfLiDfOiDhEiDeAiDeDiDiLiDhAiDfIjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.01.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CHiDocToolDlg::OnCreateFileProc (FCFile32& fileRecover, const wchar_t* wcpDataFilePath)
{
	// _xZkqqHx_jAfGiDhEiDeAiDeDiDiLiCpAjClCiCnHiCoJiBeC_xHqqkZx_
	FTFileKind fileKindNew = FFIsThereFile(wcpDataFilePath);
	if (fileKindNew == FD_FILE_32)
	//----- _xZkqqHx_jAfGiDhEiDeAiDeDiDiLiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ ------
	{
		// _xZkqqHx_jAfGiDhEiDeAiDeDiDiLiCpAiNoNiPjMiBeC_xHqqkZx_
		if (!FFDeleteFile(wcpDataFilePath))
		{
			// IDS_ERR_FILE_ACCESS_DENIED "_xZkqqHx_iDeHiDiJiBfLiBeGiDhEiDeAiDeDiDiLiCmMiDeBiDeOiDfKiDfIiCkKiLjGiJmCiClDiCoKiCmEiCkCiCnMiClJiCpBiBeC_xHqqkZx_"
			PrintMessage(IDS_ERR_FILE_ACCESS_DENIED);
			PrintMessage(wcpDataFilePath);
			AfxThrowFileException(CFileException::endOfFile, -1, WStrToTStr(wcpDataFilePath));
		}
	}
} // CHiDocToolDlg::OnCreateFileProc.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CHiDocToolDlg::OnModifyFileProc
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiBfLiDfOiDhEiDeAiDeDiDiLiPeDjAlDiCmMiDiKiDeKiDgPiDiKiBfLiPiIjHjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fileRecover		:_xZkqqHx_iPeDjFjMiDhEiDeAiDeDiDiLiCmMiDhEiDeAiDeDiDiLiDgOiDjDiDgIiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lCommandTail	:_xZkqqHx_iDfCiDhNiDjDiDgIiPeJjCfLiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpDataFilePath	:_xZkqqHx_iDgGiBfLiDfOiDhEiDeAiDeDiDiLiDhAiDfIjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.01.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CHiDocToolDlg::OnModifyFileProc (FCFile32& fileRecover, long lCommandTail, const wchar_t* wcpDataFilePath)
{
	FTFileKind fileKind = FFIsThereFile(wcpDataFilePath);
	if (fileKind != FD_FILE_32)
	{
		// IDS_ERR_FILE_NOT_EXIST  "_xZkqqHx_iDeHiDiJiBfLiBeGiDhEiDeAiDeDiDiLiCkKjBlGiNnNiClFiCmEiCkCiCnMiClJiCpBiBeC_xHqqkZx_"
		PrintMessage(IDS_ERR_FILE_NOT_EXIST);
		PrintMessage(wcpDataFilePath);
		AfxThrowFileException(CFileException::endOfFile, -1, WStrToTStr(wcpDataFilePath));
	}
	FCFile32 dataFile;
	// _xZkqqHx_iDgGiBfLiDfOiDhEiDeAiDeDiDiLiCpAiBeB_xHqqkZx_RW_xZkqqHx_jEpBiLkEjHeMiCmFiKeKiCkNiBeC_xHqqkZx_
	if (!dataFile.Open(	wcpDataFilePath,
						GENERIC_READ|GENERIC_WRITE,
						0, OPEN_EXISTING))
	{
		// IDS_ERR_FILE_ACCESS_DENIED "_xZkqqHx_iDeHiDiJiBfLiBeGiDhEiDeAiDeDiDiLiCmMiDeBiDeOiDfKiDfIiCkKiLjGiJmCiClDiCoKiCmEiCkCiCnMiClJiCpBiBeC_xHqqkZx_"
		PrintMessage(IDS_ERR_FILE_ACCESS_DENIED);
		PrintMessage(wcpDataFilePath);
		AfxThrowFileException(CFileException::endOfFile, -1, WStrToTStr(wcpDataFilePath));
	}
	// _xZkqqHx_iPeDjFjMiDhEiDeAiDeDiDiLiCkJiCoHiBeBiPeDjAlDjBePiDhEiDeAiDeDiDiLjClHiCpAiOoGjDlOiBeC_xHqqkZx_
	flint fliFileLen;
	fileRecover.Read64(&fliFileLen, sizeof(fliFileLen));
	// _xZkqqHx_iPeDjAlDjBePiDhEiDeAiDeDiDiLjClHiCkKiBeBiMlLiNnNiCmMiDhEiDeAiDeDiDiLjClHiCoGiCoIjCfKiCkCiPoKiNiHiCmNiBeBiPeDjAlDjBePiDhEiDeAiDeDiDiLjClHiCmJjFmPiNfIiBeC_xHqqkZx_
	if (fliFileLen < dataFile.GetLength64())
		dataFile.SetLength64(fliFileLen);

	// _xZkqqHx_iNlHjFkKiDgGiBfLiDfOiCmMjDmHiCnNiNjOiCnNiCmGiDiKiDeKiDgPiDiKiBfLiPiIjHjNiBeC_xHqqkZx_
	// _xZkqqHx_iNlHjFkKiDhFiDiNiDgCiDeOiCmMiBeBiPeDjAlDiImKjChFiKeKiOgOiDeBiDgIiDiMiDfIiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
	flint fliAddress;
	fileRecover.Read64(&fliAddress, sizeof(fliAddress));
	// _xZkqqHx_iDgGiBfLiDfOiDfEiDeDiDfJiCpAiOfKiPgPiBeC_xHqqkZx_
	long lRecoverDataSize = lCommandTail - fileRecover.GetPosition64();

	if (lRecoverDataSize != 0)
	//----- _xZkqqHx_iPeDjFjMiDgGiBfLiDfOiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iPeDjFjMiKeKiOgOiImKjChFiCnGiInKjDkOiBeC_xHqqkZx_
		dataFile.Seek64(fliAddress, FILE_BEGIN);
		// _xZkqqHx_iPoDiPjBiCkLiClDiCoKiClNjHmMiIoGiCpAiDgPiDgCiDeOiDeBiDgCiDhGiCkJiCoHjGnPiClHiBeC_xHqqkZx_
		FFCopy(dataFile, fileRecover, lRecoverDataSize);
	}
	// _xZkqqHx_iDgGiBfLiDfOiDhEiDeAiDeDiDiLiCmMiDgOiDjDiDgIiDiLiCpAjFmCiClGiCoJiBeC_xHqqkZx_
	dataFile.Close();
} // CHiDocToolDlg::OnModifyFileProc.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CHiDocToolDlg::DoRecover
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iPeDjFjMiCpAiOmAiNhDiClHiCoJiBeCiPeDjFjMiKeKiOgOiDhLiDfOiDjDiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpProjectPath	:_xZkqqHx_iPeDjFjMjBmOiPnLiCmMiDhGiDiNiDfHiDeGiDeOiDgHiDhEiDeAiDeDiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iPeDjFjMiCmJjAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CHiDocToolDlg::DoRecover (const wchar_t* wcpProjectPath)
{
	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDhEiDeAiDeDiDiLiCkKjBlGiNnNiClHiCoJiCkJjClCiCnHiCoJiBeC_xHqqkZx_
	switch (FFIsThereFile(wcpProjectPath))
	{
	case FD_FILE_32:		// 32_xZkqqHx_iDhCiDgCiDgHiDhEiDeAiDeDiDiLiBgJjCmKiPoNiDhEiDeAiDeDiDiLiBgKiCkKjBlGiNnNiClHiCoJiBeC_xHqqkZx_
		break;
	case FD_FILE_DIRECTORY:	// _xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiCkKjBlGiNnNiClHiCoJiBeC_xHqqkZx_
		if (FFIsThereFile(WString(wcpProjectPath) + L"\\0.ddtb") != FD_FILE_32)
		//----- _xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiJlKiCmJ_xHqqkZx_ 0.ddtb _xZkqqHx_iCkKjBlGiNnNiClFiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			// IDS_ERR_FILE_NOT_EXIST  "_xZkqqHx_iDeHiDiJiBfLiBeGiDhEiDeAiDeDiDiLiCkKjBlGiNnNiClFiCmEiCkCiCnMiClJiCpBiBeC_xHqqkZx_"
			PrintMessage(IDS_ERR_FILE_NOT_EXIST);
			PrintMessage(wcpProjectPath);
			return FALSE;
		}
		break;
	default:
		// IDS_ERR_FILE_NOT_EXIST  "_xZkqqHx_iDeHiDiJiBfLiBeGiDhEiDeAiDeDiDiLiCkKjBlGiNnNiClFiCmEiCkCiCnMiClJiCpBiBeC_xHqqkZx_"
		PrintMessage(IDS_ERR_FILE_NOT_EXIST);
		PrintMessage(wcpProjectPath);
		return FALSE;
	}

	// IDS_MSG_RECOVER_START    "_xZkqqHx_iPeDjFjMiCpAiKeKiOgOiClFiCnMiClHiBeC_xHqqkZx_"
	PrintMessage(IDS_MSG_RECOVER_START);
	PrintMessage(wcpProjectPath);

	// _xZkqqHx_iCnMiClIiBeBiDhGiDiNiDfHiDeGiDeOiDgHiJlKiClHiCnHiCmEiCmMiDgGiDeCiDiMiDeOiDgHiDiKiBeBiDhEiDeAiDeDiDiLiCmMiDeBiDeOiDfKiDfIiCkKiLjGiJmCiClDiCoKiCmEiCkCiCoJiClBiCmGiCpAjClCiCnHiCoJiBeC_xHqqkZx_
	WString wstrInvalidFile;
	if (!myCheckAccess(wstrInvalidFile, wcpProjectPath))
	//----- _xZkqqHx_iDhEiDeAiDeDiDiLiCmMiDeBiDeOiDfKiDfIiCkKjFhDiLjGiJmCiCmMiPoKiNiH_xHqqkZx_ -----
	{
    	// IDS_ERR_FILE_ACCESS_DENIED "_xZkqqHx_iDeHiDiJiBfLiBeGiDhEiDeAiDeDiDiLiCmMiDeBiDeOiDfKiDfIiCkKiLjGiJmCiClDiCoKiCmEiCkCiCnMiClJiCpBiBeC_xHqqkZx_"
		PrintMessage(IDS_ERR_FILE_ACCESS_DENIED);
		PrintMessage(wstrInvalidFile);
		return FALSE;
	}

	// own_xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiCpAiDiNiDgCiDeOiClFiCmEiCkIiCkNiBeC_xHqqkZx_
	// _xZkqqHx_iDgFiBfLiDhFiDiLiPiKjHeMiMkAiCmMiDgGiDeCiDiMiDeOiDgHiDiKjGlMiBeC_xHqqkZx_
	WString wstrLockDirPath = WString(wcpProjectPath) + L'\\' + FDTBL_LOCK_OWN_DIR_NAME;
	FCFile32 fileLockDir;

// 06.04.12 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	if (FFVersionInfo().dwPlatformId == VER_PLATFORM_WIN32_NT)
	//----- WindowsNT_xZkqqHx_iMgOiCmMiPoKiNiH_xHqqkZx_ ------
	{
		// _xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiCkK_xHqqkZx_OPEN_xZkqqHx_iCmFiCkLiCoJiCmMiCmNiBeB_xHqqkZx_WindowsNT_xZkqqHx_iMgOiCmMiCnNiBeC_xHqqkZx_
		if (!fileLockDir.Open(	wstrLockDirPath,
								FILE_LIST_DIRECTORY,					// _xZkqqHx_iDeBiDeOiDfKiDfIiBgJ_xHqqkZx_ _xZkqqHx_jDmHiCnNiPjBiCkLiBgKiDiCiBfLiDgIiBeC_xHqqkZx_
								0,										// _xZkqqHx_iLkEjHeMiDiCiBfLiDgIiBeC_xHqqkZx_
								OPEN_EXISTING,							// _xZkqqHx_iNoMjAkMjFpLjGeAiBeC_xHqqkZx_
								FILE_FLAG_BACKUP_SEMANTICS))			// _xZkqqHx_iDhEiDeAiDeDiDiLjBkOjAkLiBeC_xHqqkZx_
		{
			// IDS_ERR_OWN_FILE_ACCESS_DENIED  "_xZkqqHx_iDeHiDiJiBfLiBeGiPiKjHeMiDhEiDeAiDeDiDiLiCmJiDeBiDeOiDfKiDfIiCmFiCkLiCnMiClJiCpBiBeC_xHqqkZx_"
			PrintMessage(IDS_ERR_OWN_FILE_ACCESS_DENIED);
			PrintMessage(wstrLockDirPath);
			return FALSE;
		}
	}
	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiJlKiCmJiCkAiCoJjBfDiCmEiCmMiPeDjFjMiDhEiDeAiDeDiDiLiCpAiOoGjDlOiBeC_xHqqkZx_
	vector<WString> vRecoverFile;
	mySearchRecoverFile(vRecoverFile, wcpProjectPath);

	long lC;
	for (lC = 0; lC != vRecoverFile.size(); lC++)
	//----- _xZkqqHx_jBfDiCmEiCmMiPeDjFjMiDhEiDeAiDeDiDiLiCpAiDiLiBfLiDhG_xHqqkZx_ -----
	{
		// _xZkqqHx_iPeDjFjMiDhEiDeAiDeDiDiLiCpA_xHqqkZx_ RW_xZkqqHx_jEpBiLkEjHeMiCmFiKeKiCkNiBeC_xHqqkZx_
		FCCRCFileTmpl32<FCFile32> fileRecover;
		if (!fileRecover.Open(vRecoverFile[lC], GENERIC_READ|GENERIC_WRITE, 0, OPEN_EXISTING))
		//----- _xZkqqHx_iPeDjFjMiDhEiDeAiDeDiDiLiCkK_xHqqkZx_RW_xZkqqHx_iLkEjHeMiCmFiDeJiBfLiDhGiDjDiCmFiCkLiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iClBiCmMiPeDjFjMiDhEiDeAiDeDiDiLiCkKiOgHiCoNiCoKiCmEiCkCiCoJiBgJjBlMiPeDjFjMiDgDiBfLiDiLiCmFiPeDjFjMjCiG_xHqqkZx_ _xZkqqHx_iIlNiCkCiCmN_xHqqkZx_
			// _xZkqqHx_iDeBiDhGiDiKjGhLjBmMiCkKiDhEiDiJiDgCiDfGiDiFjCiGiBgKiCmGiNgMiCkGiCoHiCoKiCoJiBeC_xHqqkZx_

			// IDS_ERR_FILE_ACCESS_DENIED  "_xZkqqHx_iDeHiDiJiBfLiBeGiDhEiDeAiDeDiDiLiCmMiDeBiDeOiDfKiDfIiCkKiLjGiJmCiClDiCoKiCmEiCkCiCnMiClJiCpBiBeC_xHqqkZx_"
			PrintMessage(IDS_ERR_FILE_ACCESS_DENIED);
			PrintMessage(vRecoverFile[lC]);
			return FALSE;
		}
		// _xZkqqHx_iPeDjFjMiDhEiDeAiDeDiDiLiCmMjAlDjDjGjAkLiCpAiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
		switch (myIsRecoverFileRegal(fileRecover))
		{
		case 0:	//----- _xZkqqHx_iPeDjFjMiDhEiDeAiDeDiDiLiCkKiKkOjBfDiCmMiPoKiNiH_xHqqkZx_ -----
		  {
			// _xZkqqHx_iPeDjFjMiDhEiDeAiDeDiDiLiCpAiOgHiCmBiCmEiBeBiDhEiDeAiDeDiDiLiCpAiMlDiCmJjGnPiClHiBeC_xHqqkZx_
			PatchRecoverFile(fileRecover, wcpProjectPath);
			// _xZkqqHx_iPeDjFjMiDhEiDeAiDeDiDiLiCmMjClHiClDiCpAiCePiCmJiClHiCoJiBeC_xHqqkZx_
			fileRecover.SetLength64(0);
			break;
		  }
		case 1:	//----- _xZkqqHx_iPeDjFjMiDhEiDeAiDeDiDiLiCkKjDhCjCiGiPeJjHlJiClFiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
			// _xZkqqHx_iPeDjFjMiDhEiDeAiDeDiDiLiNoMjAkMjDhCjCiGiCmFiInJiPoNiPeJjHlJiClFiClNiCmGiNgMiCkGiCoHiCoKiCoJiBeC_xHqqkZx_
			// _xZkqqHx_iPeDjFjMiCmMjFeLjHhGiCmNjGlDiCkCiCmGiCnNiCmIiClHiBeC_xHqqkZx_
			// _xZkqqHx_iPeDjFjMiDhEiDeAiDeDiDiLiCmMjClHiClDiCpAiCePiCmJiClHiCoJiBeC_xHqqkZx_
			fileRecover.SetLength64(0);
			break;
		case 2:	//----- _xZkqqHx_iPeDjFjMiDhEiDeAiDeDiDiLiCkKjEgKjBlJiClFiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
			// _xZkqqHx_iPeDjFjMiDhEiDeAiDeDiDiLiCpAjFmCiClGiCoJiBeC_xHqqkZx_
			fileRecover.Close();
			// IDS_ERR_FILE_DESTROY "_xZkqqHx_iDeHiDiJiBfLiBeGiDhEiDeAiDeDiDiLiCmNjEgKjBlJiClFiCmEiCkCiCnMiClHiBeC_xHqqkZx_"
			PrintMessage(IDS_ERR_FILE_DESTROY);
			PrintMessage(vRecoverFile[lC]);
			return FALSE;
		}
		// _xZkqqHx_iPeDjFjMiDhEiDeAiDeDiDiLiCpAjFmCiClGiCoJiBeC_xHqqkZx_
		fileRecover.Close();

		// _xZkqqHx_iPeDjFjMiDhEiDeAiDeDiDiLiCpAiNoNiPjMiBeC_xHqqkZx_
		if (!FFDeleteFile(vRecoverFile[lC]))
		//----- _xZkqqHx_iPeDjFjMiDhEiDeAiDeDiDiLiCmMiNoNiPjMiCmJiOlIjEhDiClFiClNiPoKiNiH_xHqqkZx_ -----
		{
			// IDS_ERR_FILE_ACCESS_DENIED "_xZkqqHx_iDeHiDiJiBfLiBeGiDhEiDeAiDeDiDiLiCmMiDeBiDeOiDfKiDfIiCkKiLjGiJmCiClDiCoKiCmEiCkCiCnMiClJiCpBiBeC_xHqqkZx_"
			PrintMessage(IDS_ERR_FILE_ACCESS_DENIED);
			PrintMessage(vRecoverFile[lC]);
			return FALSE;
		}
	}

	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDgGiDeCiDiMiDeOiDgHiDiKiJlKiCmMjBfDiCmEiCmM_xHqqkZx_ .OLD_xZkqqHx_iDhEiDeAiDeDiDiLiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
	if (!myDeleteOldFile(wstrInvalidFile, wcpProjectPath))
	{
		// IDS_ERR_FILE_ACCESS_DENIED "_xZkqqHx_iDeHiDiJiBfLiBeGiDhEiDeAiDeDiDiLiCmMiDeBiDeOiDfKiDfIiCkKiLjGiJmCiClDiCoKiCmEiCkCiCnMiClJiCpBiBeC_xHqqkZx_"
		PrintMessage(IDS_ERR_FILE_ACCESS_DENIED);
		PrintMessage(wstrInvalidFile);
		return FALSE;
	}

	// own_xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiCmMiDiNiDgCiDeOiCpAiJpAiPjMiBeC_xHqqkZx_
	// _xZkqqHx_iNmFiMoDiCnMiCmFiDiNiDgCiDeOiClFiCmEiCkIiCkLiClNiCkCiCkKiBeB_xHqqkZx_own_xZkqqHx_iDhEiDeAiDeDiDiLiCmMiPeDjFjMiCmMiClNiCnPiCmJ_xHqqkZx_
	// _xZkqqHx_iDiNiDgCiDeOiCpAiJpAiPjMiClFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
	if (fileLockDir.IsFileOpened())
		fileLockDir.Close();

	// .ddix _xZkqqHx_iDhEiDeAiDeDiDiLiCmMiDhAiDfIiCpAiPfHiCnPiCoJiBeC_xHqqkZx_stTablePath _xZkqqHx_iCmJiCmNiBeB_xHqqkZx_"$0$1$" _xZkqqHx_iCmMiMgAiOkOiCmFjAnNjCoIiClDiCoKiCoJiBeC_xHqqkZx_
	set<WString> stTablePath;
	myGetTablePath(stTablePath, L"", wcpProjectPath);

	// own_xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiCmMjClMiJlKiCmJiCkAiCoJ_xHqqkZx_own_xZkqqHx_iDhEiDeAiDeDiDiLiCmMjHpBiLjDiBeC_xHqqkZx_
	WStringVector vFileName;
	FFEnumDirectoryFile(WStringVector(),
						vFileName,
						wstrLockDirPath + L"\\*.k");

	// own_xZkqqHx_iDhEiDeAiDeDiDiLiCpAiPfHiCnPiCoJiBeCiKgHjCkDiOhBiCpAiPjMiCkCiClN_xHqqkZx_"$0$1$"_xZkqqHx_iCmMiMgAiOkOiBeC_xHqqkZx_
	set<WString> stOwnPath;
	WStringVector::const_iterator iStr;
	for (iStr = vFileName.begin(); iStr != vFileName.end(); iStr++)
		stOwnPath.insert(iStr->Left(iStr->GetLength() - wcslen(L".k")));

	// own_xZkqqHx_iDhEiDeAiDeDiDiLiCmMiCkEiClPiBeBjBmOiJjOiClHiCoJ_xHqqkZx_ _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCkKjBlGiNnNiClFiCmIiCkCiCoAiCmMiCmNiNoNiPjMiClHiCoJiBeC_xHqqkZx_

	set<WString>::iterator iOwn;
	for (iOwn = stOwnPath.begin(); iOwn != stOwnPath.end();)
	//----- own_xZkqqHx_iDhEiDeAiDeDiDiLiCpAiDiLiBfLiDhG_xHqqkZx_ -----
	{
		if (stTablePath.find(*iOwn) == stTablePath.end())
		//----- _xZkqqHx_jBmOiJjOiClHiCoJ_xHqqkZx_ _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCkKiMkJiCmCiCkJiCoHiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			WString wstrOwn = wstrLockDirPath + L'\\' + *iOwn + L".k";
			// _xZkqqHx_iDhEiDeAiDeDiDiLiCpAiNoNiPjMiBeC_xHqqkZx_
			if (!FFDeleteFile(wstrOwn))
			{
				// IDS_ERR_FILE_ACCESS_DENIED "_xZkqqHx_iDeHiDiJiBfLiBeGiDhEiDeAiDeDiDiLiCmMiDeBiDeOiDfKiDfIiCkKiLjGiJmCiClDiCoKiCmEiCkCiCnMiClJiCpBiBeC_xHqqkZx_"
				PrintMessage(IDS_ERR_FILE_ACCESS_DENIED);
				PrintMessage(wstrOwn);
				return FALSE;
			}
			iOwn = stOwnPath.erase(iOwn);
		} else
		//----- _xZkqqHx_jBmOiJjOiClHiCoJ_xHqqkZx_ _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCkKiMkJiCmCiCkJiCmBiClNiPoKiNiH_xHqqkZx_ -----
		{
			iOwn++;
		}
	}

	set<WString>::const_iterator iDix;
	for (iDix = stTablePath.begin(); iDix != stTablePath.end(); iDix++)
	//----- _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCpAiDiLiBfLiDhG_xHqqkZx_ -----
	{
		// _xZkqqHx_jBmOiJjOiClHiCoJ_xHqqkZx_own_xZkqqHx_iDhEiDeAiDeDiDiLiCmMiDhEiDiLiDhAiDfIiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
		WString wstrOwn = wstrLockDirPath + L'\\' + *iDix + L".k";

		FCFile32 ownFile;
		if (stOwnPath.find(*iDix) == stOwnPath.end())
		//----- _xZkqqHx_jBmOiJjOiClHiCoJ_xHqqkZx_ own_xZkqqHx_iDhEiDeAiDeDiDiLiCkKiMkJiCmCiCkJiCoHiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			// own_xZkqqHx_iDhEiDeAiDeDiDiLiCpAjAfGiLeLiNoMjAkMiBeC_xHqqkZx_
			ownFile.Open(	wstrOwn,
							GENERIC_READ|GENERIC_WRITE,
							0, CREATE_NEW);
		} else
		//----- _xZkqqHx_jBmOiJjOiClHiCoJ_xHqqkZx_ own_xZkqqHx_iDhEiDeAiDeDiDiLiCkKiMkJiCmCiCkJiCmBiClNiPoKiNiH_xHqqkZx_ -----
		{
			// own_xZkqqHx_iDhEiDeAiDeDiDiLiCpAiKeKiCkNiBeC_xHqqkZx_
			ownFile.Open(	wstrOwn,
							GENERIC_READ|GENERIC_WRITE,
							0, OPEN_EXISTING);
		}
		if (!ownFile.IsFileOpened())
		//----- _xZkqqHx_iDhEiDeAiDeDiDiLiCkKiKeKiCkCiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			// IDS_ERR_FILE_ACCESS_DENIED "_xZkqqHx_iDeHiDiJiBfLiBeGiDhEiDeAiDeDiDiLiCmMiDeBiDeOiDfKiDfIiCkKiLjGiJmCiClDiCoKiCmEiCkCiCnMiClJiCpBiBeC_xHqqkZx_"
			PrintMessage(IDS_ERR_FILE_ACCESS_DENIED);
			PrintMessage(wstrOwn);
			return FALSE;
		}
		if (ownFile.GetLength64() != sizeof(GUID) + sizeof(DWORD) + sizeof(DWORD))
		//----- own_xZkqqHx_iDhEiDeAiDeDiDiLiCkKiLeLjCoIiCmMjClHiClDiCmFiCmNiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCmMiDhEiDiLiDhAiDfIiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
			WString wstrDix = *iDix;
			wstrDix.ChopLast(L'$');
			wstrDix.Replace(L'$', L'\\');
			WString wstrDixPath = WString(wcpProjectPath) + wstrDix + L".ddix";
			// _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCpAjDmHiCnNiPgPiClFiCmEjCmHiJmB_xHqqkZx_Identifier_xZkqqHx_iCpAiLiBiCnPiCoJiBeC_xHqqkZx_
			DWORD dwAppendIdentifier;
			DWORD dwErrorCode = myGetAppendIdentifier(dwAppendIdentifier, wstrDixPath);
			if (dwErrorCode != 0)
			{
				PrintMessage(dwErrorCode);
				PrintMessage(wstrDixPath);
				return FALSE;
			}
			// _xZkqqHx_jAfGiClFiCkCiDgFiBfLiDhFiDiL_xHqqkZx_GUID_xZkqqHx_iCpAiNoMjAkMiBeC_xHqqkZx_
			GUID guidTable = FFCreateGuid();
			// own_xZkqqHx_iDhEiDeAiDeDiDiLiCmJjAfGiClFiCkCiPoOjFpBiCpAiPjBiCkLiNjOiCnOiBeC_xHqqkZx_
			ownFile.Seek64(0, FILE_BEGIN);
			ownFile.Write64(&guidTable, sizeof(guidTable));
			const DWORD dwDeleteIdentifier = 0;
			ownFile.Write64(&dwDeleteIdentifier, sizeof(dwDeleteIdentifier));
			ownFile.Write64(&dwAppendIdentifier, sizeof(dwAppendIdentifier));
		}
		// own_xZkqqHx_iDhEiDeAiDeDiDiLiCpAjFmCiClGiCoJiBeC_xHqqkZx_
		ownFile.Close();
	}

	// IDS_MSG_RECOVER_SUCCEED  "_xZkqqHx_iPeDjFjMiCmNjAkMiMpHiClFiCnMiClFiClNiBeC_xHqqkZx_"
	PrintMessage(IDS_MSG_RECOVER_SUCCEED);
	return TRUE;
} // CHiDocToolDlg::DoRecover.
