#ifndef __UtilErr_h
#define __UtilErr_h

#include "resource.h"	// For IDS_ERR_MISC_UNKNOWN.

class CFCMiscException : public CException
{
	DECLARE_DYNCREATE(CFCMiscException)

public:
	CFCMiscException ();
	virtual BOOL GetErrorMessage (LPTSTR lpszError, UINT nMaxError, PUINT pnHelpContext = NULL);
	virtual DWORD GetMessageId () const;

friend void FFThrowMiscException (DWORD dwMessageId, ...);
friend void FFThrowMiscLastError ();

protected:
	DWORD		m_dwMessageId;
	WString		m_strMsg;
}; // class CFCMiscException.

extern void FFThrowFileException (int cause, LONG lOsError = -1,
									const wchar_t* lpszFileName = NULL);

extern void FFThrowMiscException (DWORD dwMessageId, ...);
extern void FFThrowMiscLastError ();
extern void FFDebugTrace (const wchar_t* wcpFormat, ...);

//#define FFThrowMiscUnknown()	{ AfxThrowUserException(); }

#define FFThrowMiscUnknown()	{ AfxDebugBreak(); FFThrowMiscException(IDS_ERR_MISC_UNKNOWN, (const wchar_t*)TStrToWStr(__FILE__), __LINE__); }

#endif//__UtilErr_h
