#ifndef __CBitmap_h
#define __CBitmap_h

class MfcBitmap : public MfcGdiObject
{
public:
	static MfcBitmap* New ();
	static void Delete (MfcBitmap* pBitmap);
	static MfcBitmap* FromHandle (HBITMAP hBitmap);
	BOOL LoadBitmap (LPCTSTR lpszResourceName);
	BOOL LoadBitmap (UINT nIDResource);
	BOOL LoadOEMBitmap (UINT nIDBitmap);
	BOOL LoadMappedBitmap (UINT nIDBitmap, UINT nFlags = 0, LPCOLORMAP lpColorMap = NULL, int nMapSize = 0);
	BOOL CreateBitmap (int nWidth, int nHeight, UINT nPlanes, UINT nBitcount, const void* lpBits);
	BOOL CreateBitmapIndirect (LPBITMAP lpBitmap);
	BOOL CreateCompatibleBitmap (MfcDC* pDC, int nWidth, int nHeight);
	BOOL CreateDiscardableBitmap (MfcDC* pDC, int nWidth, int nHeight);
	operator HBITMAP () const;
	int GetBitmap (BITMAP* pBitMap);
	DWORD SetBitmapBits (DWORD dwCount, const void* lpBits);
	DWORD GetBitmapBits (DWORD dwCount, LPVOID lpBits) const;
	MfcSize SetBitmapDimension (int nWidth, int nHeight);
	MfcSize GetBitmapDimension () const;

	virtual MfcRuntimeClass* GetRuntimeClass() const;
	virtual ~MfcBitmap();
#ifdef _DEBUG
	virtual void Dump(MfcDumpContext& dc) const;
#endif
};

#endif//__CBitmap_h
