#ifndef __CDC_cpp
#define __CDC_cpp

MfcDC* MfcDC::New ()
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_New();
} // MfcDC* MfcDC::New ()

void MfcDC::Delete (MfcDC* pDC)
{
	FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_Delete(pDC);
} // void MfcDC::Delete (MfcDC* pDC)

MfcDC::operator HDC () const
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_HDC(this);
} // MfcDC::operator HDC () const;

HDC MfcDC::GetSafeHdc () const
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_GetSafeHdc(this);
} // HDC MfcDC::GetSafeHdc () const;

MfcWnd* MfcDC::GetWindow () const
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_GetWindow(this);
} // MfcWnd* MfcDC::GetWindow () const;

MfcDC* MfcDC::FromHandle (HDC hDC)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_FromHandle(hDC);
} // MfcDC* MfcDC::FromHandle (HDC hDC);

void MfcDC::DeleteTempMap ()
{
	FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_DeleteTempMap();
} // void MfcDC::DeleteTempMap ();

BOOL MfcDC::Attach (HDC hDC)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_Attach(this, hDC);
} // BOOL MfcDC::Attach (HDC hDC);

HDC MfcDC::Detach ()
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_Detach(this);
} // HDC MfcDC::Detach ();

BOOL MfcDC::IsPrinting () const
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_IsPrinting(this);
} // BOOL MfcDC::IsPrinting () const;

MfcPen* MfcDC::GetCurrentPen () const
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_GetCurrentPen(this);
} // MfcPen* MfcDC::GetCurrentPen () const;

MfcBrush* MfcDC::GetCurrentBrush () const
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_GetCurrentBrush(this);
} // MfcBrush* MfcDC::GetCurrentBrush () const;

MfcPalette* MfcDC::GetCurrentPalette () const
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_GetCurrentPalette(this);
} // MfcPalette* MfcDC::GetCurrentPalette () const;

MfcFont* MfcDC::GetCurrentFont () const
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_GetCurrentFont(this);
} // MfcFont* MfcDC::GetCurrentFont () const;

MfcBitmap* MfcDC::GetCurrentBitmap () const
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_GetCurrentBitmap(this);
} // MfcBitmap* MfcDC::GetCurrentBitmap () const;

DWORD MfcDC::GetLayout () const
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_GetLayout(this);
} // DWORD MfcDC::GetLayout () const;

DWORD MfcDC::SetLayout (DWORD dwLayout)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_SetLayout(this, dwLayout);
} // DWORD MfcDC::SetLayout (DWORD dwLayout);

BOOL MfcDC::CreateDC (LPCTSTR lpszDriverName, LPCTSTR lpszDeviceName, LPCTSTR lpszOutput, const void* lpInitData)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_CreateDC(this, lpszDriverName, lpszDeviceName, lpszOutput, lpInitData);
} // BOOL MfcDC::CreateDC (LPCTSTR lpszDriverName, LPCTSTR lpszDeviceName, LPCTSTR lpszOutput, const void* lpInitData);

BOOL MfcDC::CreateIC (LPCTSTR lpszDriverName, LPCTSTR lpszDeviceName, LPCTSTR lpszOutput, const void* lpInitData)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_CreateIC(this, lpszDriverName, lpszDeviceName, lpszOutput, lpInitData);
} // BOOL MfcDC::CreateIC (LPCTSTR lpszDriverName, LPCTSTR lpszDeviceName, LPCTSTR lpszOutput, const void* lpInitData);

BOOL MfcDC::CreateCompatibleDC (MfcDC* pDC)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_CreateCompatibleDC(this, pDC);
} // BOOL MfcDC::CreateCompatibleDC (MfcDC* pDC);

BOOL MfcDC::DeleteDC ()
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_DeleteDC(this);
} // BOOL MfcDC::DeleteDC ();

int MfcDC::GetDeviceCaps (int nIndex) const
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_GetDeviceCaps(this, nIndex);
} // int MfcDC::GetDeviceCaps (int nIndex) const;

UINT MfcDC::SetBoundsRect (LPCRECT lpRectBounds, UINT flags)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_SetBoundsRect(this, lpRectBounds, flags);
} // UINT MfcDC::SetBoundsRect (LPCRECT lpRectBounds, UINT flags);

UINT MfcDC::GetBoundsRect (LPRECT lpRectBounds, UINT flags)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_GetBoundsRect(this, lpRectBounds, flags);
} // UINT MfcDC::GetBoundsRect (LPRECT lpRectBounds, UINT flags);

BOOL MfcDC::ResetDC (const DEVMODE* lpDevMode)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_ResetDC(this, lpDevMode);
} // BOOL MfcDC::ResetDC (const DEVMODE* lpDevMode);

MfcPoint MfcDC::GetBrushOrg () const
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_GetBrushOrg(this);
} // MfcPoint MfcDC::GetBrushOrg () const;

MfcPoint MfcDC::SetBrushOrg (int x, int y)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_SetBrushOrg(this, x, y);
} // MfcPoint MfcDC::SetBrushOrg (int x, int y);

MfcPoint MfcDC::SetBrushOrg (POINT point)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_SetBrushOrg(this, point);
} // MfcPoint MfcDC::SetBrushOrg (POINT point);

int MfcDC::EnumObjects (int nObjectType, int (CALLBACK* lpfn)(LPVOID, LPARAM), LPARAM lpData)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_EnumObjects(this, nObjectType, lpfn, lpData);
} // int MfcDC::EnumObjects (int nObjectType, int (CALLBACK* lpfn)(LPVOID, LPARAM), LPARAM lpData);

MfcPen* MfcDC::SelectObject (MfcPen* pPen)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_SelectObject(this, pPen);
} // MfcPen* MfcDC::SelectObject (MfcPen* pPen);

MfcBrush* MfcDC::SelectObject (MfcBrush* pBrush)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_SelectObject(this, pBrush);
} // MfcBrush* MfcDC::SelectObject (MfcBrush* pBrush);

MfcBitmap* MfcDC::SelectObject (MfcBitmap* pBitmap)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_SelectObject(this, pBitmap);
} // MfcBitmap* MfcDC::SelectObject (MfcBitmap* pBitmap);

int MfcDC::SelectObject (MfcRgn* pRgn)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_SelectObject(this, pRgn);
} // int MfcDC::SelectObject (MfcRgn* pRgn);

MfcGdiObject* MfcDC::SelectObject (MfcGdiObject* pObject)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_SelectObject(this, pObject);
} // MfcGdiObject* MfcDC::SelectObject (MfcGdiObject* pObject);

COLORREF MfcDC::GetNearestColor (COLORREF crColor) const
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_GetNearestColor(this, crColor);
} // COLORREF MfcDC::GetNearestColor (COLORREF crColor) const;

MfcPalette* MfcDC::SelectPalette (MfcPalette* pPalette, BOOL bForceBackground)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_SelectPalette(this, pPalette, bForceBackground);
} // MfcPalette* MfcDC::SelectPalette (MfcPalette* pPalette, BOOL bForceBackground);

UINT MfcDC::RealizePalette ()
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_RealizePalette(this);
} // UINT MfcDC::RealizePalette ();

void MfcDC::UpdateColors ()
{
	FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_UpdateColors(this);
} // void MfcDC::UpdateColors ();

COLORREF MfcDC::GetBkColor () const
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_GetBkColor(this);
} // COLORREF MfcDC::GetBkColor () const;

int MfcDC::GetBkMode () const
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_GetBkMode(this);
} // int MfcDC::GetBkMode () const;

int MfcDC::GetPolyFillMode () const
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_GetPolyFillMode(this);
} // int MfcDC::GetPolyFillMode () const;

int MfcDC::GetROP2 () const
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_GetROP2(this);
} // int MfcDC::GetROP2 () const;

int MfcDC::GetStretchBltMode () const
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_GetStretchBltMode(this);
} // int MfcDC::GetStretchBltMode () const;

COLORREF MfcDC::GetTextColor () const
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_GetTextColor(this);
} // COLORREF MfcDC::GetTextColor () const;

int MfcDC::SetBkMode (int nBkMode)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_SetBkMode(this, nBkMode);
} // int MfcDC::SetBkMode (int nBkMode);

int MfcDC::SetPolyFillMode (int nPolyFillMode)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_SetPolyFillMode(this, nPolyFillMode);
} // int MfcDC::SetPolyFillMode (int nPolyFillMode);

int MfcDC::SetROP2 (int nDrawMode)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_SetROP2(this, nDrawMode);
} // int MfcDC::SetROP2 (int nDrawMode);

int MfcDC::SetStretchBltMode (int nStretchMode)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_SetStretchBltMode(this, nStretchMode);
} // int MfcDC::SetStretchBltMode (int nStretchMode);

BOOL MfcDC::GetColorAdjustment (LPCOLORADJUSTMENT lpColorAdjust) const
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_GetColorAdjustment(this, lpColorAdjust);
} // BOOL MfcDC::GetColorAdjustment (LPCOLORADJUSTMENT lpColorAdjust) const;

BOOL MfcDC::SetColorAdjustment (const COLORADJUSTMENT* lpColorAdjust)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_SetColorAdjustment(this, lpColorAdjust);
} // BOOL MfcDC::SetColorAdjustment (const COLORADJUSTMENT* lpColorAdjust);

int MfcDC::GetMapMode () const
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_GetMapMode(this);
} // int MfcDC::GetMapMode () const;

MfcPoint MfcDC::GetViewportOrg () const
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_GetViewportOrg(this);
} // MfcPoint MfcDC::GetViewportOrg () const;

MfcPoint MfcDC::SetViewportOrg (POINT point)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_SetViewportOrg(this, point);
} // MfcPoint MfcDC::SetViewportOrg (POINT point);

MfcSize MfcDC::GetViewportExt () const
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_GetViewportExt(this);
} // MfcSize MfcDC::GetViewportExt () const;

MfcSize MfcDC::SetViewportExt (SIZE size)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_SetViewportExt(this, size);
} // MfcSize MfcDC::SetViewportExt (SIZE size);

MfcPoint MfcDC::GetWindowOrg () const
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_GetWindowOrg(this);
} // MfcPoint MfcDC::GetWindowOrg () const;

MfcPoint MfcDC::SetWindowOrg (int x, int y)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_SetWindowOrg(this, x, y);
} // MfcPoint MfcDC::SetWindowOrg (int x, int y);

MfcPoint MfcDC::SetWindowOrg (POINT point)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_SetWindowOrg(this, point);
} // MfcPoint MfcDC::SetWindowOrg (POINT point);

MfcPoint MfcDC::OffsetWindowOrg (int nWidth, int nHeight)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_OffsetWindowOrg(this, nWidth, nHeight);
} // MfcPoint MfcDC::OffsetWindowOrg (int nWidth, int nHeight);

MfcSize MfcDC::GetWindowExt () const
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_GetWindowExt(this);
} // MfcSize MfcDC::GetWindowExt () const;

MfcSize MfcDC::SetWindowExt (SIZE size)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_SetWindowExt(this, size);
} // MfcSize MfcDC::SetWindowExt (SIZE size);

void MfcDC::DPtoLP (LPPOINT lpPoints, int nCount) const
{
	FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_DPtoLP(this, lpPoints, nCount);
} // void MfcDC::DPtoLP (LPPOINT lpPoints, int nCount) const;

void MfcDC::DPtoLP (LPRECT lpRect) const
{
	FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_DPtoLP(this, lpRect);
} // void MfcDC::DPtoLP (LPRECT lpRect) const;

void MfcDC::DPtoLP (LPSIZE lpSize) const
{
	FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_DPtoLP(this, lpSize);
} // void MfcDC::DPtoLP (LPSIZE lpSize) const;

void MfcDC::LPtoDP (LPPOINT lpPoints, int nCount) const
{
	FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_LPtoDP(this, lpPoints, nCount);
} // void MfcDC::LPtoDP (LPPOINT lpPoints, int nCount) const;

void MfcDC::LPtoDP (LPRECT lpRect) const
{
	FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_LPtoDP(this, lpRect);
} // void MfcDC::LPtoDP (LPRECT lpRect) const;

void MfcDC::LPtoDP (LPSIZE lpSize) const
{
	FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_LPtoDP(this, lpSize);
} // void MfcDC::LPtoDP (LPSIZE lpSize) const;

void MfcDC::DPtoHIMETRIC (LPSIZE lpSize) const
{
	FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_DPtoHIMETRIC(this, lpSize);
} // void MfcDC::DPtoHIMETRIC (LPSIZE lpSize) const;

void MfcDC::LPtoHIMETRIC (LPSIZE lpSize) const
{
	FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_LPtoHIMETRIC(this, lpSize);
} // void MfcDC::LPtoHIMETRIC (LPSIZE lpSize) const;

void MfcDC::HIMETRICtoDP (LPSIZE lpSize) const
{
	FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_HIMETRICtoDP(this, lpSize);
} // void MfcDC::HIMETRICtoDP (LPSIZE lpSize) const;

void MfcDC::HIMETRICtoLP (LPSIZE lpSize) const
{
	FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_HIMETRICtoLP(this, lpSize);
} // void MfcDC::HIMETRICtoLP (LPSIZE lpSize) const;

BOOL MfcDC::FillRgn (MfcRgn* pRgn, MfcBrush* pBrush)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_FillRgn(this, pRgn, pBrush);
} // BOOL MfcDC::FillRgn (MfcRgn* pRgn, MfcBrush* pBrush);

BOOL MfcDC::FrameRgn (MfcRgn* pRgn, MfcBrush* pBrush, int nWidth, int nHeight)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_FrameRgn(this, pRgn, pBrush, nWidth, nHeight);
} // BOOL MfcDC::FrameRgn (MfcRgn* pRgn, MfcBrush* pBrush, int nWidth, int nHeight);

BOOL MfcDC::InvertRgn (MfcRgn* pRgn)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_InvertRgn(this, pRgn);
} // BOOL MfcDC::InvertRgn (MfcRgn* pRgn);

BOOL MfcDC::PaintRgn (MfcRgn* pRgn)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_PaintRgn(this, pRgn);
} // BOOL MfcDC::PaintRgn (MfcRgn* pRgn);

BOOL MfcDC::PtVisible (POINT point) const
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_PtVisible(this, point);
} // BOOL MfcDC::PtVisible (POINT point) const;

int MfcDC::SelectClipRgn (MfcRgn* pRgn)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_SelectClipRgn(this, pRgn);
} // int MfcDC::SelectClipRgn (MfcRgn* pRgn);

int MfcDC::ExcludeClipRect (int x1, int y1, int x2, int y2)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_ExcludeClipRect(this, x1, y1, x2, y2);
} // int MfcDC::ExcludeClipRect (int x1, int y1, int x2, int y2);

int MfcDC::ExcludeClipRect (LPCRECT lpRect)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_ExcludeClipRect(this, lpRect);
} // int MfcDC::ExcludeClipRect (LPCRECT lpRect);

int MfcDC::ExcludeUpdateRgn (MfcWnd* pWnd)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_ExcludeUpdateRgn(this, pWnd);
} // int MfcDC::ExcludeUpdateRgn (MfcWnd* pWnd);

int MfcDC::IntersectClipRect (int x1, int y1, int x2, int y2)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_IntersectClipRect(this, x1, y1, x2, y2);
} // int MfcDC::IntersectClipRect (int x1, int y1, int x2, int y2);

int MfcDC::IntersectClipRect (LPCRECT lpRect)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_IntersectClipRect(this, lpRect);
} // int MfcDC::IntersectClipRect (LPCRECT lpRect);

int MfcDC::OffsetClipRgn (int x, int y)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_OffsetClipRgn(this, x, y);
} // int MfcDC::OffsetClipRgn (int x, int y);

int MfcDC::OffsetClipRgn (SIZE size)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_OffsetClipRgn(this, size);
} // int MfcDC::OffsetClipRgn (SIZE size);

int MfcDC::SelectClipRgn (MfcRgn* pRgn, int nMode)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_SelectClipRgn(this, pRgn, nMode);
} // int MfcDC::SelectClipRgn (MfcRgn* pRgn, int nMode);

MfcPoint MfcDC::GetCurrentPosition () const
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_GetCurrentPosition(this);
} // MfcPoint MfcDC::GetCurrentPosition () const;

MfcPoint MfcDC::MoveTo (int x, int y)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_MoveTo(this, x, y);
} // MfcPoint MfcDC::MoveTo (int x, int y);

MfcPoint MfcDC::MoveTo (POINT point)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_MoveTo(this, point);
} // MfcPoint MfcDC::MoveTo (POINT point);

BOOL MfcDC::LineTo (int x, int y)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_LineTo(this, x, y);
} // BOOL MfcDC::LineTo (int x, int y);

BOOL MfcDC::LineTo (POINT point)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_LineTo(this, point);
} // BOOL MfcDC::LineTo (POINT point);

BOOL MfcDC::Arc (int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_Arc(this, x1, y1, x2, y2, x3, y3, x4, y4);
} // BOOL MfcDC::Arc (int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4);

BOOL MfcDC::Arc (LPCRECT lpRect, POINT ptStart, POINT ptEnd)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_Arc(this, lpRect, ptStart, ptEnd);
} // BOOL MfcDC::Arc (LPCRECT lpRect, POINT ptStart, POINT ptEnd);

BOOL MfcDC::Polyline (LPPOINT lpPoints, int nCount)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_Polyline(this, lpPoints, nCount);
} // BOOL MfcDC::Polyline (LPPOINT lpPoints, int nCount);

BOOL MfcDC::AngleArc (int x, int y, int nRadius, float fStartAngle, float fSweepAngle)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_AngleArc(this, x, y, nRadius, fStartAngle, fSweepAngle);
} // BOOL MfcDC::AngleArc (int x, int y, int nRadius, float fStartAngle, float fSweepAngle);

BOOL MfcDC::ArcTo (int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_ArcTo(this, x1, y1, x2, y2, x3, y3, x4, y4);
} // BOOL MfcDC::ArcTo (int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4);

BOOL MfcDC::ArcTo (LPCRECT lpRect, POINT ptStart, POINT ptEnd)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_ArcTo(this, lpRect, ptStart, ptEnd);
} // BOOL MfcDC::ArcTo (LPCRECT lpRect, POINT ptStart, POINT ptEnd);

int MfcDC::GetArcDirection () const
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_GetArcDirection(this);
} // int MfcDC::GetArcDirection () const;

int MfcDC::SetArcDirection (int nArcDirection)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_SetArcDirection(this, nArcDirection);
} // int MfcDC::SetArcDirection (int nArcDirection);

BOOL MfcDC::PolyDraw (const POINT* lpPoints, const BYTE* lpTypes, int nCount)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_PolyDraw(this, lpPoints, lpTypes, nCount);
} // BOOL MfcDC::PolyDraw (const POINT* lpPoints, const BYTE* lpTypes, int nCount);

BOOL MfcDC::PolylineTo (const POINT* lpPoints, int nCount)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_PolylineTo(this, lpPoints, nCount);
} // BOOL MfcDC::PolylineTo (const POINT* lpPoints, int nCount);

BOOL MfcDC::PolyPolyline (const POINT* lpPoints, const DWORD* lpPolyPoints, int nCount)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_PolyPolyline(this, lpPoints, lpPolyPoints, nCount);
} // BOOL MfcDC::PolyPolyline (const POINT* lpPoints, const DWORD* lpPolyPoints, int nCount);

BOOL MfcDC::PolyBezier (const POINT* lpPoints, int nCount)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_PolyBezier(this, lpPoints, nCount);
} // BOOL MfcDC::PolyBezier (const POINT* lpPoints, int nCount);

BOOL MfcDC::PolyBezierTo (const POINT* lpPoints, int nCount)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_PolyBezierTo(this, lpPoints, nCount);
} // BOOL MfcDC::PolyBezierTo (const POINT* lpPoints, int nCount);

void MfcDC::FillRect (LPCRECT lpRect, MfcBrush* pBrush)
{
	FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_FillRect(this, lpRect, pBrush);
} // void MfcDC::FillRect (LPCRECT lpRect, MfcBrush* pBrush);

void MfcDC::FrameRect (LPCRECT lpRect, MfcBrush* pBrush)
{
	FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_FrameRect(this, lpRect, pBrush);
} // void MfcDC::FrameRect (LPCRECT lpRect, MfcBrush* pBrush);

void MfcDC::InvertRect (LPCRECT lpRect)
{
	FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_InvertRect(this, lpRect);
} // void MfcDC::InvertRect (LPCRECT lpRect);

BOOL MfcDC::DrawIcon (int x, int y, HICON hIcon)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_DrawIcon(this, x, y, hIcon);
} // BOOL MfcDC::DrawIcon (int x, int y, HICON hIcon);

BOOL MfcDC::DrawIcon (POINT point, HICON hIcon)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_DrawIcon(this, point, hIcon);
} // BOOL MfcDC::DrawIcon (POINT point, HICON hIcon);

BOOL MfcDC::DrawState (MfcPoint pt, MfcSize size, HBITMAP hBitmap, UINT nFlags, HBRUSH hBrush)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_DrawState(this, pt, size, hBitmap, nFlags, hBrush);
} // BOOL MfcDC::DrawState (MfcPoint pt, MfcSize size, HBITMAP hBitmap, UINT nFlags, HBRUSH hBrush);

BOOL MfcDC::DrawState (MfcPoint pt, MfcSize size, MfcBitmap* pBitmap, UINT nFlags, MfcBrush* pBrush)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_DrawState(this, pt, size, pBitmap, nFlags, pBrush);
} // BOOL MfcDC::DrawState (MfcPoint pt, MfcSize size, MfcBitmap* pBitmap, UINT nFlags, MfcBrush* pBrush);

BOOL MfcDC::DrawState (MfcPoint pt, MfcSize size, HICON hIcon, UINT nFlags, HBRUSH hBrush)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_DrawState(this, pt, size, hIcon, nFlags, hBrush);
} // BOOL MfcDC::DrawState (MfcPoint pt, MfcSize size, HICON hIcon, UINT nFlags, HBRUSH hBrush);

BOOL MfcDC::DrawState (MfcPoint pt, MfcSize size, HICON hIcon, UINT nFlags, MfcBrush* pBrush)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_DrawState(this, pt, size, hIcon, nFlags, pBrush);
} // BOOL MfcDC::DrawState (MfcPoint pt, MfcSize size, HICON hIcon, UINT nFlags, MfcBrush* pBrush);

BOOL MfcDC::DrawState (MfcPoint pt, MfcSize size, LPCTSTR lpszText, UINT nFlags, BOOL bPrefixText, int nTextLen, HBRUSH hBrush)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_DrawState(this, pt, size, lpszText, nFlags, bPrefixText, nTextLen, hBrush);
} // BOOL MfcDC::DrawState (MfcPoint pt, MfcSize size, LPCTSTR lpszText, UINT nFlags, BOOL bPrefixText, int nTextLen, HBRUSH hBrush);

BOOL MfcDC::DrawState (MfcPoint pt, MfcSize size, LPCTSTR lpszText, UINT nFlags, BOOL bPrefixText, int nTextLen, MfcBrush* pBrush)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_DrawState(this, pt, size, lpszText, nFlags, bPrefixText, nTextLen, pBrush);
} // BOOL MfcDC::DrawState (MfcPoint pt, MfcSize size, LPCTSTR lpszText, UINT nFlags, BOOL bPrefixText, int nTextLen, MfcBrush* pBrush);

BOOL MfcDC::DrawState (MfcPoint pt, MfcSize size, DRAWSTATEPROC lpDrawProc, LPARAM lData, UINT nFlags, HBRUSH hBrush)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_DrawState(this, pt, size, lpDrawProc, lData, nFlags, hBrush);
} // BOOL MfcDC::DrawState (MfcPoint pt, MfcSize size, DRAWSTATEPROC lpDrawProc, LPARAM lData, UINT nFlags, HBRUSH hBrush);

BOOL MfcDC::DrawState (MfcPoint pt, MfcSize size, DRAWSTATEPROC lpDrawProc, LPARAM lData, UINT nFlags, MfcBrush* pBrush)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_DrawState(this, pt, size, lpDrawProc, lData, nFlags, pBrush);
} // BOOL MfcDC::DrawState (MfcPoint pt, MfcSize size, DRAWSTATEPROC lpDrawProc, LPARAM lData, UINT nFlags, MfcBrush* pBrush);

BOOL MfcDC::Chord (int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_Chord(this, x1, y1, x2, y2, x3, y3, x4, y4);
} // BOOL MfcDC::Chord (int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4);

BOOL MfcDC::Chord (LPCRECT lpRect, POINT ptStart, POINT ptEnd)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_Chord(this, lpRect, ptStart, ptEnd);
} // BOOL MfcDC::Chord (LPCRECT lpRect, POINT ptStart, POINT ptEnd);

void MfcDC::DrawFocusRect (LPCRECT lpRect)
{
	FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_DrawFocusRect(this, lpRect);
} // void MfcDC::DrawFocusRect (LPCRECT lpRect);

BOOL MfcDC::Ellipse (int x1, int y1, int x2, int y2)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_Ellipse(this, x1, y1, x2, y2);
} // BOOL MfcDC::Ellipse (int x1, int y1, int x2, int y2);

BOOL MfcDC::Ellipse (LPCRECT lpRect)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_Ellipse(this, lpRect);
} // BOOL MfcDC::Ellipse (LPCRECT lpRect);

BOOL MfcDC::Pie (int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_Pie(this, x1, y1, x2, y2, x3, y3, x4, y4);
} // BOOL MfcDC::Pie (int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4);

BOOL MfcDC::Pie (LPCRECT lpRect, POINT ptStart, POINT ptEnd)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_Pie(this, lpRect, ptStart, ptEnd);
} // BOOL MfcDC::Pie (LPCRECT lpRect, POINT ptStart, POINT ptEnd);

BOOL MfcDC::Polygon (LPPOINT lpPoints, int nCount)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_Polygon(this, lpPoints, nCount);
} // BOOL MfcDC::Polygon (LPPOINT lpPoints, int nCount);

BOOL MfcDC::PolyPolygon (LPPOINT lpPoints, LPINT lpPolyCounts, int nCount)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_PolyPolygon(this, lpPoints, lpPolyCounts, nCount);
} // BOOL MfcDC::PolyPolygon (LPPOINT lpPoints, LPINT lpPolyCounts, int nCount);

BOOL MfcDC::Rectangle (int x1, int y1, int x2, int y2)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_Rectangle(this, x1, y1, x2, y2);
} // BOOL MfcDC::Rectangle (int x1, int y1, int x2, int y2);

BOOL MfcDC::Rectangle (LPCRECT lpRect)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_Rectangle(this, lpRect);
} // BOOL MfcDC::Rectangle (LPCRECT lpRect);

BOOL MfcDC::RoundRect (int x1, int y1, int x2, int y2, int x3, int y3)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_RoundRect(this, x1, y1, x2, y2, x3, y3);
} // BOOL MfcDC::RoundRect (int x1, int y1, int x2, int y2, int x3, int y3);

BOOL MfcDC::RoundRect (LPCRECT lpRect, POINT point)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_RoundRect(this, lpRect, point);
} // BOOL MfcDC::RoundRect (LPCRECT lpRect, POINT point);

BOOL MfcDC::PatBlt (int x, int y, int nWidth, int nHeight, DWORD dwRop)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_PatBlt(this, x, y, nWidth, nHeight, dwRop);
} // BOOL MfcDC::PatBlt (int x, int y, int nWidth, int nHeight, DWORD dwRop);

BOOL MfcDC::BitBlt (int x, int y, int nWidth, int nHeight, MfcDC* pSrcDC, int xSrc, int ySrc, DWORD dwRop)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_BitBlt(this, x, y, nWidth, nHeight, pSrcDC, xSrc, ySrc, dwRop);
} // BOOL MfcDC::BitBlt (int x, int y, int nWidth, int nHeight, MfcDC* pSrcDC, int xSrc, int ySrc, DWORD dwRop);

BOOL MfcDC::StretchBlt (int x, int y, int nWidth, int nHeight, MfcDC* pSrcDC, int xSrc, int ySrc, int nSrcWidth, int nSrcHeight, DWORD dwRop)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_StretchBlt(this, x, y, nWidth, nHeight, pSrcDC, xSrc, ySrc, nSrcWidth, nSrcHeight, dwRop);
} // BOOL MfcDC::StretchBlt (int x, int y, int nWidth, int nHeight, MfcDC* pSrcDC, int xSrc, int ySrc, int nSrcWidth, int nSrcHeight, DWORD dwRop);

COLORREF MfcDC::GetPixel (int x, int y) const
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_GetPixel(this, x, y);
} // COLORREF MfcDC::GetPixel (int x, int y) const;

COLORREF MfcDC::GetPixel (POINT point) const
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_GetPixel(this, point);
} // COLORREF MfcDC::GetPixel (POINT point) const;

COLORREF MfcDC::SetPixel (int x, int y, COLORREF crColor)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_SetPixel(this, x, y, crColor);
} // COLORREF MfcDC::SetPixel (int x, int y, COLORREF crColor);

COLORREF MfcDC::SetPixel (POINT point, COLORREF crColor)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_SetPixel(this, point, crColor);
} // COLORREF MfcDC::SetPixel (POINT point, COLORREF crColor);

BOOL MfcDC::FloodFill (int x, int y, COLORREF crColor)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_FloodFill(this, x, y, crColor);
} // BOOL MfcDC::FloodFill (int x, int y, COLORREF crColor);

BOOL MfcDC::ExtFloodFill (int x, int y, COLORREF crColor, UINT nFillType)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_ExtFloodFill(this, x, y, crColor, nFillType);
} // BOOL MfcDC::ExtFloodFill (int x, int y, COLORREF crColor, UINT nFillType);

BOOL MfcDC::MaskBlt (int x, int y, int nWidth, int nHeight, MfcDC* pSrcDC, int xSrc, int ySrc, MfcBitmap& maskBitmap, int xMask, int yMask, DWORD dwRop)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_MaskBlt(this, x, y, nWidth, nHeight, pSrcDC, xSrc, ySrc, maskBitmap, xMask, yMask, dwRop);
} // BOOL MfcDC::MaskBlt (int x, int y, int nWidth, int nHeight, MfcDC* pSrcDC, int xSrc, int ySrc, MfcBitmap& maskBitmap, int xMask, int yMask, DWORD dwRop);

BOOL MfcDC::PlgBlt (LPPOINT lpPoint, MfcDC* pSrcDC, int xSrc, int ySrc, int nWidth, int nHeight, MfcBitmap& maskBitmap, int xMask, int yMask)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_PlgBlt(this, lpPoint, pSrcDC, xSrc, ySrc, nWidth, nHeight, maskBitmap, xMask, yMask);
} // BOOL MfcDC::PlgBlt (LPPOINT lpPoint, MfcDC* pSrcDC, int xSrc, int ySrc, int nWidth, int nHeight, MfcBitmap& maskBitmap, int xMask, int yMask);

BOOL MfcDC::SetPixelV (int x, int y, COLORREF crColor)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_SetPixelV(this, x, y, crColor);
} // BOOL MfcDC::SetPixelV (int x, int y, COLORREF crColor);

BOOL MfcDC::SetPixelV (POINT point, COLORREF crColor)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_SetPixelV(this, point, crColor);
} // BOOL MfcDC::SetPixelV (POINT point, COLORREF crColor);

BOOL MfcDC::TextOut (int x, int y, const MfcString& str)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_TextOut(this, x, y, str);
} // BOOL MfcDC::TextOut (int x, int y, const MfcString& str);

BOOL MfcDC::ExtTextOut (int x, int y, UINT nOptions, LPCRECT lpRect, const MfcString& str, LPINT lpDxWidths)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_ExtTextOut(this, x, y, nOptions, lpRect, str, lpDxWidths);
} // BOOL MfcDC::ExtTextOut (int x, int y, UINT nOptions, LPCRECT lpRect, const MfcString& str, LPINT lpDxWidths);

MfcSize MfcDC::TabbedTextOut (int x, int y, const MfcString& str, int nTabPositions, LPINT lpnTabStopPositions, int nTabOrigin)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_TabbedTextOut(this, x, y, str, nTabPositions, lpnTabStopPositions, nTabOrigin);
} // MfcSize MfcDC::TabbedTextOut (int x, int y, const MfcString& str, int nTabPositions, LPINT lpnTabStopPositions, int nTabOrigin);

int MfcDC::DrawText (const MfcString& str, LPRECT lpRect, UINT nFormat)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_DrawText(this, str, lpRect, nFormat);
} // int MfcDC::DrawText (const MfcString& str, LPRECT lpRect, UINT nFormat);

MfcSize MfcDC::GetTextExtent (LPCTSTR lpszString, int nCount) const
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_GetTextExtent(this, lpszString, nCount);
} // MfcSize MfcDC::GetTextExtent (LPCTSTR lpszString, int nCount) const;

MfcSize MfcDC::GetTextExtent (const MfcString& str) const
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_GetTextExtent(this, str);
} // MfcSize MfcDC::GetTextExtent (const MfcString& str) const;

MfcSize MfcDC::GetOutputTextExtent (LPCTSTR lpszString, int nCount) const
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_GetOutputTextExtent(this, lpszString, nCount);
} // MfcSize MfcDC::GetOutputTextExtent (LPCTSTR lpszString, int nCount) const;

MfcSize MfcDC::GetOutputTextExtent (const MfcString& str) const
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_GetOutputTextExtent(this, str);
} // MfcSize MfcDC::GetOutputTextExtent (const MfcString& str) const;

MfcSize MfcDC::GetTabbedTextExtent (LPCTSTR lpszString, int nCount, int nTabPositions, LPINT lpnTabStopPositions) const
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_GetTabbedTextExtent(this, lpszString, nCount, nTabPositions, lpnTabStopPositions);
} // MfcSize MfcDC::GetTabbedTextExtent (LPCTSTR lpszString, int nCount, int nTabPositions, LPINT lpnTabStopPositions) const;

MfcSize MfcDC::GetTabbedTextExtent (const MfcString& str, int nTabPositions, LPINT lpnTabStopPositions) const
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_GetTabbedTextExtent(this, str, nTabPositions, lpnTabStopPositions);
} // MfcSize MfcDC::GetTabbedTextExtent (const MfcString& str, int nTabPositions, LPINT lpnTabStopPositions) const;

MfcSize MfcDC::GetOutputTabbedTextExtent (LPCTSTR lpszString, int nCount, int nTabPositions, LPINT lpnTabStopPositions) const
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_GetOutputTabbedTextExtent(this, lpszString, nCount, nTabPositions, lpnTabStopPositions);
} // MfcSize MfcDC::GetOutputTabbedTextExtent (LPCTSTR lpszString, int nCount, int nTabPositions, LPINT lpnTabStopPositions) const;

MfcSize MfcDC::GetOutputTabbedTextExtent (const MfcString& str, int nTabPositions, LPINT lpnTabStopPositions) const
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_GetOutputTabbedTextExtent(this, str, nTabPositions, lpnTabStopPositions);
} // MfcSize MfcDC::GetOutputTabbedTextExtent (const MfcString& str, int nTabPositions, LPINT lpnTabStopPositions) const;

UINT MfcDC::GetTextAlign () const
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_GetTextAlign(this);
} // UINT MfcDC::GetTextAlign () const;

UINT MfcDC::SetTextAlign (UINT nFlags)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_SetTextAlign(this, nFlags);
} // UINT MfcDC::SetTextAlign (UINT nFlags);

int MfcDC::GetTextFace (int nCount, LPTSTR lpszFacename) const
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_GetTextFace(this, nCount, lpszFacename);
} // int MfcDC::GetTextFace (int nCount, LPTSTR lpszFacename) const;

int MfcDC::GetTextFace (MfcString& rString) const
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_GetTextFace(this, rString);
} // int MfcDC::GetTextFace (MfcString& rString) const;

BOOL MfcDC::GetTextMetrics (LPTEXTMETRIC lpMetrics) const
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_GetTextMetrics(this, lpMetrics);
} // BOOL MfcDC::GetTextMetrics (LPTEXTMETRIC lpMetrics) const;

BOOL MfcDC::GetOutputTextMetrics (LPTEXTMETRIC lpMetrics) const
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_GetOutputTextMetrics(this, lpMetrics);
} // BOOL MfcDC::GetOutputTextMetrics (LPTEXTMETRIC lpMetrics) const;

int MfcDC::SetTextJustification (int nBreakExtra, int nBreakCount)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_SetTextJustification(this, nBreakExtra, nBreakCount);
} // int MfcDC::SetTextJustification (int nBreakExtra, int nBreakCount);

int MfcDC::GetTextCharacterExtra () const
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_GetTextCharacterExtra(this);
} // int MfcDC::GetTextCharacterExtra () const;

int MfcDC::SetTextCharacterExtra (int nCharExtra)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_SetTextCharacterExtra(this, nCharExtra);
} // int MfcDC::SetTextCharacterExtra (int nCharExtra);

BOOL MfcDC::DrawEdge (LPRECT lpRect, UINT nEdge, UINT nFlags)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_DrawEdge(this, lpRect, nEdge, nFlags);
} // BOOL MfcDC::DrawEdge (LPRECT lpRect, UINT nEdge, UINT nFlags);

BOOL MfcDC::DrawFrameControl (LPRECT lpRect, UINT nType, UINT nState)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_DrawFrameControl(this, lpRect, nType, nState);
} // BOOL MfcDC::DrawFrameControl (LPRECT lpRect, UINT nType, UINT nState);

BOOL MfcDC::ScrollDC (int dx, int dy, LPCRECT lpRectScroll, LPCRECT lpRectClip, MfcRgn* pRgnUpdate, LPRECT lpRectUpdate)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_ScrollDC(this, dx, dy, lpRectScroll, lpRectClip, pRgnUpdate, lpRectUpdate);
} // BOOL MfcDC::ScrollDC (int dx, int dy, LPCRECT lpRectScroll, LPCRECT lpRectClip, MfcRgn* pRgnUpdate, LPRECT lpRectUpdate);

BOOL MfcDC::GetCharWidth (UINT nFirstChar, UINT nLastChar, LPINT lpBuffer) const
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_GetCharWidth(this, nFirstChar, nLastChar, lpBuffer);
} // BOOL MfcDC::GetCharWidth (UINT nFirstChar, UINT nLastChar, LPINT lpBuffer) const;

BOOL MfcDC::GetOutputCharWidth (UINT nFirstChar, UINT nLastChar, LPINT lpBuffer) const
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_GetOutputCharWidth(this, nFirstChar, nLastChar, lpBuffer);
} // BOOL MfcDC::GetOutputCharWidth (UINT nFirstChar, UINT nLastChar, LPINT lpBuffer) const;

DWORD MfcDC::SetMapperFlags (DWORD dwFlag)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_SetMapperFlags(this, dwFlag);
} // DWORD MfcDC::SetMapperFlags (DWORD dwFlag);

MfcSize MfcDC::GetAspectRatioFilter () const
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_GetAspectRatioFilter(this);
} // MfcSize MfcDC::GetAspectRatioFilter () const;

BOOL MfcDC::GetCharABCWidths (UINT nFirstChar, UINT nLastChar, LPABC lpabc) const
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_GetCharABCWidths(this, nFirstChar, nLastChar, lpabc);
} // BOOL MfcDC::GetCharABCWidths (UINT nFirstChar, UINT nLastChar, LPABC lpabc) const;

DWORD MfcDC::GetFontData (DWORD dwTable, DWORD dwOffset, LPVOID lpData, DWORD cbData) const
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_GetFontData(this, dwTable, dwOffset, lpData, cbData);
} // DWORD MfcDC::GetFontData (DWORD dwTable, DWORD dwOffset, LPVOID lpData, DWORD cbData) const;

int MfcDC::GetKerningPairs (int nPairs, LPKERNINGPAIR lpkrnpair) const
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_GetKerningPairs(this, nPairs, lpkrnpair);
} // int MfcDC::GetKerningPairs (int nPairs, LPKERNINGPAIR lpkrnpair) const;

UINT MfcDC::GetOutlineTextMetrics (UINT cbData, LPOUTLINETEXTMETRIC lpotm) const
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_GetOutlineTextMetrics(this, cbData, lpotm);
} // UINT MfcDC::GetOutlineTextMetrics (UINT cbData, LPOUTLINETEXTMETRIC lpotm) const;

DWORD MfcDC::GetGlyphOutline (UINT nChar, UINT nFormat, LPGLYPHMETRICS lpgm, DWORD cbBuffer, LPVOID lpBuffer, const MAT2* lpmat2) const
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_GetGlyphOutline(this, nChar, nFormat, lpgm, cbBuffer, lpBuffer, lpmat2);
} // DWORD MfcDC::GetGlyphOutline (UINT nChar, UINT nFormat, LPGLYPHMETRICS lpgm, DWORD cbBuffer, LPVOID lpBuffer, const MAT2* lpmat2) const;

BOOL MfcDC::GetCharABCWidths (UINT nFirstChar, UINT nLastChar, LPABCFLOAT lpABCF) const
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_GetCharABCWidths(this, nFirstChar, nLastChar, lpABCF);
} // BOOL MfcDC::GetCharABCWidths (UINT nFirstChar, UINT nLastChar, LPABCFLOAT lpABCF) const;

BOOL MfcDC::GetCharWidth (UINT nFirstChar, UINT nLastChar, float* lpFloatBuffer) const
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_GetCharWidth(this, nFirstChar, nLastChar, lpFloatBuffer);
} // BOOL MfcDC::GetCharWidth (UINT nFirstChar, UINT nLastChar, float* lpFloatBuffer) const;

int MfcDC::Escape (int nEscape, int nInputSize, LPCSTR lpszInputData, int nOutputSize, LPSTR lpszOutputData)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_Escape(this, nEscape, nInputSize, lpszInputData, nOutputSize, lpszOutputData);
} // int MfcDC::Escape (int nEscape, int nInputSize, LPCSTR lpszInputData, int nOutputSize, LPSTR lpszOutputData);

int MfcDC::DrawEscape (int nEscape, int nInputSize, LPCSTR lpszInputData)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_DrawEscape(this, nEscape, nInputSize, lpszInputData);
} // int MfcDC::DrawEscape (int nEscape, int nInputSize, LPCSTR lpszInputData);

int MfcDC::StartDoc (LPCTSTR lpszDocName)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_StartDoc(this, lpszDocName);
} // int MfcDC::StartDoc (LPCTSTR lpszDocName);

int MfcDC::StartDoc (LPDOCINFO lpDocInfo)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_StartDoc(this, lpDocInfo);
} // int MfcDC::StartDoc (LPDOCINFO lpDocInfo);

int MfcDC::StartPage ()
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_StartPage(this);
} // int MfcDC::StartPage ();

int MfcDC::EndPage ()
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_EndPage(this);
} // int MfcDC::EndPage ();

int MfcDC::SetAbortProc (BOOL (CALLBACK* lpfn)(HDC, int))
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_SetAbortProc(this, lpfn);
} // int MfcDC::SetAbortProc (BOOL (CALLBACK* lpfn)(HDC, int));

int MfcDC::AbortDoc ()
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_AbortDoc(this);
} // int MfcDC::AbortDoc ();

int MfcDC::EndDoc ()
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_EndDoc(this);
} // int MfcDC::EndDoc ();

BOOL MfcDC::PlayMetaFile (HMETAFILE hMF)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_PlayMetaFile(this, hMF);
} // BOOL MfcDC::PlayMetaFile (HMETAFILE hMF);

BOOL MfcDC::PlayMetaFile (HENHMETAFILE hEnhMetaFile, LPCRECT lpBounds)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_PlayMetaFile(this, hEnhMetaFile, lpBounds);
} // BOOL MfcDC::PlayMetaFile (HENHMETAFILE hEnhMetaFile, LPCRECT lpBounds);

BOOL MfcDC::AddMetaFileComment (UINT nDataSize, const BYTE* pCommentData)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_AddMetaFileComment(this, nDataSize, pCommentData);
} // BOOL MfcDC::AddMetaFileComment (UINT nDataSize, const BYTE* pCommentData);

BOOL MfcDC::AbortPath ()
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_AbortPath(this);
} // BOOL MfcDC::AbortPath ();

BOOL MfcDC::BeginPath ()
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_BeginPath(this);
} // BOOL MfcDC::BeginPath ();

BOOL MfcDC::CloseFigure ()
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_CloseFigure(this);
} // BOOL MfcDC::CloseFigure ();

BOOL MfcDC::EndPath ()
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_EndPath(this);
} // BOOL MfcDC::EndPath ();

BOOL MfcDC::FillPath ()
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_FillPath(this);
} // BOOL MfcDC::FillPath ();

BOOL MfcDC::FlattenPath ()
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_FlattenPath(this);
} // BOOL MfcDC::FlattenPath ();

BOOL MfcDC::StrokeAndFillPath ()
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_StrokeAndFillPath(this);
} // BOOL MfcDC::StrokeAndFillPath ();

BOOL MfcDC::StrokePath ()
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_StrokePath(this);
} // BOOL MfcDC::StrokePath ();

BOOL MfcDC::WidenPath ()
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_WidenPath(this);
} // BOOL MfcDC::WidenPath ();

float MfcDC::GetMiterLimit () const
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_GetMiterLimit(this);
} // float MfcDC::GetMiterLimit () const;

BOOL MfcDC::SetMiterLimit (float fMiterLimit)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_SetMiterLimit(this, fMiterLimit);
} // BOOL MfcDC::SetMiterLimit (float fMiterLimit);

int MfcDC::GetPath (LPPOINT lpPoints, LPBYTE lpTypes, int nCount) const
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_GetPath(this, lpPoints, lpTypes, nCount);
} // int MfcDC::GetPath (LPPOINT lpPoints, LPBYTE lpTypes, int nCount) const;

BOOL MfcDC::SelectClipPath (int nMode)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_SelectClipPath(this, nMode);
} // BOOL MfcDC::SelectClipPath (int nMode);

MfcBrush* MfcDC::GetHalftoneBrush ()
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_GetHalftoneBrush();
} // MfcBrush* MfcDC::GetHalftoneBrush ();

void MfcDC::DrawDragRect (LPCRECT lpRect, SIZE size, LPCRECT lpRectLast, SIZE sizeLast, MfcBrush* pBrush, MfcBrush* pBrushLast)
{
	FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_DrawDragRect(this, lpRect, size, lpRectLast, sizeLast, pBrush, pBrushLast);
} // void MfcDC::DrawDragRect (LPCRECT lpRect, SIZE size, LPCRECT lpRectLast, SIZE sizeLast, MfcBrush* pBrush, MfcBrush* pBrushLast);

void MfcDC::FillSolidRect (LPCRECT lpRect, COLORREF clr)
{
	FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_FillSolidRect(this, lpRect, clr);
} // void MfcDC::FillSolidRect (LPCRECT lpRect, COLORREF clr);

void MfcDC::FillSolidRect (int x, int y, int cx, int cy, COLORREF clr)
{
	FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_FillSolidRect(this, x, y, cx, cy, clr);
} // void MfcDC::FillSolidRect (int x, int y, int cx, int cy, COLORREF clr);

void MfcDC::Draw3dRect (LPCRECT lpRect, COLORREF clrTopLeft, COLORREF clrBottomRight)
{
	FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_Draw3dRect(this, lpRect, clrTopLeft, clrBottomRight);
} // void MfcDC::Draw3dRect (LPCRECT lpRect, COLORREF clrTopLeft, COLORREF clrBottomRight);

void MfcDC::Draw3dRect (int x, int y, int cx, int cy, COLORREF clrTopLeft, COLORREF clrBottomRight)
{
	FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcDCI()->_Draw3dRect(this, x, y, cx, cy, clrTopLeft, clrBottomRight);
} // void MfcDC::Draw3dRect (int x, int y, int cx, int cy, COLORREF clrTopLeft, COLORREF clrBottomRight);

#endif//__CDC_cpp

