#ifndef __CDocument_h
#define __CDocument_h

class MfcDocument : public MfcCmdTarget
{
	virtual MfcRuntimeClass* GetRuntimeClass() const;

public:
// Constructors

// Attributes
public:
	virtual void SetTitle(LPCTSTR lpszTitle);
	virtual void SetPathName(LPCTSTR lpszPathName, BOOL bAddToMRU = TRUE);

	virtual BOOL IsModified();
	virtual void SetModifiedFlag(BOOL bModified = TRUE);

// Operations
	virtual MFC_POSITION GetFirstViewPosition() const;
	virtual MfcView* GetNextView(MFC_POSITION& rPosition) const;

	// Update Views (simple update - DAG only)

// Overridables
	// Special notifications
	virtual void OnChangedViewList(); // after Add or Remove view
	virtual void DeleteContents(); // delete doc items etc

	// File helpers
	virtual BOOL OnNewDocument();
	virtual BOOL OnOpenDocument(LPCTSTR lpszPathName);
	virtual BOOL OnSaveDocument(LPCTSTR lpszPathName);
	virtual void OnCloseDocument();
	virtual void ReportSaveLoadException(LPCTSTR lpszPathName,
				MfcException* e, BOOL bSaving, UINT nIDPDefault);
	virtual MfcFile* GetFile(LPCTSTR lpszFileName, UINT nOpenFlags,
		MfcFileException* pError);
	virtual void ReleaseFile(MfcFile* pFile, BOOL bAbort);

	// advanced overridables, closing down frame/doc, etc.
	virtual BOOL CanCloseFrame(MfcFrameWnd* pFrame);
	virtual BOOL SaveModified(); // return TRUE if ok to continue
	virtual void PreCloseFrame(MfcFrameWnd* pFrame);

// Implementation
protected:
	// default implementation

#ifdef _DEBUG
	virtual void Dump(MfcDumpContext&) const;
	virtual void AssertValid() const;
#endif //_DEBUG
	virtual ~MfcDocument();

	// implementation helpers
	virtual BOOL DoSave(LPCTSTR lpszPathName, BOOL bReplace = TRUE);
	virtual BOOL DoFileSave();
	virtual void UpdateFrameCounts();

	// overridables for implementation
	virtual HMENU GetDefaultMenu(); // get menu depending on state
	virtual HACCEL GetDefaultAccelerator();
	virtual void OnIdle();
	virtual void OnFinalRelease();

	virtual BOOL OnCmdMsg(UINT nID, int nCode, void* pExtra,
		AFX_MFC_CMDHANDLERINFO* pHandlerInfo);
	friend class CDocTemplate;

protected:
	// file menu commands
	virtual const AFX_MFC_MSGMAP* GetMessageMap() const;
};

#endif//__CDocument_h
