#ifndef __CFont_h
#define __CFont_h

class MfcFont : public MfcGdiObject
{
public:
	static MfcFont* New ();
	static void Delete (MfcFont* pFont);
	static MfcFont* FromHandle (HFONT hFont);
	BOOL CreateFontIndirect (const LOGFONT* lpLogFont);
	BOOL CreateFont (int nHeight, int nWidth, int nEscapement, int nOrientation, int nWeight, BYTE bItalic, BYTE bUnderline, BYTE cStrikeOut, BYTE nCharSet, BYTE nOutPrecision, BYTE nClipPrecision, BYTE nQuality, BYTE nPitchAndFamily, LPCTSTR lpszFacename);
	BOOL CreatePointFont (int nPointSize, LPCTSTR lpszFaceName, MfcDC* pDC = NULL);
	BOOL CreatePointFontIndirect (const LOGFONT* lpLogFont, MfcDC* pDC = NULL);
	operator HFONT () const;
	int GetLogFont (LOGFONT* pLogFont);

	virtual MfcRuntimeClass* GetRuntimeClass() const;
	virtual ~MfcFont();
#ifdef _DEBUG
	virtual void Dump(MfcDumpContext& dc) const;
#endif
};

#endif//__CFont_h
