#ifndef __CFrameWnd_h
#define __CFrameWnd_h

// Frame window styles
#define FWS_ADDTOTITLE  0x00008000L // modify title based on content
#define FWS_PREFIXTITLE 0x00004000L // show document name before app name
#define FWS_SNAPTOBARS  0x00002000L // snap size to size of contained bars

class MfcFrameWnd : public MfcWnd
{
// Constructors
public:
	virtual BOOL LoadFrame(UINT nIDResource,
				DWORD dwDefaultStyle = WS_OVERLAPPEDWINDOW | FWS_ADDTOTITLE,
				MfcWnd* pParentWnd = NULL,
				MfcCreateContext* pContext = NULL);

// Attributes
	virtual MfcDocument* GetActiveDocument();

	// Active frame (for frames within frames -- MDI)
	virtual MfcFrameWnd* GetActiveFrame();

	// For customizing the default messages on the status bar
	virtual void GetMessageString(UINT nID, MfcString& rMessage) const;

// Operations
	virtual void RecalcLayout(BOOL bNotify = TRUE);
	virtual void ActivateFrame(int nCmdShow = -1);

	// frame window based modality
	virtual void BeginModalState();
	virtual void EndModalState();

// Overridables
	virtual void OnSetPreviewMode(BOOL bPreview, MfcPrintPreviewState* pState);
	virtual MfcWnd* GetMessageBar();

	// border space negotiation
	enum BorderCmd
		{ borderGet = 1, borderRequest = 2, borderSet = 3 };
	virtual BOOL NegotiateBorderSpace(UINT nBorderCmd, LPRECT lpRectBorder);

protected:
	virtual BOOL OnCreateClient(LPCREATESTRUCT lpcs, MfcCreateContext* pContext);

// Implementation
public:
	virtual ~MfcFrameWnd();

public:
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(MfcDumpContext& dc) const;
#endif
	virtual BOOL IsFrameWnd() const;
	virtual BOOL OnCmdMsg(UINT nID, int nCode, void* pExtra,
		AFX_MFC_CMDHANDLERINFO* pHandlerInfo);
	virtual void OnUpdateFrameTitle(BOOL bAddToTitle);
	virtual void OnUpdateFrameMenu(HMENU hMenuAlt);
	virtual HACCEL GetDefaultAccelerator();
	virtual BOOL PreTranslateMessage(MSG* pMsg);

	virtual void DelayUpdateFrameMenu(HMENU hMenuAlt);
	virtual void ExitHelpMode();

protected:
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	virtual BOOL OnCommand(WPARAM wParam, LPARAM lParam);
	virtual void PostNcDestroy();   // default to delete this.
};

#endif//__CFrameWnd_h
