#ifndef __MpgInterface_h
#define __MpgInterface_h

// To use IID_IMpgPlugInInfo.
PG_USE_PLUGIN_INTERFACE

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	IMpgInterface
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhGiDiJiDePiDeDiDjDiCmMiKoOjGhLiCmMiDeDiDjDiDfOiDhEiDeGiBfLiDfIiCpAiLeLjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.05.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
class IMpgInterface : public IMpgPlugInInfo, public IMpgPlugInMain, public IMpgPlugInFileConv
{
public:
	//////////////////////////////////////////////////////////////////////////////
	// IUnknown.

	/*************************************************************************
	 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	QueryInterface
	 *
	 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDeDiDjDiDfOiDhEiDeGiBfLiDfIiCpAiNoMjAkMiClFiCmEjFnEiClHiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	iid	:_xZkqqHx_iDeDiDjDiDfOiDhEiDeGiBfLiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
	 *			ppv	:_xZkqqHx_iDeDiDjDiDfOiDhEiDeGiBfLiDfIiCpAiOpDiCkPiOoGiCoJjFmPjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeDiDjDiDfOiDhEiDeGiBfLiDfIiCkKiMkJiCmCiCkJiCmBiClNiPoKiNiHiCmN_xHqqkZx_ S_OK_xZkqqHx_iBeBiMkJiCmCiCkJiCoHiCmIiCkCiPoKiNiHiCmN_xHqqkZx_
	 *			E_NOINTERFACE_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.09.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
	 *************************************************************************/
	virtual HRESULT __stdcall QueryInterface (const IID& iid, void** ppv)
	{
		if (iid == IID_IUnknown)
		{
			*ppv = static_cast<IMpgPlugInInfo*>(this);
		} else
		if (iid == IID_IMpgPlugInInfo)
		{
			*ppv = static_cast<IMpgPlugInInfo*>(this);
		} else
		if (iid == IID_IMpgPlugInMain)
		{
			*ppv = static_cast<IMpgPlugInMain*>(this);
		} else
		if (iid == IID_IMpgPlugInFileConv)
		{
			*ppv = static_cast<IMpgPlugInFileConv*>(this);
		} else
		{
			*ppv = NULL;
			return E_NOINTERFACE;
		}
		reinterpret_cast<IUnknown*>(*ppv)->AddRef();
		return S_OK;
	} // QueryInterface.

	/*************************************************************************
	 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	AddRef
	 *
	 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeDiDjDiDfOiDhEiDeGiBfLiDfIiCmMiOfBiPmGiDeKiDeFiDjDiDfOiCpAiCfAiJmBiOfKiClHiCoJiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iOfBiPmGjAjEiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.09.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
	 *************************************************************************/
	virtual ULONG __stdcall AddRef ()
	{
	  	return ::InterlockedIncrement(&m_cRef);
	} // AddRef.

	/*************************************************************************
	 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	Release
	 *
	 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeDiDjDiDfOiDhEiDeGiBfLiDfIiCmMiOfBiPmGiDeKiDeFiDjDiDfOiCpAiCfAiMlIiOfKiClHiCoJiBeCiOfBiPmGjAjEiCkKiCePiCmJiCmIiCmBiClNiCoH_xHqqkZx_
	 *			_xZkqqHx_iDeDiDjDiDfOiDhEiDeGiBfLiDfIiOkJjAgHiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iOfBiPmGjAjEiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.09.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
	 *************************************************************************/
	virtual ULONG __stdcall Release ()
	{
		if (::InterlockedDecrement(&m_cRef) == 0)
		{
			delete this;
			return 0;
		}
		return m_cRef;
	} // Release.

//----- 06.03.18 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	//////////////////////////////////////////////////////////////////////////////
//	// Interface IMpgPlugInInfo.
//
//	/*************************************************************************
//	 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	GetDynamicDrawAppmode
//	 *
//	 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDfCiDjDiDhMiBfLiDgMiDjDiDgHiCkKjBmOiJjOiClHiCoJ_xHqqkZx_DynamicDraw_xZkqqHx_iCmMiDeBiDhGiDiKiDfAiBfLiDfGiDiHiDjDiDiCiBfLiDgI_xHqqkZx_
//	 *			_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
//	 *
//	 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iImIiJlKiCmMjCgMiCpA_xHqqkZx_|_xZkqqHx_iCmFjBgHiCnNiNiHiCoNiClJiClNjCgMiCpAjFnEiClHiBeC_xHqqkZx_
//	 *			FD_APPMODE_DYNAMICDRAW		:DynamicDrawDraw_xZkqqHx_iDiCiBfLiDgIiBeC_xHqqkZx_
//	 *			FD_APPMODE_CHIPEDITOR		:_xZkqqHx_iDgAiDgCiDhGiDeHiDgGiDeCiDfOiDiCiBfLiDgIiBeC_xHqqkZx_
//	 *			FD_APPMODE_ARROWEDITOR		:_xZkqqHx_iDeBiDiNiBfLiDeHiDgGiDeCiDfOiDiCiBfLiDgIiBeC_xHqqkZx_
//	 *			FD_APPMODE_HISTORYVIEWER	:_xZkqqHx_jHjKjHpAiDhCiDiFiBfLiDeBiDiCiBfLiDgIiBeC_xHqqkZx_
//	 *			FD_APPMODE_HISTORICDRAW		:HistoricDraw_xZkqqHx_iDiCiBfLiDgIiBeC_xHqqkZx_
//	 *
//	 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.05.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
//	 *************************************************************************/
//	virtual WORD GetDynamicDrawAppmode () const
//	{
//		// _xZkqqHx_iDgGiDhEiDeIiDiLiDgHiCmN_xHqqkZx_DynamicDrawDraw_xZkqqHx_iCmFiCmMiCnNjDkOiNoMiBeC_xHqqkZx_
//		return FD_APPMODE_DYNAMICDRAW;
//	} // GetDynamicDrawAppmode.
//
//	/*************************************************************************
//	 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	GetDynamicDrawVersion
//	 *
//	 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDfCiDjDiDhMiBfLiDgMiDjDiDgHiCkKjBmOiJjOiClHiCoJ_xHqqkZx_DynamicDraw_xZkqqHx_iCmMiDgPiBfLiDfHiDiHiDjDiCpAjFnEiClHiBeC_xHqqkZx_
//	 *
//	 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
//	 *************************************************************************/
//	virtual WORD GetDynamicDrawVersion () const
//	{
//		union FCAppVersion
//		{
//			WORD	wVersion;	// _xZkqqHx_iDeBiDhGiDiKiDgPiBfLiDfHiDiHiDjDiBeC_xHqqkZx_
//			struct {
//				WORD	wLevelB	: 2;	// _xZkqqHx_iDiMiDhIiDiLiCgBiBeC_xHqqkZx_
//				WORD	wLevelA	: 4;	// _xZkqqHx_iDiMiDhIiDiLiCgAiBeC_xHqqkZx_
//				WORD	wMinor	: 5;	// _xZkqqHx_iDhNiDeDiDgJiBfLiDgPiBfLiDfHiDiHiDjDiBeC_xHqqkZx_
//				WORD	wMajor	: 5;	// _xZkqqHx_iDiBiDfHiDiDiBfLiDgPiBfLiDfHiDiHiDjDiBeC_xHqqkZx_
//			};
//		} ver;
//// 05.05.12 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
////		ver.wMajor = 3;
//		ver.wMajor = 4;
//		ver.wMinor = 0;
//		ver.wLevelA = 0;
//		ver.wLevelB = 0;
//		return ver.wVersion;
//	} // GetDynamicDrawVersion.
//----- 06.03.18 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	//////////////////////////////////////////////////////////////////////////////
	// Interface IMpgPlugInInfo.

	/*************************************************************************
	 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	GetAuthorName
	 *
	 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDhMiBfLiDgMiDjDiDgHiCmMiNoMiOnCjGlMiCpAjFnEiClHiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDhMiBfLiDgMiDjDiDgHiCmMiNoMiOnCjGlMiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.05.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
	 *************************************************************************/
	virtual const wchar_t* GetAuthorName () const
	{
		return L"";
	} // GetAuthorName.

	/*************************************************************************
	 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	GetComponentName
	 *
	 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiCiDfHiDiFiBfLiDiLjGlMiCpAjFnEiClHiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiCiDfHiDiFiBfLiDiLjGlMjFlGiOjKjHpBiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDiCiDfHiDiFiBfLiDiLjGlMiCmNiBeBiDiBiDgKiDiFiBfLiCmMiDfEiDhFiDiBiDgKiDiFiBfLjGlMiCmIiCmHiCmFiOgHiCoNiCoKiCoJiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iMlOiMoKiDfCiBfLiDgIiCmJjCiNiInDiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.05.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
	 *************************************************************************/
	virtual const wchar_t* GetComponentName () const
	{
		return L"";
	} // GetComponentName.

	/*************************************************************************
	 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	GetVersionName
	 *
	 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgPiBfLiDfHiDiHiDjDjGlMiCpAjFnEiClHiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDgPiBfLiDfHiDiHiDjDjGlMjFlGiOjKjHpBiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.05.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
	 *************************************************************************/
	virtual const wchar_t* GetVersionName () const
	{
		return L"";
	} // GetVersionName.

	/*************************************************************************
	 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	GetComment
	 *
	 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDfCiDjDiDhMiBfLiDgFiDjDiDgHiCmMiJpAjAoAiDfCiDiBiDjDiDgHiCpAjFnEiClHiBeCjGlDiCkCiPoKiNiHiCmN_xHqqkZx_ NULL_xZkqqHx_iBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFlGiOjKjHpBiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.05.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
	 *************************************************************************/
	virtual const wchar_t* GetComment () const
	{
		return L"";
	} // GetComment.

	/*************************************************************************
	 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	GetComponentShortcut
	 *
	 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiCiDfHiDiFiBfLiDiLiCpAiDiBiDgKiDiFiBfLiCmJjDgPjIfOiClHiCoJiCmGiCkLiCmMiDeBiDeOiDfKiDfIiDeMiBfLiCpAjFnEiClHiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeMiBfLiDfCiBfLiDgIiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClFiClNiDeMiBfLiCkKjFeLiClIjDgPjIfOiCmFiCkLiCoJiCoNiCkPiCmFiCmNiCmIiCkCiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.05.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
	 *************************************************************************/
	virtual wchar_t GetComponentShortcut () const
	{
		return L'A';
	} // GetComponentShortcut.

	//////////////////////////////////////////////////////////////////////////////
	// Interface IMpgPlugInMain.

	/*************************************************************************
	 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	Initialize
	 *
	 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiCiDfHiDiFiBfLiDiLiCpAiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pI	:DynamicDraw_xZkqqHx_jBkEiCmMiDeDiDjDiDfOiDhEiDeGiBfLiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_ S_OK_xZkqqHx_iBeBiOlIjEhDiClFiClNiPoKiNiHiCmNiDeHiDiJiBfLiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.09.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
	 *************************************************************************/
	virtual HRESULT Initialize (IMpgMolipMain* pI)
	{
//----- 06.03.21 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//		if (FMpgGetComponent0MolipMainI() == NULL)
//		{
//			// DynamicDraw_xZkqqHx_iCmMiDiBiDeDiDjDiDeDiDjDiDfOiDhEiDeGiBfLiDfIiCpAiOoGjDlOiBeC_xHqqkZx_
//			FMpgGetComponent0MolipMainI() = pI;
//		}
//----- 06.03.21 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
		// DynamicDraw_xZkqqHx_iDeDiDjDiDfOiDhEiDeGiBfLiDfIiCpAiDiBiDjDiDgPjFmPjAjEiCmJiLeMjIfOiBeCiBeC_xHqqkZx_
		m_pMolipMain = pI;
		return S_OK;
	} // Initialize.

	/*************************************************************************
	 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	Terminate
	 *
	 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiCiDfHiDiFiBfLiDiLiCmMiPeJjHlJiPiIjHjNiCpAiNhDiCkEiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_ S_OK_xZkqqHx_iBeBiOlIjEhDiClFiClNiPoKiNiHiCmNiDeHiDiJiBfLiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.09.29 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
	 *************************************************************************/
	virtual HRESULT Terminate ()
	{
		return S_OK;
	} // Terminate.

	/*************************************************************************
	 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	OnCommand
	 *
	 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiCiDfHiDiFiBfLiDiLiCkKjAnNjCoIiClFiClNiDfCiDhNiDjDiDgIiCkKiOmAiNhDiClDiCoKiClNiCmGiCkLiCmJiMmEiCmOiCoKiCoJiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	nCmdID	:_xZkqqHx_iOmAiNhDiClDiCoKiClNiDfCiDhNiDjDiDgIiCmM_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_ S_OK_xZkqqHx_iBeBiOlIjEhDiClFiClNiPoKiNiHiCmNiDeHiDiJiBfLiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.06.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
	 *************************************************************************/
	virtual HRESULT OnCommand (UINT nCmdID)
	{
		return S_OK;
	} // OnCommand.

	/*************************************************************************
	 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	OnUpdateCommandUI
	 *
	 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiCiDfHiDiFiBfLiDiLiCkKjAnNjCoIiClFiClNiDfCiDhNiDjDiDgIiCmMiDiBiDgKiDiFiBfLiCkKjFfMiOkGiClDiCoKiClNiCmGiCkLiCmJiMmEiCmOiCoKiCoJiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pCmdUI	:_xZkqqHx_iDfCiDhNiDjDiDgIjFfMiOkGiPpDjBnEiCmMiDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_ S_OK_xZkqqHx_iBeBiOlIjEhDiClFiClNiPoKiNiHiCmNiDeHiDiJiBfLiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.06.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
	 *************************************************************************/
	virtual HRESULT OnUpdateCommandUI (MfcCmdUI* pCmdUI)
	{
		return S_OK;
	} // OnUpdateCommandUI.

	/*************************************************************************
	 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	GetPopHint
	 *
	 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhGiDiJiDePiDeDiDjDiDfCiDhNiDjDiDgIiCmMiDhMiDgCiDhGiDhBiDjDiDgHiCmMiDgFiDeMiDfIiDgHiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
	 *			_xZkqqHx_iDiBiDgKiDiFiBfLiPoDiCmJiDhNiDeFiDfIiDeKiBfLiDfMiDiLiCkKiInKjDkOiClFiClNiCmGiCkLiCmJjFfMiOkGiClDiCoKiCoJiDiBiDgCiDfKiBfLiDfH_xHqqkZx_
	 *			_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wstrHintText:_xZkqqHx_iDhBiDjDiDgHiDgFiDeMiDfIiDgHiCpAjFnEiClHiBeC_xHqqkZx_
	 *			nCmdID		:_xZkqqHx_iDfCiDhNiDjDiDgI_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_ S_OK_xZkqqHx_iBeBiOlIjEhDiClFiClNiPoKiNiHiCmNiDeHiDiJiBfLiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.08.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
	 *************************************************************************/
	virtual HRESULT GetPopHint (WString& wstrHintText, UINT nCmdID)
	{
		return S_OK;
	} // GetPopHint.

	/*************************************************************************
	 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	OnSelectedObjectSave
	 *
	 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhGiDiJiDePiDeDiDjDiCkKjAnNjCoIiClFiClNiDhEiDeIiBfLiDhNiDgCiDgHiCmFiDhEiDeAiDeDiDiLjFnLjBlGiCmMiOjOiCmJiMmEiCmOiCoKiCoJiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	nFormatId	:_xZkqqHx_iDhEiDeIiBfLiDhNiDgCiDgH_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
	 *			tcpFileName	:_xZkqqHx_iDhEiDeAiDeDiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.06.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
	 *************************************************************************/
	virtual HRESULT OnSelectedObjectSave (	UINT nFormatId, const wchar_t* wcpFileName,
											mmetol mmMarginLeft, mmetol mmMarginTop,
											mmetol mmMarginRight, mmetol mmMarginBottom)
	{
		return S_OK;
	} // OnSelectedObjectSave.

//----- 05.07.29 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	/*************************************************************************
//	 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	OnFileImport
//	 *
//	 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhGiDiJiDePiDeDiDjDiCkKjAnNjCoIiClFiClNiDhEiDeIiBfLiDhNiDgCiDgHiCmFiDhEiDeAiDeDiDiLjFnLjBlGiCmMiOjOiCmJiMmEiCmOiCoKiCoJiBeC_xHqqkZx_
//	 *
//	 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	nFormatId	:_xZkqqHx_iDhEiDeIiBfLiDhNiDgCiDgH_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
//	 *			lFileCount	:pFileName_xZkqqHx_jEhKjHpBiCmMiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
//	 *			pFileName	:_xZkqqHx_iDhEiDeAiDeDiDiLjGlMiCmMjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
//	 *
//	 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.09.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
//	 *************************************************************************/
//	virtual HRESULT OnFileImport (UINT nFormatId, long lFileCount, const wchar_t* pFileName[])
//	{
//		return S_OK;
//	} // OnFileImport.
//----- 05.07.29 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

	//////////////////////////////////////////////////////////////////////////////
	// Interface IMpgPlugInFileConv.

	/*************************************************************************
	 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	GetFileConvInfo
	 *
	 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeDiDiLiDfCiDjDiDgPiBfLiDfOiBfLiCmMiPoOjFpBiCpAjFnEiClHiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pConvInfo		:FCFileConvInfo_xZkqqHx_iNfMjBkCjBmMiCmMjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
	 *			lConvInfoSize	:pConvInfo_xZkqqHx_iCmMjEhKjHpBjAjEiCpAjFnEiClHiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iPoOjFpBiCpAjFnEiClHiPoKiNiHiCmN_xHqqkZx_ S_OK_xZkqqHx_iBeBjFnEiClDiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ S_FALSE_xZkqqHx_iBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.05.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
	 *************************************************************************/
	virtual HRESULT GetFileConvInfo (const FCFileConvInfo** pConvInfo, long* lConvInfoSize)
	{
		return S_FALSE;
	} // GetFileConvInfo.

//----- 06.05.12 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	/*************************************************************************
//	 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	GetFileConverterPath
//	 *
//	 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeDiDiLiDfCiDjDiDgPiBfLiDfOiBfLjGhLjBmMiCmM_xHqqkZx_DLL_xZkqqHx_iCmMiDhAiDfIiCpAjFnEiClHiBeC_xHqqkZx_
//	 *
//	 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeDiDiLiDfCiDjDiDgPiBfLiDfOiBfLjGhLjBmMiCmM_xHqqkZx_DLL_xZkqqHx_iCmMiDhAiDfIiBeC_xHqqkZx_
//	 *
//	 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.05.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
//	 *************************************************************************/
//	virtual const wchar_t* GetFileConverterPath ()
//	{
//		return NULL;
//	} // GetFileConverterPath.
//----- 06.05.12 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

	/*************************************************************************
	 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	LoadConverter
	 *
	 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDgPiBfLiDfOjGhLjBmMiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iKnGjAjEiCkKjAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_ S_OK_xZkqqHx_iBeBiOlIjEhDiCmIiCoHiCmO_xHqqkZx_ E_FAIL_xZkqqHx_iBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeDiDiLjFmPiKlHiCpAiNhDiCkEiDhGiDiJiDePiDeDiDjDiCmFjHjIjHhAiBeC_xHqqkZx_
	 *			IMpgFileConv::RegisterConvertInfo_xZkqqHx_iCmFjFmPiKlHiPoOjFpBiCpAjDgPjIfOiClFiClN_xHqqkZx_
	 *			_xZkqqHx_iDhGiDiJiDePiDeDiDjDiCmNiBeBiDhEiDeAiDeDiDiLjFmPiKlHiCpAiKeKiOgOiClHiCoJiNnLiCmJ_xHqqkZx_DynamicDraw_xZkqqHx_iCkJiCoH_xHqqkZx_
	 *			_xZkqqHx_iClBiCmMiKnGjAjEiCkKiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
	 *			_xZkqqHx_iClBiCmMiKnGjAjEiCmFiBeBiDhEiDeAiDeDiDiLjFmPiKlH_xHqqkZx_DLL_xZkqqHx_iCmMjGhLjBmMiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.05.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
	 *************************************************************************/
	virtual HRESULT LoadConverter ()
	{
		return S_OK;
	} // LoadConverter.

	/*************************************************************************
	 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FreeConverter
	 *
	 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDgPiBfLiDfOjGhLjBmMiCpAiJpAjFpKiClHiCoJiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iKnGjAjEiCkKjAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_ S_OK_xZkqqHx_iBeBiOlIjEhDiCmIiCoHiCmO_xHqqkZx_ E_FAIL_xZkqqHx_iBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeDiDiLjFmPiKlHiCpAiNhDiCkEiDhGiDiJiDePiDeDiDjDiCmFjHjIjHhAiBeC_xHqqkZx_
	 *			IMpgFileConv::RegisterConvertInfo_xZkqqHx_iCmFjFmPiKlHiPoOjFpBiCpAjDgPjIfOiClFiClN_xHqqkZx_
	 *			_xZkqqHx_iDhGiDiJiDePiDeDiDjDiCmNiBeBiDhEiDeAiDeDiDiLjFmPiKlHiCkKiPeJjHlJiClFiClNiNnLiCmJ_xHqqkZx_DynamicDraw_xZkqqHx_iCkJiCoH_xHqqkZx_
	 *			_xZkqqHx_iClBiCmMiKnGjAjEiCkKiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
	 *			_xZkqqHx_iClBiCmMiKnGjAjEiCmFiBeBiDhEiDeAiDeDiDiLjFmPiKlH_xHqqkZx_DLL_xZkqqHx_iCmMjGhLjBmMiCpAiJpAjFpKiClHiCoJiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.05.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
	 *************************************************************************/
	virtual HRESULT FreeConverter ()
	{
		return S_OK;
	} // FreeConverter.

	/*************************************************************************
	 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	AnalyzeVersion
	 *
	 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiDhEiDeAiDeDiDiLiCmMiDgPiBfLiDfHiDiHiDjDiCpAjClCiCnHiCoJiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wstrVersion	:_xZkqqHx_iDgPiBfLiDfHiDiHiDjDiCpAjFnEiClHiBeC_xHqqkZx_
	 *			wcpFilePath	:_xZkqqHx_jClCiCnHiCoJiDhEiDeAiDeDiDiLiCmMiDhEiDeAiDeDiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDgPiBfLiDfHiDiHiDjDiCkKjElLjGlOiClFiClNiPoKiNiHiCmN_xHqqkZx_ S_OK_xZkqqHx_iBeBjFhDjGlOiCmMiPoKiNiHiCmN_xHqqkZx_ S_FALSE_xZkqqHx_iBeC_xHqqkZx_
	 *			_xZkqqHx_iKnGjAjEiCkKiOlIjEhDiCmIiCoHiCmO_xHqqkZx_ E_FAIL_xZkqqHx_iBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.05.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
	 *************************************************************************/
	virtual HRESULT AnalyzeVersion (WString& wstrVersion, const wchar_t* wcpFilePath)
	{
		return E_FAIL;
	} // AnalyzeVersion.

	/*************************************************************************
	 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	DoConvert
	 *
	 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeDiDiLiMgAiOkOiCpAjFmPiKlHiClHiCoJiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpTypeFrom		:_xZkqqHx_jFmPiKlHiMlDiDfOiDeDiDhGiCpAiOhHjCoIiBeC_xHqqkZx_
	 *							 _xZkqqHx_jHoBiBeG_xHqqkZx_"*fcore" "C:\doc\a.mdrw"
	 *			wcpVersionFrom	:_xZkqqHx_jFmPiKlHiMlDiDgPiBfLiDfHiDiHiDjDiCpAiOhHjCoIiBeC_xHqqkZx_
	 *							 _xZkqqHx_jHoBiBeG_xHqqkZx_"2.0" "3.0"
	 *			pStorageFrom	:_xZkqqHx_jFmPiKlHiMlDiCmMiDhEiDeAiDeDiDiLiBeBiIlNiCkCiCmNiDfIiDgHiDiMiBfLiDfHiCpAiOhHjCoIiBeC_xHqqkZx_
	 *							 wcpTypeFrom_xZkqqHx_iCmJ_xHqqkZx_ _xZkqqHx_jFkBiNiHiDfCiDeB_xHqqkZx_ "*ccore" _xZkqqHx_iCkKiOhHjCoIiClDiCoKiCmE_xHqqkZx_
	 *							 _xZkqqHx_iCkCiCoJiPoKiNiHiCmNiBeB_xHqqkZx_LPSTORAGE_xZkqqHx_iMfOiCmMiDfIiDgHiDiMiBfLiDfHiBeC_xHqqkZx_
	 *							 wcpTypeFrom_xZkqqHx_iCmJ_xHqqkZx_ _xZkqqHx_iDhEiDiJiDgCiDgHiDfCiDeB_xHqqkZx_ "*fcore" "*xcore" _xZkqqHx_iCkK_xHqqkZx_
	 *							 _xZkqqHx_iOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmNiBeB_xHqqkZx_MfcFile*_xZkqqHx_iMfOiCmMiDhEiDeAiDeDiDiLiBeC_xHqqkZx_
	 *							 _xZkqqHx_iClLiCoKiImIiKePiCmMiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iBeC_xHqqkZx_
	 *			wcpTypeTo		:_xZkqqHx_jFmPiKlHjAoGiDfOiDeDiDhGiCpAiOhHjCoIiBeC_xHqqkZx_
	 *							 _xZkqqHx_jHoBiBeG_xHqqkZx_"*fcore" "*fcore2" "C:\doc\a.mdrw"
	 *			wcpVersionTo	:_xZkqqHx_jFmPiKlHjAoGiDgPiBfLiDfHiDiHiDjDiCpAiOhHjCoIiBeC_xHqqkZx_
	 *							 _xZkqqHx_jHoBiBeG_xHqqkZx_"2.0" "3.0"
	 *			pStorageTo		:_xZkqqHx_jFmPiKlHjAoGiCmMiDhEiDeAiDeDiDiLiBeBiIlNiCkCiCmNiDfIiDgHiDiMiBfLiDfHiCpAiOhHjCoIiBeC_xHqqkZx_
	 *							 wcpTypeTo_xZkqqHx_iCmJ_xHqqkZx_ _xZkqqHx_jFkBiNiHiDfCiDeB_xHqqkZx_ "*ccore" _xZkqqHx_iCkKiOhHjCoIiClDiCoKiCmE_xHqqkZx_
	 *							 _xZkqqHx_iCkCiCoJiPoKiNiHiCmNiBeB_xHqqkZx_LPSTORAGE_xZkqqHx_iMfOiCmMiDfIiDgHiDiMiBfLiDfHiBeC_xHqqkZx_
	 *							 wcpTypeTo_xZkqqHx_iCmJ_xHqqkZx_ _xZkqqHx_iDhEiDiJiDgCiDgHiDfCiDeB_xHqqkZx_ "*fcore" "*xcore" _xZkqqHx_iCkK_xHqqkZx_
	 *							 _xZkqqHx_iOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmNiBeB_xHqqkZx_MfcFile*_xZkqqHx_iMfOiCmMiDhEiDeAiDeDiDiLiBeC_xHqqkZx_
	 *							 _xZkqqHx_iClLiCoKiImIiKePiCmMiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iBeC_xHqqkZx_
	 *			pImageData		:_xZkqqHx_iPjBiCkLiPgPiClHiDhEiDeAiDeDiDiLiCmMiDeDiDiBiBfLiDfHiCpAiOhHjCoIiBeC_xHqqkZx_
	 *							 _xZkqqHx_iDgGiDhEiDeIiDiLiDgHiBgJiCkJiCoHiDeDiDiBiBfLiDfHiBgKiCmMiPoKiNiHiCmN_xHqqkZx_ NULL_xZkqqHx_iBeC_xHqqkZx_
	 *			lImageSize		:pImageData_xZkqqHx_iCmMiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
	 *			szImage			:_xZkqqHx_iDeDiDiBiBfLiDfHiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	_xZkqqHx_iClBiCmMiDeJiDhFiDfHiDeGiDeOiDgHiCmMiDfCiDjDiDgPiBfLiDfOiCkKiDfEiDhMiBfLiDgHiClFiCmEiCkCiCoJjFmPiKlHiCmM_xHqqkZx_
	 *			_xZkqqHx_jFmPiKlHiMlD_xHqqkZx_/_xZkqqHx_jFmPiKlHjAoGiCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
	 *			FMfcFileConvManager::DoConvert_xZkqqHx_iCmFiCmNiBeBiClBiCmMjFmPiKlHiCpAjFkBjAjEiJpB_xHqqkZx_
	 *			_xZkqqHx_iMeKiCoIjFnEiClFiCmEiPiKjCoIiCmMiDhEiDeIiBfLiDhNiDgCiDgHiCpAjDlOiCoJiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_jFmPiKlHiCmJiOlIjEhDiClFiClNiPoKiNiHiCmNiBeBiCkJiCmIiCoHiClI_xHqqkZx_IMpgUtilErr::ThrowXXX_xZkqqHx_iCmF_xHqqkZx_
	 *			_xZkqqHx_jHoBiKePiCpAjEkNjAlGiClDiClJiCoJiClBiCmGiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeDiDiLiBhF_xHqqkZx_MMM Ver1.0_xZkqqHx_iMgAiOkOiBhGiCkJiCoHjFmPiKlHiCmMiPoKiNiH_xHqqkZx_
	 *			wcpTypeFrom = "C:\Doc\ABC.MMM"
	 *			wcpVersionFrom	= "1.0"
	 *			_xZkqqHx_iDeBiBfLiDeKiDeDiDhFiBhF_xHqqkZx_fcore Ver2.0 _xZkqqHx_iMgAiOkOiBhGiCkJiCoHjFmPiKlHiCmMiPoKiNiH_xHqqkZx_
	 *			wcpTypeFrom = "*fcore"
	 *			wcpVersionFrom	= "2.0"
	 *
	 *			_xZkqqHx_jFmPiKlHjAoGiCmJ_xHqqkZx_"*fcore"_xZkqqHx_iCpAiOhHjCoIiClHiCoJiPoKiNiHiBeBiDhHiDgCiDfPiCmJiLeMjIfOiClDiCoKiCoJjFlGiPjBiDhEiDeIiBfLiDhNiDgCiDgH_xHqqkZx_
	 *			_xZkqqHx_iCpAjAjEjCgMiCmGiClFiCmEjCmHiJmBiCmFiCkLiCoJiBeCjAjEjCgMiCpAjCmHiJmBiClFiCmIiCkCiPoKiNiHiCmNiBeBjFmPiKlHiMlDiCmMiDgGiBfLiDfOiCmJ_xHqqkZx_
	 *			_xZkqqHx_iKoOiCmDiCkCiCmEjAnNjCoIiClHiCoJiBeC_xHqqkZx_
	 *			_xZkqqHx_jHoBiBeG_xHqqkZx_
	 *			FD_DTP_PORTABLE_FORMAT_xZkqqHx_iCmMiPoKiNiHiCmN_xHqqkZx_ "*fcore2"
	 *			FD_DTP_TEMPLATE_FORMAT_xZkqqHx_iCmMiPoKiNiHiCmN_xHqqkZx_ "*fcore3"
	 *
	 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.29 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
	 *************************************************************************/
	virtual void DoConvert (const wchar_t* wcpTypeFrom,
							const wchar_t* wcpVersionFrom,
							void* pStorageFrom,
							const wchar_t* wcpTypeTo,
							const wchar_t* wcpVersionTo,
							void* pStorageTo,
							const BYTE* pImageData,
							long lImageSize,
							const MfcSize& szImage)
	{
		GetUtilErrI()->ThrowMiscException(L"Error:Default IMpgInterface::DoConvert was Called");
	} // DoConvert.

	//////////////////////////////////////////////////////////////////////////////
	// IMpgInterface native.

	/*************************************************************************
	 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	IMpgInterface
	 *
	 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.09.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
	 *************************************************************************/
	IMpgInterface () : m_cRef(1), m_pMolipMain(NULL)
	{
//----- 05.05.26 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
		// _xZkqqHx_iDfCiDjDiDhMiBfLiDgMiDjDiDgHiCmMiOfBiPmGiDeKiDeFiDjDiDfOiCpAiCfAiJmBiOfKiBeC_xHqqkZx_
		::InterlockedIncrement(&(GetInstanceCount()));
//----- 05.05.26 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	} // IMpgInterface.

	/*************************************************************************
	 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	~IMpgInterface
	 *
	 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.09.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
	 *************************************************************************/
	virtual ~IMpgInterface ()
	{
		m_cRef = 1;
//----- 05.05.26 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
		// _xZkqqHx_iDfCiDjDiDhMiBfLiDgMiDjDiDgHiCmMiOfBiPmGiDeKiDeFiDjDiDfOiCpAiCfAiMlIiOfKiBeC_xHqqkZx_
		::InterlockedDecrement(&(GetInstanceCount()));
//----- 05.05.26 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	} // ~IMpgInterface.

	/*************************************************************************
	 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	GetMolipMainI
	 *
	 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	DynamicDraw_xZkqqHx_iCmMiDiBiDeDiDjDiDeDiDjDiDfOiDhEiDeGiBfLiDfIiCpAjFnEiClHiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	DynamicDraw_xZkqqHx_iCmMiDiBiDeDiDjDiDeDiDjDiDfOiDhEiDeGiBfLiDfIiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	FMpgGetComponent0MolipMainI()_xZkqqHx_iCmNiBeBiDfCiDjDiDhMiBfLiDgMiDjDiDgH_xHqqkZx_0 _xZkqqHx_iCmJiKiEiCoIjDjGiCmEiCoHiCoKiClN_xHqqkZx_
	 *			DynamicDraw_xZkqqHx_iDiBiDeDiDjDiDeDiDjDiDfOiDhEiDeGiBfLiDfIiCpAjFnEiClHiCkKiBeB_xHqqkZx_GetMolipMainI_xZkqqHx_iKnGjAjEiCmN_xHqqkZx_
	 *			_xZkqqHx_iClBiCmMiDfCiDjDiDhMiBfLiDgMiDjDiDgHiCmJiKiEiCoIjDjGiCmEiCoHiCoKiClNiDiBiDeDiDjDiDeDiDjDiDfOiDhEiDeGiBfLiDfIiCpAjFnEiClHiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	DynamicDraw_xZkqqHx_iCmMiDiBiDeDiDjDiDeDiDjDiDfOiDhEiDeGiBfLiDfIiCmNiBeBiDhGiDiJiDePiDeDiDjDiDfCiDjDiDhMiBfLiDgMiDjDiDgH_xHqqkZx_
	 *			_xZkqqHx_iClCiCmGiCmJjDmGjHkHiClFiClNiDeDiDjDiDfOiDhEiDeGiBfLiDfIiCkKiKiEiCoIjDjGiCmEiCoHiCoKiCoJiBeC_xHqqkZx_
	 *			_xZkqqHx_iDiBiDeDiDjDiDeDiDjDiDfOiDhEiDeGiBfLiDfIiCkKjCpBiLjPiClHiCoJiKnGjAjEiCmMjBoFjElMiCmNiBeBiDhGiDiJiDePiDeDiDjDiCmMiIoBiCkCiCmJ_xHqqkZx_
	 *			_xZkqqHx_iImLjBlGiClFiCmIiCkCiCkKiBeBiIoKjFjEiCmMiKnGjAjEiCmNiDhGiDiJiDePiDeDiDjDiClCiCmGiCmJiLeAjEfMiCkKiInJiCmIiCoJiBeC_xHqqkZx_
	 *			_xZkqqHx_jHoBiCkGiCmO_xHqqkZx_ SetProfileBinary_xZkqqHx_iKnGjAjEiCmNiBeBiDhGiDiJiDePiDeDiDjDiClCiCmGiCmJiInJiCmIiCoJiDiMiDfHiDfIiDgHiDiKiCmJ_xHqqkZx_
	 *			_xZkqqHx_jCgMiCpAiLeMjIfOiClHiCoJiBeC_xHqqkZx_RegisterCommand_xZkqqHx_iKnGjAjEiCmNiBeBiDhGiDiJiDePiDeDiDjDiClCiCmGiCmJiInJiCmIiCoJ_xHqqkZx_
	 *			_xZkqqHx_iDiBiDgKiDiFiBfLiCmJiDfCiDhNiDjDiDgIiCpAiKiEiCoIjDjGiCmEiCoJiBeC_xHqqkZx_
	 *			_xZkqqHx_iClBiCmMiClNiCnPiBeBiDfCiDjDiDhMiBfLiDgMiDjDiDgHiDiBiDjDiDgPiKnGjAjEiCkJiCoHiCmN_xHqqkZx_
	 *			FMpgGetComponent0MolipMainI()_xZkqqHx_iCpAiMmEiCnBiPgPiClDiClIiBeB_xHqqkZx_GetMolipMainI_xZkqqHx_iKnGjAjEiCpA_xHqqkZx_
	 *			_xZkqqHx_iMmEiCnBiPgPiClHiClBiCmGiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
	 *************************************************************************/
	virtual IMpgMolipMain* GetMolipMainI ()
	{
		return m_pMolipMain;
	} // GetMolipMainI.

	/*************************************************************************
	 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	GetMolipMainI
	 *
	 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	DynamicDraw_xZkqqHx_iCmMiDiBiDeDiDjDiDeDiDjDiDfOiDhEiDeGiBfLiDfIiCpAjFnEiClHiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	DynamicDraw_xZkqqHx_iCmMiDiBiDeDiDjDiDeDiDjDiDfOiDhEiDeGiBfLiDfIiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	FMpgGetComponent0MolipMainI()_xZkqqHx_iCmNiBeBiDfCiDjDiDhMiBfLiDgMiDjDiDgH_xHqqkZx_0 _xZkqqHx_iCmJiKiEiCoIjDjGiCmEiCoHiCoKiClN_xHqqkZx_
	 *			DynamicDraw_xZkqqHx_iDiBiDeDiDjDiDeDiDjDiDfOiDhEiDeGiBfLiDfIiCpAjFnEiClHiCkKiBeB_xHqqkZx_GetMolipMainI_xZkqqHx_iKnGjAjEiCmN_xHqqkZx_
	 *			_xZkqqHx_iClBiCmMiDfCiDjDiDhMiBfLiDgMiDjDiDgHiCmJiKiEiCoIjDjGiCmEiCoHiCoKiClNiDiBiDeDiDjDiDeDiDjDiDfOiDhEiDeGiBfLiDfIiCpAjFnEiClHiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	DynamicDraw_xZkqqHx_iCmMiDiBiDeDiDjDiDeDiDjDiDfOiDhEiDeGiBfLiDfIiCmNiBeBiDhGiDiJiDePiDeDiDjDiDfCiDjDiDhMiBfLiDgMiDjDiDgH_xHqqkZx_
	 *			_xZkqqHx_iClCiCmGiCmJjDmGjHkHiClFiClNiDeDiDjDiDfOiDhEiDeGiBfLiDfIiCkKiKiEiCoIjDjGiCmEiCoHiCoKiCoJiBeC_xHqqkZx_
	 *			_xZkqqHx_iDiBiDeDiDjDiDeDiDjDiDfOiDhEiDeGiBfLiDfIiCkKjCpBiLjPiClHiCoJiKnGjAjEiCmMjBoFjElMiCmNiBeBiDhGiDiJiDePiDeDiDjDiCmMiIoBiCkCiCmJ_xHqqkZx_
	 *			_xZkqqHx_iImLjBlGiClFiCmIiCkCiCkKiBeBiIoKjFjEiCmMiKnGjAjEiCmNiDhGiDiJiDePiDeDiDjDiClCiCmGiCmJiLeAjEfMiCkKiInJiCmIiCoJiBeC_xHqqkZx_
	 *			_xZkqqHx_jHoBiCkGiCmO_xHqqkZx_ SetProfileBinary_xZkqqHx_iKnGjAjEiCmNiBeBiDhGiDiJiDePiDeDiDjDiClCiCmGiCmJiInJiCmIiCoJiDiMiDfHiDfIiDgHiDiKiCmJ_xHqqkZx_
	 *			_xZkqqHx_jCgMiCpAiLeMjIfOiClHiCoJiBeC_xHqqkZx_RegisterCommand_xZkqqHx_iKnGjAjEiCmNiBeBiDhGiDiJiDePiDeDiDjDiClCiCmGiCmJiInJiCmIiCoJ_xHqqkZx_
	 *			_xZkqqHx_iDiBiDgKiDiFiBfLiCmJiDfCiDhNiDjDiDgIiCpAiKiEiCoIjDjGiCmEiCoJiBeC_xHqqkZx_
	 *			_xZkqqHx_iClBiCmMiClNiCnPiBeBiDfCiDjDiDhMiBfLiDgMiDjDiDgHiDiBiDjDiDgPiKnGjAjEiCkJiCoHiCmN_xHqqkZx_
	 *			FMpgGetComponent0MolipMainI()_xZkqqHx_iCpAiMmEiCnBiPgPiClDiClIiBeB_xHqqkZx_GetMolipMainI_xZkqqHx_iKnGjAjEiCpA_xHqqkZx_
	 *			_xZkqqHx_iMmEiCnBiPgPiClHiClBiCmGiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
	 *************************************************************************/
	virtual const IMpgMolipMain* GetMolipMainI () const
	{
		return m_pMolipMain;
	} // GetMolipMainI.

	/*************************************************************************
	 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	GetUtilErrI
	 *
	 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	DynamicDraw_xZkqqHx_iCkKjCpBiLjPiClHiCoJ_xHqqkZx_IMpgUtilErr_xZkqqHx_iDeDiDjDiDfOiDhEiDeGiBfLiDfIiCpAjFnEiClHiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	IMpgUtilErr_xZkqqHx_iDeDiDjDiDfOiDhEiDeGiBfLiDfIiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
	 *************************************************************************/
	virtual const IMpgUtilErr* GetUtilErrI () const
	{
		return m_pMolipMain->GetUtilErrI();
	} // GetUtilErrI.

	/*************************************************************************
	 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	GetUtilMathI
	 *
	 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	DynamicDraw_xZkqqHx_iCkKjCpBiLjPiClHiCoJ_xHqqkZx_IMpgUtilMath_xZkqqHx_iDeDiDjDiDfOiDhEiDeGiBfLiDfIiCpAjFnEiClHiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	IMpgUtilMath_xZkqqHx_iDeDiDjDiDfOiDhEiDeGiBfLiDfIiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
	 *************************************************************************/
	virtual const IMpgUtilMath* GetUtilMathI () const
	{
		return m_pMolipMain->GetUtilMathI();
	} // GetUtilMathI.

	/*************************************************************************
	 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	GetUtilFileI
	 *
	 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	DynamicDraw_xZkqqHx_iCkKjCpBiLjPiClHiCoJ_xHqqkZx_IMpgUtilFile_xZkqqHx_iDeDiDjDiDfOiDhEiDeGiBfLiDfIiCpAjFnEiClHiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	IMpgUtilFile_xZkqqHx_iDeDiDjDiDfOiDhEiDeGiBfLiDfIiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
	 *************************************************************************/
	virtual const IMpgUtilFile* GetUtilFileI () const
	{
		return m_pMolipMain->GetUtilFileI();
	} // GetUtilFileI.

	/*************************************************************************
	 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	GetUtilFontI
	 *
	 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	DynamicDraw_xZkqqHx_iCkKjCpBiLjPiClHiCoJ_xHqqkZx_IMpgUtilFont_xZkqqHx_iDeDiDjDiDfOiDhEiDeGiBfLiDfIiCpAjFnEiClHiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	IMpgUtilFont_xZkqqHx_iDeDiDjDiDfOiDhEiDeGiBfLiDfIiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
	 *************************************************************************/
	virtual const IMpgUtilFont* GetUtilFontI () const
	{
		return m_pMolipMain->GetUtilFontI();
	} // GetUtilFontI.

	/*************************************************************************
	 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	GetUtilStrI
	 *
	 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	DynamicDraw_xZkqqHx_iCkKjCpBiLjPiClHiCoJ_xHqqkZx_IMpgUtilStr_xZkqqHx_iDeDiDjDiDfOiDhEiDeGiBfLiDfIiCpAjFnEiClHiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	IMpgUtilStr_xZkqqHx_iDeDiDjDiDfOiDhEiDeGiBfLiDfIiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
	 *************************************************************************/
	virtual const IMpgUtilStr* GetUtilStrI () const
	{
		return m_pMolipMain->GetUtilStrI();
	} // GetUtilStrI.

	/*************************************************************************
	 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	GetUtilPrintI
	 *
	 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	DynamicDraw_xZkqqHx_iCkKjCpBiLjPiClHiCoJ_xHqqkZx_IMpgUtilPrint_xZkqqHx_iDeDiDjDiDfOiDhEiDeGiBfLiDfIiCpAjFnEiClHiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	IMpgUtilPrint_xZkqqHx_iDeDiDjDiDfOiDhEiDeGiBfLiDfIiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
	 *************************************************************************/
	virtual const IMpgUtilPrint* GetUtilPrintI () const
	{
		return m_pMolipMain->GetUtilPrintI();
	} // GetUtilPrintI.

	/*************************************************************************
	 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	GetUtilCoordI
	 *
	 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	DynamicDraw_xZkqqHx_iCkKjCpBiLjPiClHiCoJ_xHqqkZx_IMpgUtilCoord_xZkqqHx_iDeDiDjDiDfOiDhEiDeGiBfLiDfIiCpAjFnEiClHiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	IMpgUtilCoord_xZkqqHx_iDeDiDjDiDfOiDhEiDeGiBfLiDfIiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
	 *************************************************************************/
	virtual const IMpgUtilCoord* GetUtilCoordI () const
	{
		return m_pMolipMain->GetUtilCoordI();
	} // GetUtilCoordI.

	/*************************************************************************
	 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	GetUtilZlibPngI
	 *
	 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	DynamicDraw_xZkqqHx_iCkKjCpBiLjPiClHiCoJ_xHqqkZx_IMpgUtilZlibPng_xZkqqHx_iDeDiDjDiDfOiDhEiDeGiBfLiDfIiCpAjFnEiClHiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	IMpgUtilZlibPng_xZkqqHx_iDeDiDjDiDfOiDhEiDeGiBfLiDfIiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
	 *************************************************************************/
	virtual const IMpgUtilZlibPng* GetUtilZlibPngI () const
	{
		return m_pMolipMain->GetUtilZlibPngI();
	} // GetUtilZlibPngI.

	/*************************************************************************
	 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	GetUtilMiscI
	 *
	 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	DynamicDraw_xZkqqHx_iCkKjCpBiLjPiClHiCoJ_xHqqkZx_IMpgUtilMisc_xZkqqHx_iDeDiDjDiDfOiDhEiDeGiBfLiDfIiCpAjFnEiClHiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	IMpgUtilMisc_xZkqqHx_iDeDiDjDiDfOiDhEiDeGiBfLiDfIiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
	 *************************************************************************/
	virtual const IMpgUtilMisc* GetUtilMiscI () const
	{
		return m_pMolipMain->GetUtilMiscI();
	} // GetUtilMiscI.

	/*************************************************************************
	 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	GetUtilBezierI
	 *
	 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	DynamicDraw_xZkqqHx_iCkKjCpBiLjPiClHiCoJ_xHqqkZx_IMpgUtilBezier_xZkqqHx_iDeDiDjDiDfOiDhEiDeGiBfLiDfIiCpAjFnEiClHiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	IMpgUtilBezier_xZkqqHx_iDeDiDjDiDfOiDhEiDeGiBfLiDfIiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.07.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
	 *************************************************************************/
	virtual const IMpgUtilBezier* GetUtilBezierI () const
	{
		return m_pMolipMain->GetUtilBezierI();
	} // GetUtilBezierI.

//----- 05.05.26 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	/*************************************************************************
//	 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	GetInstanceCount
//	 *
//	 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDhMiBfLiDgMiDjDiDgHiCmMiDeDiDjDiDfIiDfOiDjDiDfIjFmPjAjEiCpAjFnEiClHiBeC_xHqqkZx_
//	 *
//	 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.05.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
//	 *************************************************************************/
//	virtual long&	GetInstanceCount () = 0;
//----- 05.05.26 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	/*************************************************************************
	 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	GetInstanceCount
	 *
	 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDhMiBfLiDgMiDjDiDgHiCmMiDeDiDjDiDfIiDfOiDjDiDfIiDeKiDeFiDjDiDfOjFmPjAjEiCpAjFnEiClHiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDhMiBfLiDgMiDjDiDgHiDeDiDjDiDfIiDfOiDjDiDfIiCkKjGlDiCkCiPpDjBnEiCmFiCoAjClCiCnHiCoHiCoKiCoJiCoGiCkEiBeB_xHqqkZx_
	 *			static_xZkqqHx_iKnGjAjEiCmFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.05.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
	 *************************************************************************/
	static long&	GetInstanceCount ()
	{
// 06.03.05 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//		static long s_cComponents = 0;
		return s_cComponents;
	} // GetInstanceCount.
//----- 05.05.26 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

private:
	long			m_cRef;			// _xZkqqHx_iClBiCmMiDeDiDjDiDfOiDhEiDeGiBfLiDfIiCmMiOfBiPmGiDeKiDeFiDjDiDfOiBeC_xHqqkZx_
	IMpgMolipMain*	m_pMolipMain;	// DynamicDraw_xZkqqHx_iDeDiDjDiDfOiDhEiDeGiBfLiDfIiBeC_xHqqkZx_

// 06.03.05 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	static long		s_cComponents;
}; // class IMpgInterface.

// 06.03.05 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//long IMpgInterface::s_cComponents = 0;

#endif//__MpgInterface_h
