#include "stdafx.h"
#include "2Env.h"		// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////
// _xZkqqHx_jFmPjAjE_xHqqkZx_

DBLPoint MC2Env::m_mmptShadowLen;	// _xZkqqHx_iJgFiCmMjClHiClDiBeC_xHqqkZx_
//----- _xZkqqHx_jHhAiOiGiCmMiDhGiDiNiDhAiDgFiDeC_xHqqkZx_ -----
short MC2Env::m_nDocPaperOrient;		// _xZkqqHx_jHhAiOiGiCmMjFpLiMpMiBeC_xHqqkZx_
short MC2Env::m_nDocPaperType;		// _xZkqqHx_jCoIiMgAjHhAiOiGiCmMiDfOiDeDiDhGiBeC_xHqqkZx_ A4,B5,etc.
double MC2Env::m_mmDocPaperWidth;	// _xZkqqHx_jHhAiOiGiCmMjFjNiBeCjHhAiOiGiCmMjFpLiMpMiCmNjAeEiCoIiNjOiCnNiNmPiBeC_xHqqkZx_
double MC2Env::m_mmDocPaperHeight;	// _xZkqqHx_jHhAiOiGiCmMiNiCiClDiBeCjHhAiOiGiCmMjFpLiMpMiCmNjAeEiCoIiNjOiCnNiNmPiBeC_xHqqkZx_
double MC2Env::m_mmDocPaperMarginL;	// _xZkqqHx_jHhAiOiGiCmMiNlGjHfNjEjCiBeC_xHqqkZx_
double MC2Env::m_mmDocPaperMarginT;	// _xZkqqHx_jHhAiOiGiCmMiPoDjHfNjEjCiBeC_xHqqkZx_
double MC2Env::m_mmDocPaperMarginR;	// _xZkqqHx_jHhAiOiGiCmMiJeFjHfNjEjCiBeC_xHqqkZx_
double MC2Env::m_mmDocPaperMarginB;	// _xZkqqHx_jHhAiOiGiCmMiJlKjHfNjEjCiBeC_xHqqkZx_
double MC2Env::m_dDocPageTimesX;		// _xZkqqHx_jHhAiOiGjBmOiDhJiBfLiDfHiCmM_xHqqkZx_X_xZkqqHx_jEhLjHkGiBeC_xHqqkZx_
double MC2Env::m_dDocPageTimesY;		// _xZkqqHx_jHhAiOiGjBmOiDhJiBfLiDfHiCmM_xHqqkZx_Y_xZkqqHx_jEhLjHkGiBeC_xHqqkZx_
DBLRect MC2Env::m_mmrtSheet;			// _xZkqqHx_iDfGiBfLiDgHiCmMjBoFiCkLiClDiBeC_xHqqkZx_

//----- _xZkqqHx_iDhGiDiKiDjDiDfOiCmMiDhGiDiNiDhAiDgFiDeC_xHqqkZx_ -----
BOOL MC2Env::m_bUseDocMarginAsPrn;	// _xZkqqHx_jHhAiOiGiCmMjHfNjEjCjCgMiCpAiOgHiCkEiCkJiBeI_xHqqkZx_
double MC2Env::m_mmPrnPaperMarginL;	// _xZkqqHx_jHhAiOiGiCmMiNlGjHfNjEjCiBeC_xHqqkZx_
double MC2Env::m_mmPrnPaperMarginT;	// _xZkqqHx_jHhAiOiGiCmMiPoDjHfNjEjCiBeC_xHqqkZx_
double MC2Env::m_mmPrnPaperMarginR;	// _xZkqqHx_jHhAiOiGiCmMiJeFjHfNjEjCiBeC_xHqqkZx_
double MC2Env::m_mmPrnPaperMarginB;	// _xZkqqHx_jHhAiOiGiCmMiJlKjHfNjEjCiBeC_xHqqkZx_

//----- _xZkqqHx_iDhJiBfLiDfHiCmMiDhGiDiNiDhAiDgFiDeC_xHqqkZx_ -----
BOOL MC2Env::m_bEqPageSheetLt;		// _xZkqqHx_iDhJiBfLiDfHiNlGiPoDiCpAiDfGiBfLiDgHiNlGiPoDiCmJiNiHiCoNiClJiCoJiCkJiBeI_xHqqkZx_
BOOL MC2Env::m_bEqPageSheetRb;		// _xZkqqHx_iDhJiBfLiDfHiJeFiJlKiCpAiDfGiBfLiDgHiJeFiJlKiCmJiNiHiCoNiClJiCoJiCkJiBeI_xHqqkZx_
DBLPoint MC2Env::m_mmptPageLeftTop;	// _xZkqqHx_iDhJiBfLiDfHiNlGiPoDiImKjChFiCmMiNmAjFfHiBeC_xHqqkZx_
long MC2Env::m_lPageColumn;			// _xZkqqHx_iJkBjFpLiMpMiCmJiDhJiBfLiDfHiCpAjFmAiCnHiCoJjHpBjAjEiBeC_xHqqkZx_
long MC2Env::m_lPageLine;			// _xZkqqHx_iPgDjFpLiMpMiCmJiDhJiBfLiDfHiCpAjFmAiCnHiCoJiNhDjAjEiBeC_xHqqkZx_


// S_xZkqqHx_jAeG_xHqqkZx_
MC2SColorRecVector	g_vSColor;
MC2SColorIDVector	g_vFreqSColor;

// _xZkqqHx_iDiBiDfOiDhEiDeAiDeDiDiLiDhAiDfOiBfLiDjD_xHqqkZx_
MC2EMFImageRecVector	g_vEMFImage;
MC2EMFImageIDVector	g_vFreqEMFImage;

// _xZkqqHx_jCfAjAeGiDhAiDfOiBfLiDjD_xHqqkZx_._xZkqqHx_jDgIjCnHiClFjHhA_xHqqkZx_
MC2PatternRecVector	g_vPattern;
MC2PatternIDVector	g_vFreqPattern;

// _xZkqqHx_iDhFiDiJiDfGiCmMjDgPjIfOjGlM_xHqqkZx_
MC2BrushRegisterRecVector	g_vBrushRegister;
MC2BrushRegisterIDVector	g_vFreqBrushRegister;

// _xZkqqHx_iDhJiDjDiCmMjDgPjIfOjGlM_xHqqkZx_
MC2PenRegisterRecVector	g_vPenRegister;
MC2PenRegisterIDVector	g_vFreqPenRegister;

// _xZkqqHx_iDhJiDjDiCmMiDfIiDfOiDeDiDiL_xHqqkZx_._xZkqqHx_jClMjApM_xHqqkZx_,_xZkqqHx_jDfPjApM_xHqqkZx_,etc
MC2PenStyleRecVector	g_vPenStyle;
MC2PenStyleIDVector	g_vFreqPenStyle;

// S_xZkqqHx_iDhEiDeIiDjDiDgH_xHqqkZx_
MC2SFontRecVector	g_vSFont;

/////////////////////////////////////////////////////////////////////////
// class MC2PenRegisterRec

MC2PenRegisterRec::MC2PenRegisterRec ()
{
	/*----- _xZkqqHx_jBfDiCmEiCmMjFmPjAjEiCpAiPiJiKpKiJlL_xHqqkZx_ -----*/
	m_byPenType			= static_cast<BYTE>(-1);
	m_psidPenStyle		= static_cast<FD2PenStyleID>(-1);
	m_ptidPenPattern	= static_cast<FD2PatternID>(-1);
	m_mmfPenWeight		= static_cast<fmmetol>(-1);
	m_scidPenForeSColor	= static_cast<FD2SColorID>(-1);
	m_scidPenBackSColor	= static_cast<FD2SColorID>(-1);
	m_sName[0]			= _T('\0');
} // MC2PenRegisterRec::MC2PenRegisterRec.

MC2PenRegisterRec::MC2PenRegisterRec (BYTE			byPenType,
									FD2PenStyleID		psidPenStyle,
									FD2PatternID		ptidPenPattern,
									fmmetol			mmfPenWeight,
									FD2SColorID		scidPenForeSColor,
									FD2SColorID		scidPenBackSColor,
									const char*	pName)
{
	/*----- _xZkqqHx_iCkCiCmBiClNiCpBjBfDiCmEiCmMjFmPjAjEiCpAiPiJiKpKiJlL_xHqqkZx_ -----*/
	m_byPenType			= static_cast<BYTE>(-1);
	m_psidPenStyle		= static_cast<FD2PenStyleID>(-1);
	m_ptidPenPattern	= static_cast<FD2PatternID>(-1);
	m_mmfPenWeight		= static_cast<fmmetol>(-1);
	m_scidPenForeSColor	= static_cast<FD2SColorID>(-1);
	m_scidPenBackSColor	= static_cast<FD2SColorID>(-1);
	m_sName[0]			= _T('\0');
	/*----- _xZkqqHx_jHeMiMpIiCmIjFmPjAjEiCmMiCnNjAnNjCoI_xHqqkZx_ -----*/
	m_byPenType = byPenType;
	if (IsPenStyleEffect(byPenType))
		m_psidPenStyle = psidPenStyle;
	if (IsPenPatternEffect(byPenType))
		m_ptidPenPattern = ptidPenPattern;
	if (IsPenWeightEffect(byPenType))
		m_mmfPenWeight = mmfPenWeight;
	if (IsPenForeSColorEffect(byPenType))
		m_scidPenForeSColor = scidPenForeSColor;
	if (IsPenBackSColorEffect(byPenType))
		m_scidPenBackSColor = scidPenBackSColor;
	if (m_sName != pName)
		_tcscpy(m_sName, pName);
} // MC2PenRegisterRec::MC2PenRegisterRec.

BOOL MC2PenRegisterRec::operator == (const MC2PenRegisterRec& rec) const
{
	return (m_byPenType == rec.m_byPenType) &&
			(m_psidPenStyle == rec.m_psidPenStyle) &&
			(m_ptidPenPattern == rec.m_ptidPenPattern) &&
			(m_mmfPenWeight == rec.m_mmfPenWeight) &&
			(m_scidPenForeSColor == rec.m_scidPenForeSColor) &&
			(m_scidPenBackSColor == rec.m_scidPenBackSColor) &&
			(_tcscmp(m_sName, rec.m_sName) == 0);
} // MC2PenRegisterRec::operator ==.

void MC2PenRegisterRec::OutStream (MC2ARCHIVE& ar) const
{
	ar << m_byPenType;			// PEN_xZkqqHx_iCmMiMfOiBeCjGhLjHiI_xHqqkZx_4bit.
	ar << m_psidPenStyle;		// PEN_xZkqqHx_iCmMiDfIiDfOiDeDiDiLiBeC_xHqqkZx_
	ar << m_ptidPenPattern;		// PEN_xZkqqHx_iCmMiDiCiDgNiDhAiDfOiBfLiDjD_xHqqkZx_.
	ar << m_mmfPenWeight;			// PEN_xZkqqHx_iCmMjFjNiBeC_xHqqkZx_
	ar << m_scidPenForeSColor;	// PEN_xZkqqHx_iCmMjBePiMgJjAeGiBeC_xHqqkZx_
	ar << m_scidPenBackSColor;	// PEN_xZkqqHx_iCmMjEhHiMgJjAeGiBeC_xHqqkZx_
	// _xZkqqHx_jDgPjIfOjGlMiBeC_xHqqkZx_
	const BYTE byNameLen = _tcslen(m_sName);
	ar << byNameLen;
	ar.Write(m_sName, byNameLen);
} // MC2PenRegisterRec::OutStream.

void MC2PenRegisterRec::InStream (MC2ARCHIVE& ar)
{
	ar >> m_byPenType;			// PEN_xZkqqHx_iCmMiMfOiBeCjGhLjHiI_xHqqkZx_4bit.
	ar >> m_psidPenStyle;		// PEN_xZkqqHx_iCmMiDfIiDfOiDeDiDiLiBeC_xHqqkZx_
	ar >> m_ptidPenPattern;		// PEN_xZkqqHx_iCmMiDiCiDgNiDhAiDfOiBfLiDjD_xHqqkZx_.
	ar >> m_mmfPenWeight;			// PEN_xZkqqHx_iCmMjFjNiBeC_xHqqkZx_
	ar >> m_scidPenForeSColor;	// PEN_xZkqqHx_iCmMjBePiMgJjAeGiBeC_xHqqkZx_
	ar >> m_scidPenBackSColor;	// PEN_xZkqqHx_iCmMjEhHiMgJjAeGiBeC_xHqqkZx_
	// _xZkqqHx_jDgPjIfOjGlMiBeC_xHqqkZx_
	BYTE byNameLen;
	ar >> byNameLen;
//----- 06.03.26 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_jAkHiMmAjClHiCpAjClEiCkGiCoJiPoKiNiHiCmNiBeBjEgKjBlJiBeC_xHqqkZx_
	if (MD2_FD_ENV_NAME_LEN <= byNameLen)
		FFUtilErrI->ThrowMiscExceptionCode(FD_IDS_ERR_FILE_DESTROIED);
//----- 06.03.26 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	ar.Read(m_sName, byNameLen);
	m_sName[byNameLen] = _T('\0');
} // MC2PenRegisterRec::InStream.

BOOL MC2PenRegisterRec::IsPenRegisterEffect (BYTE byPenType)
{
	return (byPenType == FDPT_REGIST);
} // MC2PenRegisterRec::IsPenRegisterEffect.

BOOL MC2PenRegisterRec::IsPenStyleEffect (BYTE byPenType)
{
	return (byPenType == FDPT_SOLID || byPenType == FDPT_PATTERN);
} // MC2PenRegisterRec::IsPenStyleEffect.

BOOL MC2PenRegisterRec::IsPenPatternEffect (BYTE byPenType)
{
	return (byPenType == FDPT_PATTERN);
} // MC2PenRegisterRec::IsPenPatternEffect.

BOOL MC2PenRegisterRec::IsPenWeightEffect (BYTE byPenType)
{
	return (byPenType == FDPT_SOLID || byPenType == FDPT_TRANSP ||
			byPenType == FDPT_PATTERN);
} // MC2PenRegisterRec::IsPenWeightEffect.

BOOL MC2PenRegisterRec::IsPenForeSColorEffect (BYTE byPenType)
{
	return (byPenType == FDPT_SOLID || byPenType == FDPT_PATTERN);
} // MC2PenRegisterRec::IsPenForeSColorEffect.

BOOL MC2PenRegisterRec::IsPenBackSColorEffect (BYTE byPenType)
{
	return (byPenType == FDPT_PATTERN);
} // MC2PenRegisterRec::IsPenBackSColorEffect.

/////////////////////////////////////////////////////////////////////////
// class MC2BrushRegisterRec

MC2BrushRegisterRec::MC2BrushRegisterRec ()
{
	/*----- _xZkqqHx_jBfDiCmEiCmMjFmPjAjEiCpAiPiJiKpKiJlL_xHqqkZx_ -----*/
	m_byBrushType = static_cast<BYTE>(-1);
	m_ptidBrushPattern = static_cast<FD2PatternID>(-1);
	m_scidBrushForeSColor = static_cast<FD2SColorID>(-1);
	m_scidBrushBackSColor = static_cast<FD2SColorID>(-1);
	m_sName[0] = _T('\0');
} // MC2BrushRegisterRec::MC2BrushRegisterRec.

MC2BrushRegisterRec::MC2BrushRegisterRec (BYTE			byBrushType,
										FD2PatternID		ptidBrushPattern,
										FD2SColorID		scidBrushForeSColor,
										FD2SColorID		scidBrushBackSColor,
										const char*	pName)
{
	/*----- _xZkqqHx_iCkCiCmBiClNiCpBjBfDiCmEiCmMjFmPjAjEiCpAiPiJiKpKiJlL_xHqqkZx_ -----*/
	m_byBrushType = static_cast<BYTE>(-1);
	m_ptidBrushPattern = static_cast<FD2PatternID>(-1);
	m_scidBrushForeSColor = static_cast<FD2SColorID>(-1);
	m_scidBrushBackSColor = static_cast<FD2SColorID>(-1);
	m_sName[0] = _T('\0');
	/*----- _xZkqqHx_jHeMiMpIiCmIjFmPjAjEiCmMiCnNjAnNjCoI_xHqqkZx_ -----*/
	m_byBrushType = byBrushType;
	if (IsBrushPatternEffect(byBrushType))
		m_ptidBrushPattern = ptidBrushPattern;
	if (IsBrushForeSColorEffect(byBrushType))
		m_scidBrushForeSColor = scidBrushForeSColor;
	if (IsBrushBackSColorEffect(byBrushType))
		m_scidBrushBackSColor = scidBrushBackSColor;
	if (m_sName != pName) _tcscpy(m_sName, pName);
} // MC2BrushRegisterRec::MC2BrushRegisterRec.

BOOL MC2BrushRegisterRec::operator == (const MC2BrushRegisterRec& rec) const
{
	return (m_byBrushType == rec.m_byBrushType) &&
			(m_ptidBrushPattern == rec.m_ptidBrushPattern) &&
			(m_scidBrushForeSColor == rec.m_scidBrushForeSColor) &&
			(m_scidBrushBackSColor == rec.m_scidBrushBackSColor) &&
			(_tcscmp(m_sName, rec.m_sName) == 0);
} // MC2BrushRegisterRec::operator ==.

void MC2BrushRegisterRec::OutStream (MC2ARCHIVE& ar) const
{
	ar << m_byBrushType;			// BRUSH_xZkqqHx_iCmMiMfOiBeCjGhLjHiI_xHqqkZx_4bit.
	ar << m_ptidBrushPattern;		// BRUSH_xZkqqHx_iCmMiDiCiDgNiDhAiDfOiBfLiDjD_xHqqkZx_
	ar << m_scidBrushForeSColor;	// BRUSH_xZkqqHx_iCmMjBePiMgJjAeGiBeC_xHqqkZx_
	ar << m_scidBrushBackSColor;	// BRUSH_xZkqqHx_iCmMjEhHiMgJjAeGiBeC_xHqqkZx_
	// _xZkqqHx_jDgPjIfOjGlMiBeC_xHqqkZx_
	const BYTE byNameLen = _tcslen(m_sName);
	ar << byNameLen;
	ar.Write(m_sName, byNameLen);
} // MC2BrushRegisterRec::OutStream.

void MC2BrushRegisterRec::InStream (MC2ARCHIVE& ar)
{
	ar >> m_byBrushType;			// BRUSH_xZkqqHx_iCmMiMfOiBeCjGhLjHiI_xHqqkZx_4bit.
	ar >> m_ptidBrushPattern;		// BRUSH_xZkqqHx_iCmMiDiCiDgNiDhAiDfOiBfLiDjD_xHqqkZx_
	ar >> m_scidBrushForeSColor;	// BRUSH_xZkqqHx_iCmMjBePiMgJjAeGiBeC_xHqqkZx_
	ar >> m_scidBrushBackSColor;	// BRUSH_xZkqqHx_iCmMjEhHiMgJjAeGiBeC_xHqqkZx_
	// _xZkqqHx_jDgPjIfOjGlMiBeC_xHqqkZx_
	BYTE byNameLen;
	ar >> byNameLen;
//----- 06.03.26 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_jAkHiMmAjClHiCpAjClEiCkGiCoJiPoKiNiHiCmNiBeBjEgKjBlJiBeC_xHqqkZx_
	if (MD2_FD_ENV_NAME_LEN <= byNameLen)
		FFUtilErrI->ThrowMiscExceptionCode(FD_IDS_ERR_FILE_DESTROIED);
//----- 06.03.26 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	ar.Read(m_sName, byNameLen);
	m_sName[byNameLen] = _T('\0');
} // MC2BrushRegisterRec::InStream.

BOOL MC2BrushRegisterRec::IsBrushRegisterEffect (BYTE byBrushType)
{
	return (byBrushType == FDBT_REGIST);
} // MC2BrushRegisterRec::IsBrushRegisterEffect.

BOOL MC2BrushRegisterRec::IsBrushPatternEffect (BYTE byBrushType)
{
	return (byBrushType == FDBT_PATTERN);
} // MC2BrushRegisterRec::IsBrushPatternEffect.

BOOL MC2BrushRegisterRec::IsBrushForeSColorEffect (BYTE byBrushType)
{
	return (byBrushType == FDBT_SOLID || byBrushType == FDBT_PATTERN);
} // MC2BrushRegisterRec::IsBrushForeSColorEffect.

BOOL MC2BrushRegisterRec::IsBrushBackSColorEffect (BYTE byBrushType)
{
	return (byBrushType == FDBT_PATTERN);
} // MC2BrushRegisterRec::IsBrushBackSColorEffect.

/////////////////////////////////////////////////////////////////////////
// class MC2SFontRec

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2SFontRec::MC2SFontRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *************************************************************************/
MC2SFontRec::MC2SFontRec () {};

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2SFontRec::MC2SFontRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	_xZkqqHx_iPiJiKpKiJlLjCgMiBeC_xHqqkZx_
 *************************************************************************/
MC2SFontRec::MC2SFontRec (double mmHeight, DWORD dwEffects, BYTE byCharSet,
						BYTE byPitchAndFamily, const CHAR* szFaceName) :
				m_mmFontHeight(mmHeight), m_dwEffects(dwEffects),
				m_byCharSet(byCharSet), m_byPitchAndFamily(byPitchAndFamily)
{
	::strcpy(m_szFaceName, szFaceName);
} // MC2SFontRec::MC2SFontRec.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2SFontRec::MC2SFontRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	cf	: _xZkqqHx_iPiJiKpKiJlLjHhAiCmM_xHqqkZx_CHARFORMAT_xZkqqHx_iNfMjBkCjBmMiBeC_xHqqkZx_
 *************************************************************************/
MC2SFontRec::MC2SFontRec (const CHARFORMAT& cf)
{
	Init(cf);
} // MC2SFontRec::MC2SFontRec.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2SFontRec::MC2SFontRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lf		:_xZkqqHx_iPiJiKpKiJlLjHhAiCmM_xHqqkZx_LOGFONT_xZkqqHx_iNfMjBkCjBmMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dZoom	:_xZkqqHx_iPiJiKpKiJlLiOjOiCmMiDfJiBfLiDiAjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.04.18 Fukushiro M. dZoom_xZkqqHx_jFmPjAjEiCpAjCmHiJmBiBeC_xHqqkZx_
 *************************************************************************/
MC2SFontRec::MC2SFontRec (const LOGFONT& lf, double dZoom)
{
	Init(lf, dZoom);
} // MC2SFontRec::MC2SFontRec.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2SFontRec::MC2SFontRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	cf	: _xZkqqHx_iPiJiKpKiJlLjHhAiCmM_xHqqkZx_CHARFORMAT_xZkqqHx_iNfMjBkCjBmMiBeC_xHqqkZx_
 *************************************************************************/
void MC2SFontRec::Init (const CHARFORMAT& cf)
{
	// _xZkqqHx_iDhEiDeIiDjDiDgHiCmM_xHqqkZx_Height_xZkqqHx_iCmMiMhGiOfKiOkOiCmN_xHqqkZx_mfc\dlgfnt.cpp(135)_xZkqqHx_iCkJiCoHiIpIjHhA_xHqqkZx_.
// 06.05.10 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	m_mmFontHeight = -MD2_tw2mm(cf.yHeight);
	m_mmFontHeight = -CCD_tw2mm(cf.yHeight);
	// _xZkqqHx_iDhGiDiNiDhAiDgFiDeCiCpAiMmAjCoIiClHiCoJiClNiCnPiCmJiDfEiDhMiBfLiDgHjFkKiClOiCkPiCmJ_xHqqkZx_&_xZkqqHx_iCmFiNgJiCoIiNjOiCnO_xHqqkZx_.
	m_dwEffects = cf.dwEffects & (CFE_BOLD|CFE_ITALIC|CFE_STRIKEOUT|
									CFE_UNDERLINE);
	m_byCharSet = cf.bCharSet;
	m_byPitchAndFamily = cf.bPitchAndFamily;
	::strcpy(m_szFaceName, cf.szFaceName);
} // MC2SFontRec::Init.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2SFontRec::Init
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iPiJiKpKiJlLiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lf		:_xZkqqHx_iPiJiKpKiJlLjHhAiCmM_xHqqkZx_LOGFONT_xZkqqHx_iNfMjBkCjBmMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dZoom	:_xZkqqHx_iPiJiKpKiJlLiOjOiCmMiDfJiBfLiDiAjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.04.18 Fukushiro M. dZoom_xZkqqHx_jFmPjAjEiCpAjCmHiJmBiBeC_xHqqkZx_
 *************************************************************************/
void MC2SFontRec::Init (const LOGFONT& lf, double dZoom)
{
	m_mmFontHeight = mmetol(lf.lfHeight) / dZoom;
	m_dwEffects = 0;
	if (FW_NORMAL < lf.lfWeight)	m_dwEffects |= CFE_BOLD;
	if (lf.lfItalic)				m_dwEffects |= CFE_ITALIC;
	if (lf.lfUnderline)				m_dwEffects |= CFE_STRIKEOUT;
	if (lf.lfStrikeOut)				m_dwEffects |= CFE_UNDERLINE;
	m_byCharSet = lf.lfCharSet;
	m_byPitchAndFamily = lf.lfPitchAndFamily;
	::strcpy(m_szFaceName, lf.lfFaceName);
} // MC2SFontRec::Init.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2SFontRec::operator =
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDeIiDjDiDgHiPoOjFpBiCmMiDfCiDhDiBfL_xHqqkZx_.
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	prop	: MC2SFontRec
 *************************************************************************/
void MC2SFontRec::operator = (const MC2SFontRec& prop)
{
	m_mmFontHeight = prop.m_mmFontHeight;
	m_dwEffects = prop.m_dwEffects;
	m_byCharSet = prop.m_byCharSet;
	m_byPitchAndFamily = prop.m_byPitchAndFamily;
	::strcpy(m_szFaceName, prop.m_szFaceName);
} // MC2SFontRec::operator =.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2SFontRec::operator ==
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDeIiDjDiDgHiPoOjFpBiCmMjEoEiKhCiBeC_xHqqkZx_RegisterFont_xZkqqHx_iKnGjAjEjCiGiCmM_xHqqkZx_find_xZkqqHx_iCmFiOgHjHhAiBeC_xHqqkZx_
 *			TEXTMETRIC_xZkqqHx_iPoOjFpBiCmNjEoEiKhCiClFiCmIiCkC_xHqqkZx_._xZkqqHx_iClBiCoKiCmN_xHqqkZx_FONT_xZkqqHx_jAlGjAkMiCmJjFeLjHhGiCmIiPoOjFpBiCmFiCmN_xHqqkZx_
 *			_xZkqqHx_iCmIiCkCiCkJiCoH_xHqqkZx_.
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	prop	: MC2SFontRec
 *************************************************************************/
BOOL MC2SFontRec::operator == (const MC2SFontRec& prop) const
{
	return (m_mmFontHeight == prop.m_mmFontHeight) &&
			(m_dwEffects == prop.m_dwEffects) &&
			(m_byCharSet == prop.m_byCharSet) &&
			(m_byPitchAndFamily == prop.m_byPitchAndFamily) &&
			!strcmp(m_szFaceName, prop.m_szFaceName);
} // MC2SFontRec::operator ==.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2SFontRec::OutStream
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiMiDfCiBfLiDgIiCpAiDfIiDgHiDiKiBfLiDiAiCmJiPjBiCkLiPgPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ar	:_xZkqqHx_iDfIiDgHiDiKiBfLiDiAiPgPjHmNjHhAiDeBiBfLiDeKiDeDiDhFiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void MC2SFontRec::OutStream (MC2ARCHIVE& ar) const
{
	ar.Write(this, sizeof(*this));
} // MC2SFontRec::OutStream.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2SFontRec::InStream
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiMiDfCiBfLiDgIiCpAiDfIiDgHiDiKiBfLiDiAiCkJiCoHjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ar	:_xZkqqHx_iDfIiDgHiDiKiBfLiDiAjDpMjHmNjHhAiDeBiBfLiDeKiDeDiDhFiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void MC2SFontRec::InStream (MC2ARCHIVE& ar)
{
	ar.Read(this, sizeof(*this));
// 06.03.26 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	m_szFaceName[LF_FACESIZE - 1] = '\0';
} // MC2SFontRec::InStream.


/////////////////////////////////////////////////////////////////////////
// MC2Env_xZkqqHx_iDiBiDjDiDgPiKnGjAjEiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2Env::ClearEnvTbl
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iKmCiLkLiDgFiBfLiDhFiDiLiCpAiDeOiDiKiDeBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.11.09 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *			99.12.17 Fukushiro M. _xZkqqHx_iInKjDkOiBeC_xHqqkZx_
 *************************************************************************/
void MC2Env::ClearEnvTbl ()
{
	MC2SColorRecVector::iterator	iSColor;
	for	(iSColor = g_vSColor.begin(); iSColor != g_vSColor.end(); iSColor++)
		(*iSColor).Clear();
	g_vSColor.clear();
	g_vFreqSColor.clear();

	MC2EMFImageRecVector::iterator iEMFImage;
	for	(iEMFImage = g_vEMFImage.begin(); iEMFImage	!= g_vEMFImage.end(); iEMFImage++)
		(*iEMFImage).Clear();
	g_vEMFImage.clear();
	g_vFreqEMFImage.clear();

	MC2PatternRecVector::iterator iPattern;
	for	(iPattern =	g_vPattern.begin();	iPattern !=	g_vPattern.end(); iPattern++)
		(*iPattern).Clear();
	g_vPattern.clear();
	g_vFreqPattern.clear();

	MC2BrushRegisterRecVector::iterator iBrushRegister;
	for	(iBrushRegister	= g_vBrushRegister.begin();	iBrushRegister != g_vBrushRegister.end(); iBrushRegister++)
		(*iBrushRegister).Clear();
	g_vBrushRegister.clear();
	g_vFreqBrushRegister.clear();

	MC2PenRegisterRecVector::iterator iPenRegister;
	for	(iPenRegister =	g_vPenRegister.begin();	iPenRegister !=	g_vPenRegister.end(); iPenRegister++)
		(*iPenRegister).Clear();
	g_vPenRegister.clear();
	g_vFreqPenRegister.clear();

	MC2PenStyleRecVector::iterator iPenStyle;
	for	(iPenStyle = g_vPenStyle.begin(); iPenStyle	!= g_vPenStyle.end(); iPenStyle++)
		(*iPenStyle).Clear();
	g_vPenStyle.clear();
	g_vFreqPenStyle.clear();

	MC2SFontRecVector::iterator iSFont;
	for	(iSFont	= g_vSFont.begin();	iSFont != g_vSFont.end(); iSFont++)
		(*iSFont).Clear();
	g_vSFont.clear();
} // MC2Env::ClearEnvTbl.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2Env::OutStream
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iKmCiLkLiDgFiBfLiDhFiDiLiCmMiPoOjFpBiCpAiPjBiCkLiPgPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ar	:_xZkqqHx_iDeBiBfLiDeKiDeDiDhFiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.11.09 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *			99.07.10 Fukushiro M. _xZkqqHx_iDhGiDiKiDjDiDfOiPoOjFpBiCmMiPgPjHmNiBeC_xHqqkZx_
 *			99.12.16 Fukushiro M. OutEnvTbl_xZkqqHx_iCkJiCoHjFmPiNfIiBeC_xHqqkZx_
 *			00.04.05 Fukushiro M. _xZkqqHx_iDhGiDiKiDjDiDfOiPoOjFpBiCmMiPgPjHmNiCpA_xHqqkZx_CMC2MolipDrawApp_xZkqqHx_iCnGiInKjDkOiBeC_xHqqkZx_
 *************************************************************************/
void MC2Env::OutStream (MC2ARCHIVE& ar)
{
	// _xZkqqHx_iJgFiCmMjClHiClDiCpAiPjBiCkLiPgPiClHiBeC_xHqqkZx_
	ar.Write(&m_mmptShadowLen, sizeof(m_mmptShadowLen));
	//----- _xZkqqHx_jHhAiOiGiBeFiDhGiDiKiDjDiDfOiPoOjFpBiCpAiPjBiCkLiPgPiClH_xHqqkZx_ -----
	//----- _xZkqqHx_jHhAiOiGiCmMiDhGiDiNiDhAiDgFiDeC_xHqqkZx_ -----
	ar << m_nDocPaperOrient;	// _xZkqqHx_jHhAiOiGiCmMjFpLiMpMiBeC_xHqqkZx_
	ar << m_nDocPaperType;		// _xZkqqHx_jCoIiMgAjHhAiOiGiCmMiDfOiDeDiDhGiBeC_xHqqkZx_A4,B5,etc.
	ar << m_mmDocPaperWidth;	// _xZkqqHx_jHhAiOiGiCmMjFjNiBeCjHhAiOiGiCmMjFpLiMpMiCmNjAeEiCoIiNjOiCnNiNmPiBeC_xHqqkZx_
	ar << m_mmDocPaperHeight;	// _xZkqqHx_jHhAiOiGiCmMiNiCiClDiBeCjHhAiOiGiCmMjFpLiMpMiCmNjAeEiCoIiNjOiCnNiNmPiBeC_xHqqkZx_
	ar << m_mmDocPaperMarginL;	// _xZkqqHx_jHhAiOiGiCmMiNlGjHfNjEjCiBeC_xHqqkZx_
	ar << m_mmDocPaperMarginT;	// _xZkqqHx_jHhAiOiGiCmMiPoDjHfNjEjCiBeC_xHqqkZx_
	ar << m_mmDocPaperMarginR;	// _xZkqqHx_jHhAiOiGiCmMiJeFjHfNjEjCiBeC_xHqqkZx_
	ar << m_mmDocPaperMarginB;	// _xZkqqHx_jHhAiOiGiCmMiJlKjHfNjEjCiBeC_xHqqkZx_
	ar << m_dDocPageTimesX;		// _xZkqqHx_jHhAiOiGjBmOiDhJiBfLiDfHiCmM_xHqqkZx_X_xZkqqHx_jEhLjHkGiBeC_xHqqkZx_
	ar << m_dDocPageTimesY;		// _xZkqqHx_jHhAiOiGjBmOiDhJiBfLiDfHiCmM_xHqqkZx_Y_xZkqqHx_jEhLjHkGiBeC_xHqqkZx_
	ar.Write(&m_mmrtSheet, sizeof(m_mmrtSheet));	// _xZkqqHx_iDfGiBfLiDgHiCmMjBoFiCkLiClDiBeC_xHqqkZx_
	//----- _xZkqqHx_iDhGiDiKiDjDiDfOiCmMiDhGiDiNiDhAiDgFiDeC_xHqqkZx_ -----
	ar << m_bUseDocMarginAsPrn;	// _xZkqqHx_jHhAiOiGiCmMjHfNjEjCjCgMiCpAiOgHiCkEiCkJiBeI_xHqqkZx_
	ar << m_mmPrnPaperMarginL;	// _xZkqqHx_jHhAiOiGiCmMiNlGjHfNjEjCiBeC_xHqqkZx_
	ar << m_mmPrnPaperMarginT;	// _xZkqqHx_jHhAiOiGiCmMiPoDjHfNjEjCiBeC_xHqqkZx_
	ar << m_mmPrnPaperMarginR;	// _xZkqqHx_jHhAiOiGiCmMiJeFjHfNjEjCiBeC_xHqqkZx_
	ar << m_mmPrnPaperMarginB;	// _xZkqqHx_jHhAiOiGiCmMiJlKjHfNjEjCiBeC_xHqqkZx_

	/*-----	S_xZkqqHx_jAeG_xHqqkZx_	-----*/
	MC2SColorRecVector::const_iterator iSColor;
	ar << static_cast<long>(g_vSColor.size());
	for	(iSColor = g_vSColor.begin(); iSColor != g_vSColor.end(); iSColor++)
		(*iSColor).OutStream(ar);

	MC2SColorIDVector::const_iterator iSColorID;
	ar << long(g_vFreqSColor.size());
	for	(iSColorID = g_vFreqSColor.begin();	iSColorID != g_vFreqSColor.end(); iSColorID++)
		ar.Write(&(*iSColorID),	sizeof(*iSColorID));

	/*-----	_xZkqqHx_iDiBiDfOiDhEiDeAiDeDiDiLiDhAiDfOiBfLiDjD_xHqqkZx_ -----*/
	MC2EMFImageRecVector::const_iterator	iEMFImage;
	ar << static_cast<long>(g_vEMFImage.size());
	for	(iEMFImage = g_vEMFImage.begin(); iEMFImage	!= g_vEMFImage.end(); iEMFImage++)
		(*iEMFImage).OutStream(ar);

	MC2EMFImageIDVector::const_iterator iEMFImageID;
	ar << long(g_vFreqEMFImage.size());
	for	(iEMFImageID = g_vFreqEMFImage.begin();	iEMFImageID	!= g_vFreqEMFImage.end(); iEMFImageID++)
		ar.Write(&(*iEMFImageID), sizeof(*iEMFImageID));

	/*-----	_xZkqqHx_jCfAjAeGiDhAiDfOiBfLiDjD_xHqqkZx_._xZkqqHx_jDgIjCnHiClFjHhA_xHqqkZx_ -----*/
	MC2PatternRecVector::const_iterator iPattern;
	ar << static_cast<long>(g_vPattern.size());
	for	(iPattern =	g_vPattern.begin();	iPattern !=	g_vPattern.end(); iPattern++)
		(*iPattern).OutStream(ar);

	MC2PatternIDVector::const_iterator iPatternID;
	ar << long(g_vFreqPattern.size());
	for	(iPatternID	= g_vFreqPattern.begin(); iPatternID !=	g_vFreqPattern.end(); iPatternID++)
		ar.Write(&(*iPatternID), sizeof(*iPatternID));

	/*-----	_xZkqqHx_iDhFiDiJiDfGiCmMjDgPjIfOjGlM_xHqqkZx_ -----*/
	MC2BrushRegisterRecVector::const_iterator iBrushRegister;
	ar << static_cast<long>(g_vBrushRegister.size());
	for	(iBrushRegister	= g_vBrushRegister.begin();	iBrushRegister != g_vBrushRegister.end(); iBrushRegister++)
		(*iBrushRegister).OutStream(ar);

	MC2BrushRegisterIDVector::const_iterator	iBrushRegisterID;
	ar << long(g_vFreqBrushRegister.size());
	for	(iBrushRegisterID =	g_vFreqBrushRegister.begin(); iBrushRegisterID != g_vFreqBrushRegister.end(); iBrushRegisterID++)
		ar.Write(&(*iBrushRegisterID), sizeof(*iBrushRegisterID));

	/*-----	_xZkqqHx_iDhJiDjDiCmMjDgPjIfOjGlM_xHqqkZx_ -----*/
	MC2PenRegisterRecVector::const_iterator iPenRegister;
	ar << static_cast<long>(g_vPenRegister.size());
	for	(iPenRegister =	g_vPenRegister.begin();	iPenRegister !=	g_vPenRegister.end(); iPenRegister++)
		(*iPenRegister).OutStream(ar);

	MC2PenRegisterIDVector::const_iterator iPenRegisterID;
	ar << long(g_vFreqPenRegister.size());
	for	(iPenRegisterID	= g_vFreqPenRegister.begin(); iPenRegisterID !=	g_vFreqPenRegister.end(); iPenRegisterID++)
		ar.Write(&(*iPenRegisterID), sizeof(*iPenRegisterID));

	/*-----	_xZkqqHx_iDhJiDjDiCmMiDfIiDfOiDeDiDiL_xHqqkZx_._xZkqqHx_jClMjApM_xHqqkZx_,_xZkqqHx_jDfPjApM_xHqqkZx_,etc -----*/
	MC2PenStyleRecVector::const_iterator	iPenStyle;
	ar << static_cast<long>(g_vPenStyle.size());
	for	(iPenStyle = g_vPenStyle.begin(); iPenStyle	!= g_vPenStyle.end(); iPenStyle++)
		(*iPenStyle).OutStream(ar);

	MC2PenStyleIDVector::const_iterator iPenStyleID;
	ar << long(g_vFreqPenStyle.size());
	for	(iPenStyleID = g_vFreqPenStyle.begin();	iPenStyleID	!= g_vFreqPenStyle.end(); iPenStyleID++)
		ar.Write(&(*iPenStyleID), sizeof(*iPenStyleID));

	/*-----	S_xZkqqHx_iDhEiDeIiDjDiDgH_xHqqkZx_ -----*/
	MC2SFontRecVector::const_iterator iSFont;
	ar << static_cast<long>(g_vSFont.size());
	for	(iSFont	= g_vSFont.begin();	iSFont != g_vSFont.end(); iSFont++)
		(*iSFont).OutStream(ar);
} // MC2Env::OutStream.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2Env::InStream
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iKmCiLkLiCpAiKmCiLkLiDgFiBfLiDhFiDiLiCnGjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ar	:_xZkqqHx_iDeBiBfLiDeKiDeDiDhF_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.11.09 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *			99.12.16 Fukushiro M. InEnvTbl_xZkqqHx_iCkJiCoHjFmPiNfIiBeC_xHqqkZx_
 *			00.04.05 Fukushiro M. _xZkqqHx_iDhGiDiKiDjDiDfOiPoOjFpBiCmMjDpMjHmNiCpA_xHqqkZx_CMC2MolipDrawApp_xZkqqHx_iCnGiInKjDkOiBeC_xHqqkZx_
 *************************************************************************/
void MC2Env::InStream (MC2ARCHIVE& ar)
{
	// _xZkqqHx_iJgFiCmMjClHiClDiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
	ar.Read(&m_mmptShadowLen, sizeof(m_mmptShadowLen));
	//----- _xZkqqHx_jHhAiOiGiBeFiDhGiDiKiDjDiDfOiPoOjFpBiCpAiPjBiCkLiPgPiClH_xHqqkZx_ -----
	//----- _xZkqqHx_jHhAiOiGiCmMiDhGiDiNiDhAiDgFiDeC_xHqqkZx_ -----
	ar >> m_nDocPaperOrient;	// _xZkqqHx_jHhAiOiGiCmMjFpLiMpMiBeC_xHqqkZx_
	ar >> m_nDocPaperType;		// _xZkqqHx_jCoIiMgAjHhAiOiGiCmMiDfOiDeDiDhGiBeC_xHqqkZx_A4,B5,etc.
	ar >> m_mmDocPaperWidth;	// _xZkqqHx_jHhAiOiGiCmMjFjNiBeCjHhAiOiGiCmMjFpLiMpMiCmNjAeEiCoIiNjOiCnNiNmPiBeC_xHqqkZx_
	ar >> m_mmDocPaperHeight;	// _xZkqqHx_jHhAiOiGiCmMiNiCiClDiBeCjHhAiOiGiCmMjFpLiMpMiCmNjAeEiCoIiNjOiCnNiNmPiBeC_xHqqkZx_
	ar >> m_mmDocPaperMarginL;	// _xZkqqHx_jHhAiOiGiCmMiNlGjHfNjEjCiBeC_xHqqkZx_
	ar >> m_mmDocPaperMarginT;	// _xZkqqHx_jHhAiOiGiCmMiPoDjHfNjEjCiBeC_xHqqkZx_
	ar >> m_mmDocPaperMarginR;	// _xZkqqHx_jHhAiOiGiCmMiJeFjHfNjEjCiBeC_xHqqkZx_
	ar >> m_mmDocPaperMarginB;	// _xZkqqHx_jHhAiOiGiCmMiJlKjHfNjEjCiBeC_xHqqkZx_
	ar >> m_dDocPageTimesX;		// _xZkqqHx_jHhAiOiGjBmOiDhJiBfLiDfHiCmM_xHqqkZx_X_xZkqqHx_jEhLjHkGiBeC_xHqqkZx_
	ar >> m_dDocPageTimesY;		// _xZkqqHx_jHhAiOiGjBmOiDhJiBfLiDfHiCmM_xHqqkZx_Y_xZkqqHx_jEhLjHkGiBeC_xHqqkZx_
	ar.Read(&m_mmrtSheet, sizeof(m_mmrtSheet));	// _xZkqqHx_iDfGiBfLiDgHiCmMjBoFiCkLiClDiBeC_xHqqkZx_
	//----- _xZkqqHx_iDhGiDiKiDjDiDfOiCmMiDhGiDiNiDhAiDgFiDeC_xHqqkZx_ -----
	ar >> m_bUseDocMarginAsPrn;	// _xZkqqHx_jHhAiOiGiCmMjHfNjEjCjCgMiCpAiOgHiCkEiCkJiBeI_xHqqkZx_
	ar >> m_mmPrnPaperMarginL;	// _xZkqqHx_jHhAiOiGiCmMiNlGjHfNjEjCiBeC_xHqqkZx_
	ar >> m_mmPrnPaperMarginT;	// _xZkqqHx_jHhAiOiGiCmMiPoDjHfNjEjCiBeC_xHqqkZx_
	ar >> m_mmPrnPaperMarginR;	// _xZkqqHx_jHhAiOiGiCmMiJeFjHfNjEjCiBeC_xHqqkZx_
	ar >> m_mmPrnPaperMarginB;	// _xZkqqHx_jHhAiOiGiCmMiJlKjHfNjEjCiBeC_xHqqkZx_

	/*-----	S_xZkqqHx_jAeG_xHqqkZx_	-----*/
	long lSColor;
	ar >> lSColor;
	while (0 < lSColor--)
	{
		MC2SColorRec	recSColor;
		recSColor.InStream(ar);
		g_vSColor.push_back(recSColor);
	}

	FD2SColorID scid;
	ar >> lSColor;
	while (0 < lSColor--)
	{
		ar.Read(&scid, sizeof(scid));
		g_vFreqSColor.push_back(scid);
	}

	/*-----	_xZkqqHx_iDiBiDfOiDhEiDeAiDeDiDiLiDhAiDfOiBfLiDjD_xHqqkZx_ -----*/
	long lEMFImage;
	ar >> lEMFImage;
	while (0 < lEMFImage--)
	{
		MC2EMFImageRec recEMFImage;
		recEMFImage.InStream(ar);
		g_vEMFImage.push_back(recEMFImage);
	}

	FD2EMFImageID emid;
	ar >> lEMFImage;
	while (0 < lEMFImage--)
	{
		ar.Read(&emid, sizeof(emid));
		g_vFreqEMFImage.push_back(emid);
	}

	/*-----	_xZkqqHx_jCfAjAeGiDhAiDfOiBfLiDjD_xHqqkZx_._xZkqqHx_jDgIjCnHiClFjHhA_xHqqkZx_ -----*/
	long lPattern;
	ar >> lPattern;
	while (0 < lPattern--)
	{
		MC2PatternRec recPattern;
		recPattern.InStream(ar);
		g_vPattern.push_back(recPattern);
	}

	FD2PatternID ptid;
	ar >> lPattern;
	while (0 < lPattern--)
	{
		ar.Read(&ptid, sizeof(ptid));
		g_vFreqPattern.push_back(ptid);
	}

	/*-----	_xZkqqHx_iDhFiDiJiDfGiCmMjDgPjIfOjGlM_xHqqkZx_ -----*/
	long lBrushRegister;
	ar >> lBrushRegister;
	while (0 < lBrushRegister--)
	{
		MC2BrushRegisterRec recBrushRegister;
		recBrushRegister.InStream(ar);
		g_vBrushRegister.push_back(recBrushRegister);
	}

	FD2BrushRegisterID	brid;
	ar >> lBrushRegister;
	while (0 < lBrushRegister--)
	{
		ar.Read(&brid, sizeof(brid));
		g_vFreqBrushRegister.push_back(brid);
	}

	/*-----	_xZkqqHx_iDhJiDjDiCmMjDgPjIfOjGlM_xHqqkZx_ -----*/
	long lPenRegister;
	ar >> lPenRegister;
	while (0 < lPenRegister--)
	{
		MC2PenRegisterRec recPenRegister;
		recPenRegister.InStream(ar);
		g_vPenRegister.push_back(recPenRegister);
	}

	FD2PenRegisterID prid;
	ar >> lPenRegister;
	while (0 < lPenRegister--)
	{
		ar.Read(&prid, sizeof(prid));
		g_vFreqPenRegister.push_back(prid);
	}

	/*-----	_xZkqqHx_iDhJiDjDiCmMiDfIiDfOiDeDiDiL_xHqqkZx_._xZkqqHx_jClMjApM_xHqqkZx_,_xZkqqHx_jDfPjApM_xHqqkZx_,etc -----*/
	long lPenStyle;
	ar >> lPenStyle;
	while (0 < lPenStyle--)
	{
		MC2PenStyleRec recPenStyle;
		recPenStyle.InStream(ar);
		g_vPenStyle.push_back(recPenStyle);
	}

	FD2PenStyleID psid;
	ar >> lPenStyle;
	while (0 < lPenStyle--)
	{
		ar.Read(&psid, sizeof(psid));
		g_vFreqPenStyle.push_back(psid);
	}

	/*-----	S_xZkqqHx_iDhEiDeIiDjDiDgH_xHqqkZx_ -----*/
	long lSFont;
	ar >> lSFont;
	while (0 < lSFont--)
	{
		MC2SFontRec recSFont;
		recSFont.InStream(ar);
		g_vSFont.push_back(recSFont);
	}

} // MC2Env::InStream.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2Env::GetDocPageSize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhJiBfLiDfHiCmMjBoFiCkLiClDiCpAiMhGiOfKiClFiCmEjFnEiClHiBeCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmPageWidth		:_xZkqqHx_iDhJiBfLiDfHiCmMjFjNiCpAjFnEiClHiBeC_xHqqkZx_
 *			mmPageHeight	:_xZkqqHx_iDhJiBfLiDfHiCmMiNiCiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.12.15 Fukushiro M. FoundDoc_xZkqqHx_iCkJiCoHiInKjDkOiBeC_xHqqkZx_
 *			00.02.10 Fukushiro M. _xZkqqHx_iMhGiOfKiClFiCmEjFnEiClHiCoGiCkEiCmJjFmPiNfIiBeC_xHqqkZx_
 *************************************************************************/
void MC2Env::GetDocPageSize (double& mmPageWidth, double& mmPageHeight)
{
	mmPageWidth = m_dDocPageTimesX * (m_mmDocPaperWidth -
									m_mmDocPaperMarginL - m_mmDocPaperMarginR);
	mmPageHeight = m_dDocPageTimesY * (m_mmDocPaperHeight -
									m_mmDocPaperMarginT - m_mmDocPaperMarginB);
} // MC2Env::GetDocPageSize.

