#ifndef __Env_h
#define __Env_h

#define MD2_FD_COLOR_WHITE	static_cast<FD2SColorID>(0)
#define MD2_FD_COLOR_BLACK	static_cast<FD2SColorID>(1)

#define MD2_FD_NO_EMFIMAGE	0xfff	// FD2EMFImageID_xZkqqHx_iCmMiBeBiDeDiDiBiBfLiDfHjEpBjAnNjCoIjCgMiBeC_xHqqkZx_

typedef WORD		FD2SColorID;
typedef BYTE		FD2PatternID;
typedef WORD		FD2EMFImageID;
typedef BYTE		FD2PenStyleID;
typedef FD2SColorID	FD2PenRegisterID;
typedef FD2SColorID	FD2BrushRegisterID;
typedef WORD		FD2SFontID;

// MC2ObjBase_xZkqqHx_iCoGiCoIiInKjDkOiBeC_xHqqkZx_Util.h_xZkqqHx_jCiGiCmFiOgHiCkEiClNiCnPiBeC_xHqqkZx_
enum FTPenType
{
	FDPT_NONE	= 0xff,	// _xZkqqHx_jFhDjCoIiBeC_xHqqkZx_
	FDPT_SOLID	= 0,	// _xZkqqHx_iPiDjAeGiBeC_xHqqkZx_
	FDPT_TRANSP,		// _xZkqqHx_jDkHjGlOiBeC_xHqqkZx_
	FDPT_PATTERN,		// _xZkqqHx_iDhAiDfOiBfLiDjDiBeC_xHqqkZx_
	FDPT_REGIST			// _xZkqqHx_jDgPjIfOjAnNjCoIiBeC_xHqqkZx_
};

enum FTBrushType
{
	FDBT_NONE	= 0xff,	// _xZkqqHx_jFhDjCoIiBeC_xHqqkZx_
	FDBT_SOLID	= 0,	// _xZkqqHx_iPiDjAeGjDgIjCnHiClFiBeC_xHqqkZx_
	FDBT_TRANSP,		// _xZkqqHx_jDkHjGlOiBeC_xHqqkZx_
	FDBT_PATTERN,		// _xZkqqHx_iDhAiDfOiBfLiDjDiBeC_xHqqkZx_
	FDBT_REGIST			// _xZkqqHx_jDgPjIfOjAnNjCoIiBeC_xHqqkZx_
};

// _xZkqqHx_jDgIiCoIiCmCiCnEiClFjHhAjCfAjAeGiDhAiDfOiBfLiDjDiCmM_xHqqkZx_DIB_xZkqqHx_jHhAiBeC_xHqqkZx_
struct MC2DIBMono8x8
{
	BITMAPINFOHEADER	bmiHeader;
	RGBQUAD				bmiColors[2];	// _xZkqqHx_jCfAjAeGjHhAiBeC_xHqqkZx_
	BYTE				data[32];		// _xZkqqHx_jCfAjAeG_xHqqkZx_8x8pixels_xZkqqHx_jHhAiBeC_xHqqkZx_x_xZkqqHx_jFpLiMpMiCmN_xHqqkZx_32(4Byte)
										// _xZkqqHx_iCkKiNmFiPkMiCmMiClNiCnPiBeB_xHqqkZx_4x8Byte_xZkqqHx_iCmGiCmIiCoJiBeC_xHqqkZx_
};

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	MC2SColorRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jDgPjIfOjAeGiCmMiKmHjHjNiDiMiDfCiBfLiDgIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.30 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkMiBeC_xHqqkZx_
 *************************************************************************/
class MC2SColorRec
{
public:
	MC2SColorRec () {}
	MC2SColorRec (const COLORREF colRef, const char* pName) :m_colRef(colRef)
		{
			if (m_sName != pName) _tcscpy(m_sName, pName);
		}
	BOOL operator == (const MC2SColorRec& rec) const
		{
			return (m_colRef == rec.m_colRef) &&
					(_tcscmp(m_sName, rec.m_sName) == 0);
		}
	void OutStream (MC2ARCHIVE& ar) const
		{
			ar << m_colRef;
			// _xZkqqHx_jDgPjIfOjGlMiBeC_xHqqkZx_
			const BYTE byNameLen = _tcslen(m_sName);
			ar << byNameLen;
			ar.Write(m_sName, byNameLen);
		}
	void InStream (MC2ARCHIVE& ar)
		{
			ar >> m_colRef;
			// _xZkqqHx_jDgPjIfOjGlMiBeC_xHqqkZx_
			BYTE byNameLen;
			ar >> byNameLen;
//----- 06.03.26 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
			// _xZkqqHx_jAkHiMmAjClHiCpAjClEiCkGiCoJiPoKiNiHiCmNiBeBjEgKjBlJiBeC_xHqqkZx_
			if (MD2_FD_ENV_NAME_LEN <= byNameLen)
				FFUtilErrI->ThrowMiscExceptionCode(FD_IDS_ERR_FILE_DESTROIED);
//----- 06.03.26 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
			ar.Read(m_sName, byNameLen);
			m_sName[byNameLen] = _T('\0');
		}
	void Clear () {}
public:
	COLORREF	m_colRef;
	char		m_sName[MD2_FD_ENV_NAME_LEN];
}; // class MC2SColorRec.

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	MC2PatternRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiCiDgNiDeOiDiNiCmMjDgIiCoIjCnHiClFjHhAiDhAiDfOiBfLiDjDiDhCiDgCiDgHiDhNiDgCiDhG_xHqqkZx_.
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	m_pDIB_xZkqqHx_iCmN_xHqqkZx_ new _xZkqqHx_iIlNiCmN_xHqqkZx_ malloc_xZkqqHx_iCmFiKgNjFnLiClDiCoKiClNjHmMiIoGiCmFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
 *			_xZkqqHx_iCmIiClKiCmIiCoHiBeB_xHqqkZx_CBrush::CreateDIBPatternBrush_xZkqqHx_jCiGiCmF_xHqqkZx_ GlobalLock_xZkqqHx_iKnGjAjEiCmM_xHqqkZx_
 *			_xZkqqHx_iIpIjAjEiCmGiClFiCmEiOgHiCoNiCoKiCoJiCkJiCoHiCmFiCkAiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.11.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
class MC2PatternRec
{
public:
	MC2PatternRec ()
	{
		m_pDIB = NULL;
		m_sName[0] = _T('\0');
	}
	MC2PatternRec (MC2DIBMono8x8* pDIB, const char* pName)
		{
			m_pDIB = pDIB;
			if (m_sName != pName) _tcscpy(m_sName, pName);
		}
	BOOL operator == (const MC2PatternRec& rec) const
		{
			return (memcmp(m_pDIB, rec.m_pDIB, sizeof(*m_pDIB)) == 0) &&
					(_tcscmp(m_sName, rec.m_sName) == 0);
		}
	void OutStream (MC2ARCHIVE& ar) const
		{
			ar.Write(m_pDIB, sizeof(MC2DIBMono8x8));
			// _xZkqqHx_jDgPjIfOjGlMiBeC_xHqqkZx_
			const BYTE byNameLen = _tcslen(m_sName);
			ar << byNameLen;
			ar.Write(m_sName, byNameLen);
		}
	void InStream (MC2ARCHIVE& ar)
		{
			if (m_pDIB != NULL) delete m_pDIB;
			m_pDIB = new MC2DIBMono8x8;
			ar.Read(m_pDIB, sizeof(MC2DIBMono8x8));
			// _xZkqqHx_jDgPjIfOjGlMiBeC_xHqqkZx_
			BYTE byNameLen;
			ar >> byNameLen;
//----- 06.03.26 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
			// _xZkqqHx_jAkHiMmAjClHiCpAjClEiCkGiCoJiPoKiNiHiCmNiBeBjEgKjBlJiBeC_xHqqkZx_
			if (MD2_FD_ENV_NAME_LEN <= byNameLen)
				FFUtilErrI->ThrowMiscExceptionCode(FD_IDS_ERR_FILE_DESTROIED);
//----- 06.03.26 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
			ar.Read(m_sName, byNameLen);
			m_sName[byNameLen] = _T('\0');
		}
	void Clear ()
		{
			if (m_pDIB != NULL) delete m_pDIB;
			m_pDIB = NULL;
		}
public:
	MC2DIBMono8x8*	m_pDIB;
	char			m_sName[MD2_FD_ENV_NAME_LEN];
}; // class MC2PatternRec.

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	MC2PenStyleRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhJiDjDiCmMiDfIiDfOiDeDiDiLiBgJjIeBjBlBjApMiBeBjDfPjApMjDjJiBgKiCpAiKmHjHjNiClHiCoJiDiMiDfCiBfLiDgIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.30 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkMiBeC_xHqqkZx_
 *			99.06.29 Fukushiro M. _xZkqqHx_iDhAiDfOiBfLiDjDiCpAiOmAiNmAjFfHiMgOiCnGjFmPiNfIiBeC_xHqqkZx_
 *************************************************************************/
class MC2PenStyleRec
{
public:
	MC2PenStyleRec () {}
	MC2PenStyleRec (const fmmetol* aData, const char* pName)
		{
			if (m_mmfaData != aData) memcpy(m_mmfaData, aData, sizeof(fmmetol[4]));
			if (m_sName != pName) _tcscpy(m_sName, pName);
		}
	BOOL operator == (const MC2PenStyleRec& rec) const
		{
			return (memcmp(m_mmfaData, rec.m_mmfaData, sizeof(m_mmfaData)) == 0) &&
					(_tcscmp(m_sName, rec.m_sName) == 0);
		}
	void OutStream (MC2ARCHIVE& ar) const
		{
			ar.Write(m_mmfaData, sizeof(m_mmfaData));
			// _xZkqqHx_jDgPjIfOjGlMiBeC_xHqqkZx_
			const BYTE byNameLen = _tcslen(m_sName);
			ar << byNameLen;
			ar.Write(m_sName, byNameLen);
		}
	void InStream (MC2ARCHIVE& ar)
		{
			ar.Read(m_mmfaData, sizeof(m_mmfaData));
			// _xZkqqHx_jDgPjIfOjGlMiBeC_xHqqkZx_
			BYTE byNameLen;
			ar >> byNameLen;
//----- 06.03.26 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
			// _xZkqqHx_jAkHiMmAjClHiCpAjClEiCkGiCoJiPoKiNiHiCmNiBeBjEgKjBlJiBeC_xHqqkZx_
			if (MD2_FD_ENV_NAME_LEN <= byNameLen)
				FFUtilErrI->ThrowMiscExceptionCode(FD_IDS_ERR_FILE_DESTROIED);
//----- 06.03.26 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
			ar.Read(m_sName, byNameLen);
			m_sName[byNameLen] = _T('\0');
		}
	void Clear () {}
public:
	fmmetol	m_mmfaData[4];
	char	m_sName[MD2_FD_ENV_NAME_LEN];
}; // class MC2PenStyleRec.

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	MC2PenRegisterRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jDgPjIfOiDhJiDjDiCpAiKmHjHjNiClHiCoJiDiMiDfCiBfLiDgIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.30 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkMiBeC_xHqqkZx_
 *************************************************************************/
class MC2PenRegisterRec
{
public:
	MC2PenRegisterRec ();
	MC2PenRegisterRec (	BYTE			byPenType,
						FD2PenStyleID		psidPenStyle,
						FD2PatternID		ptidPenPattern,
						fmmetol			mmfPenWeight,
						FD2SColorID		scidPenForeSColor,
						FD2SColorID		scidPenBackSColor,
						const char*	pName);
	BOOL operator == (const MC2PenRegisterRec& rec) const;
	void OutStream (MC2ARCHIVE& ar) const;
	void InStream (MC2ARCHIVE& ar);
	void Clear () {}

	static BOOL IsPenRegisterEffect (BYTE byPenType);
	static BOOL IsPenStyleEffect (BYTE byPenType);
	static BOOL IsPenPatternEffect (BYTE byPenType);
	static BOOL IsPenWeightEffect (BYTE byPenType);
	static BOOL IsPenForeSColorEffect (BYTE byPenType);
	static BOOL IsPenBackSColorEffect (BYTE byPenType);

public:
	BYTE		m_byPenType;		// PEN_xZkqqHx_iCmMiMfOiBeCjGhLjHiI_xHqqkZx_4bit.
	FD2PenStyleID	m_psidPenStyle;		// PEN_xZkqqHx_iCmMiDfIiDfOiDeDiDiLiBeC_xHqqkZx_
	union {
		FD2PatternID		m_ptidPenPattern;	// PEN_xZkqqHx_iCmMiDiCiDgNiDhAiDfOiBfLiDjD_xHqqkZx_.
	};
	fmmetol		m_mmfPenWeight;		// PEN_xZkqqHx_iCmMjFjNiBeC_xHqqkZx_
	FD2SColorID	m_scidPenForeSColor;// PEN_xZkqqHx_iCmMjBePiMgJjAeGiBeC_xHqqkZx_
	FD2SColorID	m_scidPenBackSColor;// PEN_xZkqqHx_iCmMjEhHiMgJjAeGiBeC_xHqqkZx_
	char		m_sName[MD2_FD_ENV_NAME_LEN];
									// _xZkqqHx_iClBiCmMjDgPjIfO_xHqqkZx_PEN_xZkqqHx_iCmMjGlMjBePiBeC_xHqqkZx_
}; // class MC2PenRegisterRec.

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	MC2BrushRegisterRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jDgPjIfOiDhFiDiJiDfGiCpAiKmHjHjNiClHiCoJiDiMiDfCiBfLiDgIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.30 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkMiBeC_xHqqkZx_
 *************************************************************************/
class MC2BrushRegisterRec
{
public:
	MC2BrushRegisterRec ();
	MC2BrushRegisterRec (BYTE			byBrushType,
						FD2PatternID		ptidBrushPattern,
						FD2SColorID		scidBrushForeSColor,
						FD2SColorID		scidBrushBackSColor,
						const char*	pName);
	BOOL operator == (const MC2BrushRegisterRec& rec) const;
	void OutStream (MC2ARCHIVE& ar) const;
	void InStream (MC2ARCHIVE& ar);
	void Clear () {}

	static BOOL IsBrushRegisterEffect (BYTE byBrushType);
	static BOOL IsBrushPatternEffect (BYTE byBrushType);
	static BOOL IsBrushForeSColorEffect (BYTE byBrushType);
	static BOOL IsBrushBackSColorEffect (BYTE byBrushType);

public:
	BYTE		m_byBrushType;			// BRUSH_xZkqqHx_iCmMiMfOiBeCjGhLjHiI_xHqqkZx_4bit.
	union {
		FD2PatternID		m_ptidBrushPattern;		// BRUSH_xZkqqHx_iCmMiDiCiDgNiDhAiDfOiBfLiDjD_xHqqkZx_
	};
	union {
		FD2SColorID	m_scidBrushForeSColor;	// BRUSH_xZkqqHx_iCmMjBePiMgJjAeGiBeC_xHqqkZx_
	};
	union {
		FD2SColorID	m_scidBrushBackSColor;	// BRUSH_xZkqqHx_iCmMjEhHiMgJjAeGiBeC_xHqqkZx_
	};
	char		m_sName[MD2_FD_ENV_NAME_LEN];	// _xZkqqHx_iClBiCmMjDgPjIfO_xHqqkZx_BRUSH_xZkqqHx_iCmMjGlMjBePiBeC_xHqqkZx_
}; // class MC2BrushRegisterRec.

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	MC2EMFImageRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDfOiDhEiDeAiDeDiDiLiCmMiKmHjHjNjHhAiDiMiDfCiBfLiDgIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
class MC2EMFImageRec
{
public:
	MC2EMFImageRec ()
		{
			m_bypBits = NULL;
			m_lBitSize = 0;
			m_sName[0] = _T('\0');
		}
	MC2EMFImageRec (BYTE* bypBits, long lBitSize, const char* pName)
		{
			m_bypBits = bypBits;
			m_lBitSize = lBitSize;
			if (m_sName != pName) _tcscpy(m_sName, pName);
		}
	BOOL operator == (const MC2EMFImageRec& rec) const
		{
			return  (m_lBitSize == rec.m_lBitSize) &&
					(memcmp(m_bypBits, rec.m_bypBits, m_lBitSize) == 0) &&
					(_tcscmp(m_sName, rec.m_sName) == 0);
		}
	void OutStream (MC2ARCHIVE& ar) const
		{
			ar << m_lBitSize;					// m_bypBits_xZkqqHx_iCmMiDgPiDgCiDhEiDeAiDfEiDeDiDfJiBeC_xHqqkZx_
			ar.Write(m_bypBits, m_lBitSize);	// _xZkqqHx_iDiBiDfOiDhEiDeAiDeDiDiLiCmMiDhCiDgCiDgHjHpBiDgPiDgCiDhEiDeAiBeC_xHqqkZx_
			// _xZkqqHx_jDgPjIfOjGlMiBeC_xHqqkZx_
			const BYTE byNameLen = _tcslen(m_sName);
			ar << byNameLen;
			ar.Write(m_sName, byNameLen);
		}
	void InStream (MC2ARCHIVE& ar)
		{
			ar >> m_lBitSize;					// m_bypBits_xZkqqHx_iCmMiDgPiDgCiDhEiDeAiDfEiDeDiDfJiBeC_xHqqkZx_
			if (m_bypBits != NULL) delete[] m_bypBits;
			m_bypBits = new BYTE[m_lBitSize];
			ar.Read(m_bypBits, m_lBitSize);		// _xZkqqHx_iDiBiDfOiDhEiDeAiDeDiDiLiCmMiDhCiDgCiDgHjHpBiDgPiDgCiDhEiDeAiBeC_xHqqkZx_
			// _xZkqqHx_jDgPjIfOjGlMiBeC_xHqqkZx_
			BYTE byNameLen;
			ar >> byNameLen;
//----- 06.03.26 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
			// _xZkqqHx_jAkHiMmAjClHiCpAjClEiCkGiCoJiPoKiNiHiCmNiBeBjEgKjBlJiBeC_xHqqkZx_
			if (MD2_FD_ENV_NAME_LEN <= byNameLen)
				FFUtilErrI->ThrowMiscExceptionCode(FD_IDS_ERR_FILE_DESTROIED);
//----- 06.03.26 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
			ar.Read(m_sName, byNameLen);
			m_sName[byNameLen] = _T('\0');
		}
	void Clear ()
		{
			if (m_bypBits != NULL) delete[] m_bypBits;
			m_bypBits = NULL;
		}

public:
	BYTE*	m_bypBits;					// _xZkqqHx_iDiBiDfOiDhEiDeAiDeDiDiLiCmMiDhCiDgCiDgHjHpBiDgPiDgCiDhEiDeAiBeC_xHqqkZx_
	long	m_lBitSize;					// m_bypBits_xZkqqHx_iCmMiDgPiDgCiDhEiDeAiDfEiDeDiDfJiBeC_xHqqkZx_
	char	m_sName[MD2_FD_ENV_NAME_LEN];	// _xZkqqHx_iClBiCmMiDiBiDfOiDhEiDeAiDeDiDiLiCmMjDgPjIfOjGlMiBeC_xHqqkZx_
}; // class MC2EMFImageRec.

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	MC2SFontRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iChCiDhEiDeIiDjDiDgHiPoOjFpBiCpAiKmHjHjNiClHiCoJiDeOiDiJiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.06 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
class MC2SFontRec
{
public:
	MC2SFontRec ();
	MC2SFontRec (double mmHeight, DWORD dwEffects, BYTE byCharSet,
				BYTE byPitchAndFamily, const CHAR* szFaceName);
	MC2SFontRec (const CHARFORMAT& cf);
	MC2SFontRec (const LOGFONT& lf, double dZoom);
	void	Init (const CHARFORMAT& cf);
	void	Init (const LOGFONT& lf, double dZoom);
	void	operator = (const MC2SFontRec& prop);
	BOOL	operator == (const MC2SFontRec& prop) const;
	void	OutStream (MC2ARCHIVE& ar) const;
	void	InStream (MC2ARCHIVE& ar);
	void	Clear () {}

public:
	double	m_mmFontHeight;	// FONT_xZkqqHx_jAlGjAkMiCmFiOhHjCoIiClHiCoJiNiCiClD_xHqqkZx_(mm)._xZkqqHx_jGhLjDjGiCmMiNiCiClDiCmFiCmNiCmIiCkC_xHqqkZx_.
	DWORD	m_dwEffects;
	BYTE	m_byCharSet;
	BYTE	m_byPitchAndFamily;
	CHAR	m_szFaceName[LF_FACESIZE];

	/*----- _xZkqqHx_iImIiJlKiCmN_xHqqkZx_TEXTMETRIC_xZkqqHx_iCmMiPoOjFpB_xHqqkZx_(mm).KnowHow.doc_xZkqqHx_iCpAiOfBiPmG_xHqqkZx_ -----*/
	double	m_mmTMAscent;
	double	m_mmTMDescent;
	double	m_mmTMInternalLeading;
	double	m_mmTMExternalLeading;
}; // class MC2SFontRec.

typedef vector< MC2SColorRec > MC2SColorRecVector;
typedef vector< MC2PatternRec > MC2PatternRecVector;
typedef vector< MC2EMFImageRec > MC2EMFImageRecVector;
typedef vector< MC2PenStyleRec > MC2PenStyleRecVector;
typedef vector< MC2PenRegisterRec > MC2PenRegisterRecVector;
typedef vector< MC2BrushRegisterRec > MC2BrushRegisterRecVector;
typedef vector< MC2SFontRec > MC2SFontRecVector;
typedef vector< FD2SColorID > MC2SColorIDVector;
typedef vector< FD2PatternID > MC2PatternIDVector;
typedef vector< FD2EMFImageID > MC2EMFImageIDVector;
typedef vector< FD2PenStyleID > MC2PenStyleIDVector;
typedef vector< FD2PenRegisterID > MC2PenRegisterIDVector;
typedef vector< FD2BrushRegisterID > MC2BrushRegisterIDVector;
typedef vector< FD2SFontID > MC2SFontIDVector;

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	MC2Env
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iKmCiLkLiCmJiDeBiDeOiDfKiDfIiClHiCoJiKnGjAjEiCpAjBfDiCmEiDhGiDiNiDgFiDeOiDgHiKnGjAjEiCmJiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.29 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
class MC2Env
{
public:
	static void		ClearEnvTbl ();
	static void		OutStream (MC2ARCHIVE& ar);
	static void		InStream (MC2ARCHIVE& ar);
	//----- _xZkqqHx_iJoGjGmKiBjFiDhGiDiKiDjDiDfOjHhAiOiGiDfEiDeDiDfJiKnGjIeBiKnGjAjE_xHqqkZx_ -----
	static void		GetDocPageSize (double& mmPageWidth, double& mmPageHeight);

protected:
	static DBLPoint	m_mmptShadowLen;		// _xZkqqHx_iJgFiCmMjClHiClDiBeC_xHqqkZx_
	//----- _xZkqqHx_jHhAiOiGiCmMiDhGiDiNiDhAiDgFiDeC_xHqqkZx_ -----
	static short	m_nDocPaperOrient;		// _xZkqqHx_jHhAiOiGiCmMjFpLiMpMiBeC_xHqqkZx_
	static short	m_nDocPaperType;		// _xZkqqHx_jCoIiMgAjHhAiOiGiCmMiDfOiDeDiDhGiBeC_xHqqkZx_ A4,B5,etc.
	static double	m_mmDocPaperWidth;		// _xZkqqHx_jHhAiOiGiCmMjFjNiBeCjHhAiOiGiCmMjFpLiMpMiCmNjAeEiCoIiNjOiCnNiNmPiBeC_xHqqkZx_
	static double	m_mmDocPaperHeight;		// _xZkqqHx_jHhAiOiGiCmMiNiCiClDiBeCjHhAiOiGiCmMjFpLiMpMiCmNjAeEiCoIiNjOiCnNiNmPiBeC_xHqqkZx_
	static double	m_mmDocPaperMarginL;	// _xZkqqHx_jHhAiOiGiCmMiNlGjHfNjEjCiBeC_xHqqkZx_
	static double	m_mmDocPaperMarginT;	// _xZkqqHx_jHhAiOiGiCmMiPoDjHfNjEjCiBeC_xHqqkZx_
	static double	m_mmDocPaperMarginR;	// _xZkqqHx_jHhAiOiGiCmMiJeFjHfNjEjCiBeC_xHqqkZx_
	static double	m_mmDocPaperMarginB;	// _xZkqqHx_jHhAiOiGiCmMiJlKjHfNjEjCiBeC_xHqqkZx_
	static double	m_dDocPageTimesX;		// _xZkqqHx_jHhAiOiGjBmOiDhJiBfLiDfHiCmM_xHqqkZx_X_xZkqqHx_jEhLjHkGiBeC_xHqqkZx_
	static double	m_dDocPageTimesY;		// _xZkqqHx_jHhAiOiGjBmOiDhJiBfLiDfHiCmM_xHqqkZx_Y_xZkqqHx_jEhLjHkGiBeC_xHqqkZx_
	static DBLRect	m_mmrtSheet;			// _xZkqqHx_iDfGiBfLiDgHiCmMjBoFiCkLiClDiBeC_xHqqkZx_
	//----- _xZkqqHx_iDhGiDiKiDjDiDfOiCmMiDhGiDiNiDhAiDgFiDeC_xHqqkZx_ -----
	static BOOL		m_bUseDocMarginAsPrn;	// _xZkqqHx_jHhAiOiGiCmMjHfNjEjCjCgMiCpAiOgHiCkEiCkJiBeI_xHqqkZx_
	static double	m_mmPrnPaperMarginL;	// _xZkqqHx_jHhAiOiGiCmMiNlGjHfNjEjCiBeC_xHqqkZx_
	static double	m_mmPrnPaperMarginT;	// _xZkqqHx_jHhAiOiGiCmMiPoDjHfNjEjCiBeC_xHqqkZx_
	static double	m_mmPrnPaperMarginR;	// _xZkqqHx_jHhAiOiGiCmMiJeFjHfNjEjCiBeC_xHqqkZx_
	static double	m_mmPrnPaperMarginB;	// _xZkqqHx_jHhAiOiGiCmMiJlKjHfNjEjCiBeC_xHqqkZx_
	//----- _xZkqqHx_iDhJiBfLiDfHiCmMiDhGiDiNiDhAiDgFiDeC_xHqqkZx_ -----
	static BOOL		m_bEqPageSheetLt;		// _xZkqqHx_iDhJiBfLiDfHiNlGiPoDiCpAiDfGiBfLiDgHiNlGiPoDiCmJiNiHiCoNiClJiCoJiCkJiBeI_xHqqkZx_
	static BOOL		m_bEqPageSheetRb;		// _xZkqqHx_iDhJiBfLiDfHiJeFiJlKiCpAiDfGiBfLiDgHiJeFiJlKiCmJiNiHiCoNiClJiCoJiCkJiBeI_xHqqkZx_
	static DBLPoint	m_mmptPageLeftTop;		// _xZkqqHx_iDhJiBfLiDfHiNlGiPoDiImKjChFiCmMiNmAjFfHiBeC_xHqqkZx_
	static long		m_lPageColumn;			// _xZkqqHx_iJkBjFpLiMpMiCmJiDhJiBfLiDfHiCpAjFmAiCnHiCoJjHpBjAjEiBeC_xHqqkZx_
	static long		m_lPageLine;			// _xZkqqHx_iPgDjFpLiMpMiCmJiDhJiBfLiDfHiCpAjFmAiCnHiCoJiNhDjAjEiBeC_xHqqkZx_
}; // class MC2Env.

/**********************************************************************
 *                      _xZkqqHx_iDePiDiNiBfLiDgPiDiLjFmPjAjE_xHqqkZx_
 **********************************************************************/

// S_xZkqqHx_jAeG_xHqqkZx_
extern MC2SColorRecVector	g_vSColor;
extern MC2SColorIDVector	g_vFreqSColor;

// _xZkqqHx_iDiBiDfOiDhEiDeAiDeDiDiLiDhAiDfOiBfLiDjD_xHqqkZx_
extern MC2EMFImageRecVector	g_vEMFImage;
extern MC2EMFImageIDVector	g_vFreqEMFImage;

// _xZkqqHx_jCfAjAeGiDhAiDfOiBfLiDjD_xHqqkZx_._xZkqqHx_jDgIjCnHiClFjHhA_xHqqkZx_
extern MC2PatternRecVector	g_vPattern;
extern MC2PatternIDVector	g_vFreqPattern;

// _xZkqqHx_iDhFiDiJiDfGiCmMjDgPjIfOjGlM_xHqqkZx_
extern MC2BrushRegisterRecVector	g_vBrushRegister;
extern MC2BrushRegisterIDVector	g_vFreqBrushRegister;

// _xZkqqHx_iDhJiDjDiCmMjDgPjIfOjGlM_xHqqkZx_
extern MC2PenRegisterRecVector	g_vPenRegister;
extern MC2PenRegisterIDVector	g_vFreqPenRegister;

// _xZkqqHx_iDhJiDjDiCmMiDfIiDfOiDeDiDiL_xHqqkZx_._xZkqqHx_jClMjApM_xHqqkZx_,_xZkqqHx_jDfPjApM_xHqqkZx_,etc
extern MC2PenStyleRecVector	g_vPenStyle;
extern MC2PenStyleIDVector	g_vFreqPenStyle;

// S_xZkqqHx_iDhEiDeIiDjDiDgH_xHqqkZx_
extern MC2SFontRecVector	g_vSFont;

#endif//__Env_h
