#include "stdafx.h"
#include "4Env.h"	// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

MC4Env::MC4Env ()
{
} // MC4Env::MC4Env.

MC4Env::~MC4Env ()
{
	ClearEnvTbl();
} // MC4Env::~MC4Env.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC4Env::ClearEnvTbl
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iKmCiLkLiDgFiBfLiDhFiDiLiCpAiDeOiDiKiDeBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.11.09 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *			99.12.17 Fukushiro M. _xZkqqHx_iInKjDkOiBeC_xHqqkZx_
 *************************************************************************/
void MC4Env::ClearEnvTbl ()
{
	MC4SColorRecVector::iterator	iSColor;
	for	(iSColor = m_vSColor.begin(); iSColor != m_vSColor.end(); iSColor++)
		if (*iSColor !=	NULL) delete *iSColor;
	m_vSColor.clear();
	m_vFreqSColor.clear();

	MC4EmfImageRecVector::iterator iEmfImage;
	for	(iEmfImage = m_vEmfImage.begin(); iEmfImage	!= m_vEmfImage.end(); iEmfImage++)
		if (*iEmfImage != NULL)	delete *iEmfImage;
	m_vEmfImage.clear();
	m_vFreqEmfImage.clear();

	MC4BrushRegisterRecVector::iterator iBrushRegister;
	for	(iBrushRegister	= m_vBrushRegister.begin();	iBrushRegister != m_vBrushRegister.end(); iBrushRegister++)
		if (*iBrushRegister	!= NULL) delete	*iBrushRegister;
	m_vBrushRegister.clear();
	m_vFreqBrushRegister.clear();

	MC4PenRegisterRecVector::iterator iPenRegister;
	for	(iPenRegister =	m_vPenRegister.begin();	iPenRegister !=	m_vPenRegister.end(); iPenRegister++)
		if (*iPenRegister != NULL) delete *iPenRegister;
	m_vPenRegister.clear();
	m_vFreqPenRegister.clear();

	MC4PenStyleRecVector::iterator iPenStyle;
	for	(iPenStyle = m_vPenStyle.begin(); iPenStyle	!= m_vPenStyle.end(); iPenStyle++)
		if (*iPenStyle != NULL)	delete *iPenStyle;
	m_vPenStyle.clear();
	m_vFreqPenStyle.clear();

	MC4SFontRecVector::iterator iSFont;
	for	(iSFont	= m_vSFont.begin();	iSFont != m_vSFont.end(); iSFont++)
		if (*iSFont	!= NULL) delete	*iSFont;
	m_vSFont.clear();
	m_vFreqSFont.clear();

	MC4ChipGroupRecVector::iterator iChipGroup;
	for	(iChipGroup	= m_vChipGroup.begin();	iChipGroup != m_vChipGroup.end(); iChipGroup++)
		if (*iChipGroup	!= NULL) delete	*iChipGroup;
	m_vChipGroup.clear();
	m_vFreqChipGroup.clear();

	MC4ChipRecVector::iterator iChip;
	for	(iChip = m_vChip.begin(); iChip	!= m_vChip.end(); iChip++)
		if (*iChip != NULL)	delete *iChip;
	m_vChip.clear();
	m_vFreqChip.clear();

	MC4PictArrowRecVector::iterator iPictArrow;
	for	(iPictArrow	= m_vPictArrow.begin();	iPictArrow != m_vPictArrow.end(); iPictArrow++)
		if (*iPictArrow	!= NULL) delete	*iPictArrow;
	m_vPictArrow.clear();
	m_vFreqPictArrow.clear();
} // MC4Env::ClearEnvTbl.

void MC4Env::InStream (CArchive& ar)
{
	// _xZkqqHx_jBfDiCmEiCmMiKmCiLkLiCpAiPiJiKpKiJlLiBeC_xHqqkZx_
	ClearEnvTbl();
	// _xZkqqHx_iJgFiCmMjClHiClDiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
	ar.Read(&m_mmptShadowLen, sizeof(m_mmptShadowLen));
	//----- _xZkqqHx_jHhAiOiGiBeFiDhGiDiKiDjDiDfOiPoOjFpBiCpAiPjBiCkLiPgPiClH_xHqqkZx_ -----
	//----- _xZkqqHx_jHhAiOiGiCmMiDhGiDiNiDhAiDgFiDeC_xHqqkZx_ -----
	ar >> m_nDocPaperOrient;	// _xZkqqHx_jHhAiOiGiCmMjFpLiMpMiBeC_xHqqkZx_
	ar >> m_nDocPaperType;		// _xZkqqHx_jCoIiMgAjHhAiOiGiCmMiDfOiDeDiDhGiBeC_xHqqkZx_A4,B5,etc.
	ar >> m_mmDocPaperWidth;	// _xZkqqHx_jHhAiOiGiCmMjFjNiBeCjHhAiOiGiCmMjFpLiMpMiCmNjAeEiCoIiNjOiCnNiNmPiBeC_xHqqkZx_
	ar >> m_mmDocPaperHeight;	// _xZkqqHx_jHhAiOiGiCmMiNiCiClDiBeCjHhAiOiGiCmMjFpLiMpMiCmNjAeEiCoIiNjOiCnNiNmPiBeC_xHqqkZx_
	ar >> m_mmDocPaperMarginL;	// _xZkqqHx_jHhAiOiGiCmMiNlGjHfNjEjCiBeC_xHqqkZx_
	ar >> m_mmDocPaperMarginT;	// _xZkqqHx_jHhAiOiGiCmMiPoDjHfNjEjCiBeC_xHqqkZx_
	ar >> m_mmDocPaperMarginR;	// _xZkqqHx_jHhAiOiGiCmMiJeFjHfNjEjCiBeC_xHqqkZx_
	ar >> m_mmDocPaperMarginB;	// _xZkqqHx_jHhAiOiGiCmMiJlKjHfNjEjCiBeC_xHqqkZx_
	ar >> m_dDocPageTimesX;		// _xZkqqHx_jHhAiOiGjBmOiDhJiBfLiDfHiCmM_xHqqkZx_X_xZkqqHx_jEhLjHkGiBeC_xHqqkZx_
	ar >> m_dDocPageTimesY;		// _xZkqqHx_jHhAiOiGjBmOiDhJiBfLiDfHiCmM_xHqqkZx_Y_xZkqqHx_jEhLjHkGiBeC_xHqqkZx_
	ar.Read(&m_mmrtSheet, sizeof(m_mmrtSheet));	// _xZkqqHx_iDfGiBfLiDgHiCmMjBoFiCkLiClDiBeC_xHqqkZx_
	//----- _xZkqqHx_iDhGiDiKiDjDiDfOiCmMiDhGiDiNiDhAiDgFiDeC_xHqqkZx_ -----
	ar >> m_bUseDocMarginAsPrn;	// _xZkqqHx_jHhAiOiGiCmMjHfNjEjCjCgMiCpAiOgHiCkEiCkJiBeI_xHqqkZx_
	ar >> m_mmPrnPaperMarginL;	// _xZkqqHx_jHhAiOiGiCmMiNlGjHfNjEjCiBeC_xHqqkZx_
	ar >> m_mmPrnPaperMarginT;	// _xZkqqHx_jHhAiOiGiCmMiPoDjHfNjEjCiBeC_xHqqkZx_
	ar >> m_mmPrnPaperMarginR;	// _xZkqqHx_jHhAiOiGiCmMiJeFjHfNjEjCiBeC_xHqqkZx_
	ar >> m_mmPrnPaperMarginB;	// _xZkqqHx_jHhAiOiGiCmMiJlKjHfNjEjCiBeC_xHqqkZx_

	//----- _xZkqqHx_iDhJiBfLiDfHiCmMiDhGiDiNiDhAiDgFiDeC_xHqqkZx_ -----
	ar >> m_bEqPageSheetLt;		// _xZkqqHx_iDhJiBfLiDfHiNlGiPoDiCpAiDfGiBfLiDgHiNlGiPoDiCmJiNiHiCoNiClJiCoJiCkJiBeI_xHqqkZx_
	ar >> m_bEqPageSheetRb;		// _xZkqqHx_iDhJiBfLiDfHiJeFiJlKiCpAiDfGiBfLiDgHiJeFiJlKiCmJiNiHiCoNiClJiCoJiCkJiBeI_xHqqkZx_
	ar >> m_mmptPageLeftTop;	// _xZkqqHx_iDhJiBfLiDfHiNlGiPoDiImKjChFiCmMiNmAjFfHiBeC_xHqqkZx_
	ar >> m_lPageColumn;		// _xZkqqHx_iJkBjFpLiMpMiCmJiDhJiBfLiDfHiCpAjFmAiCnHiCoJjHpBjAjEiBeC_xHqqkZx_
	ar >> m_lPageLine;			// _xZkqqHx_iPgDjFpLiMpMiCmJiDhJiBfLiDfHiCpAjFmAiCnHiCoJiNhDjAjEiBeC_xHqqkZx_

	//----- _xZkqqHx_iDhEiDgCiDfOiCmMiDhGiDiNiDhAiDgFiDeC_xHqqkZx_ -----
//----- 06.02.26 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	ar >> m_dwSheetColor;				// _xZkqqHx_iDfGiBfLiDgHjAeGiCpA_xHqqkZx_FCRegData_xZkqqHx_iCkJiCoHiOoGjDlOiBeC_xHqqkZx_
//	ar >> m_bIsPaintSheetOnPrint;		// _xZkqqHx_iIpDiNpMiOjOiCmJiDfGiBfLiDgHiCpAjDgIiCoJiCkJiBeI_xHqqkZx_
//----- 06.02.26 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	ar >> m_bIsPrintFooter;				// _xZkqqHx_iDhEiDgCiDfOiCpAiIpDiNpMiClHiCoJiCkJiBeI_xHqqkZx_
	ar >> m_byHorzFooterPosition;		// _xZkqqHx_iDhEiDgCiDfOiCmMiImKjChFiBgJjAiFjFlNjFpLiMpMiBgKiBeCiNlGiBiBiCePiBeBjCiGiJjLiBiBiCfAiBeBiJeFiBiBiCfBiBeC_xHqqkZx_
	ar >> m_byVertFooterPosition;		// _xZkqqHx_iDhEiDgCiDfOiCmMiImKjChFiBgJjAiCjClMjFpLiMpMiBgKiBeCiPoDiBiBiCePiBeBjCiGiJjLiBiBiCfAiBeBiJlKiBiBiCfBiBeC_xHqqkZx_
	ar >> m_mmHorzFooterOffset;			// _xZkqqHx_iDhEiDgCiDfOiCmMiDeJiDhEiDfKiDgCiDgHiBgJjAiFjFlNjFpLiMpMiBgKiBeC_xHqqkZx_
	ar >> m_mmVertFooterOffset;			// _xZkqqHx_iDhEiDgCiDfOiCmMiDeJiDhEiDfKiDgCiDgHiBgJjAiCjClMjFpLiMpMiBgKiBeC_xHqqkZx_
	m_fontRecFooter.InStream(ar);		// _xZkqqHx_iDhEiDgCiDfOjHhAiDhEiDeIiDjDiDgHiBeC_xHqqkZx_
	ar >> m_scidFooter;					// _xZkqqHx_iDhEiDgCiDfOjHhAjAeGiBeC_xHqqkZx_
// 06.05.11 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	ar.ReadString(m_wstrFooterText);	// _xZkqqHx_iDhEiDgCiDfOiDgFiDeMiDfIiDgHiBeC_xHqqkZx_
	ReadString(ar, m_wstrFooterText);	// _xZkqqHx_iDhEiDgCiDfOiDgFiDeMiDfIiDgHiBeC_xHqqkZx_

	//-----	S_xZkqqHx_jAeG_xHqqkZx_	-----
	long lSColor;
	SColorID scid;
	ar >> lSColor;
	while (0 < lSColor--)
	{
		ar.Read(&scid, sizeof(scid));
		m_vFreqSColor.push_back(scid);
		MC4SColorRec* pRecSColor	= new MC4SColorRec;
		pRecSColor->InStream(ar);
		if (m_vSColor.size() <=	scid)
			m_vSColor.resize(scid +	1, NULL);
		m_vSColor[scid]	= pRecSColor;
	}

	//-----	_xZkqqHx_iDiBiDfOiDhEiDeAiDeDiDiLiDhAiDfOiBfLiDjD_xHqqkZx_ -----
	long lEmfImage;
	EmfImageID emid;
	ar >> lEmfImage;
	while (0 < lEmfImage--)
	{
		ar.Read(&emid, sizeof(emid));
		m_vFreqEmfImage.push_back(emid);
		MC4EmfImageRec* pRecEmfImage	= new MC4EmfImageRec;
		pRecEmfImage->InStream(ar);
		if (m_vEmfImage.size() <= emid)
			m_vEmfImage.resize(emid	+ 1, NULL);
		m_vEmfImage[emid] =	pRecEmfImage;
	}

	//-----	_xZkqqHx_iDhFiDiJiDfGiCmMjDgPjIfOjGlM_xHqqkZx_ -----
	long lBrushRegister;
	BrushRegisterID	brid;
	ar >> lBrushRegister;
	while (0 < lBrushRegister--)
	{
		ar.Read(&brid, sizeof(brid));
		m_vFreqBrushRegister.push_back(brid);
		MC4BrushRegisterRec*	pRecBrushRegister =	new	MC4BrushRegisterRec;
		pRecBrushRegister->InStream(ar);
		if (m_vBrushRegister.size()	<= brid)
			m_vBrushRegister.resize(brid + 1, NULL);
		m_vBrushRegister[brid] = pRecBrushRegister;
	}

	//-----	_xZkqqHx_iDhJiDjDiCmMjDgPjIfOjGlM_xHqqkZx_ -----
	long lPenRegister;
	PenRegisterID prid;
	ar >> lPenRegister;
	while (0 < lPenRegister--)
	{
		ar.Read(&prid, sizeof(prid));
		m_vFreqPenRegister.push_back(prid);
		MC4PenRegisterRec* pRecPenRegister =	new	MC4PenRegisterRec;
		pRecPenRegister->InStream(ar);
		if (m_vPenRegister.size() <= prid)
			m_vPenRegister.resize(prid + 1,	NULL);
		m_vPenRegister[prid] = pRecPenRegister;
	}

	//-----	_xZkqqHx_iDhJiDjDiCmMiDfIiDfOiDeDiDiL_xHqqkZx_(_xZkqqHx_jClMjApM_xHqqkZx_,_xZkqqHx_jDfPjApM_xHqqkZx_,etc) -----
	long lPenStyle;
	PenStyleID psid;
	ar >> lPenStyle;
	while (0 < lPenStyle--)
	{
		ar.Read(&psid, sizeof(psid));
		m_vFreqPenStyle.push_back(psid);
		MC4PenStyleRec* pRecPenStyle	= new MC4PenStyleRec;
		pRecPenStyle->InStream(ar);
		if (m_vPenStyle.size() <= psid)
			m_vPenStyle.resize(psid	+ 1, NULL);
		m_vPenStyle[psid] =	pRecPenStyle;
	}

	//-----	S_xZkqqHx_iDhEiDeIiDjDiDgH_xHqqkZx_ -----
	long lSFont;
	SFontID	foid;
	ar >> lSFont;
	while (0 < lSFont--)
	{
		ar.Read(&foid, sizeof(foid));
		m_vFreqSFont.push_back(foid);
		MC4SFontRec*	pRecSFont =	new	MC4SFontRec;
		pRecSFont->InStream(ar);
		if (m_vSFont.size()	<= foid)
			m_vSFont.resize(foid + 1, NULL);
		m_vSFont[foid] = pRecSFont;
	}

	//-----	_xZkqqHx_iDgAiDgCiDhGiDePiDiLiBfLiDhG_xHqqkZx_ -----
	long lChipGroup;
	ChipGroupID	cgid;
	ar >> lChipGroup;
	while (0 < lChipGroup--)
	{
		ar.Read(&cgid, sizeof(cgid));
		m_vFreqChipGroup.push_back(cgid);
		MC4ChipGroupRec*	pRecChipGroup =	new	MC4ChipGroupRec;
		pRecChipGroup->InStream(ar);
		if (m_vChipGroup.size()	<= cgid)
			m_vChipGroup.resize(cgid + 1, NULL);
		m_vChipGroup[cgid] = pRecChipGroup;
	}

	//-----	_xZkqqHx_iDgAiDgCiDhG_xHqqkZx_ -----
	long lChip;
	ChipID cpid;
	ar >> lChip;
	while (0 < lChip--)
	{
		ar.Read(&cpid, sizeof(cpid));
		m_vFreqChip.push_back(cpid);
		if (cpid !=	FD_CHIP_UNSPECIFY)
		{
			MC4ChipRec* pRecChip	= new MC4ChipRec;
			pRecChip->InStream(ar);
			if (m_vChip.size() <= cpid)
				m_vChip.resize(cpid	+ 1, NULL);
			m_vChip[cpid] =	pRecChip;
		}
	}

	//-----	_xZkqqHx_iDhDiDeOiDgAiDiDjGoOiIpD_xHqqkZx_ -----
	long lPictArrow;
	PictArrowID	paid;
	ar >> lPictArrow;
	while (0 < lPictArrow--)
	{
		ar.Read(&paid, sizeof(paid));
		m_vFreqPictArrow.push_back(paid);
		MC4PictArrowRec*	pRecPictArrow =	new	MC4PictArrowRec;
		pRecPictArrow->InStream(ar);
		if (m_vPictArrow.size()	<= paid)
			m_vPictArrow.resize(paid + 1, NULL);
		m_vPictArrow[paid] = pRecPictArrow;
	}
} // MC4Env::InStream.

void MC4Env::OutStream (CArchive& ar)
{
	// _xZkqqHx_iJgFiCmMjClHiClDiCpAiPjBiCkLiPgPiClHiBeC_xHqqkZx_
	ar.Write(&m_mmptShadowLen, sizeof(m_mmptShadowLen));
	//----- _xZkqqHx_jHhAiOiGiBeFiDhGiDiKiDjDiDfOiPoOjFpBiCpAiPjBiCkLiPgPiClH_xHqqkZx_ -----
	//----- _xZkqqHx_jHhAiOiGiCmMiDhGiDiNiDhAiDgFiDeC_xHqqkZx_ -----
	ar << m_nDocPaperOrient;	// _xZkqqHx_jHhAiOiGiCmMjFpLiMpMiBeC_xHqqkZx_
	ar << m_nDocPaperType;		// _xZkqqHx_jCoIiMgAjHhAiOiGiCmMiDfOiDeDiDhGiBeC_xHqqkZx_A4,B5,etc.
	ar << m_mmDocPaperWidth;	// _xZkqqHx_jHhAiOiGiCmMjFjNiBeCjHhAiOiGiCmMjFpLiMpMiCmNjAeEiCoIiNjOiCnNiNmPiBeC_xHqqkZx_
	ar << m_mmDocPaperHeight;	// _xZkqqHx_jHhAiOiGiCmMiNiCiClDiBeCjHhAiOiGiCmMjFpLiMpMiCmNjAeEiCoIiNjOiCnNiNmPiBeC_xHqqkZx_
	ar << m_mmDocPaperMarginL;	// _xZkqqHx_jHhAiOiGiCmMiNlGjHfNjEjCiBeC_xHqqkZx_
	ar << m_mmDocPaperMarginT;	// _xZkqqHx_jHhAiOiGiCmMiPoDjHfNjEjCiBeC_xHqqkZx_
	ar << m_mmDocPaperMarginR;	// _xZkqqHx_jHhAiOiGiCmMiJeFjHfNjEjCiBeC_xHqqkZx_
	ar << m_mmDocPaperMarginB;	// _xZkqqHx_jHhAiOiGiCmMiJlKjHfNjEjCiBeC_xHqqkZx_
	ar << m_dDocPageTimesX;		// _xZkqqHx_jHhAiOiGjBmOiDhJiBfLiDfHiCmM_xHqqkZx_X_xZkqqHx_jEhLjHkGiBeC_xHqqkZx_
	ar << m_dDocPageTimesY;		// _xZkqqHx_jHhAiOiGjBmOiDhJiBfLiDfHiCmM_xHqqkZx_Y_xZkqqHx_jEhLjHkGiBeC_xHqqkZx_
	ar.Write(&m_mmrtSheet, sizeof(m_mmrtSheet));	// _xZkqqHx_iDfGiBfLiDgHiCmMjBoFiCkLiClDiBeC_xHqqkZx_
	//----- _xZkqqHx_iDhGiDiKiDjDiDfOiCmMiDhGiDiNiDhAiDgFiDeC_xHqqkZx_ -----
	ar << m_bUseDocMarginAsPrn;	// _xZkqqHx_jHhAiOiGiCmMjHfNjEjCjCgMiCpAiOgHiCkEiCkJiBeI_xHqqkZx_
	ar << m_mmPrnPaperMarginL;	// _xZkqqHx_jHhAiOiGiCmMiNlGjHfNjEjCiBeC_xHqqkZx_
	ar << m_mmPrnPaperMarginT;	// _xZkqqHx_jHhAiOiGiCmMiPoDjHfNjEjCiBeC_xHqqkZx_
	ar << m_mmPrnPaperMarginR;	// _xZkqqHx_jHhAiOiGiCmMiJeFjHfNjEjCiBeC_xHqqkZx_
	ar << m_mmPrnPaperMarginB;	// _xZkqqHx_jHhAiOiGiCmMiJlKjHfNjEjCiBeC_xHqqkZx_

	//----- _xZkqqHx_iDhJiBfLiDfHiCmMiDhGiDiNiDhAiDgFiDeC_xHqqkZx_ -----
	ar << m_bEqPageSheetLt;		// _xZkqqHx_iDhJiBfLiDfHiNlGiPoDiCpAiDfGiBfLiDgHiNlGiPoDiCmJiNiHiCoNiClJiCoJiCkJiBeI_xHqqkZx_
	ar << m_bEqPageSheetRb;		// _xZkqqHx_iDhJiBfLiDfHiJeFiJlKiCpAiDfGiBfLiDgHiJeFiJlKiCmJiNiHiCoNiClJiCoJiCkJiBeI_xHqqkZx_
	ar << m_mmptPageLeftTop;	// _xZkqqHx_iDhJiBfLiDfHiNlGiPoDiImKjChFiCmMiNmAjFfHiBeC_xHqqkZx_
	ar << m_lPageColumn;		// _xZkqqHx_iJkBjFpLiMpMiCmJiDhJiBfLiDfHiCpAjFmAiCnHiCoJjHpBjAjEiBeC_xHqqkZx_
	ar << m_lPageLine;			// _xZkqqHx_iPgDjFpLiMpMiCmJiDhJiBfLiDfHiCpAjFmAiCnHiCoJiNhDjAjEiBeC_xHqqkZx_

	//----- _xZkqqHx_iDhEiDgCiDfOiCmMiDhGiDiNiDhAiDgFiDeC_xHqqkZx_ -----
//----- 06.02.26 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	ar << m_dwSheetColor;				// _xZkqqHx_iDfGiBfLiDgHjAeGiCpA_xHqqkZx_FCRegData_xZkqqHx_iCkJiCoHiOoGjDlOiBeC_xHqqkZx_
//	ar << m_bIsPaintSheetOnPrint;		// _xZkqqHx_iIpDiNpMiOjOiCmJiDfGiBfLiDgHiCpAjDgIiCoJiCkJiBeI_xHqqkZx_
//----- 06.02.26 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	ar << m_bIsPrintFooter;				// _xZkqqHx_iDhEiDgCiDfOiCpAiIpDiNpMiClHiCoJiCkJiBeI_xHqqkZx_
	ar << m_byHorzFooterPosition;		// _xZkqqHx_iDhEiDgCiDfOiCmMiImKjChFiBgJjAiFjFlNjFpLiMpMiBgKiBeCiNlGiBiBiCePiBeBjCiGiJjLiBiBiCfAiBeBiJeFiBiBiCfBiBeC_xHqqkZx_
	ar << m_byVertFooterPosition;		// _xZkqqHx_iDhEiDgCiDfOiCmMiImKjChFiBgJjAiCjClMjFpLiMpMiBgKiBeCiPoDiBiBiCePiBeBjCiGiJjLiBiBiCfAiBeBiJlKiBiBiCfBiBeC_xHqqkZx_
	ar << m_mmHorzFooterOffset;			// _xZkqqHx_iDhEiDgCiDfOiCmMiDeJiDhEiDfKiDgCiDgHiBgJjAiFjFlNjFpLiMpMiBgKiBeC_xHqqkZx_
	ar << m_mmVertFooterOffset;			// _xZkqqHx_iDhEiDgCiDfOiCmMiDeJiDhEiDfKiDgCiDgHiBgJjAiCjClMjFpLiMpMiBgKiBeC_xHqqkZx_
	m_fontRecFooter.OutStream(ar);		// _xZkqqHx_iDhEiDgCiDfOjHhAiDhEiDeIiDjDiDgHiBeC_xHqqkZx_
	ar << m_scidFooter;					// _xZkqqHx_iDhEiDgCiDfOjHhAjAeGiBeC_xHqqkZx_
// 06.05.11 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	ar.WriteString(m_wstrFooterText);	// _xZkqqHx_iDhEiDgCiDfOiDgFiDeMiDfIiDgHiBeC_xHqqkZx_
	WriteString(ar, m_wstrFooterText);	// _xZkqqHx_iDhEiDgCiDfOiDgFiDeMiDfIiDgHiBeC_xHqqkZx_

	//-----	S_xZkqqHx_jAeG_xHqqkZx_	-----
	FDSColorIDVector::const_iterator iSColorID;
	ar << long(m_vFreqSColor.size());
	for	(iSColorID = m_vFreqSColor.begin();	iSColorID != m_vFreqSColor.end(); iSColorID++)
	{
		ar.Write(&(*iSColorID),	sizeof(*iSColorID));
		m_vSColor[*iSColorID]->OutStream(ar);
	}

	//-----	_xZkqqHx_iDiBiDfOiDhEiDeAiDeDiDiLiDhAiDfOiBfLiDjD_xHqqkZx_ -----
	FDEmfImageIDVector::const_iterator iEmfImageID;
	ar << long(m_vFreqEmfImage.size());
	for	(iEmfImageID = m_vFreqEmfImage.begin();	iEmfImageID	!= m_vFreqEmfImage.end(); iEmfImageID++)
	{
		ar.Write(&(*iEmfImageID), sizeof(*iEmfImageID));
		m_vEmfImage[*iEmfImageID]->OutStream(ar);
	}

	//-----	_xZkqqHx_iDhFiDiJiDfGiCmMjDgPjIfOjGlM_xHqqkZx_ -----
	FDBrushRegisterIDVector::const_iterator	iBrushRegisterID;
	ar << long(m_vFreqBrushRegister.size());
	for	(iBrushRegisterID =	m_vFreqBrushRegister.begin(); iBrushRegisterID != m_vFreqBrushRegister.end(); iBrushRegisterID++)
	{
		ar.Write(&(*iBrushRegisterID), sizeof(*iBrushRegisterID));
		m_vBrushRegister[*iBrushRegisterID]->OutStream(ar);
	}

	//-----	_xZkqqHx_iDhJiDjDiCmMjDgPjIfOjGlM_xHqqkZx_ -----
	FDPenRegisterIDVector::const_iterator iPenRegisterID;
	ar << long(m_vFreqPenRegister.size());
	for	(iPenRegisterID	= m_vFreqPenRegister.begin(); iPenRegisterID !=	m_vFreqPenRegister.end(); iPenRegisterID++)
	{
		ar.Write(&(*iPenRegisterID), sizeof(*iPenRegisterID));
		m_vPenRegister[*iPenRegisterID]->OutStream(ar);
	}

	//-----	_xZkqqHx_iDhJiDjDiCmMiDfIiDfOiDeDiDiL_xHqqkZx_(_xZkqqHx_jClMjApM_xHqqkZx_,_xZkqqHx_jDfPjApM_xHqqkZx_,etc) -----
	FDPenStyleIDVector::const_iterator iPenStyleID;
	ar << long(m_vFreqPenStyle.size());
	for	(iPenStyleID = m_vFreqPenStyle.begin();	iPenStyleID	!= m_vFreqPenStyle.end(); iPenStyleID++)
	{
		ar.Write(&(*iPenStyleID), sizeof(*iPenStyleID));
		m_vPenStyle[*iPenStyleID]->OutStream(ar);
	}

	//-----	S_xZkqqHx_iDhEiDeIiDjDiDgH_xHqqkZx_ -----
	FDSFontIDVector::const_iterator	iSFontID;
	ar << long(m_vFreqSFont.size());
	for	(iSFontID =	m_vFreqSFont.begin(); iSFontID != m_vFreqSFont.end(); iSFontID++)
	{
		ar.Write(&(*iSFontID), sizeof(*iSFontID));
		m_vSFont[*iSFontID]->OutStream(ar);
	}

	//-----	_xZkqqHx_iDgAiDgCiDhGiDePiDiLiBfLiDhG_xHqqkZx_ -----
	FDChipGroupIDVector::const_iterator	iChipGroupID;
	ar << long(m_vFreqChipGroup.size());
	for	(iChipGroupID =	m_vFreqChipGroup.begin(); iChipGroupID != m_vFreqChipGroup.end(); iChipGroupID++)
	{
		ar.Write(&(*iChipGroupID), sizeof(*iChipGroupID));
		if (*iChipGroupID != FD_CHIP_GROUP_UNSPECIFY)
			m_vChipGroup[*iChipGroupID]->OutStream(ar);
	}

	//-----	_xZkqqHx_iDgAiDgCiDhG_xHqqkZx_ -----
	FDChipIDVector::const_iterator iChipID;
	ar << long(m_vFreqChip.size());
	for	(iChipID = m_vFreqChip.begin();	iChipID	!= m_vFreqChip.end(); iChipID++)
	{
		ar.Write(&(*iChipID), sizeof(*iChipID));
		if (*iChipID !=	FD_CHIP_UNSPECIFY)
			m_vChip[*iChipID]->OutStream(ar);
	}

	//-----	_xZkqqHx_iDhDiDeOiDgAiDiDjGoOiIpD_xHqqkZx_ -----
	FDPictArrowIDVector::const_iterator	iPictArrowID;
	ar << long(m_vFreqPictArrow.size());
	for	(iPictArrowID =	m_vFreqPictArrow.begin(); iPictArrowID != m_vFreqPictArrow.end(); iPictArrowID++)
	{
		ar.Write(&(*iPictArrowID), sizeof(*iPictArrowID));
		m_vPictArrow[*iPictArrowID]->OutStream(ar);
	}
} // MC4Env::OutStream.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC4Env::InEmfImage
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	EMF_xZkqqHx_iDeDiDiBiBfLiDfHiCmMiCnNjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ar	:_xZkqqHx_jDmHiCnNiNjOiCnNjAoGiCmMiDeBiBfLiDeKiDeDiDhFiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	_xZkqqHx_iDhCiDiFiBfLiDeBiDhEiDeIiBfLiDhNiDgCiDgHiCmMiDfGiBfLiDgHiDgGiBfLiDfOiCmMjDmHiCnNiNjOiCnNiCmJiOgHiCoNiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jDkPiClGiDeDiDiBiBfLiDfHiCpAiJlNjDhIiCoAjDmHiCnNiNjOiCnOiPoKiNiHiCkKiCkAiCoJiClNiCnPiBeBiKpJiCmJjDmHiCnNiNjOiCnN_xHqqkZx_
 *			_xZkqqHx_iNmPiCnNiCmIiCoHiCmOjDmHiCnNiNjOiCnMiCmIiCkCiCoGiCkEiCmJiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.07.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void MC4Env::InEmfImage (CArchive& ar)
{
	// _xZkqqHx_iOgHiCoNiCoKiCmEiCkCiCoJjEhHiMgJjAhNiCmMjAjEiCpAjDpMjHmNiBeC_xHqqkZx_
	long lEmfImageSize;
	ar >> lEmfImageSize;
	while (0 < lEmfImageSize--)
	{
		// _xZkqqHx_jEhHiMgJjAhN_xHqqkZx_ID_xZkqqHx_iCpAjDpMjHmNiBeC_xHqqkZx_
		EmfImageID emid;
		ar >> emid;
		// _xZkqqHx_jEhHiMgJjAhNiCmM_xHqqkZx_ID_xZkqqHx_iCkKjBoFiCkLiCkCiPoKiNiHiCmNiBeBjEhHiMgJjAhNjEhKjHpBiCpAiDiKiDfEiDeDiDfJiBeC_xHqqkZx_
		if (m_vEmfImage.size() <= emid)
			m_vEmfImage.resize(emid + 1, NULL);
		if (m_vEmfImage[emid] == NULL)
		//----- _xZkqqHx_jGkCiClOjDgPjIfOiClDiCoKiCmEiCkCiCmIiCkCiDeDiDiBiBfLiDfHiCmMiPoKiNiH_xHqqkZx_ -----
		{
			m_vEmfImage[emid] = new MC4EmfImageRec;
			m_vEmfImage[emid]->InStream(ar);
		} else
		//----- _xZkqqHx_iKpJiCmJjDgPjIfOiClDiCoKiCmEiCkCiCoJiDeDiDiBiBfLiDfHiCmMiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDgGiBfLiDfOiCpAiDfIiDeMiDgCiDhGiBeCjDmHiCnNiNjOiCpBiCmFiOmMiCmEiCoJiBeC_xHqqkZx_
			MC4EmfImageRec().InStream(ar);
		}
	}
	//----- m_vFreqEmfImage _xZkqqHx_iCpAjAnNjCoIiClHiCoJ_xHqqkZx_ -----
	m_vFreqEmfImage.clear();
	for (long lC = 0; lC < (long)m_vEmfImage.size(); lC++)
	{
		if (m_vEmfImage[lC] != NULL)
			m_vFreqEmfImage.push_back((EmfImageID)lC);
	}
} // MC4Env::InEmfImage.

void MC4Env::OutEmfImage (CArchive& ar,
							const set<EmfImageID>& stEmfImageID)
{
	// _xZkqqHx_iOgHiCoNiCoKiCmEiCkCiCoJjEhHiMgJjAhNiCpAiPgPjHmNiBeC_xHqqkZx_
	ar << long(stEmfImageID.size());
	set<EmfImageID>::const_iterator iEmf;
	for (iEmf = stEmfImageID.begin(); iEmf != stEmfImageID.end(); iEmf++)
	{
		// _xZkqqHx_jEhHiMgJjAhN_xHqqkZx_ID_xZkqqHx_iCpAiPgPjHmNiBeC_xHqqkZx_
		ar << *iEmf;
		// _xZkqqHx_jEhHiMgJjAhNiCpAiPgPjHmNiBeC_xHqqkZx_
		GetEmfImageRec(*iEmf)->OutStream(ar);
	}
} // MC4Env::OutEmfImage.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC4Env::GetEmfImageRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDfOiDhEiDeAiDeDiDiLiDhAiDfOiBfLiDjDiCmMiDiMiDfCiBfLiDgIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	emid	:_xZkqqHx_iDiMiDfCiBfLiDgIiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiMiDfCiBfLiDgIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.02.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const MC4EmfImageRec* MC4Env::GetEmfImageRec (EmfImageID emid) const
{
	return m_vEmfImage[emid];
} // MC4Env::GetEmfImageRec.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC4Env::AddEmfImageRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	EMF_xZkqqHx_iDeDiDiBiBfLiDfHiCpAjCmHiJmBiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pRec	:_xZkqqHx_jCmHiJmBiClHiCoJiDeDiDiBiBfLiDfHiCpAiOhHjCoIiBeC_xHqqkZx_new _xZkqqHx_iCmFiKgNjFnLiClFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAfGiClFiCkNjDgPjIfOiClDiCoKiClN_xHqqkZx_EMF_xZkqqHx_iCmM_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.07.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
EmfImageID MC4Env::AddEmfImageRec (MC4EmfImageRec* pRec)
{
	EmfImageID emid = (EmfImageID)m_vEmfImage.size();
	m_vEmfImage.push_back(pRec);
	m_vFreqEmfImage.push_back(emid);
	return emid;
} // MC4Env::AddEmfImageRec.

