#ifndef __4LayerManager_h
#define __4LayerManager_h

class MC4LayerRec
{
public:
	MC4LayerRec (const wchar_t* tcpName, WORD wFlag, MC4ObjBaseVector* pvLayer);
	void	Delete ();
	WString			m_strName;
	WORD			m_wFlag;
	MC4ObjBaseVector*	m_pvLayer;
}; // class MC4LayerRec.

typedef vector<MC4LayerRec>	MC4LayerRecVector;

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	MC4LayerManager
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	Document_xZkqqHx_iCmMjFjEjFgJiCmM_xHqqkZx_Z_xZkqqHx_iDeJiBfLiDfPiBfLiCpAiKmHjHjNiClHiCoJiDiMiDeDiDiEiBfLiDhNiDgMiBfLiDfHiDiDiDeOiDiJiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
class MC4LayerManager
{
public:
	MC4LayerManager (MC4ObjBaseVector& vBottomLayer, MC4ObjBaseVector& vTopLayer);
	virtual ~MC4LayerManager ();
	virtual void	DeleteAll ();
	virtual WString& GetName ();

	virtual void	OutStream (CArchive& ar) const;
	virtual void	InStream (CArchive& ar);

	virtual void	AppendToLZOrder (DWORD dwLayerIdx, MC4ObjBase* pObj);
	virtual DWORD	GetLayerSize () const;

	virtual void	InsertLayer (DWORD dwLayerIdx, const wchar_t* tcpName, WORD wFlag);

	virtual MC4ObjBaseVector*	GetObjOrder (DWORD dwLayerIdx) const;

protected:
	WString				m_strName;
	MC4LayerRecVector	m_vLayerTable;
	DWORD				m_dwCurLayerIdx;
}; // class MC4LayerManager.

#endif//__4LayerManager_h

