// 2Document.cpp : _xZkqqHx_iDeDiDjDiDhGiDiKiDiBiDjDiDgFiBfLiDfGiDiHiDjD_xHqqkZx_ _xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_
//

#include "stdafx.h"
#include "2ObjBase.h"		// for MC2ObjBase.
#include "2HeaderInf.h"		// for MC2HeaderInf.
#include "2Print.h"			// for MC2Print.
#include "2Env.h"			// for MC2Env.
#include "2View.h"			// for MC2View.
#include "2RegData.h"		// for MC2RegData.
#include "2LinkManager.h"	// for MC2LinkManager.
#include "2SheetManager.h"	// for MC2SheetManager.
#include "2ObjOle.h"		// for MC2ObjOle.
#include "2ObjRect.h"		// for MC2ObjRect.
#include "2NewFDObjAny.h"	// For NewFDObjAny.
#include "2ZOrder.h"		// For MC2ZOrder.
#include "2Document.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// MC2Document

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	myReplaceNullOle
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDePiDiLiBfLiDhGjFjEjFgJjDjJiCmMiDiBiDjDiDgPjFjEjFgJiPfHiNiHiCpAiMjPiNpFiClFiBeBiLpDiCmM_xHqqkZx_OLE_xZkqqHx_jFjEjFgJiCpAiLoJiMgAjFjEjFgJ_xHqqkZx_
 *			_xZkqqHx_iCmJjChFiCkLiKlHiCkGiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pvObj	:_xZkqqHx_jChFiCkLiKlHiCkGiCoJjFjEjFgJiCmMiDiBiDjDiDgPiBfLjFmPjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iMmDiCkC_xHqqkZx_Molip Draw_xZkqqHx_iDgGiBfLiDfOiCpAjDmHiCnNiNjOiCnOiCmGiCkLiCmJiBeBiLpDiCmM_xHqqkZx_OLE_xZkqqHx_jFjEjFgJiCkKiNkMiClGiCoJ_xHqqkZx_
 *			_xZkqqHx_iPoKiNiHiCkKiCkAiCoJiCmMiCmFiBeBiClLiCoKiCpAiLoJiMgAjFjEjFgJiCmJjChFiCkLiKlHiCkGiCmEiClFiCnMiCkEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
static void myReplaceNullOle (MC2ObjBaseVector* pvObj)
{
	if (pvObj == NULL) return;
	MC2ObjBaseVector::iterator iObj;
	for (iObj = pvObj->begin(); iObj != pvObj->end(); iObj++)
	{
		if ((*iObj)->IsKindOf(FDOJ_OLE))
		//----- OLE_xZkqqHx_jFjEjFgJiCmMiPoKiNiH_xHqqkZx_ -----
		{
			MC2ObjOle* pOle = (MC2ObjOle*)*iObj;
			if (pOle->GetOleClientItem() == NULL)
			//----- _xZkqqHx_iLpDiCmM_xHqqkZx_OLE_xZkqqHx_jFjEjFgJiCmMiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_jFjEjFgJ_xHqqkZx_ID_xZkqqHx_iBeBiDfEiDeDiDfJiCpAiLeMjIfOiBeC_xHqqkZx_
				const DWORD dwObjID = pOle->GetObjID();
				const DBLRect mmrtFrame = pOle->GetResizeFrame();
				// _xZkqqHx_jFjEjFgJiCpA_xHqqkZx_ID_xZkqqHx_iDgFiBfLiDhFiDiLiCkJiCoHjGjFiPmBiBeC_xHqqkZx_
				pOle->UnregisterObjID();
				// _xZkqqHx_jFjEjFgJiCpAiNoNiPjMiBeC_xHqqkZx_
				pOle->Terminate();
				delete pOle;
				// _xZkqqHx_jChFiCkLiKlHiCkGjHhAiLoJiMgAjFjEjFgJiCpAiNoMjAkMiBeC_xHqqkZx_
				MC2ObjRect* pRect = (MC2ObjRect*)::NewFDObjAny(FDOJ_RECT);
				// _xZkqqHx_jFjEjFgJ_xHqqkZx_ID_xZkqqHx_iCmMjDgPjIfOiBeC_xHqqkZx_
				pRect->SetObjID(dwObjID);
				pRect->RegisterObjForceID();
				// _xZkqqHx_iDfEiDeDiDfJiCpAjFmPiNfIiBeC_xHqqkZx_
				pRect->Resize(TRUE, TRUE, mmrtFrame);
				// _xZkqqHx_jFjEjFgJiCpAjChFiCkLiKlHiCkGiBeC_xHqqkZx_
				*iObj = pRect;
			}
		} else
		//----- OLE_xZkqqHx_jFjEjFgJiImIiKePiCmMiPoKiNiH_xHqqkZx_ -----
		{
//----- 01.05.25 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//			// _xZkqqHx_iNmEiLeBjDeJiCmJiOmAiNhDiBeC_xHqqkZx_
//			myReplaceNullOle(const_cast<MC2ObjBaseVector*>((*iObj)->GetMembers()));
//----- 01.05.25 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
			// _xZkqqHx_iNmEiLeBjDeJiCmJiOmAiNhDiBeC_xHqqkZx_
			MC2ObjBaseVector vObj;
			(*iObj)->GetMembers(vObj);
			myReplaceNullOle(&vObj);
//----- 01.05.25 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
		}
	}
} // myReplaceNullOle.

/////////////////////////////////////////////////////////////////////////////
// MC2Document

IMPLEMENT_DYNCREATE(MC2Document, COleServerDoc)

MC2Document::MC2Document ()
{
	// OLE _xZkqqHx_jFkBiNiHiDhEiDeAiDeDiDiLiCpAiOgHjHhAiClFiCnMiClHiBeC_xHqqkZx_
	EnableCompoundFile();

	m_headerInf = new MC2HeaderInf();
	m_print = new MC2Print();
	m_env = new MC2Env();
	m_view = new MC2View();
	m_linkManager = new MC2LinkManager();
	m_sheetManager = new MC2SheetManager();
} // MC2Document::MC2Document.

/////////////////////////////////////////////////////////////////////////////
// MC2Document

//----- 05.06.13 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2Document::SetRootStorage
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiLiBfLiDgHiDfIiDgHiDiMiBfLiDfHiCpAjChFiCkLiKlHiCkGiCoJiBeCiDeBiBfLiDeKiDeDiDhFiCkJiCoH_xHqqkZx_OLE_xZkqqHx_iCpAjDmHiCnNiNjOiCnOiClNiCnPiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pStorage	:_xZkqqHx_jChFiCkLiKlHiCkGiCoJiDfIiDgHiDiMiBfLiDfHiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iCoAiCmGiCoAiCmGiCmMiDiLiBfLiDgHiDfIiDgHiDiMiBfLiDfHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDeBiBfLiDeKiDeDiDhFiCkJiCoH_xHqqkZx_OLE_xZkqqHx_iCpAjDmHiCnNiNjOiCnOiPoKiNiHiBeBjFkBiNiHiDhEiDeAiDeDiDiLiCmFiCkAiCoKiCmOiBeB_xHqqkZx_
// *			_xZkqqHx_iDiLiBfLiDgHiDfIiDgHiDiMiBfLiDfHiCmGiDeBiBfLiDeKiDeDiDhFiCmNiDfKiDgCiDgHiCmJiCmIiCmBiCmEiCkCiCoJiBeC_xHqqkZx_
// *			_xZkqqHx_jBkGiClPiBeBiDeBiBfLiDeKiDeDiDhFiCmMjDmHiCnNiNjOiCnNiImKjChFiCkKiClPiCoFiCkEiCmH_xHqqkZx_OLE_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmM_xHqqkZx_
// *			_xZkqqHx_iImKjChFiCmJiCmIiCmBiClNiCmGiCkLiBeBjDmHiCnNiNjOiCnNjAoGiCmNiDeBiBfLiDeKiDeDiDhFiCmFiCmNiCmIiCkN_xHqqkZx_
// *			_xZkqqHx_iDiLiBfLiDgHiDfIiDgHiDiMiBfLiDfHiCmJiCmIiCmBiCmEiClFiCnMiCkEiBeC_xHqqkZx_
// *			_xZkqqHx_iClBiCmMiClNiCnPiBeBiDeBiBfLiDeKiDeDiDhFiCmGiDfKiDgCiDgHiCmJiCmIiCmBiClNiDiLiBfLiDgHiDfIiDgHiDiMiBfLiDfHiCpA_xHqqkZx_
// *			_xZkqqHx_iClBiCmMiDgIiDeMiDiFiDiBiDjDiDgHiCmJjDgOiClFiCmEiCoCiCoJjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
// *			_xZkqqHx_iDhEiDiJiDgCiDgHiDhEiDeAiDeDiDiLiCmMiPoKiNiHiCmNiBeBiClBiCmMjFeLjHhGiCmNiCmIiCkCiBeC_xHqqkZx_
// *			_xZkqqHx_iClNiClOiClFiBeBiDhEiDiJiDgCiDgHiDhEiDeAiDeDiDiLiCmFiCkAiCmBiCmEiCoAiBeBjDmHiCnNiNjOiCnNiOjOiCmJ_xHqqkZx_
// *			OLE_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCkKjBlGiNnNiClHiCoJiPoKiNiHiBeBiImIiJlKiCmMiImKjChFiCmF_xHqqkZx_
// *			_xZkqqHx_iDiLiBfLiDgHiDfIiDgHiDiMiBfLiDfHiCmJ_xHqqkZx_OLE_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiNoMjAkMiClFiCmJ_xHqqkZx_
// *			_xZkqqHx_iNhDiCmBiCmEiClFiCnMiCkEiBeC_xHqqkZx_
// *			_xZkqqHx_iClBiCmMiClNiCnPiBeBiDiLiBfLiDgHiDfIiDgHiDiMiBfLiDfHiCpA_xHqqkZx_(-1)_xZkqqHx_iCmFjChFiCkLiKlHiCkGiCoJiClBiCmGiCmN_xHqqkZx_
// *			_xZkqqHx_iClFiCmIiCkCiBeC_xHqqkZx_
// *			OLE_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiDhEiDiJiDgCiDgHiDhEiDeAiDeDiDiLiCnGiPjBiCkLiPgPiClHiPoKiNiHiCmN_xHqqkZx_
// *			_xZkqqHx_iDiLiBfLiDgHiDfIiDgHiDiMiBfLiDfHiCpAjEePiCmMiClNiCnPiCmJ_xHqqkZx_(-1)_xZkqqHx_iCmJjChFiCkLiKlHiCkGiCmEiBeB_xHqqkZx_
// *			_xZkqqHx_iJlNiCoAiPiIjHjNiCkKiCmIiCkCiCoGiCkEiCmJiClFiCmEiCkIiCkNiBeC_xHqqkZx_
// *			
// *			void COleClientItem::ReadItemCompound(CArchive& ar)
// *			{
// *				:
// *				:
// *				GetItemStorageCompound();
// *				~~~~~~~~~~~~~~~~~~~~~~~~~_xZkqqHx_iClBiCmMiKnGjAjEjCiG_xHqqkZx_
// *
// *			void COleClientItem::GetItemStorageCompound()
// *			{
// *				:
// *				:
// *				SCODE sc = pDoc->m_lpRootStg->CreateStorage(T2COLE(szItemName),
// *					STGM_CREATE|STGM_READWRITE|STGM_TRANSACTED|STGM_SHARE_EXCLUSIVE,
// *					0, 0, &lpStorage);
// *				~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~_xZkqqHx_iClBiClB_xHqqkZx_
// *
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//LPSTORAGE MC2Document::SetRootStorage (LPSTORAGE pStorage)
//{
//	LPSTORAGE pStorageOld = m_lpRootStg;
//	m_lpRootStg = pStorage;
//	return pStorageOld;
//} // MC2Document::SetRootStorage.
//----- 05.06.13 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2Document::SetFileType
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iPgPjHmNiClHiCoJiDhEiDeAiDeDiDiLiMfOiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	df	:_xZkqqHx_iDhEiDeAiDeDiDiLiMfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void MC2Document::SetFileType (FTDocumentFormat df)
{
	m_headerInf->SetFileType(df);
} // MC2Document::SetFileType.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2Document::RegisterObject
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAfGiClFiCkNjAlGjAkMiClDiCoKiClNjFjEjFgJiCpAiOhHjCoIiClFiClN_xHqqkZx_ID_xZkqqHx_iCmFjDgPjIfOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pObj	: _xZkqqHx_jDgPjIfOiClHiCoJjFjEjFgJ_xHqqkZx_
 *			dwID	: _xZkqqHx_jDgPjIfOiClHiCoJjFjEjFgJiCmM_xHqqkZx_ID
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	ID_xZkqqHx_iCmMiPgEjFkBiCpAiDgAiDeGiDgCiDeOiClFiCmIiCkCiCmMiCmFiBeB_xHqqkZx_m_obppObjID2P_xZkqqHx_iCkKiClHiCnHiCmEiLpDiCmMiOjOiBeB_xHqqkZx_
 *			_xZkqqHx_iClHiCmIiCoNiClP_xHqqkZx_m_dwObjID2PNext = 0_xZkqqHx_iCmMiOjOiCmMiCnNiOgHjHhAiCmFiCkLiCoJiBeCjAfGiLeLiCmJiDhEiDeAiDeDiDiL_xHqqkZx_
 *			_xZkqqHx_iCpAiDiNiBfLiDgIiClHiCoJiOjOiCmMiCnNiCmGiNgMiCkGiCmEiCoGiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.11.14 Fukushiro M. _xZkqqHx_iDgFiBfLiDhFiDiLiCkK_xHqqkZx_NULL_xZkqqHx_iCmMiPiIjHjNiCpAjCmHiJmB_xHqqkZx_.ChipTbl::InStreamV1_xZkqqHx_iCmMiInH_xHqqkZx_.
 *************************************************************************/
void MC2Document::RegisterObject (MC2ObjBase* pObj, DWORD dwID)
{
	m_mpIdToObjBase[dwID] = pObj;
} // MC2Document::RegisterObject.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2Document::UnregisterObject
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCpA_xHqqkZx_ID_xZkqqHx_jDgPjIfOiCkJiCoHiCmNiClIiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pObj	: _xZkqqHx_jFjEjFgJ_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.11.14 Fukushiro M. _xZkqqHx_iDgFiBfLiDhFiDiLiCkK_xHqqkZx_NULL_xZkqqHx_iCmMiPiIjHjNiCpAjCmHiJmB_xHqqkZx_.ChipTbl::InStreamV1_xZkqqHx_iCmMiInH_xHqqkZx_.
 *************************************************************************/
void MC2Document::UnregisterObject (MC2ObjBase* pObj)
{
	// _xZkqqHx_jFjEjFgJ_xHqqkZx_ID_xZkqqHx_iDgFiBfLiDhFiDiLiCkJiCoHjFjEjFgJiCpAiPjMiCkN_xHqqkZx_.
	m_mpIdToObjBase.erase(pObj->GetObjID());
} // MC2Document::UnregisterObject.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2Document::ObjID2Object
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJ_xHqqkZx_ID_xZkqqHx_iCkJiCoHjFjEjFgJiCpAjCfEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	_xZkqqHx_jFjEjFgJ_xHqqkZx_ID.
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFjEjFgJ_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.10.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *			98.11.14 Fukushiro M. _xZkqqHx_iDgFiBfLiDhFiDiLiCkK_xHqqkZx_NULL_xZkqqHx_iCmMiPiIjHjNiCpAjCmHiJmB_xHqqkZx_.ChipTbl::InStreamV1_xZkqqHx_iCmMiInH_xHqqkZx_.
 *************************************************************************/
MC2ObjBase* MC2Document::ObjID2Object (DWORD dwID) const
{
	return (*m_mpIdToObjBase.find(dwID)).second;
} // MC2Document::ObjID2Object.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2Document::OleItemToOwnerObjID
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgOiDgCiDfGiDiFiDgFiBfLiDhFiDiLiCkJiCoHiBeB_xHqqkZx_OLE _xZkqqHx_iDeBiDeDiDgFiDiA_xHqqkZx_ -> OLE_xZkqqHx_jFjEjFgJ_xHqqkZx_ID _xZkqqHx_iCpAiMjPiNpFiClFiCmE_xHqqkZx_
 *			_xZkqqHx_jFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pItem	:OLE_xZkqqHx_iDeBiDeDiDgFiDiAiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFjEjFgJ_xHqqkZx_ID_xZkqqHx_iBeCjBlGiNnNiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ DWORD(-1)
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DWORD MC2Document::OleItemToOwnerObjID (void* pItem) const
{
	map<void*, DWORD>::const_iterator i = m_mpOleItemToObjID.find(pItem);
	if (i == m_mpOleItemToObjID.end()) return DWORD(-1);
	return (*i).second;
} // MC2Document::OleItemToOwnerObjID.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2Document::SetOleItemToOwnerObjID
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	OLE _xZkqqHx_iDeBiDeDiDgFiDiA_xHqqkZx_ -> OLE_xZkqqHx_jFjEjFgJ_xHqqkZx_ID _xZkqqHx_iDgOiDgCiDfGiDiFiDgFiBfLiDhFiDiLiCnGjDgPjIfOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pItem	:OLE_xZkqqHx_iDeBiDeDiDgFiDiAiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwObjID	:_xZkqqHx_jFjEjFgJ_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void MC2Document::SetOleItemToOwnerObjID (void* pItem, DWORD dwObjID)
{
	m_mpOleItemToObjID[pItem] = dwObjID;
} // MC2Document::SetOleItemToOwnerObjID.

//----- 05.06.02 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//void MC2Document::LoadTextFile (const wchar_t* wcpFilePath)
//{
//	astring strBuff;
//	FFUtilFileI->LoadTextFile(strBuff, wcpFilePath, -1);
//
//	DWORD dwID = 100;
//	while (!strBuff.empty())
//	{
//		long lLineCount = 0;
//		astring strLine = FFUtilStrI->GetLine(strBuff, lLineCount);
//		MC2ObjBase* pObj = NewFDObjAny(FDOJ_RECT);
//		pObj->SetObjID(dwID++);
//		((MC2ObjRect*)pObj)->Resize(TRUE, TRUE, DBLRect(10, 10, 100, 100));
//		// _xZkqqHx_jFjEjFgJ_xHqqkZx_ID_xZkqqHx_iCpAiDgFiBfLiDhFiDiLiCmJiLkNjAkHjDgPjIfOiBeCiDePiDiLiBfLiDhGiCmMiPoKiNiHiCmNiBeBiDePiDiLiBfLiDhGiDiBiDjDiDgPiCoAjDgPjIfOiClDiCoKiCoJiBeC_xHqqkZx_
//		pObj->RegisterObjForceID();
//		// _xZkqqHx_jFjEjFgJiCpAiDiMiDeDiDiEiBfLiDhNiDgMiBfLiDfHiDiDiCmJjDgPjIfOiBeC_xHqqkZx_
//		m_sheetManager->GetFrontSheet()->AppendToLZOrder(pObj);
//	}
//} // MC2Document::LoadTextFile.
//----- 05.06.02 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

void MC2Document::InStreamCore (MCARCHIVE& ar)
{
	// _xZkqqHx_iDhHiDgCiDfPiPoOjFpBiCmMjDmHiCnNiNjOiCnNiBeC_xHqqkZx_
	m_headerInf->InStream(ar);

	// _xZkqqHx_jFlGiPjBiDhGiDiNiDhAiDgFiDeCiDfEiDeDiDfJiBeC_xHqqkZx_
	long lDocPropertySize;
	ar >> lDocPropertySize;
	ASSERT(lDocPropertySize == 0);

	// _xZkqqHx_jBfDiCmEiCmMiKmCiLkLiCpAiPiJiKpKiJlLiBeC_xHqqkZx_
	m_env->ClearEnvTbl();
	// _xZkqqHx_iDhGiDiKiDjDiDfOiPoOjFpBjDjJiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
	m_print->InStream(ar);
	// _xZkqqHx_iKmCiLkLiPoOjFpBiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
	m_env->InStreamV12(ar);
	// _xZkqqHx_iDgDiBfLiDiLjAnNjCoIiPoOjFpBiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
	m_view->InStream(ar);
	m_env->InStreamChipV12(ar);
	{
		BYTE			byType;
		long			lSize;
		MC2ObjBase*	pObj;
		//----- _xZkqqHx_jFjEjFgJiCmMjDmHiCnNiNjOiCnN_xHqqkZx_ -----
		ar >> lSize;
		while (0 < lSize--)
		{
			ar >> byType;
			pObj = NewFDObjAny(FTObjectType(byType));
			pObj->InStream(ar);
			// _xZkqqHx_jFjEjFgJ_xHqqkZx_ID_xZkqqHx_iCpAiDgFiBfLiDhFiDiLiCmJiLkNjAkHjDgPjIfOiBeCiDePiDiLiBfLiDhGiCmMiPoKiNiHiCmNiBeBiDePiDiLiBfLiDhGiDiBiDjDiDgPiCoAjDgPjIfOiClDiCoKiCoJiBeC_xHqqkZx_
			pObj->RegisterObjForceID();
			// _xZkqqHx_jFjEjFgJiCpAiDiMiDeDiDiEiBfLiDhNiDgMiBfLiDfHiDiDiCmJjDgPjIfOiBeC_xHqqkZx_
			m_sheetManager->GetFrontSheet()->AppendToLZOrder(pObj);
		}
	}
	// _xZkqqHx_iDiKiDjDiDeOiPoOjFpBiCpAjDpMjHmNiClHiCoJiBeC_xHqqkZx_
	m_linkManager->InStream(ar);

	// read number of items in the file
	DWORD dwCount;
	ar >> dwCount;
	// read all of them into the list
	while (dwCount--)
	{
		// OLE_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHiCpAjAlGjAkMiBeBiDgIiDeMiDiFiDiBiDjDiDgHiCmJjCmHiJmBiBeC_xHqqkZx_
		CDocItem* pItem;
		DWORD dwOwnerObjectID;
		ar >> pItem;
		ar >> dwOwnerObjectID;	// _xZkqqHx_iClBiCmM_xHqqkZx_OLE_xZkqqHx_iDeBiDeDiDgFiDiAiCpAiPiKjHeMiClHiCoJjFjEjFgJiCmM_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
		SetOleItemToOwnerObjID(pItem, dwOwnerObjectID);
	}

	//----- COleDocument_xZkqqHx_jCiGiCmJjDmHiCnNiNjOiCnMiCoKiClNiDeBiDeDiDgFiDiAiCpAiBeB_xHqqkZx_ObjOle_xZkqqHx_iCmJjAnNjCoIiClHiCoJ_xHqqkZx_ -----
	// _xZkqqHx_iNoNiPjMiClHiCnHiCkL_xHqqkZx_OLE_xZkqqHx_iDeBiDeDiDgFiDiAiCpAiDgPiDgCiDeOiDeBiDgCiDhGiBeC_xHqqkZx_
	vector<COleClientItem*> vOleDel;
	POSITION pos = GetStartPosition();
	while (pos != NULL)
	{
		COleClientItem* pItem = (COleClientItem*)GetNextClientItem(pos);
		// NULL_xZkqqHx_iCmMiPoKiNiHiCmNiOjPiCmMiDiLiBfLiDhGiCnGiBeC_xHqqkZx_NULL_xZkqqHx_iCmMiPoKiNiHiCkKjHeMiCoIjDlOiCoJiBeC_xHqqkZx_
		if (pItem == NULL) continue;
		//-----------------------------------------------------------------
		// _xZkqqHx_jGhLjHiIiCmIiCoHiImIiJlKiCmMiPiIjHjNiCmNjFhDjHhGiClOiCkKiBeB_xHqqkZx_2.0A3_xZkqqHx_iCmFiCmNiNoNiPjMiClDiCoKiClNiCmNiClIiCmM_xHqqkZx_OLE_xZkqqHx_jFjEjFgJiCmM_xHqqkZx_
		// OLE_xZkqqHx_iDeBiDeDiDgFiDiAiCkKiDfKiBfLiDhFiClDiCoKiCmEiClFiCnMiCmBiCmEiCkCiCoJiCmMiCmFiBeBiClLiCmMiClNiCnPiCmMiPiIjHjNiBeC_xHqqkZx_
		//-----------------------------------------------------------------
		// _xZkqqHx_jGlDiMpIiCmM_xHqqkZx_ObjID_xZkqqHx_iCmMiPoKiNiHiCmNiBeBiNoNiPjMiDiKiDfIiDgHiCmJjCmHiJmBiClFiCmEiOjPiCmMiDiLiBfLiDhGiCnGiBeC_xHqqkZx_
		if (OleItemToOwnerObjID(pItem) == DWORD(-1))
		{
			// _xZkqqHx_iNoNiPjMiDiKiDfIiDgHiCmJjCmHiJmBiBeC_xHqqkZx_
			vOleDel.push_back(pItem);
			continue;
		}
		MC2ObjOle* pObj = (MC2ObjOle*)ObjID2Object(OleItemToOwnerObjID(pItem));
		if (pObj == NULL || !pObj->IsKindOf(FDOJ_OLE))
		{
			// _xZkqqHx_iNoNiPjMiDiKiDfIiDgHiCmJjCmHiJmBiBeC_xHqqkZx_
			vOleDel.push_back(pItem);
		} else
		{
			DBLRect mmrtFrame = pObj->GetResizeFrame();
			((MC2ObjOle*)pObj)->SetOleClientItemAndRatio(pItem);
			pObj->Resize(TRUE, TRUE, mmrtFrame);
		}
	}

	//----- _xZkqqHx_iLpDiCmM_xHqqkZx_OLE_xZkqqHx_jFjEjFgJiCpAiBeBiLoJiMgAjFjEjFgJiCmJjChFiCkLiKlHiCkGiCoJ_xHqqkZx_ -----
	// _xZkqqHx_iChJiDeJiBfLiDfPiBfLiCpAiOoGjDlOiBeC_xHqqkZx_
	MC2ZOrder zOrder;
	m_sheetManager->GetFrontSheet()->GetZOrder(zOrder, FDOZ_ON_ANY);
	MC2ZOrderIterator iObj;
	for (zOrder.Begin(iObj); !iObj.IsEnd(); iObj++)
	{
		if ((*iObj)->IsKindOf(FDOJ_OLE))
		//----- OLE_xZkqqHx_jFjEjFgJiCmMiPoKiNiH_xHqqkZx_ -----
		{
			MC2ObjOle* pOle = (MC2ObjOle*)*iObj;
			if (pOle->GetOleClientItem() == NULL)
			//----- _xZkqqHx_iLpDiCmM_xHqqkZx_OLE_xZkqqHx_jFjEjFgJiCmMiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_jFjEjFgJ_xHqqkZx_ID_xZkqqHx_iBeBiDiMiDeDiDiEiBfLiDhNiDgMiBfLiDfHiDiDiBeBiDfEiDeDiDfJiCpAiLeMjIfOiBeC_xHqqkZx_
				const DWORD dwObjID = pOle->GetObjID();
				const MC2LayerZOrder lzorder = m_sheetManager->GetFrontSheet()->ObjBaseToLZOrder(pOle);
				const DBLRect mmrtFrame = pOle->GetResizeFrame();
				// _xZkqqHx_jFjEjFgJiCpAiDiMiDeDiDiEiBfLiDhNiDgMiBfLiDfHiDiDiCkJiCoHjGjFiPmBiBeC_xHqqkZx_
				m_sheetManager->GetFrontSheet()->RemoveFromLZOrder(pOle);
				// _xZkqqHx_jFjEjFgJiCpA_xHqqkZx_ID_xZkqqHx_iDgFiBfLiDhFiDiLiCkJiCoHjGjFiPmBiBeC_xHqqkZx_
				pOle->UnregisterObjID();
				// _xZkqqHx_jFjEjFgJiCpAiNoNiPjMiBeC_xHqqkZx_
				pOle->Terminate();
				delete pOle;
				// _xZkqqHx_jChFiCkLiKlHiCkGjHhAiLoJiMgAjFjEjFgJiCpAiNoMjAkMiBeC_xHqqkZx_
				MC2ObjRect* pRect = (MC2ObjRect*)::NewFDObjAny(FDOJ_RECT);
				// _xZkqqHx_jFjEjFgJ_xHqqkZx_ID_xZkqqHx_iCmMjDgPjIfOiBeC_xHqqkZx_
				pRect->SetObjID(dwObjID);
				pRect->RegisterObjForceID();
				// _xZkqqHx_iDiMiDeDiDiEiBfLiDhNiDgMiBfLiDfHiDiDiCmM_xHqqkZx_OLE_xZkqqHx_jFjEjFgJiImKjChFiCmJiLoJiMgAjFjEjFgJiCpAjBhNjDpMiBeC_xHqqkZx_
				m_sheetManager->GetFrontSheet()->InsertToLZOrder(lzorder, pRect);
				// _xZkqqHx_iDfEiDeDiDfJiCpAjFmPiNfIiBeC_xHqqkZx_
				pRect->Resize(TRUE, TRUE, mmrtFrame);
			}
		} else
		//----- OLE_xZkqqHx_jFjEjFgJiImIiKePiCmMiPoKiNiH_xHqqkZx_ -----
		{
			MC2ObjBaseVector vObj;
			(*iObj)->GetMembers(vObj);
			// _xZkqqHx_iDePiDiLiBfLiDhGjFjEjFgJjDjJiCmMiPoKiNiHiBeBiDiBiDjDiDgPiCpAiNmEiLeBjDeJiCmJiOmAiNhDiBeC_xHqqkZx_
			myReplaceNullOle(&vObj);
		}
	}
	// OLE_xZkqqHx_iDeBiDeDiDgFiDiAiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
	vector<COleClientItem*>::iterator iOle;
	for (iOle = vOleDel.begin(); iOle != vOleDel.end(); iOle++)
	{
		// OleClientItem_xZkqqHx_iCpAiNoNiPjMiBeC_xHqqkZx_OleClientItem_xZkqqHx_iCmNiBeB_xHqqkZx_COleDocument_xZkqqHx_iCmFiKmHjHjNiClDiCoKiCmE_xHqqkZx_
		// _xZkqqHx_iCkCiCoJiCmMiCmFiBeB_xHqqkZx_Delete_xZkqqHx_iKnGjAjEiCmFiNoNiPjMiClHiCoJiBeC_xHqqkZx_
		(*iOle)->Delete();
	}
} // MC2Document::InStreamCore.

void MC2Document::OutStreamCore (MCARCHIVE& ar)
{
	// _xZkqqHx_iDhHiDgCiDfPiPoOjFpBiCmMiPjBiCkLiPgPiClFiBeC_xHqqkZx_
	m_headerInf->OutStream(ar);

	// _xZkqqHx_jFlGiPjBiDhGiDiNiDhAiDgFiDeCiDfEiDeDiDfJiBeC_xHqqkZx_
	const long lDocPropertySize = 0;
	ar << lDocPropertySize;

	// _xZkqqHx_iDhGiDiKiDjDiDfOiPoOjFpBjDjJiCpAiPjBiCkLiPgPiClHiBeC_xHqqkZx_
	m_print->OutStream(ar);
	// _xZkqqHx_iKmCiLkLiPoOjFpBiCpAiPjBiCkLiPgPiClHiBeC_xHqqkZx_
	m_env->OutStreamV3(ar);
	// _xZkqqHx_iDgDiBfLiDiLjAnNjCoIiPoOjFpBiCpAiPjBiCkLiPgPiClHiBeC_xHqqkZx_
	m_view->OutStream(ar);
	// _xZkqqHx_iDfGiBfLiDgHiBeBjFjEjFgJiPoOjFpBiCpAiPgPjHmNiBeC_xHqqkZx_
	m_sheetManager->OutStreamV3(ar);
	// _xZkqqHx_iDiKiDjDiDeOiPoOjFpBiCpAiPgPjHmNiClHiCoJiBeC_xHqqkZx_
	m_linkManager->OutStream(ar);
	// _xZkqqHx_iDiMiDfHiDfIiDgHiDiKiPoOjFpBiCpAiPgPjHmNiClHiCoJiBeC_xHqqkZx_
	MC2RegData::OutStreamV3(ar);
	// _xZkqqHx_iDeMiDiDiDjDiDgPiDfIiCmMjFfMiOkGiPpDjBnEiCpAiDfIiDgHiDiKiBfLiDiAiCmJiPgPjHmNiClHiCoJiBeC_xHqqkZx_
	m_env->OutStreamCanvasStatV3(ar);
} // MC2Document::OutStreamCore.


/////////////////////////////////////////////////////////////////////////////
// MC2Document

BOOL MC2Document::OnNewDocument ()
{
	if (!COleServerDoc::OnNewDocument())
		return FALSE;
	return TRUE;
} // MC2Document::OnNewDocument.

MC2Document::~MC2Document ()
{
	delete m_headerInf;
	m_headerInf = NULL;

	delete m_print;
	m_print = NULL;

	delete m_env;
	m_env = NULL;

	delete m_view;
	m_view = NULL;

	delete m_linkManager;
	m_linkManager = NULL;

	m_sheetManager->DeleteAll();
	delete m_sheetManager;
	m_sheetManager = NULL;
} // MC2Document::~MC2Document.

COleServerItem* MC2Document::OnGetEmbeddedItem ()
{
	// OnGetEmbeddedItem _xZkqqHx_iCmNiBeBiDgIiDeMiDiFiDiBiDjDiDgHiCmJiKnGjIeBjFhEiCkPiCoHiCoKiClN_xHqqkZx_ COleServerItem _xZkqqHx_iCpA_xHqqkZx_
	// _xZkqqHx_iOoGjDlOiClHiCoJiClNiCnPiCmJiDhEiDiMiBfLiDiAiDiPiBfLiDeOiCkJiCoHjFeLjHhGiCmIiPoKiNiHiCmJiCmMiCnNiMmEiCnBiPgPiClDiCoKiCnMiClHiBeC_xHqqkZx_

	// NULL _xZkqqHx_iCpAjFnEiClHjBoDiCoNiCoIiCmJiBeBiClBiCmMiDgIiDeMiDiFiDiBiDjDiDgHiCmJjIeBiMiLiClDiCoKiClN_xHqqkZx_ COleServerItem _xZkqqHx_iCmM_xHqqkZx_
	// _xZkqqHx_jEgIjAlGiDeOiDiJiDfIiCnGiCmMiDhMiDeDiDjDiDfOiCpAjFnEiClHiCoGiCkEiCmJjFmPiNfIiClFiCmEiJlKiClDiCkCiBeCiClLiCmMiMoDiBeBiImIiJlKiCmM_xHqqkZx_
	// ASSERT(FALSE) _xZkqqHx_iNhDiCpAiNoNiPjMiClFiCmEiJlKiClDiCkCiBeC_xHqqkZx_
	//  (_xZkqqHx_jHoB_xHqqkZx_: return new CMyServerItem)
	ASSERT(FALSE);			// _xZkqqHx_iPiIjHjNiLeMiPhBiMoDiBeBiNoNiPjMiClFiCmEiCkNiClOiClDiCkCiBeC_xHqqkZx_
	return NULL;
} // MC2Document::OnGetEmbeddedItem.

BEGIN_MESSAGE_MAP(MC2Document, COleServerDoc)
	//{{AFX_MSG_MAP(MC2Document)
		// _xZkqqHx_iDiBiDiC_xHqqkZx_ - ClassWizard _xZkqqHx_iCmNiClBiCmMiImKjChFiCmJiDhNiDgCiDhDiDjDiDePjHhAiCmMiDhNiDeOiDiNiCpAjCmHiJmBiCnMiClNiCmNiNoNiPjMiClFiCnMiClHiBeC_xHqqkZx_
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// MC2Document _xZkqqHx_jAgGjCgG_xHqqkZx_

#ifdef _DEBUG
void MC2Document::AssertValid () const
{
	COleServerDoc::AssertValid();
} // MC2Document::AssertValid.

void MC2Document::Dump (CDumpContext& dc) const
{
	COleServerDoc::Dump(dc);
} // MC2Document::Dump.
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// MC2Document _xZkqqHx_iDfGiDiKiDeBiDiJiDeDiDfJ_xHqqkZx_

void MC2Document::Serialize (CArchive& ar)
{
	if (ar.IsStoring())
	{
		// TODO: _xZkqqHx_iClBiCmMiImKjChFiCmJjFnLjBlGjHhAiCmMiDfCiBfLiDgIiCpAjCmHiJmBiClFiCmEiCkNiClOiClDiCkC_xHqqkZx_
	}
	else
	{
		// TODO: _xZkqqHx_iClBiCmMiImKjChFiCmJjDmHiCnNiNjOiCnNjHhAiCmMiDfCiBfLiDgIiCpAjCmHiJmBiClFiCmEiCkNiClOiClDiCkC_xHqqkZx_
	}
} // MC2Document::Serialize.

/////////////////////////////////////////////////////////////////////////////
// MC2Document _xZkqqHx_iDfCiDhNiDjDiDgI_xHqqkZx_
