#ifndef __Env_h
#define __Env_h

//----- 06.03.26 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
#define FD_ENV_NAME_LEN_V12	32		// _xZkqqHx_iKmCiLkL_xHqqkZx_(_xZkqqHx_jAeGiBeFiDhAiDfOiBfLiDjDjDjJ_xHqqkZx_)_xZkqqHx_iCmMjGlMjBePiCmMjClHiClD_xHqqkZx_(_xZkqqHx_iPeJjCfLiCpAiKnMiCnO_xHqqkZx_).
#define FD_ENV_NAME_LEN_V3	32		// _xZkqqHx_iKmCiLkL_xHqqkZx_(_xZkqqHx_jAeGiBeFiDhAiDfOiBfLiDjDjDjJ_xHqqkZx_)_xZkqqHx_iCmMjGlMjBePiCmMjClHiClD_xHqqkZx_(_xZkqqHx_iPeJjCfLiCpAiKnMiCnO_xHqqkZx_).
//----- 06.03.26 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

struct MC2FontCharInfo;

#define FD_COLOR_NONE	static_cast<SColorID>(-1)
#define FD_PATTERN_NONE_V12	static_cast<PatternIDV12>(-1)

#define FD_NO_EMFIMAGE	0xfff	// EmfImageID_xZkqqHx_iCmMiBeBiDeDiDiBiBfLiDfHjEpBjAnNjCoIjCgMiBeC_xHqqkZx_

// MC2ObjBase_xZkqqHx_iCoGiCoIiInKjDkOiBeC_xHqqkZx_Util.h_xZkqqHx_jCiGiCmFiOgHiCkEiClNiCnPiBeC_xHqqkZx_
enum FTPenType
{
	FDPT_NONE	= 0xff,	// _xZkqqHx_jFhDjCoIiBeC_xHqqkZx_
	FDPT_SOLID	= 0,	// _xZkqqHx_iPiDjAeGiBeC_xHqqkZx_
	FDPT_TRANSP,		// _xZkqqHx_jDkHjGlOiBeC_xHqqkZx_
	FDPT_PATTERN,		// _xZkqqHx_iDhAiDfOiBfLiDjDiBeC_xHqqkZx_
	FDPT_REGIST			// _xZkqqHx_jDgPjIfOjAnNjCoIiBeC_xHqqkZx_
};

enum FTBrushType
{
	FDBT_NONE	= 0xff,	// _xZkqqHx_jFhDjCoIiBeC_xHqqkZx_
	FDBT_SOLID	= 0,	// _xZkqqHx_iPiDjAeGjDgIjCnHiClFiBeC_xHqqkZx_
	FDBT_TRANSP,		// _xZkqqHx_jDkHjGlOiBeC_xHqqkZx_
	FDBT_PATTERN,		// _xZkqqHx_iDhAiDfOiBfLiDjDiBeC_xHqqkZx_
	FDBT_REGIST			// _xZkqqHx_jDgPjIfOjAnNjCoIiBeC_xHqqkZx_
};

class MC2SColorRec;
class MC2EmfImageRec;
class MC2PatternRec;
class MC2BrushRegisterRec;
class MC2PenRegisterRec;
class MC2PenStyleRec;
class MC2SFontRec;
class MC2ChipGroupRec;
class MC2ChipRec;
class MC2PictArrowRec;

// S_xZkqqHx_jAeGiBeCiDiMiDfCiBfLiDgIiCmG_xHqqkZx_ID_xZkqqHx_iDeJiBfLiDfPiBfLiBeC_xHqqkZx_
typedef	vector<MC2SColorRec*> MC2SColorRecVector;
// _xZkqqHx_iDiBiDfOiDhEiDeAiDeDiDiLiDhAiDfOiBfLiDjDiBeCiDiMiDfCiBfLiDgIiCmG_xHqqkZx_ID_xZkqqHx_iDeJiBfLiDfPiBfLiBeC_xHqqkZx_
typedef	vector<MC2EmfImageRec*> MC2EmfImageRecVector;
// _xZkqqHx_jDgIjCnHiClFjHhAjCfAjAeGiDhAiDfOiBfLiDjD_xHqqkZx_(_xZkqqHx_iOmOjApM_xHqqkZx_,etc)_xZkqqHx_iBeCiDiMiDfCiBfLiDgIiCmG_xHqqkZx_ID_xZkqqHx_iDeJiBfLiDfPiBfLiBeC_xHqqkZx_
typedef	vector<MC2PatternRec*> MC2PatternRecVector;
// _xZkqqHx_iDhFiDiJiDfGiCmMjDgPjIfOjGlMiBeCiDiMiDfCiBfLiDgIiCmG_xHqqkZx_ID_xZkqqHx_iDeJiBfLiDfPiBfLiBeC_xHqqkZx_
typedef	vector<MC2BrushRegisterRec*>	MC2BrushRegisterRecVector;
// _xZkqqHx_iDhJiDjDiCmMjDgPjIfOjGlMiBeCiDiMiDfCiBfLiDgIiCmG_xHqqkZx_ID_xZkqqHx_iDeJiBfLiDfPiBfLiBeC_xHqqkZx_
typedef	vector<MC2PenRegisterRec*> MC2PenRegisterRecVector;
// _xZkqqHx_iDhJiDjDiCmMiDfIiDfOiDeDiDiL_xHqqkZx_(_xZkqqHx_jClMjApM_xHqqkZx_,_xZkqqHx_jDfPjApM_xHqqkZx_,etc)_xZkqqHx_iBeCiDiMiDfCiBfLiDgIiCmG_xHqqkZx_ID_xZkqqHx_iDeJiBfLiDfPiBfLiBeC_xHqqkZx_
typedef	vector<MC2PenStyleRec*> MC2PenStyleRecVector;
// S_xZkqqHx_iDhEiDeIiDjDiDgHiBeCiDiMiDfCiBfLiDgIiCmG_xHqqkZx_ID_xZkqqHx_iDeJiBfLiDfPiBfLiBeC_xHqqkZx_
typedef	vector<MC2SFontRec*>	MC2SFontRecVector;
// _xZkqqHx_iDgAiDgCiDhGiDePiDiLiBfLiDhGiBeCiDiMiDfCiBfLiDgIiCmG_xHqqkZx_ID_xZkqqHx_iDeJiBfLiDfPiBfLiBeC_xHqqkZx_
typedef	vector<MC2ChipGroupRec*>	MC2ChipGroupRecVector;
// _xZkqqHx_iDgAiDgCiDhGiBeCiDiMiDfCiBfLiDgIiCmG_xHqqkZx_ID_xZkqqHx_iDeJiBfLiDfPiBfLiBeC_xHqqkZx_
typedef	vector<MC2ChipRec*> MC2ChipRecVector;
// _xZkqqHx_iDhDiDeOiDgAiDiDjGoOiIpDiBeCiDiMiDfCiBfLiDgIiCmG_xHqqkZx_ID_xZkqqHx_iDeJiBfLiDfPiBfLiBeC_xHqqkZx_
typedef	vector<MC2PictArrowRec*>	MC2PictArrowRecVector;

//----- 06.03.26 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//inline void FFInNameV12 (MCARCHIVE& ar, wchar_t szName[])
//{
//	// _xZkqqHx_jDgPjIfOjGlMiBeC_xHqqkZx_
//	BYTE byNameLen;
//	ar >> byNameLen;
//	TCHARVector vName(byNameLen + 1);
//	ar.Read(&vName.front(), byNameLen * sizeof(vName[0]));
//	vName[byNameLen] = _T('\0');
//	wcscpy(szName, (const wchar_t*)TStrToWStr(&vName.front()));
//} // FFOutNameV12.
//----- 06.03.26 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
inline void FFInNameV12 (MCARCHIVE& ar, wchar_t szName[])
{
	// _xZkqqHx_jDgPjIfOjGlMiBeC_xHqqkZx_
	BYTE byNameLen;
	ar >> byNameLen;
//----- 06.03.26 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_jAkHiMmAjClHiCpAjClEiCkGiCoJiPoKiNiHiCmNiBeBjEgKjBlJiBeC_xHqqkZx_
	if (FD_ENV_NAME_LEN_V12 <= byNameLen)
		FFUtilErrI->ThrowMiscExceptionCode(FD_IDS_ERR_FILE_DESTROIED);
//----- 06.03.26 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	vector<char> vName(byNameLen + 1);
	ar.Read(&vName.front(), byNameLen);
	vName[byNameLen] = '\0';
	wcscpy(szName, (const wchar_t*)AStrToWStr(&vName.front()));
} // FFOutNameV12.
//----- 06.03.26 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	MC2SColorRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jDgPjIfOjAeGiCmMiKmHjHjNiDiMiDfCiBfLiDgIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.30 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkMiBeC_xHqqkZx_
 *************************************************************************/
class MC2SColorRec
{
public:
	MC2SColorRec () {}
	MC2SColorRec (const ColorRefID crRef, const wchar_t* pName) :m_colRef(crRef)
		{
			if (m_szName != pName)
			{
				int iLen = (int)wcslen(pName);
				if (FD_ENV_NAME_LEN_V3 <= iLen) iLen = FD_ENV_NAME_LEN_V3 - 1;
				wcsncpy(m_szName, pName, iLen);
				m_szName[iLen] = L'\0';
			}
		}
	void InStreamV12 (MCARCHIVE& ar)
		{
			ar >> m_colRef;
			// _xZkqqHx_jDgPjIfOjGlMiBeC_xHqqkZx_
			FFInNameV12(ar, m_szName);
		}
	void OutStreamV3 (MCARCHIVE& ar) const
		{
			ar << m_colRef;
			// _xZkqqHx_jDgPjIfOjGlMiBeC_xHqqkZx_
			const BYTE byNameLen = (BYTE)wcslen(m_szName);
			ar << byNameLen;
			ar.Write(m_szName, byNameLen * sizeof(m_szName[0]));
		}

	void Clear () {}
public:
	COLORREF	m_colRef;
	wchar_t		m_szName[FD_ENV_NAME_LEN_V3];
}; // class MC2SColorRec.

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	MC2PatternRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiCiDgNiDeOiDiNiCmMjDgIiCoIjCnHiClFjHhAiDhAiDfOiBfLiDjDiDhCiDgCiDgHiDhNiDgCiDhG_xHqqkZx_.
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	m_pDIB_xZkqqHx_iCmN_xHqqkZx_ new _xZkqqHx_iIlNiCmN_xHqqkZx_ malloc_xZkqqHx_iCmFiKgNjFnLiClDiCoKiClNjHmMiIoGiCmFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
 *			_xZkqqHx_iCmIiClKiCmIiCoHiBeB_xHqqkZx_CBrush::CreateDIBPatternBrush_xZkqqHx_jCiGiCmF_xHqqkZx_ GlobalLock_xZkqqHx_iKnGjAjEiCmM_xHqqkZx_
 *			_xZkqqHx_iIpIjAjEiCmGiClFiCmEiOgHiCoNiCoKiCoJiCkJiCoHiCmFiCkAiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.11.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
class MC2PatternRec
{
public:
	MC2PatternRec ()
	{
		m_pDIB = NULL;
		m_szName[0] = L'\0';
	}
	~MC2PatternRec ()
		{
			Clear();
		}
	void InStreamV12 (MCARCHIVE& ar)
		{
			if (m_pDIB != NULL) delete m_pDIB;
			m_pDIB = new FCDIBMono8x8;
			ar.Read(m_pDIB, sizeof(FCDIBMono8x8));
			// _xZkqqHx_jDgPjIfOjGlMiBeC_xHqqkZx_
			FFInNameV12(ar, m_szName);
		}
	void OutStreamV3 (MCARCHIVE& ar) const
		{
			ar.Write(m_pDIB, sizeof(FCDIBMono8x8));
			// _xZkqqHx_jDgPjIfOjGlMiBeC_xHqqkZx_
			const BYTE byNameLen = (BYTE)wcslen(m_szName);
			ar << byNameLen;
			ar.Write(m_szName, byNameLen * sizeof(m_szName[0]));
		}
	void Clear ()
		{
			if (m_pDIB != NULL) delete m_pDIB;
			m_pDIB = NULL;
		}
public:
	FCDIBMono8x8*	m_pDIB;
	wchar_t			m_szName[FD_ENV_NAME_LEN_V3];
}; // class MC2PatternRec.

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	MC2PenStyleRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhJiDjDiCmMiDfIiDfOiDeDiDiLiBgJjIeBjBlBjApMiBeBjDfPjApMjDjJiBgKiCpAiKmHjHjNiClHiCoJiDiMiDfCiBfLiDgIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.30 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkMiBeC_xHqqkZx_
 *			99.06.29 Fukushiro M. _xZkqqHx_iDhAiDfOiBfLiDjDiCpAiOmAiNmAjFfHiMgOiCnGjFmPiNfIiBeC_xHqqkZx_
 *************************************************************************/
class MC2PenStyleRec
{
public:
	MC2PenStyleRec () {}
	void InStreamV12 (MCARCHIVE& ar)
		{
			ar.Read(m_mmfaData, sizeof(m_mmfaData));
			// _xZkqqHx_jDgPjIfOjGlMiBeC_xHqqkZx_
			FFInNameV12(ar, m_szName);
		}
	void OutStreamV3 (MCARCHIVE& ar) const
		{
			ar.Write(m_mmfaData, sizeof(m_mmfaData));
			// _xZkqqHx_jDgPjIfOjGlMiBeC_xHqqkZx_
			const BYTE byNameLen = (BYTE)wcslen(m_szName);
			ar << byNameLen;
			ar.Write(m_szName, byNameLen * sizeof(m_szName[0]));
		}
	void Clear () {}
public:
	float	m_mmfaData[4];
	wchar_t	m_szName[FD_ENV_NAME_LEN_V3];
}; // class MC2PenStyleRec.

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	MC2PenRegisterRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jDgPjIfOiDhJiDjDiCpAiKmHjHjNiClHiCoJiDiMiDfCiBfLiDgIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.30 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkMiBeC_xHqqkZx_
 *************************************************************************/
class MC2PenRegisterRec
{
public:
	MC2PenRegisterRec ();
	void	InStreamV12 (MCARCHIVE& ar);
	void	OutStreamV3 (MCARCHIVE& ar) const;
	void	Clear () {}

public:
	PenStyleID	m_psidPenStyle;		// PEN_xZkqqHx_iCmMiDfIiDfOiDeDiDiLiBeC_xHqqkZx_
	float		m_mmfPenWeight;		// PEN_xZkqqHx_iCmMjFjNiBeC_xHqqkZx_
	SColorID	m_scidPenBackSColor;// PEN_xZkqqHx_iCmMjEhHiMgJjAeGiBeC_xHqqkZx_
	wchar_t		m_szName[FD_ENV_NAME_LEN_V3];
									// _xZkqqHx_iClBiCmMjDgPjIfO_xHqqkZx_PEN_xZkqqHx_iCmMjGlMjBePiBeC_xHqqkZx_
}; // class MC2PenRegisterRec.

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	MC2BrushRegisterRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jDgPjIfOiDhFiDiJiDfGiCpAiKmHjHjNiClHiCoJiDiMiDfCiBfLiDgIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.30 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkMiBeC_xHqqkZx_
 *************************************************************************/
class MC2BrushRegisterRec
{
public:
	MC2BrushRegisterRec ();
	void	InStreamV12 (MCARCHIVE& ar);
	void	OutStreamV3 (MCARCHIVE& ar) const;
	void	Clear () {}

public:
	PatternID	m_ptidBrushPattern;		// BRUSH_xZkqqHx_iCmMiDiCiDgNiDhAiDfOiBfLiDjD_xHqqkZx_
	SColorID	m_scidBrushForeSColor;	// BRUSH_xZkqqHx_iCmMjBePiMgJjAeGiBeC_xHqqkZx_
	SColorID	m_scidBrushBackSColor;	// BRUSH_xZkqqHx_iCmMjEhHiMgJjAeGiBeC_xHqqkZx_
	wchar_t		m_szName[FD_ENV_NAME_LEN_V3];	// _xZkqqHx_iClBiCmMjDgPjIfO_xHqqkZx_BRUSH_xZkqqHx_iCmMjGlMjBePiBeC_xHqqkZx_
}; // class MC2BrushRegisterRec.

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	MC2EmfImageRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDfOiDhEiDeAiDeDiDiLiCmMiKmHjHjNjHhAiDiMiDfCiBfLiDgIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
class MC2EmfImageRec
{
public:
	MC2EmfImageRec ()
		{
			m_bypBits = NULL;
			m_lBitSize = 0;
			m_szName[0] = L'\0';
		}
	~MC2EmfImageRec ()
		{
			Clear();
		}
	void InStreamV12 (MCARCHIVE& ar)
		{
			ar >> m_lBitSize;					// m_bypBits_xZkqqHx_iCmMiDgPiDgCiDhEiDeAiDfEiDeDiDfJiBeC_xHqqkZx_
			if (m_bypBits != NULL) delete[] m_bypBits;
			m_bypBits = new BYTE[m_lBitSize];
			ar.Read(m_bypBits, m_lBitSize);		// _xZkqqHx_iDiBiDfOiDhEiDeAiDeDiDiLiCmMiDhCiDgCiDgHjHpBiDgPiDgCiDhEiDeAiBeC_xHqqkZx_
			// _xZkqqHx_jDgPjIfOjGlMiBeC_xHqqkZx_
			FFInNameV12(ar, m_szName);
		}
	void OutStreamV3 (MCARCHIVE& ar) const
		{
			ar << m_lBitSize;					// m_bypBits_xZkqqHx_iCmMiDgPiDgCiDhEiDeAiDfEiDeDiDfJiBeC_xHqqkZx_
			ar.Write(m_bypBits, m_lBitSize);	// _xZkqqHx_iDiBiDfOiDhEiDeAiDeDiDiLiCmMiDhCiDgCiDgHjHpBiDgPiDgCiDhEiDeAiBeC_xHqqkZx_
			// _xZkqqHx_jDgPjIfOjGlMiBeC_xHqqkZx_
			const BYTE byNameLen = (BYTE)wcslen(m_szName);
			ar << byNameLen;
			ar.Write(m_szName, byNameLen * sizeof(m_szName[0]));
		}
	void Clear ()
		{
			if (m_bypBits != NULL) delete[] m_bypBits;
			m_bypBits = NULL;
			m_lBitSize = 0;
		}
public:
	BYTE*	m_bypBits;					// _xZkqqHx_iDiBiDfOiDhEiDeAiDeDiDiLiCmMiDhCiDgCiDgHjHpBiDgPiDgCiDhEiDeAiBeC_xHqqkZx_
	long	m_lBitSize;					// m_bypBits_xZkqqHx_iCmMiDgPiDgCiDhEiDeAiDfEiDeDiDfJiBeC_xHqqkZx_
	wchar_t	m_szName[FD_ENV_NAME_LEN_V3];	// _xZkqqHx_iClBiCmMiDiBiDfOiDhEiDeAiDeDiDiLiCmMjDgPjIfOjGlMiBeC_xHqqkZx_
}; // class MC2EmfImageRec.


class MC2SFontRecV12
{
public:
	void	InStream (MCARCHIVE& ar);

public:
	double	m_mmFontHeight;	// FONT_xZkqqHx_jAlGjAkMiCmFiOhHjCoIiClHiCoJiNiCiClD_xHqqkZx_(mm)._xZkqqHx_jGhLjDjGiCmMiNiCiClDiCmFiCmNiCmIiCkC_xHqqkZx_.
	DWORD	m_dwEffects;
	BYTE	m_byCharSet;
	BYTE	m_byPitchAndFamily;
	CHAR	m_szFaceName[LF_FACESIZE];

	/*----- _xZkqqHx_iImIiJlKiCmN_xHqqkZx_TEXTMETRIC_xZkqqHx_iCmMiPoOjFpB_xHqqkZx_(mm).KnowHow.doc_xZkqqHx_iCpAiOfBiPmG_xHqqkZx_ -----*/
	double	m_mmTMAscent;
	double	m_mmTMDescent;
	double	m_mmTMInternalLeading;
	double	m_mmTMExternalLeading;
}; // class MC2SFontRecV12.

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	MC2SFontRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iChCiDhEiDeIiDjDiDgHiPoOjFpBiCpAiKmHjHjNiClHiCoJiDeOiDiJiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.02.19 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
class MC2SFontRec
{
public:
	MC2SFontRec ();
	MC2SFontRec (const MC2FontCharInfo& fci2);
	void	operator = (const MC2SFontRec& prop);
	BOOL	operator == (const MC2SFontRec& prop) const;
	void	OutStreamV3 (MCARCHIVE& ar) const;
	void	InStreamV12 (MCARCHIVE& ar);
	void	Clear () {}
	void	ReqInit (LOGFONT& lf) const;
	void	ReqInit (MC2FontCharInfo& fci2) const;
#if defined(_MBCS)
	void	ReqInitW (LOGFONTW& lf) const;
#endif // defined(_MBCS)
	void	Init (const MC2FontCharInfo& fci2);
	void	InitMetric ();

public:
	// m_dwEffects_xZkqqHx_iCmNjFlGiOjKiCmM_xHqqkZx_V2->V3_xZkqqHx_jFmPiKlHjHhAiCmJjFeLjHhGiCmIiCmMiCmFiOgDiClFiCmEiCkIiCkNiBeC_xHqqkZx_
	DWORD	m_dwEffects;

protected:
	mmetol	m_mmFontHeight;	// FONT_xZkqqHx_jAlGjAkMiCmFiOhHjCoIiClHiCoJiNiCiClD_xHqqkZx_(mm)._xZkqqHx_jGhLjDjGiCmMiNiCiClDiCmFiCmNiCmIiCkC_xHqqkZx_.
	WORD	m_wWeight;
	BYTE	m_byItalic;
	BYTE	m_byCharSet;
	BYTE	m_byPitchAndFamily;
	BYTE	dummy1;
	wchar_t	m_szFaceName[LF_FACESIZE];
}; // class MC2SFontRec.

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	MC2ChipRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgAiDgCiDhGiPoOjFpBiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
class MC2ChipRec
{
public:
	MC2ChipRec ();
	~MC2ChipRec ();
	void InStreamV12 (MCARCHIVE& ar);
	void OutStreamV3 (MCARCHIVE& ar) const;
	void Clear ();

public:
	MC2ObjBase*	m_objpChipMaster;
	wchar_t		m_szName[FD_ENV_NAME_LEN_V3];
}; // class MC2ChipRec.

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	MC2ChipGroupRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgAiDgCiDhGiDePiDiLiBfLiDhGiPoOjFpBiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
class MC2ChipGroupRec
{
public:
	// _xZkqqHx_iImIiJlKiCmMiKnGjAjEiMfBiCmFiCmNiBeB_xHqqkZx_m_vFreqChip _xZkqqHx_iCmNiCkCiCmBiClDiCkCiIlFiCoNiCmIiCkCiBeC_xHqqkZx_
	// m_vFreqChip _xZkqqHx_iCmNiBeB_xHqqkZx_DistributeChipToGroup/CollectChipToGroup_xZkqqHx_iCmFiCmMiCnN_xHqqkZx_
	// _xZkqqHx_jFmPiNfIiClDiCoKiCoJiCoAiCmMiCmGiClHiCoJiBeC_xHqqkZx_
	MC2ChipGroupRec ()  { memset(this, 0, sizeof(*this)); }
	void OutStreamV3 (MCARCHIVE& ar) const
		{
			// _xZkqqHx_jDgPjIfOjGlMiBeC_xHqqkZx_
			const BYTE byNameLen = (BYTE)wcslen(m_szName);
			ar << byNameLen;
			ar.Write(m_szName, byNameLen * sizeof(wchar_t));
		}

public:
	wchar_t			m_szName[FD_ENV_NAME_LEN_V3];
}; // class MC2ChipGroupRec.

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	MC2PictArrowRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgAiDgCiDhGiPoOjFpBiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
class MC2PictArrowRec
{
public:
	MC2PictArrowRec ();
	~MC2PictArrowRec ();
	void OutStreamV3 (MCARCHIVE& ar) const;
	void Clear ();

public:
	MC2ObjBase*	m_objpPictArrowMaster1;
	MC2ObjBase*	m_objpPictArrowMaster2;
	wchar_t		m_szName[FD_ENV_NAME_LEN_V3];
}; // class MC2PictArrowRec.

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	MC2Env
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iKmCiLkLiCmJiDeBiDeOiDfKiDfIiClHiCoJiKnGjAjEiCpAjBfDiCmEiDhGiDiNiDgFiDeOiDgHiKnGjAjEiCmJiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.29 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
class MC2Env
{
public:
	MC2Env ();
	~MC2Env ();
	void	ClearEnvTbl ();

	void	OutStreamV3 (MCARCHIVE& ar);
	void	InStreamV12 (MCARCHIVE& ar);
	void	InStreamChipV12 (MCARCHIVE& ar);

	COLORREF scid2cref (SColorID scidSColor) const;
	SFontID FindSameFont (SFontID) const;

	void	GetDocPageSize (mmetol& mmPageWidth, mmetol& mmPageHeight) const;


	void	OutStreamCanvasStatV3 (MCARCHIVE& ar) const;

public:
	// _xZkqqHx_iKmCiLkLiDgFiBfLiDhFiDiL_xHqqkZx_
	// _xZkqqHx_iCoGiCkNiOgHiCkEiDiMiDfCiBfLiDgIiCmM_xHqqkZx_ID_xZkqqHx_iDiKiDfIiDgH_xHqqkZx_.
	// _xZkqqHx_iKmCiLkL_xHqqkZx_ID <-> _xZkqqHx_iDfEiDhFiKmCiLkL_xHqqkZx_ID_xZkqqHx_jFmPiKlHiDgFiBfLiDhFiDiL_xHqqkZx_.

// S_xZkqqHx_jAeG_xHqqkZx_
	MC2SColorRecVector	m_vSColor;
	FDSColorIDVector	m_vFreqSColor;

// _xZkqqHx_iDiBiDfOiDhEiDeAiDeDiDiLiDhAiDfOiBfLiDjD_xHqqkZx_
	MC2EmfImageRecVector	m_vEmfImage;
	FDEmfImageIDVector	m_vFreqEmfImage;

// _xZkqqHx_iDhFiDiJiDfGiCmMjDgPjIfOjGlM_xHqqkZx_
	MC2BrushRegisterRecVector	m_vBrushRegister;
	FDBrushRegisterIDVector	m_vFreqBrushRegister;

// _xZkqqHx_iDhJiDjDiCmMjDgPjIfOjGlM_xHqqkZx_
	MC2PenRegisterRecVector	m_vPenRegister;
	FDPenRegisterIDVector	m_vFreqPenRegister;

// _xZkqqHx_iDhJiDjDiCmMiDfIiDfOiDeDiDiL_xHqqkZx_(_xZkqqHx_jClMjApM_xHqqkZx_,_xZkqqHx_jDfPjApM_xHqqkZx_,etc)
	MC2PenStyleRecVector	m_vPenStyle;
	FDPenStyleIDVector	m_vFreqPenStyle;

// S_xZkqqHx_iDhEiDeIiDjDiDgH_xHqqkZx_
	MC2SFontRecVector	m_vSFont;
	FDSFontIDVector	m_vFreqSFont;

// _xZkqqHx_iDgAiDgCiDhGiDePiDiLiBfLiDhG_xHqqkZx_
	MC2ChipGroupRecVector	m_vChipGroup;
	FDChipGroupIDVector	m_vFreqChipGroup;

// _xZkqqHx_iDgAiDgCiDhG_xHqqkZx_
	MC2ChipRecVector	m_vChip;
	FDChipIDVector	m_vFreqChip;

// _xZkqqHx_iDhDiDeOiDgAiDiDjGoOiIpD_xHqqkZx_
	MC2PictArrowRecVector	m_vPictArrow;
	FDPictArrowIDVector	m_vFreqPictArrow;


protected:
	DBLPoint	m_mmptShadowLen;		// _xZkqqHx_iJgFiCmMjClHiClDiBeC_xHqqkZx_
	//----- _xZkqqHx_jHhAiOiGiCmMiDhGiDiNiDhAiDgFiDeC_xHqqkZx_ -----
	short		m_nDocPaperOrient;		// _xZkqqHx_jHhAiOiGiCmMjFpLiMpMiBeC_xHqqkZx_
	short		m_nDocPaperType;		// _xZkqqHx_jCoIiMgAjHhAiOiGiCmMiDfOiDeDiDhGiBeC_xHqqkZx_ A4,B5,etc.
	double		m_mmDocPaperWidth;		// _xZkqqHx_jHhAiOiGiCmMjFjNiBeCjHhAiOiGiCmMjFpLiMpMiCmNjAeEiCoIiNjOiCnNiNmPiBeC_xHqqkZx_
	double		m_mmDocPaperHeight;		// _xZkqqHx_jHhAiOiGiCmMiNiCiClDiBeCjHhAiOiGiCmMjFpLiMpMiCmNjAeEiCoIiNjOiCnNiNmPiBeC_xHqqkZx_
	double		m_mmDocPaperMarginL;	// _xZkqqHx_jHhAiOiGiCmMiNlGjHfNjEjCiBeC_xHqqkZx_
	double		m_mmDocPaperMarginT;	// _xZkqqHx_jHhAiOiGiCmMiPoDjHfNjEjCiBeC_xHqqkZx_
	double		m_mmDocPaperMarginR;	// _xZkqqHx_jHhAiOiGiCmMiJeFjHfNjEjCiBeC_xHqqkZx_
	double		m_mmDocPaperMarginB;	// _xZkqqHx_jHhAiOiGiCmMiJlKjHfNjEjCiBeC_xHqqkZx_
	double		m_dDocPageTimesX;		// _xZkqqHx_jHhAiOiGjBmOiDhJiBfLiDfHiCmM_xHqqkZx_X_xZkqqHx_jEhLjHkGiBeC_xHqqkZx_
	double		m_dDocPageTimesY;		// _xZkqqHx_jHhAiOiGjBmOiDhJiBfLiDfHiCmM_xHqqkZx_Y_xZkqqHx_jEhLjHkGiBeC_xHqqkZx_
	DBLRect		m_mmrtSheet;			// _xZkqqHx_iDfGiBfLiDgHiCmMjBoFiCkLiClDiBeC_xHqqkZx_
	//----- _xZkqqHx_iDhGiDiKiDjDiDfOiCmMiDhGiDiNiDhAiDgFiDeC_xHqqkZx_ -----
	BOOL		m_bUseDocMarginAsPrn;	// _xZkqqHx_jHhAiOiGiCmMjHfNjEjCjCgMiCpAiOgHiCkEiCkJiBeI_xHqqkZx_
	double		m_mmPrnPaperMarginL;	// _xZkqqHx_jHhAiOiGiCmMiNlGjHfNjEjCiBeC_xHqqkZx_
	double		m_mmPrnPaperMarginT;	// _xZkqqHx_jHhAiOiGiCmMiPoDjHfNjEjCiBeC_xHqqkZx_
	double		m_mmPrnPaperMarginR;	// _xZkqqHx_jHhAiOiGiCmMiJeFjHfNjEjCiBeC_xHqqkZx_
	double		m_mmPrnPaperMarginB;	// _xZkqqHx_jHhAiOiGiCmMiJlKjHfNjEjCiBeC_xHqqkZx_
}; // class MC2Env.

#endif//__Env_h
