#include "stdafx.h"
#include "resource.h"		// For IDS_XXX.
#include "2LayerManager.h"	// For MC2LayerManager.
#include "2ObjBase.h"		// For MC2ObjBase.
#include "2NewFDObjAny.h"	// For NewFDObjAny.
#include "2SheetManager.h"	// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2SheetManager::MC2SheetManager
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
MC2SheetManager::MC2SheetManager ()
{
	Initialize();
} // MC2SheetManager::MC2SheetManager.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2SheetManager::~MC2SheetManager
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
MC2SheetManager::~MC2SheetManager ()
{
	Clear();
} // MC2SheetManager::~MC2SheetManager.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2SheetManager::Initialize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfGiBfLiDgHiDhNiDgMiBfLiDfHiDiDiCpAiPiJiKpKiJlLiClHiCoJiBeCiNmFiPoDiImKiBeBiNmFiJlKiImKiDiMiDeDiDiEiBfLiBeBjCiGiKnE_xHqqkZx_
 *			_xZkqqHx_iDiMiDeDiDiEiBfLiCmMiDgGiDhEiDeIiDiLiDgHjCgMiCpAjAnNjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void MC2SheetManager::Initialize ()
{
	Clear();
	// "_xZkqqHx_iDfGiBfLiDgH_xHqqkZx_1"_xZkqqHx_iBeC_xHqqkZx_
	CString strRes;
	strRes.LoadString(IDS_UNTITLED_SHEET);
	CString strName;
	strName.Format(_T("%s1"), (const _TCHAR*)strRes);
	// _xZkqqHx_iDfGiBfLiDgHiDeDiDjDiDgGiDgCiDeOiDfI_xHqqkZx_ = 0_xZkqqHx_iBeBiDfGiBfLiDgH_xHqqkZx_ID = 0 _xZkqqHx_iCmFiDfGiBfLiDgHjBhNjDpMiBeC_xHqqkZx_
	SheetID stidNew;
	InsertSheet(stidNew, TStrToWStr(strName), 0, 0);
	//----- _xZkqqHx_iDfGiBfLiDgH_xHqqkZx_0_xZkqqHx_iCmJiDiMiDeDiDiEiBfL_xHqqkZx_1_xZkqqHx_iCpAjBhNjDpM_xHqqkZx_ -----
	// "_xZkqqHx_iDiMiDeDiDiEiBfL_xHqqkZx_1"_xZkqqHx_iBeC_xHqqkZx_
	strRes.LoadString(IDS_UNTITLED_LAYER);
	strName.Format(_T("%s1"), (const _TCHAR*)strRes);
	GetSheet(0)->InsertLayer(1, TStrToWStr(strName), FDOZ_ON_ALL);
	GetSheet(0)->SetCurrentLayerIdx(1);
	// _xZkqqHx_iDeKiDiMiDjDiDgHiDiMiDeDiDiEiBfLiDhNiDgMiBfLiDfHiDiDiBeC_xHqqkZx_
	m_stidCurrentSheet = 0;
} // MC2SheetManager::Initialize.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2SheetManager::Clear
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMiNoNiPjMiPiIjHjNiCmNiClJiClIiBeBiDfGiBfLiDgHiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void MC2SheetManager::Clear ()
{
	//----- _xZkqqHx_jBfDiCmEiCmMiDfGiBfLiDgHiCpAiDeOiDiKiDeB_xHqqkZx_ -----
	MC2LayerManagerPVector::iterator iZb;
	for (iZb = m_vSheet.begin(); iZb != m_vSheet.end(); iZb++)
		if (*iZb != NULL) delete *iZb;
	m_vSheet.clear();
	m_vFreqSheet.clear();
	// _xZkqqHx_iDgOiDgCiDfGiDiFiDgFiBfLiDhFiDiLiCpAiDeOiDiKiDeBiBeC_xHqqkZx_
	m_mpObjToLZHash.clear();
	// _xZkqqHx_iNmFiJlKiImKiDiMiDeDiDiEiBfLiCpAiDeOiDiKiDeBiBeC_xHqqkZx_
	m_vBottomLayer.clear();
	// _xZkqqHx_iNmFiPoDiImKiDiMiDeDiDiEiBfLiCpAiDeOiDiKiDeBiBeC_xHqqkZx_
	m_vTopLayer.clear();
	// _xZkqqHx_iDeKiDiMiDjDiDgHiDiMiDeDiDiEiBfLiDhNiDgMiBfLiDfHiDiDiBeC_xHqqkZx_
	m_stidCurrentSheet = 0;
} // MC2SheetManager::Clear.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2SheetManager::DeleteAll
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfGiBfLiDgHiDhNiDgMiBfLiDfHiDiDjCiGiCmMjBfDiCmEiCmMjFjEjFgJiCmMiNoNiPjMiPiIjHjNiCpAiOmAiNhDiClFiBeBiDfGiBfLiDgHiCpA_xHqqkZx_
 *			_xZkqqHx_iNoNiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void MC2SheetManager::DeleteAll ()
{
	//----- _xZkqqHx_jBfDiCmEiCmMiDfGiBfLiDgHiCpAiNoNiPjMiBjFiDeOiDiKiDeB_xHqqkZx_ -----
	MC2LayerManagerPVector::iterator iZb;
	for (iZb = m_vSheet.begin(); iZb != m_vSheet.end(); iZb++)
		if (*iZb != NULL)
		{
			(*iZb)->DeleteAll();
			delete *iZb;
		}
	m_vSheet.clear();
	m_vFreqSheet.clear();
	// _xZkqqHx_iDgOiDgCiDfGiDiFiDgFiBfLiDhFiDiLiCpAiDeOiDiKiDeBiBeC_xHqqkZx_
	m_mpObjToLZHash.clear();
	//----- _xZkqqHx_iNmFiJlKiImKiDiMiDeDiDiEiBfLiCpAiNoNiPjMiBjFiDeOiDiKiDeB_xHqqkZx_ -----
	MC2ObjBaseVector::iterator iObj;
	for (iObj = m_vBottomLayer.begin(); iObj != m_vBottomLayer.end(); iObj++)
		delete *iObj;
	m_vBottomLayer.clear();
	//----- _xZkqqHx_iNmFiPoDiImKiDiMiDeDiDiEiBfLiCpAiNoNiPjMiBjFiDeOiDiKiDeB_xHqqkZx_ -----
	for (iObj = m_vTopLayer.begin(); iObj != m_vTopLayer.end(); iObj++)
		delete *iObj;
	m_vTopLayer.clear();
	// _xZkqqHx_iDeKiDiMiDjDiDgHiDiMiDeDiDiEiBfLiDhNiDgMiBfLiDfHiDiDiBeC_xHqqkZx_
	m_stidCurrentSheet = 0;
//----- 01.05.25 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // MC2SheetManager::DeleteAll.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2SheetManager::OutStreamV3
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiBfLiDfOiCpAiPgPjHmNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ar	:_xZkqqHx_iPgPjHmNjAoGiDeBiBfLiDeKiDeDiDhFiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void MC2SheetManager::OutStreamV3 (MCARCHIVE& ar) const
{
	//----- _xZkqqHx_iDfGiBfLiDgHiCpAiPgPjHmN_xHqqkZx_ -----
	FDSheetIDVector::const_iterator iSheetID;
	// _xZkqqHx_iDfGiBfLiDgHiCmMjAjEiCpAiPgPjHmNiClHiCoJiBeC_xHqqkZx_
	ar << long(m_vFreqSheet.size());
	for (iSheetID = m_vFreqSheet.begin(); iSheetID != m_vFreqSheet.end(); iSheetID++)
	{
		ar.Write(&(*iSheetID), sizeof(*iSheetID));
		m_vSheet[*iSheetID]->OutStreamV3(ar);
	}
	//----- _xZkqqHx_iNmFiJlKiImKiDiMiDeDiDiEiBfLiCmMjFjEjFgJiCpAiPgPjHmN_xHqqkZx_ -----
	MC2ObjBaseVector::const_iterator iObj;
	// _xZkqqHx_jFjEjFgJiCmMjAjEiCpAiPgPjHmNiClHiCoJiBeC_xHqqkZx_
	ar << (DWORD)m_vBottomLayer.size();
	for (iObj = m_vBottomLayer.begin(); iObj != m_vBottomLayer.end(); iObj++)
	{
		(*iObj)->OutByteTypeAndStream(ar);
	}
	//----- _xZkqqHx_iNmFiPoDiImKiDiMiDeDiDiEiBfLiCmMjFjEjFgJiCpAiPgPjHmN_xHqqkZx_ -----
	// _xZkqqHx_jFjEjFgJiCmMjAjEiCpAiPgPjHmNiClHiCoJiBeC_xHqqkZx_
	ar << (DWORD)m_vTopLayer.size();
	for (iObj = m_vTopLayer.begin(); iObj != m_vTopLayer.end(); iObj++)
	{
		(*iObj)->OutByteTypeAndStream(ar);
	}
} // MC2SheetManager::OutStreamV3.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2SheetManager::GetSheet
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCmMiDfGiBfLiDgHiBgJiDiMiDeDiDiEiBfLiDhNiDgMiBfLiDfHiDiDiBgKiCpAiOoGjDlOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	stid	:_xZkqqHx_iDfGiBfLiDgHiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiMiDeDiDiEiBfLiDhNiDgMiBfLiDfHiDiDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
MC2LayerManager* MC2SheetManager::GetSheet (SheetID stid) const
{
	return m_vSheet[stid];
} // MC2SheetManager::GetSheet.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2SheetManager::GetFrontSheet
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iNmFiPiJiCmMiDfGiBfLiDgHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iNmFiPiJiCmMiDfGiBfLiDgHiBeCjGlDiCkCiPoKiNiHiCmN_xHqqkZx_ NULL_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
MC2LayerManager* MC2SheetManager::GetFrontSheet () const
{
	if (GetSheetIndexSize() == 0) return NULL;
	return GetSheet(SheetIndexToID(0));
} // MC2SheetManager::GetFrontSheet.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2SheetManager::IsEmpty
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfGiBfLiDgHjCiGiCmJjFjEjFgJiCkKiCkAiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfGiBfLiDgHjCiGiCmJjFjEjFgJiCkKiIoKiCmCiCoAjGlDiCkCiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL MC2SheetManager::IsEmpty () const
{
	return m_mpObjToLZHash.empty();
} // MC2SheetManager::IsEmpty.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2SheetManager::InsertSheet
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfGiBfLiDgHiCpAjBhNjDpMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	stid	:_xZkqqHx_jBhNjDpMiImKjChFiCpAiOhHjCoIiBeCjBhNjDpMiMoDiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCkKiClBiCmMjCgMiBeC_xHqqkZx_
 *			tcpName		:_xZkqqHx_jBhNjDpMiClHiCoJiDfGiBfLiDgHiCmMjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeKiDiMiDjDiDgHiDfGiBfLiDgHiImKjChFiCmJjBhNjDpMiClFiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void MC2SheetManager::InsertSheet (SheetID& stidNew, const wchar_t* tcpName, SheetID stid, DWORD dwIdx)
{
	stidNew = stid;
	// _xZkqqHx_jAfGiLeLiNoMjAkMiClHiCoJiDiMiDfCiBfLiDgIiCmM_xHqqkZx_ID_xZkqqHx_iCpAiOoGjDlOiBeC_xHqqkZx_
	if (stidNew == FD_SHEET_UNSPECIFY)
		stidNew = GetFreeSheetID();
	// _xZkqqHx_jAfGiLeLiNoMjAkMiClHiCoJiDiMiDfCiBfLiDgIiCpAjBhNjDpMiClHiCoJiDeDiDjDiDgGiDgCiDeOiDfIiCpAjAnNjCoIiBeC_xHqqkZx_
	if (dwIdx == DWORD(-1))
		m_vFreqSheet.push_back(stidNew);
	else
		m_vFreqSheet.insert(m_vFreqSheet.begin() + dwIdx, stidNew);
	// _xZkqqHx_iDfGiBfLiDgHiCpAjAnNjCoIiBeC_xHqqkZx_
	if (m_vSheet.size() <= stidNew)
		m_vSheet.resize(stidNew + 1, NULL);
	m_vSheet[stidNew] = new MC2LayerManager(tcpName, m_mpObjToLZHash, m_vBottomLayer, m_vTopLayer);
} // MC2SheetManager::InsertSheet.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2SheetManager::GetFreeSheetID
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	SheetID_xZkqqHx_iCmMiLpDiCkCiCmEiCkCiCoJ_xHqqkZx_ID_xZkqqHx_iCpAjCfEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iLpDiCkCiCmEiCkCiCoJ_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
SheetID MC2SheetManager::GetFreeSheetID () const
{
	SheetID stid;
	for	(stid = 0; stid < GetSheetIDSize(); stid++)
		if (GetSheet(stid) == NULL) break;
	return stid;
} // MC2SheetManager::GetFreeSheetID.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2SheetManager::SheetIndexToID
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfGiBfLiDgHiDeDiDjDiDgGiDgCiDeOiDfIiCpAiDfGiBfLiDgH_xHqqkZx_ID_xZkqqHx_iCmJjFmPiKlHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwIndex	:_xZkqqHx_iDfGiBfLiDgHiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfGiBfLiDgH_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
SheetID MC2SheetManager::SheetIndexToID (DWORD dwIndex) const
{
	return m_vFreqSheet.at(dwIndex);
} // MC2SheetManager::SheetIndexToID.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2SheetManager::GetSheetIDSize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfGiBfLiDgH_xHqqkZx_ID_xZkqqHx_iCmMiDfEiDeDiDfJiBgJjBkGiClPiDfGiBfLiDgHiDiMiDfCiBfLiDgIiDiKiDfIiDgHiCmMiDfEiDeDiDfJiBgKiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfGiBfLiDgH_xHqqkZx_ID_xZkqqHx_iCmMiDfEiDeDiDfJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
SheetID MC2SheetManager::GetSheetIDSize () const
{
	return (SheetID)m_vSheet.size();
} // MC2SheetManager::GetSheetIDSize.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2SheetManager::GetSheetIndexSize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfGiBfLiDgHiDeDiDjDiDgGiDgCiDeOiDfIiCmMiDfEiDeDiDfJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfGiBfLiDgHiDeDiDjDiDgGiDgCiDeOiDfIiCmMiDfEiDeDiDfJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DWORD MC2SheetManager::GetSheetIndexSize () const
{
	return (DWORD)m_vFreqSheet.size();
} // MC2SheetManager::GetSheetIndexSize.
