// PgMetaCon.cpp : DLL _xZkqqHx_iDeBiDhGiDiKiDfAiBfLiDfGiDiHiDjDjHhAiCmMiDeHiDjDiDgHiDiK_xHqqkZx_ _xZkqqHx_iDhMiDeDiDjDiDgHiCpAjCoIiLgAiClFiCnMiClHiBeC_xHqqkZx_
//

#include "stdafx.h"
#include <assert.h>			// For assert.
#include <tchar.h>			// For _TCHAR.
#include "Module.h"			// For FMpgGetModule.
#include "resource.h"		// For IDC_CHK_USE_ANTI_ALIAS.
#include "PgMetaCon.h"		// This header.

// _xZkqqHx_iClBiCmMiDhGiDiJiDePiDeDiDjDiDfCiDjDiDhMiBfLiDgMiDjDiDgHiCmM_xHqqkZx_CLSID_xZkqqHx_iBeC_xHqqkZx_
// _xZkqqHx_iDhGiDiJiDePiDeDiDjDiDfCiDjDiDhMiBfLiDgMiDjDiDgHiClCiCmGiCmJiMmFjHeMiCmM_xHqqkZx_CLSID_xZkqqHx_iCkKjFeLjHhGiCmFiClHiBeC_xHqqkZx_
// _xZkqqHx_iMmFjHeMiCmM_xHqqkZx_CLSID_xZkqqHx_iCmNiBeB_xHqqkZx_guidgen.exe _xZkqqHx_iCmFiOoGjDlOiCmFiCkLiCnMiClHiBeC_xHqqkZx_
// {30115BB3-120E-4bc4-B232-FDCB194B38B9}
static const GUID PG_COMPONENT_1_CLSID = { 0x30115bb3, 0x120e, 0x4bc4, { 0xb2, 0x32, 0xfd, 0xcb, 0x19, 0x4b, 0x38, 0xb9 } };

#define HID_BASE_RESOURCE   0x00020000UL	// For Help HID_XXX.

static const wchar_t* s_wcpComponentVersion = L"4.0";

#ifdef PG_JP
#include "JP.DATA"
#else//PG_JP
#include "ENG.DATA"
#endif//PG_JP

static const wchar_t PG_MENU_SHORTCUT[] =
{
	L'G',
	L'B',
	L'A',
//	L'T',
};

//---- _xZkqqHx_iDgGiDhEiDeIiDiLiDgHjCgM_xHqqkZx_ -----
const short	DEFAULT_IS_USE_ANTI_ALIAS = TRUE;

#define PG_FORMAT_JPEG	0
#define PG_FORMAT_PNG	1
#define PG_FORMAT_TIF	2
#define PG_FORMAT_PSD	3
#define PG_FORMAT_BMP	4

static const wchar_t* PG_FILE_FORMAT_NAME[] =
{
	L"JPEG file (*.jpg)",
	L"PNG file (*.png)",
	L"TIFF file (*.tif)",
	L"PSD file (*.psd)",
	L"Bitmap file (*.bmp)",
};
static const wchar_t* PG_FILE_FORMAT_EXT[] =
{
	L".jpg",
	L".png",
	L".tif",
	L".psd",
	L".bmp",
};

/////////////////////////////////////////////////////////////////////////////////

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CA::GetComponentCLSID
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDhMiBfLiDgMiDjDiDgHiCmM_xHqqkZx_CLSID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	CLSID_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const GUID& CA::GetComponentCLSID () const
{
	return PG_COMPONENT_1_CLSID;
} // CA::GetComponentCLSID.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CA::GetAuthorName
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDhMiBfLiDgMiDjDiDgHiCmMiNoMiOnCjGlMiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDhMiBfLiDgMiDjDiDgHiCmMiNoMiOnCjGlMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.12.09 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const wchar_t* CA::GetAuthorName () const
{
	return PG_AUTHOR_NAME;
} // CA::GetAuthorName.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CA::GetComponentName
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiCiDfHiDiFiBfLiDiLjGlMiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiCiDfHiDiFiBfLiDiLjGlMjFlGiOjKjHpBiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDiCiDfHiDiFiBfLiDiLjGlMiCmNiBeBiDiBiDgKiDiFiBfLiCmMiDfEiDhFiDiBiDgKiDiFiBfLjGlMiCmIiCmHiCmFiOgHiCoNiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iMlOiMoKiDfCiBfLiDgIiCmJjCiNiInDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.09.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const wchar_t* CA::GetComponentName () const
{
	return PG_COMPONENT_NAME;
} // CA::GetComponentName.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CA::GetVersionName
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgPiBfLiDfHiDiHiDjDjGlMiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDgPiBfLiDfHiDiHiDjDjGlMjFlGiOjKjHpBiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.09.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const wchar_t* CA::GetVersionName () const
{
	return s_wcpComponentVersion;
} // CA::GetVersionName.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CA::GetComment
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDfCiDjDiDhMiBfLiDgFiDjDiDgHiCmMiJpAjAoAiDfCiDiBiDjDiDgHiCpAjFnEiClHiBeCjGlDiCkCiPoKiNiHiCmN_xHqqkZx_ NULL_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFlGiOjKjHpBiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.09.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const wchar_t* CA::GetComment () const
{
	return PG_COMMENT;
} // CA::GetComment.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CA::GetComponentShortcut
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiCiDfHiDiFiBfLiDiLiCpAiDiBiDgKiDiFiBfLiCmJjDgPjIfOiClHiCoJiCmGiCkLiCmMiDfGiDiHiBfLiDgHiDeKiDgCiDgHiDeMiBfLiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeMiBfLiDfCiBfLiDgIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClFiClNiDeMiBfLiCkKjFeLiClIjDgPjIfOiCmFiCkLiCoJiCoNiCkPiCmFiCmNiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.09.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
wchar_t CA::GetComponentShortcut () const
{
	return L'A';
} // CA::GetComponentShortcut.

/////////////////////////////////////////////////////////////////////////////////

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CA::Initialize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiCiDfHiDiFiBfLiDiLiCpAiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pI	:Molip Draw_xZkqqHx_jBkEiCmMiDeDiDjDiDfOiDhEiDeGiBfLiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_ S_OK_xZkqqHx_iBeBiOlIjEhDiClFiClNiPoKiNiHiCmNiDeHiDiJiBfLiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.09.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
HRESULT CA::Initialize (IMpgMolipMain* pI)
{
	// m_adwCommandId _xZkqqHx_iCmMjEhKjHpBiDfEiDeDiDfJiCmNiBeBiDhGiDiJiDePiDeDiDjDiCmFiDfEiDhMiBfLiDgHiClHiCoJiDfCiDhNiDjDiDgIiCmJiNiHiCoNiClJiCmEiCkIiCkNiClBiCmGiBeC_xHqqkZx_
	assert((sizeof(PG_MENU) / sizeof(PG_MENU[0])) <= (sizeof(m_adwCommandId) / sizeof(m_adwCommandId[0])));
	assert((sizeof(PG_FILE_FORMAT_NAME) / sizeof(PG_FILE_FORMAT_NAME[0])) <= (sizeof(m_adwFormatId) / sizeof(m_adwFormatId[0])));

	// Molip Draw_xZkqqHx_iCmMiDiBiDeDiDjDiDeDiDjDiDfOiDhEiDeGiBfLiDfIiCpAiOoGjDlOiBeC_xHqqkZx_
	if (FAILED(IMpgInterface::Initialize(pI))) return E_FAIL;

	// _xZkqqHx_iDiCiDfHiDiFiBfLiDiLiCkKiDfEiDhMiBfLiDgHiClHiCoJiDfCiDhNiDjDiDgIiCpAjDgPjIfOiBeC_xHqqkZx_
	for (int iC = 0; iC != sizeof(PG_MENU) / sizeof(PG_MENU[0]); iC++)
	{
		m_adwCommandId[iC] = GetMolipMainI()->RegisterCommand(TRUE, PG_MENU[iC],
																PG_MENU_SHORTCUT[iC]);
	}
	// _xZkqqHx_iDiCiDfHiDiFiBfLiDiLiCkKiDfEiDhMiBfLiDgHiClHiCoJiDhEiDeAiDeDiDiLiDhEiDeIiBfLiDhNiDgCiDgHiCpAjDgPjIfOiBeC_xHqqkZx_
	for (int iC = 0; iC != sizeof(PG_FILE_FORMAT_NAME) / sizeof(PG_FILE_FORMAT_NAME[0]); iC++)
	{
		m_adwFormatId[iC] = GetMolipMainI()->RegisterSelObjSaveFormat(
									PG_FILE_FORMAT_NAME[iC], PG_FILE_FORMAT_EXT[iC]);
	}
	return S_OK;
} // CA::Initialize.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CA::Terminate
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiCiDfHiDiFiBfLiDiLiCmMiPeJjHlJiPiIjHjNiCpAiNhDiCkEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_ S_OK_xZkqqHx_iBeBiOlIjEhDiClFiClNiPoKiNiHiCmNiDeHiDiJiBfLiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.09.29 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
HRESULT CA::Terminate ()
{
	// Molip Draw_xZkqqHx_iCmMiDiBiDeDiDjDiDeDiDjDiDfOiDhEiDeGiBfLiDfIiCpAiKeKjFpKiBeC_xHqqkZx_
	return IMpgInterface::Terminate();
} // CA::Terminate.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	myDialogProc
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDfOiDfCiDjDjAnNjCoIiDfPiDeDiDeBiDiNiDePiCmMjAkHiMoEiDfCiBfLiDiLiDgPiDgCiDeOiKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	hwndDlg	:_xZkqqHx_iDfPiDeDiDeBiDiNiDePiCmMiDgOiDjDiDgIiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *			uMsg	:_xZkqqHx_iDiBiDgCiDfKiBfLiDfH_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			wParam	:wParam_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			lParam	:lParam_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiBiDgCiDfKiBfLiDfHiCkKiPiIjHjNiCmFiCkLiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBiPiIjHjNiCmFiCkLiCmIiCkJiCmBiClNiPoKiNiHiCmN_xHqqkZx_
 *			FALSE_xZkqqHx_iBeC_xHqqkZx_FALSE_xZkqqHx_iCpAjFnEiClFiClNiPoKiNiHiCmNiDgGiDhEiDeIiDiLiDgHiPiIjHjNiCkKiNhDiCoNiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
static INT_PTR CALLBACK myDialogProc (	HWND hwndDlg,	// handle to dialog box
										UINT uMsg,		// message
										WPARAM wParam,	// first message parameter
										LPARAM lParam)	// second message parameter
{
	// CA_xZkqqHx_iDeOiDiJiDfIiCpAiLeMjIfOiBeCiDhNiDiLiDgAiDfIiDiMiDgCiDgIiBeBiDiCiBfLiDgIiDiMiDfIiDfPiDeDiDeBiDiNiDePiCmMiPoKiNiHiCmN_xHqqkZx_
	// _xZkqqHx_jBlNiPgEiCmJiLeOjDkOiClDiCoKiClNiPoKiNiHjBmOiJjOiCmFiCkLiCmIiCkCiClBiCmGiCmJjCiNiInDiBeC_xHqqkZx_
	static CA* pCA = NULL;
	switch (uMsg)
	{
	case WM_INITDIALOG:
	  {
		pCA = (CA*)lParam;
		// _xZkqqHx_iDeBiDjDiDgAiDeHiDiKiDeBiDfIiCpAiOgHiCkEiCkJiBeI_xHqqkZx_
		CheckDlgButton(hwndDlg, IDC_CHK_USE_ANTI_ALIAS,
						pCA->GetIsUseAntiAlias() ? BST_CHECKED : BST_UNCHECKED);
		break;
	  }

	case WM_COMMAND:
		switch (wParam)
		{
		case IDOK:
		  {
			short nIsUseAntiAlias;
			// _xZkqqHx_iDeBiDjDiDgAiDeHiDiKiDeBiDfIiCpAiOgHiCkEiCkJiBeI_xHqqkZx_
			nIsUseAntiAlias =
				(IsDlgButtonChecked(hwndDlg, IDC_CHK_USE_ANTI_ALIAS) == BST_CHECKED);
			pCA->SetIsUseAntiAlias(nIsUseAntiAlias);
			EndDialog(hwndDlg, TRUE);
			break;
		  }
		case IDCANCEL:
			EndDialog(hwndDlg, FALSE);
			break;
		case IDHELP:
		  {
			// _xZkqqHx_iDiCiDfHiDiFiBfLiDiLiCmMiDgGiDeCiDiMiDeOiDgHiDiKjFhEiCkLjGlMjBePiBgJiKgHjCkDiOhBjGlDiClFiBgKiCpAiOoGjDlOiBeC_xHqqkZx_
			_TCHAR tcsModule[_MAX_PATH * 2];
			FMpgGetModule()->GetModulePathName(tcsModule, _MAX_PATH);
			_tcscat(tcsModule, _T(".hlp"));
			::WinHelp(pCA->GetMolipMainI()->GetMainWindow(), tcsModule,
					HELP_CONTEXT, DWORD(HID_BASE_RESOURCE + IDD_DLG_CONTROL));
			break;
		  }
		}
		break;

	case WM_CLOSE:
		PostMessage(hwndDlg, WM_COMMAND, IDCANCEL, 0L);
		break;

	default:
		return FALSE;
	}
	return TRUE;
} // myDialogProc.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CA::OnCommand
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiCiDfHiDiFiBfLiDiLiCkKjAnNjCoIiClFiClNiDfCiDhNiDjDiDgIiCkKiOmAiNhDiClDiCoKiClNiCmGiCkLiCmJiMmEiCmOiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	nCmdID	:_xZkqqHx_iOmAiNhDiClDiCoKiClNiDfCiDhNiDjDiDgIiCmM_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_ S_OK_xZkqqHx_iBeBiOlIjEhDiClFiClNiPoKiNiHiCmNiDeHiDiJiBfLiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.09.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
HRESULT CA::OnCommand (UINT nCmdID)
{
	if (nCmdID == m_adwCommandId[0])
	//----- _xZkqqHx_iDiBiDfOiDfCiDjDjAnNjCoIiDfCiDhNiDjDiDgI_xHqqkZx_ -----
	{
		//----- _xZkqqHx_iDiBiDfOiDfCiDjDjAnNjCoIiDfPiDeDiDeBiDiNiDePiCpAjFfMiOkG_xHqqkZx_ -----
		// lParam _xZkqqHx_iCmJiOhHjCoIiClHiCoJ_xHqqkZx_ this _xZkqqHx_iCmNiBeB_xHqqkZx_WM_INITDIALOG_xZkqqHx_iDiBiDgCiDfKiBfLiDfHiCmF_xHqqkZx_
		// myDialogProc_xZkqqHx_iKnGjAjEiCmJjDgOiClDiCoKiCoJiBeC_xHqqkZx_
		INT_PTR iptr = ::DialogBoxParam((HINSTANCE)FMpgGetModule()->GetModuleHandle(),
										MAKEINTRESOURCE(IDD_DLG_CONTROL),
										GetMolipMainI()->GetMainWindow(),
										DLGPROC(myDialogProc),
										LPARAM(this));
		return S_OK;
	} else
	if (nCmdID == m_adwCommandId[1])
	//----- _xZkqqHx_iDhHiDiLiDhGiDfCiDhNiDjDiDgI_xHqqkZx_ -----
	{
		// _xZkqqHx_iDiCiDfHiDiFiBfLiDiLiCmMiDgGiDeCiDiMiDeOiDgHiDiKjFhEiCkLjGlMjBePiBgJiKgHjCkDiOhBjGlDiClFiBgKiCpAiOoGjDlOiBeC_xHqqkZx_
		_TCHAR tcsModule[_MAX_PATH * 2];
		FMpgGetModule()->GetModulePathName(tcsModule, _MAX_PATH);
		_tcscat(tcsModule, _T(".hlp"));
		::WinHelp(GetMolipMainI()->GetMainWindow(), tcsModule, HELP_FINDER,(DWORD)0);
	} else
	if (nCmdID == m_adwCommandId[2])
	//----- _xZkqqHx_iDgPiBfLiDfHiDiHiDjDiPoOjFpB_xHqqkZx_ -----
	{
		GetMolipMainI()->ShowAboutDialog();
	}
	return S_OK;
} // CA::OnCommand.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CA::OnUpdateCommandUI
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiCiDfHiDiFiBfLiDiLiCkKjAnNjCoIiClFiClNiDfCiDhNiDjDiDgIiCmMiDiBiDgKiDiFiBfLiCkKjFfMiOkGiClDiCoKiClNiCmGiCkLiCmJiMmEiCmOiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pCmdUI	:_xZkqqHx_iDfCiDhNiDjDiDgIjFfMiOkGiPpDjBnEiCmMiDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_ S_OK_xZkqqHx_iBeBiOlIjEhDiClFiClNiPoKiNiHiCmNiDeHiDiJiBfLiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.09.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
HRESULT CA::OnUpdateCommandUI (MfcCmdUI* pCmdUI)
{
	// _xZkqqHx_iDfEiDhFiDiBiDgKiDiFiBfLiCmMiPoKiNiHiBgJiDfEiDhFiDiBiDgKiDiFiBfLiCmFiCoAiClBiClBiCkKiMmEiCmOiCoKiCoJiBgKiCmNiBeBjFjMiLeBiBeC_xHqqkZx_
	if (pCmdUI->m_pSubMenu != NULL) return S_OK;
	return S_OK;
} // CA::OnUpdateCommandUI.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CA::GetPopHint
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhGiDiJiDePiDeDiDjDiDfCiDhNiDjDiDgIiCmMiDhMiDgCiDhGiDhBiDjDiDgHiCmMiDgFiDeMiDfIiDgHiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDiBiDgKiDiFiBfLiPoDiCmJiDhNiDeFiDfIiDeKiBfLiDfMiDiLiCkKiInKjDkOiClFiClNiCmGiCkLiCmJjFfMiOkGiClDiCoKiCoJiDiBiDgCiDfKiBfLiDfH_xHqqkZx_
 *			_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wstrHintText:_xZkqqHx_iDhBiDjDiDgHiDgFiDeMiDfIiDgHiCpAjFnEiClHiBeC_xHqqkZx_
 *			nCmdID		:_xZkqqHx_iDfCiDhNiDjDiDgI_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_ S_OK_xZkqqHx_iBeBiOlIjEhDiClFiClNiPoKiNiHiCmNiDeHiDiJiBfLiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
HRESULT CA::GetPopHint (WString& wstrHintText, UINT nCmdID)
{
	for (int iC = 0; iC != sizeof(PG_MENU) / sizeof(PG_MENU[0]); iC++)
	{
		if (nCmdID == m_adwCommandId[iC])
		//----- iC_xZkqqHx_jEnEjGnKiCmMiDfCiDhNiDjDiDgIiCmMiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDhBiDgCiDgHiDgFiDeMiDfIiDgHiCpAjAnNjCoIiBeC_xHqqkZx_
			wstrHintText = PG_HINT_TEXT[iC];
			break;
		}
	}
	return S_OK;
} // CA::GetPopHint.

struct myFTWaitProc
{
	myFTWaitProc (DWORD dwa, const _TCHAR* tcpFileName)
					: dwProcID(dwa), tcstrFileName(tcpFileName) {}
	DWORD dwProcID;
	std::basic_string<_TCHAR>	tcstrFileName;
}; // struct myFTWaitProc.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	myWaitForExeQuit
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	MetaCon.exe_xZkqqHx_iCmMiPeJjHlJiCpAiKmEiOiLiClHiCoJiDfIiDiMiDgCiDgIiDhGiDiNiDePiDiJiDiAiBeC_xHqqkZx_
 *			MetaCon.exe_xZkqqHx_iCkKiPeJjHlJiClFiClNiCoHiBeBiOhHjCoIiCmMiDhEiDeAiDeDiDiLiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	MetaCon.exe_xZkqqHx_iCmMiDhGiDiNiDfKiDfIiDgOiDjDiDgIiDiLiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfIiDiMiDgCiDgIiCmMjAkMiMpHiBeFiOlIjEhDiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.06.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
static DWORD WINAPI myWaitForExeQuit (LPVOID pvoid)
{
	// _xZkqqHx_iDhGiDiNiDfKiDfI_xHqqkZx_ID_xZkqqHx_iCmGjBjHjFhEiDiBiDgCiDfKiBfLiDfHiCpAiOoGjDlOiBeC_xHqqkZx_
	myFTWaitProc* pData = (myFTWaitProc*)pvoid;
	// _xZkqqHx_iDhGiDiNiDfKiDfI_xHqqkZx_ID_xZkqqHx_iCkJiCoHiDgOiDjDiDgIiDiLiCpAiNoMjAkMiBeC_xHqqkZx_
	HANDLE hProcess = OpenProcess(PROCESS_ALL_ACCESS, FALSE, pData->dwProcID);
	// MetaCon.exe_xZkqqHx_iDhGiDiNiDfKiDfIiCkKiPeJjHlJiClHiCoJiCnMiCmFiBeBjGlDjAkHiMmAiCmFjBnCiCmCiBeC_xHqqkZx_
	WaitForSingleObject(hProcess, INFINITE);
	// MetaCon.exe_xZkqqHx_iDgOiDjDiDgIiDiLiCmNiCoAiCkEiOgHiCoNiCmIiCkCiCkJiCoHiDeOiDiNiBfLiDfJiClHiCoJiBeC_xHqqkZx_
	CloseHandle(hProcess);
	// _xZkqqHx_iDhEiDeAiDeDiDiLiCpAiNoNiPjMiBeC_xHqqkZx_
	DeleteFile(pData->tcstrFileName.c_str());
	// _xZkqqHx_iDgGiBfLiDfOjHmMiIoGiCpAiKeKjFpKiBeC_xHqqkZx_
	delete pData;
	// _xZkqqHx_jAlDiPoNiPeJjHlJiBeC_xHqqkZx_
    return S_OK;
} // myWaitForExeQuit.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CA::OnSelectedObjectSave
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhGiDiJiDePiDeDiDjDiCkKjAnNjCoIiClFiClNiDhEiDeIiBfLiDhNiDgCiDgHiCmFiDhEiDeAiDeDiDiLjFnLjBlGiCmMiOjOiCmJiMmEiCmOiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	nFormatId		:_xZkqqHx_iDhEiDeIiBfLiDhNiDgCiDgH_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			tcpFileName		:_xZkqqHx_iDhEiDeAiDeDiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmMarginLeft	:_xZkqqHx_iNlGjBkEiCmMjHfNjEjCiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmMarginTop		:_xZkqqHx_iPoDjBkEiCmMjHfNjEjCiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmMarginRight	:_xZkqqHx_iJeFjBkEiCmMjHfNjEjCiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmMarginBottom	:_xZkqqHx_iJlKjBkEiCmMjHfNjEjCiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.06.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
HRESULT CA::OnSelectedObjectSave (UINT nFormatId, const wchar_t* wcpFileName,
										mmetol mmMarginLeft, mmetol mmMarginTop,
										mmetol mmMarginRight, mmetol mmMarginBottom)
{
	if (nFormatId == m_adwFormatId[PG_FORMAT_JPEG] ||
		nFormatId == m_adwFormatId[PG_FORMAT_PNG] ||
		nFormatId == m_adwFormatId[PG_FORMAT_TIF] ||
		nFormatId == m_adwFormatId[PG_FORMAT_PSD] ||
		nFormatId == m_adwFormatId[PG_FORMAT_BMP])
	{
		WString wstrNameBuff;
		GetUtilFileI()->MakeUniqTmpFileName(wstrNameBuff, L"PgMetaCon", L".emf");
		if (!GetMolipMainI()->SaveSelectedEMF(	wstrNameBuff.c_str(),
												mmMarginLeft, mmMarginTop,
												mmMarginRight, mmMarginBottom))
			return E_FAIL;

		_TCHAR tcsMetaConPath[_MAX_PATH * 2];
		FMpgGetModule()->GetModuleDirPath(tcsMetaConPath, _MAX_PATH * 2);
		_tcscat(tcsMetaConPath, _T("MetaCon.exe"));
		_TCHAR tcsMetaConArg[_MAX_PATH * 2];
		if (GetIsUseAntiAlias())
		//----- _xZkqqHx_iDeBiDjDiDgAiDeHiDiKiDeBiDfIiPiIjHjNiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
		{
			_stprintf(	tcsMetaConArg, _T("\"%s\" -A+ -from \"%s\" -to \"%s\""),
						tcsMetaConPath, (const _TCHAR*)WStrToTStr(wstrNameBuff.c_str()),
						(const _TCHAR*)WStrToTStr(wcpFileName));
		} else
		//----- _xZkqqHx_iDeBiDjDiDgAiDeHiDiKiDeBiDfIiPiIjHjNiCkKjGlDiCkCiPoKiNiH_xHqqkZx_ -----
		{
			_stprintf(	tcsMetaConArg, _T("\"%s\" -A- -from \"%s\" -to \"%s\""),
						tcsMetaConPath, (const _TCHAR*)WStrToTStr(wstrNameBuff.c_str()),
						(const _TCHAR*)WStrToTStr(wcpFileName));
		}
		STARTUPINFO si;
		PROCESS_INFORMATION pi;
		// Initialize the STARTUPINFO structure.
		memset(&si, 0, sizeof(si));
		si.cb = sizeof(si);
		(void)CreateProcess(
			NULL,	// pointer to name of executable module
			tcsMetaConArg,	// pointer to command line string
			NULL,	// pointer to process security attributes
			NULL,	// pointer to thread security attributes
			FALSE,	// handle inheritance flag
			CREATE_NO_WINDOW,		// creation flags
			NULL,	// pointer to new environment block
			NULL,	// pointer to current directory name
			&si,	// pointer to STARTUPINFO
			&pi		// pointer to PROCESS_INFORMATION
		   );
		// CreateProcess_xZkqqHx_iCmFiKgNjFnLiClDiCoKiClNiDgOiDjDiDgIiDiLiCpAiJpAjFpK_xHqqkZx_(MetaCon.exe_xZkqqHx_iCmNiPeJjHlJiClFiCmIiCkC_xHqqkZx_)_xZkqqHx_iBeC_xHqqkZx_
		CloseHandle(pi.hThread);
		CloseHandle(pi.hProcess);

		// _xZkqqHx_iDfIiDiMiDgCiDgIiCmJjDgOiClHiNfMjBkCjBmMiCpAiNoMjAkMiBeC_xHqqkZx_
		myFTWaitProc* pData = new myFTWaitProc(pi.dwProcessId, WStrToTStr(wstrNameBuff.c_str()));
		// MetaCon.exe_xZkqqHx_iPeJjHlJiKmEiOiLiDfIiDiMiDgCiDgIiCpAiLeOjDkOiBeC_xHqqkZx_
		DWORD dwThreadId;
		// _xZkqqHx_iDfIiDiMiDgCiDgIiCpAiLeOjDkOiBeC_xHqqkZx_
		HANDLE hThread =
			CreateThread(NULL, 0, (PTHREAD_START_ROUTINE)myWaitForExeQuit,
						(LPVOID)pData, 0, &dwThreadId);
		// _xZkqqHx_iDfIiDiMiDgCiDgIiDgOiDjDiDgIiDiLiCpAiKeKjFpKiBeCiDfIiDiMiDgCiDgIiCmNiPeJjHlJiClFiCmIiCkCiBeC_xHqqkZx_
		CloseHandle(hThread);
	}
	return S_OK;
} // CA::OnSelectedObjectSave.

/////////////////////////////////////////////////////////////////////////////////

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CA::CA
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeCiDeKiDeFiDjDiDfOiCpAiJmBiOfKiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CA::CA ()
{
} // CA::CA.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CA::~CA
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiBeCiDeKiDeFiDjDiDfOiCpAiMlIiOfKiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CA::~CA ()
{
} // CA::~CA.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CA::GetIsUseAntiAlias
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFiDeBiDjDiDgAiDeHiDiKiDeBiDfIiCmMjHeMiMpIiBeFjGlDiMpIiBhGiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jHeMiMpIiCmIiCoHiCmOiCfAiBeBjGlDiMpIiCmIiCoHiCmOiCePiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.11.09 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
short CA::GetIsUseAntiAlias () const
{
	short nIsUseAntiAlias;
	HRESULT hr = GetMolipMainI()->GetProfileBinary(L"IsUseAntiAlias",
													(BYTE*)&nIsUseAntiAlias,
													sizeof(nIsUseAntiAlias));
	if (hr == S_OK) return nIsUseAntiAlias;
	return DEFAULT_IS_USE_ANTI_ALIAS;
} // CA::GetIsUseAntiAlias.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CA::SetIsUseAntiAlias
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFiDeBiDjDiDgAiDeHiDiKiDeBiDfIiCmMjHeMiMpIiBeFjGlDiMpIiBhGiCpAjAnNjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	nIsUseAntiAlias	:_xZkqqHx_jHeMiMpIiCmIiCoHiCmOiCfAiBeBjGlDiMpIiCmIiCoHiCmOiCePiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jCgMiCpAiDiMiDfHiDfIiDgHiDiKiCmJiPjBiCkLiNjOiCnOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.11.09 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CA::SetIsUseAntiAlias (short nIsUseAntiAlias)
{
	GetMolipMainI()->SetProfileBinary(	L"IsUseAntiAlias",
										(BYTE*)&nIsUseAntiAlias,
										sizeof(nIsUseAntiAlias));
} // CA::SetIsUseAntiAlias.
