/*
The contents of this file are subject to the Mozilla Public License
Version 1.1 (the "License"); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS"
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is "SVG Export" plug-in for DynamicDraw.

The Initial Developer of the Original Code is FUKUSHIRO Masayuki.

Copyright (C) 2001,2002  FUKUSHIRO Masayuki ( yt3m-fksr@asahi-net.or.jp ), 
HIROSAWA Masashi ( hirosawa@cam.hi-ho.ne.jp ). 
All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms
of the GNU General Public License Version 2 (the "GPL"), in which case
the provisions of the GPL are applicable instead of those above.  If you
wish to allow use of your version of this file only under the terms of
the GPL and not to allow others to use your version of this file under
the MPL, indicate your decision by deleting the provisions above and
replace them with the notice and other provisions required by the
GPL.

Alternatively, the contents of this file may be used under the terms
of the New BSD License (the "BSDL"), in which case the provisions
of the BSDL are applicable instead of those above.  If you wish
to allow use of your version of this file only under the terms of
the BSDL and not to allow others to use your version of this file under
the MPL, indicate your decision by deleting the provisions above and
replace them with the notice and other provisions required by the BSDL.

If you do not delete the provisions above, a recipient may use
your version of this file under any of the MPL, the GPL or the BSDL.
*/

#include "stdafx.h"
#include "SVGColor.h"
#include <stdio.h>

#define SVGCOLORNAME_LAST 0xFFFFFFFF

// SVG_xZkqqHx_iDhEiDeAiDeDiDiLiPgPjHmNiCmFiOgHiCoNiCoKiCoJjAeGiCmMjGlMjBePiBeC_xHqqkZx_
//   _xZkqqHx_jFkKiCkJiCoIiCoCiClHiCkCiCoAiCmMiClOiCkPiCmJiNgJiCmBiCmEiCkAiCoJiBeC_xHqqkZx_
static SvgColorName SvgExportColorNameTable[] = {
    { "black", RGB2RGBA( RGB(0,0,0) ) },
    { "red", RGB2RGBA( RGB(255,0,0) ) },
    { "green", RGB2RGBA( RGB(0,128,0) ) },
    { "blue", RGB2RGBA( RGB(0,0,255) ) },
    { "cyan", RGB2RGBA( RGB(0,255,255) ) },
    { "magenta", RGB2RGBA( RGB(255,0,255) ) },
    { "purple", RGB2RGBA( RGB(128,0,128) ) },
    { "yellow", RGB2RGBA( RGB(255,255,0) ) },
    { "grey", RGB2RGBA( RGB(128,128,128) ) },
    { "white", RGB2RGBA( RGB(255,255,255) ) },
	{ "", SVGCOLORNAME_LAST }
};

// color_xZkqqHx_iCmJjBiKjDjGiClHiCoJjFlGiOjKjHpBiCmMiDhMiDeDiDjDiDfOiCpAjFnEiClHiBeC_xHqqkZx_
//   color_xZkqqHx_iCmJiIoKjChGiClHiCoJiDgGiDhEiDeIiDiLiDgHjCoIiLgAjAeGiCkKjBlGiNnNiClHiCoJiPoKiNiHiBeBiClLiCmMjFlGiOjKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
//   _xZkqqHx_iMkJiCmCiCkJiCoHiCmIiCkJiCmBiClNiPoKiNiHiCmNiBeB_xHqqkZx_"rgb(ddd,ddd,ddd)"_xZkqqHx_iCmMiMgAiOkOiCmMjFlGiOjKjHpBiCpA_xHqqkZx_colorStr_xZkqqHx_iCmJjAnNjCoIiClFiBeB_xHqqkZx_
//   colorStr_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_colorStr_xZkqqHx_iCmNiBeBiMmEiCnBiPgPiClFjBkEiCmFiKgNjFnLiClFiCmEiCkIiCkNiBeC_xHqqkZx_
char* getExportSvgColorStr( const COLORREF color, char *colorStr ) {

	if ( 0 == RGBA_GETALPHA( color ) ) {
		// _xZkqqHx_jDkHjGlO_xHqqkZx_
		return "none";
	}

	SvgColorName *colorName = &(SvgExportColorNameTable[0]);

	while ( '\0' != colorName->name[0] ) {
		if ( GetRGB( color ) == GetRGB( colorName->color ) ) {
			return colorName->name;
		}
		colorName++;
	} // while colorName

	// _xZkqqHx_iMkJiCmCiCkJiCoHiCmIiCkJiCmBiClN_xHqqkZx_
	sprintf( colorStr, "rgb(%d,%d,%d)", GetRValue(color), GetGValue(color), GetBValue(color) );

	return colorStr;

} // end of getExportSvgColorStr
