/*
The contents of this file are subject to the Mozilla Public License
Version 1.1 (the "License"); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS"
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is "SVG Export" plug-in for DynamicDraw.

The Initial Developer of the Original Code is FUKUSHIRO Masayuki.

Copyright (C) 2001,2002  FUKUSHIRO Masayuki ( yt3m-fksr@asahi-net.or.jp ), 
HIROSAWA Masashi ( hirosawa@cam.hi-ho.ne.jp ). 
All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms
of the GNU General Public License Version 2 (the "GPL"), in which case
the provisions of the GPL are applicable instead of those above.  If you
wish to allow use of your version of this file only under the terms of
the GPL and not to allow others to use your version of this file under
the MPL, indicate your decision by deleting the provisions above and
replace them with the notice and other provisions required by the
GPL.

Alternatively, the contents of this file may be used under the terms
of the New BSD License (the "BSDL"), in which case the provisions
of the BSDL are applicable instead of those above.  If you wish
to allow use of your version of this file only under the terms of
the BSDL and not to allow others to use your version of this file under
the MPL, indicate your decision by deleting the provisions above and
replace them with the notice and other provisions required by the BSDL.

If you do not delete the provisions above, a recipient may use
your version of this file under any of the MPL, the GPL or the BSDL.
*/

#include "stdafx.h"
#include <stdio.h>
#include <tchar.h>			// For _TCHAR.
#include <AFXPRIV.H>

// 06.06.29 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
#include <string>			// For string.
#include "resource.h"		// For IDS_XX.
#include "Module.h"			// For FMpgGetModule().
//----- 06.06.29 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//#include "MpgExtern.h"		// For Global.
//#include "DBLMath.h"		// For DBLPoint.
//#include "DBLPoint.h"		// For DBLPoint.
//#include "DBLRect.h"		// For DBLRect.
//#include "FCViewWrp.h"		// For FCViewWrp.
//#include "FCLinkManagerExpType.h"	// For FCLinkRecVector.
//#include "FCObjectExp.h"	// For FC_objectExp.
//#include "FCTextEditorExpType.h"	// For FCRichTextExp.h.
//#include "FCRichTextExpType.h"	// For FCStatChar.etc.
//#include "FCRichTextExp.h"	// For FCRichTextExp.
//#include "FCArrowExpType.h"
//#include "FCArrowExp.h"
//
//#include "MpgInterface.h"
//
//#include "FCObjectExpType.h"
//
//#include "FCEnvExpType.h"	// For FCEnvExp.h.
//#include "FCEnvExp.h"
//#include "MpgClasses.h"
//#include "FCViewExp.h"		// For FCViewExp.
//----- 06.06.29 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

#include <float.h>

#include "SvgExportOption.h"
#include "SvgExportInfo.h"
#include "SvgColor.h"
#include "png.h"
#include "PngSave.h"
#include "PrintSVGOLEProcess.h"
#include "PgSVGExport.h"
#include "pencil_png.cpp"

//----- 06.06.29 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
// STL_xZkqqHx_iCmMjGlMjBePiLpDiKnEiCpAjAnNjCoIiBeC_xHqqkZx_
using namespace std;
//----- 06.06.29 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----


extern void GetPasteObjFrame (DBLRect& mmrtFrame, const ObjDynabaseVector& vObj);

SvgExportOption SvgExportInfo::svgExportOption;


SvgExportInfo::SvgExportInfo() :
//----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//		_svgFileName(NULL), _fptr(NULL), _objectExp(NULL), _partsName(NULL), _pmmptvPoly(NULL), 
//		_unitsPerMM(1), _penWidth(1), _recPenStyle(NULL), _penBgColor(0x000000),
//		_brushFgColor(0x000000), _brushBgColor(0x000000), _brushPattern(-1),
//		_shouldPrintClippedBrushPattern(true), _clipNo(0), _imageNo(0),
//		_objectIndex(1), _shadowNo(0), _isChipMaster(false)
//----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
		_svgFileName(NULL),
		_fptr(NULL),
		_objectExp(NULL),
		_partsName(NULL),
// 06.07.03 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//		_pmmptvPoly(NULL), 
		_unitsPerMM(1),
		_penWidth(1),
		_recPenStyle(NULL),
		_penBgColor(0x000000),
		_brushFgColor(0x000000),
		_brushBgColor(0x000000),
		_brushPattern(FD_PATTERN_UNUSE),
// 06.07.04 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
		_isFillPainted(false),
		_shouldPrintClippedBrushPattern(true),
		_clipNo(0),
		_imageNo(0),
		_objectIndex(1),
		_shadowNo(0),
		_isChipMaster(false)
//----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
{

/*
	char *str = getFormatString( "%f" );
	str = getFormatString( "" );
	str = getFormatString( "a" );
	str = getFormatString( "abc%f" );
	str = getFormatString( "%fabc" );
	str = getFormatString( "abc%fdef" );
	str = getFormatString( "%f%f" );
	str = getFormatString( "abc%f%f" );
	str = getFormatString( "%fabc%f" );
	str = getFormatString( "abc%fdef%f" );
	str = getFormatString( "%fa%f" );
	str = getFormatString( "%fa%fb" );
	str = getFormatString( "%fa%fb%f" );
	str = getFormatString( "%fa%fb%fc" );
*/

} // end of SvgExportInfo::SvgExportInfo


#define D2L(a)  (0 < (a) ? (long)((a) + 0.5) : (long)((a) - 0.4))


// _xZkqqHx_iDfIiDeKiDiJiBfLjCgMiCmMjFmPiKlHiBeCjIfPjHjNiNmAjFfHjCgM_xHqqkZx_(pixel)_xZkqqHx_iCkJiCoHiOmAiNmAjFfHjCgM_xHqqkZx_(mm)_xZkqqHx_iCnGjFmPiKlHiBeC_xHqqkZx_
inline double lg2mm (long a, double dZoom)
{
	return static_cast<double>(a) / dZoom;
}

// _xZkqqHx_iDfIiDeKiDiJiBfLjCgMiCmMjFmPiKlHiBeCiOmAiNmAjFfHjCgM_xHqqkZx_(mm)_xZkqqHx_iCkJiCoHjIfPjHjNiNmAjFfHjCgM_xHqqkZx_(pixel)_xZkqqHx_iCnGjFmPiKlHiBeC_xHqqkZx_
inline long mm2lg (double a, double dZoom)
{
	return D2L(dZoom * a);
}


/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CA0::GetPasteObjFrame
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	vObj _xZkqqHx_iCmFiOhHjCoIiClDiCoKiCoJjFjEjFgJiCmJiKePjAnKiClHiCoJiDhEiDiMiBfLiDiAiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmrtFrame	:_xZkqqHx_iDhEiDiMiBfLiDiAiCpAjFnEiClHiBeC_xHqqkZx_
 *			vObj		:_xZkqqHx_jFjEjFgJiPfHiNiHiCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.09.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
//void CA0::GetPasteObjFrame (DBLRect& mmrtFrame, const ObjDynabaseVector& vObj)
void GetPasteObjFrame (DBLRect& mmrtFrame, const ObjDynabaseVector& vObj)
{
	//----- _xZkqqHx_iKePjAnKiDhEiDiMiBfLiDiAiCmMiNlGiPoDiNmAjFfHiCpAiOfKiPgP_xHqqkZx_ -----
	DBLPoint mmptLT(DBL_MAX, DBL_MAX);
	ObjDynabaseVector::const_iterator iObj;
	for (iObj = vObj.begin(); iObj != vObj.end(); iObj++)
	{
		DBLRect mmrtTmp = (*iObj)->CalcExactOuterFrame();
		if (mmrtTmp.left < mmptLT.x) mmptLT.x = mmrtTmp.left;
		if (mmrtTmp.top < mmptLT.y)  mmptLT.y = mmrtTmp.top;
	}
	//------ _xZkqqHx_jCmKiPoNiCmM_xHqqkZx_DisplayPPM(_xZkqqHx_jBkGiClP_xHqqkZx_1_xZkqqHx_jEhL_xHqqkZx_)_xZkqqHx_iCmFiMhGiOfKiClHiCoJiClNiCnPiBeBiDfJiBfLiDiAiCpAjAnNjCoI_xHqqkZx_ -----
	const double dZoomBackup =
			FFGetMolipBaseI()->SetZoom(FFGetMolipBaseI()->GetDisplayPPM());
	//----- _xZkqqHx_jCmKiPoNiCmMiDfEiDeDiDfJiCmFiBeB_xHqqkZx_1 pixel_xZkqqHx_iCpAiNlGiPoDiCkJiCoHiMlIiOfKiBeC_xHqqkZx_WORD_xZkqqHx_jDjJiCmFiBeB_xHqqkZx_50%_xZkqqHx_iCmFjFfMiOkGiCpAiKoOiPiAiCmJiMgPiMlBjDeJjCgM_xHqqkZx_ -----
	mmptLT.x -= lg2mm(1, FFGetMolipBaseI()->GetZoom());
	mmptLT.y -= lg2mm(1, FFGetMolipBaseI()->GetZoom());
	//----- _xZkqqHx_jFgAiJoGiDeJiDhEiDfKiDgCiDgHjCgMiCpAjAnNjCoI_xHqqkZx_ -----
	const long lgOffsetX =
		FFGetMolipBaseI()->SetOffsetX(mm2lg(mmptLT.x, FFGetMolipBaseI()->GetZoom()));
	const long lgOffsetY =
		FFGetMolipBaseI()->SetOffsetY(mm2lg(mmptLT.y, FFGetMolipBaseI()->GetZoom()));

	mmrtFrame.SetRect(DBL_MAX, DBL_MAX, -DBL_MAX, -DBL_MAX);
	for (iObj = vObj.begin(); iObj != vObj.end(); iObj++)
	{
		DBLRect mmrtTmp = (*iObj)->CalcExactOuterFrame();
		if (mmrtTmp.left < mmrtFrame.left)		mmrtFrame.left = mmrtTmp.left;
		if (mmrtTmp.top < mmrtFrame.top)		mmrtFrame.top = mmrtTmp.top;
		if (mmrtFrame.right < mmrtTmp.right)	mmrtFrame.right = mmrtTmp.right;
		if (mmrtFrame.bottom < mmrtTmp.bottom)	mmrtFrame.bottom = mmrtTmp.bottom;
	}
	//----- _xZkqqHx_jFgAiJoGiDeJiDhEiDfKiDgCiDgHiCpAjGnPiClH_xHqqkZx_ -----
	FFGetMolipBaseI()->SetOffsetX(lgOffsetX);
	FFGetMolipBaseI()->SetOffsetY(lgOffsetY);
	// _xZkqqHx_iDfJiBfLiDiAiCpAjGnPiClHiBeC_xHqqkZx_
	FFGetMolipBaseI()->SetZoom(dZoomBackup);
	// _xZkqqHx_jCmKiPoNiCmMiDfEiDeDiDfJiCmFiBeB_xHqqkZx_1 pixel_xZkqqHx_iCpAiKgHjBoFiBeC_xHqqkZx_WORD_xZkqqHx_jDjJiCmFiBeB_xHqqkZx_50%_xZkqqHx_iCmFjFfMiOkGiCpAiKoOiPiAiCmJiMgPiMlBjDeJjCgMiBeC_xHqqkZx_
	mmrtFrame.Extend(lg2mm(1, FFGetMolipBaseI()->GetZoom()));
} // GetPasteObjFrame.


void printSvgHeader( FILE *fptr ) {

	fputs( "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 20001102//EN\" \"http://www.w3.org/TR/2000/CR-SVG-20001102/DTD/svg-20001102.dtd\">\n", fptr );

	fprintf( fptr, "<!-- This file was created by the DynamicDraw's \"SVG Export\" plug-in version %s.-->\n", SVG_EXPORT_VERSION );

} // end of printSvgHeader


int exportSelectedObjToSVGFile( const wchar_t* wcpFileName,
								mmetol mmMarginLeft, mmetol mmMarginTop,
								mmetol mmMarginRight, mmetol mmMarginBottom )
{
	USES_CONVERSION;
	FILE *fptr = fopen( W2CA(wcpFileName), "w" );
	if ( NULL == fptr )
	{
//----- 06.07.04 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//		CString str( "SVGExport_xZkqqHx_iDhGiDiJiDePiDeDiDjD_xHqqkZx_(from SVGExportTool) _xZkqqHx_iDeHiDiJiBfL_xHqqkZx_\n\n_xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_ \"" );
//		str += W2CA(wcpFileName);
//		str += "\" _xZkqqHx_iCkKiKeKiCkPiCnMiClJiCpBiBeC_xHqqkZx_\n_xZkqqHx_iPiIjHjNiCpAjCiGiOhOiClFiCnMiClHiBeC_xHqqkZx_";
//----- 06.07.04 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
		// _T("SVGExport_xZkqqHx_iDhGiDiJiDePiDeDiDjD_xHqqkZx_ _xZkqqHx_iDeHiDiJiBfL_xHqqkZx_\n\n_xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_ \"%s\" _xZkqqHx_iCkKiKeKiCkPiCnMiClJiCpBiBeC_xHqqkZx_\n_xZkqqHx_iPiIjHjNiCpAjCiGiOhOiClFiCnMiClHiBeC_xHqqkZx_")
		CString str;
		str.Format(	FFLoadString(IDS_ERRMSG_CANNOT_OPEN_FILE),
					W2CA(wcpFileName));
//----- 06.07.04 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
		::AfxMessageBox( str, MB_OK | MB_APPLMODAL | MB_ICONSTOP );
		return S_OK;
	}

// 06.06.30 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	CWaitCursor wc; // _xZkqqHx_iPiIjHjNjCiGiDeKiBfLiDfMiDiL_xHqqkZx_

	printSvgHeader( fptr );

// 06.07.03 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	DBLPointVector pmmptvPoly;
	ObjDynabaseVector::const_iterator iObj;

	double _unitsPerMM = 1.0; // 

	SvgExportInfo svgExportInfo;
	svgExportInfo._fptr = fptr;
// 06.07.03 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	svgExportInfo._pmmptvPoly = &pmmptvPoly;
	svgExportInfo._unitsPerMM = _unitsPerMM;
	svgExportInfo._svgFileName = (wchar_t*)wcpFileName;

	// _xZkqqHx_iKePjAnKiDhEiDiMiBfLiDiAiCpAiMhGiOfKiBeC_xHqqkZx_
	CFCDynamicDrawView* pView = FFGetMolipBaseI()->GetView();
	DBLRect mmrtFrame;
	GetPasteObjFrame(mmrtFrame, pView->SelectObjVector() );
	//----- _xZkqqHx_iDhNiBfLiDfHiDjDjFkKiKgHjCkDiClHiCoJ_xHqqkZx_ -----
	mmrtFrame.left	-= mmMarginLeft;
	mmrtFrame.top	-= mmMarginTop;
	mmrtFrame.right	+= mmMarginRight;
	mmrtFrame.bottom += mmMarginBottom;
	// _xZkqqHx_iDeJiDhEiDfKiDgCiDgHiCpAjAnNjCoI_xHqqkZx_
	svgExportInfo._offsetLeftTop.x = mmrtFrame.left;
	svgExportInfo._offsetLeftTop.y = mmrtFrame.top;
	
	mmetol mmPaperWidth = mmrtFrame.right - mmrtFrame.left;
	mmetol mmPaperHeight = mmrtFrame.bottom - mmrtFrame.top;

	fprintf( fptr, "<svg xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' width='%.3fmm' height='%.3fmm' viewBox='0 0 %.3f %.3f'>\n", 
		mmPaperWidth, mmPaperHeight, SvgUnit( mmPaperWidth ), SvgUnit( mmPaperHeight ) );
	fputs( "<g style='stroke-linecap:round;stroke-linejoin:round'>\n", fptr );



	for (iObj = pView->SelectObjVector().begin();
		 iObj != pView->SelectObjVector().end(); iObj++)
	{
		svgExportInfo._objectExp = (FCObjDynabase*)*iObj;
		//   _xZkqqHx_iDhJiDjDiCmMjBlOiClDiBeBiDhJiDjDiCmMiDfIiDfOiDeDiDiLiBeBiDhJiDjDiCmMjEhHiMgJjAeGiBeBiDhFiDiJiDfGiCmMjBePiMgJjAeG_xHqqkZx_
		//   _xZkqqHx_iDhFiDiJiDfGiCmMjEhHiMgJjAeGiCpAjAnNjCoI_xHqqkZx_
		svgExportInfo.setStyle();
		// SVG_xZkqqHx_iPgPjHmN_xHqqkZx_
		int result = svgExportInfo.printSVG();
		if (result)
		{
//----- 06.07.04 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//			::AfxMessageBox( "SVGExport_xZkqqHx_iDhGiDiJiDePiDeDiDjD_xHqqkZx_ _xZkqqHx_iDeHiDiJiBfL_xHqqkZx_\n\n_xZkqqHx_iPiIjHjNjCiGiCmJiDeHiDiJiBfLiCkKjEkNjAlGiClFiCnMiClFiClNiBeC_xHqqkZx_\n_xZkqqHx_iPnKiClFiCkNiCmNiBeB_xHqqkZx_SVGExport_xZkqqHx_iDhGiDiJiDePiDeDiDjDiCmMiDhHiDiLiDhGiCpAiClCiOfBiPmGiJlKiClDiCkCiBeC_xHqqkZx_",
//				MB_OK | MB_APPLMODAL | MB_ICONEXCLAMATION );
//----- 06.07.04 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
			// "SVGExport_xZkqqHx_iDhGiDiJiDePiDeDiDjD_xHqqkZx_ _xZkqqHx_iDeHiDiJiBfL_xHqqkZx_\n\n_xZkqqHx_iPiIjHjNjCiGiCmJiMhAjBlBiPiIjHjNiJmCjEfMiCmIiDeHiDiJiBfLiCkKjEkNjAlGiClFiCnMiClFiClNiBeC_xHqqkZx_\n_xZkqqHx_iPiIjHjNiCpAjBlBiNhDiClFiCnMiClHiBeC_xHqqkZx_\n_xZkqqHx_iPnKiClFiCkNiCmNiBeB_xHqqkZx_SVGExport_xZkqqHx_iDhGiDiJiDePiDeDiDjDiCmMiDhHiDiLiDhGiCpAiClCiOfBiPmGiJlKiClDiCkCiBeC_xHqqkZx_"
			::AfxMessageBox(FFLoadString(IDS_ERRMSG_CONTINUABLE_ERROR),
							MB_OK | MB_APPLMODAL | MB_ICONEXCLAMATION);
//----- 06.07.04 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
		}
	} // for iObj

	fprintf( fptr, "</g>%s\n</svg>\n", 
		getCommentStr( "<!-- stroke-linecap, etc -->" ) );

	if (fclose(fptr))
	{
//----- 06.07.04 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//		CString str( "SVGExport_xZkqqHx_iDhGiDiJiDePiDeDiDjD_xHqqkZx_ _xZkqqHx_iDeHiDiJiBfL_xHqqkZx_\n\n_xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_ \"" );
//		str += W2CA(wcpFileName);
//		str += "\" _xZkqqHx_iCkKjFmCiClGiCoHiCoKiCnMiClJiCpBiBeC_xHqqkZx_\n_xZkqqHx_iPiIjHjNiCpAjCiGiOhOiClFiCnMiClHiBeC_xHqqkZx_";
//----- 06.07.04 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
		// _T("SVGExport_xZkqqHx_iDhGiDiJiDePiDeDiDjD_xHqqkZx_ _xZkqqHx_iDeHiDiJiBfL_xHqqkZx_\n\n_xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_ \"%s\" _xZkqqHx_iCkKjFmCiClGiCoHiCoKiCnMiClJiCpBiBeC_xHqqkZx_\n_xZkqqHx_iPiIjHjNiCpAjCiGiOhOiClFiCnMiClHiBeC_xHqqkZx_")
		CString str;
		str.Format(	FFLoadString(IDS_ERRMSG_CANNOT_CLOSE_FILE),
					W2CA(wcpFileName));
//----- 06.07.04 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
		::AfxMessageBox( str, MB_OK | MB_APPLMODAL | MB_ICONSTOP );
	}

	if ( SvgExportInfo::svgExportOption._htmlOutput ) {
		// HTML_xZkqqHx_iDhEiDeAiDeDiDiLiPgPjHmN_xHqqkZx_

		// HTML_xZkqqHx_iDhEiDeAiDeDiDiLjGlMiCpAiNoMiCoJ_xHqqkZx_
		wchar_t wcsHtmlFilePath[_MAX_PATH];
		char mbcSvgFilename[_MAX_FNAME];
		if ( svgExportInfo.makeHtmlFilename( wcsHtmlFilePath, mbcSvgFilename ) ) {
			return SE_ERROR_RETURN( SVGEXPORT_CONTINUABLE_ERROR );
		}

		// HTML_xZkqqHx_iDhEiDeAiDeDiDiLjGlMiCpAiKeKiCkN_xHqqkZx_
// 06.07.04 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//		fptr = _wfopen( wcsHtmlFilePath, L"w" );
		fptr = fopen(W2CA(wcsHtmlFilePath), "w");
		if ( NULL == fptr )
		{
//----- 06.07.04 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//			CString str("SVGExport_xZkqqHx_iDhGiDiJiDePiDeDiDjD_xHqqkZx_ _xZkqqHx_iDeHiDiJiBfL_xHqqkZx_\n\n_xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_ \"");
//			str += W2CA(wcsHtmlFilePath);
//			str += "\" _xZkqqHx_iCkKiKeKiCkPiCnMiClJiCpBiBeC_xHqqkZx_\n_xZkqqHx_iPiIjHjNiCpAjCiGiOhOiClFiCnMiClHiBeC_xHqqkZx_";
//----- 06.07.04 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
			// _T("SVGExport_xZkqqHx_iDhGiDiJiDePiDeDiDjD_xHqqkZx_(from SVGExportTool) _xZkqqHx_iDeHiDiJiBfL_xHqqkZx_\n\n_xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_ \"%s\" _xZkqqHx_iCkKiKeKiCkPiCnMiClJiCpBiBeC_xHqqkZx_\n_xZkqqHx_iPiIjHjNiCpAjCiGiOhOiClFiCnMiClHiBeC_xHqqkZx_")
			CString str;
			str.Format(	FFLoadString(IDS_ERRMSG_CANNOT_OPEN_FILE),
						W2CA(wcsHtmlFilePath));
//----- 06.07.04 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
			::AfxMessageBox( str, MB_OK | MB_APPLMODAL | MB_ICONSTOP );
			return S_OK;
		}

		fprintf( fptr, "<HTML>\n<embed src=\"%s\" width=\"%f\" height=\"%f\" type=\"image/svg+xml\" pluginspage=\"http://www.adobe.co.jp/svg/viewer/install/\">\n</HTML>",
			mbcSvgFilename, mmPaperWidth * SvgExportInfo::svgExportOption._dpi / 25.4, 
			mmPaperHeight * SvgExportInfo::svgExportOption._dpi / 25.4 );
		fclose( fptr );
	} // if _htmlOutput

	return S_OK;

} // end of exportSelectedObjToSVGFile


#ifndef PGSVGIMPORTTOOL
void printContinuableDialog( char *filename, int lineNumber )
{
//----- 06.07.04 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	char szBuff[512];
//	sprintf( szBuff, "SVGExport_xZkqqHx_iDhGiDiJiDePiDeDiDjD_xHqqkZx_ _xZkqqHx_iDeHiDiJiBfL_xHqqkZx_\n\n_xZkqqHx_iPiIjHjNjCiGiCmJiMhAjBlBiPiIjHjNiJmCjEfMiCmIiDeHiDiJiBfLiCkKjEkNjAlGiClFiCnMiClFiClNiBeC_xHqqkZx_\n_xZkqqHx_iPiIjHjNiCpAjBlBiNhDiClFiCnMiClHiBeC_xHqqkZx_\n_xZkqqHx_iPnKiClFiCkNiCmNiBeB_xHqqkZx_SVGExport_xZkqqHx_iDhGiDiJiDePiDeDiDjDiCmMiDhHiDiLiDhGiCpAiClCiOfBiPmGiJlKiClDiCkCiBeC_xHqqkZx_\n\n_xZkqqHx_iDeHiDiJiBfLiPoOjFpBiBeG_xHqqkZx_%s, line %d", filename, lineNumber );
//	::AfxMessageBox( szBuff, MB_OK | MB_APPLMODAL | MB_ICONEXCLAMATION );
//----- 06.07.04 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	CString str;
	// "SVGExport_xZkqqHx_iDhGiDiJiDePiDeDiDjD_xHqqkZx_ _xZkqqHx_iDeHiDiJiBfL_xHqqkZx_\n\n_xZkqqHx_iPiIjHjNjCiGiCmJiMhAjBlBiPiIjHjNiJmCjEfMiCmIiDeHiDiJiBfLiCkKjEkNjAlGiClFiCnMiClFiClNiBeC_xHqqkZx_\n_xZkqqHx_iPiIjHjNiCpAjBlBiNhDiClFiCnMiClHiBeC_xHqqkZx_\n_xZkqqHx_iPnKiClFiCkNiCmNiBeB_xHqqkZx_SVGExport_xZkqqHx_iDhGiDiJiDePiDeDiDjDiCmMiDhHiDiLiDhGiCpAiClCiOfBiPmGiJlKiClDiCkCiBeC_xHqqkZx_"
	str.LoadString(IDS_ERRMSG_CONTINUABLE_ERROR);
	str += "\n\n";
	char szBuff[512];
	// IDS_ERRMSG_ERROR_INFORMATION = "_xZkqqHx_iDeHiDiJiBfLiPoOjFpBiBeG_xHqqkZx_%s, line %d"
	sprintf(szBuff, FFLoadString(IDS_ERRMSG_ERROR_INFORMATION), filename, lineNumber);
	str += szBuff;
	::AfxMessageBox(str, MB_OK | MB_APPLMODAL | MB_ICONEXCLAMATION);
//----- 06.07.04 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // end of printContinuableDialog
#endif // PGSVGIMPORTTOOL


#ifndef PGSVGIMPORTTOOL
int printErrorDialog( int error, char *filename, int lineNumber, char *message )
{
//----- 06.07.04 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	char str[512];
//
//	switch ( error ) {
//	case SVGEXPORT_ERROR :
//		sprintf( str, "SVGExport_xZkqqHx_iDhGiDiJiDePiDeDiDjD_xHqqkZx_ _xZkqqHx_iDeHiDiJiBfL_xHqqkZx_\n\n_xZkqqHx_iPiIjHjNjCiGiCmJiDeHiDiJiBfLiCkKjEkNjAlGiClFiCnMiClFiClNiBeC_xHqqkZx_\n_xZkqqHx_iPiIjHjNiCpAjCiGiOhOiClFiCnMiClHiBeC_xHqqkZx_\n_xZkqqHx_iPnKiClFiCkNiCmNiBeB_xHqqkZx_SVGExport_xZkqqHx_iDhGiDiJiDePiDeDiDjDiCmMiDhHiDiLiDhGiCpAiClCiOfBiPmGiJlKiClDiCkCiBeC_xHqqkZx_\n\n_xZkqqHx_iDeHiDiJiBfLiPoOjFpBiBeG_xHqqkZx_%s, line %d", filename, lineNumber );
//		break;
//	case SVGEXPORT_FATAL_ERROR : 
//		sprintf( str, "SVGExport_xZkqqHx_iDhGiDiJiDePiDeDiDjD_xHqqkZx_ _xZkqqHx_iDeHiDiJiBfL_xHqqkZx_\n\n_xZkqqHx_iPiIjHjNjCiGiCmJjChGjGlNjDeJiCmIiDeHiDiJiBfLiCkKjEkNjAlGiClFiCnMiClFiClNiBeC_xHqqkZx_\n_xZkqqHx_iPiIjHjNiCpAjCiGiOhOiClFiCnMiClHiBeC_xHqqkZx_\n_xZkqqHx_iPnKiClFiCkNiCmNiBeB_xHqqkZx_SVGExport_xZkqqHx_iDhGiDiJiDePiDeDiDjDiCmMiDhHiDiLiDhGiCpAiClCiOfBiPmGiJlKiClDiCkCiBeC_xHqqkZx_\n\n_xZkqqHx_iDeHiDiJiBfLiPoOjFpBiBeG_xHqqkZx_%s, line %d", filename, lineNumber );
//		break;
//	case SVGEXPORT_CONTINUABLE_ERROR :
//		sprintf( str, "SVGExport_xZkqqHx_iDhGiDiJiDePiDeDiDjD_xHqqkZx_ _xZkqqHx_iDeHiDiJiBfL_xHqqkZx_\n\n_xZkqqHx_iPiIjHjNjCiGiCmJiMhAjBlBiPiIjHjNiJmCjEfMiCmIiDeHiDiJiBfLiCkKjEkNjAlGiClFiCnMiClFiClNiBeC_xHqqkZx_\n_xZkqqHx_iPiIjHjNiCpAjBlBiNhDiClFiCnMiClHiBeC_xHqqkZx_\n_xZkqqHx_iPnKiClFiCkNiCmNiBeB_xHqqkZx_SVGExport_xZkqqHx_iDhGiDiJiDePiDeDiDjDiCmMiDhHiDiLiDhGiCpAiClCiOfBiPmGiJlKiClDiCkCiBeC_xHqqkZx_\n\n_xZkqqHx_iDeHiDiJiBfLiPoOjFpBiBeG_xHqqkZx_%s, line %d", filename, lineNumber );
//		break;
//	default :
//		sprintf( str, "SVGExport_xZkqqHx_iDhGiDiJiDePiDeDiDjD_xHqqkZx_ _xZkqqHx_iDeHiDiJiBfL_xHqqkZx_\n\n_xZkqqHx_iPiIjHjNjCiGiCmJjFhDjGlOiDeHiDiJiBfLiCkKjEkNjAlGiClFiCnMiClFiClNiBeC_xHqqkZx_\n_xZkqqHx_iPiIjHjNiCpAjCiGiOhOiClFiCnMiClHiBeC_xHqqkZx_\n_xZkqqHx_iPnKiClFiCkNiCmNiBeB_xHqqkZx_SVGExport_xZkqqHx_iDhGiDiJiDePiDeDiDjDiCmMiDhHiDiLiDhGiCpAiClCiOfBiPmGiJlKiClDiCkCiBeC_xHqqkZx_\n\n_xZkqqHx_iDeHiDiJiBfLiPoOjFpBiBeG_xHqqkZx_%s, line %d", filename, lineNumber );
//	} // switch
//
//	if ( message ) {
//		strcat( str, "\n" );
//		strcat( str, message );
//	}
//
//	::AfxMessageBox( str, MB_OK | MB_APPLMODAL | MB_ICONSTOP );
//
//	return error;
//----- 06.07.04 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	char szBuff[512];
	// IDS_ERRMSG_ERROR_INFORMATION = "_xZkqqHx_iDeHiDiJiBfLiPoOjFpBiBeG_xHqqkZx_%s, line %d"
	sprintf(szBuff, FFLoadString(IDS_ERRMSG_ERROR_INFORMATION), filename, lineNumber);
	CString str;
	switch (error)
	{
	case SVGEXPORT_ERROR :
		str.LoadString(IDS_ERRMSG_NOT_CONTINUABLE_ERROR);
		break;
	case SVGEXPORT_FATAL_ERROR : 
		str.LoadString(IDS_ERRMSG_FATAL_ERROR);
		break;
	case SVGEXPORT_CONTINUABLE_ERROR :
		str.LoadString(IDS_ERRMSG_CONTINUABLE_ERROR);
		break;
	default :
		str.LoadString(IDS_ERRMSG_UNKNOWN_ERROR);
	} // switch
	str += "\n\n";
	str += szBuff;
	if (message != NULL)
	{
		str += "\n";
		str += message;
	}
	::AfxMessageBox(str, MB_OK | MB_APPLMODAL | MB_ICONSTOP);
	return error;
//----- 06.07.04 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

} // end of printErrorDialog
#endif // PGSVGIMPORTTOOL


char* getCommentStr( char * commentStr ) {

	if ( SvgExportInfo::svgExportOption._printComment ) {
		return commentStr;
	} else {
		return "";
	}

}  // end of getCommentStr


#define MAKE_FORMAT_STRING_NUM	1024

// "%f"_xZkqqHx_iCpAiDeJiDhGiDfGiDiHiDjDiCmM_xHqqkZx_digitNum_xZkqqHx_iCmJiCoGiCoJjAlIjDhIjFhEiCmJiClFiCmEjFnEiClH_xHqqkZx_
char* SvgExportInfo::getFormatString( char *orgFormatString ) {

	static char newFormatStr[MAKE_FORMAT_STRING_NUM];

	static char *digitStr[] = { "%.0f", "%.1f", "%.2f", "%.3f", "%.4f", "%.5f", "%.6f" };

	if ( MAKE_FORMAT_STRING_NUM < strlen( orgFormatString ) * 3 / 2 ) {
		return NULL;
	}

	char *srcPtr = orgFormatString;
	char *dstPtr = newFormatStr;
	char *numPos;
	int len;

	newFormatStr[0] = '\0';

	while ( 1 ) {
		numPos = strstr( srcPtr, "%n" );
		if ( numPos ) {
			len = numPos - srcPtr;
			memcpy( dstPtr, srcPtr, len );
			dstPtr += len;
			dstPtr += sprintf( dstPtr, "%s", digitStr[svgExportOption._digitNum] );
			srcPtr += len + 2;
		} else {
			strcat( dstPtr, srcPtr );
			dstPtr += strlen( srcPtr );
			break;
		}
	} // while

	*dstPtr = '\0';

	return newFormatStr;

} // end of getFormatString

// _xZkqqHx_iImIiJlKiCmMjBkOjAkLiCpAjAnNjCoI_xHqqkZx_
//   _xZkqqHx_iDhJiDjDiCmMjBlOiClDiBeCjCfAiImK_xHqqkZx_=mm_xZkqqHx_iBeC_xHqqkZx_
//   _xZkqqHx_iDhJiDjDiCmMiDfIiDfOiDeDiDiLiBgJjClMjApMiBeBiNlNjApMjDjJiBgK_xHqqkZx_
//   _xZkqqHx_iDhJiDjDiCmMjEhHiMgJjAeG_xHqqkZx_
//   _xZkqqHx_iDhFiDiJiDfGiCmMjBePiMgJjAeG_xHqqkZx_
//   _xZkqqHx_iDhFiDiJiDfGiCmMjEhHiMgJjAeG_xHqqkZx_
void SvgExportInfo::setStyle()
{
//----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_iDhJiDjDiCmMjBlOiClDiCpAiOoGjDlOiBeCjCfAiImK_xHqqkZx_=mm_xZkqqHx_iBeC_xHqqkZx_
//	_penWidth = _objectExp->GetStdPenWeight();
//
//	// _xZkqqHx_iDhJiDjDiCmMiDfIiDfOiDeDiDiLiBgJjClMjApMiBeBiNlNjApMjDjJiBgKiCpAiOoGjDlOiClFiCnMiClHiBeC_xHqqkZx_
//	PenStyleID psid = _objectExp->GetStdPenStyle();
//	if ( FD_PEN_STYLE_UNUSE != psid ) {
//		_recPenStyle = FFGetMolipBaseI()->GetEnv()->GetPenStyleRec(psid);
//	}
//
//	SColorID scid;
//	// _xZkqqHx_iDhJiDjDiCmMjEhHiMgJjAeGiCpAiOoGjDlOiClFiCnMiClHiBeC_xHqqkZx_
//	scid = _objectExp->GetStdPenBackSColor();
//	if (scid != FD_S_COLOR_TRANSPARENT) {
//		_penBgColor = RGB2RGBA( FFGetMolipBaseI()->GetEnv()->scid2cref(scid) );
//	} else {
//		_penBgColor = RGBA(255, 255, 255, 0);
//	}
//
//	// _xZkqqHx_iDhFiDiJiDfGiCmMjBePiMgJjAeGiCpAiOoGjDlOiClFiCnMiClHiBeC_xHqqkZx_
//	scid = _objectExp->GetStdBrushForeSColor();
//	if (scid != FD_S_COLOR_TRANSPARENT) {
//		_brushFgColor = RGB2RGBA( FFGetMolipBaseI()->GetEnv()->scid2cref(scid) );
//	} else {
//		_brushFgColor = RGBA(255, 255, 255, 0);
//	}
//
//	// _xZkqqHx_iDhFiDiJiDfGiCmMjEhHiMgJjAeGiCpAiOoGjDlOiClFiCnMiClHiBeC_xHqqkZx_
//	scid = _objectExp->GetStdBrushBackSColor();
//	if (scid != FD_S_COLOR_TRANSPARENT) {
//		_brushBgColor = RGB2RGBA( FFGetMolipBaseI()->GetEnv()->scid2cref(scid) );
//	} else {
//		_brushBgColor = RGBA(255, 255, 255, 0);
//	}
//
//	// _xZkqqHx_iDhFiDiJiDfGiCmMiDhAiDfOiBfLiDjD_xHqqkZx_ID
//	_brushPattern = _objectExp->GetStdBrushPattern();
//----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	_penWidth = 1;						// _xZkqqHx_iDhJiDjDiCmMjBlOiClDiBeC_xHqqkZx_
	_recPenStyle = NULL;				// _xZkqqHx_iDhJiDjDiCmMiDfIiDfOiDeDiDiLiBeC_xHqqkZx_
	_penBgColor = 0x000000;				// _xZkqqHx_iDhJiDjDiCmMjEhHiMgJjAeGiBeC_xHqqkZx_
	_brushFgColor = 0x000000;			// _xZkqqHx_iDhFiDiJiDfGiCmMjBePiMgJjAeGiBeC_xHqqkZx_
	_brushBgColor = 0x000000;			// _xZkqqHx_iDhFiDiJiDfGiCmMjEhHiMgJjAeGiBeC_xHqqkZx_
	_brushPattern = FD_PATTERN_UNUSE;	// _xZkqqHx_iDhFiDiJiDfGiCmMiDhAiDfOiBfLiDjD_xHqqkZx_ID _xZkqqHx_iBeC_xHqqkZx_
	_isFillPainted = false;				// _xZkqqHx_jDgIiCoIiCmCiCnEiClHiCkJiBeIiBeC_xHqqkZx_
	if (_objectExp->IsKindOf(FDOJ_FIGURE))
	{
		const FCObjFigure* pFig = (const FCObjFigure*)_objectExp;
		// _xZkqqHx_iDhJiDjDiCmMjBlOiClDiCpAiOoGjDlOiBeCjCfAiImK_xHqqkZx_=mm_xZkqqHx_iBeC_xHqqkZx_
		_penWidth = pFig->GetStdPenWeight();
		// _xZkqqHx_iDhJiDjDiCmMiDfIiDfOiDeDiDiLiBgJjClMjApMiBeBiNlNjApMjDjJiBgKiCpAiOoGjDlOiClFiCnMiClHiBeC_xHqqkZx_
		PenStyleID psid = pFig->GetStdPenStyle();
		if (FD_PEN_STYLE_UNUSE != psid)
			_recPenStyle = FFGetMolipBaseI()->GetEnv()->GetPenStyleRec(psid);

		SColorID scid;
		// _xZkqqHx_iDhJiDjDiCmMjEhHiMgJjAeGiCpAiOoGjDlOiClFiCnMiClHiBeC_xHqqkZx_
		scid = pFig->GetStdPenBackSColor();
		if (scid != FD_S_COLOR_TRANSPARENT)
			_penBgColor = RGB2RGBA( FFGetMolipBaseI()->GetEnv()->scid2cref(scid) );
		else
			_penBgColor = RGBA(255, 255, 255, 0);

		// _xZkqqHx_iDhFiDiJiDfGiCmMjBePiMgJjAeGiCpAiOoGjDlOiClFiCnMiClHiBeC_xHqqkZx_
		scid = pFig->GetStdBrushForeSColor();
		if (scid != FD_S_COLOR_TRANSPARENT)
			_brushFgColor = RGB2RGBA( FFGetMolipBaseI()->GetEnv()->scid2cref(scid) );
		else
			_brushFgColor = RGBA(255, 255, 255, 0);

		scid = FD_S_COLOR_TRANSPARENT;
		// _xZkqqHx_iDhFiDiJiDfGiCmMjEhHiMgJjAeGiCpAiOoGjDlOiClFiCnMiClHiBeC_xHqqkZx_
		scid = pFig->GetStdBrushBackSColor();
		if (scid != FD_S_COLOR_TRANSPARENT)
			_brushBgColor = RGB2RGBA( FFGetMolipBaseI()->GetEnv()->scid2cref(scid) );
		else
			_brushBgColor = RGBA(255, 255, 255, 0);

		// _xZkqqHx_iDhFiDiJiDfGiCmMiDhAiDfOiBfLiDjD_xHqqkZx_ID
		_brushPattern = pFig->GetStdBrushPattern();

//----- 06.07.04 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
		// _xZkqqHx_jDgIiCoIiCmCiCnEiClHiCkJiBeI_xHqqkZx_
		_isFillPainted = pFig->IsFillPainted() ? true : false;
//----- 06.07.04 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	}
//----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // end of SvgExportInfo::setStyle


// _xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiDfOiDeDiDhGiCpAiMkJiCmEiBeB_xHqqkZx_shouldPrintClippedBrushPattern_xZkqqHx_iCpAjAnNjCoIiClHiCoJ_xHqqkZx_
int SvgExportInfo::setShouldPrintClippedBrushPattern() {

	switch (_objectExp->Type())
	{
//----- 06.06.29 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	case FDOJ_NONE :
//	case FDOJ_OBJECT : 
//	case FDOJ_FIGURE : 
//----- 06.06.29 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	case FDOJ_OLE : 
	case FDOJ_CHIP_MASTER : 
	case FDOJ_POINT : 			// _xZkqqHx_iDhMiDeDiDjDiDgHjFjEjFgJiBeC_xHqqkZx_
		_shouldPrintClippedBrushPattern = false;
		break;
	case FDOJ_LINE : 
	case FDOJ_RECT : 
	case FDOJ_ROUND_RECT : 
	case FDOJ_ARC : 
	case FDOJ_POLY : 
	case FDOJ_GROUP : 
	case FDOJ_WIDE_POLY : 
// 06.07.01 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	case FDOJ_PICT_ARROW : 	// _xZkqqHx_iDhDiDeOiDgAiDiDjGoOiIpDjFjEjFgJiBeC_xHqqkZx_
	case FDOJ_LABEL : 
//----- 06.06.29 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	case FDOJ_TABLE :			// _xZkqqHx_jFfMjFjEjFgJiBeC_xHqqkZx_
	case FDOJ_TEXT_RECT :		// _xZkqqHx_iDgFiDeMiDfIiDgHiLoJiMgAjFjEjFgJiBeC_xHqqkZx_
//----- 06.06.29 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
// 06.07.04 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
		_shouldPrintClippedBrushPattern = true;
		break;
	default :
		// _xZkqqHx_iDeHiDiJiBfL_xHqqkZx_
		return SE_ERROR_RETURN( SVGEXPORT_ERROR );
	} // switch

	return SVGEXPORT_OK;

} // end of SvgExportInfo::setShouldPrintClippedBrushPattern


// _xZkqqHx_iJgFiCoCiDhFiDiJiDfGiCmIiCmHiCmMjBkOjAkLiCpAiOjNiCmBiClNiDeJiDhFiDfHiDeGiDeOiDgHiCkJiCmHiCkEiCkJ_xHqqkZx_
bool SvgExportInfo::isPrintableObject() {
	switch ( _objectExp->Type() ) {
//----- 06.06.29 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	case FDOJ_NONE :
//	case FDOJ_OBJECT : 
//	case FDOJ_FIGURE : 
//----- 06.06.29 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	case FDOJ_GROUP : 
// 06.06.29 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	case FDOJ_TABLE :			// _xZkqqHx_jFfMjFjEjFgJiBeC_xHqqkZx_
	case FDOJ_CHIP_MASTER : 
	case FDOJ_POINT : 			// _xZkqqHx_iDhMiDeDiDjDiDgHjFjEjFgJiBeC_xHqqkZx_
		return false;
	case FDOJ_LINE : 
	case FDOJ_RECT : 
	case FDOJ_ROUND_RECT : 
	case FDOJ_ARC : 
	case FDOJ_POLY : 
	case FDOJ_WIDE_POLY : 
	case FDOJ_OLE : 
// 06.07.01 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	case FDOJ_PICT_ARROW : 	// _xZkqqHx_iDhDiDeOiDgAiDiDjGoOiIpDjFjEjFgJiBeC_xHqqkZx_
	case FDOJ_LABEL : 
//----- 06.06.29 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	case FDOJ_TEXT_RECT :		// _xZkqqHx_iDgFiDeMiDfIiDgHiLoJiMgAjFjEjFgJiBeC_xHqqkZx_
//----- 06.06.29 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
		return true;
	default :
		// _xZkqqHx_iDeHiDiJiBfL_xHqqkZx_
		return false;
	} // switch

} // end of isPrintableObject


int SvgExportInfo::printEachSVG (bool printClipPath)
{
	int result;

	switch (_objectExp->Type())
	{
//----- 06.06.29 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	case FDOJ_NONE :
//		_partsName = "None parts";
//		result = printSvgUnsupported();
//		SE_RESULT_CHECK( result );
//		break;
//	case FDOJ_OBJECT : 
//		_partsName = "Object parts";
//		result = printSvgUnsupported();
//		SE_RESULT_CHECK( result );
//		break;
//	case FDOJ_FIGURE : 
//		_partsName = "Figure parts";
//		result = printSvgUnsupported();
//		SE_RESULT_CHECK( result );
//		break;
//----- 06.06.29 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	case FDOJ_LINE : 
// 06.07.03 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//		result = printSvgLine();
		result = printSvgFigure(printClipPath);
		SE_RESULT_CHECK( result );
		break;
	case FDOJ_RECT : 
		result = printSvgRect( printClipPath );
		SE_RESULT_CHECK( result );
		break;
	case FDOJ_ROUND_RECT : 
		result = printSvgRoundRect( printClipPath );
		SE_RESULT_CHECK( result );
		break;
	case FDOJ_ARC : 
		result = printSvgArc( printClipPath );
		SE_RESULT_CHECK( result );
		break;
	case FDOJ_POLY : 
// 06.07.04 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//		result = printSvgPoly( printClipPath );
		result = printSvgFigure(printClipPath);
		SE_RESULT_CHECK( result );
		break;
	case FDOJ_GROUP : 
		result = printSvgGroup();
		SE_RESULT_CHECK( result );
		break;
//----- 06.07.03 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	case FDOJ_TABLE :			// _xZkqqHx_jFfMjFjEjFgJiBeC_xHqqkZx_
		result = printSvgTable();
		SE_RESULT_CHECK( result );
		break;
//----- 06.07.03 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	case FDOJ_WIDE_POLY : 
		result = printSvgWidePoly( printClipPath );
		SE_RESULT_CHECK( result );
		break;
	case FDOJ_OLE : 
		_partsName = "OLE parts";
		result = printSvgOLE( printClipPath );
		SE_RESULT_CHECK( result );
		break;
	case FDOJ_CHIP_MASTER : 
		result = printSvgChipMaster();
		SE_RESULT_CHECK( result );
		break;
	case FDOJ_POINT : 			// _xZkqqHx_iDhMiDeDiDjDiDgHjFjEjFgJiBeC_xHqqkZx_
		//_partsName = "Point parts";
		//result = printSvgUnsupported();
		//SE_RESULT_CHECK( result );
		// _xZkqqHx_jGlDiOiL_xHqqkZx_
		return SVGEXPORT_OK;
		break;
//----- 06.07.01 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	case FDOJ_PICT_ARROW : 	// _xZkqqHx_iDhDiDeOiDgAiDiDjGoOiIpDjFjEjFgJiBeC_xHqqkZx_
//		result = printSvgPictArrow();
//		SE_RESULT_CHECK( result );
//		break;
//----- 06.07.01 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	case FDOJ_LABEL : 
		result = printSvgLabel( printClipPath );
		SE_RESULT_CHECK( result );
		break;
//----- 06.07.01 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	case FDOJ_TEXT_RECT :		// _xZkqqHx_iDgFiDeMiDfIiDgHiLoJiMgAjFjEjFgJiBeC_xHqqkZx_
		result = printSvgTextRect( printClipPath );
		SE_RESULT_CHECK( result );
		break;
//----- 06.07.01 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	default :
		// _xZkqqHx_iDeHiDiJiBfL_xHqqkZx_
		_partsName = "Unknown type parts";
		return printSvgUnsupported();
	} // switch

	if ( false == printClipPath && _objectExp->GetRichText() ) {
		// _xZkqqHx_iDgFiDeMiDfIiDgHjHeMiCoI_xHqqkZx_
		//double angle = _objectExp->GetAngle();
		double angle = 0.0;
		const FCRichText *pRich = _objectExp->GetRichText();
		if ( NULL != pRich ) {
			angle = pRich->GetAngle();
		}
		if ( 0.0 != angle && false == _isChipMaster ) {
			// _xZkqqHx_iJpBjDfNjHeMiCoI_xHqqkZx_
			fprintf( _fptr, "<g " );
			printTransform( SI_TEXT_ANGLE_TRANSFORM );
			fprintf( _fptr, ">%s\n", getCommentStr( "<!-- rotation -->" ) );
		}
		result = printText();
		SE_RESULT_CHECK( result );
		if ( 0.0 != angle && false == _isChipMaster  ) {
			// _xZkqqHx_iJpBjDfNjHeMiCoI_xHqqkZx_
			fprintf( _fptr, "</g>%s\n", getCommentStr( "<!-- rotation -->" ) );
		}
	}

	fflush( _fptr );

	return SVGEXPORT_OK;

} // end of SvgExportInfo::printEachSVG



// _xZkqqHx_iJgFiPiIjHjN_xHqqkZx_
int SvgExportInfo::printShadow ()
{
//----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	SColorID scid = _objectExp->GetShadowSColor();
//	COLORREF shadowColor = RGB2RGBA( FFGetMolipBaseI()->GetEnv()->scid2cref(scid) );
//	char shadowRgbStr[SVG_RGBSTR_MAXLEN+1];
//	char *shadowColorStr = getExportSvgColorStr( shadowColor, shadowRgbStr );
//
//	DBLPoint offset = FFGetMolipBaseI()->GetEnv()->GetShadowLen();
//
//	char *formatStr = getFormatString( "<defs>\n<filter id='dd_shadow_%d' filterUnits='objectBoundingBox' width='2' height='2'>\n<feOffset in='SourceAlpha' dx='%n' dy='%n' result='dd_shadowPos_%d'/>\n<feFlood style='flood-color:%s'/>\n<feComposite in2='dd_shadowPos_%d' operator='in' result='dd_shadowPosFilled_%d'/>\n<feMerge>\n<feMergeNode in='dd_shadowPosFilled_%d'/>\n<feMergeNode in='SourceGraphic'/>\n</feMerge>\n</filter>\n</defs>\n" );
//	fprintf( _fptr, formatStr, _shadowNo, SvgUnit( offset.x ), SvgUnit( offset.y ), _shadowNo, 
//		shadowColorStr, _shadowNo, _shadowNo, _shadowNo );
//
//	return SVGEXPORT_OK;
//----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	if (!_objectExp->IsKindOf(FDOJ_FIGURE))
		ThrowSvgSystemError();
	SColorID scid = ((const FCObjFigure*)_objectExp)->GetShadowSColor();
	COLORREF shadowColor = RGB2RGBA( FFGetMolipBaseI()->GetEnv()->scid2cref(scid) );
	char shadowRgbStr[SVG_RGBSTR_MAXLEN+1];
	char *shadowColorStr = getExportSvgColorStr( shadowColor, shadowRgbStr );

	DBLPoint offset = FFGetMolipBaseI()->GetEnv()->GetShadowLen();

	char *formatStr = getFormatString( "<defs>\n<filter id='dd_shadow_%d' filterUnits='objectBoundingBox' width='2' height='2'>\n<feOffset in='SourceAlpha' dx='%n' dy='%n' result='dd_shadowPos_%d'/>\n<feFlood style='flood-color:%s'/>\n<feComposite in2='dd_shadowPos_%d' operator='in' result='dd_shadowPosFilled_%d'/>\n<feMerge>\n<feMergeNode in='dd_shadowPosFilled_%d'/>\n<feMergeNode in='SourceGraphic'/>\n</feMerge>\n</filter>\n</defs>\n" );
	fprintf( _fptr, formatStr, _shadowNo, SvgUnit( offset.x ), SvgUnit( offset.y ), _shadowNo, 
		shadowColorStr, _shadowNo, _shadowNo, _shadowNo );

	return SVGEXPORT_OK;
//----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

} // end of printShadow


static char* objectTypeName[] = {
	"FDOJ_NONE", "FDOJ_OBJECT", "FDOJ_FIGURE", "FDOJ_LINE",
	"FDOJ_RECT", "FDOJ_ROUND_RECT", "FDOJ_ARC", "FDOJ_POLY",
	"FDOJ_GROUP", "FDOJ_WIDE_POLY", "FDOJ_OLE", "FDOJ_CHIP_MASTER",
	"FDOJ_POINT", "FDOJ_PICT_ARROW", "FDOJ_LABEL",
//----- 06.06.29 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	"FDOJ_TABLE",
	"FDOJ_TEXT_RECT"
//----- 06.06.29 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
 };


int SvgExportInfo::printSVG ()
{
	FTObjectType type = _objectExp->Type();
// 06.06.29 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	if ( FDOJ_NONE <= type && type <= FDOJ_LABEL ) {
	if ( FDOJ_NONE <= type && type <= FDOJ_TEXT_RECT ) {
		char typeComment[256];
		sprintf( typeComment, "<!-- start DynamicDraw object [%d], type : %s -->\n", _objectIndex, objectTypeName[type] );
		fprintf( _fptr, "%s", getCommentStr( typeComment ) );
	}

//----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	SColorID shadowColor = _objectExp->GetShadowSColor();
//----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	SColorID shadowColor = FD_S_COLOR_TRANSPARENT;
	if (_objectExp->IsKindOf(FDOJ_FIGURE))
		shadowColor = ((const FCObjFigure*)_objectExp)->GetShadowSColor();
//----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

	if ( isPrintableObject() )
	{
		setShouldPrintClippedBrushPattern();

		if ( FD_S_COLOR_TRANSPARENT != shadowColor )
		{
			// _xZkqqHx_iJgFiPiIjHjN_xHqqkZx_
			fprintf( _fptr, "<g>%s\n", 
				getCommentStr( "<!-- start object with shadow.-->" ) );
			printShadow();
		}

		// _xZkqqHx_iDhFiDiJiDfGiDhAiDfOiBfLiDjD_xHqqkZx_
		if ( SVG_NO_BRUSHPATTERN != _brushPattern &&
			_shouldPrintClippedBrushPattern ) {

			fprintf( _fptr, "<g id='group_clip%d_pattern%d'>%s\n", _clipNo, _brushPattern, 
				getCommentStr( "<!-- start object with clipping pattern.-->" ) );

			// _xZkqqHx_iDhFiDiJiDfGiDhAiDfOiBfLiDjDjHhAiDeOiDiKiDgCiDhDiDjDiDePiPgPjHmN_xHqqkZx_
			printClipPathDefs();

			// _xZkqqHx_iDhFiDiJiDfGiDhAiDfOiBfLiDjDiCpAiDeOiDiKiDgCiDhDiDjDiDePiOhHjCoIjFhEiCmFiPgPjHmNiClHiCoJ_xHqqkZx_
			printClippedBrushPattern();
		}
	} // if isPrintableObject

	int result = printEachSVG( NOT_PRINT_SVG_CLIP_PATH );
	SE_RESULT_CHECK( result );

	if ( isPrintableObject() ) {
		// _xZkqqHx_iDhFiDiJiDfGiDhAiDfOiBfLiDjD_xHqqkZx_
		if ( SVG_NO_BRUSHPATTERN != _brushPattern &&
			_shouldPrintClippedBrushPattern ) {
			fprintf( _fptr, "</g>%s\n", 
				getCommentStr( "<!-- end object with clipping pattern.-->" ) );
		}

		if ( FD_S_COLOR_TRANSPARENT != shadowColor ) {
			// _xZkqqHx_iJgFiPiIjHjN_xHqqkZx_
			fprintf( _fptr, "</g>%s\n", 
				getCommentStr( "<!-- end object with shadow.-->" ) );
		}
	} // if isPrintableObject

// 06.06.29 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	if ( FDOJ_NONE <= type && type <= FDOJ_LABEL ) {
	if ( FDOJ_NONE <= type && type <= FDOJ_TEXT_RECT ) {
		char typeComment[256];
		sprintf( typeComment, "<!-- end DynamicDraw object [%d], type : %s -->\n", _objectIndex++, objectTypeName[type] );
		fprintf( _fptr, "%s", getCommentStr( typeComment ) );
	}

	return SVGEXPORT_OK;

} // end of SvgExportInfo::printSVG



// _xZkqqHx_jApMjFkKiDfPiDgCiDfGiDiFjFlGiOjKjHpBiCpAjDlOiCoJ_xHqqkZx_
//   dashStr_xZkqqHx_iCmNiBeBiKgNjFnLiClFiCmEiCkIiCkNiBeC_xHqqkZx_
void SvgExportInfo::getExportDashStr( char *dashStr ) {

	if ( NULL == _recPenStyle ) {
		// _xZkqqHx_iDhJiDjDiDfIiDfOiDeDiDiLiOhHjCoIiCkKjGlDiCkCiCmGiMkJiCmIiClFiCmEiBeBjElCiCkPiCoJ_xHqqkZx_
		dashStr[0] = '\0';
		return;
	}

	if ( 0.0 != _recPenStyle->m_mmfaData[0] ||
		0.0 != _recPenStyle->m_mmfaData[1] ||
		0.0 != _recPenStyle->m_mmfaData[2] ||
		0.0 != _recPenStyle->m_mmfaData[3] ) {
		sprintf( dashStr, "; stroke-dasharray:%-.3f,%-.3f,%-.3f,%-.3f", 
			SvgUnit( _recPenStyle->m_mmfaData[0] * _penWidth * 4 ), SvgUnit( _recPenStyle->m_mmfaData[1] * _penWidth * 4 ), 
			SvgUnit( _recPenStyle->m_mmfaData[2] * _penWidth* 4  ), SvgUnit( _recPenStyle->m_mmfaData[3] * _penWidth * 4 ) );
	} else {
		dashStr[0] = '\0';
	}
	
} // end of SvgExportInfo::getExportDashStr


//----- 06.07.04 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//// _xZkqqHx_jDgIiCoIiCmCiCnEiClFjAeGjFlGiOjKjHpBiCpAjDlOiCoJ_xHqqkZx_
////   brushBgRgbStr_xZkqqHx_iCmNiCkAiCoHiCkJiClGiCnPiKgNjFnLiClFiCmEiCkIiCkN_xHqqkZx_
//void SvgExportInfo::getExportFilledColorStr( char *brushBgRgbStr ) {
//
//	if ( _objectExp->IsFillPainted() )
//	{
//		getExportSvgColorStr( _brushBgColor, brushBgRgbStr );
//	} else {
//		strcpy( brushBgRgbStr, "none" );
//	}
//
//} // end of SvgExportInfo::getExportFilledColorStr
//----- 06.07.04 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----




// _xZkqqHx_iDhFiDiJiDfGiDhAiDfOiBfLiDjDjHhAiDeOiDiKiDgCiDhDiDjDiDePiPgPjHmN_xHqqkZx_
int SvgExportInfo::printClipPathDefs() {

	fprintf( _fptr, "<defs>\n<clipPath id='DynamicDraw_clip%d_ptn%d'>\n", _clipNo, _brushPattern );

	int result = printEachSVG( PRINT_SVG_CLIP_PATH );
	SE_RESULT_CHECK( result );
	
	fprintf( _fptr, "</clipPath>\n</defs>\n" );

	return result;

} // end of SvgExportInfo::printClipPathDefs






// _xZkqqHx_iDhFiDiJiDfGiDhAiDfOiBfLiDjDiCpAiDeOiDiKiDgCiDhDiDjDiDePiOhHjCoIjFhEiCmFiPgPjHmNiClHiCoJ_xHqqkZx_
int SvgExportInfo::printClippedBrushPattern() {

	// _xZkqqHx_iKePjAnKiLoJiMgAiCpAjDlOiCoJ_xHqqkZx_
	DBLRect	rect = _objectExp->CalcExactOuterFrame();
	//rect.left += _penWidth;
	//rect.top += _penWidth;

	// _xZkqqHx_iDhFiDiJiDfGjEhHiMgJjAeGjFlGiOjKjHpBiCpAjDlOiCoJ_xHqqkZx_
	char *fillColorStr, brushBgRgbStr[SVG_RGBSTR_MAXLEN+1];
	fillColorStr = getExportSvgColorStr( _brushBgColor, brushBgRgbStr );

	// _xZkqqHx_iDhFiDiJiDfGjEhHiMgJjAeGiCmMjDgIiCoIiCmCiCnEiClFiLoJiMgA_xHqqkZx_
	char *formatStr = getFormatString( "<rect x='%n' y='%n' width='%n' height='%n' style='fill:%s;stroke-width:0;clip-path:url(#DynamicDraw_clip%d_ptn%d)'/>\n" );
	fprintf( _fptr, formatStr,
		SvgUnitOffsetX( rect.left ), SvgUnitOffsetY( rect.top ), 
		SvgUnit( rect.Width() ), SvgUnit( rect.Height() ), fillColorStr, _clipNo, _brushPattern );

	// _xZkqqHx_iDhFiDiJiDfGiCmMjBePiMgJjAeGjFlGiOjKjHpBiCpAjDlOiCoJ_xHqqkZx_
	char brushFgRgbStr[SVG_RGBSTR_MAXLEN+1];
	char *brushFgColorStr = getExportSvgColorStr( _brushFgColor, brushFgRgbStr );

	double nAtomLen = 1 / SVG_PATTERN_DOT_PER_MM;
	CSRect rtCanvas( rect.left, rect.top, rect.right, rect.bottom );
	CSRect rtClip = rtCanvas;

	switch ( _brushPattern ) {
	case 0:	// _xZkqqHx_iDhAiDfOiBfLiDjD_xHqqkZx_0 : _xZkqqHx_jDfP_xHqqkZx_99%
		printSvgPinholePattern( brushFgColorStr, nAtomLen, rtCanvas, 20, 2, rtClip);
		break;
	case 1: // _xZkqqHx_iDhAiDfOiBfLiDjD_xHqqkZx_1 : _xZkqqHx_jDfP_xHqqkZx_96%
		printSvgPinholePattern( brushFgColorStr, nAtomLen, rtCanvas, 10, 2, rtClip);
		break;
	case 2: // _xZkqqHx_iDhAiDfOiBfLiDjD_xHqqkZx_2 : _xZkqqHx_jDfP_xHqqkZx_82%
		printSvgPinholePattern( brushFgColorStr, nAtomLen, rtCanvas, 7, 3, rtClip);
		break;
	case 3: // _xZkqqHx_iDhAiDfOiBfLiDjD_xHqqkZx_3 : _xZkqqHx_jDfP_xHqqkZx_50%
		printSvgStarPattern( brushFgColorStr, nAtomLen, rtCanvas, 6, 6, rtClip);
		break;
	case 4: // _xZkqqHx_iDhAiDfOiBfLiDjD_xHqqkZx_4 : _xZkqqHx_jDfP_xHqqkZx_22%
		printSvgStarPattern( brushFgColorStr, nAtomLen, rtCanvas, 6, 3, rtClip);
		break;
	case 5: // _xZkqqHx_iDhAiDfOiBfLiDjD_xHqqkZx_5 : _xZkqqHx_jDfP_xHqqkZx_7%
		printSvgStarPattern( brushFgColorStr, nAtomLen, rtCanvas, 8, 2, rtClip);
		break;
	case 6: // _xZkqqHx_iDhAiDfOiBfLiDjD_xHqqkZx_6 : _xZkqqHx_jDfP_xHqqkZx_3%
		printSvgStarPattern( brushFgColorStr, nAtomLen, rtCanvas, 12, 2, rtClip);
		break;
	case 7: // _xZkqqHx_iDhAiDfOiBfLiDjD_xHqqkZx_7 : _xZkqqHx_jBgFiNnHiPgDjApM_xHqqkZx_
		printSvgVLinePattern(brushFgColorStr, nAtomLen, rtCanvas, 20, 1, rtClip);
		break;
	case 8: // _xZkqqHx_iDhAiDfOiBfLiDjD_xHqqkZx_8 : _xZkqqHx_jFmAiNnHiPgDjApM_xHqqkZx_
		printSvgVLinePattern(brushFgColorStr, nAtomLen, rtCanvas, 10, 1, rtClip);
		break;
	case 9: // _xZkqqHx_iDhAiDfOiBfLiDjD_xHqqkZx_9 : _xZkqqHx_jGkHiNnHiPgDjApM_xHqqkZx_
		printSvgVLinePattern(brushFgColorStr, nAtomLen, rtCanvas, 5, 1, rtClip);
		break;
	case 10: // _xZkqqHx_iDhAiDfOiBfLiDjD_xHqqkZx_10 : _xZkqqHx_jBgFjBlOiPgDjApM_xHqqkZx_
		printSvgVLinePattern(brushFgColorStr, nAtomLen, rtCanvas, 20, 2, rtClip);
		break;
	case 11: // _xZkqqHx_iDhAiDfOiBfLiDjD_xHqqkZx_11 : _xZkqqHx_jFmAjBlOiPgDjApM_xHqqkZx_
		printSvgVLinePattern(brushFgColorStr, nAtomLen, rtCanvas, 10, 2, rtClip);
		break;
	case 12: // _xZkqqHx_iDhAiDfOiBfLiDjD_xHqqkZx_12 : _xZkqqHx_jGkHjBlOiPgDjApM_xHqqkZx_
		printSvgVLinePattern(brushFgColorStr, nAtomLen, rtCanvas, 5, 2, rtClip);
		break;
	case 13: // _xZkqqHx_iDhAiDfOiBfLiDjD_xHqqkZx_13 : _xZkqqHx_jBgFiNnHiJkBjApM_xHqqkZx_
		printSvgHLinePattern(brushFgColorStr, nAtomLen, rtCanvas, 20, 1, rtClip);
		break;
	case 14: // _xZkqqHx_iDhAiDfOiBfLiDjD_xHqqkZx_14 : _xZkqqHx_jFmAiNnHiJkBjApM_xHqqkZx_
		printSvgHLinePattern(brushFgColorStr, nAtomLen, rtCanvas, 10, 1, rtClip);
		break;
	case 15: // _xZkqqHx_iDhAiDfOiBfLiDjD_xHqqkZx_15 : _xZkqqHx_jGkHiNnHiJkBjApM_xHqqkZx_
		printSvgHLinePattern(brushFgColorStr, nAtomLen, rtCanvas, 5, 1, rtClip);
		break;
	case 16: // _xZkqqHx_iDhAiDfOiBfLiDjD_xHqqkZx_16 : _xZkqqHx_jBgFjBlOiJkBjApM_xHqqkZx_
		printSvgHLinePattern(brushFgColorStr, nAtomLen, rtCanvas, 20, 2, rtClip);
		break;
	case 17: // _xZkqqHx_iDhAiDfOiBfLiDjD_xHqqkZx_17 : _xZkqqHx_jFmAjBlOiJkBjApM_xHqqkZx_
		printSvgHLinePattern(brushFgColorStr, nAtomLen, rtCanvas, 10, 2, rtClip);
		break;
	case 18: // _xZkqqHx_iDhAiDfOiBfLiDjD_xHqqkZx_18 : _xZkqqHx_jGkHjBlOiJkBjApM_xHqqkZx_
		printSvgHLinePattern(brushFgColorStr, nAtomLen, rtCanvas, 5, 2, rtClip);
		break;
	case 19: // _xZkqqHx_iDhAiDfOiBfLiDjD_xHqqkZx_19 : _xZkqqHx_jBgFiNnHiJeFiOmOjApM_xHqqkZx_
		printSvgRDLinePattern(brushFgColorStr, nAtomLen, rtCanvas, 28, 1, rtClip);
		break;
	case 20: // _xZkqqHx_iDhAiDfOiBfLiDjD_xHqqkZx_20 : _xZkqqHx_jFmAiNnHiJeFiOmOjApM_xHqqkZx_
		printSvgRDLinePattern(brushFgColorStr, nAtomLen, rtCanvas, 14, 1, rtClip);
		break;
	case 21: // _xZkqqHx_iDhAiDfOiBfLiDjD_xHqqkZx_21 : _xZkqqHx_jGkHiNnHiJeFiOmOjApM_xHqqkZx_
		printSvgRDLinePattern(brushFgColorStr, nAtomLen, rtCanvas, 7, 1, rtClip);
		break;
	case 22: // _xZkqqHx_iDhAiDfOiBfLiDjD_xHqqkZx_22 : _xZkqqHx_jBgFjBlOiJeFiOmOjApM_xHqqkZx_
		printSvgRDLinePattern(brushFgColorStr, nAtomLen, rtCanvas, 28, 2, rtClip);
		break;
	case 23: // _xZkqqHx_iDhAiDfOiBfLiDjD_xHqqkZx_23 : _xZkqqHx_jFmAjBlOiJeFiOmOjApM_xHqqkZx_
		printSvgRDLinePattern(brushFgColorStr, nAtomLen, rtCanvas, 14, 2, rtClip);
		break;
	case 24: // _xZkqqHx_iDhAiDfOiBfLiDjD_xHqqkZx_24 : _xZkqqHx_jGkHjBlOiJeFiOmOjApM_xHqqkZx_
		printSvgRDLinePattern(brushFgColorStr, nAtomLen, rtCanvas, 7, 2, rtClip);
		break;
	case 25: // _xZkqqHx_iDhAiDfOiBfLiDjD_xHqqkZx_25 : _xZkqqHx_jBgFiNnHiNlGiOmOjApM_xHqqkZx_
		printSvgLDLinePattern(brushFgColorStr, nAtomLen, rtCanvas, 28, 1, rtClip);
		break;
	case 26: // _xZkqqHx_iDhAiDfOiBfLiDjD_xHqqkZx_26 : _xZkqqHx_jFmAiNnHiNlGiOmOjApM_xHqqkZx_
		printSvgLDLinePattern(brushFgColorStr, nAtomLen, rtCanvas, 14, 1, rtClip);
		break;
	case 27: // _xZkqqHx_iDhAiDfOiBfLiDjD_xHqqkZx_27 : _xZkqqHx_jGkHiNnHiNlGiOmOjApM_xHqqkZx_
		printSvgLDLinePattern(brushFgColorStr, nAtomLen, rtCanvas, 7, 1, rtClip);
		break;
	case 28: // _xZkqqHx_iDhAiDfOiBfLiDjD_xHqqkZx_28 : _xZkqqHx_jBgFjBlOiNlGiOmOjApM_xHqqkZx_
		printSvgLDLinePattern(brushFgColorStr, nAtomLen, rtCanvas, 28, 2, rtClip);
		break;
	case 29: // _xZkqqHx_iDhAiDfOiBfLiDjD_xHqqkZx_29 : _xZkqqHx_jFmAjBlOiNlGiOmOjApM_xHqqkZx_
		printSvgLDLinePattern(brushFgColorStr, nAtomLen, rtCanvas, 14, 2, rtClip);
		break;
	case 30: // _xZkqqHx_iDhAiDfOiBfLiDjD_xHqqkZx_30 : _xZkqqHx_jGkHjBlOiNlGiOmOjApM_xHqqkZx_
		printSvgLDLinePattern(brushFgColorStr, nAtomLen, rtCanvas, 7, 2, rtClip);
		break;
	case 31: // _xZkqqHx_iDhAiDfOiBfLiDjD_xHqqkZx_31 : _xZkqqHx_jBgFiNnHiKgJiOhB_xHqqkZx_
		printSvgVHLatticePattern(brushFgColorStr, nAtomLen, rtCanvas, 20, 1, rtClip);
		break;
	case 32: // _xZkqqHx_iDhAiDfOiBfLiDjD_xHqqkZx_32 : _xZkqqHx_jFmAiNnHiKgJiOhB_xHqqkZx_
		printSvgVHLatticePattern(brushFgColorStr, nAtomLen, rtCanvas, 10, 1, rtClip);
		break;
	case 33: // _xZkqqHx_iDhAiDfOiBfLiDjD_xHqqkZx_33 : _xZkqqHx_jGkHiNnHiKgJiOhB_xHqqkZx_
		printSvgVHLatticePattern(brushFgColorStr, nAtomLen, rtCanvas, 5, 1, rtClip);
		break;
	case 34: // _xZkqqHx_iDhAiDfOiBfLiDjD_xHqqkZx_34 : _xZkqqHx_jBgFjBlOiKgJiOhB_xHqqkZx_
		printSvgVHLatticePattern(brushFgColorStr, nAtomLen, rtCanvas, 20, 2, rtClip);
		break;
	case 35: // _xZkqqHx_iDhAiDfOiBfLiDjD_xHqqkZx_35 : _xZkqqHx_jFmAjBlOiKgJiOhB_xHqqkZx_
		printSvgVHLatticePattern(brushFgColorStr, nAtomLen, rtCanvas, 10, 2, rtClip);
		break;
	case 36: // _xZkqqHx_iDhAiDfOiBfLiDjD_xHqqkZx_36 : _xZkqqHx_jGkHjBlOiKgJiOhB_xHqqkZx_
		printSvgVHLatticePattern(brushFgColorStr, nAtomLen, rtCanvas, 5, 2, rtClip);
		break;
	case 37: // _xZkqqHx_iDhAiDfOiBfLiDjD_xHqqkZx_37 : _xZkqqHx_jBgFiNnHiOmOiKgJiOhB_xHqqkZx_
		printSvgDgLatticePattern(brushFgColorStr, nAtomLen, rtCanvas, 28, 1, rtClip);
		break;
	case 38: // _xZkqqHx_iDhAiDfOiBfLiDjD_xHqqkZx_38 : _xZkqqHx_jFmAiNnHiOmOiKgJiOhB_xHqqkZx_
		printSvgDgLatticePattern(brushFgColorStr, nAtomLen, rtCanvas, 14, 1, rtClip);
		break;
	case 39: // _xZkqqHx_iDhAiDfOiBfLiDjD_xHqqkZx_39 : _xZkqqHx_jGkHiNnHiOmOiKgJiOhB_xHqqkZx_
		printSvgDgLatticePattern(brushFgColorStr, nAtomLen, rtCanvas, 7, 1, rtClip);
		break;
	case 40: // _xZkqqHx_iDhAiDfOiBfLiDjD_xHqqkZx_40 : _xZkqqHx_jBgFjBlOiOmOiKgJiOhB_xHqqkZx_
		printSvgDgLatticePattern(brushFgColorStr, nAtomLen, rtCanvas, 28, 2, rtClip);
		break;
	case 41: // _xZkqqHx_iDhAiDfOiBfLiDjD_xHqqkZx_41 : _xZkqqHx_jFmAjBlOiOmOiKgJiOhB_xHqqkZx_
		printSvgDgLatticePattern(brushFgColorStr, nAtomLen, rtCanvas, 14, 2, rtClip);
		break;
	case 42: // _xZkqqHx_iDhAiDfOiBfLiDjD_xHqqkZx_42 : _xZkqqHx_jGkHjBlOiOmOiKgJiOhB_xHqqkZx_
		printSvgDgLatticePattern(brushFgColorStr, nAtomLen, rtCanvas, 7, 2, rtClip);
		break;
	case 43: // _xZkqqHx_iDhAiDfOiBfLiDjD_xHqqkZx_43 : _xZkqqHx_jBgFiNnHiJkBjEgH_xHqqkZx_
		printSvgHWavePattern(brushFgColorStr, nAtomLen, rtCanvas, 20, 8, 1, rtClip);
		break;
	case 44: // _xZkqqHx_iDhAiDfOiBfLiDjD_xHqqkZx_44 : _xZkqqHx_jFmAiNnHiJkBjEgH_xHqqkZx_
		printSvgHWavePattern(brushFgColorStr, nAtomLen, rtCanvas, 10, 8, 1, rtClip);
		break;
	case 45: // _xZkqqHx_iDhAiDfOiBfLiDjD_xHqqkZx_45 : _xZkqqHx_jGkHiNnHiJkBjEgH_xHqqkZx_
		printSvgHWavePattern(brushFgColorStr, nAtomLen, rtCanvas, 5, 8, 1, rtClip);
		break;
	case 46: // _xZkqqHx_iDhAiDfOiBfLiDjD_xHqqkZx_46 : _xZkqqHx_jBgFjBlOiJkBjEgH_xHqqkZx_
		printSvgHWavePattern(brushFgColorStr, nAtomLen, rtCanvas, 20, 8, 2, rtClip);
		break;
	case 47: // _xZkqqHx_iDhAiDfOiBfLiDjD_xHqqkZx_47 : _xZkqqHx_jFmAjBlOiJkBjEgH_xHqqkZx_
		printSvgHWavePattern(brushFgColorStr, nAtomLen, rtCanvas, 10, 8, 2, rtClip);
		break;
	case 48: // _xZkqqHx_iDhAiDfOiBfLiDjD_xHqqkZx_48 : _xZkqqHx_jGkHjBlOiJkBjEgH_xHqqkZx_
		printSvgHWavePattern(brushFgColorStr, nAtomLen, rtCanvas, 5, 8, 2, rtClip);
		break;
	case 49: // _xZkqqHx_iDhAiDfOiBfLiDjD_xHqqkZx_49 : _xZkqqHx_jBgFiNnHiPgDjEgH_xHqqkZx_
		printSvgVWavePattern(brushFgColorStr, nAtomLen, rtCanvas, 20, 8, 1, rtClip);
		break;
	case 50: // _xZkqqHx_iDhAiDfOiBfLiDjD_xHqqkZx_50 : _xZkqqHx_jFmAiNnHiPgDjEgH_xHqqkZx_
		printSvgVWavePattern(brushFgColorStr, nAtomLen, rtCanvas, 10, 8, 1, rtClip);
		break;
	case 51: // _xZkqqHx_iDhAiDfOiBfLiDjD_xHqqkZx_51 : _xZkqqHx_jGkHiNnHiPgDjEgH_xHqqkZx_
		printSvgVWavePattern(brushFgColorStr, nAtomLen, rtCanvas, 5, 8, 1, rtClip);
		break;
	case 52: // _xZkqqHx_iDhAiDfOiBfLiDjD_xHqqkZx_52 : _xZkqqHx_jBgFjBlOiPgDjEgH_xHqqkZx_
		printSvgVWavePattern(brushFgColorStr, nAtomLen, rtCanvas, 20, 8, 2, rtClip);
		break;
	case 53: // _xZkqqHx_iDhAiDfOiBfLiDjD_xHqqkZx_53 : _xZkqqHx_jFmAjBlOiPgDjEgH_xHqqkZx_
		printSvgVWavePattern(brushFgColorStr, nAtomLen, rtCanvas, 10, 8, 2, rtClip);
		break;
	case 54: // _xZkqqHx_iDhAiDfOiBfLiDjD_xHqqkZx_54 : _xZkqqHx_jGkHjBlOiPgDjEgH_xHqqkZx_
		printSvgVWavePattern(brushFgColorStr, nAtomLen, rtCanvas, 5, 8, 2, rtClip);
		break;
	default:
		printSvgPinholePattern( brushFgColorStr, nAtomLen, rtCanvas, 6, 3, rtClip);
	} // switch

	_clipNo++;

	return SVGEXPORT_OK;

} // end of SvgExportInfo::printClippedBrushPattern




// style_xZkqqHx_jFlGiOjKjHpBiCpAiPgPjHmNiClHiCoJ_xHqqkZx_
void SvgExportInfo::printStyle( bool isArrowStyle = false )
{
	// _xZkqqHx_iDhJiDjDjAeGjFlGiOjKjHpBiCpAjDlOiCoJ_xHqqkZx_
	char penBgRgbStr[SVG_RGBSTR_MAXLEN+1];
	char *penBgColorStr = getExportSvgColorStr( _penBgColor, penBgRgbStr );

	double strokeWidth = SvgUnit( _penWidth );

	// _xZkqqHx_jDgIiCoIiCmCiCnEiClFjAeGjFlGiOjKjHpBiCpAjDlOiCoJ_xHqqkZx_
	char *fillColorStr, brushBgRgbStr[SVG_RGBSTR_MAXLEN+1];
// 06.07.04 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	if ( SVG_NO_BRUSHPATTERN == _brushPattern && _objectExp->IsFillPainted() ) {
	if ( SVG_NO_BRUSHPATTERN == _brushPattern && _isFillPainted ) {
		fillColorStr = getExportSvgColorStr( _brushBgColor, brushBgRgbStr );
	} else {
		fillColorStr = "none";
	}

//----- 06.07.04 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_jApMjFkKiDfPiDgCiDfGiDiFjFlGiOjKjHpBiCpAjDlOiCoJ_xHqqkZx_
//	char dashStr[256];
//	getExportDashStr( dashStr );
//
//	// _xZkqqHx_iJgFiPiIjHjNjFlGiOjKjHpBiCpAjDlOiCoJ_xHqqkZx_
//	char shadowStr[256];
//----- 06.07.04 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	if ( FD_S_COLOR_TRANSPARENT != _objectExp->GetShadowSColor() ) {
//		sprintf( shadowStr, "; filter:url(#dd_shadow_%d)", _shadowNo++ );
//	} else {
//		shadowStr[0] = '\0';
//	}
//----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	if (!isArrowStyle)
	//----- _xZkqqHx_jGoOiIpDiDfIiDfOiDeDiDiLiImIiKePiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jApMjFkKiDfPiDgCiDfGiDiFjFlGiOjKjHpBiCpAjDlOiCoJ_xHqqkZx_
		char dashStr[256];
		getExportDashStr( dashStr );
		// _xZkqqHx_iJgFiPiIjHjNjFlGiOjKjHpBiCpAjDlOiCoJ_xHqqkZx_
		char shadowStr[256];

		SColorID shadowColor = FD_S_COLOR_TRANSPARENT;
		if (_objectExp->IsKindOf(FDOJ_FIGURE))
			shadowColor = ((const FCObjFigure*)_objectExp)->GetShadowSColor();
		if ( FD_S_COLOR_TRANSPARENT != shadowColor )
		{
			sprintf( shadowStr, "; filter:url(#dd_shadow_%d)", _shadowNo++ );
		} else
		{
			shadowStr[0] = '\0';
		}
		fprintf(_fptr, "style='fill:%s; stroke:%s; stroke-width:%f%s%s'",
				fillColorStr, penBgColorStr, SvgUnit( strokeWidth ), dashStr, shadowStr);
	} else
	//----- _xZkqqHx_jGoOiIpDiDfIiDfOiDeDiDiLiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jGoOiIpDiCmMiDfIiDfOiDeDiDiLiPgPjHmNiOjO_xHqqkZx_
		fprintf(_fptr, "style='fill:%s; stroke:%s; stroke-width:%f'", 
				penBgColorStr, penBgColorStr, 0.0 );
	}
//----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

//----- 06.07.04 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	if (isArrowStyle)
//	{
//		// _xZkqqHx_jGoOiIpDiCmMiDfIiDfOiDeDiDiLiPgPjHmNiOjO_xHqqkZx_
//		fprintf(_fptr, "style='fill:%s; stroke:%s; stroke-width:%f'", 
//				penBgColorStr, penBgColorStr, 0.0 );
//	} else
//	{
//		fprintf(_fptr, "style='fill:%s; stroke:%s; stroke-width:%f%s%s'",
//				fillColorStr, penBgColorStr, SvgUnit( strokeWidth ), dashStr, shadowStr);
//	}
//----- 06.07.04 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

} // end of printStyle



//----- 06.06.29 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CalcTextRect
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiDgFiDeMiDfIiDgHiDeJiDhFiDfHiDeGiDeOiDgHiCmJiKnMiCnMiCoKiCoJiDgFiDeMiDfIiDgHiCmJiKePjAnKiClHiCoJ_xHqqkZx_
// *			_xZkqqHx_iNmFiPkMiCmMiLoJiMgAiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pRich	:_xZkqqHx_iDgFiDeMiDfIiDgHiDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iLoJiMgAiCpAjFnEiClHiBeCiDgFiDeMiDfIiDgHiCkKiDeJiDhFiDfHiDeGiDeOiDgHiCpAiIoMiCoKiCmEiCkCiCoJiPoKiNiHiCmNiBeB_xHqqkZx_
// *			_xZkqqHx_iDgFiDeMiDfIiDgHiDeJiDhFiDfHiDeGiDeOiDgHiCmMiLoJiMgAiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.10.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//static DBLRect CalcTextRect (FCRichText* pRich)
//{
//	mmetol mmMostRight = pRich->GetTextRect().left;
//
//	mmetol	mmX;
//	mmetol	mmBaseLine;
//	BYTE	byCrossStat = BYTE(-1);	// _xZkqqHx_jFlGiOjKiIoMiCoKiPpDjBnEiBeC_xHqqkZx_
//	short	nAfterSpace = short(MINSHORT);
//	mmetol mmMostBottom = -MINSHORT;
//
//	long	lLine;
//	long	lChar;
//	const FCStatChar* pChar;
//	for (pChar = pRich->CharFirst(lLine, lChar, mmX, nAfterSpace, mmBaseLine);
//		 pChar != NULL;
//		 pChar = pRich->CharNext(lLine, lChar, mmX, nAfterSpace, mmBaseLine))
//	{
//		switch (pChar->m_wChar)
//		{
//		case FDRCH_RETURN:		// _xZkqqHx_iJpMiNhDiLeMiNiGiBeC_xHqqkZx_
//		case FDRCH_CONTINUE:	// _xZkqqHx_iMhAjBlBiNhDiLeMiNiGiBeC_xHqqkZx_
//			break;
//		case FDRCH_FONT_AND_OFFSET:		// FONT,Offset_xZkqqHx_jAnNjCoI_xHqqkZx_.
//			break;
//		case FDRCH_COLORREF:			// COLORREF_xZkqqHx_jAnNjCoI_xHqqkZx_.
//			break;
//		case FDRCH_AFTERSPACE:		// AfterSpace_xZkqqHx_jAnNjCoI_xHqqkZx_.
//			break;
//		case FDRCH_LINES_AND_CROSSSTAT:	// _xZkqqHx_iOoGiPmBiClFjApMiBeBiJlKjApMiBeBjFlGiOjKiIoMiCoKiPpDjBnEiBeC_xHqqkZx_
//			byCrossStat = pChar->m_byCrossStat;
//			break;
//		case FDRCH_PRESPACE:	// _xZkqqHx_jFlGiOjKjBePjHfNjEjC_xHqqkZx_.
//			break;
//		case L'\t':	// _xZkqqHx_iDfOiDhF_xHqqkZx_.
//			break;
//		default:	// WCH_SPC, _xZkqqHx_jCmKiPoNjFlGiOjKiBeC_xHqqkZx_
//		  {
//			// _xZkqqHx_iClBiCoKiImIiPoDiJeFjBkEiCmJiPjBiCkNiInDjGkBiCmNiCmIiCkCiBeC_xHqqkZx_
//			if (byCrossStat == FDWR_CROSS_OUTSIDE) break;
//			// _xZkqqHx_jFlGiOjKiImKjChFiBeCiNmFiCoAiJeFiCmJiCkAiCoJjFlGiOjKiCmMiImKjChFiCpAiLeMjIfOiClFiCnMiClHiBeC_xHqqkZx_
//			mmetol mmRight = mmX + pChar->m_mmfWidth - pChar->m_mmfAbcC;
//			if (mmMostRight < mmRight) mmMostRight = mmRight;
//			// _xZkqqHx_iNhDiCmMiJlKiImKjChF_xHqqkZx_
//			FCStatLine statLine = (pRich->GetTextData())[lLine];
//			mmetol mmBottom =
//					pRich->GetTextRect().top +
//					statLine.m_mmY +
//					statLine.m_mmfTMHeight +
//					statLine.m_mmfTMExternalLeading +
//					pRich->GetMarginB();
//			if ( mmMostBottom < mmBottom ) mmMostBottom = mmBottom;
//		  }
//		}
//	}
//	mmMostRight += pRich->GetMarginR();
//
//	// _xZkqqHx_iDgFiDeMiDfIiDgHiDeJiDhFiDfHiDeGiDeOiDgHiCmMiDfEiDeDiDfJiCpAiJhKiCkGiCmIiCkCiCoGiCkEiCmJjClCjAkOiBeC_xHqqkZx_
//	if (pRich->GetTextRect().right < mmMostRight)
//		mmMostBottom = pRich->GetTextRect().right;
//	if (pRich->GetTextRect().bottom < mmMostBottom)
//		mmMostBottom = pRich->GetTextRect().bottom;
//
//	return DBLRect(pRich->GetTextRect().left, pRich->GetTextRect().top,
//					mmMostRight, mmMostBottom);
//} // CalcTextRect.
//----- 06.06.29 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----


void SvgExportInfo::printTransform( bool isTextAngle ) {

//----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	double cx = _objectExp->GetCenterX();
//	double cy = _objectExp->GetCenterY();
//----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	double cx = 0.0;
	double cy = 0.0;
	if (_objectExp->IsKindOf(FDOJ_RECT))
	{
		cx = ((const FCObjRect*)_objectExp)->GetCenterX();
		cy = ((const FCObjRect*)_objectExp)->GetCenterY();
	}
//----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

	// _xZkqqHx_iJpBjDfNjHmKiCpAjDlOiCoJ_xHqqkZx_
	double angle = 0.0;
	if ( isTextAngle ) {
		const FCRichText *pRich = _objectExp->GetRichText();
		if ( NULL != pRich ) {
			angle = pRich->GetAngle();
			DBLRect	outRect = _objectExp->GetOuterFrame();
			cx = ( outRect.left + outRect.right ) / 2;
			cy = ( outRect.top + outRect.bottom ) / 2;
		}
	} else {
		angle = _objectExp->GetAngle();
	}
	char rotateStr[512];
	if ( 0.0 != angle ) {
		char *formatStr = getFormatString( "translate(%n,%n) rotate(%n) translate(-%n,-%n)" );
		sprintf( rotateStr, formatStr, SvgOffsetX( cx ), SvgOffsetY( cy ), RADRATE2DEG(angle), SvgOffsetX( cx ), SvgOffsetY( cy ) );
	} else {
		rotateStr[0] = '\0';
	}

	// _xZkqqHx_iDfIiDeMiDiFiBfL_xHqqkZx_X_xZkqqHx_iCpAjDlOiCoJ_xHqqkZx_
//----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	fmmetol aVAxisX = _objectExp->GetVAxisX();
//	fmmetol aVAxisY = _objectExp->GetVAxisY();
//----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	mmetol aVAxisX = 0.0;
	mmetol aVAxisY = 0.0;
	if (_objectExp->IsKindOf(FDOJ_RECT))
	{
		aVAxisX = ((const FCObjRect*)_objectExp)->GetVAxisX();
		aVAxisY = ((const FCObjRect*)_objectExp)->GetVAxisY();
	}
//----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	double skewX;
	char skewXStr[512];
	if ( 0.0 != aVAxisY && 0.0 != aVAxisX ) {
		skewX = atan( aVAxisX / aVAxisY );
		char *formatStr = getFormatString( " translate(%n,%n) skewX(%n) translate(-%n,-%n)" );
		sprintf( skewXStr, formatStr, SvgOffsetX( cx ), SvgOffsetY( cy ), RAD2DEG(skewX), SvgOffsetX( cx ), SvgOffsetY( cy ) );
	} else {
		skewXStr[0] = '\0';
	}

	if ( '\0' != rotateStr[0] || '\0' != skewXStr[0] ) {
		fprintf( _fptr, " transform='%s%s'", rotateStr, skewXStr );
	}

} // end of SvgExportInfo::printTransform()



#define	BYTE_MASK			0xbf
#define	THREE_OCTET_BASE	0xe0
#define	TWO_OCTET_BASE		0xc0

// utf8 : 4byte_xZkqqHx_iCmNiKgNjFnLiClFiCmEiCkIiCkNiBeC_xHqqkZx_
static int ucs2ToUtf8( unsigned short ucs2, char *utf8 ) {

    if (ucs2 < 0x80) {
	    // 1 Byte Character
		*utf8 = (unsigned char)ucs2;
		*(utf8 + 1) = '\0';
		return 1;
    } else if (ucs2 < 0x800) {
		// 2 Byte Character
		*(utf8 + 1) = (ucs2 | 0x80) & BYTE_MASK;
		ucs2 >>= 6;
		*utf8 = ucs2 | TWO_OCTET_BASE;
		*(utf8 + 2) = '\0';
		return 2;
    } else {
		// 3 Byte Character
		*(utf8 + 2) = (ucs2 | 0x80) & BYTE_MASK;
		ucs2 >>= 6;
		*(utf8 + 1) = (ucs2 | 0x80) & BYTE_MASK;
		ucs2 >>= 6;
		*utf8 = ucs2 | THREE_OCTET_BASE;
		*(utf8 + 3) = '\0';
		return 3;
    }

} // ucs2ToUtf8



static void ucs2StrToUtf8( wchar_t  *ucs2, char *utf8 ) {

	int ucs2pos = 0;
	int utf8pos = 0;
	
	for ( ucs2pos = 0; ucs2pos < LF_FACESIZE; ucs2pos++ ) {
		utf8pos += ucs2ToUtf8( ucs2[ucs2pos], utf8 + utf8pos );
	}

	utf8[utf8pos] = '\0';

} // ucs2StrToUtf8





#define MAX_FONT_STYLE_STR_LEN	256
#define POS_MAX_STR_LEN	32

// _xZkqqHx_iDgFiDeMiDfIiDgHiPiIjHjNiIpIjAjEjDgOiClFjHhAiNfMjBkCjBmM_xHqqkZx_
struct PrintTextInfo {
public :
	const FCStatChar *pChar;

	mmetol mmBaseLineCurrent; // _xZkqqHx_jClMjBePiCmMjFlGiOjKiCnMiCmFiCmMiDhIiBfLiDfIiDiJiDeDiDjDiImKjChF_xHqqkZx_
	mmetol mmBaseLine; // _xZkqqHx_iMlLiNnNiCmMjFlGiOjKiCmMiDhIiBfLiDfIiDiJiDeDiDjDiImKjChF_xHqqkZx_

	mmetol mmLeft;

	mmetol baseLineOffset; // _xZkqqHx_iPoDiBfOjCiGiBfOiJlKjFhEiCkLjFlGiOjKjHhAiDhIiBfLiDfIiDiJiDeDiDjDiDeJiDhEiDfKiDgCiDgH_xHqqkZx_
	double fontSizeRate; // _xZkqqHx_iPoDiBfOjCiGiBfOiJlKjFhEiCkLjFlGiOjKjHhAiDhEiDeIiDjDiDgHiDfEiDeDiDfJiPgLiPkMiKiEiNiH_xHqqkZx_(0.5 or 1.0)

	double rotateXOffset; // @_xZkqqHx_iDhEiDeIiDjDiDgHiCmMiJpBjDfNjHhA_xHqqkZx_
	double rotateYOffset; // @_xZkqqHx_iDhEiDeIiDjDiDgHiCmMiJpBjDfNjHhA_xHqqkZx_

	bool isHanAlphaNum; // _xZkqqHx_iMlLiNnNiBeBjElMiKhAiJhAjAjEiOjKiCpAiPgPjHmNjCiGiCkJiCmHiCkEiCkJiCmMiDhEiDiJiDePiBeC_xHqqkZx_
	                 // @_xZkqqHx_iDhEiDeIiDjDiDgHiCmFiCoAjElMiKhAiJhAjAjEiOjKiClOiCkPiCmNiJpBjDfNiClDiClJiCmIiCkCiCoGiCkEiCmJ_xHqqkZx_
					 // _xZkqqHx_iPgPjHmNiClFiCmEiCkCiCoJiCoGiCkEiCmIiCmMiCmFiBeC_xHqqkZx_

	int tspanNum; // <tspan>_xZkqqHx_iDfOiDePiCmMiPgPiMlLiJpBjAjE_xHqqkZx_

	string textString; // _xZkqqHx_iPgPjHmNiClHiCoJjFlGiOjKjHpB_xHqqkZx_
	string tspanXStr; // tspan_xZkqqHx_iCmM_xHqqkZx_x_xZkqqHx_iImKjChFjFlGiOjKjHpB_xHqqkZx_
	int tspanXStrNum; // tspan_xZkqqHx_iCmM_xHqqkZx_x_xZkqqHx_iImKjChFjFlGiOjKjHpBiCmMiMmCjAjE_xHqqkZx_
	char *text_decoration_str; // text-decoration_xZkqqHx_jBkOjAkL_xHqqkZx_(_xZkqqHx_iJlKjApMiCmIiCmH_xHqqkZx_)_xZkqqHx_iCmMjFlGiOjKjHpB_xHqqkZx_

public :
	PrintTextInfo() : pChar(NULL), mmBaseLineCurrent(DBL_MIN), mmBaseLine(DBL_MIN),
		mmLeft(DBL_MIN), baseLineOffset(0.0), fontSizeRate(1.0), rotateXOffset(0.0),
		rotateYOffset(0.0), isHanAlphaNum(true), tspanNum(0), tspanXStrNum(0), text_decoration_str(NULL) {}
};

// _xZkqqHx_iMlLiNnNiCnMiCmFiCmMjFlGiOjKjHpBiCkKiCkAiCoKiCmOiPgPjHmNiClHiCoJ_xHqqkZx_
int SvgExportInfo::printTextBufferedChar( PrintTextInfo *printTextInfo ) {

	if ( false == printTextInfo->textString.empty() ) {
		// _xZkqqHx_iNmFiPiJiCmMiNhDiCmFiCmNiCmIiCkCiCmMiCmFiBeBiMlLiNnNiCnMiCmFiCmMiDgFiDeMiDfIiDgHiBeBiImKjChFiCpAiPgPjHmN_xHqqkZx_
		double rotateYOffset = printTextInfo->rotateYOffset;
		if ( printTextInfo->isHanAlphaNum ) {
			// _xZkqqHx_jElMiKhAiJhAjAjEiOjKiBgJiCmMiJpBjDfNiDhEiDeIiDjDiDgHiBgKiCmMiOjOiCmNiBeBiJpBjDfNiClDiClJiCmIiCkC_xHqqkZx_
			rotateYOffset = 0.0;
		}
		char *formatStr = getFormatString( "<tspan x='%s' y='%n'" );
		string::size_type pos = printTextInfo->tspanXStr.rfind( ' ' );
		if ( string::npos != pos ) {
			printTextInfo->tspanXStr.erase( pos );
		}
		string xPosStr( printTextInfo->tspanXStr);
		if ( false == svgExportOption._textPosEach ) {
			// _xZkqqHx_jAoGjDkKjFlGiOjKjHpBiImKjChFiCmMiCnNiCmJiClHiCoJ_xHqqkZx_
			string::size_type pos = xPosStr.find( ' ' );
			if ( string::npos != pos ) {
				xPosStr.erase( pos );
			}
		}
		fprintf( _fptr, formatStr, 
			xPosStr.c_str(), 
			SvgUnitOffsetY( printTextInfo->mmBaseLineCurrent + printTextInfo->baseLineOffset )
				+ rotateYOffset );
		if ( printTextInfo->text_decoration_str ) {
			fprintf( _fptr, " style='%s'", printTextInfo->text_decoration_str );
		}
		if ( false == printTextInfo->isHanAlphaNum && 
			0.0 != printTextInfo->rotateXOffset ) {
			//fprintf( _fptr, " writing-mode='tb'" );
			fprintf( _fptr, " rotate='-90" );
			for ( int i = 1; i < printTextInfo->tspanXStrNum; i++ ) {
				fprintf( _fptr, " -90" );
			}
			fprintf( _fptr, "'" );
		}
		fprintf( _fptr, ">%s</tspan>", printTextInfo->textString.c_str() );
		printTextInfo->tspanXStr.erase(); printTextInfo->textString.erase();
		printTextInfo->tspanXStrNum = 0;
	} // if empty

	return SVGEXPORT_OK;

} // end of SvgExportInfo::printTextBufferedChar

// _xZkqqHx_iDhEiDeIiDjDiDgHjAeGjFmPiNfI_xHqqkZx_
int SvgExportInfo::printTextChangeColor( PrintTextInfo *printTextInfo ) {
	
	// S_xZkqqHx_jAeG_xHqqkZx_ID
	COLORREF crefCur = RGB2RGBA( printTextInfo->pChar->m_crColor );

	// _xZkqqHx_jDgIiCoIiCmCiCnEiClFjAeGjFlGiOjKjHpBiCpAjDlOiCoJ_xHqqkZx_
	char *fillColorStr, fontColorRgbStr[SVG_RGBSTR_MAXLEN+1];
	fillColorStr = getExportSvgColorStr( crefCur, fontColorRgbStr );

	// _xZkqqHx_iMlLiNnNiCnMiCmFiCmMjFlGiOjKjHpBiCkKiCkAiCoKiCmOiPgPjHmNiClHiCoJ_xHqqkZx_
	int result = printTextBufferedChar( printTextInfo );
	SE_RESULT_CHECK( result );

	fprintf( _fptr, "<tspan style='fill:%s'>", fillColorStr );
	printTextInfo->tspanNum++;

	return SVGEXPORT_OK;

} // end of SvgExportInfo::printTextChangeColor



void getFontFaceStr( wchar_t *fontFaceNameUcs2, char *fontFaceStrUtf8 ) {

//	if ( strlen( fontFaceStrUtf8 ) ) {
//		strcat( fontFaceStrUtf8, "," );
//	}
	strcat( fontFaceStrUtf8, "\"" );

	if ( L'@' == fontFaceNameUcs2[0] ) {
		ucs2StrToUtf8( fontFaceNameUcs2 + 1, fontFaceStrUtf8 + 1);
	} else {
		ucs2StrToUtf8( fontFaceNameUcs2, fontFaceStrUtf8 + 1);
	}

	strcat( fontFaceStrUtf8, "\"" );

} // end of getFontFaceStr


// FCStatChar_xZkqqHx_iCmMiPoDjFhEiCkL_xHqqkZx_Offset_xZkqqHx_jCgM_xHqqkZx_
#define UWATSUKI_OFFSET	16384 

// FCStatChar_xZkqqHx_iCmMjCiGjFhEiCkL_xHqqkZx_Offset_xZkqqHx_jCgM_xHqqkZx_
#define NAKATSUKI_OFFSET	32768

// FCStatChar_xZkqqHx_iCmMiJlKjFhEiCkL_xHqqkZx_Offset_xZkqqHx_jCgM_xHqqkZx_
#define SHITATSUKI_OFFSET	49152


// _xZkqqHx_iDhEiDeIiDjDiDgHjFmPiNfIiPiIjHjN_xHqqkZx_
int SvgExportInfo::printTextChangeFont( PrintTextInfo *printTextInfo ) {

	// _xZkqqHx_iMlLiNnNiCnMiCmFiCmMjFlGiOjKjHpBiCkKiCkAiCoKiCmOiPgPjHmNiClHiCoJ_xHqqkZx_
	int result = printTextBufferedChar( printTextInfo );
	SE_RESULT_CHECK( result );

	// _xZkqqHx_iDhEiDeIiDjDiDgH_xHqqkZx_ID
	SFontID foidCur = printTextInfo->pChar->m_foidFont;

	const FCSFontRec *pFontRec = FFGetMolipBaseI()->GetEnv()->GetSFontRec(foidCur);
// 06.07.01 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	double fontSize = pFontRec->m_mmAscent + pFontRec->m_mmDescent;
	double fontSize = pFontRec->m_mmFontHeight;

	// _xZkqqHx_iDeJiDhEiDfKiDgCiDgHjAnNjCoIiBeC_xHqqkZx_
	switch ( printTextInfo->pChar->m_wOffset ) {
	case UWATSUKI_OFFSET: // _xZkqqHx_iPoDjFhEiCkL_xHqqkZx_
		printTextInfo->baseLineOffset = -fontSize / 3;
		printTextInfo->fontSizeRate = 2.0/3;
		break;
	case NAKATSUKI_OFFSET : // _xZkqqHx_jCiGjFhEiCkL_xHqqkZx_
		printTextInfo->baseLineOffset = -fontSize / 6;
		printTextInfo->fontSizeRate = 2.0/3;
		break;
	case SHITATSUKI_OFFSET : // _xZkqqHx_iJlKjFhEiCkL_xHqqkZx_
		printTextInfo->baseLineOffset = 0.0;
		printTextInfo->fontSizeRate = 2.0/3;
		break;
	default :
		printTextInfo->baseLineOffset = 0.0;
		printTextInfo->fontSizeRate = 1.0;
		break;
	} // switch wOffset

	char *formatStr = getFormatString( "<tspan style='font-size:%n" );
	fprintf( _fptr, formatStr, SvgUnit( fontSize * printTextInfo->fontSizeRate ) );

	// _xZkqqHx_iDhEiDeIiDjDiDgHiDhEiDeAiDhOiDiKiBfLjGlMiCmMiPgPjHmN_xHqqkZx_
	char fontFaceStr[512];
	fontFaceStr[0] = '\0';
	getFontFaceStr( (wchar_t*)pFontRec->m_szFaceName, fontFaceStr );
	if ( fontFaceStr[0] ) {
		fprintf( _fptr, ";font-family:%s", fontFaceStr );
	}

	// _xZkqqHx_iJpBjDfNiDhEiDeIiDjDiDgH_xHqqkZx_
	if ( '@' == (wchar_t)pFontRec->m_szFaceName[0] ) {
		printTextInfo->rotateXOffset = pFontRec->m_mmAscent * printTextInfo->fontSizeRate;
		printTextInfo->rotateYOffset = pFontRec->m_mmDescent * printTextInfo->fontSizeRate;
	} else {
		printTextInfo->rotateXOffset = 0.0;
		printTextInfo->rotateYOffset = 0.0;
	}

	// italic_xZkqqHx_iCmMiPgPjHmN_xHqqkZx_
	if ( pFontRec->m_byItalic ) {
		fprintf( _fptr, ";font-style:italic" );
	}

	// bold_xZkqqHx_iCmMiPgPjHmN_xHqqkZx_
	if ( pFontRec->m_wWeight ) {
		fprintf( _fptr, ";font-weight:%d", (int)SvgUnit( pFontRec->m_wWeight ) );
	}

	fprintf( _fptr, "'>" );
	
	printTextInfo->tspanNum++;

	return SVGEXPORT_OK;

} // end of SvgExportInfo::printTextChangeFont



// _xZkqqHx_iOoGiPmBiClFjApMiBeBiJlKjApMiBeBjFlGiOjKiIoMiCoKiPpDjBnEiPiIjHjN_xHqqkZx_
int SvgExportInfo::printTextChangeLineCrossstat( PrintTextInfo *printTextInfo ) {

	int result;

	if ( printTextInfo->pChar->m_byUnderline ) {
		// _xZkqqHx_iMlLiNnNiCnMiCmFiCmMjFlGiOjKjHpBiCkKiCkAiCoKiCmOiPgPjHmNiClHiCoJ_xHqqkZx_
		result = printTextBufferedChar( printTextInfo );
		SE_RESULT_CHECK( result );
		// _xZkqqHx_iJlKjApMiCpA_xHqqkZx_decoration_xZkqqHx_jFlGiOjKjHpBiCmJjAnNjCoI_xHqqkZx_
		printTextInfo->text_decoration_str = "text-decoration:underline";
	} else if ( printTextInfo->pChar->m_byStrikeOut ) {
		// _xZkqqHx_iMlLiNnNiCnMiCmFiCmMjFlGiOjKjHpBiCkKiCkAiCoKiCmOiPgPjHmNiClHiCoJ_xHqqkZx_
		result = printTextBufferedChar( printTextInfo );
		SE_RESULT_CHECK( result );
		// _xZkqqHx_iOoGiCoIiPmBiClFjApMiCpA_xHqqkZx_decoration_xZkqqHx_jFlGiOjKjHpBiCmJjAnNjCoI_xHqqkZx_
		printTextInfo->text_decoration_str = "text-decoration:line-through";
	} else if ( printTextInfo->pChar->m_byCrossStat ) {
		// ?
	} else {
		// _xZkqqHx_iMlLiNnNiCnMiCmFiCmMjFlGiOjKjHpBiCkKiCkAiCoKiCmOiPgPjHmNiClHiCoJ_xHqqkZx_
		result = printTextBufferedChar( printTextInfo );
		SE_RESULT_CHECK( result );
		// decoration_xZkqqHx_iOoGiCoIiPmBiClF_xHqqkZx_
		printTextInfo->text_decoration_str = NULL;
	}

	return SVGEXPORT_OK;

} // end of SvgExportInfo::printTextChangeLineCrossstat



// _xZkqqHx_iDeHiDjDiDgFiDeCiDgFiDeCiOfBiPmGjFlGiOjKiCmIiCoHjChFiKlHiClHiCoJ_xHqqkZx_
static void replaceEntityRef( char *utf8 ) {

	switch ( utf8[0] ) {
	case '<' :
		strcpy( utf8, "&lt;" );
		break;
	case '>' :
		strcpy( utf8, "&gt;" );
		break;
	case '&' :
		strcpy( utf8, "&amp;" );
		break;
	case '\'' :
		strcpy( utf8, "&apos;" );
		break;
	case '\"' :
		strcpy( utf8, "&quot;" );
	default :
		break;
	} // switch

} // end of replaceEntityRef



// _xZkqqHx_jFlGiOjKiPgPjHmNiPiIjHjN_xHqqkZx_
int SvgExportInfo::printTextChar( PrintTextInfo *printTextInfo ) {

	char utf8[8]; // replaceEntityRef_xZkqqHx_iCoAiMkJiNjOiCpBiCmF_xHqqkZx_
	ucs2ToUtf8( printTextInfo->pChar->m_wChar, utf8 );

	bool changeBaseLine = ( printTextInfo->mmBaseLineCurrent != printTextInfo->mmBaseLine );

	// _xZkqqHx_jBfDjElMiKhAiCkKjDpMiCoKjBnGiCoNiCmBiClNiCkJiCmHiCkEiCkJ_xHqqkZx_
	bool changeHanAlphaNum = false;
	if ( utf8[0] & 0x80 ) {
		// _xZkqqHx_jBfDiKhAiCpAjDmHiCnNiNjOiCpBiClO_xHqqkZx_
		if ( printTextInfo->isHanAlphaNum ) {
			changeHanAlphaNum = true;
		}
	} else {
		// _xZkqqHx_jElMiKhAiCpAjDmHiCnNiNjOiCpBiClO_xHqqkZx_
		if ( false == printTextInfo->isHanAlphaNum ) {
			changeHanAlphaNum = true;
		}
	}

	if ( changeBaseLine || changeHanAlphaNum ) {
		// _xZkqqHx_iDhIiBfLiDfIiDiJiDeDiDjDiCkKjFmPiCoNiCmBiClNiCkJiBeBjBfDjElMiKhAiCkKjDpMiCoKjBnGiCoNiCmBiClN_xHqqkZx_

		// _xZkqqHx_iMlLiNnNiCnMiCmFiCmMjFlGiOjKjHpBiCkKiCkAiCoKiCmOiPgPjHmNiClHiCoJ_xHqqkZx_
		int result = printTextBufferedChar( printTextInfo );
		SE_RESULT_CHECK( result );
		// _xZkqqHx_iDhIiBfLiDfIiDiJiDeDiDjDiCpAiNfIjAfG_xHqqkZx_
		printTextInfo->mmBaseLineCurrent = printTextInfo->mmBaseLine;
	}

	if ( utf8[0] & 0x80 ) {
		// _xZkqqHx_jBfDiKhAiCpAjDmHiCnNiNjOiCpBiClO_xHqqkZx_
		printTextInfo->isHanAlphaNum = false;
	} else {
		// _xZkqqHx_jElMiKhAiCpAjDmHiCnNiNjOiCpBiClO_xHqqkZx_
		printTextInfo->isHanAlphaNum = true;
		// _xZkqqHx_iDeHiDjDiDgFiDeCiDgFiDeCiOfBiPmGjFlGiOjKiCmIiCoHjChFiKlH_xHqqkZx_
		replaceEntityRef( utf8 );
	}

	char xStr[POS_MAX_STR_LEN];
	double rotateXOffset = printTextInfo->rotateXOffset;
	if ( printTextInfo->isHanAlphaNum ) {
		// _xZkqqHx_jElMiKhAiJhAjAjEiOjKiBgJiCmMiJpBjDfNiDhEiDeIiDjDiDgHiBgKiCmMiOjOiCmNiBeBiJpBjDfNiClDiClJiCmIiCkC_xHqqkZx_
		rotateXOffset = 0.0;
	}
	char *formatStr = getFormatString( "%n " );
	sprintf( xStr, formatStr, SvgUnitOffsetX( printTextInfo->mmLeft + rotateXOffset ) );

	printTextInfo->tspanXStr.append( xStr );
	printTextInfo->textString.append( utf8 ); // _xZkqqHx_iPgPjHmNiClHiCoJjFlGiOjKjHpBiCpAjCmHiJmB_xHqqkZx_
	printTextInfo->tspanXStrNum++;
				
	return SVGEXPORT_OK;

} // end of printTextChar




int SvgExportInfo::printText()
{
//----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	FCRichText *pRich = _objectExp->GetRichText();
//----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	if (!_objectExp->IsKindOf(FDOJ_FIGURE))
		ThrowSvgSystemError();
	FCRichText *pRich = ((FCObjFigure*)_objectExp)->GetRichText();
//----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

	if ( pRich->GetTextRect().Height() - pRich->GetMarginB() <
		pRich->GetTextData().front().m_mmY +
		pRich->GetTextData().front().m_mmfTMHeight +
		pRich->GetTextData().front().m_mmfTMExternalLeading) {
		return SVGEXPORT_OK;
	}

	mmetol	mmX;
	BYTE		byCrossStat = BYTE(-1);	// _xZkqqHx_jFlGiOjKiIoMiCoKiPpDjBnEiBeC_xHqqkZx_
	short		nAfterSpace = short(MINSHORT);

	PrintTextInfo printTextInfo;

	int result;
	const FCStatChar* pChar;
	long	lLine;
	long	lChar;

	//fprintf( _fptr, "<text>" );
	pChar = pRich->CharFirst(lLine, lChar, mmX, nAfterSpace, printTextInfo.mmBaseLine);
	// _xZkqqHx_iDhEiDeIiDjDiDgH_xHqqkZx_ID
	SFontID foidCur = pChar->m_foidFont;
	const FCSFontRec *pFontRec = FFGetMolipBaseI()->GetEnv()->GetSFontRec(foidCur);
// 06.07.01 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	double fontSize = pFontRec->m_mmAscent + pFontRec->m_mmDescent;
	double fontSize = pFontRec->m_mmFontHeight;
	char *formatStr = getFormatString( "<text style='font-size:%n'>" );
	fprintf( _fptr, formatStr, SvgUnit( fontSize ) );

	//long	lLine;
	//long	lChar;
	//const FCStatChar* pChar;
	for ( pChar = pRich->CharFirst(lLine, lChar, mmX, nAfterSpace, printTextInfo.mmBaseLine),
		printTextInfo.mmBaseLineCurrent = printTextInfo.mmBaseLine;
		pChar != NULL;
		pChar = pRich->CharNext(lLine, lChar, mmX, nAfterSpace, printTextInfo.mmBaseLine)) {

		printTextInfo.pChar = pChar;
		printTextInfo.mmLeft = mmX + pChar->m_mmfAbcA;

		switch (pChar->m_wChar)
		{
		case FDRCH_RETURN:		// _xZkqqHx_iJpMiNhDiLeMiNiGiBeC_xHqqkZx_
		case FDRCH_CONTINUE:	// _xZkqqHx_iMhAjBlBiNhDiLeMiNiGiBeC_xHqqkZx_
			break;

		case FDRCH_FONT_AND_OFFSET:		// FONT,Offset_xZkqqHx_jAnNjCoI_xHqqkZx_.
			result = printTextChangeFont( &printTextInfo );
			SE_RESULT_CHECK( result );
			break;

		case FDRCH_COLORREF:			// COLORREF_xZkqqHx_jAnNjCoI_xHqqkZx_.
			result = printTextChangeColor( &printTextInfo );
			SE_RESULT_CHECK( result );
			break;

		case FDRCH_AFTERSPACE:		// AfterSpace_xZkqqHx_jAnNjCoI_xHqqkZx_.
			break;

		case FDRCH_LINES_AND_CROSSSTAT:	// _xZkqqHx_iOoGiPmBiClFjApMiBeBiJlKjApMiBeBjFlGiOjKiIoMiCoKiPpDjBnEiBeC_xHqqkZx_
			result = printTextChangeLineCrossstat( &printTextInfo );
			SE_RESULT_CHECK( result );
			break;

		case FDRCH_PRESPACE:	// _xZkqqHx_jFlGiOjKjBePjHfNjEjC_xHqqkZx_.
			break;

		case L'\t':	// _xZkqqHx_iDfOiDhF_xHqqkZx_.
			break;

		default:	// WCH_SPC, _xZkqqHx_jCmKiPoNjFlGiOjKiBeC_xHqqkZx_
			// _xZkqqHx_iClBiCoKiImIiPoDiJeFjBkEiCmJiPjBiCkNiInDjGkBiCmNiCmIiCkCiBeC_xHqqkZx_
			if (byCrossStat == FDWR_CROSS_OUTSIDE || pRich->GetTextRect().right < mmX) {
				break;
			}
			result = printTextChar( &printTextInfo );
			SE_RESULT_CHECK( result );
		} // switch
	} // for pChar

	// _xZkqqHx_iOgDiCmBiClNjFlGiOjKjHpBiCkKiCkAiCoKiCmOiPgPjHmNiClHiCoJ_xHqqkZx_
	result = printTextBufferedChar( &printTextInfo );
	SE_RESULT_CHECK( result );

	// _xZkqqHx_iOgDiCmBiClN_xHqqkZx_tspan_xZkqqHx_iPeJjHlJiDfOiDePiCpAiPgPjHmN_xHqqkZx_
	for ( int i = 0; i < printTextInfo.tspanNum; i++ ) {
		fprintf( _fptr, "</tspan>\n" );
	}

	fprintf( _fptr, "</text>\n" );

	return SVGEXPORT_OK;

} // end of SvgExportInfo::printText



int SvgExportInfo::printSvgUnsupported() {

	fprintf( _fptr, "<!-- The DynamicDraw part \"%s\" is not supported. -->\n", _partsName );
	char str[512];
	// "SVGExport_xZkqqHx_iDhGiDiJiDePiDeDiDjD_xHqqkZx_ _xZkqqHx_iMhIiNjA_xHqqkZx_\n\n_xZkqqHx_iClBiCmMjFjEjFgJiDfOiDeDiDhGiCmNiDfEiDhMiBfLiDgHiClFiCmEiCkIiCoIiCnMiClJiCpBiBeC_xHqqkZx_\n_xZkqqHx_iClBiCmMjFjEjFgJiCpAjGlDiOiLiClFiCmEiBeBiPiIjHjNiCpAjBlBiNhDiClFiCnMiClHiBeC_xHqqkZx_\n_xZkqqHx_iPnKiClFiCkNiCmNiBeB_xHqqkZx_SVGExport_xZkqqHx_iDhGiDiJiDePiDeDiDjDiCmMiDhHiDiLiDhGiCpAiClCiOfBiPmGiJlKiClDiCkCiBeC_xHqqkZx_\n\n_xZkqqHx_iMhIiNjAiPoOjFpBiBeG_xHqqkZx_%s"
// 06.07.04 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	sprintf( str, "SVGExport_xZkqqHx_iDhGiDiJiDePiDeDiDjD_xHqqkZx_ _xZkqqHx_iMhIiNjA_xHqqkZx_\n\n_xZkqqHx_iClBiCmMjFjEjFgJiDfOiDeDiDhGiCmNiDfEiDhMiBfLiDgHiClFiCmEiCkIiCoIiCnMiClJiCpBiBeC_xHqqkZx_\n_xZkqqHx_iClBiCmMjFjEjFgJiCpAjGlDiOiLiClFiCmEiBeBiPiIjHjNiCpAjBlBiNhDiClFiCnMiClHiBeC_xHqqkZx_\n_xZkqqHx_iPnKiClFiCkNiCmNiBeB_xHqqkZx_SVGExport_xZkqqHx_iDhGiDiJiDePiDeDiDjDiCmMiDhHiDiLiDhGiCpAiClCiOfBiPmGiJlKiClDiCkCiBeC_xHqqkZx_\n\n_xZkqqHx_iMhIiNjAiPoOjFpBiBeG_xHqqkZx_%s", objectTypeName[_objectExp->Type()] );
	sprintf(str, FFLoadString(IDS_WRNMSG_UNKNOWN_OBJECT), objectTypeName[_objectExp->Type()]);
	::AfxMessageBox(str, MB_OK | MB_APPLMODAL | MB_ICONEXCLAMATION);
	return SVGEXPORT_OK;

} // end of printSvgUnsupported



//----- 06.07.04 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//// _xZkqqHx_jGoOiIpDjGhLjBmMiBeBiPpMiCoIiCmMiDhMiDiKiDfDiDjDiCmIiCmHiCpAiPgPjHmN_xHqqkZx_
//int SvgExportInfo::printSvgArrowPolygon( DBLPointVector *vmmptArrowPoly, bool isArrowMainBody ) {
//
//	fprintf( _fptr, "<polyline points='" );
//	DBLPointVector::const_iterator iMp;
//	for (iMp = vmmptArrowPoly->begin(); iMp != vmmptArrowPoly->end(); iMp++) {
//		// _xZkqqHx_iClBiClBiCmFjAhNiMgAiCmMiDhIiDeOiDgHiDiLiDgGiBfLiDfOiCpAiOoGjDlOiCmFiCkLiCoJiBeC_xHqqkZx_
//		// _xZkqqHx_jCfAiImKiCmN_xHqqkZx_ mm_xZkqqHx_iBeC_xHqqkZx_
//		DBLPoint mmpt = (*iMp);
//		char *formatStr = getFormatString( "%n,%n " );
//		fprintf( _fptr, formatStr, SvgUnitOffsetX( mmpt.x ), 
//			SvgUnitOffsetY( mmpt.y ) );
//	} // for iMp
//	fprintf( _fptr, "' " );
//
//	//-------- _xZkqqHx_jGoOiIpDjHhAiCmGiClFiCmEiDfIiDfOiDeDiDiLiCpAiPgPjHmN_xHqqkZx_ ----------
//	printStyle( isArrowMainBody );
//
//	//-------- _xZkqqHx_iDfOiDePjFmCiClGiCoJ_xHqqkZx_ ----------
//	fprintf( _fptr, "/>\n" );
//
//	return SVGEXPORT_OK;
//
//} // end of printSvgArrowPolygon
//----- 06.07.04 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//----- 06.07.04 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

// _xZkqqHx_iBgJiDhDiDeOiDgAiDiDiBfLjGoOiIpDiCmMiBgKiDeJiDhFiDfHiDeGiDeOiDgHiDhIiDeOiDfOiBfLiCpAiPgPjHmN_xHqqkZx_
int SvgExportInfo::printSvgArrowObjVector( ObjDynabaseVector *objVector ) {

	ObjDynabaseVector::const_iterator i;
	SvgExportInfo itemSvgExportInfo = *this;
	for ( i = objVector->begin(); i != objVector->end(); i++ ) {
		itemSvgExportInfo._objectExp = (FCObjDynabase*)*i;
		itemSvgExportInfo.setStyle();
		int result = itemSvgExportInfo.printSVG();
		SE_RESULT_CHECK( result );
	} // for i

	return SVGEXPORT_OK;

} // end of printSvgArrowObjVector



// _xZkqqHx_jGoOiIpDiDhMiDiKiDfDiDjDiPgPjHmNiCmFiBeBjGoOiIpDjHhAiCmMiDfIiDfOiDeDiDiLiCmJiClHiCoJ_xHqqkZx_
#define SE_PRINT_ARROW_STYLE	true

// _xZkqqHx_jGoOiIpDiDhMiDiKiDfDiDjDiPgPjHmNiCmFiBeBiDeJiDhFiDfHiDeGiDeOiDgHiCmGjDkPiClGiDfIiDfOiDeDiDiLiCmJiClHiCoJ_xHqqkZx_
#define SE_PRINT_OBJECT_STYLE	false

//----- 06.07.03 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//// _xZkqqHx_jGoOiIpDiCpAiPgPjHmN_xHqqkZx_
//int SvgExportInfo::printSvgArrow( FCBaseArrow *pArrowF, FCBaseArrow *pArrowB, BOOL *bIsWidePoly )
//{
//	//----- _xZkqqHx_jGoOiIpDiCmMiJlKiPpMiCoIiCpAiOoGjDlO_xHqqkZx_ -----
//	if (pArrowF != NULL) {
//		switch (pArrowF->Type()) {
//		case FDAW_STANDARD:
//			break;
//		case FDAW_PICTURE:
//			{
//				// _xZkqqHx_iBgJiDhDiDeOiDgAiDiDiBfLjGoOiIpDiCmMiBgKiDeJiDhFiDfHiDeGiDeOiDgHiDhIiDeOiDfOiBfLiCpAiPgPjHmN_xHqqkZx_
//				ObjDynabaseVector vObj;
//				pArrowF->GetLocalObject()->GetPreDrawObjects(vObj);
//				int result = printSvgArrowObjVector( &vObj );
//				SE_RESULT_CHECK( result );
//				break;
//			}
//		} // switch
//	} // if pArrowF
//
//	if (pArrowB != NULL) {
//		switch (pArrowB->Type()) {
//		case FDAW_STANDARD:
//			break;
//		case FDAW_PICTURE:
//			{
//				ObjDynabaseVector vObj;
//				pArrowB->GetLocalObject()->GetPreDrawObjects(vObj);
//				int result = printSvgArrowObjVector( &vObj );
//				SE_RESULT_CHECK( result );
//				break;
//			}
//		} // switch
//	} // if pArrowB
//
//	//----- _xZkqqHx_jGoOiIpDiCmMjGhLjBmMiCpAiOoGjDlO_xHqqkZx_ -----
//	if (!*bIsWidePoly && ( NULL != pArrowF || NULL != pArrowB ) ) {
//		// _xZkqqHx_jGoOiIpDjHhAiDePiDiLiBfLiDhGiKeKiOgOiDfOiDeP_xHqqkZx_
//		fprintf( _fptr, "<g style='stroke-linecap:square;stroke-linejoin:miter'>%s\n", getCommentStr( "<!-- group tag for arrow -->" ) );
//
//		if (pArrowF != NULL) {
//			DBLPointVector vmmptArrowPoly;
//			pArrowF->GetPolygon(vmmptArrowPoly, 5.0);
//			int result = printSvgArrowPolygon( &vmmptArrowPoly, SE_PRINT_ARROW_STYLE );
//			SE_RESULT_CHECK( result );
//		} // if pArrowF
//
//		if (pArrowB != NULL)
//		{
//			DBLPointVector vmmptArrowPoly;
//			pArrowB->GetPolygon(vmmptArrowPoly, 5.0);
//			int result = printSvgArrowPolygon( &vmmptArrowPoly, SE_PRINT_ARROW_STYLE );
//			SE_RESULT_CHECK( result );
//		}
//
//		// _xZkqqHx_jGoOiIpDjHhAiDePiDiLiBfLiDhGiPeJjHlJiDfOiDeP_xHqqkZx_
//		fprintf( _fptr, "</g>%s\n", getCommentStr( "<!-- group tag for arrow -->" ) );
//	} // if bIsWidePoly
//
//	//----- _xZkqqHx_jGoOiIpDiCmMiPoDiPpMiCoIiCpAiOoGjDlO_xHqqkZx_ -----
//	if (pArrowF != NULL) {
//		switch (pArrowF->Type()) {
//		case FDAW_STANDARD:
//			{
//				DBLPointVector vmmptPoly;
//				pArrowF->GetPostPolyline(vmmptPoly);
//				int result = printSvgArrowPolygon( &vmmptPoly, SE_PRINT_OBJECT_STYLE );
//				SE_RESULT_CHECK( result );
//				break;
//			}
//		case FDAW_PICTURE:
//			{
//				ObjDynabaseVector vObj;
//				pArrowF->GetLocalObject()->GetPostDrawObjects(vObj);
//				int result = printSvgArrowObjVector( &vObj );
//				SE_RESULT_CHECK( result );
//				break;
//			}
//		} // switch
//	} // if pArrowF
//
//	if (pArrowB != NULL) {
//		switch (pArrowB->Type()) {
//		case FDAW_STANDARD:
//			{
//				DBLPointVector vmmptPoly;
//				pArrowB->GetPostPolyline(vmmptPoly);
//				int result = printSvgArrowPolygon( &vmmptPoly, SE_PRINT_OBJECT_STYLE );
//				SE_RESULT_CHECK( result );
//				break;
//			}
//		case FDAW_PICTURE:
//			{
//				ObjDynabaseVector vObj;
//				pArrowB->GetLocalObject()->GetPostDrawObjects(vObj);
//				int result = printSvgArrowObjVector( &vObj );
//				SE_RESULT_CHECK( result );
//				break;
//			}
//		} // switch
//	} // if pArrowB
//
//	if (pArrowF != NULL) pArrowF->Release();
//	if (pArrowB != NULL) pArrowB->Release();
//
//	return SVGEXPORT_OK;
//} // end of printSvgArrow
//----- 06.07.03 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	SvgExportInfo::printSvgPreArrow
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jGoOiIpDiCmMiJlKiPpMiCoIiCpAiPgPjHmNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pArrowF		:_xZkqqHx_jBePjFpLjGoOiIpDiCmMiDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pArrowB		:_xZkqqHx_iMoDjFpLjGoOiIpDiCmMiDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_SVGEXPORT_OK_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	HIROSAWA Masashi _xZkqqHx_iNoMjAkMiBeC_xHqqkZx_
 *			06.07.03 Fukushiro M. _xZkqqHx_iPeDjAlDiBeC_xHqqkZx_
 *************************************************************************/
int SvgExportInfo::printSvgPreArrow (FCBaseArrow *pArrowF, FCBaseArrow *pArrowB)
{
	//----- _xZkqqHx_jGoOiIpDiCmMiJlKiPpMiCoIiCpAiOoGjDlO_xHqqkZx_ -----
	if (pArrowF != NULL)
	{
		switch (pArrowF->Type())
		{
		case FDAW_STANDARD:
			break;
		case FDAW_PICTURE:
			{
				// _xZkqqHx_iBgJiDhDiDeOiDgAiDiDiBfLjGoOiIpDiCmMiBgKiDeJiDhFiDfHiDeGiDeOiDgHiDhIiDeOiDfOiBfLiCpAiPgPjHmN_xHqqkZx_
				ObjDynabaseVector vObj;
				pArrowF->GetLocalObject()->GetPreDrawObjects(vObj);
				int result = printSvgArrowObjVector( &vObj );
				SE_RESULT_CHECK( result );
				break;
			}
		} // switch
	} // if pArrowF

	if (pArrowB != NULL)
	{
		switch (pArrowB->Type())
		{
		case FDAW_STANDARD:
			break;
		case FDAW_PICTURE:
			{
				ObjDynabaseVector vObj;
				pArrowB->GetLocalObject()->GetPreDrawObjects(vObj);
				int result = printSvgArrowObjVector( &vObj );
				SE_RESULT_CHECK( result );
				break;
			}
		} // switch
	} // if pArrowB
	return SVGEXPORT_OK;
} // end of printSvgPreArrow

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	SvgExportInfo::printSvgMainArrow
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jGoOiIpDiCmMiDiBiDeDiDjDiCpAiPgPjHmNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pArrowF		:_xZkqqHx_jBePjFpLjGoOiIpDiCmMiDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pArrowB		:_xZkqqHx_iMoDjFpLjGoOiIpDiCmMiDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_SVGEXPORT_OK_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	HIROSAWA Masashi _xZkqqHx_iNoMjAkMiBeC_xHqqkZx_
 *			06.07.03 Fukushiro M. _xZkqqHx_iPeDjAlDiBeC_xHqqkZx_
 *************************************************************************/
int SvgExportInfo::printSvgMainArrow (FCBaseArrow *pArrowF, FCBaseArrow *pArrowB)
{
	//----- _xZkqqHx_jGoOiIpDiCmMjGhLjBmMiCpAiOoGjDlO_xHqqkZx_ -----
	if (pArrowF != NULL || pArrowB != NULL)
	{
		// _xZkqqHx_jGoOiIpDjHhAiDePiDiLiBfLiDhGiKeKiOgOiDfOiDeP_xHqqkZx_
		fprintf(_fptr, "<g style='stroke-linecap:square;stroke-linejoin:miter'>%s\n", getCommentStr("<!-- group tag for arrow -->"));
		if (pArrowF != NULL)
		{
//----- 06.07.04 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//			DBLPointVector vmmptArrowPoly;
//			pArrowF->GetPolygon(vmmptArrowPoly, 5.0);
//			int result = printSvgArrowPolygon( &vmmptArrowPoly, SE_PRINT_ARROW_STYLE );
//----- 06.07.04 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
			FCMmPolyBezier polyBezier;
			pArrowF->GetBezier(polyBezier);
			int result = printSvgFigLPB(polyBezier, true, NOT_PRINT_SVG_CLIP_PATH, true);
//----- 06.07.04 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
			SE_RESULT_CHECK( result );
		} // if pArrowF

		if (pArrowB != NULL)
		{
//----- 06.07.04 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//			DBLPointVector vmmptArrowPoly;
//			pArrowB->GetPolygon(vmmptArrowPoly, 5.0);
//			int result = printSvgArrowPolygon( &vmmptArrowPoly, SE_PRINT_ARROW_STYLE );
//----- 06.07.04 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
			FCMmPolyBezier polyBezier;
			pArrowB->GetBezier(polyBezier);
			int result = printSvgFigLPB(polyBezier, true, NOT_PRINT_SVG_CLIP_PATH, true);
//----- 06.07.04 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
			SE_RESULT_CHECK( result );
		}
		// _xZkqqHx_jGoOiIpDjHhAiDePiDiLiBfLiDhGiPeJjHlJiDfOiDeP_xHqqkZx_
		fprintf(_fptr, "</g>%s\n", getCommentStr("<!-- group tag for arrow -->"));
	} // if bIsWidePoly
	return SVGEXPORT_OK;
} // end of printSvgMainArrow

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	SvgExportInfo::printSvgPostArrow
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jGoOiIpDiCmMiJlKiPpMiCoIiCpAiPgPjHmNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pArrowF		:_xZkqqHx_jBePjFpLjGoOiIpDiCmMiDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pArrowB		:_xZkqqHx_iMoDjFpLjGoOiIpDiCmMiDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_SVGEXPORT_OK_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	HIROSAWA Masashi _xZkqqHx_iNoMjAkMiBeC_xHqqkZx_
 *			06.07.03 Fukushiro M. _xZkqqHx_iPeDjAlDiBeC_xHqqkZx_
 *************************************************************************/
int SvgExportInfo::printSvgPostArrow (FCBaseArrow *pArrowF, FCBaseArrow *pArrowB)
{
	//----- _xZkqqHx_jGoOiIpDiCmMiPoDiPpMiCoIiCpAiOoGjDlO_xHqqkZx_ -----
	if (pArrowF != NULL)
	{
		switch (pArrowF->Type())
		{
		case FDAW_STANDARD:
//----- 06.07.04 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//			{
//				DBLPointVector vmmptPoly;
//				pArrowF->GetPostPolyline(vmmptPoly);
//				int result = printSvgArrowPolygon( &vmmptPoly, SE_PRINT_OBJECT_STYLE );
//				SE_RESULT_CHECK( result );
//				break;
//			}
//----- 06.07.04 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
			break;
//----- 06.07.04 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
		case FDAW_PICTURE:
			{
				ObjDynabaseVector vObj;
				pArrowF->GetLocalObject()->GetPostDrawObjects(vObj);
				int result = printSvgArrowObjVector( &vObj );
				SE_RESULT_CHECK( result );
				break;
			}
		} // switch
	} // if pArrowF

	if (pArrowB != NULL)
	{
		switch (pArrowB->Type())
		{
		case FDAW_STANDARD:
//----- 06.07.04 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//			{
//				DBLPointVector vmmptPoly;
//				pArrowB->GetPostPolyline(vmmptPoly);
//				int result = printSvgArrowPolygon( &vmmptPoly, SE_PRINT_OBJECT_STYLE );
//				SE_RESULT_CHECK( result );
//				break;
//			}
//----- 06.07.04 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
			break;
//----- 06.07.04 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
		case FDAW_PICTURE:
			{
				ObjDynabaseVector vObj;
				pArrowB->GetLocalObject()->GetPostDrawObjects(vObj);
				int result = printSvgArrowObjVector( &vObj );
				SE_RESULT_CHECK( result );
				break;
			}
		} // switch
	} // if pArrowB

	return SVGEXPORT_OK;
} // end of printSvgPostArrow.
//----- 06.07.03 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

//----- 06.07.03 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//int SvgExportInfo::printSvgLine()
//{
////----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////	fprintf( _fptr, "<line " );
////
////	//-------- _xZkqqHx_iImKjChFiCpAiPgPjHmN_xHqqkZx_ ----------
////	BOOL bIsClose;
////	FCBaseArrow* pArrowF = NULL;
////	FCBaseArrow* pArrowB = NULL;
////	BOOL bIsWidePoly;
////	DBLPointVector vmmptPoly;
////	_objectExp->NewArrowedObjPolygon(vmmptPoly, bIsClose, pArrowF, pArrowB,
////								bIsWidePoly, 5.0, NULL, 0);
////	DBLPointVector::const_iterator iMp = _pmmptvPoly->begin();
////	iMp = vmmptPoly.begin();
////	DBLPoint mmpt = (*iMp);
////	char *formatStr = getFormatString( "x1='%n' y1='%n' " );
////	fprintf( _fptr, formatStr, SvgUnitOffsetX( mmpt.x ), SvgUnitOffsetY( mmpt.y ) );
////	//mmpt = (*(++iMp));
////	while ( vmmptPoly.end() != iMp ) {
////		mmpt = (*(iMp++));
////	}
////	formatStr = getFormatString( "x2='%n' y2='%n' " );
////	fprintf( _fptr, formatStr, SvgUnitOffsetX( mmpt.x ), SvgUnitOffsetY( mmpt.y ) );
////
////	//-------- _xZkqqHx_iDfIiDfOiDeDiDiLiCpAiPgPjHmN_xHqqkZx_ ----------
////	printStyle();
////
////	//-------- _xZkqqHx_iDfOiDePjFmCiClGiCoJ_xHqqkZx_ ----------
////	fprintf( _fptr, "/>\n" );
////
////
////	//-------- _xZkqqHx_jGoOiIpDiPgPjHmN_xHqqkZx_ ----------------
////	int result = printSvgArrow( pArrowF, pArrowB, &bIsWidePoly );
////	SE_RESULT_CHECK( result );
////
////	return SVGEXPORT_OK;
////----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
////----- 06.07.03 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////	const FCObjLine* pLine = (const FCObjLine*)_objectExp;
////	fprintf( _fptr, "<line " );
////
////	//-------- _xZkqqHx_iImKjChFiCpAiPgPjHmN_xHqqkZx_ ----------
////	BOOL bIsClose;
////	FCBaseArrow* pArrowF = NULL;
////	FCBaseArrow* pArrowB = NULL;
////	BOOL bIsWidePoly;
////	DBLPointVector vmmptPoly;
////	pLine->NewArrowedObjPolygon(vmmptPoly, bIsClose, pArrowF, pArrowB,
////								bIsWidePoly, 5.0, NULL, 0);
////	DBLPointVector::const_iterator iMp = _pmmptvPoly->begin();
////	iMp = vmmptPoly.begin();
////	DBLPoint mmpt = (*iMp);
////	char *formatStr = getFormatString( "x1='%n' y1='%n' " );
////	fprintf( _fptr, formatStr, SvgUnitOffsetX( mmpt.x ), SvgUnitOffsetY( mmpt.y ) );
////	//mmpt = (*(++iMp));
////	while ( vmmptPoly.end() != iMp ) {
////		mmpt = (*(iMp++));
////	}
////	formatStr = getFormatString( "x2='%n' y2='%n' " );
////	fprintf( _fptr, formatStr, SvgUnitOffsetX( mmpt.x ), SvgUnitOffsetY( mmpt.y ) );
////
////	//-------- _xZkqqHx_iDfIiDfOiDeDiDiLiCpAiPgPjHmN_xHqqkZx_ ----------
////	printStyle();
////
////	//-------- _xZkqqHx_iDfOiDePjFmCiClGiCoJ_xHqqkZx_ ----------
////	fprintf( _fptr, "/>\n" );
////
////
////	//-------- _xZkqqHx_jGoOiIpDiPgPjHmN_xHqqkZx_ ----------------
////	int result = printSvgArrow( pArrowF, pArrowB, &bIsWidePoly );
////	SE_RESULT_CHECK(result);
////
////	return SVGEXPORT_OK;
////----- 06.07.03 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//	const FCObjLine* pLine = (const FCObjLine*)_objectExp;
//	//-------- _xZkqqHx_iImKjChFiCpAiPgPjHmN_xHqqkZx_ ----------
//	FCMmPolyBezier polyBezier;
//	BOOL bIsClose;
//	FCBaseArrow* pArrowF = NULL;
//	FCBaseArrow* pArrowB = NULL;
//	BOOL bIsWidePoly;
//	// _xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjHnGiKhDiCmMiDhIiDfHiDeGiLmIjApMiCpAiOoGjDlOiBeC_xHqqkZx_
//	pLine->NewArrowedObjBezier(	polyBezier,
//								bIsClose,
//								pArrowF,
//								pArrowB,
//								bIsWidePoly);
//
//	int result = SVGEXPORT_OK;
//  for (;;)
//  {
//	if (polyBezier.size() != 4)
//	{
//		result = SVGEXPORT_ERROR;
//		break;
//	}
//	const DBLPoint mmptF = polyBezier[1];	// _xZkqqHx_iOgOjDfPiBeC_xHqqkZx_
//	const DBLPoint mmptB = polyBezier[3];	// _xZkqqHx_iPeJjDfPiBeC_xHqqkZx_
//	// _xZkqqHx_jGoOiIpDiCmMiJlKiPpMiCoIiCpAiPgPjHmNiBeC_xHqqkZx_
//	result = printSvgPreArrow(pArrowF, pArrowB);
//	if (result != SVGEXPORT_OK) break;
//	//----- _xZkqqHx_jApMiCpAiPgPjHmN_xHqqkZx_ -----
//	fprintf(_fptr, "<line ");
//	char *formatStr = getFormatString("x1='%n' y1='%n' ");
//	fprintf(_fptr, formatStr, SvgUnitOffsetX(mmptF.x), SvgUnitOffsetY(mmptF.y));
//	formatStr = getFormatString("x2='%n' y2='%n' ");
//	fprintf(_fptr, formatStr, SvgUnitOffsetX(mmptB.x), SvgUnitOffsetY(mmptB.y));
//	//-------- _xZkqqHx_iDfIiDfOiDeDiDiLiCpAiPgPjHmN_xHqqkZx_ ----------
//	printStyle();
//	//-------- _xZkqqHx_iDfOiDePjFmCiClGiCoJ_xHqqkZx_ ----------
//	fprintf( _fptr, "/>\n" );
//	//-------- _xZkqqHx_jGoOiIpDiPgPjHmN_xHqqkZx_ ----------------
//	result = printSvgMainArrow(pArrowF, pArrowB);
//	if (result != SVGEXPORT_OK) break;
//	result = printSvgPostArrow(pArrowF, pArrowB);
//	if (result != SVGEXPORT_OK) break;
//	break;
//  }
//	if (pArrowF != NULL) pArrowF->Release();
//	if (pArrowB != NULL) pArrowB->Release();
//	SE_RESULT_CHECK(result);
////----- 06.07.03 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//	return SVGEXPORT_OK;
////----- 06.07.03 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
////----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//} // end of printSvgLine
//----- 06.07.03 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----


int SvgExportInfo::printSvgRectBase( bool printClipPath )
{
//----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	fprintf( _fptr, "<rect " );
//
//	// _xZkqqHx_jCiGjAfDiImKjChF_xHqqkZx_
//	double cx = _objectExp->GetCenterX();
//	double cy = _objectExp->GetCenterY();
//
//	// _xZkqqHx_iDfEiDeDiDfJ_xHqqkZx_
////----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////	fmmetol aHAxisX = _objectExp->GetHAxisX();
////	fmmetol aVAxisX = _objectExp->GetVAxisX();
////	fmmetol aVAxisY = _objectExp->GetVAxisY();
////----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//	mmetol aHAxisX = _objectExp->GetHAxisX();
//	mmetol aVAxisY = _objectExp->GetVAxisY();
////----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//
//	//-------- _xZkqqHx_iImKjChFiCpAiPgPjHmN_xHqqkZx_ ----------
//	char *formatStr = getFormatString( "x='%n' y='%n' " );
//	fprintf( _fptr, formatStr, SvgUnitOffsetX( cx - aHAxisX ), 
//		SvgUnitOffsetY( cy - aVAxisY ) );
//
//	//-------- _xZkqqHx_iDfEiDeDiDfJiCpAiPgPjHmN_xHqqkZx_ ----------
//	formatStr = getFormatString( "width='%n' height='%n' " );
//	fprintf( _fptr, formatStr, SvgUnit( aHAxisX * 2 ), SvgUnit( aVAxisY * 2 ) );
//
//	return SVGEXPORT_OK;
//----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	const FCObjRect* pRect = (const FCObjRect*)_objectExp;
	fprintf( _fptr, "<rect " );

	// _xZkqqHx_jCiGjAfDiImKjChF_xHqqkZx_
	double cx = pRect->GetCenterX();
	double cy = pRect->GetCenterY();

	// _xZkqqHx_iDfEiDeDiDfJ_xHqqkZx_
//----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	fmmetol aHAxisX = pRect->GetHAxisX();
//	fmmetol aVAxisX = pRect->GetVAxisX();
//	fmmetol aVAxisY = pRect->GetVAxisY();
//----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	mmetol aHAxisX = pRect->GetHAxisX();
	mmetol aVAxisY = pRect->GetVAxisY();
//----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

	//-------- _xZkqqHx_iImKjChFiCpAiPgPjHmN_xHqqkZx_ ----------
	char *formatStr = getFormatString( "x='%n' y='%n' " );
	fprintf( _fptr, formatStr, SvgUnitOffsetX( cx - aHAxisX ), 
		SvgUnitOffsetY( cy - aVAxisY ) );

	//-------- _xZkqqHx_iDfEiDeDiDfJiCpAiPgPjHmN_xHqqkZx_ ----------
	formatStr = getFormatString( "width='%n' height='%n' " );
	fprintf( _fptr, formatStr, SvgUnit( aHAxisX * 2 ), SvgUnit( aVAxisY * 2 ) );

	return SVGEXPORT_OK;
//----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

} // end of printSvgRectBase

int SvgExportInfo::printSvgRect( bool printClipPath )
{
//----- 06.07.04 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	const FCObjFigure* pFig = (const FCObjFigure*)_objectExp;
	// _xZkqqHx_jEhHiMgJjAhNiCpA_xHqqkZx_PNG_xZkqqHx_iCmFiPgPjHmNiBeC_xHqqkZx_
	if (svgExportOption._printBackpictAsPng &&
		pFig->GetEmfImage() != FD_EMF_IMAGE_UNUSE)
		return printSvgOLE(printClipPath);
//----- 06.07.04 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	printSvgRectBase( printClipPath );

	//-------- _xZkqqHx_iDfIiDfOiDeDiDiLiCpAiPgPjHmN_xHqqkZx_ ----------
	if ( false == printClipPath ) {
		printStyle();
	}

	//-------- _xZkqqHx_iJpBjDfNiBeBiDfIiDeMiDiFiBfLiCpAiPgPjHmN_xHqqkZx_ ----------
	printTransform( SI_NO_TEXT_ANGLE_TRANSFORM );

	//-------- _xZkqqHx_iDfOiDePjFmCiClGiCoJ_xHqqkZx_ ----------
	fprintf( _fptr, "/>\n" );

	return SVGEXPORT_OK;

} // end of printSvgRect


int SvgExportInfo::printSvgRoundRect( bool printClipPath ) {

//----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	printSvgRectBase( printClipPath );
//
//	//-------- _xZkqqHx_iDfCiBfLiDgJiBfLiPgPjHmN_xHqqkZx_
//
//	mmetol roundX = _objectExp->GetRoundX();
//	mmetol roundY = _objectExp->GetRoundY();
//	char *formatStr = getFormatString( "rx='%n' ry='%n' " );
//	fprintf( _fptr, formatStr, 
//		SvgUnit( roundX ), SvgUnit( roundY ) );
//
//	//-------- _xZkqqHx_iDfIiDfOiDeDiDiLiCpAiPgPjHmN_xHqqkZx_ ----------
//	if ( false == printClipPath ) {
//		printStyle();
//	}
//
//	//-------- _xZkqqHx_iJpBjDfNiBeBiDfIiDeMiDiFiBfLiCpAiPgPjHmN_xHqqkZx_ ----------
//	printTransform( SI_NO_TEXT_ANGLE_TRANSFORM );
//
//	//-------- _xZkqqHx_iDfOiDePjFmCiClGiCoJ_xHqqkZx_ ----------
//	fprintf( _fptr, "/>\n" );
//
//	return SVGEXPORT_OK;
//----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	const FCObjRoundRect* pRoundRect = (const FCObjRoundRect*)_objectExp;
	// _xZkqqHx_jEhHiMgJjAhNiCpA_xHqqkZx_PNG_xZkqqHx_iCmFiPgPjHmNiBeC_xHqqkZx_
	if (svgExportOption._printBackpictAsPng &&
		pRoundRect->GetEmfImage() != FD_EMF_IMAGE_UNUSE)
		return printSvgOLE(printClipPath);

	printSvgRectBase( printClipPath );

	//-------- _xZkqqHx_iDfCiBfLiDgJiBfLiPgPjHmN_xHqqkZx_

	mmetol roundX = pRoundRect->GetRoundX();
	mmetol roundY = pRoundRect->GetRoundY();
	char *formatStr = getFormatString( "rx='%n' ry='%n' " );
	fprintf( _fptr, formatStr, 
		SvgUnit( roundX ), SvgUnit( roundY ) );

	//-------- _xZkqqHx_iDfIiDfOiDeDiDiLiCpAiPgPjHmN_xHqqkZx_ ----------
	if ( false == printClipPath ) {
		printStyle();
	}

	//-------- _xZkqqHx_iJpBjDfNiBeBiDfIiDeMiDiFiBfLiCpAiPgPjHmN_xHqqkZx_ ----------
	printTransform( SI_NO_TEXT_ANGLE_TRANSFORM );

	//-------- _xZkqqHx_iDfOiDePjFmCiClGiCoJ_xHqqkZx_ ----------
	fprintf( _fptr, "/>\n" );

	return SVGEXPORT_OK;
//----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

} // end of printSvgRoundRect


// _xZkqqHx_iJhO_xHqqkZx_
int SvgExportInfo::printSvgCircle( bool printClipPath ) {

//----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	fprintf( _fptr, "<circle " );
//
//	//-------- _xZkqqHx_jCiGjAfDiImKjChFiCpAiPgPjHmN_xHqqkZx_ ----------
//
//	double cx = _objectExp->GetCenterX();
//	double cy = _objectExp->GetCenterY();
//	char *formatStr = getFormatString( "cx='%n' cy='%n' " );
//	fprintf( _fptr, formatStr, SvgUnitOffsetX( cx ), SvgUnitOffsetY( cy ) );
//
//	//-------- _xZkqqHx_iDfEiDeDiDfJiCpAiPgPjHmN_xHqqkZx_ ----------
//
////----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////	fmmetol aHAxisX = _objectExp->GetHAxisX();
////	fmmetol aVAxisX = _objectExp->GetVAxisX();
////----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//	mmetol aHAxisX = _objectExp->GetHAxisX();
////----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//
//	formatStr = getFormatString( "r='%n' " );
//	fprintf( _fptr, formatStr, SvgUnit( aHAxisX ) );
//
//	//-------- _xZkqqHx_iDfIiDfOiDeDiDiLiCpAiPgPjHmN_xHqqkZx_ ----------
//	if ( false == printClipPath ) {
//		printStyle();
//	}
//
//	//-------- _xZkqqHx_iJpBjDfNiBeBiDfIiDeMiDiFiBfLiCpAiPgPjHmN_xHqqkZx_ ----------
//	printTransform( SI_NO_TEXT_ANGLE_TRANSFORM );
//
//	//-------- _xZkqqHx_iDfOiDePjFmCiClGiCoJ_xHqqkZx_ ----------
//	fprintf( _fptr, "/>\n" );
//
//	return SVGEXPORT_OK;
//----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	const FCObjArc* pArc = (const FCObjArc*)_objectExp;
	fprintf( _fptr, "<circle " );

	//-------- _xZkqqHx_jCiGjAfDiImKjChFiCpAiPgPjHmN_xHqqkZx_ ----------

	double cx = pArc->GetCenterX();
	double cy = pArc->GetCenterY();
	char *formatStr = getFormatString( "cx='%n' cy='%n' " );
	fprintf( _fptr, formatStr, SvgUnitOffsetX( cx ), SvgUnitOffsetY( cy ) );

	//-------- _xZkqqHx_iDfEiDeDiDfJiCpAiPgPjHmN_xHqqkZx_ ----------

//----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	fmmetol aHAxisX = pArc->GetHAxisX();
//	fmmetol aVAxisX = pArc->GetVAxisX();
//----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	mmetol aHAxisX = pArc->GetHAxisX();
//----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

	formatStr = getFormatString( "r='%n' " );
	fprintf( _fptr, formatStr, SvgUnit( aHAxisX ) );

	//-------- _xZkqqHx_iDfIiDfOiDeDiDiLiCpAiPgPjHmN_xHqqkZx_ ----------
	if ( false == printClipPath ) {
		printStyle();
	}

	//-------- _xZkqqHx_iJpBjDfNiBeBiDfIiDeMiDiFiBfLiCpAiPgPjHmN_xHqqkZx_ ----------
	printTransform( SI_NO_TEXT_ANGLE_TRANSFORM );

	//-------- _xZkqqHx_iDfOiDePjFmCiClGiCoJ_xHqqkZx_ ----------
	fprintf( _fptr, "/>\n" );

	return SVGEXPORT_OK;
//----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

} // end of printSvgCircle


// _xZkqqHx_jBmIiJhO_xHqqkZx_
int SvgExportInfo::printSvgEllipse( bool printClipPath ) {

//----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	fprintf( _fptr, "<ellipse " );
//
//	//-------- _xZkqqHx_jCiGjAfDiImKjChFiCpAiPgPjHmN_xHqqkZx_ ----------
//
//	double cx = _objectExp->GetCenterX();
//	double cy = _objectExp->GetCenterY();
//	char *formatStr = getFormatString( "cx='%n' cy='%n' " );
//	fprintf( _fptr, formatStr, SvgUnitOffsetX( cx ), SvgUnitOffsetY( cy ) );
//
//	//-------- _xZkqqHx_iDfEiDeDiDfJiCpAiPgPjHmN_xHqqkZx_ ----------
//
////----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////	fmmetol aHAxisX = _objectExp->GetHAxisX();
////	fmmetol aVAxisX = _objectExp->GetVAxisX();
////	fmmetol aVAxisY = _objectExp->GetVAxisY();
////----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//	mmetol aHAxisX = _objectExp->GetHAxisX();
//	mmetol aVAxisY = _objectExp->GetVAxisY();
////----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//
//	formatStr = getFormatString( "rx='%n' ry='%n' " );
//	fprintf( _fptr, formatStr, SvgUnit( aHAxisX ), SvgUnit( aVAxisY ) );
//
//	//-------- _xZkqqHx_iDfIiDfOiDeDiDiLiCpAiPgPjHmN_xHqqkZx_ ----------
//	if ( false == printClipPath ) {
//		printStyle();
//	}
//
//	//-------- _xZkqqHx_iJpBjDfNiBeBiDfIiDeMiDiFiBfLiCpAiPgPjHmN_xHqqkZx_ ----------
//	printTransform( SI_NO_TEXT_ANGLE_TRANSFORM );
//
//	//-------- _xZkqqHx_iDfOiDePjFmCiClGiCoJ_xHqqkZx_ ----------
//	fprintf( _fptr, "/>\n" );
//
//	return SVGEXPORT_OK;
//----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	const FCObjArc* pArc = (const FCObjArc*)_objectExp;
	fprintf( _fptr, "<ellipse " );

	//-------- _xZkqqHx_jCiGjAfDiImKjChFiCpAiPgPjHmN_xHqqkZx_ ----------

	double cx = pArc->GetCenterX();
	double cy = pArc->GetCenterY();
	char *formatStr = getFormatString( "cx='%n' cy='%n' " );
	fprintf( _fptr, formatStr, SvgUnitOffsetX( cx ), SvgUnitOffsetY( cy ) );

	//-------- _xZkqqHx_iDfEiDeDiDfJiCpAiPgPjHmN_xHqqkZx_ ----------

//----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	fmmetol aHAxisX = pArc->GetHAxisX();
//	fmmetol aVAxisX = pArc->GetVAxisX();
//	fmmetol aVAxisY = pArc->GetVAxisY();
//----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	mmetol aHAxisX = pArc->GetHAxisX();
	mmetol aVAxisY = pArc->GetVAxisY();
//----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

	formatStr = getFormatString( "rx='%n' ry='%n' " );
	fprintf( _fptr, formatStr, SvgUnit( aHAxisX ), SvgUnit( aVAxisY ) );

	//-------- _xZkqqHx_iDfIiDfOiDeDiDiLiCpAiPgPjHmN_xHqqkZx_ ----------
	if ( false == printClipPath ) {
		printStyle();
	}

	//-------- _xZkqqHx_iJpBjDfNiBeBiDfIiDeMiDiFiBfLiCpAiPgPjHmN_xHqqkZx_ ----------
	printTransform( SI_NO_TEXT_ANGLE_TRANSFORM );

	//-------- _xZkqqHx_iDfOiDePjFmCiClGiCoJ_xHqqkZx_ ----------
	fprintf( _fptr, "/>\n" );

	return SVGEXPORT_OK;
//----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

} // end of printSvgEllipse



// _xZkqqHx_jAoOiMgAiCmJiCmCiCmIiCkO_xHqqkZx_
int SvgExportInfo::printSvgPie( bool printClipPath ) {

//----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_jCiGjAfDiImKjChF_xHqqkZx_
//	double cx = _objectExp->GetCenterX();
//	double cy = _objectExp->GetCenterY();
//
//	// _xZkqqHx_iDfEiDeDiDfJ_xHqqkZx_
////----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////	fmmetol aHAxisX = _objectExp->GetHAxisX(); // rx
////	fmmetol aVAxisY = _objectExp->GetVAxisY(); // ry
////----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//	mmetol aHAxisX = _objectExp->GetHAxisX(); // rx
//	mmetol aVAxisY = _objectExp->GetVAxisY(); // ry
////----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//
//	// _xZkqqHx_iKeKiOgOiBeBiPeJjHlJiKhAjDhI_xHqqkZx_
//	double bgnRRad = _objectExp->GetArcBgnR() * M_PI;
//	double endRRad = _objectExp->GetArcEndR() * M_PI;
//
//	// _xZkqqHx_iKeKiOgOiBeBiPeJjHlJjDfP_xHqqkZx_
//	DBLPoint startPoint, endPoint;
//	startPoint.x = cx + aHAxisX * cos( bgnRRad );
//	startPoint.y = cy + aVAxisY * sin( bgnRRad );
//	endPoint.x = cx + aHAxisX * cos( endRRad );
//	endPoint.y = cy + aVAxisY * sin( endRRad );
//
//
//	//-------- _xZkqqHx_jAoOjFjEjFkKiCpAiPgPjHmN_xHqqkZx_ ----------
//	char *formatStr = getFormatString( "M %n,%n %n,%n %n,%n " );
//	fprintf( _fptr, formatStr, 
//		SvgUnitOffsetX( endPoint.x ), SvgUnitOffsetY( endPoint.y ),
//		SvgUnitOffsetX( cx ), SvgUnitOffsetY( cy ),
//		SvgUnitOffsetX( startPoint.x ), SvgUnitOffsetY( startPoint.y ) );
//
//	// _xZkqqHx_iMmKjFjEjFkKiCpAiPgPjHmN_xHqqkZx_
//	return printSvgArcLineBase( printClipPath );
//----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	const FCObjArc* pArc = (const FCObjArc*)_objectExp;
	// _xZkqqHx_jCiGjAfDiImKjChF_xHqqkZx_
	double cx = pArc->GetCenterX();
	double cy = pArc->GetCenterY();

	// _xZkqqHx_iDfEiDeDiDfJ_xHqqkZx_
//----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	fmmetol aHAxisX = pArc->GetHAxisX(); // rx
//	fmmetol aVAxisY = pArc->GetVAxisY(); // ry
//----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	mmetol aHAxisX = pArc->GetHAxisX(); // rx
	mmetol aVAxisY = pArc->GetVAxisY(); // ry
//----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

	// _xZkqqHx_iKeKiOgOiBeBiPeJjHlJiKhAjDhI_xHqqkZx_
	double bgnRRad = pArc->GetArcBgnR() * M_PI;
	double endRRad = pArc->GetArcEndR() * M_PI;

	// _xZkqqHx_iKeKiOgOiBeBiPeJjHlJjDfP_xHqqkZx_
	DBLPoint startPoint, endPoint;
	startPoint.x = cx + aHAxisX * cos( bgnRRad );
	startPoint.y = cy + aVAxisY * sin( bgnRRad );
	endPoint.x = cx + aHAxisX * cos( endRRad );
	endPoint.y = cy + aVAxisY * sin( endRRad );

// 06.07.04 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	fprintf( _fptr, "<path d='" );

	//-------- _xZkqqHx_jAoOjFjEjFkKiCpAiPgPjHmN_xHqqkZx_ ----------
	char *formatStr = getFormatString( "M %n,%n %n,%n %n,%n " );
	fprintf( _fptr, formatStr, 
		SvgUnitOffsetX( endPoint.x ), SvgUnitOffsetY( endPoint.y ),
		SvgUnitOffsetX( cx ), SvgUnitOffsetY( cy ),
		SvgUnitOffsetX( startPoint.x ), SvgUnitOffsetY( startPoint.y ) );

	// _xZkqqHx_iMmKjFjEjFkKiCpAiPgPjHmN_xHqqkZx_
	return printSvgArcLineBase( printClipPath );
//----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

} // end of SvgExportInfo::printSvgPie


// _xZkqqHx_jClMjApMiCmFiCmCiCmIiCkO_xHqqkZx_
int SvgExportInfo::printSvgChord( bool printClipPath ) {

//----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_jCiGjAfDiImKjChF_xHqqkZx_
//	double cx = _objectExp->GetCenterX();
//	double cy = _objectExp->GetCenterY();
//
//	// _xZkqqHx_iDfEiDeDiDfJ_xHqqkZx_
////----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////	fmmetol aHAxisX = _objectExp->GetHAxisX(); // rx
////	fmmetol aVAxisY = _objectExp->GetVAxisY(); // ry
////----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//	mmetol aHAxisX = _objectExp->GetHAxisX(); // rx
//	mmetol aVAxisY = _objectExp->GetVAxisY(); // ry
////----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//
//	// _xZkqqHx_iKeKiOgOiBeBiPeJjHlJiKhAjDhI_xHqqkZx_
//	double bgnRRad = _objectExp->GetArcBgnR() * M_PI;
//	double endRRad = _objectExp->GetArcEndR() * M_PI;
//
//	// _xZkqqHx_iKeKiOgOiBeBiPeJjHlJjDfP_xHqqkZx_
//	DBLPoint startPoint, endPoint;
//	startPoint.x = cx + aHAxisX * cos( bgnRRad );
//	startPoint.y = cy + aVAxisY * sin( bgnRRad );
//	endPoint.x = cx + aHAxisX * cos( endRRad );
//	endPoint.y = cy + aVAxisY * sin( endRRad );
//
//
//	//-------- _xZkqqHx_jClMjApMjFjEjFkKiCpAiPgPjHmN_xHqqkZx_ ----------
//	char *formatStr = getFormatString( "M %n,%n %n,%n " );
//	fprintf( _fptr, formatStr, 
//		SvgUnitOffsetX( endPoint.x ), SvgUnitOffsetY( endPoint.y ),
//		SvgUnitOffsetX( startPoint.x ), SvgUnitOffsetY( startPoint.y ) );
//
//	// _xZkqqHx_iMmKjFjEjFkKiCpAiPgPjHmN_xHqqkZx_
//	return printSvgArcLineBase( printClipPath );
//----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	const FCObjArc* pArc = (const FCObjArc*)_objectExp;
	// _xZkqqHx_jCiGjAfDiImKjChF_xHqqkZx_
	double cx = pArc->GetCenterX();
	double cy = pArc->GetCenterY();

	// _xZkqqHx_iDfEiDeDiDfJ_xHqqkZx_
//----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	fmmetol aHAxisX = pArc->GetHAxisX(); // rx
//	fmmetol aVAxisY = pArc->GetVAxisY(); // ry
//----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	mmetol aHAxisX = pArc->GetHAxisX(); // rx
	mmetol aVAxisY = pArc->GetVAxisY(); // ry
//----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

	// _xZkqqHx_iKeKiOgOiBeBiPeJjHlJiKhAjDhI_xHqqkZx_
	double bgnRRad = pArc->GetArcBgnR() * M_PI;
	double endRRad = pArc->GetArcEndR() * M_PI;

	// _xZkqqHx_iKeKiOgOiBeBiPeJjHlJjDfP_xHqqkZx_
	DBLPoint startPoint, endPoint;
	startPoint.x = cx + aHAxisX * cos( bgnRRad );
	startPoint.y = cy + aVAxisY * sin( bgnRRad );
	endPoint.x = cx + aHAxisX * cos( endRRad );
	endPoint.y = cy + aVAxisY * sin( endRRad );

// 06.07.04 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	fprintf( _fptr, "<path d='" );

	//-------- _xZkqqHx_jClMjApMjFjEjFkKiCpAiPgPjHmN_xHqqkZx_ ----------
	char *formatStr = getFormatString( "M %n,%n %n,%n " );
	fprintf( _fptr, formatStr, 
		SvgUnitOffsetX( endPoint.x ), SvgUnitOffsetY( endPoint.y ),
		SvgUnitOffsetX( startPoint.x ), SvgUnitOffsetY( startPoint.y ) );

	// _xZkqqHx_iMmKjFjEjFkKiCpAiPgPjHmN_xHqqkZx_
	return printSvgArcLineBase( printClipPath );
//----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

} // end of SvgExportInfo::printSvgChord



// _xZkqqHx_iMmKiCmMiCnNiCmMiPgPjHmNiCmMiLkEjCmKjFjEjFkK_xHqqkZx_
int SvgExportInfo::printSvgArcLineBase( bool printClipPath ) {

//----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_jCiGjAfDiImKjChF_xHqqkZx_
//	double cx = _objectExp->GetCenterX();
//	double cy = _objectExp->GetCenterY();
//
//	// _xZkqqHx_iKeKiOgOiBeBiPeJjHlJiKhAjDhI_xHqqkZx_
//	double bgnRRad = _objectExp->GetArcBgnR() * M_PI;
//	double endRRad = _objectExp->GetArcEndR() * M_PI;
//
//	// _xZkqqHx_iDfEiDeDiDfJ_xHqqkZx_
////----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////	fmmetol aHAxisX = _objectExp->GetHAxisX(); // rx
////	fmmetol aVAxisY = _objectExp->GetVAxisY(); // ry
////----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//	mmetol aHAxisX = _objectExp->GetHAxisX(); // rx
//	mmetol aVAxisY = _objectExp->GetVAxisY(); // ry
////----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//
//	// _xZkqqHx_iPeJjHlJjDfP_xHqqkZx_
//	DBLPoint endPoint;
//	endPoint.x = cx + aHAxisX * cos( endRRad );
//	endPoint.y = cy + aVAxisY * sin( endRRad );
//
//	double x_axis_rotation = 0.0; // printTransform_xZkqqHx_iCmFjBoDjBnG_xHqqkZx_
//	
//	int large_arc_flag = 0;
//	if ( M_PI < endRRad - bgnRRad || 
//		( -M_PI < endRRad - bgnRRad && endRRad - bgnRRad < 0 ) ) {
//		large_arc_flag = 1;
//	}
//
//	int sweep_flag = 1;
//
//	//-------- _xZkqqHx_iMmKjFjEjFkKiCpAiPgPjHmN_xHqqkZx_ ----------
//	char *formatStr = getFormatString( "A %n,%n %n %d %d %n %n' " );
//	fprintf( _fptr, formatStr, 
//		SvgUnit( aHAxisX ), SvgUnit( aVAxisY ),
//		RADRATE2DEG( x_axis_rotation ), large_arc_flag, sweep_flag,
//		SvgUnitOffsetX( endPoint.x ), SvgUnitOffsetY( endPoint.y ) );
//
//	//-------- _xZkqqHx_iDfIiDfOiDeDiDiLiCpAiPgPjHmN_xHqqkZx_ ----------
//	if ( false == printClipPath ) {
//		printStyle();
//	}
//
//	//-------- _xZkqqHx_iJpBjDfNiBeBiDfIiDeMiDiFiBfLiCpAiPgPjHmN_xHqqkZx_ ----------
//	printTransform( SI_NO_TEXT_ANGLE_TRANSFORM );
//
//	//-------- _xZkqqHx_iDfOiDePjFmCiClGiCoJ_xHqqkZx_ ----------
//	fprintf( _fptr, "/>\n" );
//
//	return SVGEXPORT_OK;
//----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	const FCObjArc* pArc = (const FCObjArc*)_objectExp;
	// _xZkqqHx_jCiGjAfDiImKjChF_xHqqkZx_
	double cx = pArc->GetCenterX();
	double cy = pArc->GetCenterY();

	// _xZkqqHx_iKeKiOgOiBeBiPeJjHlJiKhAjDhI_xHqqkZx_
	double bgnRRad = pArc->GetArcBgnR() * M_PI;
	double endRRad = pArc->GetArcEndR() * M_PI;

	// _xZkqqHx_iDfEiDeDiDfJ_xHqqkZx_
//----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	fmmetol aHAxisX = pArc->GetHAxisX(); // rx
//	fmmetol aVAxisY = pArc->GetVAxisY(); // ry
//----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	mmetol aHAxisX = pArc->GetHAxisX(); // rx
	mmetol aVAxisY = pArc->GetVAxisY(); // ry
//----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

	// _xZkqqHx_iPeJjHlJjDfP_xHqqkZx_
	DBLPoint endPoint;
	endPoint.x = cx + aHAxisX * cos( endRRad );
	endPoint.y = cy + aVAxisY * sin( endRRad );

	double x_axis_rotation = 0.0; // printTransform_xZkqqHx_iCmFjBoDjBnG_xHqqkZx_
	
	int large_arc_flag = 0;
	if ( M_PI < endRRad - bgnRRad || 
		( -M_PI < endRRad - bgnRRad && endRRad - bgnRRad < 0 ) ) {
		large_arc_flag = 1;
	}

	int sweep_flag = 1;

	//-------- _xZkqqHx_iMmKjFjEjFkKiCpAiPgPjHmN_xHqqkZx_ ----------
	char *formatStr = getFormatString( "A %n,%n %n %d %d %n %n' " );
	fprintf( _fptr, formatStr, 
		SvgUnit( aHAxisX ), SvgUnit( aVAxisY ),
		RADRATE2DEG( x_axis_rotation ), large_arc_flag, sweep_flag,
		SvgUnitOffsetX( endPoint.x ), SvgUnitOffsetY( endPoint.y ) );

	//-------- _xZkqqHx_iDfIiDfOiDeDiDiLiCpAiPgPjHmN_xHqqkZx_ ----------
	if ( false == printClipPath ) {
		printStyle();
	}

	//-------- _xZkqqHx_iJpBjDfNiBeBiDfIiDeMiDiFiBfLiCpAiPgPjHmN_xHqqkZx_ ----------
	printTransform( SI_NO_TEXT_ANGLE_TRANSFORM );

	//-------- _xZkqqHx_iDfOiDePjFmCiClGiCoJ_xHqqkZx_ ----------
	fprintf( _fptr, "/>\n" );

	return SVGEXPORT_OK;
//----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

} // end of SvgExportInfo::printSvgArcLineBase



// _xZkqqHx_iCmCiCmIiCkKiCmIiCkCiBeCiMmKiCmMiCnN_xHqqkZx_
int SvgExportInfo::printSvgArcLine( bool printClipPath )
{
//----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_jCiGjAfDiImKjChF_xHqqkZx_
//	double cx = _objectExp->GetCenterX();
//	double cy = _objectExp->GetCenterY();
//
//	// _xZkqqHx_iKeKiOgOiKhAjDhI_xHqqkZx_
//	double bgnRRad = _objectExp->GetArcBgnR() * M_PI;
//
//	// _xZkqqHx_iDfEiDeDiDfJ_xHqqkZx_
////----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////	fmmetol aHAxisX = _objectExp->GetHAxisX(); // rx
////	fmmetol aVAxisY = _objectExp->GetVAxisY(); // ry
////----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//	mmetol aHAxisX = _objectExp->GetHAxisX(); // rx
//	mmetol aVAxisY = _objectExp->GetVAxisY(); // ry
////----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//
//	// _xZkqqHx_iKeKiOgOjDfP_xHqqkZx_
//	DBLPoint startPoint;
//	startPoint.x = cx + aHAxisX * cos( bgnRRad );
//	startPoint.y = cy + aVAxisY * sin( bgnRRad );
//
//	//-------- _xZkqqHx_iKeKiOgOjFjEjFkKiCpAiPgPjHmN_xHqqkZx_ ----------
//	char *formatStr = getFormatString( "M %n,%n " );
//	fprintf( _fptr, formatStr, 
//		SvgUnitOffsetX( startPoint.x ), SvgUnitOffsetY( startPoint.y ) );
//
//	return printSvgArcLineBase( printClipPath );
//----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	const FCObjArc* pArc = (const FCObjArc*)_objectExp;
	// _xZkqqHx_jCiGjAfDiImKjChF_xHqqkZx_
	double cx = pArc->GetCenterX();
	double cy = pArc->GetCenterY();

	// _xZkqqHx_iKeKiOgOiKhAjDhI_xHqqkZx_
	double bgnRRad = pArc->GetArcBgnR() * M_PI;

	// _xZkqqHx_iDfEiDeDiDfJ_xHqqkZx_
//----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	fmmetol aHAxisX = pArc->GetHAxisX(); // rx
//	fmmetol aVAxisY = pArc->GetVAxisY(); // ry
//----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	mmetol aHAxisX = pArc->GetHAxisX(); // rx
	mmetol aVAxisY = pArc->GetVAxisY(); // ry
//----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_iKeKiOgOjDfP_xHqqkZx_
	DBLPoint startPoint;
	startPoint.x = cx + aHAxisX * cos( bgnRRad );
	startPoint.y = cy + aVAxisY * sin( bgnRRad );

	FCBaseArrow* pArrowF = NULL;
	FCBaseArrow* pArrowB = NULL;
	if (!printClipPath)
	//----- _xZkqqHx_iDeOiDiKiDgCiDhGiPgPjHmNiImIiKePiCmMiPoKiNiH_xHqqkZx_ -----
	{
		FCMmPolyBezier polyBezier;
		BOOL bIsClose;
		BOOL bIsWidePoly;
		// _xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjHnGiKhDiCmMiDhIiDfHiDeGiLmIjApMiCpAiOoGjDlOiBeC_xHqqkZx_
		pArc->NewArrowedObjBezier(	polyBezier,
									bIsClose,
									pArrowF,
									pArrowB,
									bIsWidePoly);
	}
	int result = SVGEXPORT_OK;
  for (;;)
  {
	// _xZkqqHx_jGoOiIpDiCmMiJlKiPpMiCoIiCpAiPgPjHmNiBeC_xHqqkZx_
	result = printSvgPreArrow(pArrowF, pArrowB);
	if (result != SVGEXPORT_OK) break;

	fprintf( _fptr, "<path d='" );

	//-------- _xZkqqHx_iKeKiOgOjFjEjFkKiCpAiPgPjHmN_xHqqkZx_ ----------
	char *formatStr = getFormatString("M %n,%n ");
	fprintf(_fptr, formatStr,
			SvgUnitOffsetX(startPoint.x),
			SvgUnitOffsetY(startPoint.y));
	result = printSvgArcLineBase(printClipPath);
	if (result != SVGEXPORT_OK) break;
	result = printSvgMainArrow(pArrowF, pArrowB);
	if (result != SVGEXPORT_OK) break;
	result = printSvgPostArrow(pArrowF, pArrowB);
	if (result != SVGEXPORT_OK) break;
	break;
  }
	if (pArrowF != NULL) pArrowF->Release();
	if (pArrowB != NULL) pArrowB->Release();
	SE_RESULT_CHECK(result);
	return SVGEXPORT_OK;

//----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

} // end of SvgExportInfo::printSvgArcLine



int SvgExportInfo::printSvgArc( bool printClipPath ) {

//----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_iKeKiOgOiBeBiPeJjHlJiKhAjDhI_xHqqkZx_
//	double bgnRRad = _objectExp->GetArcBgnR();
//	double endRRad = _objectExp->GetArcEndR();
//
//	// _xZkqqHx_jBoFiCkLiClD_xHqqkZx_
////----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////	fmmetol aHAxisX = _objectExp->GetHAxisX();
////	fmmetol aVAxisX = _objectExp->GetVAxisX();
////	fmmetol aVAxisY = _objectExp->GetVAxisY();
////----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//	mmetol aHAxisX = _objectExp->GetHAxisX();
//	mmetol aVAxisY = _objectExp->GetVAxisY();
////----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//
//	if ( bgnRRad == endRRad ) {
//		if ( aHAxisX == aVAxisY ) {
//			// _xZkqqHx_iJhO_xHqqkZx_
//			return printSvgCircle( printClipPath );
//		} else {
//			// _xZkqqHx_jBmIiJhO_xHqqkZx_
//			return printSvgEllipse( printClipPath );
//		}
//	}
//
//	fprintf( _fptr, "<path d='" );
//
//	short arcType = _objectExp->GetArcType();
//
//	switch ( arcType ) {
//	case FDOA_PIE : // _xZkqqHx_jAoOiMgAiCmJiCmCiCmIiCkO_xHqqkZx_
//		return printSvgPie( printClipPath );
//		break;
//	case FDOA_CHORD : // _xZkqqHx_jClMjApMiCmFiCmCiCmIiCkO_xHqqkZx_
//		return printSvgChord( printClipPath );
//		break;
//	case FDOA_ARC : // _xZkqqHx_iCmCiCmIiCkKiCmIiCkCiBeCiMmKiCmMiCnN_xHqqkZx_
//		return printSvgArcLine( printClipPath );
//		break;
//	default : // _xZkqqHx_iDeHiDiJiBfL_xHqqkZx_
//		fprintf( _fptr, "'/>\n" );
//		return SE_ERROR_RETURN( SVGEXPORT_ERROR );
//	}
//
//	//return SVGEXPORT_OK;
//----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	const FCObjArc* pArc = (const FCObjArc*)_objectExp;
	// _xZkqqHx_jEhHiMgJjAhNiCpA_xHqqkZx_PNG_xZkqqHx_iCmFiPgPjHmNiBeC_xHqqkZx_
	if (svgExportOption._printBackpictAsPng &&
		pArc->GetEmfImage() != FD_EMF_IMAGE_UNUSE)
		return printSvgOLE(printClipPath);

	// _xZkqqHx_iKeKiOgOiBeBiPeJjHlJiKhAjDhI_xHqqkZx_
	double bgnRRad = pArc->GetArcBgnR();
	double endRRad = pArc->GetArcEndR();

	// _xZkqqHx_jBoFiCkLiClD_xHqqkZx_
//----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	fmmetol aHAxisX = pArc->GetHAxisX();
//	fmmetol aVAxisX = pArc->GetVAxisX();
//	fmmetol aVAxisY = pArc->GetVAxisY();
//----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	mmetol aHAxisX = pArc->GetHAxisX();
	mmetol aVAxisY = pArc->GetVAxisY();
//----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

	if ( bgnRRad == endRRad ) {
		if ( aHAxisX == aVAxisY ) {
			// _xZkqqHx_iJhO_xHqqkZx_
			return printSvgCircle( printClipPath );
		} else {
			// _xZkqqHx_jBmIiJhO_xHqqkZx_
			return printSvgEllipse( printClipPath );
		}
	}

// 06.07.04 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	fprintf( _fptr, "<path d='" );

	short arcType = pArc->GetArcType();

	switch ( arcType ) {
	case FDOA_PIE : // _xZkqqHx_jAoOiMgAiCmJiCmCiCmIiCkO_xHqqkZx_
		return printSvgPie( printClipPath );
		break;
	case FDOA_CHORD : // _xZkqqHx_jClMjApMiCmFiCmCiCmIiCkO_xHqqkZx_
		return printSvgChord( printClipPath );
		break;
	case FDOA_ARC : // _xZkqqHx_iCmCiCmIiCkKiCmIiCkCiBeCiMmKiCmMiCnN_xHqqkZx_
		return printSvgArcLine( printClipPath );
		break;
	default : // _xZkqqHx_iDeHiDiJiBfL_xHqqkZx_
// 06.07.04 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//		fprintf( _fptr, "'/>\n" );
		return SE_ERROR_RETURN( SVGEXPORT_ERROR );
	}

	//return SVGEXPORT_OK;
//----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

} // end of printSvgArc

//----- 06.07.04 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	SvgExportInfo::printSvgLinePoly
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jClMjApMiCmMiCnNiCmFiNfMjAkMiClDiCoKiCoJjBlNiKhAjApMjFjEjFgJiBeBiIlNiCkCiCmNjClMjApMjFjEjFgJiCpAiPgPjHmNiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	printClipPath	:_xZkqqHx_iDhFiDiJiDfGjDjJiCmMiClNiCnPiCmMiDeOiDiKiDgCiDhDiDjDiDePiPgPjHmNiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	HIROSAWA Masashi _xZkqqHx_iNoMjAkMiBeC_xHqqkZx_
// *			06.07.03 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkMiBeC_xHqqkZx_
// *************************************************************************/
//int SvgExportInfo::printSvgLinePoly( bool printClipPath )
//{
////----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////	fprintf( _fptr, "<polyline points='" );
////
////	int jointSize = _objectExp->GetJointSize();
////	const PolyJoint *polyJointArray = _objectExp->GetJoints();
////
////	for ( int i = 0; i < jointSize; i++ ) {
////		 const PolyJoint *polyJoint = polyJointArray + i;
////
////		// _xZkqqHx_iDeKiDgJiDiBjDfPiCmMiCnNiPgPjHmN_xHqqkZx_
////		char *formatStr = getFormatString( "%n,%n " );
////		fprintf( _fptr, formatStr, SvgUnitOffsetX( polyJoint->m_mmptPivot.x ), 
////			SvgUnitOffsetY( polyJoint->m_mmptPivot.y ) );
////
////	} // for i
////
////	if ( FALSE == _objectExp->GetIsOpenPolyJoint() ) {
////		// _xZkqqHx_jFmCiClGiCoJ_xHqqkZx_
////		char *formatStr = getFormatString( "%n,%n" );
////		fprintf( _fptr, formatStr, SvgUnitOffsetX( polyJointArray->m_mmptPivot.x ), 
////			SvgUnitOffsetY( polyJointArray->m_mmptPivot.y ) );
////	}
////
////	fprintf( _fptr, "' " );
////
////	//-------- _xZkqqHx_iDfIiDfOiDeDiDiLiCpAiPgPjHmN_xHqqkZx_ ----------
////	if ( false == printClipPath ) {
////		printStyle();
////	}
////
////	//-------- _xZkqqHx_iDfOiDePjFmCiClGiCoJ_xHqqkZx_ ----------
////	fprintf( _fptr, "/>\n" );
////
////	return SVGEXPORT_OK;
////----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
////----- 06.07.03 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////	const FCObjPoly* pPoly = (const FCObjPoly*)_objectExp;
////	fprintf( _fptr, "<polyline points='" );
////
////	int jointSize = pPoly->GetJointSize();
////	const FCPolyJoint *polyJointArray = pPoly->GetJoints();
////
////	for ( int i = 0; i < jointSize; i++ ) {
////		 const FCPolyJoint *polyJoint = polyJointArray + i;
////
////		// _xZkqqHx_iDeKiDgJiDiBjDfPiCmMiCnNiPgPjHmN_xHqqkZx_
////		char *formatStr = getFormatString( "%n,%n " );
////		fprintf( _fptr, formatStr, SvgUnitOffsetX( polyJoint->m_mmptPivot.x ), 
////			SvgUnitOffsetY( polyJoint->m_mmptPivot.y ) );
////
////	} // for i
////
////	if ( FALSE == pPoly->GetIsOpenPolyJoint() ) {
////		// _xZkqqHx_jFmCiClGiCoJ_xHqqkZx_
////		char *formatStr = getFormatString( "%n,%n" );
////		fprintf( _fptr, formatStr, SvgUnitOffsetX( polyJointArray->m_mmptPivot.x ), 
////			SvgUnitOffsetY( polyJointArray->m_mmptPivot.y ) );
////	}
////
////	fprintf( _fptr, "' " );
////
////	//-------- _xZkqqHx_iDfIiDfOiDeDiDiLiCpAiPgPjHmN_xHqqkZx_ ----------
////	if ( false == printClipPath ) {
////		printStyle();
////	}
////
////	//-------- _xZkqqHx_iDfOiDePjFmCiClGiCoJ_xHqqkZx_ ----------
////	fprintf( _fptr, "/>\n" );
////----- 06.07.03 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//	const FCObjFigure* pFig = (const FCObjFigure*)_objectExp;
//	//-------- _xZkqqHx_iImKjChFiCpAiPgPjHmN_xHqqkZx_ ----------
//	FCMmPolyBezier polyBezier;
//	BOOL bIsClose;
//	FCBaseArrow* pArrowF = NULL;
//	FCBaseArrow* pArrowB = NULL;
//	BOOL bIsWidePoly;
//	// _xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjHnGiKhDiCmMiDhIiDfHiDeGiLmIjApMiCpAiOoGjDlOiBeC_xHqqkZx_
//	pFig->NewArrowedObjBezier(	polyBezier,
//								bIsClose,
//								pArrowF,
//								pArrowB,
//								bIsWidePoly);
//	int result = SVGEXPORT_OK;
//  for (;;)
//  {
//	if (polyBezier.size() < 4)
//	{
//		break;
//	}
//	// _xZkqqHx_jGoOiIpDiCmMiJlKiPpMiCoIiCpAiPgPjHmNiBeC_xHqqkZx_
//	result = printSvgPreArrow(pArrowF, pArrowB);
//	if (result != SVGEXPORT_OK) break;
//	if (polyBezier.size() == 4)
//	{
//		const DBLPoint mmptF = polyBezier[1];	// _xZkqqHx_iOgOjDfPiBeC_xHqqkZx_
//		const DBLPoint mmptB = polyBezier[3];	// _xZkqqHx_iPeJjDfPiBeC_xHqqkZx_
//		//----- _xZkqqHx_jApMiCpAiPgPjHmN_xHqqkZx_ -----
//		fprintf(_fptr, "<line ");
//		char *formatStr = getFormatString("x1='%n' y1='%n' ");
//		fprintf(_fptr, formatStr, SvgUnitOffsetX(mmptF.x), SvgUnitOffsetY(mmptF.y));
//		formatStr = getFormatString("x2='%n' y2='%n' ");
//		fprintf(_fptr, formatStr, SvgUnitOffsetX(mmptB.x), SvgUnitOffsetY(mmptB.y));
//	} else
//	{
//		fprintf(_fptr, "<polyline points='");
//		for (int i = 1; i < polyBezier.size(); i++)
//		{
//			// _xZkqqHx_iDeKiDgJiDiBjDfPiCmMiCnNiPgPjHmN_xHqqkZx_
//			const DBLPoint mmpt = polyBezier[i];
//			char *formatStr = getFormatString("%n,%n ");
//			fprintf(_fptr, formatStr, SvgUnitOffsetX(mmpt.x), SvgUnitOffsetY(mmpt.y));
//		} // for i
//		fprintf(_fptr, "' ");
//	}
//	//-------- _xZkqqHx_iDfIiDfOiDeDiDiLiCpAiPgPjHmN_xHqqkZx_ ----------
//	if (false == printClipPath)
//		printStyle();
//	//-------- _xZkqqHx_iDfOiDePjFmCiClGiCoJ_xHqqkZx_ ----------
//	fprintf( _fptr, "/>\n" );
//	//-------- _xZkqqHx_jGoOiIpDiPgPjHmN_xHqqkZx_ ----------------
//	result = printSvgMainArrow(pArrowF, pArrowB);
//	if (result != SVGEXPORT_OK) break;
//	result = printSvgPostArrow(pArrowF, pArrowB);
//	if (result != SVGEXPORT_OK) break;
//	break;
//  }
//	if (pArrowF != NULL) pArrowF->Release();
//	if (pArrowB != NULL) pArrowB->Release();
//	SE_RESULT_CHECK(result);
//	return SVGEXPORT_OK;
////----- 06.07.03 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
////----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//} // end of SvgExportInfo::printSvgLinePoly
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	SvgExportInfo::printSvgCubicBezierPoly
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iLmIjApMiCmFiNfMjAkMiClDiCoKiCoJjBlNiKhAjApMiCpAiPgPjHmNiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	printClipPath	:_xZkqqHx_iDhFiDiJiDfGjDjJiCmMiClNiCnPiCmMiDeOiDiKiDgCiDhDiDjDiDePiPgPjHmNiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	HIROSAWA Masashi _xZkqqHx_iNoMjAkMiBeC_xHqqkZx_
// *			06.07.03 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkMiBeC_xHqqkZx_
// *************************************************************************/
//int SvgExportInfo::printSvgCubicBezierPoly( bool printClipPath )
//{
////----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////	fprintf( _fptr, "<path d='" );
////
////	int jointSize = _objectExp->GetJointSize();
////	const PolyJoint *polyJointArray = _objectExp->GetJoints();
////
////	// _xZkqqHx_iKeKiOgOjDfPiPgPjHmN_xHqqkZx_
////	char *formatStr = getFormatString( "M %n,%n " );
////	fprintf( _fptr, formatStr, SvgUnitOffsetX( polyJointArray->m_mmptPivot.x ), 
////		SvgUnitOffsetY( polyJointArray->m_mmptPivot.y ) );
////
////	const PolyJoint *polyJoint = (PolyJoint*)polyJointArray;
////
////	int fin = _objectExp->GetIsOpenPolyJoint() ? jointSize-1 : jointSize;
////
////	// for ( int i = 0; i < jointSize - 1; i++ ) {
////	for ( int i = 0; i < fin; i++ ) {
////		 //PolyJoint *nextPolyJoint = (PolyJoint*)(polyJointArray + i + 1);
////		const PolyJoint *nextPolyJoint = (i == jointSize-1) ? polyJointArray : polyJointArray + i + 1;
////
////		// _xZkqqHx_jAkHiMoEjDfPiPgPjHmN_xHqqkZx_
////		formatStr = getFormatString( "C %n,%n %n,%n %n,%n " );
////		fprintf( _fptr, formatStr, 
////			SvgUnitOffsetX( polyJoint->m_mmptPivot.x + polyJoint->m_mmptNext.x ), 
////			SvgUnitOffsetY( polyJoint->m_mmptPivot.y + polyJoint->m_mmptNext.y ), 
////			SvgUnitOffsetX( nextPolyJoint->m_mmptPivot.x + nextPolyJoint->m_mmptPrev.x ),
////			SvgUnitOffsetY( nextPolyJoint->m_mmptPivot.y + nextPolyJoint->m_mmptPrev.y ),
////			SvgUnitOffsetX( nextPolyJoint->m_mmptPivot.x ),
////			SvgUnitOffsetY( nextPolyJoint->m_mmptPivot.y ) );
////
////		polyJoint = nextPolyJoint;
////
////	} // for i
////
////	 if ( FALSE == _objectExp->GetIsOpenPolyJoint() ) {
////		// _xZkqqHx_jFmCiClGiCoJ_xHqqkZx_
////		 fprintf( _fptr, "z" );
////	}
////
////	fprintf( _fptr, "' " );
////
////	//-------- _xZkqqHx_iDfIiDfOiDeDiDiLiCpAiPgPjHmN_xHqqkZx_ ----------
////	if ( false == printClipPath ) {
////		printStyle();
////	}
////
////	//-------- _xZkqqHx_iDfOiDePjFmCiClGiCoJ_xHqqkZx_ ----------
////	fprintf( _fptr, "/>\n" );
////
////	return SVGEXPORT_OK;
////----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//	const FCObjPoly* pPoly = (const FCObjPoly*)_objectExp;
//	fprintf(_fptr, "<path d='");
//
//	int jointSize = pPoly->GetJointSize();
//	const FCPolyJoint *polyJointArray = pPoly->GetJoints();
//
//	// _xZkqqHx_iKeKiOgOjDfPiPgPjHmN_xHqqkZx_
//	char *formatStr = getFormatString("M %n,%n ");
//	fprintf(_fptr,
//			formatStr,
//			SvgUnitOffsetX(polyJointArray->m_mmptPivot.x),
//			SvgUnitOffsetY(polyJointArray->m_mmptPivot.y));
//
//	const FCPolyJoint *polyJoint = (FCPolyJoint*)polyJointArray;
//	// _xZkqqHx_jIeBiMiLjDfPiCmMjAjEiBeCiLmIjApMiCkKjFmCiClGiCmEiCkCiCoJiPoKiNiHiCmNiDiLiBfLiDhGiClDiClJiCoJiClNiCnPiCmJiBhLiCfAiBeC_xHqqkZx_
//	int fin = pPoly->GetIsOpenPolyJoint() ? jointSize-1 : jointSize;
//
//	for (int i = 0; i < fin; i++)
//	{
//		const FCPolyJoint *nextPolyJoint = (i == jointSize-1) ? polyJointArray : polyJointArray + i + 1;
//		// _xZkqqHx_jAkHiMoEjDfPiPgPjHmN_xHqqkZx_
//		formatStr = getFormatString( "C %n,%n %n,%n %n,%n " );
//		fprintf(_fptr, formatStr, 
//				SvgUnitOffsetX( polyJoint->m_mmptPivot.x + polyJoint->m_mmptNext.x ),
//				SvgUnitOffsetY( polyJoint->m_mmptPivot.y + polyJoint->m_mmptNext.y ),
//				SvgUnitOffsetX( nextPolyJoint->m_mmptPivot.x + nextPolyJoint->m_mmptPrev.x ),
//				SvgUnitOffsetY( nextPolyJoint->m_mmptPivot.y + nextPolyJoint->m_mmptPrev.y ),
//				SvgUnitOffsetX( nextPolyJoint->m_mmptPivot.x ),
//				SvgUnitOffsetY( nextPolyJoint->m_mmptPivot.y ) );
//		polyJoint = nextPolyJoint;
//	} // for i
//
//	if (FALSE == pPoly->GetIsOpenPolyJoint())
//	{
//		// _xZkqqHx_jFmCiClGiCoJ_xHqqkZx_
//		fprintf(_fptr, "z");
//	}
//
//	fprintf(_fptr, "' ");
//
//	//-------- _xZkqqHx_iDfIiDfOiDeDiDiLiCpAiPgPjHmN_xHqqkZx_ ----------
//	if (false == printClipPath)
//	{
//		printStyle();
//	}
//
//	//-------- _xZkqqHx_iDfOiDePjFmCiClGiCoJ_xHqqkZx_ ----------
//	fprintf( _fptr, "/>\n" );
//
////----- 06.07.03 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
//	//-------- _xZkqqHx_jGoOiIpDiPgPjHmN_xHqqkZx_ ----------------
//	BOOL bIsClose;
//	FCBaseArrow* pArrowF = NULL;
//	FCBaseArrow* pArrowB = NULL;
//	BOOL bIsWidePoly;
//	DBLPointVector vmmptPoly;
//	pPoly->NewArrowedObjPolygon(vmmptPoly, bIsClose, pArrowF, pArrowB,
//								bIsWidePoly, 5.0, NULL, 0);
//	int result = printSvgPreArrow(pArrowF, pArrowB);
//	if (!bIsWidePoly)
//		result = printSvgMainArrow(pArrowF, pArrowB);
//	result = printSvgPostArrow(pArrowF, pArrowB);
//	if (pArrowF != NULL) pArrowF->Release();
//	if (pArrowB != NULL) pArrowB->Release();
//	SE_RESULT_CHECK(result);
////----- 06.07.03 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
//
//	return SVGEXPORT_OK;
////----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//} // end of SvgExportInfo::printSvgCubicBezierPoly
//----- 06.07.04 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	SvgExportInfo::printSvgFigLine
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiNmAjFfHjEhKjHpBiCpAjClMjApMiCmGiClFiCmEiPgPjHmNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	polyBezier		:_xZkqqHx_jHnGiKhDiCmMiDhIiDfHiDeGiLmIjApMiCmMjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			printClipPath	:_xZkqqHx_iDhFiDiJiDfGjDjJiCmMiClNiCnPiCmMiDeOiDiKiDgCiDhDiDjDiDePiPgPjHmNiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			isArrowStyle	:_xZkqqHx_jGoOiIpDiCmMiDfIiDfOiDeDiDiLiPgPjHmNiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iPiIjHjNiCkKjAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_ SVGEXPORT_OK_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	printSvgFigure_xZkqqHx_iKnGjAjEiCmMjFoCiPjFiKnGjAjEiCmGiClFiCmEiOgHiCoNiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.07.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
int SvgExportInfo::printSvgFigLine (const FCMmPolyBezier& polyBezier, bool printClipPath, bool isArrowStyle)
{
	const DBLPoint mmptF = polyBezier[1];	// _xZkqqHx_iOgOjDfPiBeC_xHqqkZx_
	const DBLPoint mmptB = polyBezier[3];	// _xZkqqHx_iPeJjDfPiBeC_xHqqkZx_
	//----- _xZkqqHx_jApMiCpAiPgPjHmN_xHqqkZx_ -----
	fprintf(_fptr, "<line ");
	char *formatStr = getFormatString("x1='%n' y1='%n' ");
	fprintf(_fptr, formatStr, SvgUnitOffsetX(mmptF.x), SvgUnitOffsetY(mmptF.y));
	formatStr = getFormatString("x2='%n' y2='%n' ");
	fprintf(_fptr, formatStr, SvgUnitOffsetX(mmptB.x), SvgUnitOffsetY(mmptB.y));
	//-------- _xZkqqHx_iDfIiDfOiDeDiDiLiCpAiPgPjHmN_xHqqkZx_ ----------
	if (!printClipPath)
		printStyle(isArrowStyle);
	//-------- _xZkqqHx_iDfOiDePjFmCiClGiCoJ_xHqqkZx_ ----------
	fprintf( _fptr, "/>\n" );
	return SVGEXPORT_OK;
} // SvgExportInfo::printSvgFigLine.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	SvgExportInfo::printSvgFigPoly
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiNmAjFfHjEhKjHpBiCpAjBlNiKhAjApMiCmGiClFiCmEiPgPjHmNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	polyBezier		:_xZkqqHx_jHnGiKhDiCmMiDhIiDfHiDeGiLmIjApMiCmMjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			printClipPath	:_xZkqqHx_iDhFiDiJiDfGjDjJiCmMiClNiCnPiCmMiDeOiDiKiDgCiDhDiDjDiDePiPgPjHmNiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			isArrowStyle	:_xZkqqHx_jGoOiIpDiCmMiDfIiDfOiDeDiDiLiPgPjHmNiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iPiIjHjNiCkKjAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_ SVGEXPORT_OK_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	printSvgFigure_xZkqqHx_iKnGjAjEiCmMjFoCiPjFiKnGjAjEiCmGiClFiCmEiOgHiCoNiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.07.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
int SvgExportInfo::printSvgFigPoly (const FCMmPolyBezier& polyBezier, bool printClipPath, bool isArrowStyle)
{
	fprintf(_fptr, "<polyline points='");
	for (int iC = 0; iC < polyBezier.size(); iC += 3)
	{
		// _xZkqqHx_iDeKiDgJiDiBjDfPiCmMiCnNiPgPjHmN_xHqqkZx_
		const DBLPoint mmpt = polyBezier[iC];
		char *formatStr = getFormatString("%n,%n ");
		fprintf(_fptr, formatStr, SvgUnitOffsetX(mmpt.x), SvgUnitOffsetY(mmpt.y));
	} // for iC
	fprintf(_fptr, "' ");
	//-------- _xZkqqHx_iDfIiDfOiDeDiDiLiCpAiPgPjHmN_xHqqkZx_ ----------
	if (!printClipPath)
		printStyle(isArrowStyle);
	//-------- _xZkqqHx_iDfOiDePjFmCiClGiCoJ_xHqqkZx_ ----------
	fprintf(_fptr, "/>\n");
	return SVGEXPORT_OK;
} // SvgExportInfo::printSvgFigPoly.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	SvgExportInfo::printSvgFigBezier
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiNmAjFfHjEhKjHpBiCpAjBlNiKhAjApMiCmGiClFiCmEiPgPjHmNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	polyBezier		:_xZkqqHx_jHnGiKhDiCmMiDhIiDfHiDeGiLmIjApMiCmMjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bIsClose		:_xZkqqHx_iDhIiDfHiDeGiLmIjApMiCkKjFmCiClGiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *			printClipPath	:_xZkqqHx_iDhFiDiJiDfGjDjJiCmMiClNiCnPiCmMiDeOiDiKiDgCiDhDiDjDiDePiPgPjHmNiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			isArrowStyle	:_xZkqqHx_jGoOiIpDiCmMiDfIiDfOiDeDiDiLiPgPjHmNiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iPiIjHjNiCkKjAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_ SVGEXPORT_OK_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	printSvgFigure_xZkqqHx_iKnGjAjEiCmMjFoCiPjFiKnGjAjEiCmGiClFiCmEiOgHiCoNiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.07.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
int SvgExportInfo::printSvgFigBezier (const FCMmPolyBezier& polyBezier, bool bIsClose, bool printClipPath, bool isArrowStyle)
{
	fprintf(_fptr, "<path d='");
	// _xZkqqHx_iKeKiOgOjDfPiPgPjHmN_xHqqkZx_
	char *formatStr = getFormatString("M %n,%n ");
	fprintf(_fptr,
			formatStr,
			SvgUnitOffsetX(polyBezier[0].x),
			SvgUnitOffsetY(polyBezier[0].y));

	int iC;
	for (iC = 1; iC < polyBezier.size(); iC += 3)
	{
		// _xZkqqHx_jAkHiMoEjDfPiPgPjHmN_xHqqkZx_
		formatStr = getFormatString("C %n,%n %n,%n %n,%n ");
		fprintf(_fptr, formatStr, 
				SvgUnitOffsetX(polyBezier[iC].x),
				SvgUnitOffsetY(polyBezier[iC].y),
				SvgUnitOffsetX(polyBezier[iC + 1].x),
				SvgUnitOffsetY(polyBezier[iC + 1].y),
				SvgUnitOffsetX(polyBezier[iC + 2].x),
				SvgUnitOffsetY(polyBezier[iC + 2].y));
	} // for iC
	if (bIsClose)
		fprintf(_fptr, "z");	// _xZkqqHx_jFmCiClGiCoJ_xHqqkZx_
	fprintf(_fptr, "' ");
	//-------- _xZkqqHx_iDfIiDfOiDeDiDiLiCpAiPgPjHmN_xHqqkZx_ ----------
	if (!printClipPath)
		printStyle(isArrowStyle);
	//-------- _xZkqqHx_iDfOiDePiCpAjFmCiClGiCoJ_xHqqkZx_ ----------
	fprintf( _fptr, "/>\n" );
	return SVGEXPORT_OK;
} // SvgExportInfo::printSvgFigBezier.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	SvgExportInfo::printSvgFigLPB
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiNmAjFfHjEhKjHpBiCkKjClMjApMiBeFjBlNiKhAjApMiBeFiDhIiDfHiDeGiLmIjApMiCkJiCpAjElLjCgGiClFiBeBiClLiCoKiCmJ_xHqqkZx_
 *			_xZkqqHx_iJjOiClGiCmEiPgPjHmNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	polyBezier		:_xZkqqHx_jHnGiKhDiCmMiDhIiDfHiDeGiLmIjApMiCmMjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bIsClose		:_xZkqqHx_iDhIiDfHiDeGiLmIjApMiCkKjFmCiClGiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *			printClipPath	:_xZkqqHx_iDhFiDiJiDfGjDjJiCmMiClNiCnPiCmMiDeOiDiKiDgCiDhDiDjDiDePiPgPjHmNiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			isArrowStyle	:_xZkqqHx_jGoOiIpDiCmMiDfIiDfOiDeDiDiLiPgPjHmNiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iPiIjHjNiCkKjAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_ SVGEXPORT_OK_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	printSvgFigure_xZkqqHx_iKnGjAjEiCmMjFoCiPjFiKnGjAjEiCmGiClFiCmEiOgHiCoNiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.07.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
int SvgExportInfo::printSvgFigLPB (const FCMmPolyBezier& polyBezier, bool bIsClose, bool printClipPath, bool isArrowStyle)
{
	// _xZkqqHx_jClMjApMiCmMiCnNiCmFiNfMjAkMiClDiCoKiCoJjBlNiKhAjApMiCkJiBeI_xHqqkZx_
	bool bIsPolyline = true;
	int iC;
	for (iC = 0; bIsPolyline && iC < polyBezier.size(); iC += 3)
	{
		if (!abouteq(polyBezier[iC], polyBezier[iC + 1]) ||
			!abouteq(polyBezier[iC + 2], polyBezier[iC + 3]))
			bIsPolyline = false;
	}
	int result;
	if (bIsPolyline)
	//----- _xZkqqHx_jClMjApMiCmMiCnNiCmFiNfMjAkMiClDiCoKiCoJjBlNiKhAjApMiCmMiPoKiNiH_xHqqkZx_ -----
	{
		if (polyBezier.size() == 4)
			result = printSvgFigLine(polyBezier, printClipPath, isArrowStyle);
		else
			result = printSvgFigPoly(polyBezier, printClipPath, isArrowStyle);
	} else
	//----- _xZkqqHx_iDhIiDfHiDeGiLmIjApMiCmMiPoKiNiH_xHqqkZx_ -----
	{
		result = printSvgFigBezier(polyBezier, bIsClose, printClipPath, isArrowStyle);
	}
	return result;
} // SvgExportInfo::printSvgFigLPB.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	SvgExportInfo::printSvgFigure
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	FCObjFigure_xZkqqHx_iDeOiDiJiDfIiCmJjBkOiClHiCoJiDeJiDhFiDfHiDeGiDeOiDgHiCpAiPgPjHmNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	printClipPath	:_xZkqqHx_iDhFiDiJiDfGjDjJiCmMiClNiCnPiCmMiDeOiDiKiDgCiDhDiDjDiDePiPgPjHmNiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iPiIjHjNiCkKjAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_ SVGEXPORT_OK_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	FCObjFigure_xZkqqHx_iDeOiDiJiDfIiCmJjBkOiClHiCoJiDeJiDhFiDfHiDeGiDeOiDgHiCmFiCkAiCoKiCmOiBeBjClMjApMiBeBjBlNiKhAjApMiBeB_xHqqkZx_
 *			_xZkqqHx_iIlNiCkCiCmNiDhIiDfHiDeGiLmIjApMiCmGiClFiCmEiPgPjHmNiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iJhOiMmKiBeBiLoJiMgAiDeJiDhFiDfHiDeGiDeOiDgHiCmIiCmHiCoAiPgPjHmNiCmFiCkLiCoJiCkKiBeBiJhOiMmKiCoCiLoJiMgAiCmMjBkOjAkLiCkK_xHqqkZx_
 *			_xZkqqHx_iOlIiCoNiCoKiBeBiDhIiDfHiDeGiLmIjApMiCmGiClFiCmEiPgPjHmNiClDiCoKiCmEiClFiCnMiCkEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.07.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
int SvgExportInfo::printSvgFigure (bool printClipPath)
{
	const FCObjFigure* pFig = (const FCObjFigure*)_objectExp;
	// _xZkqqHx_jEhHiMgJjAhNiCpA_xHqqkZx_PNG_xZkqqHx_iCmFiPgPjHmNiBeC_xHqqkZx_
	if (svgExportOption._printBackpictAsPng &&
		pFig->GetEmfImage() != FD_EMF_IMAGE_UNUSE)
		return printSvgOLE(printClipPath);
	//-------- _xZkqqHx_iImKjChFiCpAiPgPjHmN_xHqqkZx_ ----------
	FCMmPolyBezier polyBezier;
	BOOL bIsClose;
	FCBaseArrow* pArrowF = NULL;
	FCBaseArrow* pArrowB = NULL;
	BOOL bIsWidePoly;
	// _xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjHnGiKhDiCmMiDhIiDfHiDeGiLmIjApMiCpAiOoGjDlOiBeC_xHqqkZx_
	pFig->NewArrowedObjBezier(	polyBezier,
								bIsClose,
								pArrowF,
								pArrowB,
								bIsWidePoly);
	if (printClipPath)
	//----- _xZkqqHx_iDeOiDiKiDgCiDhGiPgPjHmNiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jGoOiIpDiCpAiPgPjHmNiClFiCmIiCkCiCoGiCkEiNoNiPjMiBeC_xHqqkZx_
		if (pArrowF != NULL) pArrowF->Release();
		if (pArrowB != NULL) pArrowB->Release();
		pArrowF = NULL;
		pArrowB = NULL;
	}

	int result = SVGEXPORT_OK;
  for (;;)
  {
	// _xZkqqHx_jGoOiIpDiCmMiJlKiPpMiCoIiCpAiPgPjHmNiBeC_xHqqkZx_
	result = printSvgPreArrow(pArrowF, pArrowB);
	if (result != SVGEXPORT_OK) break;

	// _xZkqqHx_iOhHjCoIiClDiCoKiClNiNmAjFfHjEhKjHpBiCkKjClMjApMiBeFjBlNiKhAjApMiBeFiDhIiDfHiDeGiLmIjApMiCkJiCpAjElLjCgGiClFiBeBiClLiCoKiCmJ_xHqqkZx_
	// _xZkqqHx_iJjOiClGiCmEiPgPjHmNiClHiCoJiBeC_xHqqkZx_
	result = printSvgFigLPB(polyBezier, bIsClose ? true : false, printClipPath, false);
	if (result != SVGEXPORT_OK) break;

	//-------- _xZkqqHx_jGoOiIpDiPgPjHmN_xHqqkZx_ ----------------
	if (!bIsWidePoly)
	{
		result = printSvgMainArrow(pArrowF, pArrowB);
		if (result != SVGEXPORT_OK) break;
	}
	result = printSvgPostArrow(pArrowF, pArrowB);
	if (result != SVGEXPORT_OK) break;
	break;
  }
	if (pArrowF != NULL) pArrowF->Release();
	if (pArrowB != NULL) pArrowB->Release();
	SE_RESULT_CHECK(result);
	return SVGEXPORT_OK;
} // SvgExportInfo::printSvgFigure.

// _xZkqqHx_jClMjApMiDhMiDiKiDfDiDjD_xHqqkZx_
#define SVG_LINE_POLY_TYPE	FDJT_BTH_PULL_0

// _xZkqqHx_iCfCiOjP_xHqqkZx_Bezier_xZkqqHx_iDhMiDiKiDfDiDjD_xHqqkZx_
#define SVG_CUBIT_BEZIER_POLY_TYPE	FDJT_ROUND

//----- 06.07.04 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//int SvgExportInfo::printSvgPoly( bool printClipPath )
//{
////----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////	int result;
////
////	int jointSize = _objectExp->GetJointSize();
////	const PolyJoint *polyJointArray = _objectExp->GetJoints();
////
////	bool isPolyLine = true;
////
////	for ( int i = 0; i < jointSize; i++ ) {
////		switch ( _objectExp->GetJoint( i ).m_nType ) {
////		case SVG_LINE_POLY_TYPE :
////			// _xZkqqHx_jClMjApM_xHqqkZx_
////			break;
////		case FDJT_PRE_PULL_0 :
////			if ( jointSize-1 != i ) {
////				isPolyLine = false;
////			}
////			break;
////		case FDJT_PST_PULL_0 :
////			if ( 0 != i ) {
////				isPolyLine = false;
////			}
////			break;
////		case SVG_CUBIT_BEZIER_POLY_TYPE :
////		case FDJT_SHARP :
////			isPolyLine = false;
////			break;
////		default :
////			// _xZkqqHx_iDeHiDiJiBfL_xHqqkZx_
////			return SE_ERROR_RETURN( SVGEXPORT_ERROR );
////		}
////	} // for i
////
////	if ( isPolyLine ) {
////		result = printSvgLinePoly( printClipPath );
////		SE_RESULT_CHECK( result );
////	} else {
////		result = printSvgCubicBezierPoly( printClipPath );
////		SE_RESULT_CHECK( result );
////	}
////
////	//-------- _xZkqqHx_jGoOiIpDiPgPjHmN_xHqqkZx_ ----------------
////	BOOL bIsClose;
////	FCBaseArrow* pArrowF = NULL;
////	FCBaseArrow* pArrowB = NULL;
////	BOOL bIsWidePoly;
////	DBLPointVector vmmptPoly;
////	_objectExp->NewArrowedObjPolygon(vmmptPoly, bIsClose, pArrowF, pArrowB,
////								bIsWidePoly, 5.0, NULL, 0);
////	result = printSvgArrow( pArrowF, pArrowB, &bIsWidePoly );
////	SE_RESULT_CHECK( result );
////
////	return SVGEXPORT_OK;
////----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//	const FCObjPoly* pPoly = (const FCObjPoly*)_objectExp;
//	int result;
//
//	int jointSize = pPoly->GetJointSize();
//	const FCPolyJoint *polyJointArray = pPoly->GetJoints();
//
//	// _xZkqqHx_jClMjApMiCmMiCnNiCmFiNfMjAkMiClDiCoKiCoJjBlNiKhAjApMiCkJiBeIiClLiCoKiCmGiCoAiDhIiDfHiDeGiLmIjApMiCkJiBeI_xHqqkZx_
//	bool isPolyLine = true;
//
//	for ( int i = 0; i < jointSize; i++ )
//	{
//		switch ( pPoly->GetJoint( i ).m_nType )
//		{
//		case SVG_LINE_POLY_TYPE :
//			// _xZkqqHx_jClMjApM_xHqqkZx_
//			break;
//		case FDJT_PRE_PULL_0 :
//			if ( jointSize-1 != i ) {
//				isPolyLine = false;
//			}
//			break;
//		case FDJT_PST_PULL_0 :
//			if ( 0 != i ) {
//				isPolyLine = false;
//			}
//			break;
//		case SVG_CUBIT_BEZIER_POLY_TYPE :
//		case FDJT_SHARP :
//			isPolyLine = false;
//			break;
//		default :
//			// _xZkqqHx_iDeHiDiJiBfL_xHqqkZx_
//			return SE_ERROR_RETURN( SVGEXPORT_ERROR );
//		}
//	} // for i
//
//	if (isPolyLine)
//	//----- _xZkqqHx_jBlNiKhAjApMiCmMiPoKiNiH_xHqqkZx_ -----
//	{
//		result = printSvgLinePoly(printClipPath);
//		SE_RESULT_CHECK( result );
//	} else
//	//----- _xZkqqHx_iLmIjApMiCmMiPoKiNiH_xHqqkZx_ -----
//	{
//		result = printSvgCubicBezierPoly(printClipPath);
//		SE_RESULT_CHECK( result );
//	}
//
////----- 06.07.03 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////	//-------- _xZkqqHx_jGoOiIpDiPgPjHmN_xHqqkZx_ ----------------
////	BOOL bIsClose;
////	FCBaseArrow* pArrowF = NULL;
////	FCBaseArrow* pArrowB = NULL;
////	BOOL bIsWidePoly;
////	DBLPointVector vmmptPoly;
////	pPoly->NewArrowedObjPolygon(vmmptPoly, bIsClose, pArrowF, pArrowB,
////								bIsWidePoly, 5.0, NULL, 0);
////	result = printSvgArrow(pArrowF, pArrowB, &bIsWidePoly);
////	SE_RESULT_CHECK(result);
////----- 06.07.03 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//
//	return SVGEXPORT_OK;
////----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//} // end of printSvgPoly
//----- 06.07.04 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----


int SvgExportInfo::printSvgGroup() {
	
	//-------- _xZkqqHx_iDePiDiLiBfLiDhGiDfOiDeP_xHqqkZx_ ----------
	fprintf( _fptr, "<g>%s\n", getCommentStr( "<!-- group -->" ) );

	FCObjDynabase **objBaseArray = _objectExp->GetMemberArray();
	SvgExportInfo itemSvgExportInfo = *this;

	for ( int i = 0; i < _objectExp->GetMemberSize(); i++ ) {

		itemSvgExportInfo._objectExp = (FCObjDynabase*)objBaseArray[i];
		itemSvgExportInfo.setStyle();
		int result = itemSvgExportInfo.printSVG();
		SE_RESULT_CHECK( result );

	} // for i

	//-------- _xZkqqHx_iDfOiDePjFmCiClGiCoJ_xHqqkZx_ ----------
	fprintf( _fptr, "</g>%s\n", getCommentStr( "<!-- group -->" ) );

	return SVGEXPORT_OK;

} // end of printSvgGroup

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	SvgExportInfo::printSvgTable
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFfMjFjEjFgJiCpAiPgPjHmNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.07.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
int SvgExportInfo::printSvgTable()
{
	//-------- _xZkqqHx_iDePiDiLiBfLiDhGiDfOiDeP_xHqqkZx_ ----------
	fprintf( _fptr, "<g>%s\n", getCommentStr( "<!-- group -->" ) );

	SvgExportInfo itemSvgExportInfo = *this;
	FCObjTable* pTable = (FCObjTable*)_objectExp;
	//----- _xZkqqHx_iDfKiDiLiCpAjFgAiJoG_xHqqkZx_ -----
	for (long lLineIndex = 0; lLineIndex != pTable->GetLineCount(); lLineIndex++)
	{
		for (long lColumnIndex = 0; lColumnIndex != pTable->GetColumnCount(); lColumnIndex++)
		{
			FCObjTextRect* pCell = pTable->GetCell(FCLineColumn(lLineIndex, lColumnIndex));
			// _xZkqqHx_jGjFiPmBiClDiCoKiClNiDiBiDjDiDgPiBfLiCmMiPoKiNiHiCmNiDfIiDeMiDgCiDhGiBeC_xHqqkZx_
			if (pCell == NULL) continue;
			itemSvgExportInfo._objectExp = pCell;
			itemSvgExportInfo.setStyle();
			int result = itemSvgExportInfo.printSVG();
			SE_RESULT_CHECK(result);
		}
	}
	long lFrontIndex;
	long lSideIndex;
	//----- _xZkqqHx_jAiFjFlNiMhCjApMiCpAjFgAiJoG_xHqqkZx_ -----
	for (lFrontIndex = 0; lFrontIndex <= pTable->GetLineCount(); lFrontIndex++)
	{
		for (lSideIndex = 0; lSideIndex != pTable->GetColumnCount(); lSideIndex++)
		{
			FCObjLine* pRuled = pTable->GetRuled(TRUE, FCFrontSide(lFrontIndex, lSideIndex));
			// _xZkqqHx_jGjFiPmBiClDiCoKiClNiDiBiDjDiDgPiBfLiCmMiPoKiNiHiCmNiDfIiDeMiDgCiDhGiBeC_xHqqkZx_
			if (pRuled == NULL) continue;
			itemSvgExportInfo._objectExp = pRuled;
			itemSvgExportInfo.setStyle();
			int result = itemSvgExportInfo.printSVG();
			SE_RESULT_CHECK(result);
		}
	}
	//----- _xZkqqHx_jAiCjClMiMhCjApMiCpAjFgAiJoG_xHqqkZx_ -----
	for (lFrontIndex = 0; lFrontIndex <= pTable->GetColumnCount(); lFrontIndex++)
	{
		for (lSideIndex = 0; lSideIndex != pTable->GetLineCount(); lSideIndex++)
		{
			FCObjLine* pRuled = pTable->GetRuled(FALSE, FCFrontSide(lFrontIndex, lSideIndex));
			// _xZkqqHx_jGjFiPmBiClDiCoKiClNiDiBiDjDiDgPiBfLiCmMiPoKiNiHiCmNiDfIiDeMiDgCiDhGiBeC_xHqqkZx_
			if (pRuled == NULL) continue;
			itemSvgExportInfo._objectExp = pRuled;
			itemSvgExportInfo.setStyle();
			int result = itemSvgExportInfo.printSVG();
			SE_RESULT_CHECK(result);
		}
	}
	//-------- _xZkqqHx_iDfOiDePiCpAjFmCiClGiCoJ_xHqqkZx_ ----------
	fprintf(_fptr, "</g>%s\n", getCommentStr("<!-- group -->"));
	return SVGEXPORT_OK;
} // end of printSvgTable

int SvgExportInfo::printSvgChipMaster() {

	_isChipMaster = true;

	int result = printSvgGroup();
	SE_RESULT_CHECK( result );

	_isChipMaster = false;

	return result;

} // end of printSvgChipMaster

//----- 06.07.04 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	SvgExportInfo::printSvgWidePolyOutline
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjNiNeMjBlNiKhAjApMjFjEjFgJiCmMjHnGiKhDjApMiCpAiPgPjHmNiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	printClipPath	:_xZkqqHx_iDhFiDiJiDfGjDjJiCmMiClNiCnPiCmMiDeOiDiKiDgCiDhDiDjDiDePiPgPjHmNiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iPiIjHjNiCkKjAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_ SVGEXPORT_OK_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	HIROSAWA Masashi _xZkqqHx_iNoMjAkMiBeC_xHqqkZx_
// *			06.07.03 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkMiBeC_xHqqkZx_
// *************************************************************************/
//int SvgExportInfo::printSvgWidePolyOutline( bool printClipPath ) {
//
////----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////	fprintf( _fptr, "<polygon points='" );
////
////	_objectExp->NewObjPolygon(*(_pmmptvPoly), 1.0, NULL, 0);
////	DBLPointVector::const_iterator iMp = _pmmptvPoly->begin();
////
////	for (iMp = _pmmptvPoly->begin(); iMp != _pmmptvPoly->end(); iMp++ ) {
////		DBLPoint mmpt = (*iMp);
////		char *formatStr = getFormatString( "%n,%n " );
////		fprintf( _fptr, formatStr, SvgUnitOffsetX( mmpt.x ), SvgUnitOffsetY( mmpt.y ) );
////	} // for iMp
////
////	fprintf( _fptr, "' " );
////
////	//-------- _xZkqqHx_iDfIiDfOiDeDiDiLiCpAiPgPjHmN_xHqqkZx_ ----------
////	if ( false == printClipPath ) {
////		printStyle();
////	}
////
////	//-------- _xZkqqHx_iDfOiDePjFmCiClGiCoJ_xHqqkZx_ ----------
////	fprintf( _fptr, "/>\n" );
////
////	return SVGEXPORT_OK;
////----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
////----- 06.07.03 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////	const FCObjWidePoly* pWidePoly = (const FCObjWidePoly*)_objectExp;
////
////	fprintf( _fptr, "<polygon points='" );
////
////	pWidePoly->NewObjPolygonForDraw(*(_pmmptvPoly), 1.0, NULL, 0);
////	DBLPointVector::const_iterator iMp = _pmmptvPoly->begin();
////
////	for (iMp = _pmmptvPoly->begin(); iMp != _pmmptvPoly->end(); iMp++ ) {
////		DBLPoint mmpt = (*iMp);
////		char *formatStr = getFormatString( "%n,%n " );
////		fprintf( _fptr, formatStr, SvgUnitOffsetX( mmpt.x ), SvgUnitOffsetY( mmpt.y ) );
////	} // for iMp
////
////	fprintf( _fptr, "' " );
////
////	//-------- _xZkqqHx_iDfIiDfOiDeDiDiLiCpAiPgPjHmN_xHqqkZx_ ----------
////	if ( false == printClipPath ) {
////		printStyle();
////	}
////
////	//-------- _xZkqqHx_iDfOiDePjFmCiClGiCoJ_xHqqkZx_ ----------
////	fprintf( _fptr, "/>\n" );
////
////	return SVGEXPORT_OK;
////----- 06.07.03 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//	const FCObjWidePoly* pWidePoly = (const FCObjWidePoly*)_objectExp;
//
//	fprintf( _fptr, "<polygon points='" );
//
////----- 06.07.03 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////	pWidePoly->NewObjPolygonForDraw(*(_pmmptvPoly), 1.0, NULL, 0);
////	DBLPointVector::const_iterator iMp = _pmmptvPoly->begin();
////
////	for (iMp = _pmmptvPoly->begin(); iMp != _pmmptvPoly->end(); iMp++ ) {
////		DBLPoint mmpt = (*iMp);
////		char *formatStr = getFormatString( "%n,%n " );
////		fprintf( _fptr, formatStr, SvgUnitOffsetX( mmpt.x ), SvgUnitOffsetY( mmpt.y ) );
////	} // for iMp
////----- 06.07.03 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//	DBLPointVector mmptvPoly;
//	pWidePoly->NewObjPolygonForDraw(mmptvPoly, 1.0, NULL, 0);
//	DBLPointVector::const_iterator iMp = mmptvPoly.begin();
//
//	for (iMp = mmptvPoly.begin(); iMp != mmptvPoly.end(); iMp++ ) {
//		DBLPoint mmpt = (*iMp);
//		char *formatStr = getFormatString( "%n,%n " );
//		fprintf( _fptr, formatStr, SvgUnitOffsetX( mmpt.x ), SvgUnitOffsetY( mmpt.y ) );
//	} // for iMp
////----- 06.07.03 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//
//	fprintf( _fptr, "' " );
//
//	//-------- _xZkqqHx_iDfIiDfOiDeDiDiLiCpAiPgPjHmN_xHqqkZx_ ----------
//	if ( false == printClipPath ) {
//		printStyle();
//	}
//
//	//-------- _xZkqqHx_iDfOiDePjFmCiClGiCoJ_xHqqkZx_ ----------
//	fprintf( _fptr, "/>\n" );
//
//	return SVGEXPORT_OK;
////----- 06.07.03 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
////----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//} // end of printSvgWidePolyOutline
//----- 06.07.04 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----


int SvgExportInfo::printSvgWidePoly( bool printClipPath )
{
//----- 06.07.04 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	int result;
//
//	if ( svgExportOption._shouldPrintWidePolySkelton && false == printClipPath )
//	{
//		// _xZkqqHx_iNjMiKgJjApMjFgAiJoG_xHqqkZx_
//
//		// _xZkqqHx_jDgIiCoIiCmCiCnEiClFiCmNiClFiCmIiCkCiCmMiCmFiBeBiDhAiDfOiBfLiDjDjHeMiCoIiCmJiClFiCmEiCkIiCkN_xHqqkZx_
//		PatternID orgBrushPattern = _brushPattern;
//		_brushPattern = SVG_NO_BRUSHPATTERN - 1;
//		result = printSvgPoly( printClipPath );
//		SE_RESULT_CHECK( result );
//		// _xZkqqHx_iDhAiDfOiBfLiDjDiCpAjGnPiClFiCmEiCkIiCkN_xHqqkZx_
//		_brushPattern = orgBrushPattern;
//	}
//
//	if ( svgExportOption._shouldPrintWidePolyOutline )
//	{
//		// _xZkqqHx_jHnGiKhDjApMjFgAiJoG_xHqqkZx_
//		result = printSvgWidePolyOutline( printClipPath );
//		SE_RESULT_CHECK( result );
//	}
//
//	return SVGEXPORT_OK;
//----- 06.07.04 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	const FCObjFigure* pFig = (const FCObjFigure*)_objectExp;
	// _xZkqqHx_jEhHiMgJjAhNiCpA_xHqqkZx_PNG_xZkqqHx_iCmFiPgPjHmNiBeC_xHqqkZx_
	if (svgExportOption._printBackpictAsPng &&
		pFig->GetEmfImage() != FD_EMF_IMAGE_UNUSE)
		return printSvgOLE(printClipPath);

	if (svgExportOption._shouldPrintWidePolySkelton)
	{
		if (!printClipPath)
		{
			// _xZkqqHx_iNjMiKgJjApMjFgAiJoG_xHqqkZx_
			const FCObjWidePoly* pWidePoly = (const FCObjWidePoly*)_objectExp;
			FCObjPoly* pPoly = (FCObjPoly*)FFGetMolipBaseI()->CreateObject(FDOJ_POLY);
			pWidePoly->Copy(pPoly);
			FCObjDynabase* pObjectExpBackup = _objectExp;
			_objectExp = pPoly;

			// _xZkqqHx_jDgIiCoIiCmCiCnEiClFjAnNjCoIiCpAjFnLjBlGiBeCjDgIiCoIiCmCiCnEiClDiCmIiCkCjAnNjCoIiCmJiBeC_xHqqkZx_
			bool isFillPaintedBackup = _isFillPainted;
			_isFillPainted = false;

			int result = printSvgFigure( printClipPath );
			SE_RESULT_CHECK( result );

			// _xZkqqHx_jDgIiCoIiCmCiCnEiClFjAnNjCoIiCpAjGnPiClHiBeC_xHqqkZx_
			_isFillPainted = isFillPaintedBackup;

			_objectExp = pObjectExpBackup;
			pPoly->Release();
		}
	} else
	{
		// _xZkqqHx_jHnGiKhDjApMjFgAiJoG_xHqqkZx_
		int result = printSvgFigure(printClipPath);
		SE_RESULT_CHECK( result );
	}
	return SVGEXPORT_OK;
//----- 06.07.04 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // end of printSvgWidePoly



//----- 06.07.01 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//int SvgExportInfo::printSvgPictArrow() {
//
//	return SVGEXPORT_OK;
//
//} // end of printSvgPictArrow
//----- 06.07.01 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----


// _xZkqqHx_iDiJiDhIiDiLiCmMiLpHiCmMiDfOiDeDiDhG_xHqqkZx_
#define DD_LABEL_BENT	1
#define DD_LABEL_PENCIL	0

#define DD_LABEL_CORNER_SIZE	5

// _xZkqqHx_iDhJiDjDiDfGiDiLiJoGjBjM_xHqqkZx_
#define DD_LABEL_PENCILIMG_FILENAME	"pencil.png"

#define MAX_SVGIMAGE_FILENAME_LEN	512

#define INCH_TO_MM	25.4

// SVG_xZkqqHx_jDoAjGiEiCnPiNjOiCnN_xHqqkZx_
//   x, y, width, height_xZkqqHx_iCmNiBeB_xHqqkZx_SvgUnit(OffsetX/Y)_xZkqqHx_iNmPiCnN_xHqqkZx_
int SvgExportInfo::printSvgLabelPencilBase64( double x, double y, double width, double height ) {

	// SVG_xZkqqHx_jDoAjGiEiCnPiNjOiCnN_xHqqkZx_image_xZkqqHx_iDfOiDePiPgPjHmN_xHqqkZx_
	char *formatStr = getFormatString( "<image x='%n' y='%n' width='%n' height='%n' xlink:href='data:image/png;base64," );
	fprintf( _fptr, formatStr, x, y, width, height );

	//----------- SVG_xZkqqHx_jDoAjGiEiCnPiNjOiCnNiPgPjHmN_xHqqkZx_ -------------

	// base64_xZkqqHx_iPiJiKpKiJlL_xHqqkZx_
	initBase64File( _fptr );

	// base64_xZkqqHx_iPjBiCkLiNjOiCnN_xHqqkZx_
	writeBase64File( GPencil_png, sizeof(GPencil_png) );

	// _xZkqqHx_iOgDiCmBiClNiDgGiBfLiDfOiCpAiPjBiCkLiNjOiCnO_xHqqkZx_
	writeBase64FileLeftBytes();

	fprintf( _fptr, "'/>\n" );

	return SVGEXPORT_OK;

} // end of printSvgLabelPencilBase64

// _xZkqqHx_iKePjFjEiDhEiDeAiDeDiDiLiPgPjHmN_xHqqkZx_
//   x, y, width, height_xZkqqHx_iCmNiBeB_xHqqkZx_SvgUnit(OffsetX/Y)_xZkqqHx_iNmPiCnN_xHqqkZx_
int SvgExportInfo::printSvgLabelPencilFile( double x, double y, double width, double height ) {

	//----------- PNG_xZkqqHx_iDhEiDeAiDeDiDiLjGlMiCpAiNoMiCoJ_xHqqkZx_ -------------

	wchar_t wideFilename[MAX_SVGIMAGE_FILENAME_LEN];
	char mbcFilename[MAX_SVGIMAGE_FILENAME_LEN];
	wchar_t *fullPathPos = wideFilename;

	wchar_t *startPos = wcsrchr( _svgFileName, L'\\' );
	if ( NULL == startPos ) {
		startPos = _svgFileName;
	} else {
		startPos++;
		wcsncpy( wideFilename, _svgFileName, startPos - _svgFileName );
		fullPathPos = wideFilename + (unsigned int)(startPos - _svgFileName);
	}
	wcscpy( fullPathPos, startPos );
	//if ( MAX_SVGIMAGE_FILENAME_LEN - 9 <= wcslen( wideFilename ) ) {
	//	return SE_ERROR_RETURN( SVGEXPORT_ERROR );
	//}
	wchar_t *addPos = wcsrchr( wideFilename, L'.' );
	if ( NULL == addPos ) {
		return SE_ERROR_RETURN( SVGEXPORT_ERROR );
	}
	swprintf( addPos, L"_pencil.png" );

	wcstombs( mbcFilename, fullPathPos, MAX_SVGIMAGE_FILENAME_LEN );

	// _xZkqqHx_iKePjFjEiDhEiDeAiDeDiDiL_xHqqkZx_image_xZkqqHx_iDfOiDePiPgPjHmN_xHqqkZx_
	char *formatStr = getFormatString( "<image x='%n' y='%n' width='%n' height='%n' xlink:href='%s'/>\n" );
	fprintf( _fptr, formatStr, x, y, width, height, mbcFilename );

	//----------- _xZkqqHx_iKePjFjE_xHqqkZx_PNG_xZkqqHx_iDhEiDeAiDeDiDiLiPgPjHmN_xHqqkZx_ -------------

	//FILE *fptr = _wfopen( wideFilename, L"wb" );
	USES_CONVERSION;
	FILE *fptr = fopen( W2CA(wideFilename), "wb" );
	if ( NULL == fptr ) {
		return SE_ERROR_RETURN( SVGEXPORT_ERROR );
	}

	fwrite( GPencil_png, 1, sizeof(GPencil_png), fptr );

	fclose( fptr );

	return SVGEXPORT_OK;

} // end of printSvgLabelPencilFile



int SvgExportInfo::printSvgLabel( bool printClipPath ) {

//----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	WORD type = _objectExp->GetImageType();
//
//	fprintf( _fptr, "<path d='M" );
//
//	_objectExp->NewObjPolygon(*(_pmmptvPoly), 1.0, NULL, 0);
//
//	DBLPoint startBent, endBent;
//	DBLPointVector::const_iterator iMp;
//	int i;
//	for (iMp = _pmmptvPoly->begin(), i = 0; iMp != _pmmptvPoly->end(); iMp++, i++) {
//		DBLPoint mmpt = (*iMp);
//		char *formatStr = getFormatString( "%n,%n " );
//		fprintf( _fptr, formatStr, SvgUnitOffsetX( mmpt.x ), SvgUnitOffsetY( mmpt.y ) );
//		if ( false == printClipPath ) {
//			// _xZkqqHx_jAnMiCoIiLmIiClAjFgAiJoGjHhA_xHqqkZx_
//			if ( 1 == i ) {
//				startBent = mmpt;
//			} else if ( 2 == i ) {
//				endBent = mmpt;
//			}
//		}
//	} // for iMp
//
//	if ( false == printClipPath && DD_LABEL_BENT == type ) {
//		// _xZkqqHx_jAnMiCoIiLmIiClAjFgAiJoGjHhA_xHqqkZx_
//		char *formatStr = getFormatString( "M%n,%n %n,%n %n,%n " );
//		fprintf( _fptr, formatStr, 
//			SvgUnitOffsetX( startBent.x ), SvgUnitOffsetY( startBent.y ),
//			SvgUnitOffsetX( startBent.x ), SvgUnitOffsetY( endBent.y ),
//			SvgUnitOffsetX( endBent.x ), SvgUnitOffsetY( endBent.y ) );
//	}
//
//	fprintf( _fptr, "' " );
//
//	//-------- _xZkqqHx_iDfIiDfOiDeDiDiLiCpAiPgPjHmN_xHqqkZx_ ----------
//	if ( false == printClipPath ) {
//		printStyle();
//	}
//
//	//-------- _xZkqqHx_iDfOiDePjFmCiClGiCoJ_xHqqkZx_ ----------
//	fprintf( _fptr, "/>\n" );
//
//	if ( false == printClipPath && DD_LABEL_PENCIL == type ) {
//		// _xZkqqHx_iDhJiDjDiDfGiDiLiJoGjBjMjFgAiJoG_xHqqkZx_
//		if ( svgExportOption._printBase64Png ) {
//			// SVG_xZkqqHx_jDoAjGiEiCnPiNjOiCnN_xHqqkZx_
//			printSvgLabelPencilBase64( SvgUnitOffsetX( startBent.x - DD_LABEL_CORNER_SIZE ), SvgUnitOffsetY( startBent.y ),
//				SvgUnit( DD_LABEL_CORNER_SIZE ), SvgUnit( DD_LABEL_CORNER_SIZE ) );
//		} else {
//			// _xZkqqHx_iKePjFjEiDhEiDeAiDeDiDiLiPgPjHmN_xHqqkZx_
//			printSvgLabelPencilFile( SvgUnitOffsetX( startBent.x - DD_LABEL_CORNER_SIZE ), SvgUnitOffsetY( startBent.y ),
//				SvgUnit( DD_LABEL_CORNER_SIZE ), SvgUnit( DD_LABEL_CORNER_SIZE ) );
//		}
//		// _xZkqqHx_iDhJiDjDiDfGiDiLiJoGjBjMiDhEiDeAiDeDiDiLiCpAiDfCiDhDiBfL_xHqqkZx_
//	}
//
//	return SVGEXPORT_OK;
//----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	const FCObjLabel* pLabel = (const FCObjLabel*)_objectExp;
	// _xZkqqHx_jEhHiMgJjAhNiCpA_xHqqkZx_PNG_xZkqqHx_iCmFiPgPjHmNiBeC_xHqqkZx_
	if (svgExportOption._printBackpictAsPng &&
		pLabel->GetEmfImage() != FD_EMF_IMAGE_UNUSE)
		return printSvgOLE(printClipPath);

	WORD type = pLabel->GetImageType();

	fprintf( _fptr, "<path d='M" );

//----- 06.07.03 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	pLabel->NewObjPolygonForDraw(*(_pmmptvPoly), 1.0, NULL, 0);
//
//	DBLPoint startBent, endBent;
//	DBLPointVector::const_iterator iMp;
//	int i;
//	for (iMp = _pmmptvPoly->begin(), i = 0; iMp != _pmmptvPoly->end(); iMp++, i++) {
//		DBLPoint mmpt = (*iMp);
//		char *formatStr = getFormatString( "%n,%n " );
//		fprintf( _fptr, formatStr, SvgUnitOffsetX( mmpt.x ), SvgUnitOffsetY( mmpt.y ) );
//		if ( false == printClipPath ) {
//			// _xZkqqHx_jAnMiCoIiLmIiClAjFgAiJoGjHhA_xHqqkZx_
//			if ( 1 == i ) {
//				startBent = mmpt;
//			} else if ( 2 == i ) {
//				endBent = mmpt;
//			}
//		}
//	} // for iMp
//----- 06.07.03 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	DBLPointVector mmptvPoly;
	pLabel->NewObjPolygonForDraw(mmptvPoly, 1.0, NULL, 0);

	DBLPoint startBent, endBent;
	DBLPointVector::const_iterator iMp;
	int i;
	for (iMp = mmptvPoly.begin(), i = 0; iMp != mmptvPoly.end(); iMp++, i++)
	{
		DBLPoint mmpt = (*iMp);
		char *formatStr = getFormatString( "%n,%n " );
		fprintf( _fptr, formatStr, SvgUnitOffsetX( mmpt.x ), SvgUnitOffsetY( mmpt.y ) );
		if ( false == printClipPath ) {
			// _xZkqqHx_jAnMiCoIiLmIiClAjFgAiJoGjHhA_xHqqkZx_
			if ( 1 == i ) {
				startBent = mmpt;
			} else if ( 2 == i ) {
				endBent = mmpt;
			}
		}
	} // for iMp
//----- 06.07.03 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

	if ( false == printClipPath && DD_LABEL_BENT == type ) {
		// _xZkqqHx_jAnMiCoIiLmIiClAjFgAiJoGjHhA_xHqqkZx_
		char *formatStr = getFormatString( "M%n,%n %n,%n %n,%n " );
		fprintf( _fptr, formatStr, 
			SvgUnitOffsetX( startBent.x ), SvgUnitOffsetY( startBent.y ),
			SvgUnitOffsetX( startBent.x ), SvgUnitOffsetY( endBent.y ),
			SvgUnitOffsetX( endBent.x ), SvgUnitOffsetY( endBent.y ) );
	}

	fprintf( _fptr, "' " );

	//-------- _xZkqqHx_iDfIiDfOiDeDiDiLiCpAiPgPjHmN_xHqqkZx_ ----------
	if ( false == printClipPath ) {
		printStyle();
	}

	//-------- _xZkqqHx_iDfOiDePjFmCiClGiCoJ_xHqqkZx_ ----------
	fprintf( _fptr, "/>\n" );

	if ( false == printClipPath && DD_LABEL_PENCIL == type ) {
		// _xZkqqHx_iDhJiDjDiDfGiDiLiJoGjBjMjFgAiJoG_xHqqkZx_
		if ( svgExportOption._printBase64Png ) {
			// SVG_xZkqqHx_jDoAjGiEiCnPiNjOiCnN_xHqqkZx_
			printSvgLabelPencilBase64( SvgUnitOffsetX( startBent.x - DD_LABEL_CORNER_SIZE ), SvgUnitOffsetY( startBent.y ),
				SvgUnit( DD_LABEL_CORNER_SIZE ), SvgUnit( DD_LABEL_CORNER_SIZE ) );
		} else {
			// _xZkqqHx_iKePjFjEiDhEiDeAiDeDiDiLiPgPjHmN_xHqqkZx_
			printSvgLabelPencilFile( SvgUnitOffsetX( startBent.x - DD_LABEL_CORNER_SIZE ), SvgUnitOffsetY( startBent.y ),
				SvgUnit( DD_LABEL_CORNER_SIZE ), SvgUnit( DD_LABEL_CORNER_SIZE ) );
		}
		// _xZkqqHx_iDhJiDjDiDfGiDiLiJoGjBjMiDhEiDeAiDeDiDiLiCpAiDfCiDhDiBfL_xHqqkZx_
	}

	return SVGEXPORT_OK;
//----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

} // end of printSvgLabel

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	SvgExportInfo::printSvgTextRect
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	TextRect_xZkqqHx_jFjEjFgJiCpA_xHqqkZx_SVG_xZkqqHx_iPgPjHmNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	printClipPath	:_xZkqqHx_iDhFiDiJiDfGjDjJiCmMiClNiCnPiCmMiDeOiDiKiDgCiDhDiDjDiDePiPgPjHmNiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.07.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
int SvgExportInfo::printSvgTextRect (bool printClipPath)
{
	const FCObjTextRect* pTextRect = (const FCObjTextRect*)_objectExp;
	// _xZkqqHx_jEhHiMgJjAhNiCpA_xHqqkZx_PNG_xZkqqHx_iCmFiPgPjHmNiBeC_xHqqkZx_
	if (svgExportOption._printBackpictAsPng &&
		pTextRect->GetEmfImage() != FD_EMF_IMAGE_UNUSE)
		return printSvgOLE(printClipPath);

	fprintf(_fptr, "<rect ");
	// _xZkqqHx_iDgFiDeMiDfIiDgHiDhEiDiMiBfLiDiAiCmMiNmAjFfHiOoGjDlOiBeC_xHqqkZx_
	const DBLRect mmrtFrame = pTextRect->GetResizeFrame();
	//-------- _xZkqqHx_iImKjChFiCpAiPgPjHmN_xHqqkZx_ ----------
	char *formatStr = getFormatString("x='%n' y='%n' ");
	fprintf(_fptr, formatStr, SvgUnitOffsetX(mmrtFrame.left), SvgUnitOffsetY(mmrtFrame.top));
	//-------- _xZkqqHx_iDfEiDeDiDfJiCpAiPgPjHmN_xHqqkZx_ ----------
	formatStr = getFormatString("width='%n' height='%n' ");
	fprintf(_fptr, formatStr, SvgUnit( mmrtFrame.Width() ), SvgUnit( mmrtFrame.Height()));
	//-------- _xZkqqHx_iDfIiDfOiDeDiDiLiCpAiPgPjHmN_xHqqkZx_ ----------
	if (false == printClipPath)
		printStyle();
	//-------- _xZkqqHx_iJpBjDfNiBeBiDfIiDeMiDiFiBfLiCpAiPgPjHmN_xHqqkZx_ ----------
	printTransform(SI_NO_TEXT_ANGLE_TRANSFORM);
	//-------- _xZkqqHx_iDfOiDePiCpAjFmCiClGiCoJ_xHqqkZx_ ----------
	fprintf(_fptr, "/>\n");
	return SVGEXPORT_OK;
} // end of printSvgTextRect



#define SVGEXPORT_NO_USE_BASE64	false
#define SVGEXPORT_USE_BASE64	true


// base64_xZkqqHx_iCmF_xHqqkZx_SVG_xZkqqHx_jDoAiCmJjGiEiCnPiNjOiCnN_xHqqkZx_
int SvgExportInfo::printSvgOLEInside() {

	PrintSvgOLEProcess printSvgOLEProcess;
	COLORREF transColor = RGB(0,0,0);

	// OnDraw_xZkqqHx_iCmMjBePiPiIjHjN_xHqqkZx_
	printSvgOLEProcess.preprocess( _objectExp );

	// _xZkqqHx_jDoAjFjE_xHqqkZx_PNG_xZkqqHx_jGiEiCnPiNjOiCnNiCmM_xHqqkZx_image_xZkqqHx_iDfOiDePiPgPjHmN_xHqqkZx_
	char *formatStr = getFormatString( "<image x='%n' y='%n' width='%n' height='%n' xlink:href='data:image/png;base64," );
	fprintf( _fptr, formatStr,
		SvgUnitOffsetX( printSvgOLEProcess.mmRect.left ), 
		SvgUnitOffsetY( printSvgOLEProcess.mmRect.top ), 
		SvgUnit( printSvgOLEProcess.mmRect.Width() ), 
		SvgUnit( printSvgOLEProcess.mmRect.Height() ) );

	// _xZkqqHx_jFgAiJoG_xHqqkZx_
//----- 06.06.30 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	_objectExp->OnDraw( &(printSvgOLEProcess.dc), false );
//----- 06.06.30 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	_objectExp->OnDraw( MfcDC::FromHandle(printSvgOLEProcess.dc.GetSafeHdc()), false );
	MfcDC::DeleteTempMap();
//----- 06.06.30 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

	// _xZkqqHx_jDkHjGlOjAeGiPiIjHjN_xHqqkZx_
	bool useOleTrans = false;
	if ( svgExportOption._useOleTrans ) {
		if ( SVGEXPORT_OK == printSvgOLEProcess.processTransparentColor( &transColor, _objectExp ) ) {
			useOleTrans = true;
		}
	}

	// _xZkqqHx_jDoAjFjE_xHqqkZx_PNG_xZkqqHx_iJoGjBjMiPjBiCkLiNjOiCnN_xHqqkZx_
	if ( pngSave( _fptr, &(printSvgOLEProcess.dc), _objectExp, printSvgOLEProcess.pxWidth, printSvgOLEProcess.pxHeight,
		useOleTrans, transColor, SVGEXPORT_USE_BASE64 ) ) {
		return SE_ERROR_RETURN( SVGEXPORT_CONTINUABLE_ERROR );
	}

	// OnDraw_xZkqqHx_iCmMiMoDiPiIjHjN_xHqqkZx_
	printSvgOLEProcess.postprocess();

	fprintf( _fptr, "'/>\n" );

	return SVGEXPORT_OK;

} // end of printSvgOLEInside


// mbcFilename : png_xZkqqHx_iDhEiDeAiDeDiDiLjGlMiClOiCkP_xHqqkZx_
// wideFileName : _xZkqqHx_iDhEiDiLiDhAiDfI_xHqqkZx_
int SvgExportInfo::makePngFilename( wchar_t *wideFilename, char *mbcFilename ) {

	wchar_t *fullPathPos = wideFilename;

	wchar_t *startPos = wcsrchr( _svgFileName, L'\\' );
	if ( NULL == startPos ) {
		startPos = _svgFileName;
	} else {
		startPos++;
		wcsncpy( wideFilename, _svgFileName, startPos - _svgFileName );
		fullPathPos = wideFilename + (unsigned int)(startPos - _svgFileName);
	}
	wcscpy( fullPathPos, startPos );
	//if ( MAX_SVGIMAGE_FILENAME_LEN - 9 <= wcslen( wideFilename ) ) {
	//	return SE_ERROR_RETURN( SVGEXPORT_ERROR );
	//}
	wchar_t *addPos = wcsrchr( wideFilename, L'.' );
	if ( NULL == addPos ) {
		return SE_ERROR_RETURN( SVGEXPORT_ERROR );
	}
	swprintf( addPos, L"_img%d.png", _imageNo++ );

	wcstombs( mbcFilename, fullPathPos, MAX_SVGIMAGE_FILENAME_LEN );

	return SVGEXPORT_OK;

} // end of makeFilename



int SvgExportInfo::makeHtmlFilename( wchar_t *wideFilePath, char *mbcSvgFilename ) {

	wchar_t *fullPathPos = wideFilePath;
	wchar_t wcsSvgFilename[_MAX_FNAME];

	wchar_t *startPos = wcsrchr( _svgFileName, L'\\' );
	if ( NULL == startPos ) {
		startPos = _svgFileName;
	} else {
		startPos++;
		wcsncpy( wideFilePath, _svgFileName, startPos - _svgFileName );
		fullPathPos = wideFilePath + (unsigned int)(startPos - _svgFileName);
	}
	wcscpy( fullPathPos, startPos );
	//if ( MAX_SVGIMAGE_FILENAME_LEN - 9 <= wcslen( wideFilename ) ) {
	//	return SE_ERROR_RETURN( SVGEXPORT_ERROR );
	//}

	wcscpy( wcsSvgFilename, startPos );
	wcstombs( mbcSvgFilename, wcsSvgFilename, _MAX_FNAME );

	wchar_t *addPos = wcsrchr( wideFilePath, L'.' );
	if ( NULL == addPos ) {
		return SE_ERROR_RETURN( SVGEXPORT_ERROR );
	}
	swprintf( addPos, L".html" );

	return SVGEXPORT_OK;

} // end of makeFilename



// _xZkqqHx_iKePjFjEiDhEiDeAiDeDiDiLiCmFiPjBiCkLiPgPiClH_xHqqkZx_
int SvgExportInfo::printSvgOLEOutside() {

	PrintSvgOLEProcess printSvgOLEProcess;
	COLORREF transColor;

	// OnDraw_xZkqqHx_iCmMjBePiPiIjHjN_xHqqkZx_
	printSvgOLEProcess.preprocess( _objectExp );

	// PNG_xZkqqHx_iDhEiDeAiDeDiDiLjGlMiCpAiNoMiCoJ_xHqqkZx_
	wchar_t filename[MAX_SVGIMAGE_FILENAME_LEN];
	char mbcFilename[MAX_SVGIMAGE_FILENAME_LEN];
	if ( makePngFilename( filename, mbcFilename ) ) {
		return SE_ERROR_RETURN( SVGEXPORT_CONTINUABLE_ERROR );
	}

	// _xZkqqHx_iKePjFjE_xHqqkZx_PNG_xZkqqHx_iDhEiDeAiDeDiDiLiCpAiOgHiCmBiClN_xHqqkZx_image_xZkqqHx_iDfOiDePiPgPjHmN_xHqqkZx_
	char *formatStr = getFormatString( "<image x='%n' y='%n' width='%n' height='%n' xlink:href='%s'/>\n" );
	fprintf( _fptr, formatStr,
		SvgUnitOffsetX( printSvgOLEProcess.mmRect.left ), 
		SvgUnitOffsetY( printSvgOLEProcess.mmRect.top ), 
		SvgUnit( printSvgOLEProcess.mmRect.Width() ), 
		SvgUnit( printSvgOLEProcess.mmRect.Height() ), 
		mbcFilename );

	// _xZkqqHx_jFgAiJoG_xHqqkZx_
//----- 06.06.30 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	_objectExp->OnDraw( &(printSvgOLEProcess.dc), false );
//----- 06.06.30 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	_objectExp->OnDraw( MfcDC::FromHandle(printSvgOLEProcess.dc.GetSafeHdc()), false );
	MfcDC::DeleteTempMap();
//----- 06.06.30 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

	// _xZkqqHx_jDkHjGlOjAeGiPiIjHjN_xHqqkZx_
	bool useOleTrans = false;
	if ( svgExportOption._useOleTrans ) {
		if ( SVGEXPORT_OK == printSvgOLEProcess.processTransparentColor( &transColor, _objectExp ) ) {
			useOleTrans = true;
		}
	}

	// _xZkqqHx_iKePjFjE_xHqqkZx_PNG_xZkqqHx_iDhEiDeAiDeDiDiLiPjBiCkLiNjOiCnN_xHqqkZx_
	//FILE *fptr = _wfopen( filename, L"wb" );
	USES_CONVERSION;
	FILE *fptr = fopen( W2CA(filename), "wb" );
	if ( NULL == fptr ) {
		return SE_ERROR_RETURN( SVGEXPORT_CONTINUABLE_ERROR );
	}
	if ( pngSave( fptr, &(printSvgOLEProcess.dc), _objectExp, printSvgOLEProcess.pxWidth, printSvgOLEProcess.pxHeight,
		useOleTrans, transColor, SVGEXPORT_NO_USE_BASE64 ) ) {
		fclose( fptr );
		return SE_ERROR_RETURN( SVGEXPORT_CONTINUABLE_ERROR );
	}
	fclose( fptr );

	// OnDraw_xZkqqHx_iCmMiMoDiPiIjHjN_xHqqkZx_
	printSvgOLEProcess.postprocess();

	return SVGEXPORT_OK;

} // end of printSvgOLEOutside



int SvgExportInfo::printSvgOLE( bool printClipPath ) {

	if ( printClipPath ) {
		// OLE_xZkqqHx_iCmNiDhAiDfOiBfLiDjDiCmNiKnGiMfHiCmIiCkCiCmNiClIiCmIiCmMiCmFiBeBiJlNiCoAiClJiClIiCmJjElCiCkPiCoJ_xHqqkZx_
		return SVGEXPORT_OK;
	}

	if ( svgExportOption._printBase64Png ) {
		// base64_xZkqqHx_iCmF_xHqqkZx_SVG_xZkqqHx_jDoAiCmJjGiEiCnPiNjOiCnN_xHqqkZx_
		return printSvgOLEInside();
	} else {
		// _xZkqqHx_iKePjFjEiDhEiDeAiDeDiDiLiCmFiPjBiCkLiPgPiClH_xHqqkZx_
		return printSvgOLEOutside();
	}


} // end of printSvgOLE



/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	SvgExportInfo::printSvgPinholePattern
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBePiMgJjAeGiCmMjDgIiCoIiCmCiCnEiClFiCmJiBeBiCmGiClBiCoLiCmHiClBiCoLiMiKiCkKiLpDiCkCiCmEiCkCiCmEiBeBjEhHiMgJjAeGiCkK_xHqqkZx_
 *			_xZkqqHx_iMkJiCkGiCoJiCoGiCkEiCmIiDhAiDfOiBfLiDjDiCpAjFgAiJoGiBeC_xHqqkZx_
 *
 *	<_xZkqqHx_iIpIjAjE_xHqqkZx_>	brushFgColorStr : _xZkqqHx_jBePiMgJjAeGjFlGiOjKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			nAtomLen	:_xZkqqHx_jFgAiJoGiCmMiNmFiPkMjCfAiImKiCpAiOhHjCoIiBeCiJpAjBjMjDhIiCmJiCoGiCmBiCmEjFmPiJlLiClHiCoJiBeC_xHqqkZx_
 *			rtCanvas	:_xZkqqHx_iDhAiDfOiBfLiDjDiCpAjFgAiJoGiClHiCoJiLoJiMgAiCpAiOhHjCoIiBeC_xHqqkZx_rtCanvas_xZkqqHx_iCmMiDfEiDeDiDfJiCkKiCePiCmMiPoKiNiHiBeB_xHqqkZx_
 *						 _xZkqqHx_iDhAiDfOiBfLiDjDiCmMiMeKiCoIjFnEiClFiCmMiNmFiPkMjCfAiImKiCmMiLoJiMgAiCkKjFnEiCoJiBeC_xHqqkZx_
 *			nSkip		:_xZkqqHx_jFgAiJoGiClHiCoJiDhAiDfOiBfLiDjDiCmMiMeKiCoIjFnEiClFiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			nHoleW		:_xZkqqHx_jFgAiJoGiClHiCoJiDhAiDfOiBfLiDjDiCmMjDfPiCmMjFjNiCpAiOhHjCoIiBeC_xHqqkZx_
 *			rtClip		:_xZkqqHx_jFgAiJoGiOjOiCmMiDhNiDfIiDeOiDeOiDiKiDgCiDhGiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *          01.08.18 HIROSAWA Masashi SVG_xZkqqHx_iPgPjHmNjHhAiCmJiPeDjAlD_xHqqkZx_
 *************************************************************************/
void SvgExportInfo::printSvgPinholePattern (char *brushFgColorStr, double nAtomLen, CSRect& rtCanvas,
								short nSkip, short nHoleW, CSRect rtClip)
{

	double lGap = nAtomLen * nSkip;

	if ( rtCanvas.left == rtCanvas.right && rtCanvas.top == rtCanvas.bottom )
	{
		while (lGap < 16) lGap *= 2;
		rtCanvas.SetRect(0, 0, lGap, lGap);
		return;
	}

	double strokeWidth = lGap * (nSkip - nHoleW) / nSkip * _unitsPerMM;

	// _xZkqqHx_iDfIiDfOiDeDiDiLiOhHjCoIiCmM_xHqqkZx_g_xZkqqHx_iKeKiOgOiDfOiDeP_xHqqkZx_
	char *formatStr = getFormatString( "<g style='stroke:%s; stroke-width:%n;clip-path:url(#DynamicDraw_clip%d_ptn%d)'>%s\n" );
	fprintf( _fptr, formatStr,
		brushFgColorStr, strokeWidth, _clipNo, _brushPattern, getCommentStr( "<!-- style : PinholePattern -->" ) );

	rtClip.InflateRect(lGap, lGap);
	double lRight = rtCanvas.right + lGap;
	if (rtClip.right < lRight) lRight = rtClip.right;
	double lBottom = rtCanvas.bottom + lGap;
	if (rtClip.bottom < lBottom) lBottom = rtClip.bottom;
	double lStartX, lStartY;
	for (lStartX = rtCanvas.left; lStartX < rtClip.left; lStartX += lGap);
	for (lStartY = rtCanvas.top; lStartY < rtClip.top; lStartY += lGap);
	double lX, lY;
	formatStr = getFormatString( "<line x1='%n' y1='%n' x2='%n' y2='%n'/>\n" );
	for (lX = lStartX; lX < lRight; lX += lGap)
	{
		fprintf( _fptr, formatStr,
			SvgUnitOffsetX( lX ), SvgUnitOffsetY( rtCanvas.top ), 
			SvgUnitOffsetX( lX ), SvgUnitOffsetY( rtCanvas.bottom ) );
	}
	for (lY = lStartY; lY < lBottom; lY += lGap)
	{
		fprintf( _fptr, formatStr,
			SvgUnitOffsetX( rtCanvas.left ), SvgUnitOffsetY( lY ), 
			SvgUnitOffsetX( rtCanvas.right ), SvgUnitOffsetY( lY ) );
	}

	// _xZkqqHx_iDfIiDfOiDeDiDiLiOhHjCoIiCmM_xHqqkZx_g_xZkqqHx_iPeJjHlJiDfOiDeP_xHqqkZx_
	fprintf( _fptr, "</g>%s\n", getCommentStr( "<!-- style : PinholePattern -->" ) );

} // SvgExportInfo::printSvgPinholePattern.



/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	SvgExportInfo::printSvgStarPattern
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jEhHiMgJjAeGiCmMjDgIiCoIiCmCiCnEiClFiCmJiBeBiCmGiClBiCoLiCmHiClBiCoLjBePiMgJjAeGiCmMjDfPiCkKiMkJiCkGiCoJiCoGiCkEiCmI_xHqqkZx_
 *			_xZkqqHx_iDhAiDfOiBfLiDjDiCpAjFgAiJoGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_rtCanvas_xZkqqHx_iCpAiOpDiCkPiOoGiCoJiPoKiNiHiCmN_xHqqkZx_
 *				 NULL _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			cr	:_xZkqqHx_jBePiMgJjAeGiCpAiOhHjCoIiBeC_xHqqkZx_
 *			nAtomLen	:_xZkqqHx_jFgAiJoGiCmMiNmFiPkMjCfAiImKiCpAiOhHjCoIiBeCiJpAjBjMjDhIiCmJiCoGiCmBiCmEjFmPiJlLiClHiCoJiBeC_xHqqkZx_
 *			rtCanvas	:_xZkqqHx_iDhAiDfOiBfLiDjDiCpAjFgAiJoGiClHiCoJiLoJiMgAiCpAiOhHjCoIiBeC_xHqqkZx_pDC = NULL _xZkqqHx_iCmMiPoKiNiHiBeB_xHqqkZx_
 *						 _xZkqqHx_iDhAiDfOiBfLiDjDiCmMiMeKiCoIjFnEiClFiCmMiNmFiPkMjCfAiImKiCmMiLoJiMgAiCkKjFnEiCoJiBeC_xHqqkZx_
 *			nSkip		:_xZkqqHx_jFgAiJoGiClHiCoJiDhAiDfOiBfLiDjDiCmMiMeKiCoIjFnEiClFiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			nStarW		:_xZkqqHx_jFgAiJoGiClHiCoJiDhAiDfOiBfLiDjDiCmMjDfPiCmMjFjNiCpAiOhHjCoIiBeC_xHqqkZx_
 *			rtClip		:_xZkqqHx_jFgAiJoGiOjOiCmMiDhNiDfIiDeOiDeOiDiKiDgCiDhGiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void SvgExportInfo::printSvgStarPattern (char *brushFgColorStr, double nAtomLen, CSRect& rtCanvas,
								short nSkip, short nStarW, CSRect rtClip)
{
	double lGap = nAtomLen * nSkip * 2;

	if ( rtCanvas.left == rtCanvas.right && rtCanvas.top == rtCanvas.bottom )
	{
		while (lGap < 16) lGap *= 2;
		rtCanvas.SetRect(0, 0, lGap, lGap);
		return;
	}

	//double strokeWidth = lGap * nStarW / nSkip * _unitsPerMM;

	// _xZkqqHx_iDfIiDfOiDeDiDiLiOhHjCoIiCmM_xHqqkZx_g_xZkqqHx_iKeKiOgOiDfOiDeP_xHqqkZx_
	fprintf( _fptr, "<g style='fill:%s;clip-path:url(#DynamicDraw_clip%d_ptn%d)'>%s\n",
		brushFgColorStr, _clipNo, _brushPattern, getCommentStr( "<!-- style : StarPattern -->" ) );

	const double lW = nAtomLen * nStarW;
	rtClip.InflateRect(lW, lW);
	double lRight = rtCanvas.right + lW;
	if (rtClip.right < lRight) lRight = rtClip.right;
	double lBottom = rtCanvas.bottom + lW;
	if (rtClip.bottom < lBottom) lBottom = rtClip.bottom;
	double lStartX, lStartY;
	for (lStartX = rtCanvas.left; lStartX < rtClip.left; lStartX += lGap);
	for (lStartY = rtCanvas.top; lStartY < rtClip.top; lStartY += lGap);
	double lX, lY;
	char *formatStr = getFormatString( "<rect x='%n' y='%n' width='%n' height='%n'/>\n" );
	for (lY = lStartY; lY < lBottom; lY += lGap)
	{
		for (lX = lStartX; lX < lRight; lX += lGap)
		{
			fprintf( _fptr, formatStr, SvgUnitOffsetX( lX ), SvgUnitOffsetY( lY ), 
				SvgUnit( lW ), SvgUnit( lW ) );
		}
	}
	for (lStartX = rtCanvas.left - lGap / 2; lStartX < rtClip.left; lStartX += lGap);
	for (lStartY = rtCanvas.top - lGap / 2; lStartY < rtClip.top; lStartY += lGap);
	formatStr = getFormatString( "<rect x='%n' y='%n' width='%n' height='%n'/>\n" );
	for (lY = lStartY; lY < lBottom; lY += lGap)
	{
		for (lX = lStartX; lX < lRight; lX += lGap)
		{
			fprintf( _fptr, formatStr, SvgUnitOffsetX( lX ), SvgUnitOffsetY( lY ), SvgUnit( lW ), SvgUnit( lW ) );
		}
	}

	// _xZkqqHx_iDfIiDfOiDeDiDiLiOhHjCoIiCmM_xHqqkZx_g_xZkqqHx_iPeJjHlJiDfOiDeP_xHqqkZx_
	fprintf( _fptr, "</g>%s\n", getCommentStr( "<!-- style : StarPattern -->" ) );

} // SvgExportInfo::printSvgStarPattern.


/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	SvgExportInfo::printSvgVLinePattern
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jEhHiMgJjAeGiCmMjDgIiCoIiCmCiCnEiClFiCmJiBeBjBePiMgJjAeGiCmMjAiCjClMjApMiCkKiMeKiCoIjFnEiClHiDhAiDfOiBfLiDjDiCpAjFgAiJoGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_rtCanvas_xZkqqHx_iCpAiOpDiCkPiOoGiCoJiPoKiNiHiCmN_xHqqkZx_
 *				 NULL _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			cr	:_xZkqqHx_jBePiMgJjAeGiCpAiOhHjCoIiBeC_xHqqkZx_
 *			nAtomLen	:_xZkqqHx_jFgAiJoGiCmMiNmFiPkMjCfAiImKiCpAiOhHjCoIiBeCiJpAjBjMjDhIiCmJiCoGiCmBiCmEjFmPiJlLiClHiCoJiBeC_xHqqkZx_
 *			rtCanvas	:_xZkqqHx_iDhAiDfOiBfLiDjDiCpAjFgAiJoGiClHiCoJiLoJiMgAiCpAiOhHjCoIiBeC_xHqqkZx_pDC = NULL _xZkqqHx_iCmMiPoKiNiHiBeB_xHqqkZx_
 *						 _xZkqqHx_iDhAiDfOiBfLiDjDiCmMiMeKiCoIjFnEiClFiCmMiNmFiPkMjCfAiImKiCmMiLoJiMgAiCkKjFnEiCoJiBeC_xHqqkZx_
 *			nSkip		:_xZkqqHx_jFgAiJoGiClHiCoJiDhAiDfOiBfLiDjDiCmMiMeKiCoIjFnEiClFiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			nLineW		:_xZkqqHx_jFgAiJoGiClHiCoJiDhAiDfOiBfLiDjDiCmMjApMiCmMjFjNiCpAiOhHjCoIiBeC_xHqqkZx_
 *			rtClip		:_xZkqqHx_jFgAiJoGiOjOiCmMiDhNiDfIiDeOiDeOiDiKiDgCiDhGiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void SvgExportInfo::printSvgVLinePattern (char *brushFgColorStr, double nAtomLen, CSRect& rtCanvas,
								short nSkip, short nLineW, CSRect rtClip)
{
	double lGap = nAtomLen * nSkip;

	if ( rtCanvas.left == rtCanvas.right && rtCanvas.top == rtCanvas.bottom )
	{
		while (lGap < 16) lGap *= 2;
		rtCanvas.SetRect(0, 0, lGap, lGap);
		return;
	}

	double strokeWidth = nAtomLen * nLineW * _unitsPerMM;

	// _xZkqqHx_iDfIiDfOiDeDiDiLiOhHjCoIiCmM_xHqqkZx_g_xZkqqHx_iKeKiOgOiDfOiDeP_xHqqkZx_
	char *formatStr = getFormatString( "<g style='stroke:%s; stroke-width:%n;clip-path:url(#DynamicDraw_clip%d_ptn%d)'>%s\n" );
	fprintf( _fptr, formatStr,
		brushFgColorStr, strokeWidth, _clipNo, _brushPattern, getCommentStr( "<!-- style : VLinePattern -->" ) );

	const double lW = nAtomLen * nLineW;

	rtClip.InflateRect(lW, lW);
	double lRight = rtCanvas.right + lW;
	if (rtClip.right < lRight) lRight = rtClip.right;
	double lTop = rtCanvas.top - lW;
	if (lTop < rtClip.top) lTop = rtClip.top;
	double lBottom = rtCanvas.bottom + lW;
	if (rtClip.bottom < lBottom) lBottom = rtClip.bottom;
	double lStartX;
	for (lStartX = rtCanvas.left; lStartX < rtClip.left; lStartX += lGap);
	double lX;
	formatStr = getFormatString( "<line x1='%n' y1='%n' x2='%n' y2='%n'/>\n" );
	for (lX = lStartX; lX < lRight; lX += lGap)
	{
		fprintf( _fptr, formatStr, SvgUnitOffsetX( lX ), SvgUnitOffsetY( lTop ), 
			SvgUnitOffsetX( lX ), SvgUnitOffsetY( lBottom ) );
	}

	// _xZkqqHx_iDfIiDfOiDeDiDiLiOhHjCoIiCmM_xHqqkZx_g_xZkqqHx_iPeJjHlJiDfOiDeP_xHqqkZx_
	fprintf( _fptr, "</g>%s\n", getCommentStr( "<!-- style : VLinePattern -->" ) );

} // SvgExportInfo::printSvgVLinePattern.




/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	SvgExportInfo::printSvgHLinePattern
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jEhHiMgJjAeGiCmMjDgIiCoIiCmCiCnEiClFiCmJiBeBjBePiMgJjAeGiCmMjAiFjFlNjApMiCkKiMeKiCoIjFnEiClHiDhAiDfOiBfLiDjDiCpAjFgAiJoGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_rtCanvas_xZkqqHx_iCpAiOpDiCkPiOoGiCoJiPoKiNiHiCmN_xHqqkZx_
 *				 NULL _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			cr	:_xZkqqHx_jBePiMgJjAeGiCpAiOhHjCoIiBeC_xHqqkZx_
 *			nAtomLen	:_xZkqqHx_jFgAiJoGiCmMiNmFiPkMjCfAiImKiCpAiOhHjCoIiBeCiJpAjBjMjDhIiCmJiCoGiCmBiCmEjFmPiJlLiClHiCoJiBeC_xHqqkZx_
 *			rtCanvas	:_xZkqqHx_iDhAiDfOiBfLiDjDiCpAjFgAiJoGiClHiCoJiLoJiMgAiCpAiOhHjCoIiBeC_xHqqkZx_pDC = NULL _xZkqqHx_iCmMiPoKiNiHiBeB_xHqqkZx_
 *						 _xZkqqHx_iDhAiDfOiBfLiDjDiCmMiMeKiCoIjFnEiClFiCmMiNmFiPkMjCfAiImKiCmMiLoJiMgAiCkKjFnEiCoJiBeC_xHqqkZx_
 *			nSkip		:_xZkqqHx_jFgAiJoGiClHiCoJiDhAiDfOiBfLiDjDiCmMiMeKiCoIjFnEiClFiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			nLineW		:_xZkqqHx_jFgAiJoGiClHiCoJiDhAiDfOiBfLiDjDiCmMjApMiCmMjFjNiCpAiOhHjCoIiBeC_xHqqkZx_
 *			rtClip		:_xZkqqHx_jFgAiJoGiOjOiCmMiDhNiDfIiDeOiDeOiDiKiDgCiDhGiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void SvgExportInfo::printSvgHLinePattern (char *brushFgColorStr, double nAtomLen, CSRect& rtCanvas,
								short nSkip, short nLineW, CSRect rtClip)
{
	double lGap = nAtomLen * nSkip;

	if ( rtCanvas.left == rtCanvas.right && rtCanvas.top == rtCanvas.bottom )
	{
		while (lGap < 16) lGap *= 2;
		rtCanvas.SetRect(0, 0, lGap, lGap);
		return;
	}

	double strokeWidth = nAtomLen * nLineW * _unitsPerMM;

	// _xZkqqHx_iDfIiDfOiDeDiDiLiOhHjCoIiCmM_xHqqkZx_g_xZkqqHx_iKeKiOgOiDfOiDeP_xHqqkZx_
	char *formatStr = getFormatString( "<g style='stroke:%s; stroke-width:%n;clip-path:url(#DynamicDraw_clip%d_ptn%d)'>%s\n" );
	fprintf( _fptr, formatStr,
		brushFgColorStr, strokeWidth, _clipNo, _brushPattern, getCommentStr( "<!-- style : HLinePattern -->" ) );

	const double lW = nAtomLen * nLineW;
	rtClip.InflateRect(lW, lW);
	double lBottom = rtCanvas.bottom + lW;
	if (rtClip.bottom < lBottom) lBottom = rtClip.bottom;
	double lLeft = rtCanvas.left - lW;
	if (lLeft < rtClip.left) lLeft = rtClip.left;
	double lRight = rtCanvas.right + lW;
	if (rtClip.right < lRight) lRight = rtClip.right;
	double lStartY;
	for (lStartY = rtCanvas.top; lStartY < rtClip.top; lStartY += lGap);
	double lY;
	formatStr = getFormatString( "<line x1='%n' y1='%n' x2='%n' y2='%n'/>\n" );
	for (lY = lStartY; lY < lBottom; lY += lGap)
	{
		fprintf( _fptr, formatStr, SvgUnitOffsetX( lLeft ), SvgUnitOffsetY( lY ), 
			SvgUnitOffsetX( lRight ), SvgUnitOffsetY( lY ) );

	}

	// _xZkqqHx_iDfIiDfOiDeDiDiLiOhHjCoIiCmM_xHqqkZx_g_xZkqqHx_iPeJjHlJiDfOiDeP_xHqqkZx_
	fprintf( _fptr, "</g>%s\n", getCommentStr( "<!-- style : HLinePattern -->" ) );

} // SvgExportInfo::printSvgHLinePattern.




/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	SvgExportInfo::printSvgLDLinePattern
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jEhHiMgJjAeGiCmMjDgIiCoIiCmCiCnEiClFiCmJiBeBjBePiMgJjAeGiCmMiOmOjApMiBgJiNlGiPoDiCkJiCoHiJeFiJlKiCnGiBgKiCkK_xHqqkZx_
 *			_xZkqqHx_iMeKiCoIjFnEiClHiDhAiDfOiBfLiDjDiCpAjFgAiJoGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_rtCanvas_xZkqqHx_iCpAiOpDiCkPiOoGiCoJiPoKiNiHiCmN_xHqqkZx_
 *				 NULL _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			cr	:_xZkqqHx_jBePiMgJjAeGiCpAiOhHjCoIiBeC_xHqqkZx_
 *			nAtomLen	:_xZkqqHx_jFgAiJoGiCmMiNmFiPkMjCfAiImKiCpAiOhHjCoIiBeCiJpAjBjMjDhIiCmJiCoGiCmBiCmEjFmPiJlLiClHiCoJiBeC_xHqqkZx_
 *			rtCanvas	:_xZkqqHx_iDhAiDfOiBfLiDjDiCpAjFgAiJoGiClHiCoJiLoJiMgAiCpAiOhHjCoIiBeC_xHqqkZx_pDC = NULL _xZkqqHx_iCmMiPoKiNiHiBeB_xHqqkZx_
 *						 _xZkqqHx_iDhAiDfOiBfLiDjDiCmMiMeKiCoIjFnEiClFiCmMiNmFiPkMjCfAiImKiCmMiLoJiMgAiCkKjFnEiCoJiBeC_xHqqkZx_
 *			nSkip		:_xZkqqHx_jFgAiJoGiClHiCoJiDhAiDfOiBfLiDjDiCmMiMeKiCoIjFnEiClFiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			nLineW		:_xZkqqHx_jFgAiJoGiClHiCoJiDhAiDfOiBfLiDjDiCmMjApMiCmMjFjNiCpAiOhHjCoIiBeC_xHqqkZx_
 *			rtClip		:_xZkqqHx_jFgAiJoGiOjOiCmMiDhNiDfIiDeOiDeOiDiKiDgCiDhGiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void SvgExportInfo::printSvgLDLinePattern (char *brushFgColorStr, double nAtomLen, CSRect& rtCanvas,
								short nSkip, short nLineW, CSRect rtClip)
{
	double lGap = nAtomLen * nSkip;

	if ( rtCanvas.left == rtCanvas.right && rtCanvas.top == rtCanvas.bottom )
	{
		while (lGap < 16) lGap *= 2;
		rtCanvas.SetRect(0, 0, lGap, lGap);
		return;
	}

	double strokeWidth = nAtomLen * nLineW * _unitsPerMM;

	// _xZkqqHx_iDfIiDfOiDeDiDiLiOhHjCoIiCmM_xHqqkZx_g_xZkqqHx_iKeKiOgOiDfOiDeP_xHqqkZx_
	char *formatStr = getFormatString( "<g style='stroke:%s; stroke-width:%n;clip-path:url(#DynamicDraw_clip%d_ptn%d)'>\n" );
	fprintf( _fptr, formatStr, brushFgColorStr, strokeWidth, _clipNo, _brushPattern );

	const double lW = nAtomLen * nLineW;
	rtClip.InflateRect(lW, lW);
	double lRight = rtCanvas.right + lW;
	double lBottom = rtCanvas.bottom + lW;
	double lWidth = rtCanvas.Width();
	double lHeight = rtCanvas.Height();

	double lX, lY;
	formatStr = getFormatString( "<line x1='%n' y1='%n' x2='%n' y2='%n'/>%s\n" );
	for (lX = rtCanvas.left; lX < lRight; lX += lGap)
	{
		double lPatSize = rtCanvas.right - lX;
		if (lHeight < lPatSize) lPatSize = lHeight;
		CSRect rtLine(lX - lW, rtCanvas.top - lW,
					lX + lPatSize + lW, rtCanvas.top + lPatSize + lW);
		if (!(rtLine & rtClip).IsRectEmpty())
		{
			fprintf( _fptr, formatStr,
				SvgUnitOffsetX( rtLine.left ), SvgUnitOffsetY( rtLine.top ), 
				SvgUnitOffsetX( rtLine.right ), SvgUnitOffsetY( rtLine.bottom ), 
				getCommentStr( "<!-- style : LDLinePattern -->" ) );
		}
	}
	for (lY = rtCanvas.top + lGap; lY < lBottom; lY += lGap)
	{
		double lPatSize = rtCanvas.bottom - lY;
		if (lWidth < lPatSize) lPatSize = lWidth;
		CSRect rtLine(rtCanvas.left - lW, lY - lW,
					rtCanvas.left + lPatSize + lW, lY + lPatSize + lW);
		if (!(rtLine & rtClip).IsRectEmpty())
		{
			fprintf( _fptr, formatStr,
				SvgUnitOffsetX( rtLine.left ), SvgUnitOffsetY( rtLine.top ), 
				SvgUnitOffsetX( rtLine.right ), SvgUnitOffsetY( rtLine.bottom ) );
		}
	}

	// _xZkqqHx_iDfIiDfOiDeDiDiLiOhHjCoIiCmM_xHqqkZx_g_xZkqqHx_iPeJjHlJiDfOiDeP_xHqqkZx_
	fprintf( _fptr, "</g>%s\n", getCommentStr( "<!-- style : LDLinePattern -->" ) );

} // SvgExportInfo::printSvgLDLinePattern.




/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	SvgExportInfo::printSvgRDLinePattern
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jEhHiMgJjAeGiCmMjDgIiCoIiCmCiCnEiClFiCmJiBeBjBePiMgJjAeGiCmMiOmOjApMiBgJiJeFiPoDiCkJiCoHiNlGiJlKiCnGiBgKiCkK_xHqqkZx_
 *			_xZkqqHx_iMeKiCoIjFnEiClHiDhAiDfOiBfLiDjDiCpAjFgAiJoGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_rtCanvas_xZkqqHx_iCpAiOpDiCkPiOoGiCoJiPoKiNiHiCmN_xHqqkZx_
 *				 NULL _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			cr	:_xZkqqHx_jBePiMgJjAeGiCpAiOhHjCoIiBeC_xHqqkZx_
 *			nAtomLen	:_xZkqqHx_jFgAiJoGiCmMiNmFiPkMjCfAiImKiCpAiOhHjCoIiBeCiJpAjBjMjDhIiCmJiCoGiCmBiCmEjFmPiJlLiClHiCoJiBeC_xHqqkZx_
 *			rtCanvas	:_xZkqqHx_iDhAiDfOiBfLiDjDiCpAjFgAiJoGiClHiCoJiLoJiMgAiCpAiOhHjCoIiBeC_xHqqkZx_pDC = NULL _xZkqqHx_iCmMiPoKiNiHiBeB_xHqqkZx_
 *						 _xZkqqHx_iDhAiDfOiBfLiDjDiCmMiMeKiCoIjFnEiClFiCmMiNmFiPkMjCfAiImKiCmMiLoJiMgAiCkKjFnEiCoJiBeC_xHqqkZx_
 *			nSkip		:_xZkqqHx_jFgAiJoGiClHiCoJiDhAiDfOiBfLiDjDiCmMiMeKiCoIjFnEiClFiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			nLineW		:_xZkqqHx_jFgAiJoGiClHiCoJiDhAiDfOiBfLiDjDiCmMjApMiCmMjFjNiCpAiOhHjCoIiBeC_xHqqkZx_
 *			rtClip		:_xZkqqHx_jFgAiJoGiOjOiCmMiDhNiDfIiDeOiDeOiDiKiDgCiDhGiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void SvgExportInfo::printSvgRDLinePattern (char *brushFgColorStr, double nAtomLen, CSRect& rtCanvas,
								short nSkip, short nLineW, CSRect rtClip)
{
	double lGap = nAtomLen * nSkip;

	if ( rtCanvas.left == rtCanvas.right && rtCanvas.top == rtCanvas.bottom )
	{
		while (lGap < 16) lGap *= 2;
		rtCanvas.SetRect(0, 0, lGap, lGap);
		return;
	}

	double strokeWidth = nAtomLen * nLineW * _unitsPerMM;

	// _xZkqqHx_iDfIiDfOiDeDiDiLiOhHjCoIiCmM_xHqqkZx_g_xZkqqHx_iKeKiOgOiDfOiDeP_xHqqkZx_
	char *formatStr = getFormatString( "<g style='stroke:%s; stroke-width:%n;clip-path:url(#DynamicDraw_clip%d_ptn%d)'>%s\n" );
	fprintf( _fptr, formatStr,
		brushFgColorStr, SvgUnit( strokeWidth ), _clipNo, _brushPattern, getCommentStr( "<!-- style : RDLinePattern -->" ) );

	const double lW = nAtomLen * nLineW;
	rtClip.InflateRect(lW, lW);
	double lRight = rtCanvas.right + lW;
	double lTop = rtCanvas.top - lW;
	double lWidth = rtCanvas.Width();
	double lHeight = rtCanvas.Height();
	double lX, lY;
	formatStr = getFormatString( "<line x1='%n' y1='%n' x2='%n' y2='%n'/>\n" );
	for (lX = rtCanvas.left; lX < lRight; lX += lGap)
	{
		double lPatSize = rtCanvas.right - lX;
		if (lHeight < lPatSize) lPatSize = lHeight;
		CSRect rtLine(lX - lW, rtCanvas.bottom - lPatSize - lW,
					lX + lPatSize + lW, rtCanvas.bottom + lW);
		if (!(rtLine & rtClip).IsRectEmpty())
		{
			fprintf( _fptr, formatStr,
				SvgUnitOffsetX( rtLine.left ), SvgUnitOffsetY( rtLine.bottom ), 
				SvgUnitOffsetX( rtLine.right ), SvgUnitOffsetY( rtLine.top ) );
		}
	}
	for (lY = rtCanvas.bottom - lGap; lTop < lY; lY -= lGap)
	{
		double lPatSize = lY - rtCanvas.top;
		if (lWidth < lPatSize) lPatSize = lWidth;
		CSRect rtLine(rtCanvas.left - lW, lY - lPatSize - lW,
					rtCanvas.left + lPatSize + lW, lY + lW);
		if (!(rtLine & rtClip).IsRectEmpty())
		{
			fprintf( _fptr, formatStr,
				SvgUnitOffsetX( rtLine.left ), SvgUnitOffsetY( rtLine.bottom ), 
				SvgUnitOffsetX( rtLine.right ), SvgUnitOffsetY( rtLine.top ) );
		}
	}

	// _xZkqqHx_iDfIiDfOiDeDiDiLiOhHjCoIiCmM_xHqqkZx_g_xZkqqHx_iPeJjHlJiDfOiDeP_xHqqkZx_
	fprintf( _fptr, "</g>%s\n", getCommentStr( "<!-- style : RDLinePattern -->" ) );

} // SvgExportInfo::printSvgRDLinePattern.




/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	SvgExportInfo::printSvgVHLatticePattern
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jEhHiMgJjAeGiCmMjDgIiCoIiCmCiCnEiClFiCmJiBeBjBePiMgJjAeGiCmMjFpLiKoBjGmNjHgMiCkKiMeKiCoIjFnEiClHiDhAiDfOiBfLiDjDiCpAjFgAiJoGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_rtCanvas_xZkqqHx_iCpAiOpDiCkPiOoGiCoJiPoKiNiHiCmN_xHqqkZx_
 *				 NULL _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			cr	:_xZkqqHx_jBePiMgJjAeGiCpAiOhHjCoIiBeC_xHqqkZx_
 *			nAtomLen	:_xZkqqHx_jFgAiJoGiCmMiNmFiPkMjCfAiImKiCpAiOhHjCoIiBeCiJpAjBjMjDhIiCmJiCoGiCmBiCmEjFmPiJlLiClHiCoJiBeC_xHqqkZx_
 *			rtCanvas	:_xZkqqHx_iDhAiDfOiBfLiDjDiCpAjFgAiJoGiClHiCoJiLoJiMgAiCpAiOhHjCoIiBeC_xHqqkZx_pDC = NULL _xZkqqHx_iCmMiPoKiNiHiBeB_xHqqkZx_
 *						 _xZkqqHx_iDhAiDfOiBfLiDjDiCmMiMeKiCoIjFnEiClFiCmMiNmFiPkMjCfAiImKiCmMiLoJiMgAiCkKjFnEiCoJiBeC_xHqqkZx_
 *			nSkip		:_xZkqqHx_jFgAiJoGiClHiCoJiDhAiDfOiBfLiDjDiCmMiMeKiCoIjFnEiClFiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			nLineW		:_xZkqqHx_jFgAiJoGiClHiCoJiDhAiDfOiBfLiDjDiCmMjApMiCmMjFjNiCpAiOhHjCoIiBeC_xHqqkZx_
 *			rtClip		:_xZkqqHx_jFgAiJoGiOjOiCmMiDhNiDfIiDeOiDeOiDiKiDgCiDhGiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void SvgExportInfo::printSvgVHLatticePattern (char *brushFgColorStr, double nAtomLen, CSRect& rtCanvas,
									short nSkip, short nLineW, CSRect rtClip)
{
	double lGap = nAtomLen * nSkip;

	if ( rtCanvas.left == rtCanvas.right && rtCanvas.top == rtCanvas.bottom )
	{
		while (lGap < 16) lGap *= 2;
		rtCanvas.SetRect(0, 0, lGap, lGap);
		return;
	}

	double strokeWidth = nAtomLen * nLineW * _unitsPerMM;

	// _xZkqqHx_iDfIiDfOiDeDiDiLiOhHjCoIiCmM_xHqqkZx_g_xZkqqHx_iKeKiOgOiDfOiDeP_xHqqkZx_
	char *formatStr = getFormatString( "<g style='stroke:%s; stroke-width:%n;clip-path:url(#DynamicDraw_clip%d_ptn%d)'>%s\n" );
	fprintf( _fptr, formatStr,
		brushFgColorStr, SvgUnit( strokeWidth ), _clipNo, _brushPattern, getCommentStr( "<!-- style : VHLatticePattern -->" ) );

	const double lW = nAtomLen * nLineW;
	rtClip.InflateRect(lW, lW);
	double lLeft = rtCanvas.left - lW;
	if (lLeft < rtClip.left) lLeft = rtClip.left;
	double lTop = rtCanvas.top - lW;
	if (lTop < rtClip.top) lTop = rtClip.top;
	double lRight = rtCanvas.right + lW;
	if (rtClip.right < lRight) lRight = rtClip.right;
	double lBottom = rtCanvas.bottom + lW;
	if (rtClip.bottom < lBottom) lBottom = rtClip.bottom;
	double lStartX;
	for (lStartX = rtCanvas.left; lStartX < rtClip.left; lStartX += lGap);
	double lX, lY;
	formatStr = getFormatString( "<line x1='%n' y1='%n' x2='%n' y2='%n'/>\n" );
	for (lX = lStartX; lX < lRight; lX += lGap)
	{
		fprintf( _fptr, formatStr, SvgUnitOffsetX( lX ), SvgUnitOffsetY( lTop ), 
			SvgUnitOffsetX( lX ), SvgUnitOffsetY( lBottom ) );
	}
	double lStartY;
	for (lStartY = rtCanvas.top; lStartY < rtClip.top; lStartY += lGap);
	for (lY = lStartY; lY < lBottom; lY += lGap)
	{
		fprintf( _fptr, formatStr, SvgUnitOffsetX( lLeft ), SvgUnitOffsetY( lY ), 
			SvgUnitOffsetX( lRight ), SvgUnitOffsetY( lY ) );
	}

	// _xZkqqHx_iDfIiDfOiDeDiDiLiOhHjCoIiCmM_xHqqkZx_g_xZkqqHx_iPeJjHlJiDfOiDeP_xHqqkZx_
	fprintf( _fptr, "</g>%s\n", getCommentStr( "<!-- style : VHLatticePattern -->" ) );

} // SvgExportInfo::printSvgVHLatticePattern.




/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	SvgExportInfo::printSvgDgLatticePattern
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jEhHiMgJjAeGiCmMjDgIiCoIiCmCiCnEiClFiCmJiBeBjBePiMgJjAeGiCmMiOmOiCnPiCmMjFpLiKoBjGmNjHgMiCkKiMeKiCoIjFnEiClH_xHqqkZx_
 *			_xZkqqHx_iDhAiDfOiBfLiDjDiCpAjFgAiJoGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_rtCanvas_xZkqqHx_iCpAiOpDiCkPiOoGiCoJiPoKiNiHiCmN_xHqqkZx_
 *				 NULL _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			cr	:_xZkqqHx_jBePiMgJjAeGiCpAiOhHjCoIiBeC_xHqqkZx_
 *			nAtomLen	:_xZkqqHx_jFgAiJoGiCmMiNmFiPkMjCfAiImKiCpAiOhHjCoIiBeCiJpAjBjMjDhIiCmJiCoGiCmBiCmEjFmPiJlLiClHiCoJiBeC_xHqqkZx_
 *			rtCanvas	:_xZkqqHx_iDhAiDfOiBfLiDjDiCpAjFgAiJoGiClHiCoJiLoJiMgAiCpAiOhHjCoIiBeC_xHqqkZx_pDC = NULL _xZkqqHx_iCmMiPoKiNiHiBeB_xHqqkZx_
 *						 _xZkqqHx_iDhAiDfOiBfLiDjDiCmMiMeKiCoIjFnEiClFiCmMiNmFiPkMjCfAiImKiCmMiLoJiMgAiCkKjFnEiCoJiBeC_xHqqkZx_
 *			nSkip		:_xZkqqHx_jFgAiJoGiClHiCoJiDhAiDfOiBfLiDjDiCmMiMeKiCoIjFnEiClFiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			nLineW		:_xZkqqHx_jFgAiJoGiClHiCoJiDhAiDfOiBfLiDjDiCmMjApMiCmMjFjNiCpAiOhHjCoIiBeC_xHqqkZx_
 *			rtClip		:_xZkqqHx_jFgAiJoGiOjOiCmMiDhNiDfIiDeOiDeOiDiKiDgCiDhGiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void SvgExportInfo::printSvgDgLatticePattern (char *brushFgColorStr, double nAtomLen, CSRect& rtCanvas,
									short nSkip, short nLineW, CSRect rtClip)
{
	double lGap = nAtomLen * nSkip;

	if ( rtCanvas.left == rtCanvas.right && rtCanvas.top == rtCanvas.bottom )
	{
		while (lGap < 16) lGap *= 2;
		rtCanvas.SetRect(0, 0, lGap, lGap);
		return;
	}

	double strokeWidth = nAtomLen * nLineW * _unitsPerMM;

	// _xZkqqHx_iDfIiDfOiDeDiDiLiOhHjCoIiCmM_xHqqkZx_g_xZkqqHx_iKeKiOgOiDfOiDeP_xHqqkZx_
	char *formatStr = getFormatString( "<g style='stroke:%s; stroke-width:%n;clip-path:url(#DynamicDraw_clip%d_ptn%d)'>%s\n" );
	fprintf( _fptr, formatStr,
		brushFgColorStr, SvgUnit( strokeWidth ), _clipNo, _brushPattern, getCommentStr( "<!-- style : DgLatticePattern -->" ) );

	const double lW = nAtomLen * nLineW;
	rtClip.InflateRect(lW, lW);
	double lRight = rtCanvas.right + lW;
	double lTop = rtCanvas.top - lW;
	double lBottom = rtCanvas.bottom + lW;
	double lWidth = rtCanvas.Width();
	double lHeight = rtCanvas.Height();
	double lX, lY;
	formatStr = getFormatString( "<line x1='%n' y1='%n' x2='%n' y2='%n'/>\n" );
	for (lX = rtCanvas.left; lX < lRight; lX += lGap)
	{
		double lPatSize = rtCanvas.right - lX;
		if (lHeight < lPatSize) lPatSize = lHeight;
		CSRect rtLine(lX - lW, rtCanvas.top - lW,
					lX + lPatSize + lW, rtCanvas.top + lPatSize + lW);
		if (!(rtLine & rtClip).IsRectEmpty())
		{
			fprintf( _fptr, formatStr,
				SvgUnitOffsetX( rtLine.left ), SvgUnitOffsetY( rtLine.top ), 
				SvgUnitOffsetX( rtLine.right ), SvgUnitOffsetY( rtLine.bottom ) );
		}
	}
	for (lY = rtCanvas.top + lGap; lY < lBottom; lY += lGap)
	{
		double lPatSize = rtCanvas.bottom - lY;
		if (lWidth < lPatSize) lPatSize = lWidth;
		CSRect rtLine(rtCanvas.left - lW, lY - lW,
					rtCanvas.left + lPatSize + lW, lY + lPatSize + lW);
		if (!(rtLine & rtClip).IsRectEmpty())
		{
			fprintf( _fptr, formatStr,
				SvgUnitOffsetX( rtLine.left ), SvgUnitOffsetY( rtLine.top ), 
				SvgUnitOffsetX( rtLine.right ), SvgUnitOffsetY( rtLine.bottom ) );
		}
	}

	for (lX = rtCanvas.left; lX < lRight; lX += lGap)
	{
		double lPatSize = rtCanvas.right - lX;
		if (lHeight < lPatSize) lPatSize = lHeight;
		CSRect rtLine(lX - lW, rtCanvas.bottom - lPatSize - lW,
					lX + lPatSize + lW, rtCanvas.bottom + lW);
		if (!(rtLine & rtClip).IsRectEmpty())
		{
			fprintf( _fptr, formatStr,
				SvgUnitOffsetX( rtLine.left ), SvgUnitOffsetY( rtLine.bottom ), 
				SvgUnitOffsetX( rtLine.right ), SvgUnitOffsetY( rtLine.top ) );
		}
	}
	for (lY = rtCanvas.bottom - lGap; lTop < lY; lY -= lGap)
	{
		double lPatSize = lY - rtCanvas.top;
		if (lWidth < lPatSize) lPatSize = lWidth;
		CSRect rtLine(rtCanvas.left - lW, lY - lPatSize - lW,
					rtCanvas.left + lPatSize + lW, lY + lW);
		if (!(rtLine & rtClip).IsRectEmpty())
		{
			fprintf( _fptr, formatStr,
				SvgUnitOffsetX( rtLine.left ), SvgUnitOffsetY( rtLine.bottom ), 
				SvgUnitOffsetX( rtLine.right ), SvgUnitOffsetY( rtLine.top ) );
		}
	}

	// _xZkqqHx_iDfIiDfOiDeDiDiLiOhHjCoIiCmM_xHqqkZx_g_xZkqqHx_iPeJjHlJiDfOiDeP_xHqqkZx_
	fprintf( _fptr, "</g>%s\n", getCommentStr( "<!-- style : DgLatticePattern -->" ) );

} // SvgExportInfo::printSvgDgLatticePattern.




/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	SvgExportInfo::printSvgHWavePattern
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jEhHiMgJjAeGiCmMjDgIiCoIiCmCiCnEiClFiCmJiBeBjBePiMgJjAeGiCmMjAiFjFlNjFpLiMpMiCmMjEgHjGmNjHgMiCkKiMeKiCoIjFnEiClH_xHqqkZx_
 *			_xZkqqHx_iDhAiDfOiBfLiDjDiCpAjFgAiJoGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_rtCanvas_xZkqqHx_iCpAiOpDiCkPiOoGiCoJiPoKiNiHiCmN_xHqqkZx_
 *				 NULL _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			cr	:_xZkqqHx_jBePiMgJjAeGiCpAiOhHjCoIiBeC_xHqqkZx_
 *			nAtomLen	:_xZkqqHx_jFgAiJoGiCmMiNmFiPkMjCfAiImKiCpAiOhHjCoIiBeCiJpAjBjMjDhIiCmJiCoGiCmBiCmEjFmPiJlLiClHiCoJiBeC_xHqqkZx_
 *			rtCanvas	:_xZkqqHx_iDhAiDfOiBfLiDjDiCpAjFgAiJoGiClHiCoJiLoJiMgAiCpAiOhHjCoIiBeC_xHqqkZx_pDC = NULL _xZkqqHx_iCmMiPoKiNiHiBeB_xHqqkZx_
 *						 _xZkqqHx_iDhAiDfOiBfLiDjDiCmMiMeKiCoIjFnEiClFiCmMiNmFiPkMjCfAiImKiCmMiLoJiMgAiCkKjFnEiCoJiBeC_xHqqkZx_
 *			nSkip		:_xZkqqHx_jFgAiJoGiClHiCoJiDhAiDfOiBfLiDjDiCmMiMeKiCoIjFnEiClFiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			nWaveW		:_xZkqqHx_jFgAiJoGiClHiCoJjEgHiCmMjFjNiCpAiOhHjCoIiBeC_xHqqkZx_
 *			nLineW		:_xZkqqHx_jFgAiJoGiClHiCoJiDhAiDfOiBfLiDjDiCmMjApMiCmMjFjNiCpAiOhHjCoIiBeC_xHqqkZx_
 *			rtClip		:_xZkqqHx_jFgAiJoGiOjOiCmMiDhNiDfIiDeOiDeOiDiKiDgCiDhGiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void SvgExportInfo::printSvgHWavePattern (char *brushFgColorStr, double nAtomLen, CSRect& rtCanvas,
								short nSkip, short nWaveW, short nLineW, CSRect rtClip)
{
	double lGapH = nAtomLen * nWaveW;
	double lGapV = nAtomLen * nSkip;

	if ( rtCanvas.left == rtCanvas.right && rtCanvas.top == rtCanvas.bottom )
	{
		while (lGapH < 16 || lGapV < 16)
		{
			lGapH *= 2;
			lGapV *= 2;
		}
		rtCanvas.SetRect(0, 0, lGapH, lGapV);
		return;
	}

	double strokeWidth = nAtomLen * nLineW * _unitsPerMM;

	// _xZkqqHx_iDfIiDfOiDeDiDiLiOhHjCoIiCmM_xHqqkZx_g_xZkqqHx_iKeKiOgOiDfOiDeP_xHqqkZx_
	char *formatStr = getFormatString( "<g style='stroke:%s; stroke-width:%n;clip-path:url(#DynamicDraw_clip%d_ptn%d)'>%s\n" );
	fprintf( _fptr, formatStr,
		brushFgColorStr, SvgUnit( strokeWidth ), _clipNo, _brushPattern, getCommentStr( "<!-- style : HWavePattern -->" ) );

	double lWaveHeight = lGapH / 2;
	const double lW = nAtomLen * nLineW;
	rtClip.InflateRect(lGapH, lGapV);
	double lBottom = rtCanvas.bottom + lGapV;
	if (rtClip.bottom < lBottom) lBottom = rtClip.bottom;
	double lRight = rtCanvas.right + lGapH;
	if (rtClip.right < lRight) lRight = rtClip.right;
	double lStartX;
	for (lStartX = rtCanvas.left; lStartX < rtClip.left; lStartX += lGapH);
	double lStartY;
	for (lStartY = rtCanvas.top; lStartY < rtClip.top; lStartY += lGapV);
	double lX, lY;
	double prevX, prevY, nextX, nextY;
	for (lY = lStartY; lY < lBottom; lY += lGapV)
	{
		//pDC->MoveTo(lStartX, lY);
		prevX = lStartX; prevY = lY;
		formatStr = getFormatString( "<line x1='%n' y1='%n' x2='%n' y2='%n'/>\n" );
		for (lX = lStartX; lX < lRight; lX += lGapH)
		{
			nextX = lX + lWaveHeight; nextY = lY - lWaveHeight;
			fprintf( _fptr, formatStr, SvgUnitOffsetX( prevX ), SvgUnitOffsetY( prevY ), 
				SvgUnitOffsetX( nextX ), SvgUnitOffsetY( nextY ) );
			prevX = nextX; prevY = nextY;
			nextX = lX + 2 * lWaveHeight; nextY = lY;
			fprintf( _fptr, formatStr, SvgUnitOffsetX( prevX ), SvgUnitOffsetY( prevY ), 
				SvgUnitOffsetX( nextX ), SvgUnitOffsetY( nextY ) );
			prevX = nextX; prevY = nextY;
		}
	}

	// _xZkqqHx_iDfIiDfOiDeDiDiLiOhHjCoIiCmM_xHqqkZx_g_xZkqqHx_iPeJjHlJiDfOiDeP_xHqqkZx_
	fprintf( _fptr, "</g>%s\n", getCommentStr( "<!-- style : HWavePattern -->" ) );

} // SvgExportInfo::printSvgHWavePattern.




/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	SvgExportInfo::printSvgVWavePattern
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jEhHiMgJjAeGiCmMjDgIiCoIiCmCiCnEiClFiCmJiBeBjBePiMgJjAeGiCmMjAiCjClMjFpLiMpMiCmMjEgHjGmNjHgMiCkKiMeKiCoIjFnEiClH_xHqqkZx_
 *			_xZkqqHx_iDhAiDfOiBfLiDjDiCpAjFgAiJoGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_rtCanvas_xZkqqHx_iCpAiOpDiCkPiOoGiCoJiPoKiNiHiCmN_xHqqkZx_
 *				 NULL _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			cr	:_xZkqqHx_jBePiMgJjAeGiCpAiOhHjCoIiBeC_xHqqkZx_
 *			nAtomLen	:_xZkqqHx_jFgAiJoGiCmMiNmFiPkMjCfAiImKiCpAiOhHjCoIiBeCiJpAjBjMjDhIiCmJiCoGiCmBiCmEjFmPiJlLiClHiCoJiBeC_xHqqkZx_
 *			rtCanvas	:_xZkqqHx_iDhAiDfOiBfLiDjDiCpAjFgAiJoGiClHiCoJiLoJiMgAiCpAiOhHjCoIiBeC_xHqqkZx_pDC = NULL _xZkqqHx_iCmMiPoKiNiHiBeB_xHqqkZx_
 *						 _xZkqqHx_iDhAiDfOiBfLiDjDiCmMiMeKiCoIjFnEiClFiCmMiNmFiPkMjCfAiImKiCmMiLoJiMgAiCkKjFnEiCoJiBeC_xHqqkZx_
 *			nSkip		:_xZkqqHx_jFgAiJoGiClHiCoJiDhAiDfOiBfLiDjDiCmMiMeKiCoIjFnEiClFiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			nWaveW		:_xZkqqHx_jFgAiJoGiClHiCoJjEgHiCmMjFjNiCpAiOhHjCoIiBeC_xHqqkZx_
 *			nLineW		:_xZkqqHx_jFgAiJoGiClHiCoJiDhAiDfOiBfLiDjDiCmMjApMiCmMjFjNiCpAiOhHjCoIiBeC_xHqqkZx_
 *			rtClip		:_xZkqqHx_jFgAiJoGiOjOiCmMiDhNiDfIiDeOiDeOiDiKiDgCiDhGiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void SvgExportInfo::printSvgVWavePattern (char *brushFgColorStr, double nAtomLen, CSRect& rtCanvas,
								short nSkip, short nWaveW, short nLineW, CSRect rtClip)
{
	double lGapV = nAtomLen * nWaveW;
	double lGapH = nAtomLen * nSkip;

	if ( rtCanvas.left == rtCanvas.right && rtCanvas.top == rtCanvas.bottom )
	{
		while (lGapV < 16 || lGapH < 16)
		{
			lGapV *= 2;
			lGapH *= 2;
		}
		rtCanvas.SetRect(0, 0, lGapH, lGapV);
		return;
	}

	double strokeWidth = nAtomLen * nLineW * _unitsPerMM;

	// _xZkqqHx_iDfIiDfOiDeDiDiLiOhHjCoIiCmM_xHqqkZx_g_xZkqqHx_iKeKiOgOiDfOiDeP_xHqqkZx_
	char *formatStr = getFormatString( "<g style='stroke:%s; stroke-width:%n;clip-path:url(#DynamicDraw_clip%d_ptn%d)'>%s\n" );
	fprintf( _fptr, formatStr,
		brushFgColorStr, SvgUnit( strokeWidth ), _clipNo, _brushPattern, getCommentStr( "<!-- style : VWavePattern -->" ) );

	double lWaveHeight = lGapV / 2;
	const double lW = nAtomLen * nLineW;
	rtClip.InflateRect(lGapH, lGapV);
	double lBottom = rtCanvas.bottom + lGapV;
	if (rtClip.bottom < lBottom) lBottom = rtClip.bottom;
	double lRight = rtCanvas.right + lGapH;
	if (rtClip.right < lRight) lRight = rtClip.right;
	double lStartX;
	for (lStartX = rtCanvas.left; lStartX < rtClip.left; lStartX += lGapH);
	double lStartY;
	for (lStartY = rtCanvas.top; lStartY < rtClip.top; lStartY += lGapV);
	double lX, lY;
	double prevX, prevY, nextX, nextY;
	for (lX = lStartX; lX < lRight; lX += lGapH)
	{
		prevX = lX; prevY = lStartY;
		formatStr = getFormatString( "<line x1='%n' y1='%n' x2='%n' y2='%n'/>\n" );
		for (lY = lStartY; lY < lBottom; lY += lGapV)
		{
			nextX = lX - lWaveHeight; nextY = lY + lWaveHeight;
			fprintf( _fptr, formatStr, SvgUnitOffsetX( prevX ), SvgUnitOffsetY( prevY ), 
				SvgUnitOffsetX( nextX ), SvgUnitOffsetY( nextY ) );
			prevX = nextX; prevY = nextY;
			nextX = lX; nextY = lY + 2 * lWaveHeight;
			fprintf( _fptr, formatStr, SvgUnitOffsetX( prevX ), SvgUnitOffsetY( prevY ), 
				SvgUnitOffsetX( nextX ), SvgUnitOffsetY( nextY ) );
			prevX = nextX; prevY = nextY;
		}
	}

	// _xZkqqHx_iDfIiDfOiDeDiDiLiOhHjCoIiCmM_xHqqkZx_g_xZkqqHx_iPeJjHlJiDfOiDeP_xHqqkZx_
	fprintf( _fptr, "</g>%s\n", getCommentStr( "<!-- style : VWavePattern -->" ) );

} // SvgExportInfo::printSvgVWavePattern.


