/*
The contents of this file are subject to the Mozilla Public License
Version 1.1 (the "License"); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS"
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is "SVG Export" plug-in for DynamicDraw.

The Initial Developer of the Original Code is FUKUSHIRO Masayuki.

Copyright (C) 2001,2002  FUKUSHIRO Masayuki ( yt3m-fksr@asahi-net.or.jp ), 
HIROSAWA Masashi ( hirosawa@cam.hi-ho.ne.jp ). 
All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms
of the GNU General Public License Version 2 (the "GPL"), in which case
the provisions of the GPL are applicable instead of those above.  If you
wish to allow use of your version of this file only under the terms of
the GPL and not to allow others to use your version of this file under
the MPL, indicate your decision by deleting the provisions above and
replace them with the notice and other provisions required by the
GPL.

Alternatively, the contents of this file may be used under the terms
of the New BSD License (the "BSDL"), in which case the provisions
of the BSDL are applicable instead of those above.  If you wish
to allow use of your version of this file only under the terms of
the BSDL and not to allow others to use your version of this file under
the MPL, indicate your decision by deleting the provisions above and
replace them with the notice and other provisions required by the BSDL.

If you do not delete the provisions above, a recipient may use
your version of this file under any of the MPL, the GPL or the BSDL.
*/

#ifndef SVGEXPORTINFO_H
#define SVGEXPORTINFO_H

#include "CSRect.h"

struct PrintTextInfo;


class PrintSvgOLEProcess;


//----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//#define SVG_EXPORT_VERSION "1.1.1"
//#define SVG_EXPORT_VERSION_L L"1.1.1"
//----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
#define SVG_EXPORT_VERSION "1.1.2"
#define SVG_EXPORT_VERSION_L L"1.1.2"
//----- 06.06.29 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----


// _xZkqqHx_iDhFiDiJiDfGiDhAiDfOiBfLiDjDiCkKjBeJjBpAiClDiCoKiCmEiCkCiCmIiCkC_xHqqkZx_
#define SVG_NO_BRUSHPATTERN	0xFFFE

#define PRINT_SVG_CLIP_PATH		true
#define NOT_PRINT_SVG_CLIP_PATH	false

// printTransform_xZkqqHx_iIpIjAjEjHhA_xHqqkZx_
#define SI_NO_TEXT_ANGLE_TRANSFORM	false
#define SI_TEXT_ANGLE_TRANSFORM	true


struct SvgExportInfo {

public :
	wchar_t *_svgFileName; // SVG_xZkqqHx_iPgPjHmNiDhEiDeAiDeDiDiL_xHqqkZx_
	FILE *_fptr; // SVG_xZkqqHx_iPgPjHmNiDhEiDeAiDeDiDiL_xHqqkZx_
	FCObjDynabase *_objectExp; // _xZkqqHx_jFjEjFgJiDhMiDeDiDjDiDfO_xHqqkZx_
	char *_partsName; // _xZkqqHx_jFjEjFgJjGlMiBeCjFeLjHhGiCmIiCoHjAnNjCoIiClHiCoJiBeC_xHqqkZx_
// 06.07.03 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	DBLPointVector* _pmmptvPoly; // _xZkqqHx_iDhMiDeDiDjDiDgHjEhKjHpB_xHqqkZx_
	double _unitsPerMM; // <unitsPerMM> units = 1 mm
	DBLPoint _offsetLeftTop; // _xZkqqHx_iPgPjHmNjEmNiImNiCmMiNlGiPoDiNmAjFfHiBgJiClBiCoKiClOiCkPiIpIiCkNiBgK_xHqqkZx_

	fmmetol _penWidth; // _xZkqqHx_iDhJiDjDiCmMjBlOiClD_xHqqkZx_
	const FCPenStyleRec *_recPenStyle; // _xZkqqHx_iDhJiDjDiCmMiDfIiDfOiDeDiDiL_xHqqkZx_
	COLORREF _penBgColor; // _xZkqqHx_iDhJiDjDiCmMjEhHiMgJjAeG_xHqqkZx_
	COLORREF _brushFgColor; // _xZkqqHx_iDhFiDiJiDfGiCmMjBePiMgJjAeG_xHqqkZx_
	COLORREF _brushBgColor; // _xZkqqHx_iDhFiDiJiDfGiCmMjEhHiMgJjAeG_xHqqkZx_
	PatternID _brushPattern; // _xZkqqHx_iDhFiDiJiDfGiCmMiDhAiDfOiBfLiDjD_xHqqkZx_ID 

// 06.07.04 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	bool	_isFillPainted;	// _xZkqqHx_jDgIiCoIiCmCiCnEiClHiCkJiBeI_xHqqkZx_

	bool _shouldPrintClippedBrushPattern;

	static SvgExportOption svgExportOption;

	int _clipNo;
	int _imageNo;
	int _objectIndex; // _xZkqqHx_iDfCiDiBiDjDiDgHjHhAiDeJiDhFiDfHiDeGiDeOiDgHjEnEiNiG_xHqqkZx_
	int _shadowNo;

	bool _isChipMaster; // _xZkqqHx_iDgAiDgCiDhGiDhNiDfIiDfOiBfLjFjEjFgJiCkJiCmHiCkEiCkJ_xHqqkZx_

public:
	// _xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfO_xHqqkZx_
	SvgExportInfo();

	// _xZkqqHx_iImIiJlKiCmMjBkOjAkLiCpAjAnNjCoI_xHqqkZx_
	//   _xZkqqHx_iDhJiDjDiCmMjBlOiClDiBeCjCfAiImK_xHqqkZx_=mm_xZkqqHx_iBeC_xHqqkZx_
	//   _xZkqqHx_iDhJiDjDiCmMiDfIiDfOiDeDiDiLiBgJjClMjApMiBeBiNlNjApMjDjJiBgK_xHqqkZx_
	//   _xZkqqHx_iDhJiDjDiCmMjEhHiMgJjAeG_xHqqkZx_
	//   _xZkqqHx_iDhFiDiJiDfGiCmMjBePiMgJjAeG_xHqqkZx_
	//   _xZkqqHx_iDhFiDiJiDfGiCmMjEhHiMgJjAeG_xHqqkZx_
	void setStyle();

	int printSVG();

	int makeHtmlFilename( wchar_t *wideFilePath, char *mbcSvgFilename );

private :
// 06.07.04 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	int printSvgWidePolyOutline( bool printClipPath );

	// _xZkqqHx_jApMjFkKiDfPiDgCiDfGiDiFjFlGiOjKjHpBiCpAjDlOiCoJ_xHqqkZx_
	//   dashStr_xZkqqHx_iCmNjHfMiCnPiKgNjFnLiClFiCmEiCkIiCkN_xHqqkZx_
	void getExportDashStr( char *dashStr );

//----- 06.07.04 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_jDgIiCoIiCmCiCnEiClFjAeGjFlGiOjKjHpBiCpAjDlOiCoJ_xHqqkZx_
//	//   brushBgRgbStr_xZkqqHx_iCmNiCkAiCoHiCkJiClGiCnPiKgNjFnLiClFiCmEiCkIiCkN_xHqqkZx_
//	void getExportFilledColorStr( char *brushBgRgbStr );
//----- 06.07.04 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

	bool isPrintableObject();

	int printEachSVG( bool printClipPath );

	// _xZkqqHx_iJgFiPiIjHjN_xHqqkZx_
	int printShadow();

	int printText();
	int printTextChangeFont( PrintTextInfo *printTextInfo );
	int printTextChangeColor( PrintTextInfo *printTextInfo );
	int printTextChangeLineCrossstat( PrintTextInfo *printTextInfo );
	int printTextChar( PrintTextInfo *printTextInfo );
	int printTextBufferedChar( PrintTextInfo *printTextInfo );

	int printSvgUnsupported();

// 06.07.03 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	int printSvgLine();

	int printSvgRectBase( bool printClipPath );

	int printSvgRect( bool printClipPath );

	int printSvgRoundRect( bool printClipPath );

	int printSvgCircle( bool printClipPath );
	int printSvgEllipse( bool printClipPath );
	int printSvgPie( bool printClipPath );
	int printSvgChord( bool printClipPath );
	int printSvgArcLine( bool printClipPath );
	int printSvgArcLineBase( bool printClipPath );
	int printSvgArc( bool printClipPath );

//----- 06.07.04 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	int printSvgPoly( bool printClipPath );
//	int printSvgLinePoly( bool printClipPath );
//	int printSvgCubicBezierPoly( bool printClipPath );
//----- 06.07.04 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 06.07.03 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	int printSvgFigLine (const FCMmPolyBezier& polyBezier, bool printClipPath, bool isArrowStyle);
	int printSvgFigPoly (const FCMmPolyBezier& polyBezier, bool printClipPath, bool isArrowStyle);
	int printSvgFigBezier (const FCMmPolyBezier& polyBezier, bool bIsClose, bool printClipPath, bool isArrowStyle);
	int printSvgFigLPB (const FCMmPolyBezier& polyBezier, bool bIsClose, bool printClipPath, bool isArrowStyle);
	int printSvgFigure (bool printClipPath);
//----- 06.07.03 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	int printSvgGroup();
// 06.07.03 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	int printSvgTable();

	int printSvgChipMaster();

	int printSvgWidePoly( bool printClipPath );

	int printSvgArrowObjVector( ObjDynabaseVector *objVector );
// 06.07.04 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	int printSvgArrowPolygon( DBLPointVector *vmmptArrowPoly, bool isArrowMainBody );

//----- 06.07.03 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	int printSvgArrow( FCBaseArrow *pArrowF, FCBaseArrow *pArrowB, BOOL *bIsWidePoly );
//----- 06.07.03 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	int printSvgPreArrow (FCBaseArrow *pArrowF, FCBaseArrow *pArrowB);
	int printSvgMainArrow (FCBaseArrow *pArrowF, FCBaseArrow *pArrowB);
	int printSvgPostArrow (FCBaseArrow *pArrowF, FCBaseArrow *pArrowB);
//----- 06.07.03 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
// 06.07.01 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	int printSvgPictArrow();

	// _xZkqqHx_iKePjFjEiDhEiDeAiDeDiDiLiPgPjHmN_xHqqkZx_
	int printSvgLabelPencilFile( double x, double y, double width, double height );

	// SVG_xZkqqHx_jDoAjGiEiCnPiNjOiCnN_xHqqkZx_
	int printSvgLabelPencilBase64( double x, double y, double width, double height );

	int printSvgLabel( bool printClipPath );

//----- 06.07.01 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	int printSvgTextRect( bool printClipPath );
//----- 06.07.01 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	int makePngFilename( wchar_t *wideFilename, char *mbcFilename );
	int printSvgOLEInside();
	int printSvgOLEOutside();
	int printSvgOLE( bool printClipPath );

	int printClipPathDefs();

	// _xZkqqHx_iDhFiDiJiDfGiDhAiDfOiBfLiDjDiCpAiDeOiDiKiDgCiDhDiDjDiDePiOhHjCoIjFhEiCmFiPgPjHmNiClHiCoJ_xHqqkZx_
	int printClippedBrushPattern();

	void printSvgPinholePattern (char *brushFgColorStr, double nAtomLen, CSRect& rtCanvas,
								short nSkip, short nHoleW, CSRect rtClip);
	void printSvgStarPattern (char *brushFgColorStr, double nAtomLen, CSRect& rtCanvas,
								short nSkip, short nStarW, CSRect rtClip);
	void printSvgVLinePattern (char *brushFgColorStr, double nAtomLen, CSRect& rtCanvas,
								short nSkip, short nLineW, CSRect rtClip);
	void printSvgHLinePattern (char *brushFgColorStr, double nAtomLen, CSRect& rtCanvas,
								short nSkip, short nLineW, CSRect rtClip);
	void printSvgLDLinePattern (char *brushFgColorStr, double nAtomLen, CSRect& rtCanvas,
								short nSkip, short nLineW, CSRect rtClip);
	void printSvgRDLinePattern (char *brushFgColorStr, double nAtomLen, CSRect& rtCanvas,
								short nSkip, short nLineW, CSRect rtClip);
	void printSvgVHLatticePattern (char *brushFgColorStr, double nAtomLen, CSRect& rtCanvas,
									short nSkip, short nLineW, CSRect rtClip);
	void printSvgDgLatticePattern (char *brushFgColorStr, double nAtomLen, CSRect& rtCanvas,
									short nSkip, short nLineW, CSRect rtClip);
	void printSvgHWavePattern (char *brushFgColorStr, double nAtomLen, CSRect& rtCanvas,
								short nSkip, short nWaveW, short nLineW, CSRect rtClip);
	void printSvgVWavePattern (char *brushFgColorStr, double nAtomLen, CSRect& rtCanvas,
								short nSkip, short nWaveW, short nLineW, CSRect rtClip);

	// style_xZkqqHx_jFlGiOjKjHpBiCpAiPgPjHmNiClHiCoJ_xHqqkZx_
	void printStyle( bool isArrowStyle );

	void printTransform( bool isTextAngle );

	// "%f"_xZkqqHx_iCpAiDeJiDhGiDfGiDiHiDjDiCmM_xHqqkZx_digitNum_xZkqqHx_iCmJiCoGiCoJjAlIjDhIjFhEiCmJiClFiCmEjFnEiClH_xHqqkZx_
	char* getFormatString( char *orgFormatString );

	// _xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiDfOiDeDiDhGiCpAiMkJiCmEiBeB_xHqqkZx_shouldPrintClippedBrushPattern_xZkqqHx_iCpAjAnNjCoIiClHiCoJ_xHqqkZx_
	int setShouldPrintClippedBrushPattern();


};

char* getCommentStr( char * commentStr );

int exportSelectedObjToSVGFile( const wchar_t* wcpFileName,
									mmetol mmMarginLeft, mmetol mmMarginTop,
									mmetol mmMarginRight, mmetol mmMarginBottom );

void GetPasteObjFrame (DBLRect& mmrtFrame, const ObjDynabaseVector& vObj);

#ifndef M_PI
#	define M_PI	3.1415926535897932384626433832795
#endif

#ifndef RADRATE2DEG
#	define RADRATE2DEG( radrate ) (180 * (radrate))
#endif

#ifndef RAD2DEG
#	define RAD2DEG( rad ) (180 * (rad) / M_PI )
#endif

// printSvg*Pattern_xZkqqHx_iCmFiOgHiCoNiCoKiCoJiBeBjFgAiJoGiDgIiDgCiDgHiCmG_xHqqkZx_mm_xZkqqHx_iCmMjEoEjHkG_xHqqkZx_
#define	SVG_PATTERN_DOT_PER_MM	5.0

#define SvgUnitOffsetX( value ) ( ( (value) - _offsetLeftTop.x ) * _unitsPerMM )
#define SvgUnitOffsetY( value ) ( ( (value) - _offsetLeftTop.y ) * _unitsPerMM )
#define SvgUnit( value ) ( (value) * _unitsPerMM )

#define SvgOffsetX( value ) ( (value) - _offsetLeftTop.x )
#define SvgOffsetY( value ) ( (value) - _offsetLeftTop.y )

// _xZkqqHx_jFnEiCoIjCgM_xHqqkZx_
#define SVGEXPORT_OK	0
#define SVGEXPORT_ERROR	1
#define SVGEXPORT_FATAL_ERROR	2
#define SVGEXPORT_CONTINUABLE_ERROR	3

void printContinuableDialog( char *filename, int lineNumber );

#ifdef _DEBUG
int printErrorDialog( int error, char *filename, int lineNumber, char *message );
#endif

#ifdef _DEBUG
#	define SE_ERROR_RETURN( errorNo ) \
		printErrorDialog( (errorNo), __FILE__, __LINE__, NULL )
#	define SE_ERROR_RETURN_WM( errorNo, message ) \
		printErrorDialog( (errorNo), __FILE__, __LINE__, message )
#else
#	define SE_ERROR_RETURN( errorNo ) \
		(errorNo)
#	define SE_ERROR_RETURN_WM( errorNo, message ) \
		(errorNo)
#endif

// result_xZkqqHx_iCmMjCgMiCmJiCoGiCmBiCmEiBeBiImIiJlKiCmMiPiIjHjNiCpAiNhDiCkEiBeC_xHqqkZx_
//   SVGIMPORT_OK : _xZkqqHx_iJlNiCoAiClJiClIiBeBiPiIjHjNiCpAjBlBiCkPiCoJ_xHqqkZx_
//   SVGIMPORT_CONTINUABLE_ERROR : _xZkqqHx_jBlBiNhDiJmCjEfMiDeHiDiJiBfLiDfPiDeDiDeBiDiNiDePiCpAiPgPiClFiCmEiBeBiPiIjHjNiCpAjBlBiCkPiCoJ_xHqqkZx_
//   _xZkqqHx_iClLiCoKiImIiKeP_xHqqkZx_ : _xZkqqHx_iDeHiDiJiBfLiDfPiDeDiDeBiDiNiDePiCpAjFfMiOkGiClFiCmEiBeB_xHqqkZx_result_xZkqqHx_iCmMjFnEiCoIjCgMiCmFiKnGjAjEiCpAjElCiCkPiCoJ_xHqqkZx_
/*
#define SE_RESULT_CHECK( result ) \
	if ( result ) { \
		if ( SVGEXPORT_CONTINUABLE_ERROR != (result) ) { \
			printErrorDialog( result, __FILE__, __LINE__, NULL ); \
			return SE_ERROR_RETURN(result); \
		} \
		printContinuableDialog( __FILE__, __LINE__ );\
	}
	*/
#define SE_RESULT_CHECK( result ) \
	if ( result ) { \
		if ( SVGEXPORT_CONTINUABLE_ERROR != (result) ) { \
			return SE_ERROR_RETURN(result); \
		} \
		printContinuableDialog( __FILE__, __LINE__ );\
	}

// result_xZkqqHx_iCmMjCgMiCmJiCoGiCmBiCmEiBeBiImIiJlKiCmMiPiIjHjNiCpAiNhDiCkEiBeC_xHqqkZx_
//   SVGIMPORT_OK : _xZkqqHx_iJlNiCoAiClJiClIiBeBiPiIjHjNiCpAjBlBiCkPiCoJ_xHqqkZx_
//   SVGIMPORT_CONTINUABLE_ERROR : _xZkqqHx_jBlBiNhDiJmCjEfMiDeHiDiJiBfLiDfPiDeDiDeBiDiNiDePiCpAiPgPiClFiCmEiBeBiPiIjHjNiCpAjBlBiCkPiCoJ_xHqqkZx_
//   _xZkqqHx_iClLiCoKiImIiKeP_xHqqkZx_ : _xZkqqHx_iDeHiDiJiBfLiDfPiDeDiDeBiDiNiDePiCpAjFfMiOkGiClFiCmEiBeB_xHqqkZx_gotoLabel_xZkqqHx_iCnG_xHqqkZx_goto_xZkqqHx_iDfHiDiDiDjDiDhGiClFiCmEiBeB_xHqqkZx_
//              result_xZkqqHx_iCmMjFnEiCoIjCgMiCmFiKnGjAjEiCpAjElCiCkPiCoJ_xHqqkZx_
#define SE_RESULT_CHECK_GOTO( result, gotoLable ) \
	if ( result ) { \
		if ( SVGEXPORT_CONTINUABLE_ERROR != (result) ) { \
			printErrorDialog( result, __FILE__, __LINE__, NULL ); \
			goto gotoLable;\
		} \
		printContinuableDialog( __FILE__, __LINE__ );\
		goto gotoLable;\
	}

// ptr_xZkqqHx_iCmMjCgMiCmJiCoGiCmBiCmEiBeBiImIiJlKiCmMiPiIjHjNiCpAiNhDiCkEiBeC_xHqqkZx_
//   NULL_xZkqqHx_iImIiKeP_xHqqkZx_ : _xZkqqHx_iJlNiCoAiClJiClIiBeBiPiIjHjNiCpAjBlBiCkPiCoJ_xHqqkZx_
//   NULL : result_variable_xZkqqHx_iCmJ_xHqqkZx_error_no_xZkqqHx_iCpAjAnNjCoIiClFiBeB_xHqqkZx_error_no_xZkqqHx_iCmMjCgMiCmJiCoGiCmBiCmEiBeB_xHqqkZx_
//   _xZkqqHx_iImIiJlKiCmMiPiIjHjNiCpAiNhDiCkEiBeC_xHqqkZx_
//     SVGIMPORT_CONTINUABLE_ERROR : _xZkqqHx_jBlBiNhDiJmCjEfMiDeHiDiJiBfLiDfPiDeDiDeBiDiNiDePiCpAiPgPiClFiCmEiBeBiPiIjHjNiCpAjBlBiCkPiCoJ_xHqqkZx_
//     _xZkqqHx_iClLiCoKiImIiKeP_xHqqkZx_ : _xZkqqHx_iDeHiDiJiBfLiDfPiDeDiDeBiDiNiDePiCpAjFfMiOkGiClFiCmEiBeB_xHqqkZx_gotoLabel_xZkqqHx_iCnG_xHqqkZx_goto_xZkqqHx_iDfHiDiDiDjDiDhGiClFiCmEiBeB_xHqqkZx_
//              error_no_xZkqqHx_iCmMjFnEiCoIjCgMiCmFiKnGjAjEiCpAjElCiCkPiCoJ_xHqqkZx_
#define SE_NULL_CHECK_GOTO( ptr, result_variable, error_no, gotoLable ) \
	if ( NULL == (ptr) ) { \
		(result_variable) = (error_no);\
		if ( SVGEXPORT_CONTINUABLE_ERROR != (error_no) ) { \
			printErrorDialog( error_no, __FILE__, __LINE__ ); \
			goto gotoLable;\
		} \
		printContinuableDialog( __FILE__, __LINE__ );\
		goto gotoLable;\
	}


#endif // SVGEXPORTINFO_H
