/*
The contents of this file are subject to the Mozilla Public License
Version 1.1 (the "License"); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS"
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is "SVG Export" plug-in for DynamicDraw.

The Initial Developer of the Original Code is FUKUSHIRO Masayuki.

Copyright (C) 2001,2002  FUKUSHIRO Masayuki ( yt3m-fksr@asahi-net.or.jp ), 
HIROSAWA Masashi ( hirosawa@cam.hi-ho.ne.jp ). 
All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms
of the GNU General Public License Version 2 (the "GPL"), in which case
the provisions of the GPL are applicable instead of those above.  If you
wish to allow use of your version of this file only under the terms of
the GPL and not to allow others to use your version of this file under
the MPL, indicate your decision by deleting the provisions above and
replace them with the notice and other provisions required by the
GPL.

Alternatively, the contents of this file may be used under the terms
of the New BSD License (the "BSDL"), in which case the provisions
of the BSDL are applicable instead of those above.  If you wish
to allow use of your version of this file only under the terms of
the BSDL and not to allow others to use your version of this file under
the MPL, indicate your decision by deleting the provisions above and
replace them with the notice and other provisions required by the BSDL.

If you do not delete the provisions above, a recipient may use
your version of this file under any of the MPL, the GPL or the BSDL.
*/

#ifndef SVGEXPORTOPTION_H
#define SVGEXPORTOPTION_H

// 06.07.04 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//#define SVG_EXPORT_VERSION_NUM 110
#define SVG_EXPORT_VERSION_NUM 112

struct SvgExportOption {

	// _xZkqqHx_iDgPiBfLiDfHiDiHiDjD_xHqqkZx_
	int _version;

	// _xZkqqHx_iPkMjAjEjDfPiImIiJlKiCmMiMiFjAjE_xHqqkZx_
	int _digitNum;

	// WidePoly_xZkqqHx_iCmMiNjMiKgJiCpAiPgPjHmNiClHiCoJiCkJiCmHiCkEiCkJ_xHqqkZx_
	bool _shouldPrintWidePolySkelton;

//----- 06.07.04 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// WidePoly_xZkqqHx_iCmMjHnGiKhDiCpAiPgPjHmNiClHiCoJiCkJiCmHiCkEiCkJ_xHqqkZx_
//	bool _shouldPrintWidePolyOutline;
//	// WidePoly_xZkqqHx_iCmMjHnGiKhDiCmMiNnHiCkJiClDiBeC_xHqqkZx_0.0_xZkqqHx_iCmMiOjOiCmNiPgPjHmNiClFiCmIiCkC_xHqqkZx_
//	mmetol _widePolyOutlineUnit;
//----- 06.07.04 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

	bool _printComment;		// _xZkqqHx_iDfCiDiBiDjDiDgHiCpAiPgPjHmNiClHiCoJiCkJiBeI_xHqqkZx_

	bool _printBase64Png;	// SVG_xZkqqHx_jDoAjFjEiCmJjGiEiCnPiNjOiCnNiCkJiBeI_xHqqkZx_

// 06.07.04 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	bool _printBackpictAsPng;	// _xZkqqHx_jEhHiMgJjAhNiCpAiOjNiCmCjAhNiMgAiCpA_xHqqkZx_PNG_xZkqqHx_iPgPjHmNiClHiCoJiCkJiBeI_xHqqkZx_

	bool _useOleTrans; // PNG_xZkqqHx_iPgPjHmNiCmJjDkHjGlOjAeGiOhHjCoIiClHiCoJiCkJiCmHiCkEiCkJ_xHqqkZx_

	bool _textPosEach; // _xZkqqHx_iDgFiDeMiDfIiDgHjFlGiOjKiImKjChFiCpAiKgFjFlGiOjKiCmFiPgPjHmNiClHiCoJiCkJiCmHiCkEiCkJ_xHqqkZx_

	bool _htmlOutput; // HTML_xZkqqHx_iDhEiDeAiDeDiDiLiPgPjHmNiClHiCoJiCkJiCmHiCkEiCkJ_xHqqkZx_

	short _dpi; // HTML_xZkqqHx_iDhEiDeAiDeDiDiLiPgPjHmNiClHiCoJiOjOiCmMjBoFiCkLiClD_xHqqkZx_(mm_xZkqqHx_iCmGiDgIiDgCiDgHiCmMiKlHiOfK_xHqqkZx_)

public :
	SvgExportOption() : _version(0), _digitNum(6),
// 06.07.04 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//		_shouldPrintWidePolyOutline(true),
		_shouldPrintWidePolySkelton(false),
// 06.07.04 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//		_widePolyOutlineUnit(5.0),
		_printComment(true),
		_printBase64Png(true),

// 06.07.04 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
		_printBackpictAsPng(true),	// _xZkqqHx_jEhHiMgJjAhNiCpAiOjNiCmCjAhNiMgAiCpA_xHqqkZx_PNG_xZkqqHx_iPgPjHmNiClHiCoJiCkJiBeI_xHqqkZx_

		_useOleTrans(false), _textPosEach(false), _htmlOutput(false), _dpi(72) {}
	~SvgExportOption() {}

	void setDefault() {	
		_version = SVG_EXPORT_VERSION_NUM;
		_digitNum = 6;
// 06.07.04 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//		_shouldPrintWidePolyOutline = true;
		_shouldPrintWidePolySkelton = false;
// 06.07.04 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//		_widePolyOutlineUnit = 5.0;
		_printComment = true;
		_printBase64Png = true;
// 06.07.04 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
		_printBackpictAsPng = true;	// _xZkqqHx_jEhHiMgJjAhNiCpAiOjNiCmCjAhNiMgAiCpA_xHqqkZx_PNG_xZkqqHx_iPgPjHmNiClHiCoJiCkJiBeI_xHqqkZx_

		_useOleTrans = false;
		_textPosEach = false;
		_htmlOutput = false;
		_dpi = 72;
	}
};

#endif // SVGEXPORTOPTION_H

