#!/bin/sh

# Copyright (c) 2012 ken.naruo
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.

# .root load
LANG=C;export LANG
SCRIPT_DIR=`dirname $0`
. ${SCRIPT_DIR}/.root

PROJECT=$1
JOBNET=$2
JOBNET_HOME=${ROOT}/project/${PROJECT}/${JOBNET}
CONTROLLER=${JOBNET_HOME}/controller.sh

if [ "${PROJECT}" = "" -o "${JOBNET}" = "" ];then
 echo "usage: enable_jobnet.sh <PROJECT> <JOBNET>"
 exit 1
fi

if [ ! -f ${ROOT}/project/${PROJECT}/${JOBNET}/jobnet.prof ];then
 echo "jobnet is not exist"
 exit 1
fi

## jobnet prof load
grep -v SCHEDULE ${ROOT}/project/${PROJECT}/${JOBNET}/jobnet.prof > ${ROOT}/project/${PROJECT}/${JOBNET}/.jobnet_tmp
. ${ROOT}/project/${PROJECT}/${JOBNET}/.jobnet_tmp

if [ "$JOB_ORDER" = "" ];then
 echo "ERROR JOB_ORDER is not defined"
 exit 1
fi

## job check
for JOB in ${JOB_ORDER}
do
 ls ${ROOT}/project/${PROJECT}/${JOBNET}/${JOB} > /dev/null 2>&1
 if [ $? != 0 ];then
  echo "${JOB} ERROR JOB FILE is not exist ${ROOT}/project/${PROJECT}/${JOBNET}/${JOB}"
  exit 1
 fi
done

## message check
MESSAGE_CHECK=`echo ${OUTPUT_MESSAGE} | awk {'print $2'}`
if [ "${MESSAGE_CHECK}" ];then
 echo "OUTPUT_MESSAGE is one message only"
 exit 1
fi

## controller create
if [ -f ${ROOT}/project/${PROJECT}/${JOBNET}/controller.sh ];then
 echo "already exist controller file ${ROOT}/project/${PROJECT}/${JOBNET}/controller.sh"
 exit 1
fi

ln -s ${ROOT}/template/_controller.sh ${ROOT}/project/${PROJECT}/${JOBNET}/controller.sh

echo "-------------------------------------------------------------"
echo "JOBNET:${JOBNET} controller created succesfully"
echo "notice:please execute \"enable_jobnet.sh ${PROJECT} ${JOBNET}\""

## cluster_check
. ${ROOT}/project/${PROJECT}/${JOBNET}/cluster.conf

if [ "${CLUSTER}" = yes -o "${DISPATCH}" = yes ];then
 echo "notice:cluster.conf is defined, execute \"enable_cluster.sh ${PROJECT} ${JOBNET}\""
 else
 echo "notice:cluster.conf is not defined (not clustered)"
fi
echo "-------------------------------------------------------------"

exit 0
