#!/bin/sh

# Copyright (c) 2012 ken.naruo
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.


# .root load
LANG=C;export LANG
SCRIPT_DIR=`dirname $0`
. ${SCRIPT_DIR}/.root

echo "please input project name"
read PROJECTNAME

if [ -d ${ROOT}/project/${PROJECTNAME} ];then
 echo "project is already exist"
 exit 1
fi

if [ "$PROJECTNAME" = "" ];then
 echo "project name is null"
 exit 1
fi

mkdir -p ${ROOT}/project/${PROJECTNAME}

if [ $? != 0 ];then
 echo "ERROR you can't create ${ROOT}/project/${PROJECTNAME}"
 exit 1
fi

chmod 755 ${ROOT}/project/${PROJECTNAME}

if [ $? != 0 ];then
 echo "ERROR you can't change permission ${ROOT}/project/${PROJECTNAME}"
 exit 1
fi

echo ""
echo "-------------------------------------------------------------"
echo "Project create succesfully. "
echo "Project Directory is  ${ROOT}/project/${PROJECTNAME} "
echo "-------------------------------------------------------------"

exit 0
