#!/bin/sh

#############################################
# jobnet check script
#############################################
LANG=C;export LANG
SCRIPT_DIR=`dirname $0`
LOG=${SCRIPT_DIR}/log/jobnet_check_`date +%Y%m%d`

## config load
. ${SCRIPT_DIR}/.root
. ${SCRIPT_DIR}/jobnet_check.conf

QUE_DIR=${ROOT}/que
CHECK_COUNT=`echo ${LONG_TIME}-1 | bc`

#status que
find ${QUE_DIR}/tmp -type f -mtime +${CHECK_COUNT} >> ${LOG} 2>&1
LONG_TIME_JOBNET=`cat ${LOG}`

#send mail
if [ "${MAIL_ADDR}" -a "${LONG_TIME_JOBNET}" ];then
 echo "over ${LONG_TIME} day running jobnet list is following" > /tmp/e-cron_mail.tmp
 chmod 766 /tmp/e-cron_mail.tmp
 echo "project_jobnet" >> /tmp/e-cron_mail.tmp
 cat  ${LOG} | awk -F [/] '{field = $NF } END {print field }' >>  /tmp/e-cron_mail.tmp
 cat /tmp/e-cron_mail.tmp |mailx -s "[WARN]long time running jobnet list" ${MAIL_ADDR} 
fi
exit 0
