#!/bin/sh

# Copyright (c) 2013 ken.naruo
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.

## global conf load
LANG=C;export LANG
UNAME=`uname -n`
SCRIPT_DIR=`dirname $0`
 . ${SCRIPT_DIR}/../global.conf
LOG=${SCRIPT_DIR}/log/clustering_console_`date +%Y%m%d`
ERROR_QUE=${ROOT}/que/daemon_error/${UNAME}_`date +%Y%m%d`

## process check
if [ -f /tmp/clustering_console_lock ];then
  exit 0
else
  touch /tmp/clustering_console_lock
fi

IFCONFIG=/usr/sbin/ifconfig
LINUX=`uname -a | grep Linux`
if [ "${LINUX}" ];then
  IFCONFIG=/sbin/ifconfig
fi

if [ "${MASTER_SERVER}" = "" ];then
  echo "`date +%Y/%m/%d` `date +%H:%M:%S` error master server is not defined" >> ${LOG}
  echo "error master server is not defined" | mailx -s "WARN clustering_console" ${MAIL_ADDR}
fi

if [ "${SSH_PORT}" = "" ];then
  SSH_PORT=22
fi

## alive check
ping -c 3 ${MASTER_SERVER}  > /dev/null 2>&1
if [ $? = 0 ];then
  if [ -f ${ROOT}/utilities/.master_dead.flg ];then
    echo "`date +%Y/%m/%d` `date +%H:%M:%S` ${MASTER_SERVER} recovered, change cluster master " >> ${LOG}
    echo "`date +%Y/%m/%d` `date +%H:%M:%S` console_clustring:${MASTER_SERVER} recovered, change cluster master " >> ${ERROR_QUE}
    echo "${MASTER_SERVER} master console server recovered, change cluster master ${MASTER_SERVER}" | mailx -s "INFO master console server recovered" ${MAIL_ADDR}
    cp ${ROOT}/backup/secondary_keys/* ~/.ssh/

    FAILD_FLAG=""
    scp -P ${SSH_PORT} -p ${ROOT}/map.conf @${MASTER_SERVER}:${ROOT}/
    if [ $? != 0 ];then
      FAILED_FLAG="on"
    fi

    scp -P ${SSH_PORT} -p ${ERROR_QUE} @${MASTER_SERVER}:${ROOT}/que/daemon_error/

    for DIR in project servers
    do
      rsync -e "ssh -p ${SSH_PORT}" -alv --delete ${ROOT}/${DIR} ${MASTER_SERVER}:${ROOT}/ > /dev/null 2>&1
      if [ $? != 0 ];then
        FAILED_FLAG="on"
      fi
    done

    if [ "${FAILED_FLAG}" = on ];then
      echo "`date +%Y/%m/%d` `date +%H:%M:%S` failed to mirror clustering data from ${UNAME} to ${MASTER_SERVER}" >> ${LOG}
      echo "failed to mirror clustering data from ${UNAME} to ${MASTER_SERVER}" | mailx -s "WARN clustering_console" ${MAIL_ADDR}
    fi
    
    ${ROOT}/bin/kill_ecron_daemon
    rm ${ROOT}/utilities/.master_dead.flg
    rm /tmp/clustering_console_lock
    exit 0
  fi

  echo "`date +%Y/%m/%d` `date +%H:%M:%S` master server is alive" >> ${LOG}
  FAILD_FLAG=""
  for DIR in project servers
  do
    rsync -e "ssh -p ${SSH_PORT}" -alv --delete ${MASTER_SERVER}:${ROOT}/${DIR} ${ROOT}/ > /dev/null 2>&1
    if [ $? != 0 ];then
      FAILED_FLAG="on"
    fi
  done

  scp -P ${SSH_PORT} -p @${MASTER_SERVER}:~/.ssh/*rsa* ${ROOT}/backup/master_keys/
  if [ $? != 0 ];then
    FAILED_FLAG="on"
  fi

  scp -P ${SSH_PORT} -p @${MASTER_SERVER}:${ROOT}/map.conf ${ROOT}/
  if [ $? != 0 ];then
    FAILED_FLAG="on"
  fi

  if [ "${FAILED_FLAG}" = on ];then
    echo "`date +%Y/%m/%d` `date +%H:%M:%S` failed to mirror clustering data from ${MASTER_SERVER} to ${UNAME}" >> ${LOG}
    echo "failed to mirror clustering data from ${MASTER_SERVER} to ${UNAME}" | mailx -s "WARN clustering_console" ${MAIL_ADDR}
  fi
  

else
  sleep 60
  ping -c 3 ${MASTER_SERVER}  > /dev/null 2>&1
  if [ $? = 0 ];then
      rm /tmp/clustering_console_lock
      exit 0
  else
    if [ ! -f ${ROOT}/utilities/.master_dead.flg ];then
      echo "`date +%Y/%m/%d` `date +%H:%M:%S` ${MASTER_SERVER} down, change cluster master " >> ${LOG}
      echo "`date +%Y/%m/%d` `date +%H:%M:%S` console_clustring:${MASTER_SERVER} down, change cluster master " >> ${ERROR_QUE}
      echo "${MASTER_SERVER} master console server down, change cluster master to ${UNAME}" | mailx -s "WARN master console server down" ${MAIL_ADDR}
      cp ~/.ssh/*rsa* ${ROOT}/backup/secondary_keys/
      cp ${ROOT}/backup/master_keys/* ~/.ssh/
      ${ROOT}/bin/check_ecron_daemon
      touch ${ROOT}/utilities/.master_dead.flg
    fi
  fi 
fi

rm /tmp/clustering_console_lock
