/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.query;

import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.seasar.extension.jdbc.JdbcContext;
import org.seasar.extension.jdbc.SqlBatchUpdate;
import org.seasar.extension.jdbc.exception.IllegalParamSizeRuntimeException;
import org.seasar.extension.jdbc.exception.SEntityExistsException;
import org.seasar.extension.jdbc.manager.JdbcManagerImplementor;
import org.seasar.extension.jdbc.query.AbstractQuery;
import org.seasar.framework.util.PreparedStatementUtil;
import org.seasar.framework.util.StatementUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlBatchUpdateImpl
extends AbstractQuery<SqlBatchUpdate>
implements SqlBatchUpdate {
    protected int batchSize;
    protected Class<?>[] paramClasses;
    protected List<Object[]> paramsList = new ArrayList<Object[]>();

    public SqlBatchUpdateImpl(JdbcManagerImplementor jdbcManager, String sql, Class<?> ... paramClasses) {
        super(jdbcManager);
        if (sql == null) {
            throw new NullPointerException("sql");
        }
        this.executedSql = sql;
        if (paramClasses == null) {
            throw new NullPointerException("paramClasses");
        }
        this.paramClasses = paramClasses;
    }

    @Override
    public SqlBatchUpdate batchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    @Override
    public SqlBatchUpdate params(Object ... params) {
        this.paramsList.add(params);
        return this;
    }

    @Override
    public int[] execute() {
        this.prepare("execute");
        try {
            return this.executeInternal();
        }
        catch (RuntimeException e) {
            if (this.getJdbcManager().getDialect().isUniqueConstraintViolation(e)) {
                throw new SEntityExistsException(this.executedSql, e);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int[] executeInternal() {
        JdbcContext jdbcContext = this.jdbcManager.getJdbcContext();
        try {
            PreparedStatement ps = this.getPreparedStatement(jdbcContext);
            int batchSize = this.batchSize > 0 ? this.batchSize : this.jdbcManager.getDialect().getDefaultBatchSize();
            int size = this.paramsList.size();
            int[] updateRows = new int[size];
            int pos = 0;
            for (int i = 0; i < size; ++i) {
                Object[] params = this.paramsList.get(i);
                if (params.length != this.paramClasses.length) {
                    this.logger.log("ESSR0709", new Object[]{this.callerClass.getName(), this.callerMethodName});
                    throw new IllegalParamSizeRuntimeException(params.length, this.paramClasses.length);
                }
                for (int j = 0; j < params.length; ++j) {
                    this.addParam(params[j], this.paramClasses[j]);
                }
                this.logSql();
                this.prepareInParams(ps);
                PreparedStatementUtil.addBatch((PreparedStatement)ps);
                this.resetParams();
                if (i != size - 1 && (batchSize <= 0 || (i + 1) % batchSize != 0)) continue;
                int[] rows = PreparedStatementUtil.executeBatch((PreparedStatement)ps);
                System.arraycopy(rows, 0, updateRows, pos, rows.length);
                pos = i + 1;
            }
            int[] nArray = updateRows;
            return nArray;
        }
        finally {
            if (!jdbcContext.isTransactional()) {
                jdbcContext.destroy();
            }
        }
    }

    protected PreparedStatement getPreparedStatement(JdbcContext jdbcContext) {
        PreparedStatement ps = jdbcContext.getPreparedStatement(this.executedSql);
        if (this.queryTimeout > 0) {
            StatementUtil.setQueryTimeout((Statement)ps, (int)this.queryTimeout);
        }
        return ps;
    }

    @Override
    protected void prepare(String methodName) {
        this.prepareCallerClassAndMethodName(methodName);
    }
}

