/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.query;

import java.sql.PreparedStatement;
import java.sql.Statement;
import org.seasar.extension.jdbc.JdbcContext;
import org.seasar.extension.jdbc.SqlFileUpdate;
import org.seasar.extension.jdbc.exception.SEntityExistsException;
import org.seasar.extension.jdbc.manager.JdbcManagerImplementor;
import org.seasar.extension.jdbc.parameter.LobParameter;
import org.seasar.extension.jdbc.parameter.Parameter;
import org.seasar.extension.jdbc.parameter.TemporalParameter;
import org.seasar.extension.jdbc.query.AbstractQuery;
import org.seasar.extension.jdbc.types.ValueTypes;
import org.seasar.extension.sql.Node;
import org.seasar.extension.sql.SqlContext;
import org.seasar.extension.sql.cache.NodeCache;
import org.seasar.extension.sql.context.SqlContextImpl;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.exception.ResourceNotFoundRuntimeException;
import org.seasar.framework.util.PreparedStatementUtil;
import org.seasar.framework.util.StatementUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlFileUpdateImpl
extends AbstractQuery<SqlFileUpdate>
implements SqlFileUpdate {
    protected String path;
    protected Object parameter;
    protected Node node;
    protected SqlContext sqlContext;

    public SqlFileUpdateImpl(JdbcManagerImplementor jdbcManager, String path) {
        this(jdbcManager, path, null);
    }

    public SqlFileUpdateImpl(JdbcManagerImplementor jdbcManager, String path, Object parameter) {
        super(jdbcManager);
        if (path == null) {
            throw new NullPointerException("path");
        }
        this.path = path;
        this.parameter = parameter;
    }

    public String getPath() {
        return this.path;
    }

    @Override
    public int execute() {
        this.prepare("execute");
        try {
            return this.executeInternal();
        }
        catch (RuntimeException e) {
            if (this.getJdbcManager().getDialect().isUniqueConstraintViolation(e)) {
                throw new SEntityExistsException(this.executedSql, e);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int executeInternal() {
        this.logSql();
        int ret = 0;
        JdbcContext jdbcContext = this.jdbcManager.getJdbcContext();
        try {
            PreparedStatement ps = this.getPreparedStatement(jdbcContext);
            ret = PreparedStatementUtil.executeUpdate((PreparedStatement)ps);
        }
        finally {
            if (!jdbcContext.isTransactional()) {
                jdbcContext.destroy();
            }
        }
        return ret;
    }

    protected PreparedStatement getPreparedStatement(JdbcContext jdbcContext) {
        PreparedStatement ps = jdbcContext.getPreparedStatement(this.executedSql);
        if (this.queryTimeout > 0) {
            StatementUtil.setQueryTimeout((Statement)ps, (int)this.queryTimeout);
        }
        this.prepareInParams(ps);
        return ps;
    }

    @Override
    protected void prepare(String methodName) {
        this.prepareCallerClassAndMethodName(methodName);
        this.prepareNode();
        this.prepareParameter();
        this.prepareSql();
    }

    protected void prepareNode() throws ResourceNotFoundRuntimeException {
        this.node = NodeCache.getNode(this.path, this.jdbcManager.getDialect().getName());
        if (this.node == null) {
            this.logger.log("ESSR0709", new Object[]{this.callerClass.getName(), this.callerMethodName});
            throw new ResourceNotFoundRuntimeException(this.path);
        }
    }

    protected void prepareParameter() {
        this.sqlContext = new SqlContextImpl();
        if (this.parameter != null) {
            Class<?> clazz = this.parameter.getClass();
            if (ValueTypes.isSimpleType(clazz) || TemporalParameter.class == clazz || LobParameter.class == clazz) {
                this.sqlContext.addArg("$1", this.parameter, clazz);
            } else {
                BeanDesc beanDesc = BeanDescFactory.getBeanDesc(clazz);
                for (int i = 0; i < beanDesc.getPropertyDescSize(); ++i) {
                    PropertyDesc pd = beanDesc.getPropertyDesc(i);
                    if (!pd.isReadable()) continue;
                    Object value = Parameter.wrapIfNecessary(pd, pd.getValue(this.parameter));
                    this.sqlContext.addArg(pd.getPropertyName(), value, pd.getPropertyType());
                }
            }
        }
        this.node.accept(this.sqlContext);
        Object[] vars = this.sqlContext.getBindVariables();
        Class[] types = this.sqlContext.getBindVariableTypes();
        int size = vars.length;
        for (int i = 0; i < size; ++i) {
            this.addParam(vars[i], types[i]);
        }
    }

    protected void prepareSql() {
        this.executedSql = this.sqlContext.getSql();
    }
}

