/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.internal.argtype;

import java.io.File;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.seasar.extension.jdbc.gen.internal.argtype.ArgumentType;
import org.seasar.extension.jdbc.gen.internal.argtype.BooleanType;
import org.seasar.extension.jdbc.gen.internal.argtype.CharacterType;
import org.seasar.extension.jdbc.gen.internal.argtype.ClassType;
import org.seasar.extension.jdbc.gen.internal.argtype.EnumType;
import org.seasar.extension.jdbc.gen.internal.argtype.FileType;
import org.seasar.extension.jdbc.gen.internal.argtype.ListType;
import org.seasar.extension.jdbc.gen.internal.argtype.NumberType;
import org.seasar.extension.jdbc.gen.internal.argtype.StringType;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.tiger.ReflectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArgumentTypeRegistry {
    protected static Map<Class<?>, Constructor<? extends ArgumentType<?>>> argTypeMap = new ConcurrentHashMap();

    public static <T> ArgumentType<T> getArgumentType(PropertyDesc propertyDesc) {
        Class propertyType = propertyDesc.getPropertyType();
        if (propertyDesc.isParameterized() && Collection.class.isAssignableFrom(propertyType)) {
            Class elementClass = propertyDesc.getElementClassOfCollection();
            return ArgumentTypeRegistry.getCollectionArgumentType(propertyType, elementClass);
        }
        return ArgumentTypeRegistry.getArgumentType(propertyType);
    }

    protected static <T> ArgumentType<T> getArgumentType(Class<?> clazz) {
        if (argTypeMap.containsKey(clazz = ClassUtil.getWrapperClassIfPrimitive(clazz))) {
            Constructor<? extends ArgumentType<?>> constructor = argTypeMap.get(clazz);
            return (ArgumentType)ReflectionUtil.newInstance(constructor, null);
        }
        if (Number.class.isAssignableFrom(clazz)) {
            return new NumberType(clazz);
        }
        if (Enum.class.isAssignableFrom(clazz)) {
            return new EnumType(clazz);
        }
        return null;
    }

    protected static <T> ArgumentType<T> getCollectionArgumentType(Class<?> collectioinClass, Class<?> elementClass) {
        ArgumentType<T> argumentType = ArgumentTypeRegistry.getArgumentType(elementClass);
        if (List.class.isAssignableFrom(collectioinClass)) {
            return new ListType<T>(argumentType);
        }
        return null;
    }

    protected static void register(Class<? extends ArgumentType<?>> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz");
        }
        Constructor constructor = ReflectionUtil.getConstructor(clazz, null);
        argTypeMap.put(clazz, constructor);
    }

    protected static void deregister(Class<? extends ArgumentType<?>> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz");
        }
        argTypeMap.remove(clazz);
    }

    static {
        argTypeMap.put(Boolean.class, ReflectionUtil.getConstructor(BooleanType.class, null));
        argTypeMap.put(Character.class, ReflectionUtil.getConstructor(CharacterType.class, null));
        argTypeMap.put(String.class, ReflectionUtil.getConstructor(StringType.class, null));
        argTypeMap.put(File.class, ReflectionUtil.getConstructor(FileType.class, null));
        argTypeMap.put(Class.class, ReflectionUtil.getConstructor(ClassType.class, null));
    }
}

