/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.internal.argtype;

import java.util.ArrayList;
import java.util.List;
import org.seasar.extension.jdbc.gen.internal.argtype.ArgumentType;
import org.seasar.extension.jdbc.gen.internal.util.ArgumentUtil;
import org.seasar.framework.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListType<T>
implements ArgumentType<List<? extends T>> {
    protected static String OPEN_BRACKET = "[";
    protected static String CLOSE_BRACKET = "]";
    protected ArgumentType<T> argumentType;

    public ListType(ArgumentType<T> argumentType) {
        this.argumentType = argumentType;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public List<? extends T> toObject(String value) {
        if (StringUtil.isEmpty((String)value)) {
            return null;
        }
        ArrayList<T> list = new ArrayList<T>();
        String s = StringUtil.ltrim((String)value, (String)OPEN_BRACKET);
        s = StringUtil.rtrim((String)s, (String)CLOSE_BRACKET);
        Tokenizer tokenizer = new Tokenizer(s);
        while (true) {
            switch (tokenizer.nextToken()) {
                case QUOTED_VALUE: 
                case VALUE: {
                    String token = tokenizer.getToken();
                    list.add(this.argumentType.toObject(token));
                    break;
                }
                case END: {
                    return list;
                }
            }
        }
    }

    @Override
    public String toText(List<? extends T> value) {
        if (value == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        buf.append(OPEN_BRACKET);
        for (T o : value) {
            buf.append(this.argumentType.toText(o));
            buf.append(",");
        }
        if (value.size() > 0) {
            buf.setLength(buf.length() - 1);
        }
        buf.append(CLOSE_BRACKET);
        return buf.toString();
    }

    protected static class Tokenizer {
        protected char delimiter = ArgumentUtil.DELIMITER_CHAR;
        protected char quote = ArgumentUtil.QUOTE_CHAR;
        protected String value;
        protected int length;
        protected int pos;
        protected int nextPos;
        protected String token;
        protected TokenType type;

        protected Tokenizer(String value) {
            this.value = value;
            this.length = value.length();
            this.peek(0);
        }

        protected void peek(int index) {
            if (index < this.length) {
                char c = this.value.charAt(index);
                if (c == this.delimiter) {
                    this.type = TokenType.DELIMITER;
                    this.pos = index;
                    this.nextPos = index + 1;
                } else if (c == this.quote) {
                    this.type = TokenType.QUOTED_VALUE;
                    this.pos = index;
                    this.nextPos = index + 1;
                } else {
                    this.type = TokenType.VALUE;
                    this.pos = index;
                    this.nextPos = index;
                }
            } else {
                this.type = TokenType.END;
            }
        }

        protected TokenType nextToken() {
            switch (this.type) {
                case QUOTED_VALUE: {
                    for (int i = this.nextPos; i < this.length; ++i) {
                        char c = this.value.charAt(i);
                        if (c != this.quote) continue;
                        if (++i >= this.length) {
                            this.token = this.value.substring(this.pos, i);
                            this.type = TokenType.END;
                            return TokenType.QUOTED_VALUE;
                        }
                        if (this.value.charAt(i) != this.delimiter) continue;
                        this.token = this.value.substring(this.pos, i);
                        this.peek(i);
                        return TokenType.QUOTED_VALUE;
                    }
                    this.token = this.value.substring(this.pos, this.length);
                    this.type = TokenType.END;
                    return TokenType.QUOTED_VALUE;
                }
                case VALUE: {
                    for (int i = this.nextPos; i < this.length; ++i) {
                        char c = this.value.charAt(i);
                        if (c != this.delimiter) continue;
                        this.token = this.value.substring(this.pos, i);
                        this.peek(i);
                        return TokenType.VALUE;
                    }
                    this.token = this.value.substring(this.pos, this.length);
                    this.type = TokenType.END;
                    return TokenType.QUOTED_VALUE;
                }
                case DELIMITER: {
                    this.token = this.value.substring(this.pos, this.nextPos);
                    this.peek(this.nextPos);
                    return TokenType.DELIMITER;
                }
                case END: {
                    this.token = null;
                    return TokenType.END;
                }
            }
            throw new IllegalStateException("type");
        }

        protected String getToken() {
            return this.token;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum TokenType {
        QUOTED_VALUE,
        VALUE,
        DELIMITER,
        END;

    }
}

