/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.internal.command;

import org.seasar.extension.jdbc.gen.command.Command;
import org.seasar.extension.jdbc.gen.exception.CommandFailedRuntimeException;
import org.seasar.extension.jdbc.gen.internal.util.SingletonS2ContainerFactorySupport;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.log.Logger;

public abstract class AbstractCommand
implements Command {
    protected String configPath = "s2jdbc.dicon";
    protected String env = "ut";
    protected SingletonS2ContainerFactorySupport containerFactorySupport;

    public String getConfigPath() {
        return this.configPath;
    }

    public void setConfigPath(String configPath) {
        this.configPath = configPath;
    }

    public String getEnv() {
        return this.env;
    }

    public void setEnv(String env) {
        this.env = env;
    }

    public final void execute() {
        String commandClassName = this.getClass().getName();
        this.getLogger().log("DS2JDBCGen0003", new Object[]{commandClassName});
        this.logWritableProperties();
        this.validate();
        this.init();
        try {
            this.doExecute();
        }
        catch (Throwable t) {
            throw new CommandFailedRuntimeException(t, commandClassName);
        }
        finally {
            this.destroy();
        }
        this.getLogger().log("DS2JDBCGen0008", new Object[]{commandClassName});
    }

    protected void logWritableProperties() {
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc(this.getClass());
        for (int i = 0; i < beanDesc.getPropertyDescSize(); ++i) {
            PropertyDesc propertyDesc = beanDesc.getPropertyDesc(i);
            if (!propertyDesc.hasWriteMethod()) continue;
            this.getLogger().info((Object)propertyDesc.getPropertyName());
            this.getLogger().info((Object)propertyDesc.getWriteMethod());
            this.getLogger().log("DS2JDBCGen0001", new Object[]{propertyDesc.getPropertyName(), propertyDesc.getValue((Object)this)});
        }
    }

    protected final void validate() {
        this.doValidate();
    }

    protected final void init() {
        this.containerFactorySupport = new SingletonS2ContainerFactorySupport(this.configPath, this.env);
        this.containerFactorySupport.init();
        this.doInit();
    }

    protected final void destroy() {
        this.doDestroy();
        if (this.containerFactorySupport != null) {
            this.containerFactorySupport.destory();
        }
    }

    protected abstract void doValidate();

    protected abstract void doInit();

    protected abstract void doExecute() throws Throwable;

    protected abstract void doDestroy();

    protected abstract Logger getLogger();
}

