/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.ea2ddl.dao.allcommon;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.dbflute.QLog;
import org.seasar.dbflute.XLog;
import org.seasar.dbflute.jdbc.DataSourceHandler;
import org.seasar.dbflute.jdbc.StatementConfig;

public class DBFluteConfig {
    private static final Log _log = LogFactory.getLog(DBFluteConfig.class);
    private static final DBFluteConfig _instance = new DBFluteConfig();
    private static final String DEFAULT_OUTSIDE_SQL_PACKAGE = null;
    private static final boolean DEFAULT_USE_SQL_LOG_REGISTRY = false;
    protected StatementConfig _defaultStatementConfig;
    protected boolean _queryLogLevelInfo;
    protected boolean _executeStatusLogLevelInfo;
    protected String _logDateFormat;
    protected String _logTimestampFormat;
    protected DataSourceHandler _dataSourceHandler;
    protected String _outsideSqlPackage = DEFAULT_OUTSIDE_SQL_PACKAGE;
    protected boolean _useSqlLogRegistry = false;
    protected boolean _disableSelectIndex;
    protected boolean _internalDebug;
    protected boolean _locked = true;

    private DBFluteConfig() {
    }

    public static DBFluteConfig getInstance() {
        return _instance;
    }

    public StatementConfig getDefaultStatementConfig() {
        return this._defaultStatementConfig;
    }

    public void setDefaultStatementConfig(StatementConfig defaultStatementConfig) {
        this.assertNotLocked();
        if (_log.isInfoEnabled()) {
            _log.info((Object)("...Setting defaultStatementConfig: " + defaultStatementConfig));
        }
        this._defaultStatementConfig = defaultStatementConfig;
    }

    public void setQueryLogLevelInfo(boolean queryLogLevelInfo) {
        this.assertNotLocked();
        if (_log.isInfoEnabled()) {
            _log.info((Object)("...Setting queryLogLevelInfo: " + queryLogLevelInfo));
        }
        QLog.unlock();
        QLog.setQueryLogLevelInfo((boolean)queryLogLevelInfo);
        QLog.lock();
    }

    public void setExecuteStatusLogLevelInfo(boolean executeStatusLogLevelInfo) {
        this.assertNotLocked();
        if (_log.isInfoEnabled()) {
            _log.info((Object)("...Setting executeStatusLogLevelInfo: " + executeStatusLogLevelInfo));
        }
        XLog.unlock();
        XLog.setExecuteStatusLogLevelInfo((boolean)executeStatusLogLevelInfo);
        XLog.lock();
    }

    public String getLogDateFormat() {
        return this._logDateFormat;
    }

    public void setLogDateFormat(String logDateFormat) {
        this.assertNotLocked();
        if (_log.isInfoEnabled()) {
            _log.info((Object)("...Setting logDateFormat: " + logDateFormat));
        }
        this._logDateFormat = logDateFormat;
    }

    public String getLogTimestampFormat() {
        return this._logTimestampFormat;
    }

    public void setLogTimestampFormat(String logTimestampFormat) {
        this.assertNotLocked();
        if (_log.isInfoEnabled()) {
            _log.info((Object)("...Setting logTimestampFormat: " + logTimestampFormat));
        }
        this._logTimestampFormat = logTimestampFormat;
    }

    public DataSourceHandler getDataSourceHandler() {
        return this._dataSourceHandler;
    }

    public void setDataSourceHandler(DataSourceHandler dataSourceHandler) {
        this.assertNotLocked();
        if (_log.isInfoEnabled()) {
            _log.info((Object)("...Setting dataSourceHandler: " + dataSourceHandler));
        }
        this._dataSourceHandler = dataSourceHandler;
    }

    public String getOutsideSqlPackage() {
        return this._outsideSqlPackage;
    }

    public void setOutsideSqlPackage(String outsideSqlPackage) {
        this.assertNotLocked();
        if (_log.isInfoEnabled()) {
            _log.info((Object)("...Setting outsideSqlPackage: " + outsideSqlPackage));
        }
        this._outsideSqlPackage = outsideSqlPackage;
    }

    public boolean isUseSqlLogRegistry() {
        return this._useSqlLogRegistry;
    }

    public void setUseSqlLogRegistry(boolean useSqlLogRegistry) {
        this.assertNotLocked();
        if (_log.isInfoEnabled()) {
            _log.info((Object)("...Setting useSqlLogRegistry: " + useSqlLogRegistry));
        }
        this._useSqlLogRegistry = useSqlLogRegistry;
    }

    public boolean isDisableSelectIndex() {
        return this._disableSelectIndex;
    }

    public void setDisableSelectIndex(boolean disableSelectIndex) {
        this.assertNotLocked();
        if (_log.isInfoEnabled()) {
            _log.info((Object)("...Setting disableSelectIndex: " + disableSelectIndex));
        }
        this._disableSelectIndex = disableSelectIndex;
    }

    public boolean isInternalDebug() {
        return this._internalDebug;
    }

    public void setInternalDebug(boolean internalDebug) {
        this.assertNotLocked();
        if (_log.isInfoEnabled()) {
            _log.info((Object)("...Setting internalDebug: " + internalDebug));
        }
        this._internalDebug = internalDebug;
    }

    public boolean isLocked() {
        return this._locked;
    }

    public void lock() {
        if (_log.isInfoEnabled()) {
            _log.info((Object)"...Locking the configuration of DBFlute!");
        }
        this._locked = true;
    }

    public void unlock() {
        if (_log.isInfoEnabled()) {
            _log.info((Object)"...Unlocking the configuration of DBFlute!");
        }
        this._locked = false;
    }

    protected void assertNotLocked() {
        if (!this.isLocked()) {
            return;
        }
        String msg = "The configuration of DBFlute is locked! Don't access at this timing!";
        throw new IllegalStateException(msg);
    }

    public void clear() {
        this._defaultStatementConfig = null;
        this._queryLogLevelInfo = false;
        this._executeStatusLogLevelInfo = false;
        this._logDateFormat = null;
        this._logTimestampFormat = null;
        this._dataSourceHandler = null;
        this._outsideSqlPackage = DEFAULT_OUTSIDE_SQL_PACKAGE;
        this._useSqlLogRegistry = false;
        this._disableSelectIndex = false;
        this._internalDebug = false;
    }
}

