/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.ea2ddl.dao.allcommon;

import jp.sourceforge.ea2ddl.dao.allcommon.DBCurrent;
import jp.sourceforge.ea2ddl.dao.allcommon.DBFluteConfig;
import jp.sourceforge.ea2ddl.dao.allcommon.DBMetaInstanceHandler;
import org.seasar.dbflute.DBDef;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.sqlclause.SqlClause;
import org.seasar.dbflute.cbean.sqlclause.SqlClauseCreator;
import org.seasar.dbflute.cbean.sqlclause.SqlClauseDb2;
import org.seasar.dbflute.cbean.sqlclause.SqlClauseDefault;
import org.seasar.dbflute.cbean.sqlclause.SqlClauseDerby;
import org.seasar.dbflute.cbean.sqlclause.SqlClauseFirebird;
import org.seasar.dbflute.cbean.sqlclause.SqlClauseH2;
import org.seasar.dbflute.cbean.sqlclause.SqlClauseMySql;
import org.seasar.dbflute.cbean.sqlclause.SqlClauseOracle;
import org.seasar.dbflute.cbean.sqlclause.SqlClausePostgreSql;
import org.seasar.dbflute.cbean.sqlclause.SqlClauseSqlServer;
import org.seasar.dbflute.dbmeta.DBMetaProvider;

public class ImplementedSqlClauseCreator
implements SqlClauseCreator {
    public SqlClause createSqlClause(ConditionBean cb) {
        String tableSqlName = cb.getTableSqlName();
        SqlClause sqlClause = this.createSqlClause(tableSqlName);
        return sqlClause;
    }

    public SqlClause createSqlClause(String tableDbName) {
        DBMetaInstanceHandler dbmetaProvider = new DBMetaInstanceHandler();
        SqlClause sqlClause = this.isCurrentDBDef(DBDef.MySQL) ? new SqlClauseMySql(tableDbName).provider((DBMetaProvider)dbmetaProvider) : (this.isCurrentDBDef(DBDef.PostgreSQL) ? new SqlClausePostgreSql(tableDbName).provider((DBMetaProvider)dbmetaProvider) : (this.isCurrentDBDef(DBDef.Oracle) ? new SqlClauseOracle(tableDbName).provider((DBMetaProvider)dbmetaProvider) : (this.isCurrentDBDef(DBDef.DB2) ? new SqlClauseDb2(tableDbName).provider((DBMetaProvider)dbmetaProvider) : (this.isCurrentDBDef(DBDef.SQLServer) ? new SqlClauseSqlServer(tableDbName).provider((DBMetaProvider)dbmetaProvider) : (this.isCurrentDBDef(DBDef.FireBird) ? new SqlClauseFirebird(tableDbName).provider((DBMetaProvider)dbmetaProvider) : (this.isCurrentDBDef(DBDef.H2) ? new SqlClauseH2(tableDbName).provider((DBMetaProvider)dbmetaProvider) : (this.isCurrentDBDef(DBDef.Derby) ? new SqlClauseDerby(tableDbName).provider((DBMetaProvider)dbmetaProvider) : new SqlClauseDefault(tableDbName).provider((DBMetaProvider)dbmetaProvider))))))));
        if (this.isDisableSelectIndex()) {
            sqlClause.disableSelectIndex();
        }
        return sqlClause;
    }

    protected boolean isCurrentDBDef(DBDef currentDBDef) {
        return DBCurrent.getInstance().isCurrentDBDef(currentDBDef);
    }

    protected boolean isDisableSelectIndex() {
        return DBFluteConfig.getInstance().isDisableSelectIndex();
    }
}

