/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.ea2ddl.ddl.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import jp.sourceforge.ea2ddl.ddl.model.ColumnModel;
import jp.sourceforge.ea2ddl.ddl.model.ForeignKeyModel;
import jp.sourceforge.ea2ddl.ddl.model.IndexModel;
import jp.sourceforge.ea2ddl.ddl.model.PrimaryKeyModel;
import jp.sourceforge.ea2ddl.ddl.model.UniqueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableModel
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private String alias;
    private String note;
    private String schema;
    private boolean suppressCommonColumn = false;
    private List<ColumnModel> _columnList;
    private PrimaryKeyModel _primaryKey;
    private List<UniqueModel> _uniqueList;
    private List<ForeignKeyModel> _foreignKeyList;
    private List<IndexModel> _indexList;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public boolean isSuppressCommonColumn() {
        return this.suppressCommonColumn;
    }

    public void setSuppressCommonColumn(boolean suppressCommonColumn) {
        this.suppressCommonColumn = suppressCommonColumn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ColumnModel> getColumnList() {
        if (this._columnList == null) {
            TableModel tableModel = this;
            synchronized (tableModel) {
                if (this._columnList == null) {
                    this._columnList = new ArrayList<ColumnModel>();
                }
            }
        }
        return this._columnList;
    }

    public void setColumnList(List<ColumnModel> columnList) {
        this._columnList = columnList;
    }

    public void addColumn(ColumnModel column) {
        this.getColumnList().add(column);
    }

    public PrimaryKeyModel getPrimaryKey() {
        return this._primaryKey;
    }

    public void setPrimaryKey(PrimaryKeyModel primaryKey) {
        this._primaryKey = primaryKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<UniqueModel> getUniqueList() {
        if (this._uniqueList == null) {
            TableModel tableModel = this;
            synchronized (tableModel) {
                if (this._uniqueList == null) {
                    this._uniqueList = new ArrayList<UniqueModel>();
                }
            }
        }
        return this._uniqueList;
    }

    public void setUniqueList(List<UniqueModel> uniqueList) {
        this._uniqueList = uniqueList;
    }

    public void addUnique(UniqueModel unique) {
        this.getUniqueList().add(unique);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ForeignKeyModel> getForeignKeyList() {
        if (this._foreignKeyList == null) {
            TableModel tableModel = this;
            synchronized (tableModel) {
                if (this._foreignKeyList == null) {
                    this._foreignKeyList = new ArrayList<ForeignKeyModel>();
                }
            }
        }
        return this._foreignKeyList;
    }

    public void setForeignKeyList(List<ForeignKeyModel> foreignKeyList) {
        this._foreignKeyList = foreignKeyList;
    }

    public void addForeignKey(ForeignKeyModel foreignKey) {
        this.getForeignKeyList().add(foreignKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IndexModel> getIndexList() {
        if (this._indexList == null) {
            TableModel tableModel = this;
            synchronized (tableModel) {
                if (this._indexList == null) {
                    this._indexList = new ArrayList<IndexModel>();
                }
            }
        }
        return this._indexList;
    }

    public void setIndexList(List<IndexModel> indexList) {
        this._indexList = indexList;
    }

    public void addIndex(IndexModel indexModel) {
        this.getIndexList().add(indexModel);
    }
}

