/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute;

import org.seasar.dbflute.jdbc.SqlLogHandler;

public class CallbackContext {
    private static final ThreadLocal<CallbackContext> _threadLocal = new ThreadLocal();
    protected SqlLogHandler _sqlLogHandler;

    public static CallbackContext getCallbackContextOnThread() {
        return _threadLocal.get();
    }

    public static void setCallbackContextOnThread(CallbackContext callbackContext) {
        if (callbackContext == null) {
            String msg = "The argument[callbackContext] must not be null.";
            throw new IllegalArgumentException(msg);
        }
        _threadLocal.set(callbackContext);
    }

    public static boolean isExistCallbackContextOnThread() {
        return _threadLocal.get() != null;
    }

    public static void clearCallbackContextOnThread() {
        _threadLocal.set(null);
    }

    public SqlLogHandler getSqlLogHandler() {
        return this._sqlLogHandler;
    }

    public void setSqlLogHandler(SqlLogHandler sqlLogHandler) {
        this._sqlLogHandler = sqlLogHandler;
    }
}

