/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.cbean;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.seasar.dbflute.cbean.grouping.GroupingOption;
import org.seasar.dbflute.cbean.grouping.GroupingRowEndDeterminer;
import org.seasar.dbflute.cbean.grouping.GroupingRowResource;
import org.seasar.dbflute.cbean.grouping.GroupingRowSetupper;
import org.seasar.dbflute.cbean.mapping.EntityDtoMapper;
import org.seasar.dbflute.cbean.sqlclause.OrderByClause;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListResultBean<ENTITY>
implements List<ENTITY>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String _tableDbName;
    protected int _allRecordCount;
    protected List<ENTITY> _selectedList = new ArrayList<ENTITY>();
    protected OrderByClause _orderByClause = new OrderByClause();

    public <ROW> List<ROW> groupingList(GroupingRowSetupper<ROW, ENTITY> groupingRowSetupper, GroupingOption<ENTITY> groupingOption) {
        ArrayList<ROW> groupingList = new ArrayList<ROW>();
        GroupingRowEndDeterminer rowEndDeterminer = groupingOption.getGroupingRowEndDeterminer();
        if (rowEndDeterminer == null) {
            rowEndDeterminer = new GroupingRowEndDeterminer<ENTITY>(){

                @Override
                public boolean determine(GroupingRowResource<ENTITY> rowResource, ENTITY nextEntity) {
                    return rowResource.isSizeUpBreakCount();
                }
            };
        }
        GroupingRowResource<ENTITY> rowResource = new GroupingRowResource<ENTITY>();
        int breakCount = groupingOption.getElementCount();
        int rowElementIndex = 0;
        int allElementIndex = 0;
        for (ENTITY entity : this._selectedList) {
            rowResource.addGroupingRowList(entity);
            rowResource.setElementCurrentIndex(rowElementIndex);
            rowResource.setBreakCount(breakCount);
            if (this._selectedList.size() == allElementIndex + 1) {
                ROW groupingRowObject = groupingRowSetupper.setup(rowResource);
                groupingList.add(groupingRowObject);
                break;
            }
            ENTITY nextElement = this._selectedList.get(allElementIndex + 1);
            if (rowEndDeterminer.determine(rowResource, nextElement)) {
                ROW groupingRowObject = groupingRowSetupper.setup(rowResource);
                groupingList.add(groupingRowObject);
                rowResource = new GroupingRowResource();
                rowElementIndex = 0;
                ++allElementIndex;
                continue;
            }
            ++rowElementIndex;
            ++allElementIndex;
        }
        return groupingList;
    }

    public <DTO> ListResultBean<DTO> mappingList(EntityDtoMapper<ENTITY, DTO> entityDtoMapper) {
        ListResultBean<DTO> mappingList = new ListResultBean<DTO>();
        for (ENTITY entity : this._selectedList) {
            mappingList.add(entityDtoMapper.map(entity));
        }
        mappingList.setTableDbName(this.getTableDbName());
        mappingList.setAllRecordCount(this.getAllRecordCount());
        mappingList.setOrderByClause(this.getOrderByClause());
        return mappingList;
    }

    public boolean isSelectedResult() {
        return this._tableDbName != null;
    }

    @Override
    public int hashCode() {
        if (this._selectedList == null) {
            return super.hashCode();
        }
        return ((Object)this._selectedList).hashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (this._selectedList == null) {
            return false;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof List)) {
            return false;
        }
        return ((Object)this._selectedList).equals(other);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{").append(this._tableDbName);
        sb.append(",").append(this._allRecordCount);
        sb.append(",").append(this._orderByClause != null ? this._orderByClause.getOrderByClause() : null);
        sb.append(",").append(this._selectedList);
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean add(ENTITY o) {
        return this._selectedList.add(o);
    }

    @Override
    public boolean addAll(Collection<? extends ENTITY> c) {
        return this._selectedList.addAll(c);
    }

    @Override
    public void clear() {
        this._selectedList.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this._selectedList.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this._selectedList.containsAll(c);
    }

    @Override
    public boolean isEmpty() {
        return this._selectedList.isEmpty();
    }

    @Override
    public Iterator<ENTITY> iterator() {
        return this._selectedList.iterator();
    }

    @Override
    public boolean remove(Object o) {
        return this._selectedList.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this._selectedList.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this._selectedList.retainAll(c);
    }

    @Override
    public int size() {
        return this._selectedList.size();
    }

    @Override
    public Object[] toArray() {
        return this._selectedList.toArray();
    }

    @Override
    public <TYPE> TYPE[] toArray(TYPE[] a) {
        return this._selectedList.toArray(a);
    }

    @Override
    public void add(int index, ENTITY element) {
        this._selectedList.add(index, element);
    }

    @Override
    public boolean addAll(int index, Collection<? extends ENTITY> c) {
        return this._selectedList.addAll(index, c);
    }

    @Override
    public ENTITY get(int index) {
        return this._selectedList.get(index);
    }

    @Override
    public int indexOf(Object o) {
        return this._selectedList.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this._selectedList.lastIndexOf(o);
    }

    @Override
    public ListIterator<ENTITY> listIterator() {
        return this._selectedList.listIterator();
    }

    @Override
    public ListIterator<ENTITY> listIterator(int index) {
        return this._selectedList.listIterator(index);
    }

    @Override
    public ENTITY remove(int index) {
        return this._selectedList.remove(index);
    }

    @Override
    public ENTITY set(int index, ENTITY element) {
        return this._selectedList.set(index, element);
    }

    @Override
    public List<ENTITY> subList(int fromIndex, int toIndex) {
        return this._selectedList.subList(fromIndex, toIndex);
    }

    public String getTableDbName() {
        return this._tableDbName;
    }

    public void setTableDbName(String tableDbName) {
        this._tableDbName = tableDbName;
    }

    public int getAllRecordCount() {
        return this._allRecordCount;
    }

    public void setAllRecordCount(int allRecordCount) {
        this._allRecordCount = allRecordCount;
    }

    public List<ENTITY> getSelectedList() {
        return this._selectedList;
    }

    public void setSelectedList(List<ENTITY> selectedList) {
        if (selectedList == null) {
            return;
        }
        this._selectedList = selectedList;
    }

    public OrderByClause getOrderByClause() {
        return this._orderByClause;
    }

    public void setOrderByClause(OrderByClause orderByClause) {
        if (orderByClause == null) {
            return;
        }
        this._orderByClause = orderByClause;
    }
}

