/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.cbean;

import java.util.List;
import org.seasar.dbflute.cbean.PagingBean;
import org.seasar.dbflute.cbean.PagingHandler;
import org.seasar.dbflute.cbean.PagingResultBean;
import org.seasar.dbflute.cbean.ResultBeanBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PagingInvoker<ENTITY> {
    protected String _tableDbName;
    protected boolean _countLater;

    public PagingInvoker(String tableDbName) {
        this._tableDbName = tableDbName;
    }

    public PagingResultBean<ENTITY> invokePaging(PagingHandler<ENTITY> handler) {
        int allRecordCount;
        List<ENTITY> selectedList;
        this.assertObjectNotNull("handler", handler);
        PagingBean pagingBean = handler.getPagingBean();
        this.assertObjectNotNull("handler.getPagingBean()", pagingBean);
        if (!pagingBean.isFetchScopeEffective()) {
            String msg = "The paging bean is not effective about fetch-scope!";
            msg = msg + " When you select page, you should set up fetch-scope of paging bean(Should invoke fetchFirst() and fetchPage()!).";
            msg = msg + " The paging bean is: " + pagingBean;
            throw new IllegalStateException(msg);
        }
        if (this._countLater) {
            selectedList = handler.paging();
            allRecordCount = handler.count();
        } else {
            allRecordCount = handler.count();
            selectedList = handler.paging();
        }
        PagingResultBean rb = new ResultBeanBuilder<ENTITY>(this._tableDbName).buildPagingResultBean(pagingBean, allRecordCount, selectedList);
        if (pagingBean.canPagingReSelect() && this.isNecessaryToReadPageAgain(rb)) {
            pagingBean.fetchPage(rb.getAllPageCount());
            int reAllRecordCount = handler.count();
            List<ENTITY> reSelectedList = handler.paging();
            return new ResultBeanBuilder<ENTITY>(this._tableDbName).buildPagingResultBean(pagingBean, reAllRecordCount, reSelectedList);
        }
        return rb;
    }

    protected boolean isNecessaryToReadPageAgain(PagingResultBean<ENTITY> rb) {
        return rb.getAllRecordCount() > 0 && rb.getSelectedList().isEmpty();
    }

    public PagingInvoker<ENTITY> countLater() {
        this._countLater = true;
        return this;
    }

    protected void assertObjectNotNull(String variableName, Object value) {
        if (variableName == null) {
            String msg = "The value should not be null: variableName=" + variableName + " value=" + value;
            throw new IllegalArgumentException(msg);
        }
        if (value == null) {
            String msg = "The value should not be null: variableName=" + variableName;
            throw new IllegalArgumentException(msg);
        }
    }
}

