/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.cbean.sqlclause;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.seasar.dbflute.cbean.ckey.ConditionKey;
import org.seasar.dbflute.cbean.coption.ConditionOption;
import org.seasar.dbflute.cbean.cvalue.ConditionValue;
import org.seasar.dbflute.cbean.sqlclause.OrderByClause;
import org.seasar.dbflute.cbean.sqlclause.OrderByElement;
import org.seasar.dbflute.cbean.sqlclause.SqlClause;
import org.seasar.dbflute.cbean.sqlclause.WhereClauseSimpleFilter;
import org.seasar.dbflute.dbmeta.DBMeta;
import org.seasar.dbflute.dbmeta.DBMetaProvider;
import org.seasar.dbflute.dbmeta.info.ColumnInfo;
import org.seasar.dbflute.dbmeta.info.ForeignInfo;
import org.seasar.dbflute.util.DfAssertUtil;
import org.seasar.dbflute.util.DfStringUtil;
import org.seasar.dbflute.util.DfSystemUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSqlClause
implements SqlClause {
    protected static final SqlClause.SelectClauseType DEFAULT_SELECT_CLAUSE_TYPE = SqlClause.SelectClauseType.COLUMNS;
    protected static final String SELECT_HINT = "/*$dto.selectHint*/";
    protected final String _tableName;
    protected DBMetaProvider _dbmetaProvider;
    protected Map<String, Map<String, SelectedSelectColumnInfo>> _selectedSelectColumnMap = new LinkedHashMap<String, Map<String, SelectedSelectColumnInfo>>();
    protected Map<String, Map<String, String>> _specifiedSelectColumnMap;
    protected Map<String, String> _specifiedDeriveSubQueryMap;
    protected Map<String, String> _selectClauseRealColumnAliasMap = new HashMap<String, String>();
    protected SqlClause.SelectClauseType _selectClauseType = DEFAULT_SELECT_CLAUSE_TYPE;
    protected SqlClause.SelectClauseType _previousSelectClauseType;
    protected Map<String, Integer> _selectIndexMap;
    protected boolean _useSelectIndex = true;
    protected Map<String, LeftOuterJoinInfo> _outerJoinMap = new LinkedHashMap<String, LeftOuterJoinInfo>();
    protected List<String> _whereList = new ArrayList<String>();
    protected List<String> _baseTableInlineWhereList = new ArrayList<String>();
    protected final OrderByClause _orderByClause = new OrderByClause();
    protected List<UnionQueryInfo> _unionQueryInfoList;
    protected boolean _isOrderByEffective = false;
    protected int _fetchStartIndex = 0;
    protected int _fetchSize = 0;
    protected int _fetchPageNumber = 1;
    protected boolean _isFetchScopeEffective = false;
    protected boolean _isAdditionalConditionAsOrEffective = false;
    protected List<WhereClauseSimpleFilter> _whereClauseSimpleFilterList;
    protected Map<String, String> _selectedForeignInfo;
    protected boolean _formatClause = true;

    public AbstractSqlClause(String tableName) {
        if (tableName == null) {
            String msg = "Argument[tableName] should not be null.";
            throw new IllegalArgumentException(msg);
        }
        this._tableName = tableName;
    }

    public SqlClause provider(DBMetaProvider dbmetaProvider) {
        this._dbmetaProvider = dbmetaProvider;
        return this;
    }

    @Override
    public String getClause() {
        StringBuilder sb = new StringBuilder(512);
        sb.append(this.getSelectClause());
        sb.append(" ");
        sb.append(this.buildClauseWithoutMainSelect());
        String sql = sb.toString();
        sql = this.filterUnionCountOrScalar(sql);
        sql = this.filterSubQueryIndent(sql);
        return sql;
    }

    protected String buildClauseWithoutMainSelect() {
        StringBuilder sb = new StringBuilder(512);
        sb.append(this.getFromClause());
        sb.append(this.getFromHint());
        sb.append(" ");
        sb.append(this.getWhereClause());
        String unionClause = this.buildUnionClause(this.getSelectClause());
        unionClause = this.replaceString(unionClause, this.getUnionWhereClauseMark(), "");
        unionClause = this.replaceString(unionClause, this.getUnionWhereFirstConditionMark(), "");
        sb.append(unionClause);
        if (this._isOrderByEffective && !this._orderByClause.isEmpty()) {
            sb.append(" ");
            sb.append(this.getOrderByClause());
        }
        sb.append(" ");
        sb.append(this.getSqlSuffix());
        return sb.toString();
    }

    @Override
    public String getClauseFromWhereWithUnionTemplate() {
        return this.buildClauseFromWhereAsTemplate(false);
    }

    @Override
    public String getClauseFromWhereWithWhereUnionTemplate() {
        return this.buildClauseFromWhereAsTemplate(true);
    }

    protected String buildClauseFromWhereAsTemplate(boolean template) {
        StringBuilder sb = new StringBuilder(512);
        sb.append(this.getFromClause());
        sb.append(this.getFromHint());
        sb.append(" ");
        sb.append(this.buildWhereClause(template));
        sb.append(this.buildUnionClause(this.getUnionSelectClauseMark()));
        return sb.toString();
    }

    protected String buildUnionClause(String selectClause) {
        StringBuilder sb = new StringBuilder();
        if (this.hasUnionQuery()) {
            for (UnionQueryInfo unionQueryInfo : this._unionQueryInfoList) {
                String unionQueryClause = unionQueryInfo.getUnionQueryClause();
                boolean unionAll = unionQueryInfo.isUnionAll();
                sb.append(this.getLineSeparator());
                sb.append(unionAll ? " union all " : " union ");
                sb.append(this.getLineSeparator());
                sb.append(selectClause).append(" ").append(unionQueryClause);
            }
        }
        return sb.toString();
    }

    protected String filterUnionCountOrScalar(String sql) {
        if (!this.isSelectClauseTypeCountOrScalar() || !this.hasUnionQuery()) {
            return sql;
        }
        String selectClause = this.buildSelectClauseCountOrScalar("dfmain");
        String ln = this.getLineSeparator();
        String beginMark = this.resolveSubQueryBeginMark("dfmain") + ln;
        String endMark = this.resolveSubQueryEndMark("dfmain");
        return selectClause + ln + "  from (" + beginMark + sql + ln + "       ) dfmain" + endMark;
    }

    @Override
    public String getSelectClause() {
        if (this.isSelectClauseTypeCountOrScalar() && !this.hasUnionQuery()) {
            return this.buildSelectClauseCountOrScalar("dflocal");
        }
        StringBuilder sb = new StringBuilder();
        DBMeta dbmeta = this.findDBMeta(this._tableName);
        List<ColumnInfo> columnInfoList = dbmeta.getColumnInfoList();
        Map<String, String> localSpecifiedMap = this._specifiedSelectColumnMap != null ? this._specifiedSelectColumnMap.get(this.getLocalTableAliasName()) : null;
        boolean existsSpecifiedLocal = localSpecifiedMap != null && !localSpecifiedMap.isEmpty();
        Integer selectIndex = 0;
        if (this._useSelectIndex) {
            this._selectIndexMap = new HashMap<String, Integer>();
        }
        for (ColumnInfo columnInfo : columnInfoList) {
            String onQueryName;
            String columnName = columnInfo.getColumnDbName();
            if (existsSpecifiedLocal && !localSpecifiedMap.containsKey(columnName) && (!this.isSelectClauseTypeCountOrScalar() || !this.hasUnionQuery() || dbmeta.hasPrimaryKey() && !columnInfo.isPrimary())) continue;
            if (sb.length() > 0) {
                sb.append(", ");
            } else {
                sb.append("select").append(SELECT_HINT).append(" ");
            }
            String realColumnName = this.getLocalTableAliasName() + "." + columnName;
            selectIndex = selectIndex + 1;
            if (this._useSelectIndex) {
                this._selectIndexMap.put(columnName, selectIndex);
                onQueryName = this.buildSelectIndexAliasName(selectIndex);
            } else {
                onQueryName = columnName;
            }
            sb.append(realColumnName).append(" as ").append(onQueryName);
            this._selectClauseRealColumnAliasMap.put(realColumnName, onQueryName);
        }
        Set<String> tableAliasNameSet = this._selectedSelectColumnMap.keySet();
        for (String tableAliasName : tableAliasNameSet) {
            Map<String, SelectedSelectColumnInfo> map = this._selectedSelectColumnMap.get(tableAliasName);
            Collection<SelectedSelectColumnInfo> selectColumnInfoList = map.values();
            Map<String, String> foreginSpecifiedMap = this._specifiedSelectColumnMap != null ? this._specifiedSelectColumnMap.get(tableAliasName) : null;
            boolean existsSpecifiedForeign = foreginSpecifiedMap != null && !foreginSpecifiedMap.isEmpty();
            for (SelectedSelectColumnInfo selectColumnInfo : selectColumnInfoList) {
                String onQueryName;
                if (existsSpecifiedForeign && !foreginSpecifiedMap.containsKey(selectColumnInfo.getColumnName())) continue;
                String realColumnName = selectColumnInfo.buildRealColumnName();
                String columnAliasName = selectColumnInfo.getColumnAliasName();
                selectIndex = selectIndex + 1;
                if (this._useSelectIndex) {
                    this._selectIndexMap.put(columnAliasName, selectIndex);
                    onQueryName = this.buildSelectIndexAliasName(selectIndex);
                } else {
                    onQueryName = columnAliasName;
                }
                sb.append(", ").append(realColumnName).append(" as ").append(onQueryName);
                this._selectClauseRealColumnAliasMap.put(realColumnName, onQueryName);
            }
        }
        if (this._specifiedDeriveSubQueryMap != null && !this._specifiedDeriveSubQueryMap.isEmpty()) {
            Collection<String> deriveSubQuerySet = this._specifiedDeriveSubQueryMap.values();
            for (String deriveSubQuery : deriveSubQuerySet) {
                sb.append(this.getLineSeparator()).append("     ");
                sb.append(", ").append(deriveSubQuery);
                int beginIndex = deriveSubQuery.lastIndexOf(" as ");
                if (beginIndex < 0) continue;
                String aliasName = deriveSubQuery.substring(beginIndex + " as ".length());
                int endIndex = aliasName.indexOf("--df:");
                if (endIndex >= 0) {
                    aliasName = aliasName.substring(0, endIndex);
                }
                this._selectClauseRealColumnAliasMap.put(aliasName, aliasName);
            }
        }
        return sb.toString();
    }

    protected boolean isSelectClauseTypeCountOrScalar() {
        if (this._selectClauseType.equals((Object)SqlClause.SelectClauseType.COUNT)) {
            return true;
        }
        if (this._selectClauseType.equals((Object)SqlClause.SelectClauseType.MAX)) {
            return true;
        }
        if (this._selectClauseType.equals((Object)SqlClause.SelectClauseType.MIN)) {
            return true;
        }
        if (this._selectClauseType.equals((Object)SqlClause.SelectClauseType.SUM)) {
            return true;
        }
        return this._selectClauseType.equals((Object)SqlClause.SelectClauseType.AVG);
    }

    protected String buildSelectClauseCountOrScalar(String aliasName) {
        if (this._selectClauseType.equals((Object)SqlClause.SelectClauseType.COUNT)) {
            return this.buildSelectClauseCount();
        }
        if (this._selectClauseType.equals((Object)SqlClause.SelectClauseType.MAX)) {
            return this.buildSelectClauseMax(aliasName);
        }
        if (this._selectClauseType.equals((Object)SqlClause.SelectClauseType.MIN)) {
            return this.buildSelectClauseMin(aliasName);
        }
        if (this._selectClauseType.equals((Object)SqlClause.SelectClauseType.SUM)) {
            return this.buildSelectClauseSum(aliasName);
        }
        if (this._selectClauseType.equals((Object)SqlClause.SelectClauseType.AVG)) {
            return this.buildSelectClauseAvg(aliasName);
        }
        String msg = "The type of select clause is not for scalar:";
        msg = msg + " type=" + (Object)((Object)this._selectClauseType);
        throw new IllegalStateException(msg);
    }

    protected String buildSelectClauseCount() {
        return "select count(*)";
    }

    protected String buildSelectClauseMax(String aliasName) {
        String columnName = this.getSpecifiedColumnNameAsOne();
        this.assertScalarSelectSpecifiedColumnOnlyOne(columnName);
        return "select max(" + aliasName + "." + columnName + ")";
    }

    protected String buildSelectClauseMin(String aliasName) {
        String columnName = this.getSpecifiedColumnNameAsOne();
        this.assertScalarSelectSpecifiedColumnOnlyOne(columnName);
        return "select min(" + aliasName + "." + columnName + ")";
    }

    protected String buildSelectClauseSum(String aliasName) {
        String columnName = this.getSpecifiedColumnNameAsOne();
        this.assertScalarSelectSpecifiedColumnOnlyOne(columnName);
        return "select sum(" + aliasName + "." + columnName + ")";
    }

    protected String buildSelectClauseAvg(String aliasName) {
        String columnName = this.getSpecifiedColumnNameAsOne();
        this.assertScalarSelectSpecifiedColumnOnlyOne(columnName);
        return "select avg(" + aliasName + "." + columnName + ")";
    }

    protected void assertScalarSelectSpecifiedColumnOnlyOne(String columnName) {
        if (columnName != null) {
            return;
        }
        String msg = "The specified column exists one";
        msg = msg + " when the type of select clause is for scalar:";
        msg = msg + " specifiedSelectColumnMap=" + this._specifiedSelectColumnMap;
        throw new IllegalStateException(msg);
    }

    @Override
    public Map<String, Integer> getSelectIndexMap() {
        return this._selectIndexMap;
    }

    @Override
    public Map<String, String> getSelectIndexReverseMap() {
        if (this._selectIndexMap == null) {
            return null;
        }
        HashMap<String, String> selectIndexReverseMap = new HashMap<String, String>();
        for (String columnName : this._selectIndexMap.keySet()) {
            Integer selectIndex = this._selectIndexMap.get(columnName);
            selectIndexReverseMap.put(this.buildSelectIndexAliasName(selectIndex), columnName);
        }
        return selectIndexReverseMap;
    }

    @Override
    public void disableSelectIndex() {
        this._useSelectIndex = false;
    }

    protected String buildSelectIndexAliasName(Integer selectIndex) {
        return "c" + selectIndex;
    }

    @Override
    public String getSelectHint() {
        return this.createSelectHint();
    }

    @Override
    public String getFromClause() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getLineSeparator()).append("  ");
        sb.append("from ");
        if (this._baseTableInlineWhereList.isEmpty()) {
            sb.append(this._tableName).append(" dflocal");
        } else {
            sb.append(this.getInlineViewClause(this._tableName, this._baseTableInlineWhereList)).append(" dflocal");
        }
        sb.append(this.getFromBaseTableHint());
        sb.append(this.getLeftOuterJoinClause());
        return sb.toString();
    }

    protected String getLeftOuterJoinClause() {
        StringBuilder sb = new StringBuilder();
        for (String aliasName : this._outerJoinMap.keySet()) {
            LeftOuterJoinInfo joinInfo = this._outerJoinMap.get(aliasName);
            String joinTableName = joinInfo.getJoinTableName();
            List<String> inlineWhereClauseList = joinInfo.getInlineWhereClauseList();
            List<String> additionalOnClauseList = joinInfo.getAdditionalOnClauseList();
            Map<String, String> joinOnMap = joinInfo.getJoinOnMap();
            this.assertJoinOnMapNotEmpty(joinOnMap, aliasName);
            sb.append(this.getLineSeparator()).append("   ");
            sb.append(" left outer join ");
            if (inlineWhereClauseList.isEmpty()) {
                sb.append(joinTableName);
            } else {
                sb.append(this.getInlineViewClause(joinTableName, inlineWhereClauseList));
            }
            sb.append(" ").append(aliasName).append(" on ");
            int count = 0;
            Set<String> localColumnNameSet = joinOnMap.keySet();
            for (String localColumnName : localColumnNameSet) {
                String foreignColumnName = joinOnMap.get(localColumnName);
                if (count > 0) {
                    sb.append(" and ");
                }
                if (localColumnName.equals("$$fixedCondition$$")) {
                    sb.append(foreignColumnName);
                } else {
                    sb.append(localColumnName).append(" = ").append(foreignColumnName);
                }
                ++count;
            }
            for (String additionalOnClause : additionalOnClauseList) {
                sb.append(" and ").append(additionalOnClause);
            }
        }
        return sb.toString();
    }

    protected String getInlineViewClause(String joinTableName, List<String> inlineWhereClauseList) {
        StringBuilder sb = new StringBuilder();
        sb.append("(select * from ").append(joinTableName).append(" where ");
        int count = 0;
        for (String clauseElement : inlineWhereClauseList) {
            clauseElement = this.filterWhereClauseSimply(clauseElement);
            if (count > 0) {
                sb.append(" and ");
            }
            sb.append(clauseElement);
            ++count;
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public String getFromBaseTableHint() {
        return this.createFromBaseTableHint();
    }

    @Override
    public String getFromHint() {
        return this.createFromHint();
    }

    @Override
    public String getWhereClause() {
        return this.buildWhereClause(false);
    }

    protected String buildWhereClause(boolean template) {
        StringBuilder sb = new StringBuilder();
        int count = 0;
        for (String clauseElement : this._whereList) {
            clauseElement = this.filterWhereClauseSimply(clauseElement);
            if (count == 0) {
                sb.append(this.getLineSeparator()).append(" ");
                sb.append("where ").append(template ? this.getWhereFirstConditionMark() : "").append(clauseElement);
            } else {
                sb.append(this.getLineSeparator()).append("  ");
                sb.append(" and ").append(clauseElement);
            }
            ++count;
        }
        if (template && sb.length() == 0) {
            sb.append(this.getWhereClauseMark());
        }
        return sb.toString();
    }

    @Override
    public String getOrderByClause() {
        String orderByClause = null;
        if (this.hasUnionQuery()) {
            if (this._selectClauseRealColumnAliasMap == null || this._selectClauseRealColumnAliasMap.isEmpty()) {
                String msg = "The selectClauseColumnAliasMap should not be null or empty when union query exists: " + this.toString();
                throw new IllegalStateException(msg);
            }
            orderByClause = this._orderByClause.getOrderByClause(this._selectClauseRealColumnAliasMap);
        } else {
            orderByClause = this._orderByClause.getOrderByClause();
        }
        if (orderByClause != null && orderByClause.trim().length() > 0) {
            return this.getLineSeparator() + " " + orderByClause;
        }
        return orderByClause;
    }

    @Override
    public String getSqlSuffix() {
        String sqlSuffix = this.createSqlSuffix();
        if (sqlSuffix != null && sqlSuffix.trim().length() > 0) {
            return this.getLineSeparator() + sqlSuffix;
        }
        return sqlSuffix;
    }

    @Override
    public void registerSelectedSelectColumn(String foreignTableAliasName, String localTableName, String foreignPropertyName, String localRelationPath) {
        this._selectedSelectColumnMap.put(foreignTableAliasName, this.createSelectedSelectColumnInfo(foreignTableAliasName, localTableName, foreignPropertyName, localRelationPath));
    }

    protected Map<String, SelectedSelectColumnInfo> createSelectedSelectColumnInfo(String foreignTableAliasName, String localTableName, String foreignPropertyName, String localRelationPath) {
        DBMeta dbmeta = this.findDBMeta(localTableName);
        ForeignInfo foreignInfo = dbmeta.findForeignInfo(foreignPropertyName);
        int relationNo = foreignInfo.getRelationNo();
        String nextRelationPath = "_" + relationNo;
        if (localRelationPath != null) {
            nextRelationPath = localRelationPath + nextRelationPath;
        }
        LinkedHashMap<String, SelectedSelectColumnInfo> resultMap = new LinkedHashMap<String, SelectedSelectColumnInfo>();
        DBMeta foreignDBMeta = foreignInfo.getForeignDBMeta();
        List<ColumnInfo> columnInfoList = foreignDBMeta.getColumnInfoList();
        for (ColumnInfo columnInfo : columnInfoList) {
            String columnDbName = columnInfo.getColumnDbName();
            SelectedSelectColumnInfo selectColumnInfo = new SelectedSelectColumnInfo();
            selectColumnInfo.setTableAliasName(foreignTableAliasName);
            selectColumnInfo.setColumnName(columnDbName);
            selectColumnInfo.setColumnAliasName(columnDbName + nextRelationPath);
            resultMap.put(columnDbName, selectColumnInfo);
        }
        return resultMap;
    }

    @Override
    public void registerOuterJoin(String joinTableName, String aliasName, Map<String, String> joinOnMap) {
        this.assertAlreadyOuterJoin(aliasName);
        this.assertJoinOnMapNotEmpty(joinOnMap, aliasName);
        LeftOuterJoinInfo joinInfo = new LeftOuterJoinInfo();
        joinInfo.setAliasName(aliasName);
        joinInfo.setJoinTableName(joinTableName);
        joinInfo.setJoinOnMap(joinOnMap);
        this._outerJoinMap.put(aliasName, joinInfo);
    }

    protected void assertAlreadyOuterJoin(String aliasName) {
        if (this._outerJoinMap.containsKey(aliasName)) {
            String msg = "The alias name have already registered in outer join: " + aliasName;
            throw new IllegalStateException(msg);
        }
    }

    protected void assertJoinOnMapNotEmpty(Map<String, String> joinOnMap, String aliasName) {
        if (joinOnMap.isEmpty()) {
            String msg = "The joinOnMap should not be empty: aliasName=" + aliasName;
            throw new IllegalStateException(msg);
        }
    }

    @Override
    public void registerWhereClause(String columnFullName, ConditionKey key, ConditionValue value) {
        this.assertStringNotNullAndNotTrimmedEmpty("columnFullName", columnFullName);
        key.addWhereClause(this._whereList, columnFullName, value);
        this.arrangeWhereListAdditionalConditionAsOr(this._whereList);
    }

    @Override
    public void registerWhereClause(String columnFullName, ConditionKey key, ConditionValue value, ConditionOption option) {
        this.assertStringNotNullAndNotTrimmedEmpty("columnFullName", columnFullName);
        this.assertObjectNotNull("option of " + columnFullName, option);
        key.addWhereClause(this._whereList, columnFullName, value, option);
        this.arrangeWhereListAdditionalConditionAsOr(this._whereList);
    }

    @Override
    public void registerWhereClause(String clause) {
        this.assertStringNotNullAndNotTrimmedEmpty("clause", clause);
        this._whereList.add(clause);
        this.arrangeWhereListAdditionalConditionAsOr(this._whereList);
    }

    @Override
    public void exchangeFirstWhereClauseForLastOne() {
        if (this._whereList.size() > 1) {
            String first = this._whereList.get(0);
            String last = this._whereList.get(this._whereList.size() - 1);
            this._whereList.set(0, last);
            this._whereList.set(this._whereList.size() - 1, first);
        }
    }

    @Override
    public void registerBaseTableInlineWhereClause(String columnName, ConditionKey key, ConditionValue value) {
        this.assertStringNotNullAndNotTrimmedEmpty("columnName", columnName);
        key.addWhereClause(this._baseTableInlineWhereList, columnName, value);
        this.arrangeWhereListAdditionalConditionAsOr(this._baseTableInlineWhereList);
    }

    @Override
    public void registerBaseTableInlineWhereClause(String columnName, ConditionKey key, ConditionValue value, ConditionOption option) {
        this.assertStringNotNullAndNotTrimmedEmpty("columnName", columnName);
        this.assertObjectNotNull("option of " + columnName, option);
        key.addWhereClause(this._baseTableInlineWhereList, columnName, value, option);
        this.arrangeWhereListAdditionalConditionAsOr(this._baseTableInlineWhereList);
    }

    @Override
    public void registerBaseTableInlineWhereClause(String value) {
        this._baseTableInlineWhereList.add(value);
    }

    @Override
    public void registerOuterJoinInlineWhereClause(String aliasName, String columnName, ConditionKey key, ConditionValue value, boolean onClauseInline) {
        this.assertNotYetOuterJoin(aliasName);
        this.assertStringNotNullAndNotTrimmedEmpty("columnName", columnName);
        LeftOuterJoinInfo joinInfo = this._outerJoinMap.get(aliasName);
        if (onClauseInline) {
            key.addWhereClause(joinInfo.getAdditionalOnClauseList(), aliasName + "." + columnName, value);
        } else {
            key.addWhereClause(joinInfo.getInlineWhereClauseList(), columnName, value);
        }
        this.arrangeWhereListAdditionalConditionAsOr(joinInfo.getInlineWhereClauseList());
    }

    @Override
    public void registerOuterJoinInlineWhereClause(String aliasName, String columnName, ConditionKey key, ConditionValue value, ConditionOption option, boolean onClauseInline) {
        this.assertNotYetOuterJoin(aliasName);
        this.assertStringNotNullAndNotTrimmedEmpty("columnName", columnName);
        LeftOuterJoinInfo joinInfo = this._outerJoinMap.get(aliasName);
        if (onClauseInline) {
            key.addWhereClause(joinInfo.getAdditionalOnClauseList(), aliasName + "." + columnName, value, option);
            this.arrangeWhereListAdditionalConditionAsOr(joinInfo.getAdditionalOnClauseList());
        } else {
            key.addWhereClause(joinInfo.getInlineWhereClauseList(), columnName, value, option);
            this.arrangeWhereListAdditionalConditionAsOr(joinInfo.getInlineWhereClauseList());
        }
    }

    @Override
    public void registerOuterJoinInlineWhereClause(String aliasName, String value, boolean onClauseInline) {
        this.assertNotYetOuterJoin(aliasName);
        LeftOuterJoinInfo joinInfo = this._outerJoinMap.get(aliasName);
        if (onClauseInline) {
            joinInfo.addAdditionalOnClause(value);
            this.arrangeWhereListAdditionalConditionAsOr(joinInfo.getAdditionalOnClauseList());
        } else {
            joinInfo.addInlineWhereClause(value);
            this.arrangeWhereListAdditionalConditionAsOr(joinInfo.getInlineWhereClauseList());
        }
    }

    protected void assertNotYetOuterJoin(String aliasName) {
        if (!this._outerJoinMap.containsKey(aliasName)) {
            String msg = "The alias name have not registered in outer join yet: " + aliasName;
            throw new IllegalStateException(msg);
        }
    }

    @Override
    public void makeAdditionalConditionAsOrEffective() {
        this._isAdditionalConditionAsOrEffective = true;
    }

    @Override
    public void ignoreAdditionalConditionAsOr() {
        this._isAdditionalConditionAsOrEffective = false;
    }

    protected void arrangeWhereListAdditionalConditionAsOr(List<String> whereList) {
        if (this._isAdditionalConditionAsOrEffective) {
            if (whereList.size() < 2) {
                String msg = "The whereList should have two more elements when the isAdditionalConditionAsOrEffective is true: " + this.toString();
                throw new IllegalStateException(msg);
            }
            String lastWhereClause = whereList.remove(whereList.size() - 1);
            String preWhereClause = whereList.remove(whereList.size() - 1);
            if (preWhereClause.startsWith("(") && preWhereClause.endsWith(")")) {
                String plainClause = preWhereClause.substring("(".length(), preWhereClause.length() - ")".length());
                whereList.add("(" + plainClause + " or " + lastWhereClause + ")");
            } else {
                whereList.add("(" + preWhereClause + " or " + lastWhereClause + ")");
            }
        }
    }

    @Override
    public OrderByClause getSqlComponentOfOrderByClause() {
        return this._orderByClause;
    }

    @Override
    public SqlClause clearOrderBy() {
        this._isOrderByEffective = false;
        this._orderByClause.clear();
        return this;
    }

    @Override
    public SqlClause ignoreOrderBy() {
        this._isOrderByEffective = false;
        return this;
    }

    @Override
    public SqlClause makeOrderByEffective() {
        if (!this._orderByClause.isEmpty()) {
            this._isOrderByEffective = true;
        }
        return this;
    }

    @Override
    public void reverseOrderBy_Or_OverrideOrderBy(String orderByProperty, String registeredOrderByProperty, boolean ascOrDesc) {
        this._isOrderByEffective = true;
        if (!this._orderByClause.isSameOrderByColumn(orderByProperty)) {
            this.clearOrderBy();
            this.registerOrderBy(orderByProperty, registeredOrderByProperty, ascOrDesc);
        } else {
            this._orderByClause.reverseAll();
        }
    }

    @Override
    public void registerOrderBy(String orderByProperty, String registeredOrderByProperty, boolean ascOrDesc) {
        try {
            this._isOrderByEffective = true;
            ArrayList<String> orderByList = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(orderByProperty, "/");
            while (st.hasMoreElements()) {
                orderByList.add(st.nextToken());
            }
            if (registeredOrderByProperty == null || registeredOrderByProperty.trim().length() == 0) {
                registeredOrderByProperty = orderByProperty;
            }
            ArrayList<String> registeredOrderByList = new ArrayList<String>();
            StringTokenizer st2 = new StringTokenizer(registeredOrderByProperty, "/");
            while (st2.hasMoreElements()) {
                registeredOrderByList.add(st2.nextToken());
            }
            int count = 0;
            for (String orderBy : orderByList) {
                String registeredOrderBy = (String)registeredOrderByList.get(count);
                this._isOrderByEffective = true;
                String aliasName = null;
                String columnName = null;
                String registeredAliasName = null;
                String registeredColumnName = null;
                if (orderBy.indexOf(".") < 0) {
                    columnName = orderBy;
                } else {
                    aliasName = orderBy.substring(0, orderBy.lastIndexOf("."));
                    columnName = orderBy.substring(orderBy.lastIndexOf(".") + 1);
                }
                if (registeredOrderBy.indexOf(".") < 0) {
                    registeredColumnName = registeredOrderBy;
                } else {
                    registeredAliasName = registeredOrderBy.substring(0, registeredOrderBy.lastIndexOf("."));
                    registeredColumnName = registeredOrderBy.substring(registeredOrderBy.lastIndexOf(".") + 1);
                }
                OrderByElement element = new OrderByElement();
                element.setAliasName(aliasName);
                element.setColumnName(columnName);
                element.setRegisteredAliasName(registeredAliasName);
                element.setRegisteredColumnName(registeredColumnName);
                if (ascOrDesc) {
                    element.setupAsc();
                } else {
                    element.setupDesc();
                }
                this._orderByClause.addOrderByElement(element);
                ++count;
            }
        }
        catch (RuntimeException e) {
            String msg = "registerOrderBy() threw the exception: orderByProperty=" + orderByProperty;
            msg = msg + " registeredColumnFullName=" + registeredOrderByProperty;
            msg = msg + " ascOrDesc=" + ascOrDesc;
            msg = msg + " sqlClause=" + this.toString();
            throw new RuntimeException(msg, e);
        }
    }

    @Override
    public void addNullsFirstToPreviousOrderBy() {
        this._orderByClause.addNullsFirstToPreviousOrderByElement(this.createOrderByNullsSetupper());
    }

    @Override
    public void addNullsLastToPreviousOrderBy() {
        this._orderByClause.addNullsLastToPreviousOrderByElement(this.createOrderByNullsSetupper());
    }

    protected OrderByClause.OrderByNullsSetupper createOrderByNullsSetupper() {
        return new OrderByClause.OrderByNullsSetupper(){

            public String setup(String columnName, String orderByElementClause, boolean nullsFirst) {
                return orderByElementClause + " nulls " + (nullsFirst ? "first" : "last");
            }
        };
    }

    protected OrderByClause.OrderByNullsSetupper createOrderByNullsSetupperByCaseWhen() {
        return new OrderByClause.OrderByNullsSetupper(){

            public String setup(String columnName, String orderByElementClause, boolean nullsFirst) {
                String thenNumber = nullsFirst ? "1" : "0";
                String elseNumber = nullsFirst ? "0" : "1";
                String caseWhen = "case when " + columnName + " is not null then " + thenNumber + " else " + elseNumber + " end asc";
                return caseWhen + ", " + orderByElementClause;
            }
        };
    }

    @Override
    public void registerUnionQuery(String unionQueryClause, boolean unionAll) {
        this.assertStringNotNullAndNotTrimmedEmpty("unionQueryClause", unionQueryClause);
        UnionQueryInfo unionQueryInfo = new UnionQueryInfo();
        unionQueryInfo.setUnionQueryClause(unionQueryClause);
        unionQueryInfo.setUnionAll(unionAll);
        this.addUnionQueryInfo(unionQueryInfo);
    }

    protected void addUnionQueryInfo(UnionQueryInfo unionQueryInfo) {
        if (this._unionQueryInfoList == null) {
            this._unionQueryInfoList = new ArrayList<UnionQueryInfo>();
        }
        this._unionQueryInfoList.add(unionQueryInfo);
    }

    @Override
    public boolean hasUnionQuery() {
        return this._unionQueryInfoList != null && !this._unionQueryInfoList.isEmpty();
    }

    @Override
    public SqlClause fetchFirst(int fetchSize) {
        this._isFetchScopeEffective = true;
        if (fetchSize <= 0) {
            String msg = "Argument[fetchSize] should be plus: " + fetchSize;
            throw new IllegalArgumentException(msg);
        }
        this._fetchStartIndex = 0;
        this._fetchSize = fetchSize;
        this._fetchPageNumber = 1;
        this.doClearFetchPageClause();
        this.doFetchFirst();
        return this;
    }

    @Override
    public SqlClause fetchScope(int fetchStartIndex, int fetchSize) {
        this._isFetchScopeEffective = true;
        if (fetchStartIndex < 0) {
            String msg = "Argument[fetchStartIndex] must be plus or zero: " + fetchStartIndex;
            throw new IllegalArgumentException(msg);
        }
        if (fetchSize <= 0) {
            String msg = "Argument[fetchSize] should be plus: " + fetchSize;
            throw new IllegalArgumentException(msg);
        }
        this._fetchStartIndex = fetchStartIndex;
        this._fetchSize = fetchSize;
        return this.fetchPage(1);
    }

    @Override
    public SqlClause fetchPage(int fetchPageNumber) {
        this._isFetchScopeEffective = true;
        if (fetchPageNumber <= 0) {
            fetchPageNumber = 1;
        }
        if (this._fetchSize <= 0) {
            String msg = "Look! Read the message below." + this.getLineSeparator();
            msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.getLineSeparator();
            msg = msg + "Fetch size should not be minus or zero!" + this.getLineSeparator();
            msg = msg + this.getLineSeparator();
            msg = msg + "[Advice]" + this.getLineSeparator();
            msg = msg + "When you invoke this method, it is necessary to invoke 'fetchFirst()' or 'fetchScope()' ahead of that. " + this.getLineSeparator();
            msg = msg + "Please confirm your program. Does it really invoke 'fetchPage()' with 'fetchFirst()' or 'fetchScope()'?" + this.getLineSeparator();
            msg = msg + "  For example:" + this.getLineSeparator();
            msg = msg + "    before (x):" + this.getLineSeparator();
            msg = msg + "      XxxCB cb = new XxxCB();" + this.getLineSeparator();
            msg = msg + "      cb.fetchPage(3);" + this.getLineSeparator();
            msg = msg + "    after  (o):" + this.getLineSeparator();
            msg = msg + "      XxxCB cb = new XxxCB();" + this.getLineSeparator();
            msg = msg + "      cb.fetchFirst(20); // The size of page" + this.getLineSeparator();
            msg = msg + "      cb.fetchPage(3);   // The number of target page" + this.getLineSeparator();
            msg = msg + this.getLineSeparator();
            msg = msg + "[Actual Parameter Value]" + this.getLineSeparator();
            msg = msg + "fetchSize=" + this._fetchSize + this.getLineSeparator();
            msg = msg + "fetchPageNumber=" + fetchPageNumber + this.getLineSeparator();
            msg = msg + "* * * * * * * * * */" + this.getLineSeparator();
            throw new IllegalStateException(msg);
        }
        this._fetchPageNumber = fetchPageNumber;
        if (this._fetchPageNumber == 1 && this._fetchStartIndex == 0) {
            return this.fetchFirst(this._fetchSize);
        }
        this.doClearFetchPageClause();
        this.doFetchPage();
        return this;
    }

    protected abstract void doFetchFirst();

    protected abstract void doFetchPage();

    protected abstract void doClearFetchPageClause();

    @Override
    public int getFetchStartIndex() {
        return this._fetchStartIndex;
    }

    @Override
    public int getFetchSize() {
        return this._fetchSize;
    }

    @Override
    public int getFetchPageNumber() {
        return this._fetchPageNumber;
    }

    @Override
    public int getPageStartIndex() {
        if (this._fetchPageNumber <= 0) {
            String msg = "_fetchPageNumber must be plus: " + this._fetchPageNumber;
            throw new IllegalStateException(msg);
        }
        return this._fetchStartIndex + this._fetchSize * (this._fetchPageNumber - 1);
    }

    @Override
    public int getPageEndIndex() {
        if (this._fetchPageNumber <= 0) {
            String msg = "_fetchPageNumber must be plus: " + this._fetchPageNumber;
            throw new IllegalStateException(msg);
        }
        return this._fetchStartIndex + this._fetchSize * this._fetchPageNumber;
    }

    @Override
    public boolean isFetchScopeEffective() {
        return this._isFetchScopeEffective;
    }

    @Override
    public SqlClause ignoreFetchScope() {
        this._isFetchScopeEffective = false;
        this.doClearFetchPageClause();
        return this;
    }

    @Override
    public SqlClause makeFetchScopeEffective() {
        if (this.getFetchSize() > 0 && this.getFetchPageNumber() > 0) {
            this.fetchPage(this.getFetchPageNumber());
        }
        return this;
    }

    @Override
    public boolean isFetchStartIndexSupported() {
        return true;
    }

    @Override
    public boolean isFetchSizeSupported() {
        return true;
    }

    protected abstract String createSelectHint();

    protected abstract String createFromBaseTableHint();

    protected abstract String createFromHint();

    protected abstract String createSqlSuffix();

    @Override
    public int getFetchNarrowingSkipStartIndex() {
        return this.getPageStartIndex();
    }

    @Override
    public int getFetchNarrowingLoopCount() {
        return this.getFetchSize();
    }

    @Override
    public boolean isFetchNarrowingEffective() {
        return this._isFetchScopeEffective;
    }

    @Override
    public String resolveJoinAliasName(String relationPath, int cqNestNo) {
        return this.resolveNestLevelExpression("dfrelation" + relationPath, cqNestNo);
    }

    @Override
    public String resolveNestLevelExpression(String name, int cqNestNo) {
        return name;
    }

    @Override
    public int resolveRelationNo(String localTableName, String foreignPropertyName) {
        DBMeta dbmeta = this.findDBMeta(localTableName);
        ForeignInfo foreignInfo = dbmeta.findForeignInfo(foreignPropertyName);
        return foreignInfo.getRelationNo();
    }

    @Override
    public String getLocalTableAliasName() {
        return "dflocal";
    }

    @Override
    public String getForeignTableAliasPrefix() {
        return "dfrelation";
    }

    @Override
    public String getWhereClauseMark() {
        return "#df:whereClause#";
    }

    @Override
    public String getWhereFirstConditionMark() {
        return "#df:whereFirstCondition#";
    }

    @Override
    public String getUnionSelectClauseMark() {
        return "#df:unionSelectClause#";
    }

    @Override
    public String getUnionWhereClauseMark() {
        return "#df:unionWhereClause#";
    }

    @Override
    public String getUnionWhereFirstConditionMark() {
        return "#df:unionWhereFirstCondition#";
    }

    @Override
    public void addWhereClauseSimpleFilter(WhereClauseSimpleFilter whereClauseSimpleFilter) {
        if (this._whereClauseSimpleFilterList == null) {
            this._whereClauseSimpleFilterList = new ArrayList<WhereClauseSimpleFilter>();
        }
        this._whereClauseSimpleFilterList.add(whereClauseSimpleFilter);
    }

    protected String filterWhereClauseSimply(String clauseElement) {
        if (this._whereClauseSimpleFilterList == null || this._whereClauseSimpleFilterList.isEmpty()) {
            return clauseElement;
        }
        for (WhereClauseSimpleFilter filter : this._whereClauseSimpleFilterList) {
            if (filter == null) {
                String msg = "The list of filter should not have null: _whereClauseSimpleFilterList=" + this._whereClauseSimpleFilterList;
                throw new IllegalStateException(msg);
            }
            clauseElement = filter.filterClauseElement(clauseElement);
        }
        return clauseElement;
    }

    @Override
    public boolean isSelectedForeignInfoEmpty() {
        if (this._selectedForeignInfo == null) {
            return true;
        }
        return this._selectedForeignInfo.isEmpty();
    }

    @Override
    public boolean hasSelectedForeignInfo(String relationPath) {
        if (this._selectedForeignInfo == null) {
            return false;
        }
        return this._selectedForeignInfo.containsKey(relationPath);
    }

    @Override
    public void registerSelectedForeignInfo(String relationPath, String foreignPropertyName) {
        if (this._selectedForeignInfo == null) {
            this._selectedForeignInfo = new HashMap<String, String>();
        }
        this._selectedForeignInfo.put(relationPath, foreignPropertyName);
    }

    @Override
    public String resolveSubQueryBeginMark(String subQueryIdentity) {
        return this.getSubQueryBeginMarkPrefix() + subQueryIdentity + this.getSubQueryIdentityTerminal();
    }

    @Override
    public String resolveSubQueryEndMark(String subQueryIdentity) {
        return this.getSubQueryEndMarkPrefix() + subQueryIdentity + this.getSubQueryIdentityTerminal();
    }

    protected String getSubQueryBeginMarkPrefix() {
        return "--df:SubQueryBegin#";
    }

    protected String getSubQueryEndMarkPrefix() {
        return "--df:SubQueryEnd#";
    }

    protected String getSubQueryIdentityTerminal() {
        return "#IdentityTerminal#";
    }

    @Override
    public String filterSubQueryIndent(String sql) {
        return this.filterSubQueryIndent(sql, "", sql);
    }

    protected String filterSubQueryIndent(String sql, String preIndent, String originalSql) {
        String lineSeparator = this.getLineSeparator();
        if (!sql.contains(this.getSubQueryBeginMarkPrefix())) {
            return sql;
        }
        String[] lines = sql.split(lineSeparator);
        String beginMarkPrefix = this.getSubQueryBeginMarkPrefix();
        String endMarkPrefix = this.getSubQueryEndMarkPrefix();
        String identityTerminal = this.getSubQueryIdentityTerminal();
        int terminalLength = identityTerminal.length();
        StringBuilder mainSb = new StringBuilder();
        StringBuilder subSb = null;
        boolean throughBegin = false;
        boolean throughBeginFirst = false;
        String subQueryIdentity = null;
        String indent = null;
        for (String line : lines) {
            String clause;
            String msg;
            int terminalIndex;
            int markIndex;
            if (!throughBegin) {
                if (line.contains(beginMarkPrefix)) {
                    throughBegin = true;
                    subSb = new StringBuilder();
                    markIndex = line.indexOf(beginMarkPrefix);
                    terminalIndex = line.indexOf(identityTerminal);
                    if (terminalIndex < 0) {
                        msg = "Identity terminal was Not Found at the begin line: [" + line + "]";
                        throw new SubQueryIndentFailureException(msg);
                    }
                    clause = line.substring(0, markIndex) + line.substring(terminalIndex + terminalLength);
                    subQueryIdentity = line.substring(markIndex + beginMarkPrefix.length(), terminalIndex);
                    subSb.append(clause);
                    indent = this.buildSpaceBar(markIndex - preIndent.length());
                    continue;
                }
                mainSb.append(line).append(this.getLineSeparator());
                continue;
            }
            if (line.contains(endMarkPrefix + subQueryIdentity)) {
                markIndex = line.indexOf(endMarkPrefix);
                terminalIndex = line.indexOf(identityTerminal);
                if (terminalIndex < 0) {
                    msg = "Identity terminal was Not Found at the begin line: [" + line + "]";
                    throw new SubQueryIndentFailureException(msg);
                }
                clause = line.substring(0, markIndex) + line.substring(terminalIndex + terminalLength);
                subSb.append(clause).append(this.getLineSeparator());
                String currentSql = this.filterSubQueryIndent(subSb.toString(), preIndent + indent, originalSql);
                mainSb.append(currentSql);
                throughBegin = false;
                throughBeginFirst = false;
                continue;
            }
            if (!throughBeginFirst) {
                subSb.append(line.trim()).append(this.getLineSeparator());
                throughBeginFirst = true;
                continue;
            }
            subSb.append(indent).append(line).append(this.getLineSeparator());
        }
        String filteredSql = mainSb.toString();
        if (throughBegin) {
            String msg = "End Mark Not Found!";
            msg = msg + this.getLineSeparator() + "[Current SubQueryIdentity]" + this.getLineSeparator();
            msg = msg + subQueryIdentity + this.getLineSeparator();
            msg = msg + this.getLineSeparator() + "[Before Filter]" + this.getLineSeparator() + sql;
            msg = msg + this.getLineSeparator() + "[After Filter]" + this.getLineSeparator() + filteredSql;
            msg = msg + this.getLineSeparator() + "[Original SQL]" + this.getLineSeparator() + originalSql;
            throw new SubQueryIndentFailureException(msg);
        }
        if (filteredSql.contains(beginMarkPrefix)) {
            String msg = "Any begin marks are not filtered!";
            msg = msg + this.getLineSeparator() + "[Current SubQueryIdentity]" + this.getLineSeparator();
            msg = msg + subQueryIdentity + this.getLineSeparator();
            msg = msg + this.getLineSeparator() + "[Before Filter]" + this.getLineSeparator() + sql;
            msg = msg + this.getLineSeparator() + "[After Filter]" + this.getLineSeparator() + filteredSql;
            msg = msg + this.getLineSeparator() + "[Original SQL]" + this.getLineSeparator() + originalSql;
            throw new SubQueryIndentFailureException(msg);
        }
        return filteredSql;
    }

    protected String buildSpaceBar(int size) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            sb.append(" ");
        }
        return sb.toString();
    }

    @Override
    public void specifySelectColumn(String tableAliasName, String columnName) {
        if (this._specifiedSelectColumnMap == null) {
            this._specifiedSelectColumnMap = new HashMap<String, Map<String, String>>();
        }
        if (!this._specifiedSelectColumnMap.containsKey(tableAliasName)) {
            this._specifiedSelectColumnMap.put(tableAliasName, new LinkedHashMap());
        }
        Map<String, String> elementMap = this._specifiedSelectColumnMap.get(tableAliasName);
        elementMap.put(columnName, null);
        this._specifiedSelectColumnMap.put(tableAliasName, elementMap);
    }

    @Override
    public void specifyDeriveSubQuery(String aliasName, String deriveSubQuery) {
        if (this._specifiedDeriveSubQueryMap == null) {
            this._specifiedDeriveSubQueryMap = new LinkedHashMap<String, String>();
        }
        this._specifiedDeriveSubQueryMap.put(aliasName, deriveSubQuery);
    }

    @Override
    public boolean hasSpecifiedDeriveSubQuery(String aliasName) {
        if (this._specifiedDeriveSubQueryMap == null) {
            return false;
        }
        return this._specifiedDeriveSubQueryMap.containsKey(aliasName);
    }

    @Override
    public String getSpecifiedColumnNameAsOne() {
        Map<String, String> elementMap;
        if (this._specifiedSelectColumnMap != null && this._specifiedSelectColumnMap.size() == 1 && (elementMap = this._specifiedSelectColumnMap.get(this._specifiedSelectColumnMap.keySet().iterator().next())) != null && elementMap.size() == 1) {
            return elementMap.keySet().iterator().next();
        }
        return null;
    }

    @Override
    public void clearSpecifiedSelectColumn() {
        if (this._specifiedSelectColumnMap != null) {
            this._specifiedSelectColumnMap.clear();
            this._specifiedSelectColumnMap = null;
        }
    }

    @Override
    public String getClauseQueryUpdate(Map<String, String> columnParameterMap) {
        String subQuery;
        if (columnParameterMap.isEmpty()) {
            return null;
        }
        String aliasName = this.getLocalTableAliasName();
        DBMeta dbmeta = this.findDBMeta(this._tableName);
        if (dbmeta.hasTwoOrMorePrimaryKeys()) {
            String msg = "The target table of queryUpdate() should have only one primary key:";
            msg = msg + " primaryKeys=" + dbmeta.getPrimaryUniqueInfo().getUniqueColumnList();
            throw new IllegalStateException(msg);
        }
        String primaryKeyName = dbmeta.getPrimaryUniqueInfo().getFirstColumn().getColumnDbName();
        String selectClause = "select " + aliasName + "." + primaryKeyName;
        String fromWhereClause = this.getClauseFromWhereWithUnionTemplate();
        fromWhereClause = this.replaceString(fromWhereClause, this.getUnionSelectClauseMark(), selectClause);
        fromWhereClause = this.replaceString(fromWhereClause, this.getUnionWhereClauseMark(), "");
        fromWhereClause = this.replaceString(fromWhereClause, this.getUnionWhereFirstConditionMark(), "");
        StringBuilder sb = new StringBuilder();
        String ln = this.getLineSeparator();
        sb.append("update ").append(this._tableName).append(ln);
        int index = 0;
        for (String columnName : columnParameterMap.keySet()) {
            String parameter = columnParameterMap.get(columnName);
            if (index == 0) {
                sb.append("   set ").append(columnName).append(" = ").append(parameter).append(ln);
            } else {
                sb.append("     , ").append(columnName).append(" = ").append(parameter).append(ln);
            }
            ++index;
        }
        if (this.isUpdateSubQueryUseLocalTableSupported()) {
            subQuery = this.filterSubQueryIndent(selectClause + " " + fromWhereClause);
            sb.append(" where ").append(primaryKeyName);
            sb.append(" in (").append(ln).append(subQuery).append(ln).append(")");
            return sb.toString();
        }
        subQuery = this.filterSubQueryIndent(fromWhereClause);
        subQuery = this.replaceString(subQuery, aliasName + ".", "");
        int whereIndex = (subQuery = this.replaceString(subQuery, " " + aliasName + " ", " ")).indexOf("where ");
        if (whereIndex < 0) {
            return sb.toString();
        }
        subQuery = subQuery.substring(whereIndex);
        sb.append(" ").append(subQuery);
        return sb.toString();
    }

    @Override
    public String getClauseQueryDelete() {
        String aliasName = this.getLocalTableAliasName();
        DBMeta dbmeta = this.findDBMeta(this._tableName);
        if (dbmeta.hasTwoOrMorePrimaryKeys()) {
            String msg = "The target table of queryDelete() should have only one primary key:";
            msg = msg + " primaryKeys=" + dbmeta.getPrimaryUniqueInfo().getUniqueColumnList();
            throw new IllegalStateException(msg);
        }
        String primaryKeyName = dbmeta.getPrimaryUniqueInfo().getFirstColumn().getColumnDbName();
        String selectClause = "select " + aliasName + "." + primaryKeyName;
        String fromWhereClause = this.getClauseFromWhereWithUnionTemplate();
        fromWhereClause = this.replaceString(fromWhereClause, this.getUnionSelectClauseMark(), selectClause);
        fromWhereClause = this.replaceString(fromWhereClause, this.getUnionWhereClauseMark(), "");
        fromWhereClause = this.replaceString(fromWhereClause, this.getUnionWhereFirstConditionMark(), "");
        if (this.isUpdateSubQueryUseLocalTableSupported()) {
            String subQuery = this.filterSubQueryIndent(selectClause + " " + fromWhereClause);
            StringBuilder sb = new StringBuilder();
            String ln = this.getLineSeparator();
            sb.append("delete from ").append(this._tableName).append(ln);
            sb.append(" where ").append(primaryKeyName);
            sb.append(" in (").append(ln).append(subQuery).append(ln).append(")");
            return sb.toString();
        }
        String subQuery = this.filterSubQueryIndent(fromWhereClause);
        subQuery = this.replaceString(subQuery, aliasName + ".", "");
        subQuery = this.replaceString(subQuery, " " + aliasName + " ", " ");
        subQuery = subQuery.substring(subQuery.indexOf("from "));
        return "delete " + subQuery;
    }

    protected boolean isUpdateSubQueryUseLocalTableSupported() {
        return true;
    }

    @Override
    public void classifySelectClauseType(SqlClause.SelectClauseType selectClauseType) {
        this.changeSelectClauseType(selectClauseType);
    }

    protected void changeSelectClauseType(SqlClause.SelectClauseType selectClauseType) {
        this.savePreviousSelectClauseType();
        this._selectClauseType = selectClauseType;
    }

    protected void savePreviousSelectClauseType() {
        this._previousSelectClauseType = this._selectClauseType;
    }

    @Override
    public void rollbackSelectClauseType() {
        this._selectClauseType = this._previousSelectClauseType != null ? this._previousSelectClauseType : DEFAULT_SELECT_CLAUSE_TYPE;
    }

    protected DBMeta findDBMeta(String tableName) {
        if (this._dbmetaProvider == null) {
            String msg = "The DB meta provider should not be null when using findDBMeta(): ";
            msg = msg + " tableName=" + tableName;
            throw new IllegalStateException(msg);
        }
        return this._dbmetaProvider.provideDBMetaChecked(tableName);
    }

    protected String replaceString(String text, String fromText, String toText) {
        return DfStringUtil.replace(text, fromText, toText);
    }

    protected String getLineSeparator() {
        return DfSystemUtil.getLineSeparator();
    }

    protected void assertObjectNotNull(String variableName, Object value) {
        DfAssertUtil.assertObjectNotNull(variableName, value);
    }

    protected void assertStringNotNullAndNotTrimmedEmpty(String variableName, String value) {
        DfAssertUtil.assertStringNotNullAndNotTrimmedEmpty(variableName, value);
    }

    public static class SubQueryIndentFailureException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public SubQueryIndentFailureException(String msg) {
            super(msg);
        }
    }

    protected static class UnionQueryInfo {
        protected String _unionQueryClause;
        protected boolean _unionAll;

        protected UnionQueryInfo() {
        }

        public String getUnionQueryClause() {
            return this._unionQueryClause;
        }

        public void setUnionQueryClause(String unionQueryClause) {
            this._unionQueryClause = unionQueryClause;
        }

        public boolean isUnionAll() {
            return this._unionAll;
        }

        public void setUnionAll(boolean unionAll) {
            this._unionAll = unionAll;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class LeftOuterJoinInfo {
        protected String _aliasName;
        protected String _joinTableName;
        protected List<String> _inlineWhereClauseList = new ArrayList<String>();
        protected List<String> _additionalOnClauseList = new ArrayList<String>();
        protected Map<String, String> _joinOnMap;
        protected boolean _onClauseInline;

        protected LeftOuterJoinInfo() {
        }

        public String getAliasName() {
            return this._aliasName;
        }

        public void setAliasName(String value) {
            this._aliasName = value;
        }

        public String getJoinTableName() {
            return this._joinTableName;
        }

        public void setJoinTableName(String value) {
            this._joinTableName = value;
        }

        public List<String> getInlineWhereClauseList() {
            return this._inlineWhereClauseList;
        }

        public void addInlineWhereClause(String value) {
            this._inlineWhereClauseList.add(value);
        }

        public List<String> getAdditionalOnClauseList() {
            return this._additionalOnClauseList;
        }

        public void addAdditionalOnClause(String value) {
            this._additionalOnClauseList.add(value);
        }

        public Map<String, String> getJoinOnMap() {
            return this._joinOnMap;
        }

        public void setJoinOnMap(Map<String, String> value) {
            this._joinOnMap = value;
        }

        public boolean isOnClauseInline() {
            return this._onClauseInline;
        }

        public void setOnClauseInline(boolean value) {
            this._onClauseInline = value;
        }
    }

    public static class SelectedSelectColumnInfo {
        protected String tableAliasName;
        protected String columnName;
        protected String columnAliasName;

        public String buildRealColumnName() {
            if (this.tableAliasName != null) {
                return this.tableAliasName + "." + this.columnName;
            }
            return this.columnName;
        }

        public String getTableAliasName() {
            return this.tableAliasName;
        }

        public void setTableAliasName(String tableAliasName) {
            this.tableAliasName = tableAliasName;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public void setColumnName(String columnName) {
            this.columnName = columnName;
        }

        public String getColumnAliasName() {
            return this.columnAliasName;
        }

        public void setColumnAliasName(String columnAliasName) {
            this.columnAliasName = columnAliasName;
        }
    }
}

