/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.dbmeta.info;

import java.util.ArrayList;
import java.util.List;
import org.seasar.dbflute.dbmeta.DBMeta;
import org.seasar.dbflute.dbmeta.info.ColumnInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UniqueInfo {
    protected final DBMeta dbmeta;
    protected final List<ColumnInfo> uniqueColumnList;
    protected final boolean primary;

    public UniqueInfo(DBMeta dbmeta, List<ColumnInfo> uniqueColumnList, boolean primary) {
        this.assertObjectNotNull("dbmeta", dbmeta);
        this.assertObjectNotNull("uniqueColumnList", uniqueColumnList);
        this.dbmeta = dbmeta;
        this.uniqueColumnList = uniqueColumnList;
        this.primary = primary;
    }

    public boolean containsColumn(ColumnInfo columnInfo) {
        return this.containsColumn(columnInfo.getColumnDbName());
    }

    protected boolean containsColumn(String columnName) {
        for (ColumnInfo columnInfo : this.uniqueColumnList) {
            if (!columnInfo.getColumnDbName().equals(columnName)) continue;
            return true;
        }
        return false;
    }

    protected void assertObjectNotNull(String variableName, Object value) {
        if (variableName == null) {
            String msg = "The value should not be null: variableName=" + variableName + " value=" + value;
            throw new IllegalArgumentException(msg);
        }
        if (value == null) {
            String msg = "The value should not be null: variableName=" + variableName;
            throw new IllegalArgumentException(msg);
        }
    }

    public int hashCode() {
        return this.dbmeta.hashCode() + ((Object)this.uniqueColumnList).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof UniqueInfo)) {
            return false;
        }
        UniqueInfo target = (UniqueInfo)obj;
        if (!this.dbmeta.equals(target.getDBMeta())) {
            return false;
        }
        return ((Object)this.uniqueColumnList).equals(target.getUniqueColumnList());
    }

    public String toString() {
        return this.dbmeta.getTableDbName() + "." + this.uniqueColumnList;
    }

    public DBMeta getDBMeta() {
        return this.dbmeta;
    }

    public List<ColumnInfo> getUniqueColumnList() {
        return new ArrayList<ColumnInfo>(this.uniqueColumnList);
    }

    public ColumnInfo getFirstColumn() {
        return this.uniqueColumnList.get(0);
    }

    public boolean isTwoOrMore() {
        return this.uniqueColumnList.size() > 1;
    }

    public boolean isPrimary() {
        return this.primary;
    }
}

