/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.helper.token.file.impl;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.seasar.dbflute.helper.token.file.FileMakingCallback;
import org.seasar.dbflute.helper.token.file.FileMakingHeaderInfo;
import org.seasar.dbflute.helper.token.file.FileMakingOption;
import org.seasar.dbflute.helper.token.file.FileMakingRowResource;
import org.seasar.dbflute.helper.token.file.FileToken;
import org.seasar.dbflute.helper.token.file.FileTokenizingCallback;
import org.seasar.dbflute.helper.token.file.FileTokenizingHeaderInfo;
import org.seasar.dbflute.helper.token.file.FileTokenizingOption;
import org.seasar.dbflute.helper.token.file.FileTokenizingRowResource;
import org.seasar.dbflute.helper.token.line.LineMakingOption;
import org.seasar.dbflute.helper.token.line.LineToken;
import org.seasar.dbflute.helper.token.line.LineTokenizingOption;
import org.seasar.dbflute.helper.token.line.impl.LineTokenImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileTokenImpl
implements FileToken {
    protected final LineToken _lineToken = new LineTokenImpl();

    @Override
    public void tokenize(String filename, FileTokenizingCallback fileTokenizingCallback, FileTokenizingOption fileTokenizingOption) throws FileNotFoundException, IOException {
        this.assertStringNotNullAndNotTrimmedEmpty("filename", filename);
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(filename);
            this.tokenize(fis, fileTokenizingCallback, fileTokenizingOption);
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException ignored) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void tokenize(InputStream inputStream, FileTokenizingCallback fileTokenizingCallback, FileTokenizingOption fileTokenizingOption) throws FileNotFoundException, IOException {
        block28: {
            this.assertObjectNotNull("inputStream", inputStream);
            this.assertObjectNotNull("fileTokenizingCallback", fileTokenizingCallback);
            this.assertObjectNotNull("fileTokenizingOption", fileTokenizingOption);
            delimiter = fileTokenizingOption.getDelimiter();
            encoding = fileTokenizingOption.getEncoding();
            this.assertStringNotNullAndNotTrimmedEmpty("encoding", encoding);
            this.assertObjectNotNull("delimiter", delimiter);
            ir = null;
            br = null;
            lineString = null;
            preContinueString = "";
            temporaryValueList = new ArrayList<String>();
            filteredValueList = new ArrayList<String>();
            try {
                ir = new InputStreamReader(inputStream, encoding);
                br = new BufferedReader(ir);
                fileTokenizingHeaderInfo = null;
                count = -1;
                rowNumber = 1;
                lineNumber = 0;
                while (true) lbl-1000:
                // 5 sources

                {
                    ++count;
                    if ("".equals(preContinueString)) {
                        lineNumber = count + 1;
                    }
                    if ((lineString = br.readLine()) == null) {
                        break block28;
                    }
                    if (count == 0) {
                        if (fileTokenizingOption.isBeginFirstLine()) {
                            fileTokenizingHeaderInfo = new FileTokenizingHeaderInfo();
                        } else {
                            fileTokenizingHeaderInfo = this.analyzeHeaderInfo(delimiter, lineString);
                            continue;
                        }
                    }
                    if (preContinueString.equals("")) {
                        rowString = lineString;
                    } else {
                        lineSeparator = System.getProperty("line.separator");
                        rowString = preContinueString + lineSeparator + lineString;
                    }
                    valueLineInfo = this.arrangeValueList(rowString, delimiter);
                    ls = valueLineInfo.getValueList();
                    if (valueLineInfo.isContinueNextLine()) {
                        preContinueString = ls.remove(ls.size() - 1);
                        temporaryValueList.addAll(ls);
                        continue;
                    }
                    temporaryValueList.addAll(ls);
                    try {
                        fileTokenizingRowResource = new FileTokenizingRowResource();
                        fileTokenizingRowResource.setFirstLineInfo(fileTokenizingHeaderInfo);
                        if (fileTokenizingOption.isHandleEmptyAsNull()) {
                            for (String value : temporaryValueList) {
                                if ("".equals(value)) {
                                    filteredValueList.add(null);
                                    continue;
                                }
                                filteredValueList.add(value);
                            }
                            fileTokenizingRowResource.setValueList(filteredValueList);
                        } else {
                            fileTokenizingRowResource.setValueList(temporaryValueList);
                        }
                        fileTokenizingRowResource.setRowString(rowString);
                        fileTokenizingRowResource.setRowNumber(rowNumber);
                        fileTokenizingRowResource.setLineNumber(lineNumber);
                        fileTokenizingCallback.handleRowResource(fileTokenizingRowResource);
                    }
                    finally {
                        ++rowNumber;
                        temporaryValueList.clear();
                        filteredValueList.clear();
                        preContinueString = "";
                        continue;
                    }
                    break;
                }
            }
            catch (FileNotFoundException e) {
                throw e;
            }
            catch (IOException e) {
                throw e;
            }
            finally {
                try {
                    if (ir != null) {
                        ir.close();
                    }
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException ignored) {}
            }
            ** GOTO lbl-1000
        }
    }

    protected ValueLineInfo arrangeValueList(String lineString, String delimiter) {
        ArrayList<String> valueList = new ArrayList<String>();
        LineTokenizingOption tokenizingOption = new LineTokenizingOption();
        tokenizingOption.setDelimiter(delimiter);
        List<String> list = this._lineToken.tokenize(lineString, tokenizingOption);
        String[] values = list.toArray(new String[list.size()]);
        for (int i = 0; i < values.length; ++i) {
            valueList.add(values[i]);
        }
        return this.arrangeValueList(valueList, delimiter);
    }

    protected ValueLineInfo arrangeValueList(List<String> valueList, String delimiter) {
        ValueLineInfo valueLineInfo = new ValueLineInfo();
        ArrayList<String> resultList = new ArrayList<String>();
        String preString = "";
        for (int i = 0; i < valueList.size(); ++i) {
            String value = valueList.get(i);
            if (value == null) continue;
            if (i == valueList.size() - 1) {
                if (preString.equals("")) {
                    if (this.isFrontQOnly(value)) {
                        valueLineInfo.setContinueNextLine(true);
                        resultList.add(value);
                        break;
                    }
                    if (this.isRearQOnly(value)) {
                        resultList.add(value);
                        break;
                    }
                    if (this.isNotBothQ(value)) {
                        resultList.add(value);
                        break;
                    }
                    resultList.add(this.removeDoubleQuotation(value));
                    break;
                }
                if (this.isFrontQOnly(value)) {
                    valueLineInfo.setContinueNextLine(true);
                    resultList.add(this.connectPreString(preString, delimiter, value));
                    break;
                }
                if (this.isRearQOnly(value)) {
                    resultList.add(this.removeDoubleQuotation(this.connectPreString(preString, delimiter, value)));
                    break;
                }
                if (this.isNotBothQ(value)) {
                    valueLineInfo.setContinueNextLine(true);
                    resultList.add(this.connectPreString(preString, delimiter, value));
                    break;
                }
                resultList.add(this.removeDoubleQuotation(this.connectPreString(preString, delimiter, value)));
                break;
            }
            if (preString.equals("")) {
                if (this.isFrontQOnly(value)) {
                    preString = value;
                    continue;
                }
                if (this.isRearQOnly(value)) {
                    preString = value;
                    continue;
                }
                if (this.isNotBothQ(value)) {
                    resultList.add(value);
                } else {
                    resultList.add(this.removeDoubleQuotation(value));
                }
            } else {
                if (this.isFrontQOnly(value)) {
                    preString = this.connectPreString(preString, delimiter, value);
                    continue;
                }
                if (this.isRearQOnly(value)) {
                    resultList.add(this.removeDoubleQuotation(this.connectPreString(preString, delimiter, value)));
                } else {
                    if (this.isNotBothQ(value)) {
                        preString = this.connectPreString(preString, delimiter, value);
                        continue;
                    }
                    resultList.add(this.removeDoubleQuotation(this.connectPreString(preString, delimiter, value)));
                }
            }
            preString = "";
        }
        valueLineInfo.setValueList(resultList);
        return valueLineInfo;
    }

    protected String connectPreString(String preString, String delimiter, String value) {
        if (preString.equals("")) {
            return value;
        }
        return preString + delimiter + value;
    }

    protected boolean isNotBothQ(String value) {
        return !value.startsWith("\"") && !value.endsWith("\"");
    }

    protected boolean isRearQOnly(String value) {
        return !value.startsWith("\"") && value.endsWith("\"");
    }

    protected boolean isFrontQOnly(String value) {
        return value.startsWith("\"") && !value.endsWith("\"");
    }

    protected String removeDoubleQuotation(String value) {
        if (!value.startsWith("\"") && !value.endsWith("\"")) {
            return value;
        }
        if (value.startsWith("\"")) {
            value = value.substring(1);
        }
        if (value.endsWith("\"")) {
            value = value.substring(0, value.length() - 1);
        }
        return value;
    }

    protected String removeRightDoubleQuotation(String value) {
        if (value.endsWith("\"")) {
            value = value.substring(0, value.length() - 1);
        }
        return value;
    }

    protected FileTokenizingHeaderInfo analyzeHeaderInfo(String delimiter, String lineString) {
        ArrayList<String> columnNameList = new ArrayList<String>();
        String[] values = lineString.split(delimiter);
        for (int i = 0; i < values.length; ++i) {
            String value = values[i].trim();
            if (value.startsWith("\"") && value.endsWith("\"")) {
                columnNameList.add(value.substring(1, value.length() - 1));
                continue;
            }
            columnNameList.add(value);
        }
        FileTokenizingHeaderInfo fileTokenizingHeaderInfo = new FileTokenizingHeaderInfo();
        fileTokenizingHeaderInfo.setColumnNameList(columnNameList);
        fileTokenizingHeaderInfo.setColumnNameRowString(lineString);
        return fileTokenizingHeaderInfo;
    }

    @Override
    public void make(String filename, FileMakingCallback fileMakingCallback, FileMakingOption fileMakingOption) throws FileNotFoundException, IOException {
        this.assertStringNotNullAndNotTrimmedEmpty("filename", filename);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(filename);
            this.make(fos, fileMakingCallback, fileMakingOption);
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
    }

    @Override
    public void make(OutputStream outputStream, FileMakingCallback fileMakingCallback, FileMakingOption fileMakingOption) throws FileNotFoundException, IOException {
        this.assertObjectNotNull("outputStream", outputStream);
        this.assertObjectNotNull("fileMakingCallback", fileMakingCallback);
        this.assertObjectNotNull("fileMakingOption", fileMakingOption);
        String encoding = fileMakingOption.getEncoding();
        String delimiter = fileMakingOption.getDelimiter();
        this.assertStringNotNullAndNotTrimmedEmpty("encoding", encoding);
        this.assertObjectNotNull("delimiter", delimiter);
        String lineSeparator = fileMakingOption.getLineSeparator() != null && !fileMakingOption.getLineSeparator().equals("") ? fileMakingOption.getLineSeparator() : System.getProperty("line.separator");
        BufferedOutputStream bos = null;
        Writer writer = null;
        try {
            List<String> columnNameList;
            bos = new BufferedOutputStream(outputStream);
            writer = new OutputStreamWriter((OutputStream)bos, encoding);
            boolean headerDone = false;
            FileMakingHeaderInfo fileMakingHeaderInfo = fileMakingOption.getFileMakingHeaderInfo();
            if (fileMakingHeaderInfo != null && (columnNameList = fileMakingHeaderInfo.getColumnNameList()) != null && !columnNameList.isEmpty()) {
                LineMakingOption lineMakingOption = new LineMakingOption();
                lineMakingOption.setDelimiter(delimiter);
                lineMakingOption.trimSpace();
                String columnHeaderString = this._lineToken.make(columnNameList, lineMakingOption);
                writer.write(columnHeaderString + lineSeparator);
                headerDone = true;
            }
            FileMakingRowResource rowResource = null;
            while ((rowResource = fileMakingCallback.getRowResource()) != null) {
                List<String> valueList;
                if (rowResource.getValueList() != null) {
                    valueList = rowResource.getValueList();
                } else {
                    LinkedHashMap<String, String> nameValueMap = rowResource.getNameValueMap();
                    if (!headerDone) {
                        ArrayList<String> columnNameList2 = new ArrayList<String>(nameValueMap.keySet());
                        LineMakingOption lineMakingOption = new LineMakingOption();
                        lineMakingOption.setDelimiter(delimiter);
                        lineMakingOption.trimSpace();
                        String columnHeaderString = this._lineToken.make(columnNameList2, lineMakingOption);
                        writer.write(columnHeaderString + lineSeparator);
                        headerDone = true;
                    }
                    valueList = new ArrayList<String>(nameValueMap.values());
                }
                LineMakingOption lineMakingOption = new LineMakingOption();
                lineMakingOption.setDelimiter(delimiter);
                if (!fileMakingOption.isGoodByeDoubleQuotation()) {
                    lineMakingOption.quoteByDoubleQuotation();
                }
                String lineString = this._lineToken.make(valueList, lineMakingOption);
                writer.write(lineString + lineSeparator);
            }
            writer.flush();
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (bos != null) {
                bos.close();
            }
            if (writer != null) {
                writer.close();
            }
        }
    }

    protected void assertObjectNotNull(String variableName, Object value) {
        if (variableName == null) {
            String msg = "The value should not be null: variableName=" + variableName + " value=" + value;
            throw new IllegalArgumentException(msg);
        }
        if (value == null) {
            String msg = "The value should not be null: variableName=" + variableName;
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertStringNotNullAndNotTrimmedEmpty(String variableName, String value) {
        this.assertObjectNotNull("variableName", variableName);
        this.assertObjectNotNull(variableName, value);
        if (value.trim().length() == 0) {
            String msg = "The value should not be empty: variableName=" + variableName + " value=" + value;
            throw new IllegalArgumentException(msg);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ValueLineInfo {
        protected List<String> valueList;
        protected boolean continueNextLine;

        public List<String> getValueList() {
            return this.valueList;
        }

        public void setValueList(List<String> valueList) {
            this.valueList = valueList;
        }

        public boolean isContinueNextLine() {
            return this.continueNextLine;
        }

        public void setContinueNextLine(boolean continueNextLine) {
            this.continueNextLine = continueNextLine;
        }
    }
}

