/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.s2dao.extension;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.ConditionBeanContext;
import org.seasar.dbflute.dbmeta.DBMeta;
import org.seasar.dbflute.jdbc.ValueType;
import org.seasar.dbflute.resource.ResourceContext;
import org.seasar.dbflute.s2dao.beans.TnPropertyDesc;
import org.seasar.dbflute.s2dao.extension.TnRowCreatorExtension;
import org.seasar.dbflute.s2dao.metadata.TnBeanMetaData;
import org.seasar.dbflute.s2dao.metadata.TnPropertyType;
import org.seasar.dbflute.s2dao.metadata.TnRelationPropertyType;
import org.seasar.dbflute.s2dao.rowcreator.impl.TnRelationRowCreationResource;
import org.seasar.dbflute.s2dao.rowcreator.impl.TnRelationRowCreatorImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TnRelationRowCreatorExtension
extends TnRelationRowCreatorImpl {
    @Override
    protected Object createRelationRow(TnRelationRowCreationResource res) throws SQLException {
        if (!res.hasPropertyCacheElement()) {
            return null;
        }
        this.setupRelationKeyValue(res);
        this.setupRelationAllValue(res);
        return res.getRow();
    }

    @Override
    protected void setupRelationKeyValue(TnRelationRowCreationResource res) {
        TnRelationPropertyType rpt = res.getRelationPropertyType();
        TnBeanMetaData bmd = rpt.getBeanMetaData();
        DBMeta dbmeta = this.findDBMeta(bmd.getBeanClass(), bmd.getTableName());
        for (int i = 0; i < rpt.getKeySize(); ++i) {
            Object value;
            String columnName = rpt.getMyKey(i) + res.getBaseSuffix();
            if (!res.containsColumnName(columnName)) continue;
            if (!res.hasRowInstance()) {
                Object row = dbmeta != null ? dbmeta.newEntity() : this.newRelationRow(rpt);
                res.setRow(row);
            }
            if (!res.containsRelKeyValueIfExists(columnName) || (value = res.extractRelKeyValue(columnName)) == null) continue;
            String yourKey = rpt.getYourKey(i);
            TnPropertyType pt = bmd.getPropertyTypeByColumnName(yourKey);
            TnPropertyDesc pd = pt.getPropertyDesc();
            pd.setValue(res.getRow(), value);
        }
    }

    protected Object createRelationRowInstance(DBMeta dbmeta) {
        if (dbmeta != null) {
            return dbmeta.newEntity();
        }
        return null;
    }

    protected DBMeta findDBMeta(Class<?> rowType, String tableName) {
        return TnRowCreatorExtension.findDBMeta(rowType, tableName);
    }

    @Override
    protected void setupRelationAllValue(TnRelationRowCreationResource res) throws SQLException {
        Map<String, TnPropertyType> propertyCacheElement = res.extractPropertyCacheElement();
        Set<String> columnNameCacheElementKeySet = propertyCacheElement.keySet();
        for (String columnName : columnNameCacheElementKeySet) {
            TnPropertyType pt = propertyCacheElement.get(columnName);
            res.setCurrentPropertyType(pt);
            if (!this.isValidRelationPerPropertyLoop(res)) {
                res.clearRowInstance();
                return;
            }
            this.setupRelationProperty(res);
        }
        if (!this.isValidRelationAfterPropertyLoop(res)) {
            res.clearRowInstance();
            return;
        }
        res.clearValidValueCount();
        if (res.hasNextRelationProperty() && (this.hasConditionBean(res) || res.hasNextRelationLevel())) {
            this.setupNextRelationRow(res);
        }
    }

    @Override
    protected void registerRelationValue(TnRelationRowCreationResource res, String columnName) throws SQLException {
        TnPropertyType pt = res.getCurrentPropertyType();
        Object value = null;
        if (res.containsRelKeyValueIfExists(columnName)) {
            value = res.extractRelKeyValue(columnName);
        } else {
            ValueType valueType = pt.getValueType();
            Map<String, Integer> selectIndexMap = res.getSelectIndexMap();
            value = selectIndexMap != null ? ResourceContext.getValue(res.getResultSet(), columnName, valueType, selectIndexMap) : valueType.getValue(res.getResultSet(), columnName);
        }
        if (value != null) {
            res.incrementValidValueCount();
            DBMeta dbmeta = this.findDBMeta(res.getRow());
            String propertyName = pt.getPropertyName();
            if (dbmeta != null && dbmeta.hasEntityPropertySetupper(propertyName)) {
                dbmeta.setupEntityProperty(propertyName, res.getRow(), value);
            } else {
                TnPropertyDesc pd = pt.getPropertyDesc();
                pd.setValue(res.getRow(), value);
            }
        }
    }

    protected DBMeta findDBMeta(Object row) {
        return TnRowCreatorExtension.findDBMeta(row);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setupPropertyCache(TnRelationRowCreationResource res) throws SQLException {
        res.initializePropertyCacheElement();
        if (this.hasConditionBean(res) && !this.hasSelectedForeignInfo(res)) {
            return;
        }
        TnBeanMetaData nextBmd = res.getRelationBeanMetaData();
        Map<String, TnPropertyType> propertyTypeMap = nextBmd.getPropertyTypeMap();
        Set<String> keySet = propertyTypeMap.keySet();
        for (String key : keySet) {
            TnPropertyType pt = propertyTypeMap.get(key);
            res.setCurrentPropertyType(pt);
            if (!this.isTargetProperty(res)) continue;
            this.setupPropertyCacheElement(res);
        }
        if (res.hasNextRelationProperty() && (this.hasConditionBean(res) || res.hasNextRelationLevel())) {
            res.backupRelationPropertyType();
            res.incrementCurrentRelationNestLevel();
            try {
                this.setupNextPropertyCache(res, nextBmd);
            }
            finally {
                res.restoreRelationPropertyType();
                res.decrementCurrentRelationNestLevel();
            }
        }
    }

    @Override
    protected boolean isTargetProperty(TnRelationRowCreationResource res) throws SQLException {
        TnPropertyType pt = res.getCurrentPropertyType();
        if (!pt.getPropertyDesc().hasWriteMethod()) {
            return false;
        }
        return !List.class.isAssignableFrom(pt.getPropertyDesc().getPropertyType());
    }

    @Override
    protected boolean isCreateDeadLink() {
        return false;
    }

    @Override
    protected int getLimitRelationNestLevel() {
        return 2;
    }

    protected TnRelationRowCreationResource createResourceForRow(ResultSet rs, TnRelationPropertyType rpt, Set columnNames, Map relKeyValues, Map relationPropertyCache) throws SQLException {
        TnRelationRowCreationResourceExtension res = new TnRelationRowCreationResourceExtension();
        res.setResultSet(rs);
        res.setRelationPropertyType(rpt);
        res.setColumnNames(columnNames);
        res.setRelKeyValues(relKeyValues);
        res.setRelationPropertyCache(relationPropertyCache);
        res.setBaseSuffix("");
        res.setRelationNoSuffix(this.buildRelationNoSuffix(rpt));
        res.setLimitRelationNestLevel(this.getLimitRelationNestLevel());
        res.setCurrentRelationNestLevel(1);
        res.setCreateDeadLink(this.isCreateDeadLink());
        res.setSelectIndexMap(ResourceContext.getSelectIndexMap());
        return res;
    }

    protected TnRelationRowCreationResource createResourceForPropertyCache(TnRelationPropertyType rpt, Set columnNames, Map relationPropertyCache, String baseSuffix, String relationNoSuffix, int limitRelationNestLevel) throws SQLException {
        TnRelationRowCreationResourceExtension res = new TnRelationRowCreationResourceExtension();
        res.setRelationPropertyType(rpt);
        res.setColumnNames(columnNames);
        res.setRelationPropertyCache(relationPropertyCache);
        res.setBaseSuffix(baseSuffix);
        res.setRelationNoSuffix(relationNoSuffix);
        res.setLimitRelationNestLevel(limitRelationNestLevel);
        res.setCurrentRelationNestLevel(1);
        res.setSelectIndexMap(ResourceContext.getSelectIndexMap());
        return res;
    }

    protected boolean isConditionBeanSelectedRelation(TnRelationRowCreationResource res) {
        ConditionBean cb;
        return this.hasConditionBean(res) && (cb = ConditionBeanContext.getConditionBeanOnThread()).getSqlClause().hasSelectedForeignInfo(res.getRelationNoSuffix());
    }

    protected boolean hasConditionBean(TnRelationRowCreationResource res) {
        return ConditionBeanContext.isExistConditionBeanOnThread();
    }

    protected boolean hasSelectedForeignInfo(TnRelationRowCreationResource res) {
        ConditionBean cb = ConditionBeanContext.getConditionBeanOnThread();
        return cb.getSqlClause().hasSelectedForeignInfo(res.getRelationNoSuffix());
    }

    protected static class TnRelationRowCreationResourceExtension
    extends TnRelationRowCreationResource {
        protected Stack<TnRelationPropertyType> backupRelationPropertyType = new Stack();
        protected Stack<String> backupBaseSuffix = new Stack();
        protected Stack<String> backupRelationSuffix = new Stack();

        protected TnRelationRowCreationResourceExtension() {
        }

        public void backupRelationPropertyType() {
            this.backupRelationPropertyType.push(this.getRelationPropertyType());
        }

        public void restoreRelationPropertyType() {
            this.setRelationPropertyType(this.backupRelationPropertyType.pop());
        }

        public void backupSuffixAndPrepare(String baseSuffix, String additionalRelationNoSuffix) {
            this.backupBaseSuffixExtension();
            this.backupRelationNoSuffixExtension();
            this.setBaseSuffix(baseSuffix);
            this.addRelationNoSuffix(additionalRelationNoSuffix);
        }

        public void restoreSuffix() {
            this.restoreBaseSuffixExtension();
            this.restoreRelationNoSuffixExtension();
        }

        protected void backupBaseSuffixExtension() {
            this.backupBaseSuffix.push(this.getBaseSuffix());
        }

        protected void restoreBaseSuffixExtension() {
            this.setBaseSuffix(this.backupBaseSuffix.pop());
        }

        protected void backupRelationNoSuffixExtension() {
            this.backupRelationSuffix.push(this.getRelationNoSuffix());
        }

        protected void restoreRelationNoSuffixExtension() {
            this.setRelationNoSuffix(this.backupRelationSuffix.pop());
        }
    }
}

