/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.s2dao.rshandler;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.Set;
import org.seasar.dbflute.Entity;
import org.seasar.dbflute.s2dao.metadata.TnBeanMetaData;
import org.seasar.dbflute.s2dao.metadata.TnPropertyType;
import org.seasar.dbflute.s2dao.metadata.TnRelationPropertyType;
import org.seasar.dbflute.s2dao.rowcreator.TnRelationRowCreator;
import org.seasar.dbflute.s2dao.rowcreator.TnRowCreator;
import org.seasar.dbflute.s2dao.rshandler.TnAbstractDtoMetaDataResultSetHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TnAbstractBeanMetaDataResultSetHandler
extends TnAbstractDtoMetaDataResultSetHandler {
    private TnBeanMetaData beanMetaData;
    protected TnRelationRowCreator relationRowCreator;

    public TnAbstractBeanMetaDataResultSetHandler(TnBeanMetaData beanMetaData, TnRowCreator rowCreator, TnRelationRowCreator relationRowCreator) {
        super(beanMetaData, rowCreator);
        this.beanMetaData = beanMetaData;
        this.relationRowCreator = relationRowCreator;
    }

    @Override
    protected Map<String, TnPropertyType> createPropertyCache(Set<String> columnNames) throws SQLException {
        return this.rowCreator.createPropertyCache(columnNames, this.beanMetaData);
    }

    @Override
    protected Object createRow(ResultSet rs, Map<String, TnPropertyType> propertyCache) throws SQLException {
        Class<?> beanClass = this.beanMetaData.getBeanClass();
        return this.rowCreator.createRow(rs, propertyCache, beanClass);
    }

    protected Map<String, Map<String, TnPropertyType>> createRelationPropertyCache(Set<String> columnNames) throws SQLException {
        return this.relationRowCreator.createPropertyCache(columnNames, this.beanMetaData);
    }

    protected Object createRelationRow(ResultSet rs, TnRelationPropertyType rpt, Set<String> columnNames, Map<String, Object> relKeyValues, Map<String, Map<String, TnPropertyType>> relationPropertyCache) throws SQLException {
        return this.relationRowCreator.createRelationRow(rs, rpt, columnNames, relKeyValues, relationPropertyCache);
    }

    protected void postCreateRow(Object row) {
        if (row instanceof Entity) {
            ((Entity)row).clearModifiedPropertyNames();
        } else {
            TnBeanMetaData bmd = this.getBeanMetaData();
            Set<String> names = bmd.getModifiedPropertyNames(row);
            names.clear();
        }
    }

    public TnBeanMetaData getBeanMetaData() {
        return this.beanMetaData;
    }
}

