/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.s2dao.sqlcommand;

import java.util.ArrayList;
import java.util.Arrays;
import javax.sql.DataSource;
import org.seasar.dbflute.exception.EntityAlreadyUpdatedException;
import org.seasar.dbflute.jdbc.StatementFactory;
import org.seasar.dbflute.s2dao.identity.TnIdentifierGenerator;
import org.seasar.dbflute.s2dao.metadata.TnBeanMetaData;
import org.seasar.dbflute.s2dao.metadata.TnPropertyType;
import org.seasar.dbflute.s2dao.sqlcommand.TnAbstractStaticCommand;
import org.seasar.dbflute.s2dao.sqlhandler.TnAbstractAutoHandler;

public abstract class TnAbstractAutoStaticCommand
extends TnAbstractStaticCommand {
    private TnPropertyType[] propertyTypes;
    protected boolean optimisticLockHandling;
    protected boolean versionNoAutoIncrementOnMemory;

    public TnAbstractAutoStaticCommand(DataSource dataSource, StatementFactory statementFactory, TnBeanMetaData beanMetaData, String[] propertyNames, boolean optimisticLockHandling, boolean versionNoAutoIncrementOnMemory) {
        super(dataSource, statementFactory, beanMetaData);
        this.optimisticLockHandling = optimisticLockHandling;
        this.versionNoAutoIncrementOnMemory = versionNoAutoIncrementOnMemory;
        this.setupPropertyTypes(propertyNames);
        this.setupSql();
    }

    public Object execute(Object[] args) {
        TnAbstractAutoHandler handler = this.createAutoHandler();
        handler.setOptimisticLockHandling(this.optimisticLockHandling);
        handler.setVersionNoAutoIncrementOnMemory(this.versionNoAutoIncrementOnMemory);
        handler.setSql(this.getSql());
        handler.setLoggingMessageSqlArgs(args);
        int rows = handler.execute(args);
        return new Integer(rows);
    }

    protected EntityAlreadyUpdatedException createEntityAlreadyUpdatedException(Object bean, int rows) {
        return new EntityAlreadyUpdatedException(bean, rows);
    }

    protected TnPropertyType[] getPropertyTypes() {
        return this.propertyTypes;
    }

    protected void setPropertyTypes(TnPropertyType[] propertyTypes) {
        this.propertyTypes = propertyTypes;
    }

    protected abstract TnAbstractAutoHandler createAutoHandler();

    protected abstract void setupPropertyTypes(String[] var1);

    protected void setupInsertPropertyTypes(String[] propertyNames) {
        ArrayList<TnPropertyType> types = new ArrayList<TnPropertyType>();
        for (int i = 0; i < propertyNames.length; ++i) {
            TnPropertyType pt = this.getBeanMetaData().getPropertyType(propertyNames[i]);
            if (!this.isInsertTarget(pt)) continue;
            types.add(pt);
        }
        this.propertyTypes = types.toArray(new TnPropertyType[types.size()]);
    }

    protected boolean isInsertTarget(TnPropertyType propertyType) {
        if (propertyType.isPrimaryKey()) {
            String name = propertyType.getPropertyName();
            TnIdentifierGenerator generator = this.getBeanMetaData().getIdentifierGenerator(name);
            return generator.isSelfGenerate();
        }
        return true;
    }

    protected void setupUpdatePropertyTypes(String[] propertyNames) {
        ArrayList<TnPropertyType> types = new ArrayList<TnPropertyType>();
        for (int i = 0; i < propertyNames.length; ++i) {
            TnPropertyType pt = this.getBeanMetaData().getPropertyType(propertyNames[i]);
            if (pt.isPrimaryKey()) continue;
            types.add(pt);
        }
        if (types.size() == 0) {
            String msg = "The property type that is not primary key was not found:";
            msg = msg + " propertyNames=" + Arrays.asList(propertyNames);
            throw new IllegalStateException(msg);
        }
        this.propertyTypes = types.toArray(new TnPropertyType[types.size()]);
    }

    protected void setupDeletePropertyTypes(String[] propertyNames) {
    }

    protected abstract void setupSql();

    protected void setupInsertSql() {
        TnPropertyType pt;
        int i;
        TnBeanMetaData bmd = this.getBeanMetaData();
        StringBuilder sb = new StringBuilder(100);
        sb.append("insert into ");
        sb.append(bmd.getTableName());
        sb.append(" (");
        for (i = 0; i < this.propertyTypes.length; ++i) {
            pt = this.propertyTypes[i];
            if (!this.isInsertTarget(pt)) continue;
            sb.append(pt.getColumnName());
            sb.append(", ");
        }
        sb.setLength(sb.length() - 2);
        sb.append(") values (");
        for (i = 0; i < this.propertyTypes.length; ++i) {
            pt = this.propertyTypes[i];
            if (!this.isInsertTarget(pt)) continue;
            sb.append("?, ");
        }
        sb.setLength(sb.length() - 2);
        sb.append(")");
        this.setSql(sb.toString());
    }

    protected void setupUpdateSql() {
        this.checkPrimaryKey();
        StringBuilder sb = new StringBuilder(100);
        sb.append("update ");
        sb.append(this.getBeanMetaData().getTableName());
        sb.append(" set ");
        String versionNoPropertyName = this.getBeanMetaData().getVersionNoPropertyName();
        for (int i = 0; i < this.propertyTypes.length; ++i) {
            TnPropertyType pt = this.propertyTypes[i];
            if (pt.getPropertyName().equalsIgnoreCase(versionNoPropertyName) && !this.versionNoAutoIncrementOnMemory) {
                sb.append(pt.getColumnName()).append(" = ").append(pt.getColumnName()).append(" + 1, ");
                continue;
            }
            sb.append(pt.getColumnName()).append(" = ?, ");
        }
        sb.setLength(sb.length() - 2);
        this.setupUpdateWhere(sb);
        this.setSql(sb.toString());
    }

    protected void setupDeleteSql() {
        this.checkPrimaryKey();
        StringBuilder sb = new StringBuilder(100);
        sb.append("delete from ");
        sb.append(this.getBeanMetaData().getTableName());
        this.setupUpdateWhere(sb);
        this.setSql(sb.toString());
    }

    protected void checkPrimaryKey() {
        TnBeanMetaData bmd = this.getBeanMetaData();
        if (bmd.getPrimaryKeySize() == 0) {
            String msg = "The primary key was not found:";
            msg = msg + " bean=" + bmd.getBeanClass();
            throw new IllegalStateException(msg);
        }
    }

    protected void setupUpdateWhere(StringBuilder sb) {
        TnBeanMetaData bmd = this.getBeanMetaData();
        sb.append(" where ");
        for (int i = 0; i < bmd.getPrimaryKeySize(); ++i) {
            sb.append(bmd.getPrimaryKey(i)).append(" = ? and ");
        }
        sb.setLength(sb.length() - 5);
        if (this.optimisticLockHandling && bmd.hasVersionNoPropertyType()) {
            TnPropertyType pt = bmd.getVersionNoPropertyType();
            sb.append(" and ").append(pt.getColumnName()).append(" = ?");
        }
        if (this.optimisticLockHandling && bmd.hasTimestampPropertyType()) {
            TnPropertyType pt = bmd.getTimestampPropertyType();
            sb.append(" and ").append(pt.getColumnName()).append(" = ?");
        }
    }
}

