/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.s2dao.sqlhandler;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.seasar.dbflute.CallbackContext;
import org.seasar.dbflute.DBDef;
import org.seasar.dbflute.QLog;
import org.seasar.dbflute.jdbc.SqlLogHandler;
import org.seasar.dbflute.jdbc.StatementFactory;
import org.seasar.dbflute.jdbc.ValueType;
import org.seasar.dbflute.resource.ResourceContext;
import org.seasar.dbflute.resource.SQLExceptionHandler;
import org.seasar.dbflute.s2dao.extension.TnSqlLogRegistry;
import org.seasar.dbflute.s2dao.valuetype.TnValueTypes;
import org.seasar.dbflute.twowaysql.CompleteSqlBuilder;
import org.seasar.dbflute.util.DfSystemUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TnBasicHandler {
    private DataSource dataSource;
    private String sql;
    private StatementFactory statementFactory;
    private Object[] loggingMessageSqlArgs;

    public TnBasicHandler(DataSource ds, StatementFactory statementFactory) {
        this.setDataSource(ds);
        this.setStatementFactory(statementFactory);
    }

    public TnBasicHandler(DataSource ds, String sql, StatementFactory statementFactory) {
        this.setDataSource(ds);
        this.setSql(sql);
        this.setStatementFactory(statementFactory);
    }

    protected void bindArgs(PreparedStatement ps, Object[] args, Class<?>[] argTypes) {
        if (args == null) {
            return;
        }
        for (int i = 0; i < args.length; ++i) {
            ValueType valueType = this.findValueType(args[i], argTypes[i]);
            try {
                valueType.bindValue(ps, i + 1, args[i]);
                continue;
            }
            catch (SQLException e) {
                this.handleSQLException(e, ps);
            }
        }
    }

    protected ValueType findValueType(Object arg, Class<?> argType) {
        ValueType valueType = TnValueTypes.getValueType(arg);
        if (valueType != null) {
            return valueType;
        }
        valueType = TnValueTypes.getValueType(argType);
        if (valueType != null) {
            return valueType;
        }
        String msg = "Unknown type\uff1aargType=" + argType + " args=" + arg;
        throw new IllegalStateException(msg);
    }

    protected Class<?>[] getArgTypes(Object[] args) {
        if (args == null) {
            return null;
        }
        Class[] argTypes = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            if (arg == null) continue;
            argTypes[i] = arg.getClass();
        }
        return argTypes;
    }

    protected void logSql(Object[] args, Class<?>[] argTypes) {
        boolean existsSqlLogRegistry;
        SqlLogHandler sqlLogHandler = this.getSqlLogHander();
        boolean existsSqlLogHandler = sqlLogHandler != null;
        Object sqlLogRegistry = TnSqlLogRegistry.findContainerSqlLogRegistry();
        boolean bl = existsSqlLogRegistry = sqlLogRegistry != null;
        if (this.isLogEnabled() || existsSqlLogHandler || existsSqlLogRegistry) {
            String completeSql = this.getCompleteSql(args);
            if (this.isLogEnabled()) {
                this.log((this.isContainsLineSeparatorInSql() ? this.getLineSeparator() : "") + completeSql);
            }
            if (existsSqlLogHandler) {
                sqlLogHandler.handle(this.getSql(), completeSql, args, argTypes);
            }
            if (existsSqlLogRegistry) {
                TnSqlLogRegistry.push(this.getSql(), completeSql, args, argTypes, sqlLogRegistry);
            }
        }
    }

    protected boolean isLogEnabled() {
        return QLog.isLogEnabled();
    }

    protected void log(String msg) {
        QLog.log(msg);
    }

    protected String getCompleteSql(Object[] args) {
        String logDateFormat = ResourceContext.getLogDateFormat();
        String logTimestampFormat = ResourceContext.getLogTimestampFormat();
        return CompleteSqlBuilder.getCompleteSql(this.sql, args, logDateFormat, logTimestampFormat);
    }

    protected SqlLogHandler getSqlLogHander() {
        if (!CallbackContext.isExistCallbackContextOnThread()) {
            return null;
        }
        return CallbackContext.getCallbackContextOnThread().getSqlLogHandler();
    }

    protected boolean isContainsLineSeparatorInSql() {
        return this.sql != null ? this.sql.contains(this.getLineSeparator()) : false;
    }

    protected String getBindVariableText(Object bindVariable) {
        String logDateFormat = ResourceContext.getLogDateFormat();
        String logTimestampFormat = ResourceContext.getLogTimestampFormat();
        return CompleteSqlBuilder.getBindVariableText(bindVariable, logDateFormat, logTimestampFormat);
    }

    protected void handleSQLException(SQLException e, Statement statement) {
        this.handleSQLException(e, statement, false);
    }

    protected void handleSQLException(SQLException e, Statement statement, boolean uniqueConstraintValid) {
        String completeSql = this.buildLoggingMessageSql();
        new SQLExceptionHandler().handleSQLException(e, statement, uniqueConstraintValid, completeSql);
    }

    protected String buildLoggingMessageSql() {
        String completeSql = null;
        if (this.sql != null && this.loggingMessageSqlArgs != null) {
            try {
                completeSql = this.getCompleteSql(this.loggingMessageSqlArgs);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return completeSql;
    }

    protected Connection getConnection() {
        if (this.dataSource == null) {
            throw new IllegalStateException("The dataSource should not be null!");
        }
        try {
            return this.dataSource.getConnection();
        }
        catch (SQLException e) {
            this.handleSQLException(e, null);
            return null;
        }
    }

    protected PreparedStatement prepareStatement(Connection conn) {
        if (this.sql == null) {
            throw new IllegalStateException("The sql should not be null!");
        }
        return this.statementFactory.createPreparedStatement(conn, this.sql);
    }

    protected int executeUpdate(PreparedStatement ps) {
        try {
            return ps.executeUpdate();
        }
        catch (SQLException e) {
            this.handleSQLException(e, ps, true);
            return 0;
        }
    }

    protected void setFetchSize(Statement statement, int fetchSize) {
        if (statement == null) {
            return;
        }
        try {
            statement.setFetchSize(fetchSize);
        }
        catch (SQLException e) {
            this.handleSQLException(e, statement);
        }
    }

    protected void setMaxRows(Statement statement, int maxRows) {
        if (statement == null) {
            return;
        }
        try {
            statement.setMaxRows(maxRows);
        }
        catch (SQLException e) {
            this.handleSQLException(e, statement);
        }
    }

    protected void close(Statement statement) {
        if (statement == null) {
            return;
        }
        try {
            statement.close();
        }
        catch (SQLException e) {
            this.handleSQLException(e, statement);
        }
    }

    protected void close(ResultSet resultSet) {
        if (resultSet == null) {
            return;
        }
        try {
            resultSet.close();
        }
        catch (SQLException e) {
            this.handleSQLException(e, null);
        }
    }

    protected void close(Connection conn) {
        if (conn == null) {
            return;
        }
        try {
            conn.close();
        }
        catch (SQLException e) {
            this.handleSQLException(e, null);
        }
    }

    protected String removeLineComment(String sql) {
        String[] lines;
        if (sql == null || sql.trim().length() == 0) {
            return sql;
        }
        StringBuilder sb = new StringBuilder();
        for (String line : lines = sql.split("\n")) {
            if (line == null || (line = line.replaceAll("\r", "")).startsWith("--")) continue;
            sb.append(line).append("\n");
        }
        String filteredSql = sb.toString();
        return filteredSql.substring(0, filteredSql.lastIndexOf("\n"));
    }

    protected String getLineSeparator() {
        return DfSystemUtil.getLineSeparator();
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        if (this.isRemoveLineCommentFromSql()) {
            sql = this.removeLineComment(sql);
        }
        this.sql = sql;
    }

    protected boolean isRemoveLineCommentFromSql() {
        return this.isCurrentDBDef(DBDef.MSAccess);
    }

    protected boolean isCurrentDBDef(DBDef currentDBDef) {
        return ResourceContext.isCurrentDBDef(currentDBDef);
    }

    public StatementFactory getStatementFactory() {
        return this.statementFactory;
    }

    public void setStatementFactory(StatementFactory statementFactory) {
        this.statementFactory = statementFactory;
    }

    public void setLoggingMessageSqlArgs(Object[] loggingMessageSqlArgs) {
        this.loggingMessageSqlArgs = loggingMessageSqlArgs;
    }
}

