/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.twowaysql.node;

import org.seasar.dbflute.exception.IfCommentNotBooleanResultException;
import org.seasar.dbflute.exception.IfCommentWrongExpressionException;
import org.seasar.dbflute.twowaysql.context.CommandContext;
import org.seasar.dbflute.twowaysql.node.ContainerNode;
import org.seasar.dbflute.twowaysql.node.ElseNode;
import org.seasar.dbflute.util.DfOgnlUtil;
import org.seasar.dbflute.util.DfStringUtil;
import org.seasar.dbflute.util.DfSystemUtil;

public class IfNode
extends ContainerNode {
    private String _expression;
    private Object _parsedExpression;
    private ElseNode _elseNode;
    private String _specifiedSql;

    public IfNode(String expression, String specifiedSql) {
        this._expression = expression;
        this._parsedExpression = DfOgnlUtil.parseExpression(expression);
        this._specifiedSql = specifiedSql;
    }

    public String getExpression() {
        return this._expression;
    }

    public ElseNode getElseNode() {
        return this._elseNode;
    }

    public void setElseNode(ElseNode elseNode) {
        this._elseNode = elseNode;
    }

    public void accept(CommandContext ctx) {
        Object result = null;
        try {
            result = DfOgnlUtil.getValue(this._parsedExpression, ctx);
        }
        catch (RuntimeException e) {
            if (!this._expression.contains("pmb.")) {
                this.throwIfCommentWrongExpressionException(this._expression, e, this._specifiedSql);
            }
            String replaced = this.replace(this._expression, "pmb.", "pmb.parameterMap.");
            Object secondParsedExpression = DfOgnlUtil.parseExpression(replaced);
            try {
                result = DfOgnlUtil.getValue(secondParsedExpression, ctx);
            }
            catch (RuntimeException ignored) {
                this.throwIfCommentWrongExpressionException(this._expression, e, this._specifiedSql);
            }
            if (result == null) {
                this.throwIfCommentWrongExpressionException(this._expression, e, this._specifiedSql);
            }
            this._parsedExpression = secondParsedExpression;
        }
        if (result != null && result instanceof Boolean) {
            if (((Boolean)result).booleanValue()) {
                super.accept(ctx);
                ctx.setEnabled(true);
            } else if (this._elseNode != null) {
                this._elseNode.accept(ctx);
                ctx.setEnabled(true);
            }
        } else {
            this.throwIfCommentNotBooleanResultException(this._expression, result, this._specifiedSql);
        }
    }

    protected void throwIfCommentWrongExpressionException(String expression, RuntimeException cause, String specifiedSql) {
        String msg = "Look! Read the message below." + this.getLineSeparator();
        msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.getLineSeparator();
        msg = msg + "The IF comment of your specified SQL was Wrong!" + this.getLineSeparator();
        msg = msg + this.getLineSeparator();
        msg = msg + "[Advice]" + this.getLineSeparator();
        msg = msg + "Please confirm the existence of your property on your arguments." + this.getLineSeparator();
        msg = msg + "And confirm the IF comment of your specified SQL." + this.getLineSeparator();
        msg = msg + "  For example, correct IF comment is as below:" + this.getLineSeparator();
        msg = msg + "    /*IF pmb.xxxId != null*/XXX_ID = .../*END*/" + this.getLineSeparator();
        msg = msg + "    /*IF pmb.isPaging()*/.../*END*/" + this.getLineSeparator();
        msg = msg + "    /*IF pmb.xxxId == null && pmb.xxxName != null*/.../*END*/" + this.getLineSeparator();
        msg = msg + "    /*IF pmb.xxxId == null || pmb.xxxName != null*/.../*END*/" + this.getLineSeparator();
        msg = msg + this.getLineSeparator();
        msg = msg + "[IF Comment Expression]" + this.getLineSeparator() + expression + this.getLineSeparator();
        msg = msg + this.getLineSeparator();
        msg = msg + "[Cause Message]" + this.getLineSeparator();
        msg = msg + cause.getClass() + ":" + this.getLineSeparator();
        msg = msg + "  --> " + cause.getMessage() + this.getLineSeparator();
        Throwable nestedCause = cause.getCause();
        if (nestedCause != null) {
            msg = msg + nestedCause.getClass() + ":" + this.getLineSeparator();
            msg = msg + "  --> " + nestedCause.getMessage() + this.getLineSeparator();
        }
        msg = msg + this.getLineSeparator();
        msg = msg + "[Specified SQL]" + this.getLineSeparator() + specifiedSql + this.getLineSeparator();
        msg = msg + "* * * * * * * * * */";
        throw new IfCommentWrongExpressionException(msg, cause);
    }

    protected void throwIfCommentNotBooleanResultException(String expression, Object result, String specifiedSql) {
        String msg = "Look! Read the message below." + this.getLineSeparator();
        msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.getLineSeparator();
        msg = msg + "The boolean expression on IF comment of your specified SQL was Wrong!" + this.getLineSeparator();
        msg = msg + this.getLineSeparator();
        msg = msg + "[Advice]" + this.getLineSeparator();
        msg = msg + "Please confirm the grammar of your IF comment. Does it really express boolean?" + this.getLineSeparator();
        msg = msg + "And confirm the existence of your property on your arguments if you use parameterMap." + this.getLineSeparator();
        msg = msg + this.getLineSeparator();
        msg = msg + "[IF Comment Expression]" + this.getLineSeparator() + expression + this.getLineSeparator();
        msg = msg + this.getLineSeparator();
        msg = msg + "[IF Comment Result Value]" + this.getLineSeparator() + result + this.getLineSeparator();
        msg = msg + this.getLineSeparator();
        msg = msg + "[Specified SQL]" + this.getLineSeparator() + specifiedSql + this.getLineSeparator();
        msg = msg + "* * * * * * * * * */";
        throw new IfCommentNotBooleanResultException(msg);
    }

    protected String replace(String text, String fromText, String toText) {
        return DfStringUtil.replace(text, fromText, toText);
    }

    protected String getLineSeparator() {
        return DfSystemUtil.getLineSeparator();
    }
}

